/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.factory;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.Detachable;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.builder.XOPAwareStAXOMBuilder;
import org.apache.axiom.om.impl.common.factory.DOMXMLStreamReader;
import org.apache.axiom.om.impl.common.factory.DetachableInputStream;
import org.apache.axiom.om.impl.common.factory.DetachableReader;
import org.apache.axiom.om.impl.common.factory.SAXOMBuilder;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.MTOMStAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.OMMetaFactoryEx;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.intf.AxiomSOAPMessage;
import org.apache.axiom.util.stax.XMLEventUtils;
import org.apache.axiom.util.stax.XMLFragmentStreamReader;
import org.apache.axiom.util.stax.xop.MimePartProvider;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class AbstractOMMetaFactory
implements OMMetaFactoryEx {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SourceInfo createXMLStreamReader(StAXParserConfiguration configuration, InputSource is, boolean makeDetachable) {
        try {
            void var4_23;
            InputStream closeable;
            XMLStreamReader reader;
            if (is.getByteStream() != null) {
                String systemId = is.getSystemId();
                String encoding = is.getEncoding();
                InputStream in = is.getByteStream();
                if (makeDetachable) {
                    DetachableInputStream detachableInputStream = new DetachableInputStream(in, false);
                    in = detachableInputStream;
                    DetachableInputStream detachableInputStream2 = detachableInputStream;
                } else {
                    Object var4_15 = null;
                }
                if (systemId != null) {
                    if (encoding != null) throw new UnsupportedOperationException();
                    reader = StAXUtils.createXMLStreamReader(configuration, systemId, in);
                } else {
                    reader = encoding == null ? StAXUtils.createXMLStreamReader(configuration, in) : StAXUtils.createXMLStreamReader(configuration, in, encoding);
                }
                closeable = null;
                return new SourceInfo(reader, (Detachable)var4_23, closeable);
            } else if (is.getCharacterStream() != null) {
                Reader in = is.getCharacterStream();
                if (makeDetachable) {
                    DetachableReader detachableReader = new DetachableReader(in);
                    in = detachableReader;
                    DetachableReader detachableReader2 = detachableReader;
                } else {
                    Object var4_18 = null;
                }
                reader = StAXUtils.createXMLStreamReader(configuration, in);
                closeable = null;
                return new SourceInfo(reader, (Detachable)var4_23, closeable);
            } else {
                String systemId = is.getSystemId();
                InputStream in = new URL(systemId).openConnection().getInputStream();
                if (makeDetachable) {
                    DetachableInputStream detachableInputStream = new DetachableInputStream(in, true);
                    in = detachableInputStream;
                    DetachableInputStream detachableInputStream3 = detachableInputStream;
                } else {
                    Object var4_21 = null;
                }
                reader = StAXUtils.createXMLStreamReader(configuration, systemId, in);
                closeable = in;
            }
            return new SourceInfo(reader, (Detachable)var4_23, closeable);
        }
        catch (XMLStreamException ex) {
            throw new OMException(ex);
        }
        catch (IOException ex) {
            throw new OMException(ex);
        }
    }

    private static XMLStreamReader getXMLStreamReader(XMLStreamReader originalReader) {
        int eventType = originalReader.getEventType();
        switch (eventType) {
            case 7: {
                return originalReader;
            }
            case 1: {
                return new XMLFragmentStreamReader(originalReader);
            }
        }
        throw new OMException("The supplied XMLStreamReader is in an unexpected state (" + XMLEventUtils.getEventTypeString(eventType) + ")");
    }

    public OMXMLParserWrapper createStAXOMBuilder(OMFactory omFactory, XMLStreamReader parser) {
        return new StAXOMBuilder(omFactory, AbstractOMMetaFactory.getXMLStreamReader(parser), null, null);
    }

    public OMXMLParserWrapper createOMBuilder(OMFactory omFactory, StAXParserConfiguration configuration, InputSource is) {
        SourceInfo sourceInfo = AbstractOMMetaFactory.createXMLStreamReader(configuration, is, true);
        StAXOMBuilder builder = new StAXOMBuilder(omFactory, sourceInfo.getReader(), sourceInfo.getDetachable(), sourceInfo.getCloseable());
        builder.setAutoClose(true);
        return builder;
    }

    private static InputSource toInputSource(StreamSource source) {
        InputSource is = new InputSource();
        is.setByteStream(source.getInputStream());
        is.setCharacterStream(source.getReader());
        is.setPublicId(source.getPublicId());
        is.setSystemId(source.getSystemId());
        return is;
    }

    public OMXMLParserWrapper createOMBuilder(OMFactory omFactory, Source source) {
        if (source instanceof SAXSource) {
            return this.createOMBuilder(omFactory, (SAXSource)source, true);
        }
        if (source instanceof DOMSource) {
            return this.createOMBuilder(omFactory, ((DOMSource)source).getNode(), true);
        }
        if (source instanceof StreamSource) {
            return this.createOMBuilder(omFactory, StAXParserConfiguration.DEFAULT, AbstractOMMetaFactory.toInputSource((StreamSource)source));
        }
        try {
            return new StAXOMBuilder(omFactory, StAXUtils.getXMLInputFactory().createXMLStreamReader(source), null, null);
        }
        catch (XMLStreamException ex) {
            throw new OMException(ex);
        }
    }

    public OMXMLParserWrapper createOMBuilder(OMFactory omFactory, Node node, boolean expandEntityReferences) {
        return new StAXOMBuilder(omFactory, (XMLStreamReader)new DOMXMLStreamReader(node, expandEntityReferences), null, null);
    }

    public OMXMLParserWrapper createOMBuilder(OMFactory omFactory, SAXSource source, boolean expandEntityReferences) {
        return new SAXOMBuilder(omFactory, source, expandEntityReferences);
    }

    public OMXMLParserWrapper createOMBuilder(StAXParserConfiguration configuration, OMFactory omFactory, InputSource rootPart, MimePartProvider mimePartProvider) {
        SourceInfo sourceInfo = AbstractOMMetaFactory.createXMLStreamReader(configuration, rootPart, false);
        XOPAwareStAXOMBuilder builder = new XOPAwareStAXOMBuilder(omFactory, sourceInfo.getReader(), mimePartProvider, mimePartProvider instanceof Detachable ? (Detachable)((Object)mimePartProvider) : null, sourceInfo.getCloseable());
        builder.setAutoClose(true);
        return builder;
    }

    public SOAPModelBuilder createStAXSOAPModelBuilder(XMLStreamReader parser) {
        return new StAXSOAPModelBuilder(this, AbstractOMMetaFactory.getXMLStreamReader(parser), null, null);
    }

    public SOAPModelBuilder createSOAPModelBuilder(StAXParserConfiguration configuration, InputSource is) {
        SourceInfo sourceInfo = AbstractOMMetaFactory.createXMLStreamReader(configuration, is, true);
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(this, sourceInfo.getReader(), sourceInfo.getDetachable(), sourceInfo.getCloseable());
        builder.setAutoClose(true);
        return builder;
    }

    public SOAPModelBuilder createSOAPModelBuilder(Source source) {
        if (source instanceof SAXSource) {
            throw new UnsupportedOperationException();
        }
        if (source instanceof DOMSource) {
            return new StAXSOAPModelBuilder(this, (XMLStreamReader)new DOMXMLStreamReader(((DOMSource)source).getNode(), true), null, null);
        }
        if (source instanceof StreamSource) {
            return this.createSOAPModelBuilder(StAXParserConfiguration.SOAP, AbstractOMMetaFactory.toInputSource((StreamSource)source));
        }
        try {
            return new StAXSOAPModelBuilder(this, StAXUtils.getXMLInputFactory().createXMLStreamReader(source), null, null);
        }
        catch (XMLStreamException ex) {
            throw new OMException(ex);
        }
    }

    public SOAPModelBuilder createSOAPModelBuilder(StAXParserConfiguration configuration, SOAPFactory soapFactory, InputSource rootPart, MimePartProvider mimePartProvider) {
        SourceInfo sourceInfo = AbstractOMMetaFactory.createXMLStreamReader(configuration, rootPart, false);
        MTOMStAXSOAPModelBuilder builder = new MTOMStAXSOAPModelBuilder(soapFactory, sourceInfo.getReader(), mimePartProvider, mimePartProvider instanceof Detachable ? (Detachable)((Object)mimePartProvider) : null, sourceInfo.getCloseable());
        builder.setAutoClose(true);
        return builder;
    }

    public abstract AxiomSOAPMessage createSOAPMessage();

    public final SOAPMessage createSOAPMessage(OMXMLParserWrapper builder) {
        AxiomSOAPMessage message = this.createSOAPMessage();
        message.coreSetBuilder(builder);
        return message;
    }

    private static final class SourceInfo {
        private final XMLStreamReader reader;
        private final Detachable detachable;
        private final Closeable closeable;

        SourceInfo(XMLStreamReader reader, Detachable detachable, Closeable closeable) {
            this.reader = reader;
            this.detachable = detachable;
            this.closeable = closeable;
        }

        XMLStreamReader getReader() {
            return this.reader;
        }

        Detachable getDetachable() {
            return this.detachable;
        }

        Closeable getCloseable() {
            return this.closeable;
        }
    }
}

