/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.parser.stax;

import java.util.ArrayList;
import java.util.List;
import javax.activation.MimeType;
import org.apache.abdera.model.Collection;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Service;
import org.apache.abdera.model.Workspace;
import org.apache.abdera.parser.stax.FOMExtensibleElement;
import org.apache.abdera.util.Constants;
import org.apache.axiom.fom.AbderaService;
import org.apache.axiom.fom.AbderaWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOMService
extends FOMExtensibleElement
implements AbderaService {
    public List<Workspace> getWorkspaces() {
        List<Workspace> list = this._getChildrenAsSet(Constants.WORKSPACE);
        if (list == null || list.size() == 0) {
            list = this._getChildrenAsSet(Constants.PRE_RFC_WORKSPACE);
        }
        return list;
    }

    public Workspace getWorkspace(String title) {
        List<Workspace> workspaces = this.getWorkspaces();
        Workspace workspace = null;
        for (Workspace w : workspaces) {
            if (!w.getTitle().equals(title)) continue;
            workspace = w;
            break;
        }
        return workspace;
    }

    public Service addWorkspace(Workspace workspace) {
        this._addChild((AbderaWorkspace)workspace);
        return this;
    }

    public Workspace addWorkspace(String title) {
        Workspace workspace = this.getFactory().newWorkspace((Element)this);
        workspace.setTitle(title);
        return workspace;
    }

    public Collection getCollection(String workspace, String collection) {
        Collection col = null;
        Workspace w = this.getWorkspace(workspace);
        if (w != null) {
            col = w.getCollection(collection);
        }
        return col;
    }

    public Collection getCollectionThatAccepts(MimeType ... types) {
        Collection collection = null;
        for (Workspace workspace : this.getWorkspaces()) {
            collection = workspace.getCollectionThatAccepts(types);
            if (collection != null) break;
        }
        return collection;
    }

    public Collection getCollectionThatAccepts(String ... types) {
        Collection collection = null;
        for (Workspace workspace : this.getWorkspaces()) {
            collection = workspace.getCollectionThatAccepts(types);
            if (collection != null) break;
        }
        return collection;
    }

    public List<Collection> getCollectionsThatAccept(MimeType ... types) {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        for (Workspace workspace : this.getWorkspaces()) {
            List colls = workspace.getCollectionsThatAccept(types);
            collections.addAll(colls);
        }
        return collections;
    }

    public List<Collection> getCollectionsThatAccept(String ... types) {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        for (Workspace workspace : this.getWorkspaces()) {
            List colls = workspace.getCollectionsThatAccept(types);
            collections.addAll(colls);
        }
        return collections;
    }
}

