
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 * Normalize document with check-character-normalization set to true, check that
 * non-normalized characters are signaled.
* @author Curt Arnold
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-normalizeDocument">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-normalizeDocument</a>
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-check-character-normalization">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-check-character-normalization</a>
* @see <a href="http://www.w3.org/TR/2003/WD-charmod-20030822/">http://www.w3.org/TR/2003/WD-charmod-20030822/</a>
*/
public final class checkcharacternormalization02 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public checkcharacternormalization02(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "barfoo", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element docElem;
      DOMConfiguration domConfig;
      org.w3c.domts.DOMErrorMonitor errorMonitor = new org.w3c.domts.DOMErrorMonitor();
      
      NodeList pList;
      Element pElem;
      Text text;
      String textValue;
      Node retval;
      boolean canSet;
      java.util.List errors = new java.util.ArrayList();
      
      DOMError error;
      int severity;
      DOMLocator locator;
      Node relatedNode;
      int errorCount = 0;
      String errorType;
      doc = (Document) load("barfoo", true);
      domConfig = doc.getDomConfig();
      canSet = domConfig.canSetParameter("check-character-normalization", Boolean.TRUE);
      
      if (canSet) {
          domConfig.setParameter("check-character-normalization", Boolean.TRUE);
      domConfig.setParameter("error-handler", ((Object) /*DOMErrorMonitor */errorMonitor));
      pList = doc.getElementsByTagName("p");
      pElem = (Element) pList.item(0);
      text = doc.createTextNode("suçon");
      retval = pElem.appendChild(text);
      doc.normalizeDocument();
      errors = errorMonitor.getAllErrors();
for (int indexN100AA = 0; indexN100AA < errors.size(); indexN100AA++) {
          error = (DOMError) errors.get(indexN100AA);
    severity = (int) error.getSeverity();
      
      if (equals(2, severity)) {
          errorCount += 1;
      errorType = error.getType();
      assertEquals("errorType", "check-character-normalization-failure", errorType);
      locator = error.getLocation();
      relatedNode = locator.getRelatedNode();
      assertSame("relatedNodeSame", text, relatedNode);
}
      }
      assertEquals("oneError", 1, errorCount);
      }
    }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/checkcharacternormalization02";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(checkcharacternormalization02.class, args);
   }
}

