/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.builder;

import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.soap.SOAPProcessingException;

public class StAXSOAPModelBuilder
implements SOAPModelBuilder {
    private final SOAPModelBuilder target;

    protected StAXSOAPModelBuilder(SOAPModelBuilder target) {
        this.target = target;
    }

    public StAXSOAPModelBuilder(XMLStreamReader parser, SOAPFactory factory, String soapVersion) {
        this(OMXMLBuilderFactory.createStAXSOAPModelBuilder(factory.getMetaFactory(), parser));
        this.validateSOAPVersion(factory, soapVersion);
    }

    public StAXSOAPModelBuilder(XMLStreamReader parser) {
        this(OMXMLBuilderFactory.createStAXSOAPModelBuilder(OMAbstractFactory.getMetaFactory(), parser));
    }

    public StAXSOAPModelBuilder(XMLStreamReader parser, String soapVersion) {
        this(parser);
        this.validateSOAPVersion(null, soapVersion);
    }

    protected final void validateSOAPVersion(SOAPFactory factory, String soapVersion) {
        SOAPFactory actualFactory = (SOAPFactory)this.getSOAPMessage().getOMFactory();
        if (factory != null && actualFactory != factory || soapVersion != null && !actualFactory.getSOAPVersion().getEnvelopeURI().equals(soapVersion)) {
            throw new SOAPProcessingException("SOAP version mismatch");
        }
    }

    @Override
    public SOAPEnvelope getSOAPEnvelope() {
        return this.target.getSOAPEnvelope();
    }

    @Override
    public SOAPMessage getSOAPMessage() {
        return this.target.getSOAPMessage();
    }

    public SOAPMessage getSoapMessage() {
        return this.target.getSOAPMessage();
    }

    @Override
    public boolean isCompleted() {
        return this.target.isCompleted();
    }

    @Override
    public OMDocument getDocument() {
        return this.target.getDocument();
    }

    @Override
    public OMElement getDocumentElement() {
        return this.target.getDocumentElement();
    }

    @Override
    public OMElement getDocumentElement(boolean discardDocument) {
        return this.target.getDocumentElement(discardDocument);
    }

    @Override
    public void close() {
        this.target.close();
    }

    @Override
    public void detach() {
        this.target.detach();
    }
}

