/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.factory;

import javax.xml.namespace.QName;
import org.apache.axiom.core.NodeFactory;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.common.factory.OMFactoryImpl;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.Sequence;
import org.apache.axiom.om.impl.mixin.AxiomContainerSupport;
import org.apache.axiom.om.impl.mixin.AxiomElementSupport;
import org.apache.axiom.om.impl.mixin.AxiomSourcedElementSupport;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.axiom.soap.impl.intf.AxiomSOAPElement;
import org.apache.axiom.soap.impl.intf.AxiomSOAPHeaderBlock;
import org.apache.axiom.soap.impl.intf.AxiomSOAPMessage;
import org.apache.axiom.soap.impl.intf.SOAPHelper;
import org.apache.axiom.soap.impl.mixin.AxiomSOAPMessageSupport;

public abstract class SOAPFactoryImpl
extends OMFactoryImpl
implements SOAPFactory {
    private static final Sequence envelopeSequence = new Sequence(SOAPHeader.class, SOAPBody.class);

    public SOAPFactoryImpl(OMMetaFactory metaFactory, NodeFactory nodeFactory) {
        super(metaFactory, nodeFactory);
    }

    public abstract SOAPHelper getSOAPHelper();

    @Override
    public final String getSoapVersionURI() {
        return this.getSOAPHelper().getEnvelopeURI();
    }

    @Override
    public final SOAPVersion getSOAPVersion() {
        return this.getSOAPHelper().getVersion();
    }

    @Override
    public final OMNamespace getNamespace() {
        return this.getSOAPHelper().getNamespace();
    }

    protected final <T extends AxiomSOAPElement> T createSOAPElement(Class<T> type, OMElement parent, QName qname) {
        return this.createSOAPElement(type, parent, qname, null, -1);
    }

    protected final <T extends AxiomSOAPElement> T createSOAPElement(Class<T> type, OMElement parent, QName qname, Sequence sequence, int pos) {
        AxiomSOAPElement element = (AxiomSOAPElement)this.createNode(type);
        if (parent != null) {
            if (sequence != null) {
                AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$insertChild((AxiomElement)parent, sequence, pos, element, false);
            } else {
                AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$addChild((AxiomElement)parent, element);
            }
        }
        if (qname.getNamespaceURI().length() == 0) {
            AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$initName(element, qname.getLocalPart(), null, true);
        } else if (parent != null) {
            AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$initName(element, qname.getLocalPart(), parent.getNamespace(), false);
        } else {
            AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$initName(element, qname.getLocalPart(), this.getNamespace(), true);
        }
        return (T)element;
    }

    @Override
    public final SOAPMessage createSOAPMessage() {
        AxiomSOAPMessage message = this.createNode(AxiomSOAPMessage.class);
        AxiomSOAPMessageSupport.ajc$interMethodDispatch1$org_apache_axiom_soap_impl_mixin_AxiomSOAPMessageSupport$org_apache_axiom_soap_impl_intf_AxiomSOAPMessage$initSOAPFactory(message, this);
        return message;
    }

    @Override
    public final SOAPEnvelope createSOAPEnvelope() {
        return this.createSOAPEnvelope(this.getNamespace());
    }

    @Override
    public final SOAPEnvelope createSOAPEnvelope(OMNamespace ns) {
        return this.createAxiomElement(this.getSOAPHelper().getEnvelopeClass(), null, "Envelope", ns);
    }

    @Override
    public final SOAPHeader createSOAPHeader(SOAPEnvelope parent) {
        SOAPHelper helper = this.getSOAPHelper();
        return this.createSOAPElement(helper.getHeaderClass(), parent, helper.getHeaderQName(), envelopeSequence, 0);
    }

    @Override
    public final SOAPHeader createSOAPHeader() {
        return this.createSOAPHeader(null);
    }

    @Override
    public final SOAPHeaderBlock createSOAPHeaderBlock(String localName, OMNamespace ns, SOAPHeader parent) {
        return this.createAxiomElement(this.getSOAPHelper().getHeaderBlockClass(), parent, localName, ns);
    }

    @Override
    public final SOAPHeaderBlock createSOAPHeaderBlock(String localName, OMNamespace ns) {
        return this.createAxiomElement(this.getSOAPHelper().getHeaderBlockClass(), null, localName, ns);
    }

    @Override
    public final SOAPHeaderBlock createSOAPHeaderBlock(OMDataSource source) {
        AxiomSOAPHeaderBlock element = this.createNode(this.getSOAPHelper().getHeaderBlockClass());
        AxiomSourcedElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomSourcedElementSupport$org_apache_axiom_om_impl_intf_AxiomSourcedElement$init(element, source);
        return element;
    }

    @Override
    public final SOAPHeaderBlock createSOAPHeaderBlock(String localName, OMNamespace ns, OMDataSource ds) {
        AxiomSOAPHeaderBlock element = this.createNode(this.getSOAPHelper().getHeaderBlockClass());
        AxiomSourcedElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomSourcedElementSupport$org_apache_axiom_om_impl_intf_AxiomSourcedElement$init(element, localName, ns, ds);
        return element;
    }

    @Override
    public final SOAPHeaderBlock createSOAPHeaderBlock(OMElement element) {
        return this.importElement(element, this.getSOAPHelper().getHeaderBlockClass());
    }

    @Override
    public final SOAPBody createSOAPBody(SOAPEnvelope parent) {
        SOAPHelper helper = this.getSOAPHelper();
        return this.createSOAPElement(helper.getBodyClass(), parent, helper.getBodyQName(), envelopeSequence, 1);
    }

    @Override
    public final SOAPBody createSOAPBody() {
        return this.createSOAPBody(null);
    }

    @Override
    public final SOAPFault createSOAPFault(SOAPBody parent) {
        SOAPHelper helper = this.getSOAPHelper();
        return this.createSOAPElement(helper.getFaultClass(), parent, helper.getFaultQName());
    }

    @Override
    public final SOAPFault createSOAPFault() {
        return this.createSOAPFault(null);
    }

    @Override
    public final SOAPFault createSOAPFault(SOAPBody parent, Exception e) {
        SOAPFault fault = this.createSOAPFault(parent);
        fault.setException(e);
        return fault;
    }

    @Override
    public final SOAPFaultCode createSOAPFaultCode(SOAPFault parent) {
        SOAPHelper helper = this.getSOAPHelper();
        return this.createSOAPElement(helper.getFaultCodeClass(), parent, helper.getFaultCodeQName());
    }

    @Override
    public final SOAPFaultCode createSOAPFaultCode() {
        return this.createSOAPFaultCode(null);
    }

    @Override
    public final SOAPFaultReason createSOAPFaultReason(SOAPFault parent) {
        SOAPHelper helper = this.getSOAPHelper();
        return this.createSOAPElement(helper.getFaultReasonClass(), parent, helper.getFaultReasonQName());
    }

    @Override
    public final SOAPFaultReason createSOAPFaultReason() {
        return this.createSOAPFaultReason(null);
    }

    @Override
    public final SOAPFaultRole createSOAPFaultRole(SOAPFault parent) {
        SOAPHelper helper = this.getSOAPHelper();
        return this.createSOAPElement(helper.getFaultRoleClass(), parent, helper.getFaultRoleQName());
    }

    @Override
    public final SOAPFaultRole createSOAPFaultRole() {
        return this.createSOAPFaultRole(null);
    }

    @Override
    public final SOAPFaultDetail createSOAPFaultDetail(SOAPFault parent) {
        SOAPHelper helper = this.getSOAPHelper();
        return this.createSOAPElement(helper.getFaultDetailClass(), parent, helper.getFaultDetailQName());
    }

    @Override
    public final SOAPFaultDetail createSOAPFaultDetail() {
        return this.createSOAPFaultDetail(null);
    }

    @Override
    public final SOAPMessage createDefaultSOAPMessage() {
        SOAPMessage message = this.createSOAPMessage();
        SOAPEnvelope env = this.createSOAPEnvelope();
        message.addChild(env);
        this.createSOAPBody(env);
        return message;
    }

    @Override
    public final SOAPEnvelope getDefaultEnvelope() {
        SOAPEnvelope env = this.createSOAPEnvelope();
        this.createSOAPHeader(env);
        this.createSOAPBody(env);
        return env;
    }
}

