/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.util.Iterator;
import org.apache.axiom.attachments.IncomingAttachmentInputStream;
import org.apache.axiom.mime.Header;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.mime.Part;
import org.apache.axiom.om.OMException;

public final class IncomingAttachmentStreams {
    private final Part rootPart;
    private final Iterator<Part> partIterator;
    private boolean readyToGetNextStream = true;

    IncomingAttachmentStreams(MultipartBody message) {
        this.rootPart = message.getRootPart();
        this.partIterator = message.iterator();
    }

    public final boolean isReadyToGetNextStream() {
        return this.readyToGetNextStream;
    }

    void setReadyToGetNextStream(boolean ready) {
        this.readyToGetNextStream = ready;
    }

    public IncomingAttachmentInputStream getNextStream() throws OMException {
        if (!this.readyToGetNextStream) {
            throw new IllegalStateException("nextStreamNotReady");
        }
        Part part = null;
        while (part == null && this.partIterator.hasNext()) {
            part = this.partIterator.next();
            if (part != this.rootPart) continue;
            part = null;
        }
        if (part != null) {
            IncomingAttachmentInputStream stream = new IncomingAttachmentInputStream(part.getInputStream(false), this);
            for (Header header : part.getHeaders()) {
                String name = header.getName();
                String value = header.getValue();
                if ("content-id".equals(name) || "content-type".equals(name) || "content-location".equals(name)) {
                    value = value.trim();
                }
                stream.addHeader(name, value);
            }
            this.readyToGetNextStream = false;
            return stream;
        }
        return null;
    }
}

