/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.DeferredParsingException;
import org.apache.axiom.core.impl.builder.BuilderImpl;
import org.apache.axiom.core.impl.builder.PlainXMLModel;
import org.apache.axiom.core.stream.FilteredXmlInput;
import org.apache.axiom.core.stream.NamespaceRepairingFilter;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlInput;
import org.apache.axiom.core.stream.stax.pull.input.StAXPullInput;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamedInformationItem;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMXMLStreamReaderConfiguration;
import org.apache.axiom.om.QNameAwareOMDataSource;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.DeferredNamespace;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.common.util.OMDataSourceUtil;
import org.apache.axiom.om.impl.intf.AxiomSourcedElement;
import org.apache.axiom.om.impl.llom.AxiomElementImpl;
import org.apache.axiom.om.impl.stream.ds.PushOMDataSourceInput;
import org.apache.axiom.om.impl.stream.stax.pull.AxiomXMLStreamReaderHelperFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxiomSourcedElementImpl
extends AxiomElementImpl
implements AxiomSourcedElement,
OMSourcedElement,
OMElement,
OMNamedInformationItem,
OMNode,
OMContainer {
    private OMDataSource dataSource;
    private OMNamespace definedNamespace;
    private boolean definedNamespaceSet;
    private boolean isExpanded;
    private static final Log log;
    private static final Log forceExpandLog;

    public AxiomSourcedElementImpl() {
        this.init$AxiomSourcedElementMixin();
    }

    static {
        AxiomSourcedElementImpl.clinit$AxiomSourcedElementMixin();
    }

    private void init$AxiomSourcedElementMixin() {
        this.isExpanded = true;
    }

    private static void clinit$AxiomSourcedElementMixin() {
        log = LogFactory.getLog(AxiomSourcedElementImpl.class);
        forceExpandLog = LogFactory.getLog((String)(AxiomSourcedElementImpl.class.getName() + ".forceExpand"));
    }

    private static OMNamespace getOMNamespace(QName qName) {
        return qName.getNamespaceURI().length() == 0 ? null : new OMNamespaceImpl(qName.getNamespaceURI(), qName.getPrefix());
    }

    @Override
    public Class<? extends CoreNode> coreGetNodeClass() {
        return AxiomSourcedElement.class;
    }

    @Override
    public void init(OMDataSource source) {
        this.dataSource = source;
        this.isExpanded = false;
    }

    @Override
    public void init(String localName, OMNamespace ns, OMDataSource source) {
        if (source == null) {
            throw new IllegalArgumentException("OMDataSource can't be null");
        }
        this.internalSetLocalName(localName);
        this.dataSource = source;
        this.isExpanded = false;
        if (ns != null && ns.getNamespaceURI().length() == 0) {
            ns = null;
        }
        if (ns == null || ns.getPrefix() != null) {
            this.definedNamespace = ns;
        } else {
            String uri = ns.getNamespaceURI();
            this.definedNamespace = new DeferredNamespace(this, uri);
        }
        this.definedNamespaceSet = true;
    }

    @Override
    public void init(QName qName, OMDataSource source) {
        if (source == null) {
            throw new IllegalArgumentException("OMDataSource can't be null");
        }
        this.internalSetLocalName(qName.getLocalPart());
        this.dataSource = source;
        this.isExpanded = false;
        this.definedNamespace = AxiomSourcedElementImpl.getOMNamespace(qName);
        this.definedNamespaceSet = true;
    }

    @Override
    public boolean internalIsDefinedNamespaceSet() {
        return this.definedNamespaceSet;
    }

    @Override
    public OMNamespace internalGetDefinedNamespace() {
        return this.definedNamespace;
    }

    private String getPrintableName() {
        if (this.isExpanded || this.definedNamespaceSet && this.internalGetLocalName() != null) {
            String uri = null;
            if (this.getNamespace() != null) {
                uri = this.getNamespace().getNamespaceURI();
            }
            if (uri == null || uri.length() == 0) {
                return this.getLocalName();
            }
            return "{" + uri + '}' + this.getLocalName();
        }
        return "<unknown>";
    }

    @Override
    public void forceExpand() {
        if (!this.isExpanded && this.dataSource != null) {
            BuilderImpl builder;
            if (log.isDebugEnabled()) {
                log.debug((Object)("forceExpand: expanding element " + this.getPrintableName()));
                if (forceExpandLog.isDebugEnabled()) {
                    Exception e = new Exception("Debug Stack Trace");
                    forceExpandLog.debug((Object)"forceExpand stack", (Throwable)e);
                }
            }
            if (OMDataSourceUtil.isPushDataSource(this.dataSource)) {
                builder = new BuilderImpl(new PushOMDataSourceInput(this, this.dataSource), this.coreGetNodeFactory().getFactory2(), PlainXMLModel.INSTANCE, this);
            } else {
                XMLStreamReader readerFromDS;
                try {
                    readerFromDS = this.dataSource.getReader();
                }
                catch (XMLStreamException ex) {
                    throw new OMException("Error obtaining parser from data source for element " + this.getPrintableName(), (Throwable)ex);
                }
                builder = new BuilderImpl(new FilteredXmlInput(new StAXPullInput(readerFromDS, AxiomXMLStreamReaderHelperFactory.INSTANCE), NamespaceRepairingFilter.DEFAULT), this.coreGetNodeFactory().getFactory2(), PlainXMLModel.INSTANCE, this);
            }
            this.isExpanded = true;
            this.coreSetState(1);
            try {
                do {
                    builder.next();
                } while (this.getState() == 1);
            }
            catch (DeferredParsingException ex) {
                throw AxiomExceptionTranslator.translate(ex);
            }
        }
    }

    @Override
    public void validateName(String staxPrefix, String staxLocalName, String staxNamespaceURI) {
        if (this.internalGetLocalName() == null) {
            this.internalSetLocalName(staxLocalName);
        } else if (!staxLocalName.equals(this.internalGetLocalName())) {
            throw new OMException("Element name from data source is " + staxLocalName + ", not the expected " + this.internalGetLocalName());
        }
        if (this.definedNamespaceSet) {
            String namespaceURI;
            if (staxNamespaceURI == null) {
                staxNamespaceURI = "";
            }
            String string = namespaceURI = this.definedNamespace == null ? "" : this.definedNamespace.getNamespaceURI();
            if (!staxNamespaceURI.equals(namespaceURI)) {
                throw new OMException("Element namespace from data source is " + staxNamespaceURI + ", not the expected " + namespaceURI);
            }
            if (!(this.definedNamespace instanceof DeferredNamespace)) {
                String prefix;
                if (staxPrefix == null) {
                    staxPrefix = "";
                }
                String string2 = prefix = this.definedNamespace == null ? "" : this.definedNamespace.getPrefix();
                if (!staxPrefix.equals(prefix)) {
                    throw new OMException("Element prefix from data source is '" + staxPrefix + "', not the expected '" + prefix + "'");
                }
            }
        }
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public XMLStreamReader getXMLStreamReader(boolean cache, OMXMLStreamReaderConfiguration configuration) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting XMLStreamReader for " + this.getPrintableName() + " with cache=" + cache));
        }
        if (this.isExpanded) {
            return this.defaultGetXMLStreamReader(cache, configuration);
        }
        if (cache && OMDataSourceUtil.isDestructiveRead(this.dataSource) || OMDataSourceUtil.isPushDataSource(this.dataSource)) {
            this.forceExpand();
            return this.defaultGetXMLStreamReader(true, configuration);
        }
        try {
            return this.dataSource.getReader();
        }
        catch (XMLStreamException ex) {
            throw new OMException("Error obtaining parser from data source for element " + this.getPrintableName(), (Throwable)ex);
        }
    }

    @Override
    public final void updateLocalName() {
        if (this.dataSource instanceof QNameAwareOMDataSource) {
            this.internalSetLocalName(((QNameAwareOMDataSource)this.dataSource).getLocalName());
        }
        if (this.internalGetLocalName() == null) {
            this.forceExpand();
        }
    }

    @Override
    public OMNamespace getNamespace() throws OMException {
        String namespaceURI;
        if (this.isExpanded()) {
            return this.defaultGetNamespace();
        }
        if (this.definedNamespaceSet) {
            return this.definedNamespace;
        }
        if (this.dataSource instanceof QNameAwareOMDataSource && (namespaceURI = ((QNameAwareOMDataSource)this.dataSource).getNamespaceURI()) != null) {
            if (namespaceURI.length() == 0) {
                this.definedNamespaceSet = true;
            } else {
                String prefix = ((QNameAwareOMDataSource)this.dataSource).getPrefix();
                this.definedNamespace = prefix == null ? new DeferredNamespace(this, namespaceURI) : new OMNamespaceImpl(namespaceURI, prefix);
                this.definedNamespaceSet = true;
            }
        }
        if (this.definedNamespaceSet) {
            return this.definedNamespace;
        }
        this.forceExpand();
        return this.defaultGetNamespace();
    }

    @Override
    public QName getQName() {
        if (this.isExpanded()) {
            return this.defaultGetQName();
        }
        if (this.getNamespace() != null) {
            return new QName(this.getNamespace().getNamespaceURI(), this.getLocalName());
        }
        return new QName(this.getLocalName());
    }

    @Override
    public <T> void initSource(ClonePolicy<T> policy, T options, CoreElement other) {
        AxiomSourcedElement o = (AxiomSourcedElement)other;
        OMDataSource ds = o.getDataSource();
        if (!(options instanceof OMCloneOptions) || !((OMCloneOptions)options).isCopyOMDataSources() || ds == null || o.isExpanded() || !(ds instanceof OMDataSourceExt)) {
            return;
        }
        OMDataSourceExt sourceDS = (OMDataSourceExt)ds;
        if (sourceDS.isDestructiveRead() || sourceDS.isDestructiveWrite()) {
            return;
        }
        OMDataSourceExt targetDS = ((OMDataSourceExt)ds).copy();
        if (targetDS == null) {
            return;
        }
        this.init((OMDataSource)targetDS);
        this.definedNamespaceSet = o.internalIsDefinedNamespaceSet();
        OMNamespace otherDefinedNamespace = o.internalGetDefinedNamespace();
        this.definedNamespace = otherDefinedNamespace instanceof DeferredNamespace ? new DeferredNamespace(this, otherDefinedNamespace.getNamespaceURI()) : otherDefinedNamespace;
    }

    @Override
    public final XmlInput getXmlInput(boolean cache, boolean incremental) throws StreamException {
        boolean pull;
        if (this.isExpanded()) {
            return null;
        }
        if (OMDataSourceUtil.isPullDataSource(this.dataSource)) {
            pull = true;
        } else if (OMDataSourceUtil.isPushDataSource(this.dataSource)) {
            if (incremental) {
                return null;
            }
            pull = false;
        } else {
            pull = incremental;
        }
        if (cache && (pull && OMDataSourceUtil.isDestructiveRead(this.dataSource) || !pull && OMDataSourceUtil.isDestructiveWrite(this.dataSource))) {
            return null;
        }
        if (pull) {
            try {
                return new StAXPullInput(this.dataSource.getReader(), AxiomXMLStreamReaderHelperFactory.INSTANCE);
            }
            catch (XMLStreamException ex) {
                throw new StreamException(ex);
            }
        }
        return new PushOMDataSourceInput(this, this.dataSource);
    }

    public OMDataSource getDataSource() {
        return this.dataSource;
    }

    public OMDataSource setDataSource(OMDataSource dataSource) {
        try {
            if (!this.isExpanded()) {
                OMDataSource oldDS = this.dataSource;
                this.dataSource = dataSource;
                return oldDS;
            }
            OMDataSource oldDS = this.dataSource;
            this.coreSetInputContext(null);
            this.coreRemoveChildren(AxiomSemantics.INSTANCE);
            this.isExpanded = false;
            this.dataSource = dataSource;
            return oldDS;
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public void completed() {
        if (this.dataSource != null) {
            if (this.dataSource instanceof OMDataSourceExt) {
                ((OMDataSourceExt)this.dataSource).close();
            }
            this.dataSource = null;
        }
    }

    public Object getObject(Class<? extends OMDataSourceExt> dataSourceClass) {
        if (this.dataSource == null || this.isExpanded || !dataSourceClass.isInstance(this.dataSource)) {
            return null;
        }
        return ((OMDataSourceExt)this.dataSource).getObject();
    }
}

