/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.axiom.weaver.noabstract;

import static org.junit.Assert.assertThrows;

import org.apache.axiom.weaver.SimpleImplementationClassNameMapper;
import org.apache.axiom.weaver.Weaver;
import org.apache.axiom.weaver.innerclass.InnerClassTest;
import org.apache.axiom.weaver.mixin.clazz.MixinFactoryException;
import org.junit.jupiter.api.Test;

public class NoAbstractMethodTest {
    @Test
    public void testMixinWithAbstractMethod() {
        ClassLoader cl = InnerClassTest.class.getClassLoader();
        Weaver weaver = new Weaver(cl, new SimpleImplementationClassNameMapper("impl"));
        assertThrows(
                MixinFactoryException.class,
                () -> weaver.loadWeavablePackage("org.apache.axiom.weaver.noabstract"));
    }
}
