/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.soap;

import java.net.URI;
import org.apache.woden.ErrorReporter;
import org.apache.woden.wsdl20.WSDLComponent;
import org.apache.woden.wsdl20.extensions.BaseComponentExtensionContext;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.ExtensionProperty;
import org.apache.woden.wsdl20.extensions.http.HTTPConstants;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPConstants;
import org.apache.woden.wsdl20.extensions.soap.SOAPModule;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.BooleanAttr;
import org.apache.woden.xml.StringAttr;
import org.apache.woden.xml.URIAttr;

public class SOAPBindingExtensionsImpl
extends BaseComponentExtensionContext
implements SOAPBindingExtensions {
    public SOAPBindingExtensionsImpl(WSDLComponent parent, URI extNamespace, ErrorReporter errReporter) {
        super(parent, extNamespace, errReporter);
    }

    public ExtensionProperty[] getProperties() {
        return new ExtensionProperty[]{this.getProperty("soap version"), this.getProperty("soap underlying protocol"), this.getProperty("soap mep default"), this.getProperty("soap modules")};
    }

    public ExtensionProperty getProperty(String propertyName) {
        if ("soap version".equals(propertyName)) {
            return this.newExtensionProperty("soap version", this.getSoapVersion());
        }
        if ("soap underlying protocol".equals(propertyName)) {
            return this.newExtensionProperty("soap underlying protocol", this.getSoapUnderlyingProtocol());
        }
        if ("soap mep default".equals(propertyName)) {
            return this.newExtensionProperty("soap mep default", this.getSoapMepDefault());
        }
        if ("soap modules".equals(propertyName)) {
            return this.newExtensionProperty("soap modules", this.getSoapModules());
        }
        return null;
    }

    public String getSoapVersion() {
        StringAttr version = (StringAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(SOAPConstants.Q_ATTR_SOAP_VERSION);
        return version != null ? version.getString() : "1.2";
    }

    public URI getSoapUnderlyingProtocol() {
        URIAttr protocol = (URIAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(SOAPConstants.Q_ATTR_SOAP_PROTOCOL);
        return protocol != null ? protocol.getURI() : null;
    }

    public URI getSoapMepDefault() {
        URIAttr mepDefault = (URIAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(SOAPConstants.Q_ATTR_SOAP_MEPDEFAULT);
        return mepDefault != null ? mepDefault.getURI() : null;
    }

    public SOAPModule[] getSoapModules() {
        ExtensionElement[] extEls = ((WSDLElement)((Object)this.getParent())).getExtensionElementsOfType(SOAPConstants.Q_ELEM_SOAP_MODULE);
        int len = extEls.length;
        SOAPModule[] soapMods = new SOAPModule[len];
        System.arraycopy(extEls, 0, soapMods, 0, len);
        return soapMods;
    }

    public String getHttpQueryParameterSeparatorDefault() {
        URI protocol = this.getSoapUnderlyingProtocol();
        if (protocol == null) {
            return null;
        }
        if ("1.2".equals(this.getSoapVersion()) && protocol.toString().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || "1.1".equals(this.getSoapVersion()) && protocol.toString().equals("http://www.w3.org/2006/01/soap11/bindings/HTTP/")) {
            StringAttr qpsDef = (StringAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_QUERY_PARAMETER_SEPARATOR_DEFAULT);
            return qpsDef != null ? qpsDef.getString() : "&";
        }
        return null;
    }

    public Boolean isHttpCookies() {
        URI protocol = this.getSoapUnderlyingProtocol();
        if (protocol == null) {
            return null;
        }
        if ("1.2".equals(this.getSoapVersion()) && protocol.toString().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || "1.1".equals(this.getSoapVersion()) && protocol.toString().equals("http://www.w3.org/2006/01/soap11/bindings/HTTP/")) {
            BooleanAttr cookiesUsed = (BooleanAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_COOKIES);
            return cookiesUsed != null ? cookiesUsed.getBoolean() : new Boolean(false);
        }
        return null;
    }

    public String getHttpContentEncodingDefault() {
        URI protocol = this.getSoapUnderlyingProtocol();
        if (protocol == null) {
            return null;
        }
        if ("1.2".equals(this.getSoapVersion()) && protocol.toString().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || "1.1".equals(this.getSoapVersion()) && protocol.toString().equals("http://www.w3.org/2006/01/soap11/bindings/HTTP/")) {
            StringAttr ceDef = (StringAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_CONTENT_ENCODING_DEFAULT);
            return ceDef != null ? ceDef.getString() : null;
        }
        return null;
    }
}

