#BMAE Language dictionary
#Dictionary of all of the languages for BMAE

#############################################################################		
# --------------------------------------------------------------------------
# BMAE v1.2
# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2006 - 2007: Ron Walker
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------
############################################################################

###############################
#Beginning of Language section#---------------------------------------------------------------------------------------
###############################
import Blender
import os
import sys

#Language Dictionaries
#=======================
english = { 'Language':'English',
	
			#Mesh Types------
			#2d
			'Plane':"Plane",
			'Circle':"Circle",
			'Disc':"Disc",
			'Triangle':"Triangle",
			'Right Triangle':"Right Triangle",
			#3d
			'Cube':"Cube",
			'Tube':"Tube",
			'Cylinder':"Cylinder",
			'Triangle_3d':"Triangle 3d",
			'Right_Triangle_3d':"Right Triangle 3d",
			'Tetrahedron':"Tetrahedron",
			'Pyramid':"Pyramid",
			'Diamond':"Diamond",
			'Cone':"Cone",
			'Sphere':"Sphere",
			'Torus':"Torus",	
				
			#Interactive Display Labels and Warnings------
			#Size Input Warnings
			'UE':"User Error",
			'UE_SMT':"User Error:%t|Select a Mesh Type",
			'UE - No Unit':"User Error:%t|Mesh needs a Measurement Unit.",
			#Units
			'I_Miles':"\tMiles",
			'I_Feet':"    Feet",
			'I_Inches':"   Inches",
			'I_Kilo':" Kilometers",
			'I_Meters':"   Meters",
			'I_Cent':"Centimeters",
			#X
			'I_W_X':"Width  (X):",
			'I_H_X':"Height (X):",
			'I_D_X':"Depth  (X):",
			#Y	
			'I_W_Y':"Width  (Y):",
			'I_H_Y':"Height (Y):",
			'I_D_Y':"Depth  (Y):",
			#Z
			'I_H_Z':"Height (Z):",
			'I_D_Z':"Depth  (Z):",
			#Diplay and Warnings
			'Reset_W':"Warning! - Reset all settings?%t|Proceed %x1|Stop %x2",
			'EMode_Sel':"Select Mode.%t|Edit Mode (Default) %x1|Object Mode %x2",
			'MScale_W':"Warning! - This will alter the Mesh Scale.%t|Normal %x1|10X %x2",
			'Exit_W':"Exit Program?%t|Yes %x1|No %x2",
			'No_OVal_W':"User Error:%t|Missing an outer size value.",
			'No_IVal_W':"User Error:%t|Missing an inner size value.",
			'OIS_F_W':"User Error:%t|Outer size values must be set first.",
			'SL_Reset_W':"Warning! - Reset size and location values?%t|Proceed %x1|Stop %x2",
			
			
			#Buttons, Menus, Toggles and Text------
			#Constant Text
			'T_Title':"\t\t\t\t  BMAE v1.2",
			'T_M_Type':"Mesh Type:",
			'T_M_Name':"Mesh Name:",
			'T_Mea_Unit':"Measurement Unit:",
			'T_Axis':"Axis:",
			'T_Size':"Size",
			'T_Loc':"Location",
			'T_Loc_X':"L-/R+ (X):",
			'T_Loc_Y':"F-/B+ (Y):",
			'T_Loc_Z':"D-/U+ (Z):",
			'T_Draw_Type':"Draw Type:",
			'T_Outer':": Outer",
			'T_Inner':": Inner",
			#Constant Buttons
			'B_MT_2d':"%t|2D Mesh Types %x1|Plane %x2|Circle %x3|Disc %x4|Triangle %x5|Right Triangle %x6",
			'B_MT_3d':"%t|3D Mesh Types %x1|Cube %x2|Tube %x3|Cylinder %x4|Triangle %x5|Right Triangle %x6|Tetrahedron %x7|Pyramid %x8|Diamond %x9|Cone %x10|Sphere %x11|Torus %x12",	
			'B_Mesh_Type_2d_T':"Select a 2d mesh type..",
			'B_Mesh_Type_3d_T':"Select a 3d mesh type.",	
			'B_Mesh_Name_T':"Enter a name for your mesh. (Optional)",
			'B_Units_Menu':"%t|Units %x1|US Standard %x2|Metric %x3|US Standard to Metric %x4|Metric to US Standard %x5",
			'B_Units_Menu_T':"Select Units",
			'B_Mesh_Size_D':"Mesh Scale:",
			'B_Mesh_Size_T':"Synchronize to 'Spacing' in View Properties - Default is 1.",
			'B_Axis_X_T':"X Axis Orientatation. (Default Z)",
			'B_Axis_Y_T':"Y Axis Orientatation. (Default Z)",
			'B_Axis_Z_T':"Z Axis Orientatation. (Default Z)",
			'B_Cal_D':"Calculator",
			'B_Cal_T':"Fraction to decimal calculator.",	
			'B_EMode_D':"Mode",
			'B_EMode_T':"On = Edit Mode / Off = Object Mode. (Default On)",
			'B_Reset_D':"Reset",
			'B_Reset_T':"Reset all",
			'B_Create_D':"Create",
			'B_Create_T':"Create your mesh.",
			'B_Options':"Options",
			'B_Options_T':"Change BMAE options.",
			'B_Exit_D':"Exit",
			'B_Exit_T':"Exit this program.",
			#Numeric Buttons
			"B_MiS":"Miles from mesh center",
			"B_FS":"Feet from mesh center",
			"B_IS":"Inches from mesh center",
			"B_MiL":"Miles from grid center",
			"B_FL":"Feet from grid center",
			"B_IL":"Inches from grid center",
			"B_KS":"Kilometers from mesh center",
			"B_MeS":"Meters from mesh center",
			"B_CS":"Centimeters from mesh center",
			"B_KL":"Kilometers from grid center",
			"B_MeL":"Meters from grid center",
			"B_CL":"Centimeters from grid center",
			"B_N":"No Unit",
			#Segments
			'B_Segments':"Segments:",
			'B_N_Segs':"Number of Segments. (Columns)",	
			#Rings
			'B_Rings':"Rings:",
			'B_N_Rings':"Number of Rings. (Rows)",
			#Right Triangle
			'B_RT_BL':"Bottom Left",
			'B_RT_BR':"Bottom Right",
			'B_RT_TL':"Top Left",
			'B_RT_TR':"Top Right",
			'B_RT_BL_T':"Right angle on the bottom left side.",
			'B_RT_BR_T':"Right angle on the bottom right side.",
			'B_RT_TL_T':"Right angle on the top left side.",
			'B_RT_TR_T':"Right angle on the top right side.",
			#SL_Reset
			'B_SL_R':"SL Reset",
			'B_SL_R_T':"Reset the size (outer/inner) and location values.",
			#2d/3d Toggle
			'B_2d_T':"2 dimensional mesh types (planar).",
			'B_3d_T':"3 dimensional mesh types.",
			#Core
			'B_Core':"Core",
			'B_Core_T':"Core the mesh",
			#Outer/Inner
			'B_Outer':"O",
			'B_Outer_T':"Set the outer radius.",
			'B_Inner':"I",
			'B_Inner_T':"Set the inner radius.",
			#Fill
			'B_Fill':"Fill",
			'B_Fill_T':"Fill inner radius faces.",
			#Floor
			'B_Floor':"Floor",
			'B_Floor_T':"Set the mesh to the positive or negative floor.",
			#+Z/-Z
			'B_+Z_T':"Floor mesh on the positive Z axis.",
			'B_-Z_T':"Floor mesh on the negative Z axis.",
			#Torus Outside, Center, Inside
			'B_Outside':"O",
			'B_Outside_T':"Measure Torus from outside.",
			'B_Center':"C",
			'B_Center_T':"Measure Torus from center.",
			'B_Inside':"I",
			'B_Inside_T':"Measure Torus from inside.",
				
			#Options------
			#Diplay and Warnings
			'B_Op_Units_Menu':"Units %t|No Unit %x1|US Standard %x2|Metric %x3|US Standard to Metric %x4|Metric to US Standard %x5",
			'B_Op_Units_Menu_T':"Select Units.",
			'B_Op_YFlip_W':"Set the Y face normal direction?%t|Face to front (-Y) (default).%x1|Face to back (+Y).%x2",
			
			#Save Popup
			'Op_Save_W':"Settings have been saved!%t|Restart BMAE for settings to become permanent.",
			#Load Warning
			'Op_Load_W':"BMAE Error!  The Settings.bsf file is either missing or corrupt..%t|BMAE will continue but without Options support.",		
			#Constant Buttons and Text
			#Text
			'T_Op_Settings':"Settings",
			'T_Op_Language':"Language Settings:",
			'T_Op_Unit':"Unit Settings:",
			'T_MeshScale':"Mesh Scale",
			'T_Op_YDir':"Y Direction:",
			#Buttons	
			'B_Op_Lang_T':"Select a language.",
			'B_Op_Save':"Save",
			'B_Op_Save_T':"Save your settings",
			'B_MeshScale_T':"Synchronize to 'Spacing' in View Properties - default is 1.",
			'B_Op_YDir_T':"Flip mesh for +Y or -Y direction.",

			
			#Calculator------
			#Popup Warnings
			'Cal_Reset_W':"Warning! - Reset all settings?%t|Proceed %x1|Stop %x2", 	
			#Constant Text
			'Cal_T_Ledger':"Ledger",
			'Cal_T_USS':"US Standard",
			'Cal_T_Metric':"Metric",
			'Cal_T_FTD':"Convert Fraction to Decimal",
			'Cal_T_DTI':"Convert Decimal to Inches",
			'Cal_T_N':"N:",
			'Cal_T_D':"D:",
			'Cal_T_Dec':"Decimal:",
			'Cal_T_In':"Inches:",
			#Ledger
			'Cal_Deci_T':" Decimeter ",
			'Cal_Decis_T':" Decimeters ",
			'Cal_Centi_T':" Centimeter ",
			'Cal_Centis_T':" Centimeters ",
			'Cal_Milli_T':" Millimeter ",
			'Cal_Millis_T':" Millimeters ",
			#Buttons
			'CalOp_Back_D':"Back",
			'CalOp_Back_T':"Back to main interface",
			'Cal_Calc_D':"Calculate",
			'Cal_Calc_TD_T':"Calculate to decimal",
			'Cal_Calc_FD_T':"Calculate from decimal",
			'Cal_Reset_D':"Reset",
			'Cal_Reset_T':"Reset all",
			'Cal_USM_D':"%t|US Standard %x1|16th's %x2|8th's %x3|4th's %x4|",
			'Cal_USM_T':"English Ledger (Common Values)",
			'Cal_MetM_D':"%t|Metric %x1|Millimeters %x2|Centimeters %x3|Decimeters %x4",
			'Cal_MetM_T':"Metric Ledger (Common Values)",
			'Cal_N_T':"Numerator",
			'Cal_D_T':"Denominator",
			'Cal_Dec_T':"Decimal",
		  }

espanol = { 'Language':'Espanol',
	
			#Mesh Types------
			#2d
			'Plane':"Plano",
			'Circle':"Circulo",
			'Disc':"Disco",
			'Triangle':"Triangulo",
			'Right Triangle':"Triangulo Derecho",
			#3d
			'Cube':"Cubo",
			'Tube':"Tubo",
			'Cylinder':"Cilindro",
			'Triangle_3d':"Triangulo 3d",
			'Right_Triangle_3d':"Triangulo Derecho 3d",
			'Tetrahedron':"Tetraedro",
			'Pyramid':"Piramide",
			'Diamond':"Diamante",
			'Cone':"Cono",
			'Sphere':"Esfera",
			'Torus':"Toro",
				
			#Interactive Display Labels and Warnings------
			#Size Input Warnings
			'UE':"Error Del Usario",
			'UE_SMT':"Error Del Usario:%t|Seleccione un tipo del acoplamiento",
			'UE - No Unit':"Error Del Usario:%t|El acoplamiento necesita una unidad de la medida.",
			#Units
			'I_Miles':"    Millas",
			'I_Feet':"     Pies",
			'I_Inches':" Pulgadas",
			'I_Kilo':" Kilometros",
			'I_Meters':"   Metros",
			'I_Cent':"Centimetros",
			#X
			'I_W_X':"Anchura (X):",#Needs small +
			'I_H_X':"Altura (X):",
			'I_D_X':"Profundidad(X):",
			#Y	
			'I_W_Y':"Anchura (Y):",
			'I_H_Y':"Altura (Y):",
			'I_D_Y':"Profundidad(Y):",
			#Z
			'I_H_Z':"Altura (Z):",
			'I_D_Z':"Profundidad(Z):",#Needs small +
			#Diplay and Warnings
			'Reset_W':"Permita el interfaz de la calculadora?%t|Proceda %x1|Pare %x2",
			'EMode_Sel':"Modo Selecto.%t|Modo del Corrige (Default) %x1|Modo del Objecto %x2",
			'MScale_W':"Advertencia! - esto alterar la escala del acoplamiento.%t|Normal %x1|10X %x2",
			'Exit_W':"Salga Del Programa?%t|Si %x1|No %x2",
			'No_OVal_W':"Error del usuario:%t|valores externos del tamano que faltan.",
			'No_IVal_W':"Error del usuario:%t|valores interno del tamano que faltan.",
			'OIS_F_W':"Error del usuario:%t|Los valores externos del tamano se deben fijar primero.",
			'SL_Reset_W':"Advertencia! - Reajuste los valores del tamano y de la localizacion?%t|Proceda %x1|Pare %x2",
			
			#Buttons, Menus, Toggles and Text------
			#Constant Text
			'T_Title':"\t\t\t\t  BMAE v1.2",
			'T_M_Type':"Tipo Del Acoplamiento:",
			'T_M_Name':"Nombre Del Acoplamiento:",#Needs Small
			'T_Mea_Unit':"Unidad De la Medida:",
			'T_Axis':"Eje:",
			'T_Size':"Tamano",#Needs small
			'T_Loc':"Localizacion",
			'T_Loc_X':"I-/D+ (X):",
			'T_Loc_Y':"F-/P+ (Y):",
			'T_Loc_Z':"A-/E+ (Z):",
			'T_Draw_Type':"Tipo Del Drenaje:",#Needs small
			'T_Outer':": Externo",
			'T_Inner':": Interno",
			#Constant Buttons
			'B_MT_2d':"%t|2D Mesh Types %x1|Plano %x2|Circulo %x3|Disco %x4|Triangulo %x5|Triangulo Derecho %x6",
			'B_MT_3d':"%t|3D Mesh Types %x1|Cubo %x2|Tubo %x3|Cilindro %x4|Triangulo %x5|Triangulo Derecho %x6|Tetrahedro %x7|Pyramide %x8|Diamante %x9|Cono %x10|Esfera %x11|Toro %x12",	
			'B_Mesh_Type_2d_T':"Seleccione un 2d tipo del acoplamiento.",
			'B_Mesh_Type_3d_T':"Seleccione un 3d tipo del acoplamiento.",		
			'B_Mesh_Name_T':"Incorpore un nombre para su acoplamiento. (Opcional)",
			'B_Units_Menu':"%t|Unidades %x1|Estandar de los E.U. %x2|Metrico %x3|Estandar de los E.U. a Metrico %x4|Metrico al Estandar de los E.U. %x5",
			'B_Units_Menu_T':"Seleccione Las Unidad.",
			'B_Mesh_Size_D':"Escala del Acoplamiento.",
			'B_Mesh_Size_T':"Sincronice el 'espaciamiento' en caracteristicas de la vision - el defecto es 1.",
			'B_Axis_X_T':"Orientacin Del Eje X. (Defecto Z)",
			'B_Axis_Y_T':"Orientacin Del Eje Y. (Defecto Z)",
			'B_Axis_Z_T':"Orientacin Del Eje Z. (Defecto Z)",
			'B_Cal_D':"Calculadora",
			'B_Cal_T':"Fraccin a la culadora decimal.",	
			'B_EMode_D':"Modo",
			'B_EMode_T':"Encendido = Modo del Corrige / Apagado = Modo del Objecto. (Defecto encendido)",
			'B_Reset_D':"Reajuste",
			'B_Reset_T':"Reajuste Todos",
			'B_Create_D':"Cree",
			'B_Create_T':"Cree su acomplamiento.",
			'B_Options':"Opciones",
			'B_Options_T':"Cambie las opciones de BMAE.",
			'B_Exit_D':"Salida",
			'B_Exit_T':"Salida de este programa.",
			#Numeric Buttons
			"B_MiS":"Millas del centro del acoplamiento",
			"B_FS":"Pies del centro de la acoplamiento",
			"B_IS":"Pulgadas del centro del acomplamiento",
			"B_MiL":"Millas del centro de la rejilla",
			"B_FL":"Pies del centro de la rejilla",
			"B_IL":"Pulgadas del centro de la rejilla",
			"B_KS":"Kilometros del centro del acoplamiento",
			"B_MeS":"Metros del centro del acoplamiento",
			"B_CS":"Centimetros del centro del acoplamiento",
			"B_KL":"Kilometros del centro de la rejilla",
			"B_MeL":"Metros del centro de la rejilla",
			"B_CL":"Centimetros del centro de la rejilla",
			"B_N":"Ninguna Unidad",
			#Segments
			'B_Segments':"Segmentos:",
			'B_N_Segs':"Numero de los segmentos. (Columnas)",	
			#Rings
			'B_Rings':"Anillos:",
			'B_N_Rings':"Numero de los anillos. (Filas)",
			#Right Triangle
			'B_RT_BL':"Izquierda Inferior",
			'B_RT_BR':"Derecha Inferior",
			'B_RT_TL':"Izquierda Superior",
			'B_RT_TR':"Derecha Superior",
			'B_RT_BL_T':"Angulo recto en el lado izquierdo inferior.",
			'B_RT_BR_T':"Angulo recto en el derecho inferior.",
			'B_RT_TL_T':"Angulo recto en el lado izquierdo superior.",
			'B_RT_TR_T':"Angulo recto en el derecho superior.",
			#SL_Reset
			'B_SL_R':"TL R",#Reajuste
			'B_SL_R_T':"Reajuste el tamano (externo/interno) y los valores de la localizacion.",
			#2d/3d Toggle
			'B_2d_T':"2 tipos dimensionales del acoplamiento (planar).",
			'B_3d_T':"3 tipos dimensionales del acoplamiento.",
			#Core
			'B_Core':"Corazon",
			'B_Core_T':"Quite el corazon al acoplamiento.",
			#Outer/Inner
			'B_Outer':"E",
			'B_Outer_T':"Fije el radio externo.",
			'B_Inner':"I",	
			'B_Inner_T':"Fije el radio interno.",
			#Fill
			'B_Fill':"llene",
			'B_Fill_T':"Llene las caras internas del radio.",
			#Floor
			'B_Floor':"Piso",
			'B_Floor_T':"Fije el acoplamiento al piso positivo o negativo.",
			#+Z/-Z
			'B_+Z_T':"Acoplamiento del piso en el eje positivo de Z.",
			'B_-Z_T':"Acoplamiento del piso en el eje negativo de Z.",
			#Torus Outside, Center, Inside
			'B_Outside':"E",
			'B_Outside_T':"Toro de la medida del exterior.",
			'B_Center':"A",
			'B_Center_T':"Toro de la medida desde adentro.",
			'B_Inside':"C",
			'B_Inside_T':"Toro de la medida del centro.",
			
				
			#Options------
			#Diplay and Warnings
			'B_Op_Units_Menu':"Unidades %t|Ninguna Unidad %x1|Estandar de los E.U. %x2,\
				|Metrico %x3|Estandar de los E.U. a Metrico %x4|Metrico al Estandar de los E.U. %x5",
			'B_Op_Units_Menu_T':"Seleccione Las Unidad.",
			'B_Op_YFlip_W':"Fije la cara de Y en direccion normal?%t|Cara a afrontar (-Y) (defecto).%x1|Cara a atras (+Y).%x2",
			
			#Save Popup
			'Op_Save_W':"Se han ahorrado los ajustes!%t|Recomenzar BMAE para los ajustes a llegar a ser permanentes.",
			#Load Warning
			'Op_Load_W':"Error de BMAE!  El archivo de Settings.bsf esta faltando o corrompe..%t|BMAE continuara pero sin ayuda de las Opciones.",
			#Constant Buttons and Text
			#Text
			'T_Op_Settings':"Ajustes",
			'T_Op_Language':"Ajustes de la lengua:",
			'T_Op_Unit':"Ajustes de la unidad:",
			'T_MeshScale':"Escala del Acoplamiento",
			'T_Op_YDir':"Direccion de Y:",
			#Buttons
			'B_Op_Lang_T':"Seleccione una lengua.",	
			'B_Op_Save':"Excepto",
			'B_Op_Save_T':"Excepto sus ajustes",
			'B_MeshScale_T':"Sincronice al 'Espaciamiento' en Caracteristicas de la Vision - el defecto es 1.",
			'B_Op_YDir_T':"Mueva de un tion el acoplamiento para - Y o direccion de +Y.",
				
			#Calculator------
			#Popup Warnings
			'Cal_Reset_W':"Advertencia! - Reajuste todos los ajustes?%t|Proceda %x1|Pare %x2", 	
			#Constant Text
			'Cal_T_Ledger':"Libro Mayor",
			'Cal_T_USS':"Estandar de los E.U.",
			'Cal_T_Metric':"Metrico",
			'Cal_T_FTD':"Fracciones el convertido al decimal",
			'Cal_T_DTI':"Decimal del convertido a las pulgadas",
			'Cal_T_N':"N:",
			'Cal_T_D':"D:",
			'Cal_T_Dec':"Decimal:",
			'Cal_T_In':"Pulgadas:",
			#Ledger
			'Cal_Deci_T':" Decimeter ",
			'Cal_Decis_T':" Decimeters ",
			'Cal_Centi_T':" Centimetro ",
			'Cal_Centis_T':" Centimetros ",
			'Cal_Milli_T':" Millimetro ",
			'Cal_Millis_T':" Millimetros ",
			#Buttons
			'CalOp_Back_D':"Detras",
			'CalOp_Back_T':"De nuevo a interfaz principal",
			'Cal_Calc_D':"Calcule",
			'Cal_Calc_TD_T':"Calcule al decimal",
			'Cal_Calc_FD_T':"Calcule de decimal",
			'Cal_Reset_D':"Reajuste",
			'Cal_Reset_T':"Reajuste todos",
			'Cal_USM_D':"%t|Estandar de los E.U. %x1|16th's %x2|8th's %x3|4th's %x4|",
			'Cal_USM_T':"Libro mayor Ingles (valores comunes)",
			'Cal_MetM_D':"%t|Metric %x1|Millimeters %x2|Centimeters %x3|Decimeters %x4",
			'Cal_MetM_T':"Libro mayor Metrico (Common Values)",
			'Cal_N_T':"Numerador",
			'Cal_D_T':"Denominador",
			'Cal_Dec_T':"Decimal",
		  }

francais = { 'Language':'Francais',
	
			#Mesh Types------
			#2d
			'Plane':"Plan",
			'Circle':"Cercle",
			'Disc':"Disque",
			'Triangle':"Triangle",
			'Right Triangle':"Triangle Rectangle",
			#3d
			'Cube':"Cube",
			'Tube':"Tube",
			'Cylinder':"Cylindre",
			'Triangle_3d':"Triangle 3d",
			'Right_Triangle_3d':"Triangle Rectangle 3d",
			'Tetrahedron':"Tetrahedre",
			'Pyramid':"Pyramide",
			'Diamond':"Diamant",
			'Cone':"Cone",
			'Sphere':"Sphere",
			'Torus':"Tore",	
				
			#Interactive Display Labels and Warnings------
			#Size Input Warnings
			'UE':"Erreur d'utilisateur",
			'UE_SMT':"Erreur d'utilisateur:%t|Selectionner un type de maillage",
			'UE - No Unit':"Erreur d'utilisateur:%t|Le maillage a besoin d'une unite de mesure.",
			#Units
			'I_Miles':"\tMiles",
			'I_Feet':"    Pieds",
			'I_Inches':"   Pouces",
			'I_Kilo':" Kilometres",
			'I_Meters':"   Metres",
			'I_Cent':"Centimetres",
			#X
			'I_W_X':"Largeur    (X):",
			'I_H_X':"Hauteur    (X):",
			'I_D_X':"Profondeur (X):",
			#Y	
			'I_W_Y':"Largeur    (Y):",
			'I_H_Y':"Hauteur    (Y):",
			'I_D_Y':"Profondeur (Y):",
			#Z
			'I_H_Z':"Hauteur    (Z):",
			'I_D_Z':"Profondeur (Z):",
			#Diplay and Warnings
			'Reset_W':"Attention! - Reinitialiser tous les reglages?%t|Proceder %x1|Arreter %x2",
			'EMode_Sel':"Selectionner le Mode.%t|Mode Edition (Par Defaut) %x1|Mode Objet %x2",
			'MScale_W':"Atttention! - Ceci modifiera l'echelle du maillage.%t|Normal %x1|10X %x2",
			'Exit_W':"Quitter le Programme?%t|Oui %x1|Non %x2",
			'No_OVal_W':"Erreur d'utilisateur:%t|Il manque une valeur de grandeur externe.",
			'No_IVal_W':"Erreur d'utilisateur:%t|Il manque une valeur de grandeur interne.",
			'OIS_F_W':"Erreur d'utilisateur:%t|La valeur de grandeur externe doit etre reglee en premier.",
			'SL_Reset_W':"Attention! - Reinitialiser les reglages de grandeur et de position?%t|Proceder %x1|Arreter %x2",
			
			
			#Buttons, Menus, Toggles and Text------
			#Constant Text
			'T_Title':"\t\t\t\t  BMAE v1.2",
			'T_M_Type':"Type de maillage:",
			'T_M_Name':"Nom du maillage:",
			'T_Mea_Unit':"Unite de mesure:",
			'T_Axis':"Axe:",
			'T_Size':"Grandeur",
			'T_Loc':"Position",
			'T_Loc_X':"G-/D+ (X):",#Gauche, Droite
			'T_Loc_Y':"A-/P+ (Y):",#Anterieur, Posterieur
			'T_Loc_Z':"B-/H+ (Z):",#Bas, Haut
			'T_Draw_Type':"Type d'affichage:",
			'T_Outer':": Externe",
			'T_Inner':": Interne",
			#Constant Buttons
			'B_MT_2d':"%t|Types de maillage 2d %x1|Plan %x2|Cercle %x3|Disque %x4|Triangle %x5|Triangle rectangle %x6",
			'B_MT_3d':"%t|Types de maillage 3d %x1|Cube %x2|Tube %x3|Cylindre %x4|Triangle %x5|Triangle rectangle %x6|Tetrahedre %x7|Pyramide %x8|Diamant %x9|Cone %x10|Sphere %x11|Tore %x12",	
			'B_Mesh_Type_2d_T':"Selectionner un type de maillage 2d.",
			'B_Mesh_Type_3d_T':"Selectionner un type de maillage 3d .",	
			'B_Mesh_Name_T':"Entrer un nom pour votre maillage. (Optionnel)",
			'B_Units_Menu':"%t|Unites %x1|Norme des Etats-Unis %x2|Metriques %x3|Norme des Etats-Unis a Metriques %x4|Metriques a Norme des Etats-Unis %x5",
			'B_Units_Menu_T':"Selectionner l'unite",
			'B_Mesh_Size_D':"Echelle du maillage:",
			'B_Mesh_Size_T':"Synchronizer a 'L'espace' dans les proprietes de la vue - La valeur par defaut est 1.",
			'B_Axis_X_T':"Axe d'orientatation X. (Z par defaut)",
			'B_Axis_Y_T':"Axe d'orientatation Y. (Z par defaut)",
			'B_Axis_Z_T':"Axe d'orientatation Z. (Z par defaut)",
			'B_Cal_D':"C",#Convertisseur or Calculatrice
			'B_Cal_T':"Convertisseur de fractions en decimales.",	
			'B_EMode_D':"Mode",
			'B_EMode_T':"On = Mode Edition / Off = Mode Objet. (On par defaut)",
			'B_Reset_D':"R",#Reinitialiser
			'B_Reset_T':"Tout reinitialiser",
			'B_Create_D':"Creer",
			'B_Create_T':"Creer votre maillage.",
			'B_Options':"Options",
			'B_Options_T':"Changer les options de BMAE.",
			'B_Exit_D':"Quitter",
			'B_Exit_T':"Quitter ce programme.",
			#Numeric Buttons
			"B_MiS":"Miles depuis le centre du maillage",
			"B_FS":"Pieds (feets) depuis le centre du maillage",
			"B_IS":"Pouces (inches) depuis le centre du maillage",
			"B_MiL":"Miles depuis le centre de la grille",
			"B_FL":"Pieds (feet) depuis le centre de la grille",
			"B_IL":"Pouces (inches) depuis le centre de la grille",
			"B_KS":"Kilometres depuis le centre du maillage",
			"B_MeS":"Metres depuis le centre du maillage",
			"B_CS":"Centimetres depuis le centre du maillage",
			"B_KL":"Kilometres depuis le centre de la grille",
			"B_MeL":"Metres depuis le centre de la grille",
			"B_CL":"Centimetres depuis le centre de la grille",
			"B_N":"Pas d'unite",
			#Segments
			'B_Segments':"Segments:",
			'B_N_Segs':"Nombre de segments. (Colonnes)",	
			#Rings
			'B_Rings':"Anneaux:",
			'B_N_Rings':"Nombre d'anneaux. (Rangs)",
			#Right Triangle
			'B_RT_BL':"Bas a gauche",
			'B_RT_BR':"Bas a droite",
			'B_RT_TL':"Haut a gauche",
			'B_RT_TR':"Haut a droite",
			'B_RT_BL_T':"Angle droit sur le cote en bas a gauche.",
			'B_RT_BR_T':"Angle droit sur le cote en bas a droite.",
			'B_RT_TL_T':"Angle droit sur le cote en haut a gauche.",
			'B_RT_TR_T':"Angle droit sur le cote en haut a droite.",
			#SL_Reset
			'B_SL_R':"GP R", #Grandeur/Position Reinitialiser
			'B_SL_R_T':"Reinitialiser les parametres de grandeur (externe/interne) et de position.",
			#2d/3d Toggle
			'B_2d_T':"Types de maillage en 2 dimensions (planaires).",
			'B_3d_T':"Types de maillage en 3 dimensions.",
			#Core
			'B_Core':"Centre",
			'B_Core_T':"Enlever le centre du maillage",
			#Outer/Inner
			'B_Outer':"E",
			'B_Outer_T':"Regler le rayon externe.",
			'B_Inner':"I",
			'B_Inner_T':"Regler le rayon interne.",
			#Fill
			'B_Fill':"Remplir",
			'B_Fill_T':"Remplir les faces du rayons interne.",
			#Floor
			'B_Floor':"Sol",
			'B_Floor_T':"Regler le maillage au sol positif ou negatif.",
			#+Z/-Z
			'B_+Z_T':"Maillage de sol sur l'axe Z positif.",
			'B_-Z_T':"Maillage de sol sur l'axe Z negatif.",
			#Torus Outside, Center, Inside
			'B_Outside':"E",
			'B_Outside_T':"Mesurer le tore depuis l'exterieur.",
			'B_Center':"C",
			'B_Center_T':"Mesurer le tore depuis le centre.",
			'B_Inside':"I",
			'B_Inside_T':"Mesurer le tore depuis l'interieur.",
				
			#Options------
			#Diplay and Warnings
			'B_Op_Units_Menu':"Unites %t|Pas d'unite %x1|Standards des Etats-Unis %x2|Metriques %x3|Standards des Etats-Unis a Metriques %x4|Metriques aux Standards des Etats-Unis %x5",
			'B_Op_Units_Menu_T':"Selectionner les unites.",
			'B_Op_YFlip_W':"Regler la direction normale de la face Y?%t|Face a l'avant (-Y) (par defaut).%x1|Face a l'arriere (+Y).%x2",
			
			#Save Popup
			'Op_Save_W':"Les reglages ont ete sauvegardes!%t|Redemarrer BMAE pour que les reglages deviennent permanents.",	
			#Load Warning
			'Op_Load_W':"Erreur de BMAE! Le fichier Settings.bsf est manquant ou corrompu. BMAE continuera sans le support des options.",	
			#Constant Buttons and Text
			#Text
			'T_Op_Settings':"Reglages",
			'T_Op_Language':"Reglages de la langue:",
			'T_Op_Unit':"Reglages des unites:",
			'T_MeshScale':"Echelle du maillage",
			'T_Op_YDir':"Direction de Y:",
			#Buttons	
			'B_Op_Lang_T':"Selectionner une langue.",
			'B_Op_Save':"Sauver",
			'B_Op_Save_T':"Sauver vos reglages",
			'B_MeshScale_T':"Synchronizer a 'L'espace' dans les proprietes de la vue - La valeur par defaut est 1.",
			'B_Op_YDir_T':"Intervertir le maillage dans la direction +Y ou -Y.",

			
			#Calculator------
			#Popup Warnings
			'Cal_Reset_W':"Attention! - Reinitialiser tous les reglages?%t|Proceder %x1|Arreter %x2", 	
			#Constant Text
			'Cal_T_Ledger':"Grand livre",
			'Cal_T_USS':"Imperiale",
			'Cal_T_Metric':"Metrique",
			'Cal_T_FTD':"Convertir les fractions en decimales",
			'Cal_T_DTI':"Convertir les decimales en pouces",
			'Cal_T_N':"N:",
			'Cal_T_D':"D:",
			'Cal_T_Dec':"Decimales:",
			'Cal_T_In':"Pouces:",
			#Ledger
			'Cal_Deci_T':" Decimetre ",
			'Cal_Decis_T':" Decimetres ",
			'Cal_Centi_T':" Centimetre ",
			'Cal_Centis_T':" Centimetres ",
			'Cal_Milli_T':" Millimetre ",
			'Cal_Millis_T':" Millimetres ",
			#Buttons
			'CalOp_Back_D':"Retour",
			'CalOp_Back_T':"Retour a l'interface principale",
			'Cal_Calc_D':"Convertir",
			'Cal_Calc_TD_T':"Convertir en decimales",
			'Cal_Calc_FD_T':"Convertir depuis des decimales",
			'Cal_Reset_D':"Reinitialiser",
			'Cal_Reset_T':"Tout reinitialiser",
			'Cal_USM_D':"%t|Imperiales %x1|16th's %x2|8th's %x3|4th's %x4|",
			'Cal_USM_T':"Grand livre anglais (Valeurs communes)",
			'Cal_MetM_D':"%t|Metres %x1|Millimetres %x2|Centimetres %x3|Decimetres %x4",
			'Cal_MetM_T':"Grand livre metrique (Valeurs communes)",
			'Cal_N_T':"Numerateur",
			'Cal_D_T':"Denominateur",
			'Cal_Dec_T':"Decimale",
		  }
		  
italiano = { 'Language':'Italiano',
	
			#Mesh Types------
			#2d
			'Plane':"Aereo",
			'Circle':"Cerchio",
			'Disc':"Disco",
			'Triangle':"Triangolo",
			'Right Triangle':"Giusto Triangolo",
			#3d
			'Cube':"Cubo",
			'Tube':"Tubo",
			'Cylinder':"Cilindro",
			'Triangle_3d':"Triangolo 3d",
			'Right_Triangle_3d':"Giusto Triangolo 3d",
			'Tetrahedron':"Tetraedro",
			'Pyramid':"Piramide",
			'Diamond':"Diamante",
			'Cone':"Cono",
			'Sphere':"Sfera",
			'Torus':"Toro",
				
			#Interactive Display Labels and Warnings------
			#Size Input Warnings
			'UE':"Errore Dell'Utente",
			'UE_SMT':"Errore Dell'Utente:%t|Selezioni un tipo della maglia",
			'UE - No Unit':"User Error:%t|Mesh needs a Measurement Unit.",
			#Units
			'I_Miles':"    Miglia",
			'I_Feet':"\tPiedi",
			'I_Inches':"   Pollici",
			'I_Kilo':" Chilometri",
			'I_Meters':"   Tester",
			'I_Cent':" Centimetri",
			#X
			'I_W_X':"Larghezza (X):",
			'I_H_X':"Altezza (X):",
			'I_D_X':"Profondita(X):",
			#Y	
			'I_W_Y':"Larghezza (Y):",
			'I_H_Y':"Altezza (Y):",
			'I_D_Y':"Profondita(Y):",
			#Z
			'I_H_Z':"Altezza (Z):",
			'I_D_Z':"Profondita(Z):",
			#Diplay and Warnings
			'Reset_W':"Avvertimento! - Ripristini tutte le regolazioni?%t|Continui %x1|Arresto %x2",
			'EMode_Sel':"Modo prescelto.%t|Pubblichi il modo (difetto) %x1|Modo dell'oggetto %x2",
			'MScale_W':"Avvertimento! - Cio alterera la scala della maglia.%t|Normale %x1|10X %x2",
			'Exit_W':"Rimuova il programma?%t|Si %x1|No %x2",
			'No_OVal_W':"Errore dell'utente:%t|valori esterni di signa di formato.",
			'No_IVal_W':"Errore dell'utente:%t|valori interno di signa di formato.",
			'OIS_F_W':"Errore dell'utente:%t|I valori esterni di formato devono essere regolati in primo luogo.",
			'SL_Reset_W':"Avvertimento! - Ripristini i valori di formato e di posizion?%t|Continui %x1|Arresto %x2",
			
			#Buttons, Menus, Toggles and Text------
			#Constant Text
			'T_Title':"\t\t\t\t  BMAE v1.2",
			'T_M_Type':"Tipo Della Maglia:",
			'T_M_Name':"Nome Della Maglia:",
			'T_Mea_Unit':"Unita Di Misura:",
			'T_Axis':"Asse:",
			'T_Size':"Formato",
			'T_Loc':"Posizione",
			'T_Loc_X':"S-/D+ (X):",#Di Sinistra, Destra
			'T_Loc_Y':"A-/P+ (Y):",#Anteriore, Posteriore
			'T_Loc_Z':"G-/S+ (Z):",#Giu, Su
			'T_Draw_Type':"Tipo Di Tiraggio:",
			'T_Outer':": Esterno",
			'T_Inner':": Interno",
			#Constant Buttons
			'B_MT_2d':"%t|2D Mesh Types %x1|Aereo %x2|Cerchio %x3|Disco %x4|Triangolo %x5|Giusto Triangolo %x6",
			'B_MT_3d':"%t|3D Mesh Types %x1|Cubo %x2|Tubo %x3|Cilindro %x4|Triangolo %x5|Guisto Triangolo %x6|Tetraedro %x7|Pyramide %x8|Diamante %x9|Cono %x10|Sfera %x11|Toro %x12",	
			'B_Mesh_Type_2d_T':"Selezioni un 2d tipo della maglia.",
			'B_Mesh_Type_3d_T':"Selezioni un 3d tipo della maglia.",	
			'B_Mesh_Name_T':"Introduca un nome per la vostra maglia. (facoltativo)",
			'B_Units_Menu':"%t|Unitas %x1|Campione degli Stati Uniti %x2|Metrico %x3|Campione degli Stati Uniti a Metrico %x4|Metrico al Campione degli Stati Uniti %x5",
			'B_Units_Menu_T':"Selezioni L'Unit",
			'B_Mesh_Size_D':"Scala della maglia",
			'B_Mesh_Size_T':"Sincronizzi 'il gioco' nelle proprieta di vista - il difetto e 1.",
			'B_Axis_X_T':"X Orientamento di asse. (Difetto Z)",
			'B_Axis_Y_T':"Y Orientamento di asse. (Difetto Z)",
			'B_Axis_Z_T':"Z Orientamento di asse. (Difetto Z)",
			'B_Cal_D':"Calcolatore",
			'B_Cal_T':"Frazione al calcolatore decimale.",	
			'B_EMode_D':"Modo",
			'B_EMode_T':"Sopra = Edit Mode / Disinserito = Modo dell'oggetto. (Difetto sopra)",
			'B_Reset_D':"Ripristini",#Risistemazione
			'B_Reset_T':"Ripristini tutti",
			'B_Create_D':"Generi",
			'B_Create_T':"Generi la vostra maglia.",
			'B_Options':"Opzioni",
			'B_Options_T':"Cambi le opzioni di BMAE.",
			'B_Exit_D':"Uscita",
			'B_Exit_T':"Rimuova questo programma.",
			#Numeric Buttons
			"B_MiS":"Miglia dal centro della maglia",
			"B_FS":"Piedi dal centro della maglia",
			"B_IS":"Pollici dal centro della maglia",
			"B_MiL":"Miglia dal centro di griglia",
			"B_FL":"Piedi dal centro di griglia",
			"B_IL":"Pollici dal centro di griglia",
			"B_KS":"Chilometri dal centro della maglia",
			"B_MeS":"Tester dal centro della maglia",
			"B_CS":"Centimetri dal centro della maglia",
			"B_KL":"Chilometri dal centro di griglia",
			"B_MeL":"Tester dal centro di griglia",
			"B_CL":"Centimetri dal centro di griglia",
			"B_N":"Nessun'unit",
			#Segments
			'B_Segments':"Segmenti:",
			'B_N_Segs':"Numero di segmenti. (Colonne)",	
			#Rings
			'B_Rings':"Anelli:",
			'B_N_Rings':"Numero di anelli. (File)",
			#Right Triangle
			'B_RT_BL':"S I",#Sinistra Inferiore 
			'B_RT_BR':"D I",#Destra Inferiore
			'B_RT_TL':"S S",#Sinistra Superiore 
			'B_RT_TR':"D S",#Destra Superiore
			'B_RT_BL_T':"Angolo retto dalla parte di sinistra inferiore.",
			'B_RT_BR_T':"Angolo retto dalla parte di destra inferiore.",
			'B_RT_TL_T':"Angolo retto dalla parte di sinistra superiore.",
			'B_RT_TR_T':"Angolo retto dalla parte di destra superiore.",
			#SL_Reset
			'B_SL_R':"FP R",#Ripristini
			'B_SL_R_T':"Ripristini il formato (esterno/interno) ed i valori di posizione.",
			#2d/3d Toggle
			'B_2d_T':"2 tipi dimensionali della maglia (planare).",
			'B_3d_T':"3 tipi dimensionali della maglia.",
			#Core
			'B_Core':"Nucleo",
			'B_Core_T':"Estragga la parte centrale dalla maglia.",
			#Outer/Inner
			'B_Outer':"E",
			'B_Outer_T':"Regoli il raggio esterno.",
			'B_Inner':"I",
			'B_Inner_T':"Regoli il raggio interno.",
			#Fill
			'B_Fill':"R",#Riempia
			'B_Fill_T':"Riempia le facce interne del raggio.",
			#Floor
			'B_Floor':"P",#Pavimento
			'B_Floor_T':"Regoli la maglia al pavimento positivo o negativo.",
			#+Z/-Z
			'B_+Z_T':"Acoplamiento del piso en el eje positivo de Z.",
			'B_-Z_T':"Acoplamiento del piso en el eje negativo de Z",
			#Torus Outside, Center, Inside
			'B_Outside':"E",
			'B_Outside_T':"Toro di misura dalla parte esterna.",
			'B_Center':"I",
			'B_Center_T':"Toro di misura dall'interno.",
			'B_Inside':"C",
			'B_Inside_T':"Toro di misura dal centro.",
				
			#Diplay and Warnings
			'B_Op_Units_Menu':"Unitas %t|Nessun' Unita %x1|Campione degli Stati Uniti %x2,\
				|Metrico %x3|Campione degli Stati Uniti a Metrico %x4|Metrico al Campione degli Stati Uniti %x5",
			'B_Op_Units_Menu_T':"Selezioni Le Unita.",
			'B_Op_YFlip_W':"Regoli la faccia di Y di direzione normale.?%t|Faccia da fronteggiare (- Y) (difetto).%x1|Faccia da sostenere (+Y).%x2",
			#Save Popup
			'Op_Save_W':"Le regolazioni sono state conservate!%t|Riavviamento BMAE per le regolazioni da diventare permanente.",
			#Load Warning
			'Op_Load_W':"Errore di BMAE!  La lima di Settings.bsf sta mancando o corrompe..%t|BMAE continuera ma senza supporto di Opzioni.",
			#Constant Buttons and Text
			#Text
			'T_Op_Settings':"Regolazioni",
			'T_Op_Language':"Regolazioni di lingua:",
			'T_Op_Unit':"Regolazioni dell' unita:",
			'T_MeshScale':"Scala della Maglia",
			'T_Op_YDir':"Senso di Y:",
			#Buttons
			'B_Op_Lang_T':"Selezioni una lingua.",	
			'B_Op_Save':"Risparmi",
			'B_Op_Save_T':"Risparmi le vostre regolazioni",
			'B_MeshScale_T':"Sincronizzi al 'Gioco' nelle Proprieta di Vista - il defetto e 1.",
			'B_Op_YDir_T':"Lanci la maglia per - Y o senso di +Y.",
				
			#Calculator------
			#Popup Warnings
			'Cal_Reset_W':"Avvertimento! - Ripristini tutte le regolazioni??%t|Continui %x1|Arresto %x2", 	
			#Constant Text
			'Cal_T_Ledger':"Registro",
			'Cal_T_USS':"Campione Degli Stati Uniti",
			'Cal_T_Metric':"Metrico",
			'Cal_T_FTD':"Frazione del Convertito al Decimale",
			'Cal_T_DTI':"Decimale del Convertito ai Pollici",
			'Cal_T_N':"N:",
			'Cal_T_D':"D:",
			'Cal_T_Dec':"Decimale:",
			'Cal_T_In':"Pollici:",
			#Ledger
			'Cal_Deci_T':" Decimeter ",
			'Cal_Decis_T':" Decimeters ",
			'Cal_Centi_T':" Centimetro ",
			'Cal_Centis_T':" Centimetri ",
			'Cal_Milli_T':" Millimetro ",
			'Cal_Millis_T':" Millimetri ",
			#Buttons
			'CalOp_Back_D':"V I",#Vada Indietro ?
			'CalOp_Back_T':"Di nuovo all'interfaccia principale",
			'Cal_Calc_D':"Calcole",
			'Cal_Calc_TD_T':"Calcoli al decimale",
			'Cal_Calc_FD_T':"Calcoli dal decimale",
			'Cal_Reset_D':"R",#Risistemazione
			'Cal_Reset_T':"Ripristini tutti",
			'Cal_USM_D':"%t|Campione degli Stati Uniti %x1|16th's %x2|8th's %x3|4th's %x4|",
			'Cal_USM_T':"Registro Inglese (Valori Comuni)",
			'Cal_MetM_D':"%t|Metrico %x1|Millimetri %x2|Centimetri %x3|Decimeters %x4",
			'Cal_MetM_T':"Metric Ledger (Valori comuni)",
			'Cal_N_T':"Numeratore",
			'Cal_D_T':"Denominatore",
			'Cal_Dec_T':"Decimale",
		  }
		
ld = [english,espanol,francais,italiano]		
					
#########################
#End of Language section#----------------------------------------------------------------------------------------------
#########################



###############################
#Beginning of Images section  #---------------------------------------------------------------------------------------
###############################

#Images Dictionary
#===================			
Grey = {   	#Grey Rounded
			#Mesh Type
			'I_MeshType_R' : Blender.Image.Load(os.path.join(Blender.Get(r"scriptsdir"), "Mesh", "BMAE", "Image/Mesh_Type_R.png")),
			#Mesh Name
			'I_MeshName_R' : Blender.Image.Load(os.path.join(Blender.Get(r"scriptsdir"), "Mesh", "BMAE", 'Image/Mesh_Name_R.png')),
			#Size & Location Buttons
			'I_SLBtn_R' : Blender.Image.Load(os.path.join(Blender.Get(r"scriptsdir"), "Mesh", "BMAE", "Image/SL_Buttons_R.png")),
			#Grey Default
			#Mesh Type
			'I_MeshType_D' : Blender.Image.Load(os.path.join(Blender.Get(r"scriptsdir"), "Mesh", "BMAE", "Image/Mesh_Type_D.png")),
			#Mesh Name
			'I_MeshName_D' : Blender.Image.Load(os.path.join(Blender.Get(r"scriptsdir"), "Mesh", "BMAE", "Image/Mesh_Name_D.png")),
			#Size & Location Buttons
			'I_SLBtn_D' : Blender.Image.Load(os.path.join(Blender.Get(r"scriptsdir"), "Mesh", "BMAE", "Image/SL_Buttons_D.png")),
			#Button Backgrounds
			#Title
			'I_Title_BG' : Blender.Image.Load(os.path.join(Blender.Get(r"scriptsdir"), "Mesh", "BMAE", "Image/Title.png")),
			#2d & 3d
			'I_2d3d_BG' : Blender.Image.Load(os.path.join(Blender.Get(r"scriptsdir"), "Mesh", "BMAE", "Image/2d_3d_BG.png")),
			#Size
			'I_Size_BG' : Blender.Image.Load(os.path.join(Blender.Get(r"scriptsdir"), "Mesh", "BMAE", "Image/Size_BG.png")),
			#Core
			'I_Core_BG' : Blender.Image.Load(os.path.join(Blender.Get(r"scriptsdir"), "Mesh", "BMAE", "Image/Core_BG.png")),
			#Floor
			'I_Floor_BG' : Blender.Image.Load(os.path.join(Blender.Get(r"scriptsdir"), "Mesh", "BMAE", "Image/Floor_BG.png")),
			#Create & Exit
			'I_C_E_BG' : Blender.Image.Load(os.path.join(Blender.Get(r"scriptsdir"), "Mesh", "BMAE", "Image/Create_Exit_BG.png")),
			#Create & Exit Square
			'I_C_E_D_BG' : Blender.Image.Load(os.path.join(Blender.Get(r"scriptsdir"), "Mesh", "BMAE", "Image/Create_Exit_D_BG.png"))
		}
			
id = [Grey]