#########################################################
############## General initializers #####################
#########################################################
#                                                        Guns
var n_gun1_ammo_count = "ai/submodels/submodel[0]/count";
var n_gun2_ammo_count = "ai/submodels/submodel[1]/count";
#                                                        Bombs
var n_bomb1_count     = "ai/submodels/submodel[2]/count";
var n_bomb2_count     = "ai/submodels/submodel[3]/count";
#                                                        AIM9
var n_rocket1_count   = "ai/submodels/submodel[4]/count";
var n_rocket2_count   = "ai/submodels/submodel[5]/count";

#########################################################
##################### reload guns #######################
#########################################################
# Guns generally cannot be reloaded in flight.  It requires landing,
# stop, and reload before taking off again.
#
# Note that tracers are modeled as bullets that include a visual model but
# no impact.  They fire along with 1 of every three or four bullets to simulate
# a tracer round every 4 rounds.

reload_guns  = func {

  var  groundspeed = getprop("velocities/groundspeed-kt");

  # only allow it if on ground or if it's already set to unlimited mode
  if ( groundspeed < 5 or getprop( r_gun1_ammo_count) == -1 ) {

    #                                           Guns
    setprop(n_gun1_ammo_count, 400);
    setprop(n_gun2_ammo_count, 400);
    #                                           Rockets
    setprop(n_bomb1_count, 1);
    setprop(n_bomb2_count, 1);
    #                                           AIM9
    setprop(n_rocket1_count, 1);
    setprop(n_rocket2_count, 1);

    # controls/armament/trigger1
    setprop("sim/multiplay/generic/int[10]", 0);
    # controls/armament/trigger2
    setprop("sim/multiplay/generic/int[11]", 0);
    # controls/armament/trigger3
    setprop("sim/multiplay/generic/int[12]", 0);
    # controls/armament/trigger4
    setprop("sim/multiplay/generic/int[13]", 0);

    gui.popupTip ("Guns reloaded--400 rounds in each gun and bomb and rockets.", 5);
  } else {
    gui.popupTip ("You must be on the ground and engines dead stopped to re-load guns.",5);
  }
}

#########################################################
################ unlimited ammo #########################
#########################################################
# For testing only, of course!
#

unlimited_guns = func {

  var groundspeed = getprop("velocities/groundspeed-kt");

  #                                           Guns
  setprop ( n_gun1_ammo_count, -1);
  setprop ( n_gun2_ammo_count, -1);
  #                                           Rockets
  setprop(n_rocket1_count, -1);
  setprop(n_rocket2_count, -1);
  #                                           AIM9
  setprop(n_rocket1_count, -1);
  setprop(n_rocket2_count, -1);

  # controls/armament/trigger1
  setprop("sim/multiplay/generic/int[10]", 0);
  # controls/armament/trigger2
  setprop("sim/multiplay/generic/int[11]", 0);
  # controls/armament/trigger3
  setprop("sim/multiplay/generic/int[12]", 0);
  # controls/armament/trigger4
  setprop("sim/multiplay/generic/int[13]", 0);

  gui.popupTip ("Guns bomb and rockets set to unlimited mode--definitely not realistic and only for testing!  Select 'Reload Guns' to revert to limited ammo.",7);
}
