# Simulation of Alpha Electro Altimeter (ALT) by Bea Wolf (D-ECHO) based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)

#Information based on manual http://www.flypipistrel.com/manuals/ALPHA%20ELECTRO%20POH%20A02.pdf
#######################################

var ALT_main = nil;
var ALT_display = nil;

var base = "/instrumentation/airspeed-indicator/";
var inputs = base~"inputs/";

var ALT = props.globals.getNode("instrumentation/altimeter/indicated-altitude-ft", 1);
var ALT_qnh = props.globals.getNode("instrumentation/altimeter/setting-hpa", 1);
var ALT_fl = props.globals.getNode("instrumentation/altimeter/mode-c-alt-ft", 1);

var volt_prop = "systems/electrical/outputs/instruments";

var instrument_dir = "Aircraft/AlphaElectro/Models/Instruments/ALT/";


var canvas_ALT_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		 var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var svg_keys = me.getKeys();
			foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var volt = getprop(volt_prop) or 0;
		
		if ( volt > 10) {
			ALT_main.page.show();
		} else {
			ALT_main.page.hide();
		}
		
		settimer(func me.update(), 0.02);
	},
};
	
	
var canvas_ALT_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_ALT_main , canvas_ALT_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["qnh","flightlevel","alt"];
	},
	update: func() {
		
		#Altitude
		var altitude = ALT.getValue();
		var fl = ALT_fl.getValue();
		
		me["alt"].setText(sprintf("%5d", math.round(altitude)));
		me["qnh"].setText(sprintf("%4d", math.round(ALT_qnh.getValue()))); 
		me["flightlevel"].setText(sprintf("%03d", math.round(fl/100))); 
		
		
		
		settimer(func me.update(), 0.02);
	}
	
};




setlistener("sim/signals/fdm-initialized", func {
	ALT_display = canvas.new({
		"name": "ALT",
		"size": [320, 240],
		"view": [320, 240],
		"mipmapping": 1
	});
	ALT_display.addPlacement({"node": "ALT.screen"});
	var groupMain = ALT_display.createGroup();


	ALT_main = canvas_ALT_main.new(groupMain, instrument_dir~"ALT_main.svg");

	ALT_main.update();
	canvas_ALT_base.update();
});

var showALT = func {
	var dlg = canvas.Window.new([320, 240], "dialog").set("resize", 1);
	dlg.setCanvas(ALT_display);
}

	
