# Pipistrel EPSI 570 EIS by D-ECHO based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)
#######################################

var epsi570_flight = nil;
var epsi570_system = nil;
var epsi570_start = nil;
var epsi570_display = nil;


var groupMain = nil;

var base = "/instrumentation/epsi570/";


var page_prop = base~"page";

var qnh_hpa = "instrumentation/altimeter/setting-hpa";


var start_prop = base~"start";
var volt_prop = "/systems/electrical/outputs/eis";
var brightness_prop = base~"brightness";

var charge_front = props.globals.getNode("/systems/electrical/battery-charge-percent-front", 1);
var charge_rear = props.globals.getNode("/systems/electrical/battery-charge-percent-back", 1);

var environment_temp = props.globals.getNode("/environment/temperature-degc", 1);
var ac_volts = props.globals.getNode("/systems/electrical/ac-volts", 1);
var ac_amps = props.globals.getNode("/systems/electrical/ac-amps", 1);
var dc_volts = props.globals.getNode("/systems/electrical/dc-volts", 1);
var dc_amps = props.globals.getNode("/systems/electrical/dc-amps", 1);

var engine_rpm = props.globals.getNode("/engines/engine[0]/thruster/rpm", 1);

var throttle_raw = props.globals.getNode("/fdm/jsbsim/fcs/epsi570/throttle-system-raw", 1);
var throttle_final = props.globals.getNode("/fdm/jsbsim/fcs/epsi570/throttle-system-final", 1);
var seenzero = props.globals.getNode("/fdm/jsbsim/fcs/epsi570/enable-throttle", 1);


#roundToNearest function used for alt tape, thanks @Soitanen (737-800)!
var roundToNearest = func(n, m) {
	var x = int(n/m)*m;
	if((math.mod(n,m)) > (m/2) and n > 0)
			x = x + m;
	if((m - (math.mod(n,m))) > (m/2) and n < 0)
			x = x - m;
	return x;
}


var canvas_epsi570_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "Orbitron/Orbitron-Bold.ttf";
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var svg_keys = me.getKeys();
			foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
			}
		}
		
		if(me["horizon"]!=nil) {
			me.h_trans = me["horizon"].createTransform();
			me.h_rot = me["horizon"].createTransform();
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var volts = getprop(volt_prop) or 0;
		var start = getprop(start_prop) or 0;
		if ( volts > 10 and start == 1) {
			epsi570_start.page.hide();
			var act_page = getprop(page_prop);
			if(act_page=="flight"){
				epsi570_flight.page.show();
				epsi570_flight.update();
				epsi570_system.page.hide();
			}else{
				epsi570_flight.page.hide();
				epsi570_system.page.show();
				epsi570_system.update();
			}
		} else if ( volts > 10 and start != 0 and start != 1 ){
			epsi570_flight.page.hide();
			epsi570_system.page.hide();
			epsi570_start.page.show();
		} else {
			epsi570_flight.page.hide();
			epsi570_system.page.hide();
			epsi570_start.page.hide();
		}
		
		settimer(func me.update(), 0.02);
	},
};
	
	
var canvas_epsi570_flight = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_epsi570_flight , canvas_epsi570_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["rpm.needle","rpm.digits","rpm.fill1","rpm.fill2","rpm.fill3","aux.batt.volts","battery.volts","chargeF.bar","chargeF.digits","chargeR.bar","chargeR.digits","power.digits","power.fill1","power.fill2","power.fill3","power.needle"];
	},
	update: func() {
		
		var rpm = engine_rpm.getValue();
		me["rpm.digits"].setText(sprintf("%4d", math.round(rpm, 10)));
		var rpm_deg = rpm/2500 * 250;
		
		me["rpm.needle"].setRotation(rpm_deg*D2R);
		if(rpm_deg <= 45){
			me["rpm.fill1"].setRotation(rpm_deg*D2R);
			me["rpm.fill2"].setRotation(0);
			me["rpm.fill3"].setRotation(0);
		}else if(rpm_deg <=135){
			me["rpm.fill1"].setRotation(45*D2R);
			me["rpm.fill2"].setRotation((rpm_deg-45)*D2R);
			me["rpm.fill3"].setRotation(0);
		}else{
			me["rpm.fill1"].setRotation(45*D2R);
			me["rpm.fill2"].setRotation(90*D2R);
			me["rpm.fill3"].setRotation((rpm_deg-135)*D2R);
		}
			
		
		
		var battery_charge_front = charge_front.getValue();
		var battery_charge_rear = charge_rear.getValue();
		
		me["chargeF.digits"].setText(sprintf("%3d", math.round(battery_charge_front*100)));
		me["chargeR.digits"].setText(sprintf("%3d", math.round(battery_charge_rear*100)));
		me["chargeF.bar"].setTranslation(0, (1-battery_charge_front)*200);
		me["chargeR.bar"].setTranslation(0, (1-battery_charge_rear)*200);
		
		var battery_volts = getprop("/systems/electrical/ac-volts") or 0;
		me["battery.volts"].setText(sprintf("%3d", math.round(battery_volts))~" V");
		
		var dc_volts = getprop("/systems/electrical/dc-volts") or 0;
		me["aux.batt.volts"].setText(sprintf("%4.2f", dc_volts)~" V");
		
		var power_kw = (getprop("/fdm/jsbsim/propulsion/engine[0]/power-hp") or 0) * 0.7457;
		
		me["power.digits"].setText(sprintf("%2d", math.round(power_kw)));
		
		var power_deg = power_kw/60 * 202; 
		
		me["power.needle"].setRotation(power_deg*D2R);
		
		if(power_deg>0 and power_deg<=90){
			me["power.fill1"].setRotation(power_deg*D2R);
			me["power.fill2"].setRotation(0);
			me["power.fill3"].setRotation(0);
		}else if(power_deg>90){
			me["power.fill1"].setRotation(90*D2R);
			me["power.fill2"].setRotation((power_deg-90)*D2R);
			me["power.fill3"].setRotation(0);
		}else if(power_deg<=0){
			me["power.fill1"].setRotation(0);
			me["power.fill2"].setRotation(0);
			me["power.fill3"].setRotation(power_deg*D2R);
		}
	}
	
};


var canvas_epsi570_start = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_epsi570_start , canvas_epsi570_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
	}
	
};

var canvas_epsi570_system = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_epsi570_system , canvas_epsi570_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["battery.front.mode","battery.front.socsoh","battery.front.maxtemp","battery.front.minu","battery.front.maxu","battery.front.busu","battery.front.battu","battery.front.batti","battery.front.pcerr","battery.front.balancing","battery.front.uptime","battery.rear.mode","battery.rear.socsoh","battery.rear.maxtemp","battery.rear.minu","battery.rear.maxu","battery.rear.busu","battery.rear.battu","battery.rear.batti","battery.rear.pcerr","battery.rear.balancing","battery.rear.uptime","drive.nmtstate","drive.status","drive.tempmi","drive.rpm","drive.coolant","drive.hobbs","dcdc.presence","dcdc.state","dcdc.outputu","dcdc.outputi","dcdc.inputu","dcdc.inputi","powerlever.presence","powerlever.output","powerlever.scaled","powerlever.final","powerlever.seenzero"];
	},
	update: func() {
		var acv = ac_volts.getValue();
		var aca = ac_amps.getValue();
		
		me["battery.front.mode"].setText("Active"); #TODO Program modes correctly (Ready, Active, Error)
		me["battery.front.socsoh"].setText(sprintf("%3d",charge_front.getValue()*100)~"/99"); #TODO Calculate and display State of Health (SOH)
		me["battery.front.maxtemp"].setText(sprintf("%2d", environment_temp.getValue() + 10)~"° (0)"); #TODO Calculate battery temperature correctly
		me["battery.front.minu"].setText("4100mV");
		me["battery.front.maxu"].setText("4100mV");
		me["battery.front.busu"].setText(sprintf("%4.1f",acv/2)~"V");
		me["battery.front.battu"].setText(sprintf("%4.1f",acv/2)~"V");
		me["battery.front.batti"].setText(sprintf("%3.1f",aca/2)~"A");
		me["battery.front.pcerr"].setText("0");
		me["battery.front.balancing"].setText("0");
		me["battery.front.uptime"].setText("1234"); #TODO calculate uptime correctly
		
		me["battery.rear.mode"].setText("Active"); #TODO Program modes correctly (Ready, Active, Error)
		me["battery.rear.socsoh"].setText(sprintf("%3d",charge_rear.getValue()*100)~"/99"); #TODO Calculate and display State of Health (SOH)
		me["battery.rear.maxtemp"].setText(sprintf("%2d", environment_temp.getValue() + 10)~"° (0)"); #TODO Calculate battery temperature correctly
		me["battery.rear.minu"].setText("4100mV");
		me["battery.rear.maxu"].setText("4100mV");
		me["battery.rear.busu"].setText(sprintf("%4.1f",acv/2)~"V");
		me["battery.rear.battu"].setText(sprintf("%4.1f",acv/2)~"V");
		me["battery.rear.batti"].setText(sprintf("%3.1f",aca/2)~"A");
		me["battery.rear.pcerr"].setText("0");
		me["battery.rear.balancing"].setText("0");
		me["battery.rear.uptime"].setText("1234"); #TODO calculate uptime correctly
		
		
		me["drive.nmtstate"].setText("1"); 	#TODO: What is this?
		me["drive.status"].setText("63");	#TODO: What is this?
		me["drive.tempmi"].setText("35°/35°");	#TODO Calculate Motor (first value) and power controller (second value) temperatures correctly
		me["drive.rpm"].setText(sprintf("%4d", engine_rpm.getValue())~"/min");
		me["drive.coolant"].setText("54°/60°");	#TODO Calculate coolant temperatures correctly (first=after second=before cooler)
		me["drive.hobbs"].setText("1234min");	#TODO calculate hobbs correctly (of power controller)
		
		
		me["dcdc.presence"].setText("yes");	#TODO code correctly
		me["dcdc.state"].setText("1");		#TODO: What is this?
		me["dcdc.outputu"].setText(sprintf("%2.1f", dc_volts.getValue())~"V");
		me["dcdc.outputi"].setText(sprintf("%2.1f", dc_amps.getValue())~"A");
		me["dcdc.inputu"].setText(sprintf("%4.1f", acv)~"V");
		me["dcdc.inputi"].setText(sprintf("%2.1f", aca)~"A");
		
		
		me["powerlever.presence"].setText("yes");	#TODO code correctly
		var throttle_raw_value = throttle_raw.getValue();
		me["powerlever.output"].setText(sprintf("%4d", throttle_raw_value));
		me["powerlever.scaled"].setText(sprintf("%4d", throttle_raw_value));	#TODO apply conversion map
		me["powerlever.final"].setText(sprintf("%4d", throttle_final.getValue()));
		if(seenzero.getValue()){
			me["powerlever.seenzero"].setText("yes");
		}else{
			me["powerlever.seenzero"].setText("no");
		}
	}
	
};




setlistener("sim/signals/fdm-initialized", func {
	epsi570_display = canvas.new({
		"name": "EPSI570",
		"size": [1024, 776],
		"view": [1024, 776],
		"mipmapping": 1
	});
	epsi570_display.addPlacement({"node": "EPSI570.screen"});
	var groupFlight = epsi570_display.createGroup();
	var groupSystem = epsi570_display.createGroup();
	var groupStart = epsi570_display.createGroup();


	epsi570_flight = canvas_epsi570_flight.new(groupFlight, "Aircraft/AlphaElectro/Models/Instruments/EPSI570/epsi570-flight.svg");
	epsi570_system = canvas_epsi570_system.new(groupSystem, "Aircraft/AlphaElectro/Models/Instruments/EPSI570/epsi570-system.svg");
	epsi570_start = canvas_epsi570_start.new(groupStart, "Aircraft/AlphaElectro/Models/Instruments/EPSI570/epsi570-start.svg");
	canvas_epsi570_base.update();
});


var showEPSI570 = func {
	var dlg = canvas.Window.new([320, 243], "dialog").set("resize", 1);
	dlg.setCanvas(epsi570_display);
}

var not_yet_started=1;

var power_btn = func (){
	if(not_yet_started==1 and getprop(volt_prop)>10){
		not_yet_started=0;
		interpolate(start_prop, 1, 3);
	}else if(not_yet_started==0){
		not_yet_started=1;
		setprop(start_prop, 0);
	}
}

setlistener(volt_prop, func(i){
	if(i.getValue() < 10){
		#reset
		not_yet_started=1;
		setprop(start_prop, 0);
	}
});

