# Simulation of Alpha Electro HORIS by Bea Wolf (D-ECHO) based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)

#Information based on manual https://www.kanardia.eu/wp-content/uploads/2019/01/HorisManual.pdf
#######################################

var HORIS_adahrs = nil;
var HORIS_display = nil;

var base = "/instrumentation/airspeed-indicator/";
var inputs = base~"inputs/";

var AI_pitch = props.globals.getNode("orientation/pitch-deg", 1);
var AI_roll = props.globals.getNode("orientation/roll-deg", 1);

var ASI_ias = props.globals.getNode("instrumentation/airspeed-indicator/indicated-speed-kt", 1);
var ASI_tas = props.globals.getNode("instrumentation/airspeed-indicator/true-speed-kt", 1);

var ALT = props.globals.getNode("instrumentation/altimeter/indicated-altitude-ft", 1);
var ALT_qnh = props.globals.getNode("instrumentation/altimeter/setting-hpa", 1);

var WIND_hdg = props.globals.getNode("environment/wind-from-heading-deg", 1);
var WIND_speed = props.globals.getNode("environment/wind-speed-kt", 1);

var HDG = props.globals.getNode("orientation/heading-deg", 1);

var OAT_degc = props.globals.getNode("environment/temperature-degc", 1);

var SLIPSKID = props.globals.getNode("instrumentation/slip-skid-ball/indicated-slip-skid", 1);

var VS = props.globals.getNode("instrumentation/vertical-speed-indicator/indicated-speed-fpm", 1);

var volt_prop = "systems/electrical/outputs/instruments";

var instrument_dir = "Aircraft/AlphaElectro/Models/Instruments/HORIS/";




#roundToNearest function used for alt tape, thanks @Soitanen (737-800)!
var roundToNearest = func(n, m) {
	var x = int(n/m)*m;
	if((math.mod(n,m)) > (m/2) and n > 0)
			x = x + m;
	if((m - (math.mod(n,m))) > (m/2) and n < 0)
			x = x - m;
	return x;
}

var canvas_HORIS_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			if(weight=="bold"){
				return "LiberationFonts/LiberationSans-Bold.ttf";
			}else{
				return "LiberationFonts/LiberationSans-Regular.ttf";
			}
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		 var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var svg_keys = me.getKeys();
			foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
			}
		}
		
		me.h_trans = me["horizon"].createTransform();
		me.h_rot = me["horizon"].createTransform();

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var volt = getprop(volt_prop) or 0;
		
		if ( volt > 10) {
			HORIS_adahrs.page.show();
		} else {
			HORIS_adahrs.page.hide();
		}
		
		settimer(func me.update(), 0.02);
	},
};
	
	
var canvas_HORIS_adahrs = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_HORIS_adahrs , canvas_HORIS_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["horizon","rollpointer","ias.digits","tas.digits","asi.tape","alt.digits.small","alt.digits.big","qnh.digits","wind.digits","wind.arrow","heading.digits","oat.digits","ball","vs.digits","altTapeScale","altTextHigh1","altTextHigh2","altTextHigh3","altTextHigh4","altTextHigh5","altTextHigh6","altTextHigh7","altTextHigh8","altTextHigh9",
		"altTextLow1","altTextLow2","altTextLow3","altTextLow4","altTextLow5","altTextLow6","altTextLow7","altTextLow8",
		"altTextHighSmall2","altTextHighSmall3","altTextHighSmall4","altTextHighSmall5","altTextHighSmall6","altTextHighSmall7","altTextHighSmall8","altTextHighSmall9",
		"altTextLowSmall1","altTextLowSmall2","altTextLowSmall3","altTextLowSmall4","altTextLowSmall5","altTextLowSmall6","altTextLowSmall7","altTextLowSmall8"];
	},
	update: func() {
		
		#Attitude Indicator
		var pitch = AI_pitch.getValue();
		var roll =  AI_roll.getValue();
		
		me.h_trans.setTranslation(0,pitch*3.36);
		me.h_rot.setRotation(-roll*D2R,me["horizon"].getCenter());
		
		if(roll<45 and roll>-45){
			me["rollpointer"].setRotation(-roll*D2R);
		}
		
		#Airspeed
		var ias = ASI_ias.getValue();
		var tas = ASI_tas.getValue();
		
		me["ias.digits"].setText(sprintf("%3d", math.round(ias)));
		me["asi.tape"].setTranslation(0,ias*2.95);
		me["tas.digits"].setText(sprintf("%3d", math.round(tas)));
		
		#Altitude
		var altitude = ALT.getValue();
		var qnh = ALT_qnh.getValue();
		
		me["alt.digits.big"].setText(sprintf("%3d", math.floor(altitude/100, 1)));
		me["alt.digits.small"].setText(sprintf("%3d", 100*math.mod(altitude/100, 1)));
		me["qnh.digits"].setText(sprintf("%4d", math.round(qnh)));
		
		#Alt Tape
		me["altTapeScale"].setTranslation(0,(altitude - roundToNearest(altitude, 1000))*0.33);
		
		if (roundToNearest(altitude, 1000) == 0) {
			me["altTextLowSmall1"].setText(sprintf("%0.0f",100));
			me["altTextLowSmall2"].setText(sprintf("%0.0f",200));
			me["altTextLowSmall3"].setText(sprintf("%0.0f",300));
			me["altTextLowSmall4"].setText(sprintf("%0.0f",400));
			me["altTextLowSmall5"].setText(sprintf("%0.0f",500));
			me["altTextLowSmall6"].setText(sprintf("%0.0f",600));
			me["altTextLowSmall7"].setText(sprintf("%0.0f",700));
			me["altTextLowSmall8"].setText(sprintf("%0.0f",800));
			me["altTextHighSmall2"].setText(sprintf("%0.0f",100));
			me["altTextHighSmall3"].setText(sprintf("%0.0f",200));
			me["altTextHighSmall4"].setText(sprintf("%0.0f",300));
			me["altTextHighSmall5"].setText(sprintf("%0.0f",400));
			me["altTextHighSmall6"].setText(sprintf("%0.0f",500));
			me["altTextHighSmall7"].setText(sprintf("%0.0f",600));
			me["altTextHighSmall8"].setText(sprintf("%0.0f",700));
			me["altTextHighSmall9"].setText(sprintf("%0.0f",800));
			var altNumLow = "-";
			var altNumHigh = "";
			var altNumCenter = altNumHigh;
		} elsif (roundToNearest(altitude, 1000) > 0) {
			me["altTextLowSmall1"].setText(sprintf("%0.0f",900));
			me["altTextLowSmall2"].setText(sprintf("%0.0f",800));
			me["altTextLowSmall3"].setText(sprintf("%0.0f",700));
			me["altTextLowSmall4"].setText(sprintf("%0.0f",600));
			me["altTextLowSmall5"].setText(sprintf("%0.0f",500));
			me["altTextLowSmall6"].setText(sprintf("%0.0f",400));
			me["altTextLowSmall7"].setText(sprintf("%0.0f",300));
			me["altTextLowSmall8"].setText(sprintf("%0.0f",200));
			me["altTextHighSmall2"].setText(sprintf("%0.0f",100));
			me["altTextHighSmall3"].setText(sprintf("%0.0f",200));
			me["altTextHighSmall4"].setText(sprintf("%0.0f",300));
			me["altTextHighSmall5"].setText(sprintf("%0.0f",400));
			me["altTextHighSmall6"].setText(sprintf("%0.0f",500));
			me["altTextHighSmall7"].setText(sprintf("%0.0f",600));
			me["altTextHighSmall8"].setText(sprintf("%0.0f",700));
			me["altTextHighSmall9"].setText(sprintf("%0.0f",800));
			var altNumLow = roundToNearest(altitude, 1000)/1000 - 1;
			var altNumHigh = roundToNearest(altitude, 1000)/1000;
			var altNumCenter = altNumHigh;
		} elsif (roundToNearest(altitude, 1000) < 0) {
			me["altTextLowSmall1"].setText(sprintf("%0.0f",100));
			me["altTextLowSmall2"].setText(sprintf("%0.0f",200));
			me["altTextLowSmall3"].setText(sprintf("%0.0f",300));
			me["altTextLowSmall4"].setText(sprintf("%0.0f",400));
			me["altTextLowSmall5"].setText(sprintf("%0.0f",500));
			me["altTextLowSmall6"].setText(sprintf("%0.0f",600));
			me["altTextLowSmall7"].setText(sprintf("%0.0f",700));
			me["altTextLowSmall8"].setText(sprintf("%0.0f",800));
			me["altTextHighSmall2"].setText(sprintf("%0.0f",900));
			me["altTextHighSmall3"].setText(sprintf("%0.0f",800));
			me["altTextHighSmall4"].setText(sprintf("%0.0f",700));
			me["altTextHighSmall5"].setText(sprintf("%0.0f",600));
			me["altTextHighSmall6"].setText(sprintf("%0.0f",500));
			me["altTextHighSmall7"].setText(sprintf("%0.0f",400));
			me["altTextHighSmall8"].setText(sprintf("%0.0f",300));
			me["altTextHighSmall9"].setText(sprintf("%0.0f",200));
			var altNumLow = roundToNearest(altitude, 1000)/1000;
			var altNumHigh = roundToNearest(altitude, 1000)/1000 + 1;
			var altNumCenter = altNumLow;
		}
		if ( altNumLow == 0 ) {
			altNumLow = "";
		}
		if ( altNumHigh == 0 and altitude < 0) {
			altNumHigh = "-";
		}
		me["altTextLow1"].setText(sprintf("%s", altNumLow));
		me["altTextLow2"].setText(sprintf("%s", altNumLow));
		me["altTextLow3"].setText(sprintf("%s", altNumLow));
		me["altTextLow4"].setText(sprintf("%s", altNumLow));
		me["altTextLow5"].setText(sprintf("%s", altNumLow));
		me["altTextLow6"].setText(sprintf("%s", altNumLow));
		me["altTextLow7"].setText(sprintf("%s", altNumLow));
		me["altTextLow8"].setText(sprintf("%s", altNumLow));
		me["altTextHigh1"].setText(sprintf("%s", altNumCenter));
		me["altTextHigh2"].setText(sprintf("%s", altNumHigh));
		me["altTextHigh3"].setText(sprintf("%s", altNumHigh));
		me["altTextHigh4"].setText(sprintf("%s", altNumHigh));
		me["altTextHigh5"].setText(sprintf("%s", altNumHigh));
		me["altTextHigh6"].setText(sprintf("%s", altNumHigh));
		me["altTextHigh7"].setText(sprintf("%s", altNumHigh));
		me["altTextHigh8"].setText(sprintf("%s", altNumHigh));
		me["altTextHigh9"].setText(sprintf("%s", altNumHigh));
		
		#Heading
		var heading = HDG.getValue();
		
		me["heading.digits"].setText(sprintf("%3d", math.round(heading)));
		
		#Wind Indication
		var wind_from = WIND_hdg.getValue();
		var wind_relative = heading -  wind_from;
		var wind_kts = WIND_speed.getValue();
		
		me["wind.digits"].setText(sprintf("%2d", math.round(wind_kts))~"/"~sprintf("%3d", math.round(wind_from))~"°");
		me["wind.arrow"].setRotation(wind_relative * -D2R);
		
		#OAT
		var temp = OAT_degc.getValue();
		
		me["oat.digits"].setText(sprintf("%2d", math.round(temp)));
		
		#Ball/Slip-Skid
		var slsk = SLIPSKID.getValue();
		
		me["ball"].setTranslation(slsk*-25, 0);
		
		#Vertical Speed
		var vs_fpm = VS.getValue();
		
		me["vs.digits"].setText(sprintf("%3.1f", vs_fpm/1000));
		
		settimer(func me.update(), 0.02);
	}
	
};




setlistener("sim/signals/fdm-initialized", func {
	HORIS_display = canvas.new({
		"name": "HORIS",
		"size": [320, 240],
		"view": [320, 240],
		"mipmapping": 1
	});
	HORIS_display.addPlacement({"node": "HORIS.screen"});
	var groupMain = HORIS_display.createGroup();


	HORIS_adahrs = canvas_HORIS_adahrs.new(groupMain, instrument_dir~"HORIS_ADAHRS.svg");

	HORIS_adahrs.update();
	canvas_HORIS_base.update();
});

var showHORIS = func {
	var dlg = canvas.Window.new([320, 240], "dialog").set("resize", 1);
	dlg.setCanvas(HORIS_display);
}

	
