# Simulation of Alpha Electro Variometer (VSI) by Bea Wolf (D-ECHO) based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)

#Information based on manual http://www.flypipistrel.com/manuals/ALPHA%20ELECTRO%20POH%20A02.pdf
#######################################

var VSI_main = nil;
var VSI_display = nil;

var VSI = props.globals.getNode("instrumentation/vertical-speed-indicator/indicated-speed-fpm", 1);

var volt_prop = "systems/electrical/outputs/instruments";

var instrument_dir = "Aircraft/AlphaElectro/Models/Instruments/VSI/";


var canvas_VSI_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		 var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var svg_keys = me.getKeys();
			foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var volt = getprop(volt_prop) or 0;
		
		if ( volt > 10) {
			VSI_main.page.show();
		} else {
			VSI_main.page.hide();
		}
		
		settimer(func me.update(), 0.02);
	},
};
	
	
var canvas_VSI_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_VSI_main , canvas_VSI_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["vario"];
	},
	update: func() {
		
		#Altitude
		var vsi_val = VSI.getValue();
		
		me["vario"].setText(sprintf("%5d", math.round(vsi_val,50)));
		
		
		
		settimer(func me.update(), 0.02);
	}
	
};




setlistener("sim/signals/fdm-initialized", func {
	VSI_display = canvas.new({
		"name": "VSI",
		"size": [320, 240],
		"view": [320, 240],
		"mipmapping": 1
	});
	VSI_display.addPlacement({"node": "VSI.screen"});
	var groupMain = VSI_display.createGroup();


	VSI_main = canvas_VSI_main.new(groupMain, instrument_dir~"VSI_main.svg");

	VSI_main.update();
	canvas_VSI_base.update();
});

var showVSI = func {
	var dlg = canvas.Window.new([320, 240], "dialog").set("resize", 1);
	dlg.setCanvas(VSI_display);
}

	
