var airspeed = props.globals.getNode("/velocities/airspeed-kt", 1);
var bugs = props.globals.getNode("/sim/model/bugs", 1);
var was_active = 0;
var elapsed_time = props.globals.getNode("/sim/time/elapsed-sec", 1);
var bug_timer = nil;

var update_bugs = func () {
	if ( airspeed.getValue() > 30 ) {
		bugs.setValue(bugs.getValue() + ((elapsed_time.getValue() - last_time) / (3600 * 5))); # reach full bug coverage after 5 hours of flight
	}
	last_time = elapsed_time.getValue();
}

setlistener("/sim/signals/fdm-initialized", func() {
	bug_timer = maketimer(2, update_bugs);
	bug_timer.simulatedTime = 1;
	bug_timer.start();
	print("Bugs initialized");
});
