# All Engine-related nasal functions go here

var engine_master = props.globals.getNode("/controls/engines/engine[0]/master", 1);
var glow = props.globals.getNode("/engines/engine[0]/glow", 1);
var glow_volts = props.globals.getNode("/systems/electrical/outputs/glow", 1);
var run2 = props.globals.getNode("/engines/engine[0]/running-2", 1);

setlistener(engine_master, func {
	settimer(glow_func, 0.2);
});

var glow_func = func {
	if( engine_master.getValue() == 1 and glow.getValue() != 1 and glow_volts.getValue() > 9 ) {
		interpolate(glow, 1, 4);
	} else if ( ( engine_master.getValue() == 0 or glow_volts.getValue() < 9 ) and glow.getValue() != 0 ){
		interpolate(glow, 0, 4);
	}
}

var hobbs = props.globals.getNode("/engines/engine[0]/hobbs", 1);
var eng_running = props.globals.getNode("/engines/engine[0]/running", 1);
var elapsed_time = props.globals.getNode("/sim/time/elapsed-sec", 1);
var hobbs_running = 0;

var update_hobbs = maketimer(2, func (){
	if(eng_running.getValue()){
		hobbs.setValue(hobbs.getValue()+((elapsed_time.getValue()-last_time)/3600));
		last_time = elapsed_time.getValue();
	}else{
		hobbs_running=0;
		update_hobbs.stop();
	}
});

setlistener("/engines/engine[0]/running", func(i){
	if(hobbs_running == 0 and i.getValue()==1){
		hobbs_running=1;
		last_time = elapsed_time.getValue();
		update_hobbs.start();
	}
	if(i.getValue() == 1){
		settimer(func() {
			run2.setBoolValue(1)
		},	0.945);
	}else{
		run2.setBoolValue(0);
	}
});
