##################################################################
####      autostart.nas - ePilot                              ####
####                                                          ####
####    Provides Auto-Start and Auto-Shutdown                 ####
####                                                          ####
##################################################################

# Autostart #

var autostart = func {

var leftempty=getprop("/consumables/fuel/tank[0]/empty");
var rightempty=getprop("/consumables/fuel/tank[1]/empty");
if ( (!leftempty) or (!rightempty) ) {

  setprop("/sim/input/selected/engine[0]",1);
  setprop("/sim/input/selected/engine[1]",1);

  setprop("/controls/engines/engine[0]/propeller-pitch", 1);
  setprop("/controls/engines/engine[1]/propeller-pitch", 1);

  setprop("/controls/electric/battery-switch",1);
  setprop("/controls/electric/engine[0]/generator",1);
  setprop("/controls/electric/engine[1]/generator",1);
  setprop("/controls/electric/inv1-switch",1);
  setprop("/controls/electric/inv2-switch",1);
  setprop("/controls/electric/inv3-switch",1);
  setprop("/controls/electric/avionics-pwr-switch",1);
  setprop("/controls/fuel/lsel-main",1);
  setprop("/controls/fuel/lsel-off",0);
  setprop("/controls/fuel/internal/LSEL",0);
  setprop("/controls/fuel/rsel-main",1);
  setprop("/controls/fuel/rsel-off",0);
  setprop("/controls/fuel/internal/RSEL",1);

  setprop("/controls/engines/engine[0]/mixture",1);
  setprop("/controls/engines/engine[1]/mixture",1);

  setprop("/controls/engines/engine[0]/magnetos",3);
  setprop("/controls/engines/engine[1]/magnetos",3);

  setprop("/controls/engines/engine[0]/starter",1);
  setprop("/controls/engines/engine[1]/starter",1);

  setprop("/controls/engines/engine[0]/cutoff",1);
  setprop("/controls/engines/engine[1]/cutoff",1);

  setprop("/controls/GustLock/lock-open",1);

  if (getprop("/engines/engine[0]/running") == 1) {
#    setprop("/controls/electric/battery-switch",0);
    setprop("/controls/electric/avionics-pwr-switch",1);
    setprop("/controls/engines/engine[0]/starter",0);
    setprop("/controls/engines/engine[1]/starter",0);

    setprop("/controls/engines/autostart",0);
  }

  if (getprop("/engines/engine[0]/running") == 0) settimer(autostart,0);

  }
}

# Shutdown #

var autoshutdown = func {
    setprop("/controls/engines/engine[0]/propeller-pitch",0);
    setprop("/controls/electric/battery-switch",0);
    setprop("/controls/electric/engine[0]/generator",1);
    setprop("/controls/electric/engine[1]/generator",1);
    setprop("/controls/electric/inv1-switch",0);
    setprop("/controls/electric/inv2-switch",0);
    setprop("/controls/electric/inv3-switch",0);
    setprop("/controls/electric/avionics-pwr-switch",0);
    setprop("systems/electrical/on", 0);

    setprop("/controls/engines/engine[0]/starter",0);
    setprop("/controls/engines/engine[1]/starter",0);

    setprop("/controls/fuel/lsel-main",0);
    setprop("/controls/fuel/lsel-off",1);
    setprop("/controls/fuel/internal/LSEL",-1);

    setprop("/controls/fuel/rsel-main",0);
    setprop("/controls/fuel/rsel-off",1);
    setprop("/controls/fuel/internal/RSEL",-1);

    setprop("/controls/engines/engine[0]/mixture",1);
    setprop("/controls/engines/engine[1]/mixture",1);

    setprop("/controls/engines/engine[0]/magnetos",0);
    setprop("/controls/engines/engine[1]/magnetos",0);

    setprop("/controls/engines/engine[0]/cutoff",0);
    setprop("/controls/engines/engine[1]/cutoff",0);

    setprop("/controls/GustLock/lock-open",0);
}

