####################################
####	DG-505 Elan Orion	####
####################################

##	Liveries	##
aircraft.livery.init("Aircraft/DG-505/Models/Liveries");

##	Instruments	##
# Load vario instrument for the mechanical vario-5stv5
# (the following code is based on the ILEC SC7 e-vario)
io.include("Aircraft/Generic/soaring-instrumentation-sdk.nas");

var probe = TotalEnergyProbe.new();

var vario_needle = Dampener.new(
	input: probe,
	dampening: 2.7,
	on_update: update_prop("/instrumentation/variometer/te-reading-mps"));

var lx8080_te_vario = Dampener.new(
	input: probe,
	dampening: 2.7,
	on_update: update_prop("/instrumentation/lx8080/te-reading-mps"));

# Wrap everything together into an instrument
var fast_instruments = UpdateLoop.new(
	update_period: 0,
	components: [probe, vario_needle],
	enable: 1);

# Vibrating yaw string
var yawstring_front = YawString.new(
	on_update: update_prop("instrumentation/yaw-string[0]/deflection-deg"), 
	n: 0);
var yawstring_rear = YawString.new(
	on_update: update_prop("instrumentation/yaw-string[1]/deflection-deg"), 
	n: 1);

var string_instrument = Instrument.new(
	components: [yawstring_front, yawstring_rear],
	enable: 1);

##	Water Ballast	##
var tank_outflow_rate = [
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/outflow-rate-pps[0]"),
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/outflow-rate-pps[1]"),
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/outflow-rate-pps[2]"),
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/outflow-rate-pps[3]"),
];
var tank_level_p = [
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[4]"),
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[5]"),
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[6]"),
];
var tank_level_lbs = [ 0.0, 0.0, 0.0, ];
var delta_time = props.globals.getNode("/sim/time/delta-sec");

var update_waterballast = func () {
	var dt = delta_time.getDoubleValue();
	for( var i=0; i<=2; i=i+1 ){
		tank_level_lbs[ i ] = tank_level_p[ i ].getDoubleValue();
		tank_level_p[ i ].setDoubleValue( math.max( tank_level_lbs[ i ] - tank_outflow_rate[ i ].getDoubleValue()  * dt, 0.0 ) );
	}
}
var waterballast_timer = maketimer( 0.0, update_waterballast );
waterballast_timer.simulatedTime = 1;


##	Start updates when FDM is initialized	##
var ls = setlistener("/sim/signals/fdm-initialized", func() {
	waterballast_timer.start();
	removelistener( ls );
});
