################################################################################################
#
# calculate CG position and convert units
#
################################################################################################

var weight_and_balance = func {

  # ------------------------  convert units  ------------------------
  
  var weight_empty_lbs = getprop("/fdm/jsbsim/inertia/empty-weight-lbs");
  var weight_empty_kg = weight_empty_lbs * LB2KG;
  setprop("/fdm/jsbsim/inertia/empty-weight-kg",weight_empty_kg);
 
  var weight_pilot_kg = getprop("/fdm/jsbsim/inertia/pointmass-weight-kg[0]");
  var weight_pilot_lbs = weight_pilot_kg * KG2LB;
  setprop("/fdm/jsbsim/inertia/pointmass-weight-lbs[0]",weight_pilot_lbs) ;

  var weight_co_pilot_kg = getprop("/fdm/jsbsim/inertia/pointmass-weight-kg[1]");
  var weight_co_pilot_lbs = weight_co_pilot_kg * KG2LB;
  setprop("/fdm/jsbsim/inertia/pointmass-weight-lbs[1]",weight_co_pilot_lbs) ;

  var weight_instruments_kg = getprop("/fdm/jsbsim/inertia/pointmass-weight-kg[2]");
  var weight_instruments_lbs = weight_instruments_kg * KG2LB;
  setprop("/fdm/jsbsim/inertia/pointmass-weight-lbs[2]",weight_instruments_lbs) ;

  var weight_floats_kg = getprop("/fdm/jsbsim/inertia/pointmass-weight-kg[3]");
  var weight_floats_lbs = weight_floats_kg * KG2LB;
  setprop("/fdm/jsbsim/inertia/pointmass-weight-lbs[3]",weight_floats_lbs) ;

  var weight_fuel_lbs = getprop("/consumables/fuel/total-fuel-lbs");
  var weight_fuel_kg  = weight_fuel_lbs * LB2KG;

  var weight_lbs = getprop("/fdm/jsbsim/inertia/weight-lbs");
  var weight_kg = weight_lbs * LB2KG;
  setprop("/fdm/jsbsim/inertia/weight-kg",weight_kg);

  var area_sqft = getprop("/fdm/jsbsim/metrics/Sw-sqft");
  var area_sqm = area_sqft * 0.09290;
  setprop("/fdm/jsbsim/metrics/Sw-sqm",area_sqm);


  # ------------------------  calculate CG position  ------------------------

  # CG from nose (Datum)
  var cg_x_in = getprop("/fdm/jsbsim/inertia/cg-x-in");
  var cg_from_nose_mm = ( cg_x_in * IN2M + 2.285 ) * 1000. ;
  setprop("/fdm/jsbsim/inertia/cg_from_nose-mm",cg_from_nose_mm) ;
  setprop("/fdm/jsbsim/inertia/cg_from_nose-in",cg_from_nose_mm / 1000. * M2IN) ;

  # CG from Wing LE / MAC 
  var mac_m = getprop("/fdm/jsbsim/metrics/cbarw-ft") * FT2M;
  var cg_from_WingLE_m = ( cg_from_nose_mm / 1000. - 1.524 );
  var cg_mac_pc = cg_from_WingLE_m / mac_m *100. ;
  setprop("/fdm/jsbsim/inertia/cg_mac-pc",cg_mac_pc) ;


  # --------------------------  wing loading  --------------------------

  var wing_loading_lbft2 = weight_lbs / area_sqft ;
  var wing_loading_kgm2  = weight_kg  / area_sqm ;
  setprop("/fdm/jsbsim/inertia/wing_loading_lbsqft",wing_loading_lbft2) ;
  setprop("/fdm/jsbsim/inertia/wing_loading_kgsqm",wing_loading_kgm2) ;

}

################################################################################################
#
# Set default weight values
#
################################################################################################

var weight_and_balance_defaults = func {

  setprop("/fdm/jsbsim/inertia/pointmass-weight-kg[0]", 90.);
  setprop("/fdm/jsbsim/inertia/pointmass-weight-kg[1]", 0.);
  setprop("/fdm/jsbsim/inertia/pointmass-weight-kg[2]", 2.);
  setprop("/fdm/jsbsim/inertia/pointmass-weight-kg[3]", 0.);
  setprop("/consumables/fuel/tank/level-kg", 10.);

  weight_and_balance()
}








