#	KN63 DME System
#
#	2023 Bea Wolf
#
#	References: see kdi572.xml

var func_knob = props.globals.initNode("/instrumentation/dme[0]/function-knob", 1, "INT");	# 0 = OFF, 1 = NAV 1, 2 = HOLD, 3 = NAV 2

var power = props.globals.initNode("/instrumentation/dme[0]/power-btn", 1, "BOOL");
var source = props.globals.initNode("/instrumentation/dme[0]/frequencies/source", "/instrumentation/nav[0]/frequencies/selected-mhz", "STRING");
var freq_store = props.globals.initNode("/instrumentation/dme[0]/frequencies/stored-mhz", 000.00, "DOUBLE");

var src_flag = props.globals.initNode("/instrumentation/dme[0]/source-flag", 0, "INT"); # 0 = NAV1 "1", 1 = Hold NAV1 "1H", 2 = Hold NAV2 "H2", 3 = NAV2 "2"

setlistener( func_knob, func{
	var x = func_knob.getIntValue();
	
	if( x == 0 ){
		power.setBoolValue( 0 );
	} else {
		power.setBoolValue( 1 );
		
		if( x == 1 ){
			source.setValue( "/instrumentation/nav[0]/frequencies/selected-mhz" );
			src_flag.setIntValue( 0 );
		} elsif( x == 3 ){
			source.setValue( "/instrumentation/nav[1]/frequencies/selected-mhz" );
			src_flag.setIntValue( 3 );
		} else {
			var prev_src = source.getValue();
			freq_store.setValue( getprop( prev_src ) );
			if( prev_src == "/instrumentation/nav[0]/frequencies/selected-mhz" ){
				src_flag.setIntValue( 1 );
			} else {
				src_flag.setIntValue( 2 );
			}
			source.setValue( "/instrumentation/dme[0]/frequencies/stored-mhz" );
		}
	}
});
	
