# $Id$
#
# Nasal script to print errors to the screen when aircraft exceed design limits:
#  - extending spoiler above maximum spoiler extension speed(s)
#  - exceeding Vne 
#  - exceeding Vno (->Caution)
#  - exceeding structural G limits
# Taken from Aircraft/Generic and adapted for DG-1000S

var accel_limits = {
	aerobatic: {
		va: [	props.globals.getNode("/limits/acceleration/aerobatic/min-va", 1), props.globals.getNode("/limits/acceleration/aerobatic/max-va", 1) ],
		vne: [	props.globals.getNode("/limits/acceleration/aerobatic/min-vne", 1), props.globals.getNode("/limits/acceleration/aerobatic/max-vne", 1) ],
		se: [	props.globals.getNode("/limits/acceleration/aerobatic/min-airbrakes-extended", 1), props.globals.getNode("/limits/acceleration/aerobatic/max-airbrakes-extended", 1) ],
	},
	utility: {
		va: [	props.globals.getNode("/limits/acceleration/utility/min-va", 1), props.globals.getNode("/limits/acceleration/utility/max-va", 1) ],
		vne: [	props.globals.getNode("/limits/acceleration/utility/min-vne", 1), props.globals.getNode("/limits/acceleration/utility/max-vne", 1) ],
		se: [	props.globals.getNode("/limits/acceleration/utility/min-airbrakes-extended", 1), props.globals.getNode("/limits/acceleration/utility/max-airbrakes-extended", 1) ],
	},
};

var speedbrakes = props.globals.getNode( "/surface-positions/speedbrake-pos-norm", 1);

var checkG = func{
	if (getprop("/sim/freeze/replay-state"))
		return;
	
	var airspeed = getprop("velocities/airspeed-kt");
	var vne      = getprop("limits/vne");
	var va       = getprop("limits/va");
	var g = getprop("/accelerations/pilot-g") or 1;
	var mtow = getprop("limits/mtow-lbs");
	var mtow_aerobatic = getprop("limits/mtow-lbs-aerobatic");
	var gw = getprop("fdm/jsbsim/inertia/weight-lb") or 0.0;
	var wingtips = getprop("/dg1000/options/wingtips");
	var msg = nil;

	# Check whether we are in aerobatic configuration
	if( gw <= mtow_aerobatic and wingtips <= 1 ) {
		# Check whether spoilers are extended
		if( speedbrakes.getDoubleValue() > 0.01 ){
			if( g < accel_limits.aerobatic.se[0].getDoubleValue() or g > accel_limits.aerobatic.se[1].getDoubleValue() ){
				msg = "with speedbrakes extended";
			}
		} else {
			# Check which speed range we are in
			if( airspeed > va ){
				if( g < accel_limits.aerobatic.vne[0].getDoubleValue() or g > accel_limits.aerobatic.vne[1].getDoubleValue() ){
					msg = "above manoeuvering speed";
				}
			} else {
				if( g < accel_limits.aerobatic.va[0].getDoubleValue() or g > accel_limits.aerobatic.va[1].getDoubleValue() ){
					msg = "";
				}
			}
		}
	} else {
		# Check whether spoilers are extended
		if( speedbrakes.getDoubleValue() > 0.01 ){
			if( g < accel_limits.utility.se[0].getDoubleValue() or g > accel_limits.utility.se[1].getDoubleValue() ){
				msg = "with speedbrakes extended";
			}
		} else {
			# Check which speed range we are in
			if( airspeed > va ){
				if( g < accel_limits.utility.vne[0].getDoubleValue() or g > accel_limits.utility.vne[1].getDoubleValue() ){
					msg = "above manoeuvering speed";
				}
			} else {
				if( g < accel_limits.utility.va[0].getDoubleValue() or g > accel_limits.utility.va[1].getDoubleValue() ){
					msg = "";
				}
			}
		}
	}
	
	if (msg != nil){
		# If we have a message, display it, but don't bother checking for
		# any other errors for 5 seconds. Otherwise we're likely to get
		# repeated messages.
		screen.log.write("Airframe structural g load limit "~ msg ~" exceeded!");
		settimer(checkG, 5);
	}else{
		settimer(checkG, 1);
	}
}

var checkVNE = func {
	if (getprop("/sim/freeze/replay-state"))
		return;
	
	var airspeed = getprop("velocities/airspeed-kt");
	var vne      = getprop("limits/vne");
	var va      = getprop("limits/va");
	var msg = "";
	
	if ((airspeed != nil) and (vne != nil) and (airspeed > vne))
	{
		msg = "Airspeed exceeds Vne!";
	} else if ((airspeed != nil) and (va != nil) and (airspeed > va))
	{
		msg = "Caution: Airspeed exceeds Va!";
	}
	
	
	
	if (msg != "")
	{
		# If we have a message, display it, but don't bother checking for
		# any other errors for 5 seconds. Otherwise we're likely to get
		# repeated messages.
		screen.log.write(msg);
		settimer(checkVNE, 5);
	}
	else
	{
		settimer(checkVNE, 1);
	}
}

var checkMTOW = func{
	if (getprop("/sim/freeze/replay-state"))
		return;
	
	var gw = getprop("fdm/jsbsim/inertia/weight-lb");
	var mtow = getprop("limits/mtow-lbs");
	var msg = "";
	
	if ((mtow != nil) and (gw != nil) and (gw > mtow))
	{
		msg = "Maximum Takeoff Weight exceeded!";
	}    
	
	if (msg != ""){
		# If we have a message, display it, but don't bother checking for
		# any other errors for 5 seconds. Otherwise we're likely to get
		# repeated messages.
		screen.log.write(msg);
		settimer(checkMTOW, 5);
	}else{
		settimer(checkMTOW, 1);
	}
}


checkG();
checkMTOW();
checkVNE();
