#########################################################
############## General initializers #####################
#########################################################
#                                                        M2/AN Browning .50 BMG
var l_gun1_ammo_count = "ai/submodels/submodel[0]/count";
var l_gun2_ammo_count = "ai/submodels/submodel[1]/count";
var l_gun3_ammo_count = "ai/submodels/submodel[2]/count";
var r_gun1_ammo_count = "ai/submodels/submodel[3]/count";
var r_gun2_ammo_count = "ai/submodels/submodel[4]/count";
var r_gun3_ammo_count = "ai/submodels/submodel[5]/count";
#                                                        AIM-9 sidewinder (unguided) pylon 3 rockets by wing
var l_roc1_ammo_count = "ai/submodels/submodel[6]/count";
var l_roc2_ammo_count = "ai/submodels/submodel[7]/count";
var l_roc3_ammo_count = "ai/submodels/submodel[8]/count";
var r_roc1_ammo_count = "ai/submodels/submodel[9]/count";
var r_roc2_ammo_count = "ai/submodels/submodel[10]/count";
var r_roc3_ammo_count = "ai/submodels/submodel[11]/count";
#                                                        MK-82 500 pound bomb
var c_bom1_ammo_count = "ai/submodels/submodel[12]/count";

#########################################################
##################### reload guns #######################
#########################################################
# Guns generally cannot be reloaded in flight.  It requires landing,
# stop, and reload before taking off again.
#
# Note that tracers are modeled as bullets that include a visual model but
# no impact.  They fire along with 1 of every three or four bullets to simulate
# a tracer round every 4 rounds.

reload_guns = func {

  groundspeed = getprop("velocities/groundspeed-kt");
  engine_rpm  = getprop("engines/engine/rpm");

  #only allow it if on ground, stopped OR if it's already set to unlimited mode
  if ( ( groundspeed < 5 and engine_rpm < 5 ) or getprop( r_gun1_ammo_count) == -1 ) {

    #                                           M2/AN Browning .50 BMG
    setprop(l_gun1_ammo_count, 400);
    setprop(l_gun2_ammo_count, 400);
    setprop(l_gun3_ammo_count, 400);
    setprop(r_gun1_ammo_count, 400);
    setprop(r_gun2_ammo_count, 400);
    setprop(r_gun3_ammo_count, 400);
    #                                           AIM-9 sidewinder (unguided) pylon 3 rockets by wing
    setprop ( l_roc1_ammo_count, 1);
    setprop ( l_roc2_ammo_count, 1);
    setprop ( l_roc3_ammo_count, 1);
    setprop ( r_roc1_ammo_count, 1);
    setprop ( r_roc2_ammo_count, 1);
    setprop ( r_roc3_ammo_count, 1);
    #                                           MK-82 500 pound bomb
    setprop ( c_bom1_ammo_count, 1);

    # setprop("ai/submodels/rocket-number",6);
    setprop("sim/multiplay/generic/float[14]", 6);

    gui.popupTip ("Guns reloaded--400 rounds in each gun.", 5)
  } else {
    gui.popupTip ("You must be on the ground and engines dead stopped to re-load guns.",5)
  }
}

#########################################################
################ unlimited ammo #########################
#########################################################
# For testing only, of course!
#

unlimited_guns = func {

  groundspeed = getprop("velocities/groundspeed-kt");
  engine_rpm  = getprop("engines/engine/rpm");

  #                                           M2/AN Browning .50 BMG
  setprop ( l_gun1_ammo_count, -1);
  setprop ( l_gun2_ammo_count, -1);
  setprop ( l_gun3_ammo_count, -1);
  setprop ( r_gun1_ammo_count, -1);
  setprop ( r_gun2_ammo_count, -1);
  setprop ( r_gun3_ammo_count, -1);
  #                                           AIM-9 sidewinder (unguided) pylon 3 rockets by wing
  setprop ( l_roc1_ammo_count, 1);
  setprop ( l_roc2_ammo_count, 1);
  setprop ( l_roc3_ammo_count, 1);
  setprop ( r_roc1_ammo_count, 1);
  setprop ( r_roc2_ammo_count, 1);
  setprop ( r_roc3_ammo_count, 1);
  #                                           MK-82 500 pound bomb
  setprop ( c_bom1_ammo_count, 1);

  # setprop("ai/submodels/rocket-number",6);
  setprop("sim/multiplay/generic/float[14]", 6);

  gui.popupTip ("Guns set to unlimited mode--definitely not realistic and only for testing!  Select 'Reload Guns' to revert to limited ammo.",7)
}

######################################################################
###                                                                ###
###                         Guns fire                              ###
###                                                                ###
### BARANGER Emmanuel aka Helijah 19/01/2026 for F6F Hellcat       ###
######################################################################

fire_MG = func {
  # Guns
  # setprop("/controls/armament/trigger", 1);
  setprop("sim/multiplay/generic/int[10]", 1);
}

stop_MG = func {
  #setprop("/controls/armament/trigger", 0);
  setprop("sim/multiplay/generic/int[10]", 0);
}

Release_Bomb = func {
  # Bomb
  # setprop("/controls/armament/trigger1", 1);
  setprop("sim/multiplay/generic/int[11]", 1);
}

stop_Bomb = func {
  # setprop("/controls/armament/trigger1", 0);
  setprop("sim/multiplay/generic/int[11]", 0);
}

fire_AIM = func {
  # AIM-9 Sidewinder

  # var aimnumber = getprop("ai/submodels/rocket-number");
  var aimnumber = getprop("sim/multiplay/generic/float[14]");
  if ( aimnumber == 6 ) {
    # setprop("/controls/armament/trigger2", 1);
    setprop("sim/multiplay/generic/int[12]", 1);
  } elsif ( aimnumber == 5 ) {
    # setprop("/controls/armament/trigger3", 1);
    setprop("sim/multiplay/generic/int[13]", 1);
  } elsif ( aimnumber == 4 ) {
    # setprop("/controls/armament/trigger4", 1);
    setprop("sim/multiplay/generic/int[14]", 1);
  } elsif ( aimnumber == 3 ) {
    # setprop("/controls/armament/trigger5", 1);
    setprop("sim/multiplay/generic/int[15]", 1);
  } elsif ( aimnumber == 2 ) {
    # setprop("/controls/armament/trigger6", 1);
    setprop("sim/multiplay/generic/int[16]", 1);
  } elsif ( aimnumber == 1 ) {
    # setprop("/controls/armament/trigger7", 1);
    setprop("sim/multiplay/generic/int[17]", 1);
  }

  aimnumber -= 1;
  if ( aimnumber < 0 ) {
    aimnumber = 0;
  }
  # setprop("ai/submodels/rocket-number",aimnumber);
  setprop("sim/multiplay/generic/float[14]", aimnumber);
}

stop_AIM = func {
  # setprop("/controls/armament/trigger2", 0);
  setprop("sim/multiplay/generic/int[12]", 0);
  # setprop("/controls/armament/trigger3", 0);
  setprop("sim/multiplay/generic/int[13]", 0);
  # setprop("/controls/armament/trigger4", 0);
  setprop("sim/multiplay/generic/int[14]", 0);
  # setprop("/controls/armament/trigger5", 0);
  setprop("sim/multiplay/generic/int[15]", 0);
  # setprop("/controls/armament/trigger6", 0);
  setprop("sim/multiplay/generic/int[16]", 0);
  # setprop("/controls/armament/trigger7", 0);
  setprop("sim/multiplay/generic/int[17]", 0);
}

