var rotor_wash_loop = func {

  ##### water and grass shader effect
  var vpos     = geo.viewer_position();
  var apos     = geo.aircraft_position();

  var lat_to_m = 110952.0;
  var lon_to_m = math.cos(apos.lat()*math.pi/180.0) * lat_to_m;

  var alt      = getprop("/position/altitude-agl-ft");

  var delta_x  = (apos.lat() - vpos.lat()) * lat_to_m;
  var delta_y  = -(apos.lon() - vpos.lon()) * lon_to_m;

  setprop("/environment/aircraft-effects/wash-x", delta_x);
  setprop("/environment/aircraft-effects/wash-y", delta_y);

  var rpm_factor = getprop("rotors/main/rpm")/400.0;

  var strength = 20.0/alt;
  if (strength > 1.0) {
    strength = 1.0;
  }
  strength = strength * rpm_factor;

  setprop("/environment/aircraft-effects/wash-strength", strength);

  # particle effect colors
  var land = getprop("/gear/gear/ground-is-solid");

  var red_diffuse = getprop("/rendering/scene/diffuse/red");
  var gre_diffuse = getprop("/rendering/scene/diffuse/green");
  var blu_diffuse = getprop("/rendering/scene/diffuse/blue");

  if (land) {
    setprop("/sim/model/s92/effects/particles/rotorwash/redcombinedstart",   red_diffuse * 0.4);
    setprop("/sim/model/s92/effects/particles/rotorwash/greencombinedstart", gre_diffuse * 0.4);
    setprop("/sim/model/s92/effects/particles/rotorwash/bluecombinedstart",  blu_diffuse * 0.4);
    setprop("/sim/model/s92/effects/particles/rotorwash/redcombinedend",     red_diffuse * 0.7);
    setprop("/sim/model/s92/effects/particles/rotorwash/greencombinedend",   gre_diffuse * 0.7);
    setprop("/sim/model/s92/effects/particles/rotorwash/bluecombinedend",    blu_diffuse * 0.7);
  } else {
    setprop("/sim/model/s92/effects/particles/rotorwash/redcombinedstart",   red_diffuse * 0.65);
    setprop("/sim/model/s92/effects/particles/rotorwash/greencombinedstart", gre_diffuse * 0.80);
    setprop("/sim/model/s92/effects/particles/rotorwash/bluecombinedstart",  blu_diffuse * 0.75);
    setprop("/sim/model/s92/effects/particles/rotorwash/redcombinedend",     red_diffuse * 0.85);
    setprop("/sim/model/s92/effects/particles/rotorwash/greencombinedend",   gre_diffuse * 1);
    setprop("/sim/model/s92/effects/particles/rotorwash/bluecombinedend",    blu_diffuse * 0.90);
  }
}
