# EXPORT : functions ending by export are called from xml
# CRON : functions ending by cron are called from timer
# SCHEDULE : functions ending by schedule are called from cron

# current nasal version doesn't accept :
# - too many operations on 1 line.
# - variable with hyphen (?).



# ==============
# INITIALIZATION
# ==============

ConcordeMain = {};

ConcordeMain.new = func {
   var obj = { parents : [ConcordeMain]
         };

   obj.init();

   return obj;
}

# the possible relations :
# ----------------------

# - pumpsystem : Pump.new(),
#   inside another system / instrument, to synchronize the objects.

# - me.electricalsystem = electrical;
#   local pointer to the global object, to call its nasal code.

# - <dependency>/systems/electrical</dependency>
#   tag in the instrumentation / system initialization, to read the properties.

# - <static-port>/systems/static</static-port>
#   tag in the instrumentation file, to customize a C++ instrument.

# - <noinstrument>/position/altitude-agl-ft</noinstrument>.
#   no relation to an instrument / system failure.

ConcordeMain.putinrelation = func {
   autopilotsystem.set_relation( autothrottlesystem );
   MWSsystem.set_relation( ADCinstrument, CGinstrument, INSinstrument,
                           airbleedsystem, electricalsystem, enginesystem,
                           flightsystem, fuelsystem, hydraulicsystem, antiicingsystem,
                           pressuresystem, tankpressuresystem );

   wiperinstrument.set_relation( noseinstrument );

   copilotcrew.set_relation( airbleedsystem, autopilotsystem, electricalsystem, flightsystem, lightingsystem, MWSsystem, voicecrew );
   engineercrew.set_relation( airbleedsystem, autopilotsystem, electricalsystem, enginesystem, fuelsystem, lightingsystem, voicecrew );
   voicecrew.set_relation( autopilotsystem );

   engineerhuman.set_relation( seatsystem );
}

ConcordeMain.synchronize = func {
   electricalsystem.set_rate( fuelsystem.PUMPSEC );
   hydraulicsystem.set_rate( fuelsystem.PUMPSEC );
   airbleedsystem.set_rate( fuelsystem.PUMPSEC );
   enginesystem.set_rate( fuelsystem.PUMPSEC );
}

# 1 seconds cron (only, to spare frame rate)
ConcordeMain.sec1cron = func {
   electricalsystem.schedule();
   hydraulicsystem.schedule();
   fuelsystem.schedule();
   airbleedsystem.schedule();
   enginesystem.schedule();
   GPWSsystem.schedule();
   lightingsystem.schedule();
   wiperinstrument.schedule();
   daytimeinstrument.schedule();

   # schedule the next call
   settimer(func { me.sec1cron(); },fuelsystem.PUMPSEC);
}

# 3 seconds cron
ConcordeMain.sec3cron = func {
   autopilotsystem.schedule();
   autothrottlesystem.schedule();
   MWSsystem.schedule();
   flightsystem.schedule();
   fuelsystem.slowschedule();
   antiicingsystem.schedule();
   TCASinstrument.schedule();
   INSinstrument.schedule();
   crewscreen.schedule();

   # schedule the next call
   settimer(func { me.sec3cron(); },autopilotsystem.AUTOPILOTSEC);
}

# 5 seconds cron
ConcordeMain.sec5cron = func {
   CGinstrument.schedule();
   IASinstrument.schedule();
   machinstrument.schedule();
   autopilotsystem.slowschedule();
   autothrottlesystem.slowschedule();
   pressuresystem.schedule();
   enginesystem.slowschedule();
   copilotcrew.fastschedule();
   copilothuman.schedule();
   engineerhuman.schedule();

   # schedule the next call
   settimer(func { me.sec5cron(); },pressuresystem.PRESSURIZESEC);
}

# 10 seconds cron
ConcordeMain.sec10cron = func {
   MWSsystem.slowschedule();

   # schedule the next call
   settimer(func { me.sec10cron(); },MWSsystem.AUXILIARYSEC);
}

# 15 seconds cron
ConcordeMain.sec15cron = func {
   TMOinstrument.schedule();
   GPWSsystem.slowschedule();
   engineerhuman.slowschedule();

   # schedule the next call
   settimer(func { me.sec15cron(); },15);
}

# 30 seconds cron
ConcordeMain.sec30cron = func {
   tankpressuresystem.schedule();

   # schedule the next call
   settimer(func { me.sec30cron(); },tankpressuresystem.TANKSEC);
}

# 60 seconds cron
ConcordeMain.sec60cron = func {
   electricalsystem.slowschedule();
   airbleedsystem.slowschedule();
   antiicingsystem.slowschedule();
   engineercrew.veryslowschedule();

   # schedule the next call
   settimer(func { me.sec60cron(); },60);
}

ConcordeMain.savedata = func {
   var saved_props = [ "/controls/anti-ice/icing-model/duration/few-min",
                       "/controls/anti-ice/icing-model/duration/scattered-min",
                       "/controls/anti-ice/icing-model/duration/broken-min",
                       "/controls/anti-ice/icing-model/duration/overcast-min",
                       "/controls/anti-ice/icing-model/duration/clear-min",
                       "/controls/anti-ice/icing-model/temperature/max-degc",
                       "/controls/anti-ice/icing-model/temperature/min-degc",
                       "/controls/autoflight/fg-waypoint",
                       "/controls/autoflight/real-nav",
                       "/controls/captain/countdown",
                       "/controls/copilot/landing-lights",
                       "/controls/crew/captain-busy",
                       "/controls/crew/checklist",
                       "/controls/crew/ins-alignment",
                       "/controls/crew/night-lighting",
                       "/controls/crew/timeout",
                       "/controls/crew/timeout-s",
                       "/controls/seat/recover",
                       "/controls/seat/yoke",
                       "/controls/voice/sound",
                       "/controls/voice/text",
                       "/systems/fuel/presets",
                       "/systems/human/serviceable",
                       "/systems/seat/position/observer/x-m",
                       "/systems/seat/position/observer/y-m",
                       "/systems/seat/position/observer/z-m",
                       "/systems/seat/position/steward/x-m",
                       "/systems/seat/position/steward/y-m",
                       "/systems/seat/position/steward/z-m" ];

   for( var i = 0; i < size(saved_props); i = i + 1 ) {
        aircraft.data.add(saved_props[i]);
   }
}

# global variables in Concorde namespace, for call by XML
ConcordeMain.instantiate = func {
   globals.Concorde.constant = Concorde.Constant.new();
   globals.Concorde.constantaero = Concorde.Constantaero.new();
   globals.Concorde.constantISA = Concorde.ConstantISA.new();

   globals.Concorde.electricalsystem = Concorde.Electrical.new();
   globals.Concorde.hydraulicsystem = Concorde.Hydraulic.new();
   globals.Concorde.flightsystem = Concorde.Flight.new();
   globals.Concorde.airbleedsystem = Concorde.Airbleed.new();
   globals.Concorde.pressuresystem = Concorde.Pressurization.new();
   globals.Concorde.antiicingsystem = Concorde.Antiicing.new();
   globals.Concorde.fuelsystem = Concorde.Fuel.new();
   globals.Concorde.tankpressuresystem = Concorde.Pressurizetank.new();
   globals.Concorde.autopilotsystem = Concorde.Autopilot.new();
   globals.Concorde.autothrottlesystem = Concorde.Autothrottle.new();
   globals.Concorde.GPWSsystem = Concorde.Gpws.new();
   globals.Concorde.MWSsystem = Concorde.Mws.new();
   globals.Concorde.enginesystem = Concorde.Engine.new();
   globals.Concorde.lightingsystem = Concorde.Lighting.new();
   globals.Concorde.gearsystem = Concorde.Gear.new();

   globals.Concorde.CGinstrument = Concorde.Centergravity.new();
   globals.Concorde.IASinstrument = Concorde.Airspeed.new();
   globals.Concorde.machinstrument = Concorde.Machmeter.new();
   globals.Concorde.TMOinstrument = Concorde.Temperature.new();
   globals.Concorde.ADCinstrument = Concorde.AirDataComputer.new();
   globals.Concorde.INSinstrument = Concorde.Inertial.new();
   globals.Concorde.TCASinstrument = Concorde.Traffic.new();
   globals.Concorde.transponderinstrument = Concorde.Transponder.new();
   globals.Concorde.wiperinstrument = Concorde.Wiper.new();
   globals.Concorde.noseinstrument = Concorde.NoseVisor.new();
   globals.Concorde.markerinstrument = Concorde.Markerbeacon.new();
   globals.Concorde.RATinstrument = Concorde.Rat.new();
   globals.Concorde.daytimeinstrument = Concorde.Daytime.new();
   globals.Concorde.genericinstrument = Concorde.Generic.new();

   globals.Concorde.doorsystem = Concorde.Doors.new();
   globals.Concorde.seatsystem = Concorde.Seats.new();

   globals.Concorde.menuscreen = Menu.new();
   globals.Concorde.crewscreen = Crewbox.new();

   globals.Concorde.copilotcrew = Concorde.Virtualcopilot.new();
   globals.Concorde.engineercrew = Concorde.Virtualengineer.new();
   globals.Concorde.voicecrew = Concorde.Voice.new();

   globals.Concorde.copilothuman = Concorde.Copilothuman.new();
   globals.Concorde.engineerhuman = Concorde.Engineerhuman.new();
}

# general initialization
ConcordeMain.init = func {
   aircraft.livery.init("Aircraft/Concorde/Models/Liveries", "sim/model/livery/name", "sim/model/livery/index");

   me.instantiate();
   me.putinrelation();
   me.synchronize();

   # schedule the 1st call
   settimer(func { me.sec1cron(); },0);
   settimer(func { me.sec3cron(); },0);
   settimer(func { me.sec5cron(); },0);
   settimer(func { me.sec10cron(); },0);
   settimer(func { me.sec15cron(); },0);
   settimer(func { me.sec30cron(); },0);
   settimer(func { me.sec60cron(); },0);

   # saved on exit, restored at launch
   me.savedata();

   # the 3D is soon visible (long by Cygwin)
   print("concorde systems started, version ", getprop("/sim/aircraft-version"));
}

concordeL = setlistener("/sim/signals/fdm-initialized", func { theconcorde = ConcordeMain.new(); removelistener(concordeL); });
