# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work envronment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=gtk+
VER=2.14.3
REV=3
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev
usemsvs6

(

set -x

DEPS=`latest --arch=${ARCH} glib atk cairo pango libpng zlib libtiff jpeg`
PROXY_LIBINTL=`latest --arch=${ARCH} proxy-libintl`


PKG_CONFIG_PATH=
for D in $DEPS; do
    PATH=/devel/dist/${ARCH}/$D/bin:$PATH
    [ -d /devel/dist/${ARCH}/$D/lib/pkgconfig ] && PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/lib/pkgconfig:$PKG_CONFIG_PATH
done

LIBPNG=`latest --arch=${ARCH} libpng`
ZLIB=`latest --arch=${ARCH} zlib`
LIBTIFF=`latest --arch=${ARCH} libtiff`
JPEG=`latest --arch=${ARCH} jpeg`

# Don't do any relinking crap in libtool.

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I
# can only do this if you have shared version of the
# library, which you do not appear to have."

# Screw libtool. I know what I am doing. Yes, I do want to link with a
# static libintl now. (The proxy-libintl libintl wrapper.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

patch -p0 <<'EOF'
Index: gtk-zip.sh.in
===================================================================
--- gtk-zip.sh.in	(revision 21509)
+++ gtk-zip.sh.in	(revision 21511)
@@ -46,11 +46,7 @@
 bin/gtk-builder-convert
 bin/gtk-demo.exe
 bin/gtk-update-icon-cache.exe
-share/man/man1/gdk-builder-convert.1
-share/man/man1/gdk-pixbuf-csource.1
-share/man/man1/gdk-update-icon-cache.1
-share/man/man1/gtk-pixbuf-query-loaders.1
-share/man/man1/gtk-query-immodules-2.0.1
+share/man
 lib/libgdk_pixbuf-@GTK_API_VERSION@.dll.a
 lib/gdk_pixbuf-@GTK_API_VERSION@.lib
 lib/libgdk-win32-@GTK_API_VERSION@.dll.a
@@ -60,16 +56,10 @@
 lib/libgailutil.dll.a
 lib/gailutil.lib
 lib/gtk-2.0/include
-lib/pkgconfig/gdk-pixbuf-2.0.pc
-lib/pkgconfig/gdk-2.0.pc
-lib/pkgconfig/gdk-win32-2.0.pc
-lib/pkgconfig/gtk+-2.0.pc
-lib/pkgconfig/gtk+-win32-2.0.pc
-share/aclocal/gtk-2.0.m4
+lib/pkgconfig
+share/aclocal
 share/gtk-2.0
-share/gtk-doc/html/gdk-pixbuf
-share/gtk-doc/html/gdk
-share/gtk-doc/html/gtk
+share/gtk-doc
 EOF
 
 zip -r $DEVZIP share/doc/gtk+-dev-@GTK_VERSION@
EOF

patch -p0 <<'EOF'
--- gdk/win32/gdkprivate-win32.h	2008-09-19 07:44:43.000000000 +0300
+++ ../gtk-2-14/gdk/win32/gdkprivate-win32.h	2008-10-05 00:28:55.652000000 +0300
@@ -98,6 +98,7 @@
 #define GDK_DEBUG_EVENTS_OR_INPUT (GDK_DEBUG_EVENTS|GDK_DEBUG_INPUT)
 #define GDK_DEBUG_PIXMAP_OR_COLORMAP (GDK_DEBUG_PIXMAP|GDK_DEBUG_COLORMAP)
 #define GDK_DEBUG_MISC_OR_COLORMAP (GDK_DEBUG_MISC|GDK_DEBUG_COLORMAP)
+#define GDK_DEBUG_MISC_OR_EVENTS (GDK_DEBUG_MISC|GDK_DEBUG_EVENTS)
 
 #define GDK_TYPE_GC_WIN32              (_gdk_gc_win32_get_type ())
 #define GDK_GC_WIN32(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), GDK_TYPE_GC_WIN32, GdkGCWin32))
@@ -311,6 +312,8 @@
 gchar *_gdk_win32_gcvalues_mask_to_string (GdkGCValuesMask mask);
 gchar *_gdk_win32_window_state_to_string (GdkWindowState state);
 gchar *_gdk_win32_window_style_to_string (LONG style);
+gchar *_gdk_win32_window_exstyle_to_string (LONG style);
+gchar *_gdk_win32_window_pos_bits_to_string (UINT flags);
 gchar *_gdk_win32_drawable_description (GdkDrawable *d);
 
 gchar *_gdk_win32_rop2_to_string       (int          rop2);
--- gdk/win32/gdkmain-win32.c	2008-09-19 07:44:43.000000000 +0300
+++ ../gtk-2-14/gdk/win32/gdkmain-win32.c	2008-10-05 00:28:30.448875000 +0300
@@ -553,7 +553,7 @@
   buf[0] = '\0';
 
 #define BIT(x)						\
-  if (style & WS_ ## x)			\
+  if (style & WS_ ## x)					\
     (bufp += sprintf (bufp, "%s" #x, s), s = "|")
 
   /* Note that many of the WS_* macros are in face several bits.
@@ -586,6 +586,81 @@
 }
 
 gchar *
+_gdk_win32_window_exstyle_to_string (LONG style)
+{
+  gchar buf[1000];
+  gchar *bufp = buf;
+  gchar *s = "";
+
+  buf[0] = '\0';
+
+#define BIT(x)						\
+  if (style & WS_EX_ ## x)				\
+    (bufp += sprintf (bufp, "%s" #x, s), s = "|")
+
+  /* Note that many of the WS_EX_* macros are in face several bits.
+   * Handle just the individual bits here. Sort as in w32api's
+   * winuser.h.
+   */
+  BIT (ACCEPTFILES);
+  BIT (APPWINDOW);
+  BIT (CLIENTEDGE);
+  BIT (COMPOSITED);
+  BIT (CONTEXTHELP);
+  BIT (CONTROLPARENT);
+  BIT (DLGMODALFRAME);
+  BIT (LAYERED);
+  BIT (LAYOUTRTL);
+  BIT (LEFTSCROLLBAR);
+  BIT (MDICHILD);
+  BIT (NOACTIVATE);
+  BIT (NOINHERITLAYOUT);
+  BIT (NOPARENTNOTIFY);
+  BIT (RIGHT);
+  BIT (RTLREADING);
+  BIT (STATICEDGE);
+  BIT (TOOLWINDOW);
+  BIT (TOPMOST);
+  BIT (TRANSPARENT);
+  BIT (WINDOWEDGE);
+#undef BIT
+
+  return static_printf ("%s", buf);  
+}
+
+gchar *
+_gdk_win32_window_pos_bits_to_string (UINT flags)
+{
+  gchar buf[1000];
+  gchar *bufp = buf;
+  gchar *s = "";
+
+  buf[0] = '\0';
+
+#define BIT(x)						\
+  if (flags & SWP_ ## x)				\
+    (bufp += sprintf (bufp, "%s" #x, s), s = "|")
+
+  BIT (DRAWFRAME);
+  BIT (FRAMECHANGED);
+  BIT (HIDEWINDOW);
+  BIT (NOACTIVATE);
+  BIT (NOCOPYBITS);
+  BIT (NOMOVE);
+  BIT (NOSIZE);
+  BIT (NOREDRAW);
+  BIT (NOZORDER);
+  BIT (SHOWWINDOW);
+  BIT (NOOWNERZORDER);
+  BIT (NOSENDCHANGING);
+  BIT (DEFERERASE);
+  BIT (ASYNCWINDOWPOS);
+#undef BIT
+
+  return static_printf ("%s", buf);  
+}
+
+gchar *
 _gdk_win32_rop2_to_string (int rop2)
 {
   switch (rop2)
--- gdk/win32/gdkevents-win32.c	2008-09-19 07:44:43.000000000 +0300
+++ ../gtk-2-14/gdk/win32/gdkevents-win32.c	2008-10-05 02:17:26.355125000 +0300
@@ -292,11 +292,7 @@
   retval = inner_window_procedure (hwnd, message, wparam, lparam);
   debug_indent -= 2;
 
-#ifdef _WIN64
-  GDK_NOTE (EVENTS, g_print (" => %I64d%s", retval, (debug_indent == 0 ? "\n" : "")));
-#else
-  GDK_NOTE (EVENTS, g_print (" => %ld%s", retval, (debug_indent == 0 ? "\n" : "")));
-#endif
+  GDK_NOTE (EVENTS, g_print (" => %I64d%s", (gint64) retval, (debug_indent == 0 ? "\n" : "")));
 
   return retval;
 }
@@ -1781,9 +1777,6 @@
 doesnt_want_key (gint mask,
 		 MSG *msg)
 {
-  GdkWindow *modal_current = _gdk_modal_current ();
-  GdkWindow *window = (GdkWindow *) gdk_win32_handle_table_lookup ((GdkNativeWindow)msg->hwnd);
-
   return (((msg->message == WM_KEYUP || msg->message == WM_SYSKEYUP) &&
 	   !(mask & GDK_KEY_RELEASE_MASK)) ||
 	  ((msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN) &&
@@ -2106,6 +2099,143 @@
     _gdk_event_button_generate (_gdk_display, event);
 }
 
+static void
+ensure_stacking_on_unminimize (MSG *msg)
+{
+  HWND rover;
+  HWND lowest_transient = NULL;
+
+  rover = msg->hwnd;
+  while ((rover = GetNextWindow (rover, GW_HWNDNEXT)))
+    {
+      GdkWindow *rover_gdkw = gdk_win32_handle_table_lookup (rover);
+
+      /* Checking window group not implemented yet */
+      if (rover_gdkw)
+	{
+	  GdkWindowImplWin32 *rover_impl =
+	    (GdkWindowImplWin32 *)((GdkWindowObject *)rover_gdkw)->impl;
+
+	  if (rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
+	      rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
+	      rover_impl->transient_owner != NULL)
+	    {
+	      lowest_transient = rover;
+	    }
+	}
+    }
+  if (lowest_transient != NULL)
+    {
+      GDK_NOTE (EVENTS, g_print (" restacking: %p", lowest_transient));
+      SetWindowPos (msg->hwnd, lowest_transient, 0, 0, 0, 0,
+		    SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE);
+    }
+}
+
+static gboolean
+ensure_stacking_on_window_pos_changing (MSG       *msg,
+					GdkWindow *window)
+{
+  GdkWindowImplWin32 *impl = (GdkWindowImplWin32 *)((GdkWindowObject *) window)->impl;
+  WINDOWPOS *windowpos = (WINDOWPOS *) msg->lParam;
+
+  if (GetActiveWindow () == msg->hwnd &&
+      impl->type_hint != GDK_WINDOW_TYPE_HINT_UTILITY &&
+      impl->type_hint != GDK_WINDOW_TYPE_HINT_DIALOG &&
+      impl->transient_owner == NULL)
+    {
+      /* Make sure the window stays behind any transient-type windows
+       * of the same window group.
+       *
+       * If the window is not active and being activated, we let
+       * Windows bring it to the top and rely on the WM_ACTIVATEAPP
+       * handling to bring any utility windows on top of it.
+       */
+      HWND rover;
+      gboolean restacking;
+
+      rover = windowpos->hwndInsertAfter;
+      restacking = FALSE;
+      while (rover)
+	{
+	  GdkWindow *rover_gdkw = gdk_win32_handle_table_lookup (rover);
+
+	  /* Checking window group not implemented yet */
+	  if (rover_gdkw)
+	    {
+	      GdkWindowImplWin32 *rover_impl =
+		(GdkWindowImplWin32 *)((GdkWindowObject *)rover_gdkw)->impl;
+
+	      if (rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
+		  rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
+		  rover_impl->transient_owner != NULL)
+		{
+		  restacking = TRUE;
+		  windowpos->hwndInsertAfter = rover;
+		}
+	    }
+	  rover = GetNextWindow (rover, GW_HWNDNEXT);
+	}
+
+      if (restacking)
+	{
+	  GDK_NOTE (EVENTS, g_print (" restacking: %p", windowpos->hwndInsertAfter));
+	  return TRUE;
+	}
+    }
+  return FALSE;
+}
+
+static void
+ensure_stacking_on_activate_app (MSG       *msg,
+				 GdkWindow *window)
+{
+  GdkWindowImplWin32 *impl = (GdkWindowImplWin32 *)((GdkWindowObject *) window)->impl;
+
+  if (impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
+      impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
+      impl->transient_owner != NULL)
+    {
+      SetWindowPos (msg->hwnd, HWND_TOP, 0, 0, 0, 0,
+		    SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE);
+      return;
+    }
+
+  if (IsWindowVisible (msg->hwnd) &&
+      gdk_win32_handle_table_lookup (GetActiveWindow ()))
+    {
+      /* This window is not a transient-type window and this or some
+       * other window in this app is the active window. Make sure this
+       * window is as visible as possible, just below the lowest
+       * transient-type window of this app.
+       */
+      HWND rover;
+
+      rover = msg->hwnd;
+      while ((rover = GetNextWindow (rover, GW_HWNDPREV)))
+	{
+	  GdkWindow *rover_gdkw = gdk_win32_handle_table_lookup (rover);
+
+	  /* Checking window group not implemented yet */
+	  if (rover_gdkw)
+	    {
+	      GdkWindowImplWin32 *rover_impl =
+		(GdkWindowImplWin32 *)((GdkWindowObject *)rover_gdkw)->impl;
+
+	      if (rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
+		  rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
+		  rover_impl->transient_owner != NULL)
+		{
+		  GDK_NOTE (EVENTS, g_print (" restacking: %p", rover));
+		  SetWindowPos (msg->hwnd, rover, 0, 0, 0, 0,
+				SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE);
+		  break;
+		}
+	    }
+	}
+    }
+}
+
 static gboolean
 gdk_event_translate (MSG  *msg,
 		     gint *ret_valp)
@@ -2117,6 +2247,7 @@
   HCURSOR hcursor;
   BYTE key_state[256];
   HIMC himc;
+  WINDOWPOS *windowpos;
 
   GdkEvent *event;
 
@@ -2852,7 +2983,6 @@
       break;
 
     case WM_SYNCPAINT:
-
       sync_timer = SetTimer (GDK_WINDOW_HWND (window),
 			     1,
 			     200, sync_timer_proc);
@@ -2886,7 +3016,14 @@
       break;
 
     case WM_SHOWWINDOW:
-      GDK_NOTE (EVENTS, g_print (" %d", (int) msg->wParam));
+      GDK_NOTE (EVENTS, g_print (" %s %s",
+				 (msg->wParam ? "YES" : "NO"),
+				 (msg->lParam == 0 ? "ShowWindow" :
+				  (msg->lParam == SW_OTHERUNZOOM ? "OTHERUNZOOM" :
+				   (msg->lParam == SW_OTHERZOOM ? "OTHERZOOM" :
+				    (msg->lParam == SW_PARENTCLOSING ? "PARENTCLOSING" :
+				     (msg->lParam == SW_PARENTOPENING ? "PARENTOPENING" :
+				      "???")))))));
 
       if (!(((GdkWindowObject *) window)->event_mask & GDK_STRUCTURE_MASK))
 	break;
@@ -2927,7 +3064,6 @@
       break;
 
     case WM_SYSCOMMAND:
-
       switch (msg->wParam)
 	{
 	case SC_MINIMIZE:
@@ -2970,6 +3106,9 @@
 	  GdkWindowState withdrawn_bit =
 	    IsWindowVisible (msg->hwnd) ? GDK_WINDOW_STATE_WITHDRAWN : 0;
 
+	  if (((GdkWindowObject *) window)->state & GDK_WINDOW_STATE_ICONIFIED)
+	    ensure_stacking_on_unminimize (msg);
+
 	  if (!GDK_WINDOW_DESTROYED (window))
 	    handle_configure_event (msg, window);
 	  
@@ -3024,7 +3163,33 @@
       KillTimer (NULL, modal_timer);
       break;
 
-    case WM_WINDOWPOSCHANGED :
+    case WM_WINDOWPOSCHANGING:
+      GDK_NOTE (EVENTS, g_print (" %s %s %dx%d@%+d%+d now below %p",
+				 _gdk_win32_window_pos_bits_to_string (windowpos->flags),
+				 (windowpos->hwndInsertAfter == HWND_BOTTOM ? "BOTTOM" :
+				  (windowpos->hwndInsertAfter == HWND_NOTOPMOST ? "NOTOPMOST" :
+				   (windowpos->hwndInsertAfter == HWND_TOP ? "TOP" :
+				    (windowpos->hwndInsertAfter == HWND_TOPMOST ? "TOPMOST" :
+				     (sprintf (buf, "%p", windowpos->hwndInsertAfter),
+				      buf))))),
+				 windowpos->cx, windowpos->cy, windowpos->x, windowpos->y,
+				 GetNextWindow (msg->hwnd, GW_HWNDPREV)));
+
+      return_val = ensure_stacking_on_window_pos_changing (msg, window);
+      break;
+
+    case WM_WINDOWPOSCHANGED:
+      GDK_NOTE (EVENTS, (windowpos = (WINDOWPOS *) msg->lParam,
+			 g_print (" %s %s %dx%d@%+d%+d",
+				  _gdk_win32_window_pos_bits_to_string (windowpos->flags),
+				  (windowpos->hwndInsertAfter == HWND_BOTTOM ? "BOTTOM" :
+				   (windowpos->hwndInsertAfter == HWND_NOTOPMOST ? "NOTOPMOST" :
+				    (windowpos->hwndInsertAfter == HWND_TOP ? "TOP" :
+				     (windowpos->hwndInsertAfter == HWND_TOPMOST ? "TOPMOST" :
+				      (sprintf (buf, "%p", windowpos->hwndInsertAfter),
+				       buf))))),
+				  windowpos->cx, windowpos->cy, windowpos->x, windowpos->y)));
+
       /* Once we've entered the moving or sizing modal loop, we won't
        * return to the main loop until we're done sizing or moving.
        */
@@ -3034,6 +3199,7 @@
 	{
 	  if (((GdkWindowObject *) window)->event_mask & GDK_STRUCTURE_MASK)
 	    {
+	      GDK_NOTE (EVENTS, g_print (" do magic"));
 	      if (((GdkWindowObject *) window)->resize_count > 1)
 		((GdkWindowObject *) window)->resize_count -= 1;
 	      
@@ -3457,11 +3623,17 @@
       break;
 
     case WM_ACTIVATE:
-
+      GDK_NOTE (EVENTS, g_print (" %s%s %p",
+				 (LOWORD (msg->wParam) == WA_ACTIVE ? "ACTIVE" :
+				  (LOWORD (msg->wParam) == WA_CLICKACTIVE ? "CLICKACTIVE" :
+				   (LOWORD (msg->wParam) == WA_INACTIVE ? "INACTIVE" : "???"))),
+				 HIWORD (msg->wParam) ? " minimized" : "",
+				 (HWND) msg->lParam));
       /* We handle mouse clicks for modally-blocked windows under WM_MOUSEACTIVATE,
        * but we still need to deal with alt-tab, or with SetActiveWindow() type
-       * situations. */
-      if (is_modally_blocked (window) && msg->wParam == WA_ACTIVE)
+       * situations.
+       */
+      if (is_modally_blocked (window) && LOWORD (msg->wParam) == WA_ACTIVE)
 	{
 	  GdkWindow *modal_current = _gdk_modal_current ();
 	  SetActiveWindow (GDK_WINDOW_HWND (modal_current));
@@ -3479,6 +3651,13 @@
 	_gdk_input_set_tablet_active ();
       break;
 
+    case WM_ACTIVATEAPP:
+      GDK_NOTE (EVENTS, g_print (" %s thread: %I64d",
+				 msg->wParam ? "YES" : "NO",
+				 (gint64) msg->lParam));
+
+      ensure_stacking_on_activate_app (msg, window);
+      break;
 
       /* Handle WINTAB events here, as we know that gdkinput.c will
        * use the fixed WT_DEFBASE as lcMsgBase, and we thus can use the
--- gdk/win32/gdkwindow-win32.c	2008-09-19 07:44:43.000000000 +0300
+++ ../gtk-2-14/gdk/win32/gdkwindow-win32.c	2008-10-05 02:41:07.136375000 +0300
@@ -34,11 +34,7 @@
 #include "gdkwindowimpl.h"
 #include "gdkprivate-win32.h"
 #include "gdkinput-win32.h"
-
-#if 0
-#include <gdk-pixbuf/gdk-pixbuf.h>
-#include <stdio.h>
-#endif
+#include "gdkenumtypes.h"
 
 static GdkColormap* gdk_window_impl_win32_get_colormap (GdkDrawable *drawable);
 static void         gdk_window_impl_win32_set_colormap (GdkDrawable *drawable,
@@ -54,9 +50,9 @@
 static gpointer parent_class = NULL;
 static GSList *modal_window_stack = NULL;
 
-static void     update_style_bits         (GdkWindow *window);
-static gboolean _gdk_window_get_functions (GdkWindow     *window,
-                                           GdkWMFunction *functions);
+static void     update_style_bits         (GdkWindow         *window);
+static gboolean _gdk_window_get_functions (GdkWindow         *window,
+                                           GdkWMFunction     *functions);
 
 #define WINDOW_IS_TOPLEVEL(window)		   \
   (GDK_WINDOW_TYPE (window) != GDK_WINDOW_CHILD && \
@@ -699,6 +695,9 @@
   else
     impl->type_hint = GDK_WINDOW_TYPE_HINT_NORMAL;
 
+  if (impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY)
+    dwExStyle |= WS_EX_TOOLWINDOW;
+
   if (private->parent)
     private->parent->children = g_list_prepend (private->parent->children, window);
 
@@ -752,6 +751,9 @@
 			   hparent,
 			   GDK_WINDOW_HWND (window)));
 
+  /* Add window handle to title */
+  GDK_NOTE (MISC_OR_EVENTS, gdk_window_set_title (window, title));
+
   g_free (wtitle);
 
   if (draw_impl->handle == NULL)
@@ -1852,16 +1854,15 @@
 	  return TRUE;
 
 	case GDK_WINDOW_TYPE_HINT_TOOLBAR:
+	case GDK_WINDOW_TYPE_HINT_UTILITY:
 	  gdk_window_set_skip_taskbar_hint (window, TRUE);
-	  *decoration = GDK_DECOR_ALL | GDK_DECOR_MINIMIZE | GDK_DECOR_MAXIMIZE;
+	  gdk_window_set_skip_pager_hint (window, TRUE);
+	  *decoration = (GDK_DECOR_ALL | GDK_DECOR_MINIMIZE | GDK_DECOR_MAXIMIZE);
 	  return TRUE;
 
-	case GDK_WINDOW_TYPE_HINT_UTILITY:
-	  return FALSE;
-
 	case GDK_WINDOW_TYPE_HINT_SPLASHSCREEN:
-	  *decoration = (GDK_DECOR_ALL | GDK_DECOR_RESIZEH | GDK_DECOR_MENU
-                  | GDK_DECOR_MINIMIZE | GDK_DECOR_MAXIMIZE);
+	  *decoration = (GDK_DECOR_ALL | GDK_DECOR_RESIZEH | GDK_DECOR_MENU |
+			 GDK_DECOR_MINIMIZE | GDK_DECOR_MAXIMIZE);
 	  return TRUE;
 	  
 	case GDK_WINDOW_TYPE_HINT_DOCK:
@@ -1961,9 +1962,13 @@
   GDK_NOTE (MISC, g_print ("gdk_window_set_title: %p: %s\n",
 			   GDK_WINDOW_HWND (window), title));
   
+  GDK_NOTE (MISC_OR_EVENTS, title = g_strdup_printf ("%p %s", GDK_WINDOW_HWND (window), title));
+
   wtitle = g_utf8_to_utf16 (title, -1, NULL, NULL, NULL);
   API_CALL (SetWindowTextW, (GDK_WINDOW_HWND (window), wtitle));
   g_free (wtitle);
+
+  GDK_NOTE (MISC_OR_EVENTS, g_free ((char *) title));
 }
 
 void          
@@ -1992,6 +1997,8 @@
   window_id = GDK_WINDOW_HWND (window);
   parent_id = parent != NULL ? GDK_WINDOW_HWND (parent) : NULL;
 
+  GDK_NOTE (MISC, g_print ("gdk_window_set_transient_for: %p: %p\n", window_id, parent_id));
+
   if (GDK_WINDOW_DESTROYED (window) || (parent && GDK_WINDOW_DESTROYED (parent)))
     {
       if (GDK_WINDOW_DESTROYED (window))
@@ -2879,19 +2886,29 @@
 static void
 update_style_bits (GdkWindow *window)
 {
+  GdkWindowObject *private = (GdkWindowObject *)window;
+  GdkWindowImplWin32 *impl = (GdkWindowImplWin32 *)private->impl;
   GdkWMDecoration decorations;
-  LONG old_style, new_style, exstyle;
+  LONG old_style, new_style, old_exstyle, new_exstyle;
   gboolean all;
   RECT rect, before, after;
 
   old_style = GetWindowLong (GDK_WINDOW_HWND (window), GWL_STYLE);
-  exstyle = GetWindowLong (GDK_WINDOW_HWND (window), GWL_EXSTYLE);
+  old_exstyle = GetWindowLong (GDK_WINDOW_HWND (window), GWL_EXSTYLE);
 
   GetClientRect (GDK_WINDOW_HWND (window), &before);
   after = before;
-  AdjustWindowRectEx (&before, old_style, FALSE, exstyle);
+  AdjustWindowRectEx (&before, old_style, FALSE, old_exstyle);
 
   new_style = old_style;
+  new_exstyle = old_exstyle;
+
+  if (private->window_type == GDK_WINDOW_TEMP ||
+      impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY)
+    new_exstyle |= WS_EX_TOOLWINDOW;
+  else
+    new_exstyle &= ~WS_EX_TOOLWINDOW;
+
   if (get_effective_window_decorations (window, &decorations))
     {
       all = (decorations & GDK_DECOR_ALL);
@@ -2903,21 +2920,34 @@
       update_single_bit (&new_style, all, decorations & GDK_DECOR_MAXIMIZE, WS_MAXIMIZEBOX);
     }
 
-  if (old_style == new_style)
+  if (old_style == new_style && old_exstyle == new_exstyle )
     {
       GDK_NOTE (MISC, g_print ("update_style_bits: %p: no change\n",
 			       GDK_WINDOW_HWND (window)));
       return;
     }
 
-  GDK_NOTE (MISC, g_print ("update_style_bits: %p: %s => %s\n",
-			   GDK_WINDOW_HWND (window),
-			   _gdk_win32_window_style_to_string (old_style),
-			   _gdk_win32_window_style_to_string (new_style)));
+  if (old_style != new_style)
+    {
+      GDK_NOTE (MISC, g_print ("update_style_bits: %p: STYLE: %s => %s\n",
+			       GDK_WINDOW_HWND (window),
+			       _gdk_win32_window_style_to_string (old_style),
+			       _gdk_win32_window_style_to_string (new_style)));
+      
+      SetWindowLong (GDK_WINDOW_HWND (window), GWL_STYLE, new_style);
+    }
 
-  SetWindowLong (GDK_WINDOW_HWND (window), GWL_STYLE, new_style);
+  if (old_exstyle != new_exstyle)
+    {
+      GDK_NOTE (MISC, g_print ("update_style_bits: %p: EXSTYLE: %s => %s\n",
+			       GDK_WINDOW_HWND (window),
+			       _gdk_win32_window_exstyle_to_string (old_exstyle),
+			       _gdk_win32_window_exstyle_to_string (new_exstyle)));
+      
+      SetWindowLong (GDK_WINDOW_HWND (window), GWL_EXSTYLE, new_exstyle);
+    }
 
-  AdjustWindowRectEx (&after, new_style, FALSE, exstyle);
+  AdjustWindowRectEx (&after, new_style, FALSE, new_exstyle);
 
   GetWindowRect (GDK_WINDOW_HWND (window), &rect);
   rect.left += after.left - before.left;
@@ -3492,13 +3522,18 @@
 }
 
 void
-gdk_window_set_keep_above (GdkWindow *window, gboolean setting)
+gdk_window_set_keep_above (GdkWindow *window,
+			   gboolean   setting)
 {
   g_return_if_fail (GDK_IS_WINDOW (window));
 
   if (GDK_WINDOW_DESTROYED (window))
     return;
 
+  GDK_NOTE (MISC, g_print ("gdk_window_set_keep_above: %p: %s\n",
+			   GDK_WINDOW_HWND (window),
+			   setting ? "YES" : "NO"));
+
   if (GDK_WINDOW_IS_MAPPED (window))
     {
       API_CALL (SetWindowPos, (GDK_WINDOW_HWND (window),
@@ -3513,13 +3548,18 @@
 }
 
 void
-gdk_window_set_keep_below (GdkWindow *window, gboolean setting)
+gdk_window_set_keep_below (GdkWindow *window,
+			   gboolean   setting)
 {
   g_return_if_fail (GDK_IS_WINDOW (window));
 
   if (GDK_WINDOW_DESTROYED (window))
     return;
 
+  GDK_NOTE (MISC, g_print ("gdk_window_set_keep_below: %p: %s\n",
+			   GDK_WINDOW_HWND (window),
+			   setting ? "YES" : "NO"));
+
   if (GDK_WINDOW_IS_MAPPED (window))
     {
       API_CALL (SetWindowPos, (GDK_WINDOW_HWND (window),
@@ -3564,6 +3604,10 @@
   if (GDK_WINDOW_DESTROYED (window))
     return;
 
+  GDK_NOTE (MISC, g_print ("gdk_window_set_modal_hint: %p: %s\n",
+			   GDK_WINDOW_HWND (window),
+			   modal ? "YES" : "NO"));
+
   private = (GdkWindowObject*) window;
 
   if (modal == private->modal_hint)
@@ -3602,13 +3646,13 @@
 
   g_return_if_fail (GDK_IS_WINDOW (window));
 
+  GDK_NOTE (MISC, g_print ("gdk_window_set_skip_taskbar_hint: %p: %s, doing nothing\n",
+			   GDK_WINDOW_HWND (window),
+			   skips_taskbar ? "YES" : "NO"));
+
   // ### TODO: Need to figure out what to do here.
   return;
 
-  GDK_NOTE (MISC, g_print ("gdk_window_set_skip_taskbar_hint: %p: %s\n",
-			   GDK_WINDOW_HWND (window),
-			   skips_taskbar ? "TRUE" : "FALSE"));
-
   if (skips_taskbar)
     {
       if (owner == NULL)
@@ -3642,6 +3686,10 @@
 				gboolean   skips_pager)
 {
   g_return_if_fail (GDK_IS_WINDOW (window));
+
+  GDK_NOTE (MISC, g_print ("gdk_window_set_skip_pager_hint: %p: %s, doing nothing\n",
+			   GDK_WINDOW_HWND (window),
+			   skips_pager ? "YES" : "NO"));
 }
 
 void
@@ -3653,8 +3701,15 @@
   if (GDK_WINDOW_DESTROYED (window))
     return;
 
-  GDK_NOTE (MISC, g_print ("gdk_window_set_type_hint: %p: %d\n",
-			   GDK_WINDOW_HWND (window), hint));
+  GDK_NOTE (MISC,
+	    G_STMT_START{
+	      static GEnumClass *class = NULL;
+	      if (!class)
+		class = g_type_class_ref (GDK_TYPE_WINDOW_TYPE_HINT);
+	      g_print ("gdk_window_set_type_hint: %p: %s\n",
+		       GDK_WINDOW_HWND (window),
+		       g_enum_get_value (class, hint)->value_name);
+	    }G_STMT_END);
 
   ((GdkWindowImplWin32 *)((GdkWindowObject *)window)->impl)->type_hint = hint;
 
--- gtk/gtkfilechooserdefault.c	2008-09-22 21:33:15.000000000 +0300
+++ ../gtk-2-14/gtk/gtkfilechooserdefault.c	2008-10-04 22:47:23.527000000 +0300
@@ -934,8 +934,6 @@
 
   shortcuts_free (impl);
 
-  g_object_unref (impl->file_system);
-
   g_free (impl->browse_files_last_selected_name);
 
   for (l = impl->filters; l; l = l->next)
@@ -2076,10 +2074,17 @@
 	  if (_gtk_file_system_volume_is_mounted (volume))
 	    {
 	      GFile *base_file;
+              gboolean base_is_native = TRUE;
 
 	      base_file = _gtk_file_system_volume_get_root (volume);
-	      if (base_file != NULL && !g_file_is_native (base_file))
-		continue;
+              if (base_file != NULL)
+                {
+                  base_is_native = g_file_is_native (base_file);
+                  g_object_unref (base_file);
+                }
+
+              if (!base_is_native)
+                continue;
 	    }
 	}
 
@@ -2181,6 +2186,7 @@
 
   bookmarks = _gtk_file_system_list_bookmarks (impl->file_system);
   shortcuts_append_bookmarks (impl, bookmarks);
+  g_slist_foreach (bookmarks, (GFunc) g_object_unref, NULL);
   g_slist_free (bookmarks);
 
   if (impl->num_bookmarks == 0)
@@ -6504,7 +6510,7 @@
 
   impl->show_and_select_files_cancellable =
     _gtk_file_system_get_folder (impl->file_system, parent_file,
- 				 "standard::is-hidden,standard::type,standard::name",
+ 				 "standard::is-hidden,standard::type,standard::name,standard::content-type",
 			         show_and_select_files_get_folder_cb, info);
 
   profile_end ("end", NULL);
@@ -10194,12 +10200,16 @@
 
   if (!_gtk_file_system_volume_is_mounted (volume))
     {
+      GtkMountOperation *mount_op;
+
       set_busy_cursor (impl, TRUE);
 
+      mount_op = gtk_mount_operation_new (get_toplevel (GTK_WIDGET (impl)));
       impl->shortcuts_activate_iter_cancellable =
-        _gtk_file_system_mount_volume (impl->file_system, volume, NULL,
+        _gtk_file_system_mount_volume (impl->file_system, volume, mount_op,
 				       shortcuts_activate_volume_mount_cb,
 				       g_object_ref (impl));
+      g_object_unref (mount_op);
     }
   else
     {
--- gtk/gtkfilesystemmodel.c	2008-09-19 07:44:03.000000000 +0300
+++ ../gtk-2-14/gtk/gtkfilesystemmodel.c	2008-10-04 22:47:23.417625000 +0300
@@ -994,7 +994,7 @@
 
   if (folder)
     info->cleanups = g_slist_prepend (info->cleanups, folder);
-  else if (g_slist_length (info->files) == 1
+  else if ((info->files != NULL && info->files->next == NULL) /* g_slist_length == 1 */
            && g_file_equal (info->node->file, info->files->data))
     {
       /* Done, now call the function */
@@ -1022,10 +1022,10 @@
       goto out;
     }
 
-  g_object_unref (info->files);
+  g_object_unref (info->files->data);
   info->files = g_slist_remove (info->files, info->files->data);
 
-  if (g_slist_length (info->files) < 1)
+  if (info->files == NULL)
     {
       /* Done, now call the function */
       if (info->node)
@@ -1070,7 +1070,8 @@
 out:
   if (info->node)
     unref_node_and_parents (info->model, info->node);
-  g_object_unref (info->files);
+  g_slist_foreach (info->files, (GFunc)g_object_unref, NULL);
+  g_slist_free (info->files);
   g_slist_foreach (info->cleanups, (GFunc)g_object_unref, NULL);
   g_slist_free (info->cleanups);
   g_object_unref (info->model);
@@ -1133,8 +1134,9 @@
 	  return;
 	}
     }
+  g_object_unref (parent_file);
 
-  if (g_slist_length (files) < 1)
+  if (files == NULL)
     return;
 
   /* Now we have all paths, except the root path */
@@ -1151,7 +1153,7 @@
   g_object_unref (files->data);
   files = g_slist_remove (files, files->data);
 
-  if (g_slist_length (files) < 1)
+  if (files == NULL)
     {
       /* Done, now call the function */
       if (node)
--- gtk/gtkfilesystem.c	2008-09-22 20:51:30.000000000 +0300
+++ ../gtk-2-14/gtk/gtkfilesystem.c	2008-10-04 22:47:23.605125000 +0300
@@ -1304,7 +1304,9 @@
 
   if (error)
     {
-      g_warning (error->message);
+      if (!g_error_matches (error, G_IO_ERROR, G_IO_ERROR_CANCELLED))
+        g_warning ("%s", error->message);
+
       g_error_free (error);
       return;
     }
--- gdk-pixbuf/io-icns.c	2008-09-19 07:44:14.000000000 +0300
+++ ../gtk-2-14/gdk-pixbuf/io-icns.c	2008-10-01 13:42:45.204500000 +0300
@@ -19,7 +19,9 @@
  * Boston, MA 02111-1307, USA.
  */
 
+#ifndef _WIN32
 #define _GNU_SOURCE
+#endif
 #include <stdlib.h>
 #include <string.h>
 #include <errno.h>
--- gtk/gtkscalebutton.c	2008-09-19 07:44:05.000000000 +0300
+++ ../gtk-2-14/gtk/gtkscalebutton.c	2008-10-01 14:02:39.954500000 +0300
@@ -35,7 +35,9 @@
 
 #include "config.h"
 
+#ifndef _WIN32
 #define _GNU_SOURCE
+#endif
 #include <math.h>
 #include <stdlib.h>
 #include <string.h>
EOF

CC='gcc -mtune=pentium3 -mthreads' CPPFLAGS="-I/devel/dist/${ARCH}/${LIBPNG}/include -I/devel/dist/${ARCH}/${ZLIB}/include -I/devel/dist/${ARCH}/${LIBTIFF}/include -I/devel/dist/${ARCH}/${JPEG}/include -I/devel/dist/${ARCH}/${PROXY_LIBINTL}/include" LDFLAGS="-L/devel/dist/${ARCH}/${LIBPNG}/lib -L/devel/dist/${ARCH}/${ZLIB}/lib -L/devel/dist/${ARCH}/${LIBTIFF}/lib -L/devel/dist/${ARCH}/${JPEG}/lib -L/devel/dist/${ARCH}/${PROXY_LIBINTL}/lib -Wl,--exclude-libs=libintl.a -Wl,--enable-auto-image-base" LIBS=-lintl CFLAGS=-O2 ./configure --with-gdktarget=win32 --disable-gdiplus --with-included-loaders --with-included-immodules --without-libjasper --enable-debug=yes --enable-explicit-deps=no --disable-gtk-doc --disable-static --prefix=$TARGET &&
libtoolcacheize &&
rm gtk/gtk.def &&
(PATH="/devel/target/$HEX/bin:$PATH" make -j3 install || (rm .libtool-cache* && PATH="/devel/target/$HEX/bin:$PATH" make -j3 install)) &&

grep -v -E 'Automatically generated|Created by|LoaderDir =' <$TARGET/etc/gtk-2.0/gdk-pixbuf.loaders >$TARGET/etc/gtk-2.0/gdk-pixbuf.loaders.temp &&
    mv $TARGET/etc/gtk-2.0/gdk-pixbuf.loaders.temp $TARGET/etc/gtk-2.0/gdk-pixbuf.loaders &&
grep -v -E 'Automatically generated|Created by|ModulesPath =' <$TARGET/etc/gtk-2.0/gtk.immodules >$TARGET/etc/gtk-2.0/gtk.immodules.temp &&
    mv $TARGET/etc/gtk-2.0/gtk.immodules.temp $TARGET/etc/gtk-2.0/gtk.immodules &&

./gtk-zip.sh &&

mv /tmp/${MOD}-${VER}.zip /tmp/$RUNZIP &&
mv /tmp/${MOD}-dev-${VER}.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/make/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/make/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
