# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work envronment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=libbonoboui
VER=2.22.0
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`

MINOR=${VER%.*}
MINOR=${MINOR#*.}

(( $MINOR % 2 == 1 )) && UNSTABLE="-unstable"

DEPS=`/devel/src/tml/latest$UNSTABLE.sh popt libart_lgpl glib libglade atk cairo pango gtk+ libgnomecanvas libIDL ORBit2 libbonobo GConf libgnome gnome-vfs gail`

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

usedev

MY_PKG_CONFIG_PATH=""
for D in $DEPS; do
    PATH=/devel/dist/$D/bin:$PATH
    MY_PKG_CONFIG_PATH=/devel/dist/$D/lib/pkgconfig:$MY_PKG_CONFIG_PATH
done
PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH CC='gcc -mtune=pentium3 -mthreads' CPPFLAGS='-I/opt/gnu/include -I/devel/dist/popt-1.10.2-tml-20050828/include' LDFLAGS='-L/opt/gnu/lib -L/devel/dist/popt-1.10.2-tml-20050828/lib' CFLAGS=-O ./configure --enable-debug=yes --disable-gtk-doc --disable-static --prefix=c:/devel/target/$HEX &&
unset MY_PKG_CONFIG_PATH &&

libtoolcacheize &&

PATH=/devel/target/$HEX/bin:.libs:$PATH make install &&
(BONOBO_ACTIVATION_PATH=/devel/target/$HEX/lib/bonobo/servers PATH=/devel/target/$HEX/bin:$PATH make check || true) &&

./libbonoboui-zip &&

(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&
manifestify /tmp/$MOD*-$VER.zip
