# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=gettext
VER=0.17
REV=3
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

# Note that this build script is different from most of my build
# scripts, as it produces two sets of packages: "gettext-runtime" and
# "gettext-tools", and no packages called just "gettext".

RUNTIMERUNZIP=${MOD}-runtime_${VER}-${REV}_${ARCH}.zip
RUNTIMEDEVZIP=${MOD}-runtime-dev_${VER}-${REV}_${ARCH}.zip

TOOLSRUNZIP=${MOD}-tools_${VER}-${REV}_${ARCH}.zip
TOOLSDEVZIP=${MOD}-tools-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usemingw64
usemsvs9x64

(

set -x

WIN_ICONV=`latest --arch=${ARCH} win-iconv`

# Verify this from gettext-runtime/intl/Makefile.in
LTV_CURRENT_MINUS_AGE=8

patch -p0 <<'EOF'
--- /dev/null
+++ gettext-runtime/intl/intl.def
@@ -0,0 +1,29 @@
+EXPORTS
+_nl_msg_cat_cntr DATA
+bind_textdomain_codeset
+bindtextdomain
+dcgettext
+dcngettext
+dgettext
+dngettext
+gettext
+libintl_bind_textdomain_codeset
+libintl_bindtextdomain
+libintl_dcgettext
+libintl_dcngettext
+libintl_dgettext
+libintl_dngettext
+libintl_fprintf
+libintl_gettext
+libintl_ngettext
+libintl_printf
+libintl_set_relocation_prefix
+libintl_snprintf
+libintl_sprintf
+libintl_textdomain
+libintl_vfprintf
+libintl_vprintf
+libintl_vsprintf
+libintl_vsnprintf
+ngettext
+textdomain
--- gettext-runtime/intl/printf.c
+++ gettext-runtime/intl/printf.c
@@ -69,7 +69,7 @@
 #define STATIC static
 
 /* This needs to be consistent with libgnuintl.h.in.  */
-#if defined __NetBSD__ || defined __BEOS__ || defined __CYGWIN__ || defined __MINGW32__
+#if defined __NetBSD__ || defined __BEOS__ || defined __CYGWIN__
 /* Don't break __attribute__((format(printf,M,N))).
    This redefinition is only possible because the libc in NetBSD, Cygwin,
    mingw does not have a function __printf__.  */
--- gettext-runtime/intl/libgnuintl.h.in
+++ gettext-runtime/intl/libgnuintl.h.in
@@ -330,7 +330,7 @@
 extern int vfprintf (FILE *, const char *, va_list);
 
 #undef printf
-#if defined __NetBSD__ || defined __BEOS__ || defined __CYGWIN__ || defined __MINGW32__
+#if defined __NetBSD__ || defined __BEOS__ || defined __CYGWIN__
 /* Don't break __attribute__((format(printf,M,N))).
    This redefinition is only possible because the libc in NetBSD, Cygwin,
    mingw does not have a function __printf__.  */
diff -ru C:/DOCUME~1/tml/LOCALS~1/Temp/gettext-0.17/gettext-runtime/intl/Makefile.in ./gettext-runtime/intl/Makefile.in
--- C:/DOCUME~1/tml/LOCALS~1/Temp/gettext-0.17/gettext-runtime/intl/Makefile.in	2007-11-04 23:21:12.000000000 +0200
+++ gettext-runtime/intl/Makefile.in	2007-11-26 01:59:34.599000000 +0200
@@ -85,7 +85,7 @@
 CPPFLAGS = @CPPFLAGS@
 CFLAGS = @CFLAGS@ @CFLAG_VISIBILITY@
 LDFLAGS = @LDFLAGS@ $(LDFLAGS_@WOE32DLL@)
-LDFLAGS_yes = -Wl,--export-all-symbols
+LDFLAGS_yes = intl.def
 LDFLAGS_no =
 LIBS = @LIBS@
 
--- gettext-tools/gnulib-lib/clean-temp.c
+++ gettext-tools/gnulib-lib/clean-temp.c
@@ -66,9 +66,11 @@
 # endif
 #endif
 
+#ifndef _WIN64
 #ifndef uintptr_t
 # define uintptr_t unsigned long
 #endif
+#endif
 
 #if !GNULIB_FCNTL_SAFER
 /* The results of open() in this file are not used with fchdir,
--- gettext-tools/gnulib-lib/fstrcmp.c
+++ gettext-tools/gnulib-lib/fstrcmp.c
@@ -55,9 +55,11 @@
 #include "minmax.h"
 #include "xalloc.h"
 
+#ifndef _WIN64
 #ifndef uintptr_t
 # define uintptr_t unsigned long
 #endif
+#endif
 
 
 #define ELEMENT char
--- gettext-tools/gnulib-lib/gl_array_list.c
+++ gettext-tools/gnulib-lib/gl_array_list.c
@@ -55,9 +55,11 @@
 /* Checked size_t computations.  */
 #include "xsize.h"
 
+#ifndef _WIN64
 #ifndef uintptr_t
 # define uintptr_t unsigned long
 #endif
+#endif
 
 /* -------------------------- gl_list_t Data Type -------------------------- */
 
--- gettext-tools/gnulib-lib/gl_linkedhash_list.c
+++ gettext-tools/gnulib-lib/gl_linkedhash_list.c
@@ -55,9 +55,11 @@
 #include "xalloc.h"
 #include "xsize.h"
 
+#ifndef _WIN64
 #ifndef uintptr_t
 # define uintptr_t unsigned long
 #endif
+#endif
 
 #define WITH_HASHTABLE 1
 
--- gettext-tools/gnulib-lib/tempname.c
+++ gettext-tools/gnulib-lib/tempname.c
@@ -54,6 +54,10 @@
 #include <stdint.h>
 #include <unistd.h>
 
+#ifdef _WIN32
+# include <direct.h>
+#endif
+
 #include <sys/stat.h>
 
 #if _LIBC
@@ -73,6 +73,10 @@
 # define __xstat64(version, file, buf) stat (file, buf)
 #endif
 
+#ifdef _WIN32
+# define mkdir(path,mode) _mkdir(path)
+#endif
+
 #if ! (HAVE___SECURE_GETENV || _LIBC)
 # define __secure_getenv getenv
 #endif
--- gettext-tools/gnulib-lib/w32spawn.h
+++ gettext-tools/gnulib-lib/w32spawn.h
@@ -22,6 +22,7 @@
 /* Get _get_osfhandle() and _open_osfhandle().  */
 #include <io.h>
 
+#include <stdint.h>
 #include <stdbool.h>
 #include <string.h>
 #include <errno.h>
@@ -47,7 +47,7 @@
     error (EXIT_FAILURE, 0, _("DuplicateHandle failed with error code 0x%08x"),
 	   GetLastError ());
 
-  nfd = _open_osfhandle ((long) new_handle, O_BINARY);
+  nfd = _open_osfhandle ((intptr_t) new_handle, O_BINARY);
   if (nfd < 0)
     error (EXIT_FAILURE, errno, _("_open_osfhandle failed"));
 
--- gettext-tools/src/write-java.c
+++ gettext-tools/src/write-java.c
@@ -30,6 +30,10 @@
 #include <stdio.h>
 #include <string.h>
 
+#ifdef _WIN32
+# include <direct.h>
+#endif
+
 #include <sys/stat.h>
 #if !defined S_ISDIR && defined S_IFDIR
 # define S_ISDIR(mode) (((mode) & S_IFMT) == S_IFDIR)
@@ -53,6 +53,10 @@
 # define S_IXUSR 00100
 #endif
 
+#ifdef _WIN32
+# define mkdir(path,mode) _mkdir(path)
+#endif
+
 #include "c-ctype.h"
 #include "error.h"
 #include "xerror.h"
--- gettext-tools/src/write-csharp.c
+++ gettext-tools/src/write-csharp.c
@@ -29,6 +29,10 @@
 #include <stdio.h>
 #include <string.h>
 
+#ifdef _WIN32
+# include <direct.h>
+#endif
+
 #include <sys/stat.h>
 #if !defined S_ISDIR && defined S_IFDIR
 # define S_ISDIR(mode) (((mode) & S_IFMT) == S_IFDIR)
@@ -70,6 +70,10 @@
 # define S_IXOTH (S_IXUSR >> 6)
 #endif
 
+#ifdef _WIN32
+# define mkdir(path,mode) _mkdir(path)
+#endif
+
 #include "c-ctype.h"
 #include "relocatable.h"
 #include "error.h"
EOF

lt_cv_deplibs_check_method='pass_all' \
CC='x86_64-w64-mingw32-gcc' \
CFLAGS=-O2 \
./configure --host=x86_64-w64-mingw32 \
--disable-static \
--disable-java \
--enable-relocatable \
--disable-openmp \
--disable-largefile \
--with-libiconv-prefix=/devel/dist/${ARCH}/${WIN_ICONV} \
--prefix=c:/devel/target/$HEX &&

sed -e 's/need_relink=yes/need_relink=no/' <gettext-tools/libtool >gettext-tools/libtool.temp && mv gettext-tools/libtool.temp gettext-tools/libtool &&
PATH=/devel/target/$HEX/bin:$PATH make install &&

(cd /devel/target/$HEX &&
echo 'LIBRARY libintl-'${LTV_CURRENT_MINUS_AGE}'.dll
EXPORTS
_nl_msg_cat_cntr DATA
bind_textdomain_codeset
bindtextdomain
dcgettext
dcngettext
dgettext
dngettext
gettext
libintl_bind_textdomain_codeset
libintl_bindtextdomain
libintl_dcgettext
libintl_dcngettext
libintl_dgettext
libintl_dngettext
libintl_fprintf
libintl_gettext
libintl_ngettext
libintl_printf
libintl_set_relocation_prefix
libintl_snprintf
libintl_sprintf
libintl_textdomain
libintl_vfprintf
libintl_vprintf
libintl_vsnprintf
libintl_vsprintf
ngettext
textdomain' >lib/libintl.def &&

# Split into gettext-runtime and gettext-tools as suggested in the
# PACKAGING file. Additionally split gettext-runtime into "real
# runtime" and "developer" packages. For gettext-tools the "runtime"
# package is empty, as tools by definition are for developers.

rm -f /tmp/$RUNTIMERUNZIP /tmp/$RUNTIMEDEVZIP &&

zip /tmp/$RUNTIMERUNZIP bin/libintl-${LTV_CURRENT_MINUS_AGE}.dll &&
zip /tmp/$RUNTIMERUNZIP lib/charset.alias &&
zip /tmp/$RUNTIMERUNZIP share/locale/locale.alias &&

zip /tmp/$RUNTIMEDEVZIP lib/libintl.dll.a &&
(cd lib && lib.exe -machine:x64 -def:libintl.def -out:intl.lib) &&
zip /tmp/$RUNTIMEDEVZIP lib/libintl.def lib/intl.lib &&
zip /tmp/$RUNTIMEDEVZIP include/libintl.h &&
zip /tmp/$RUNTIMEDEVZIP bin/{{,n}gettext,envsubst}.exe &&
zip /tmp/$RUNTIMEDEVZIP bin/gettext.sh &&
zip -r -D /tmp/$RUNTIMEDEVZIP share/man/man1/{{,n}gettext,envsubst}.1 &&
zip -r -D /tmp/$RUNTIMEDEVZIP share/doc/gettext/{{,n}gettext,envsubst}.1.html &&
zip /tmp/$RUNTIMEDEVZIP share/locale/*/LC_MESSAGES/gettext-runtime.mo &&
zip /tmp/$RUNTIMEDEVZIP share/doc/gettext/*.3.html &&
zip /tmp/$RUNTIMEDEVZIP lib/GNU.Gettext.dll &&
zip -r -D /tmp/$RUNTIMEDEVZIP share/doc/gettext/csharpdoc &&
zip /tmp/$RUNTIMEDEVZIP bin/libasprintf*.dll &&
(cd /opt/mingw64 && zip /tmp/$RUNTIMEDEVZIP bin/libgcc_s_sjlj-1.dll) &&
zip /tmp/$RUNTIMEDEVZIP lib/libasprintf.dll.a  &&
zip /tmp/$RUNTIMEDEVZIP include/autosprintf.h &&
zip -r -D /tmp/$RUNTIMEDEVZIP share/doc/libasprintf &&
# zip /tmp/$RUNTIMEDEVZIP info/autosprintf.info &&

rm -f /tmp/$TOOLSRUNZIP /tmp/$TOOLSDEVZIP &&

# the TOOLSRUNZIP is empty. created only because some of my scripts
# want both a foo and foo-dev zipfile.
zip /tmp/$TOOLSRUNZIP nul &&
zip -d /tmp/$TOOLSRUNZIP nul &&

# Now the problem is to put everything else into the TOOLSDEVZIP...

zip /tmp/$TOOLSDEVZIP bin/{autopoint,gettextize,msg*,recode,xgettext} &&
(cd /opt/mingw64 && zip /tmp/$TOOLSDEVZIP bin/libgcc_s_sjlj-1.dll) &&
zip /tmp/$TOOLSDEVZIP share/man/man1/msg*.1 &&
zip /tmp/$TOOLSDEVZIP share/man/man1/xgettext.1
zip /tmp/$TOOLSDEVZIP share/man/man1/gettextize.1 &&
zip /tmp/$TOOLSDEVZIP share/man/man1/autopoint.1 &&
zip /tmp/$TOOLSDEVZIP share/doc/gettext/msg*.1.html &&
zip /tmp/$TOOLSDEVZIP share/doc/gettext/xgettext.1.html &&
zip /tmp/$TOOLSDEVZIP share/doc/gettext/gettextize.1.html &&
zip /tmp/$TOOLSDEVZIP share/doc/gettext/autopoint.1.html &&
zip /tmp/$TOOLSDEVZIP share/doc/gettext/gettext_*.html &&
zip /tmp/$TOOLSDEVZIP share/doc/gettext/FAQ.html &&
zip /tmp/$TOOLSDEVZIP share/doc/gettext/examples/* &&
# zip /tmp/$TOOLSDEVZIP info/gettext.info* &&
zip /tmp/$TOOLSDEVZIP include/gettext-po.h &&
zip /tmp/$TOOLSDEVZIP bin/libgettextlib*.dll &&
zip /tmp/$TOOLSDEVZIP bin/libgettextsrc*.dll &&
zip /tmp/$TOOLSDEVZIP bin/libgettextpo*.dll &&
zip /tmp/$TOOLSDEVZIP lib/gettext/* &&
zip /tmp/$TOOLSDEVZIP share/locale/*/LC_MESSAGES/gettext-tools.mo &&
zip /tmp/$TOOLSDEVZIP share/gettext/config.rpath &&
zip /tmp/$TOOLSDEVZIP share/gettext/intl/* &&
zip /tmp/$TOOLSDEVZIP share/gettext/po/* &&
zip /tmp/$TOOLSDEVZIP share/gettext/projects/* &&
zip /tmp/$TOOLSDEVZIP share/gettext/gettext.h &&
zip /tmp/$TOOLSDEVZIP share/gettext/archive.tar.gz &&
zip /tmp/$TOOLSDEVZIP share/aclocal/codeset.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/gettext.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/glibc2.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/glibc21.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/iconv.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/intdiv0.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/intl.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/intldir.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/intlmacosx.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/intmax.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/inttypes_h.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/inttypes-pri.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/lcmessage.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/lib-ld.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/lib-link.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/lib-prefix.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/lock.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/longlong.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/nls.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/po.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/printf-posix.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/progtest.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/size_max.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/stdint_h.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/uintmax_t.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/visibility.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/wchar_t.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/wint_t.m4 &&
zip /tmp/$TOOLSDEVZIP share/aclocal/xsize.m4 &&
zip /tmp/$TOOLSDEVZIP share/emacs/site-lisp/po-compat.el &&
zip /tmp/$TOOLSDEVZIP share/emacs/site-lisp/po-compat.elc &&
zip /tmp/$TOOLSDEVZIP share/emacs/site-lisp/po-mode.el &&
zip /tmp/$TOOLSDEVZIP share/emacs/site-lisp/po-mode.elc &&
zip /tmp/$TOOLSDEVZIP share/emacs/site-lisp/start-po.el &&
zip /tmp/$TOOLSDEVZIP share/emacs/site-lisp/start-po.elc &&

: )

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

# Put this script and the log file in both dev packages
(cd /devel && zip /tmp/$RUNTIMEDEVZIP src/tml/packaging/$THIS.{sh,log}) &&
(cd /devel && zip /tmp/$TOOLSDEVZIP src/tml/packaging/$THIS.{sh,log}) &&

manifestify /tmp/$RUNTIMERUNZIP /tmp/$RUNTIMEDEVZIP &&
manifestify /tmp/$TOOLSRUNZIP /tmp/$TOOLSDEVZIP
