# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=glib
VER=2.17.7
REV=1
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usestable
usemingw64
usemsvs9x64

(

set -x

# Avoid the silly "relink" stuff in libtool
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I
# can only do this if you have shared version of the
# library, which you do not appear to have."

# Screw libtool. I know what I am doing. Yes, I do want to link with a
# static libintl now. (The proxy-libintl libintl wrapper.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure &&

# Fix problems with libtool and Win64

sed -e 's!file format pe-i386!file format pe-!' <ltmain.sh >ltmain.sh.temp && mv ltmain.sh.temp ltmain.sh &&
sed -e 's!file_magic file format pei\*-i386!file_magic file format pei*-!' <configure >configure.temp && mv configure.temp configure &&

CC='x86_64-pc-mingw32-gcc' CPPFLAGS='-I/opt/proxy-libintl/include' LDFLAGS='-L/opt/proxy-libintl/lib64 -Wl,--exclude-libs=libintl.a -Wl,--enable-auto-image-base' CFLAGS=-O2 ./configure --host=x86_64-pc-mingw32 --disable-gtk-doc --prefix=$TARGET &&
libtoolcacheize &&
make glibconfig.h.win32 &&
make glibconfig.h &&
mv glibconfig.h glibconfig.h.autogened &&
cp glibconfig.h.win32 glibconfig.h &&
make -j3 install &&

./glib-zip &&

mv /tmp/glib-$VER.zip /tmp/$RUNZIP &&
mv /tmp/glib-dev-$VER.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/make/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/make/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
