/*
    SPDX-FileCopyrightText: 1999, 2000 David Faure <faure@kde.org>
    SPDX-FileCopyrightText: 1999, 2000 Simon Hausmann <hausmann@kde.org>

    SPDX-License-Identifier: LGPL-2.0-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef __parts_h__
#define __parts_h__

#include <kparts/readonlypart.h>
#include <KAboutData>

class QTextEdit;
namespace KParts
{
class GUIActivateEvent;
}

class Part1 : public KParts::ReadOnlyPart
{
    Q_OBJECT
public:
    Part1(QObject *parent, QWidget *parentWidget);
    virtual ~Part1();

public Q_SLOTS:
    void slotBlah();
    void slotFooBar();

protected:
    bool openFile() override;

protected:
    QTextEdit *m_edit;
    KAboutData m_componentData;
};

class Part2 : public KParts::Part
{
    Q_OBJECT
public:
    Part2(QObject *parent, QWidget *parentWidget);
    virtual ~Part2();

protected:
    // This is not mandatory - only if you care about setting the
    // part caption when the part is used in a multi-part environment
    // (i.e. in a part manager)
    // There is a default impl for ReadOnlyPart...
    void guiActivateEvent(KParts::GUIActivateEvent *) override;
    KAboutData m_componentData;
};

#endif
