/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content.playlist;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.dvb.media.VideoPresentationControl;
import org.havi.ui.HScreen;
import org.havi.ui.HScreenRectangle;
import org.havi.ui.HVideoConfiguration;
import org.videolan.Logger;
import org.videolan.StreamInfo;
import org.videolan.media.content.playlist.Handler;
import org.videolan.media.content.playlist.StreamControl;

public abstract class VideoControl
extends StreamControl
implements VideoPresentationControl {
    private int plane = 0;
    private HScreenRectangle srcArea = new HScreenRectangle(0.0f, 0.0f, 1.0f, 1.0f);
    private HScreenRectangle dstArea = new HScreenRectangle(0.0f, 0.0f, 1.0f, 1.0f);

    protected VideoControl(Handler player, int plane) {
        super(player);
        this.plane = plane;
    }

    protected HScreenRectangle getNormalizedRectangle(Dimension dimension, Rectangle rectangle) {
        if (dimension.width == 0 || dimension.height == 0) {
            return new HScreenRectangle(0.0f, 0.0f, 0.0f, 0.0f);
        }
        float x = (float)rectangle.x / (float)dimension.width;
        float y = (float)rectangle.y / (float)dimension.height;
        float w = (float)rectangle.width / (float)dimension.width;
        float h = (float)rectangle.height / (float)dimension.height;
        return new HScreenRectangle(x, y, w, h);
    }

    protected Rectangle getRectangle(Dimension dimension, HScreenRectangle rectangle) {
        int x = (int)(rectangle.x * (float)dimension.width);
        int y = (int)(rectangle.y * (float)dimension.height);
        int w = (int)(rectangle.width * (float)dimension.width);
        int h = (int)(rectangle.height * (float)dimension.height);
        return new Rectangle(x, y, w, h);
    }

    protected float getPositionOnScreen(float pos) {
        if (pos < 0.0f) {
            return 0.0f;
        }
        if (pos > 1.0f) {
            return 1.0f;
        }
        return pos;
    }

    protected HScreenRectangle getRectangleOnScreen(HScreenRectangle rectangle) {
        float x1 = this.getPositionOnScreen(rectangle.x);
        float y1 = this.getPositionOnScreen(rectangle.y);
        float x2 = this.getPositionOnScreen(rectangle.x + rectangle.width);
        float y2 = this.getPositionOnScreen(rectangle.y + rectangle.height);
        return new HScreenRectangle(x1, y1, x2 - x1, y2 - y1);
    }

    protected Dimension getScreenSize() {
        HVideoConfiguration hvc = HScreen.getDefaultHScreen().getDefaultHVideoDevice().getCurrentConfiguration();
        return hvc.getPixelResolution();
    }

    protected void setVideoArea(HScreenRectangle rectangle) {
        this.dstArea = rectangle;
    }

    public Dimension getInputVideoSize() {
        StreamInfo stream = this.getCurrentStream();
        if (stream == null) {
            return new Dimension(0, 0);
        }
        return stream.getVideoSize();
    }

    public Dimension getVideoSize() {
        Rectangle dr = this.getRectangle(this.getScreenSize(), this.dstArea);
        return new Dimension(dr.width, dr.height);
    }

    public HScreenRectangle getActiveVideoArea() {
        return new HScreenRectangle(this.dstArea.x, this.dstArea.y, this.dstArea.width, this.dstArea.height);
    }

    public HScreenRectangle getActiveVideoAreaOnScreen() {
        return this.getRectangleOnScreen(this.dstArea);
    }

    public HScreenRectangle getTotalVideoArea() {
        return this.getActiveVideoArea();
    }

    public HScreenRectangle getTotalVideoAreaOnScreen() {
        return this.getActiveVideoAreaOnScreen();
    }

    public boolean supportsClipping() {
        return true;
    }

    public Rectangle getClipRegion() {
        return this.getRectangle(this.getVideoSize(), this.srcArea);
    }

    public Rectangle setClipRegion(Rectangle clipRect) {
        Dimension vd = this.getInputVideoSize();
        if (vd.width == 0 || vd.height == 0) {
            return new Rectangle(0, 0);
        }
        this.srcArea = this.getRectangleOnScreen(this.getNormalizedRectangle(vd, clipRect));
        Logger.unimplemented("VideoControl", "setClipRegion");
        return this.getRectangle(vd, this.srcArea);
    }

    public float[] supportsArbitraryHorizontalScaling() {
        return new float[]{0.001f, 4.0f};
    }

    public float[] supportsArbitraryVerticalScaling() {
        return new float[]{0.001f, 4.0f};
    }

    public float[] getHorizontalScalingFactors() {
        Logger.unimplemented("VideoControl", "getHorizontalScalingFactors");
        return null;
    }

    public float[] getVerticalScalingFactors() {
        Logger.unimplemented("VideoControl", "getVerticalScalingFactors");
        return null;
    }

    public byte getPositioningCapability() {
        return 0;
    }

    public Component getControlComponent() {
        Logger.unimplemented("VideoControl", "getControlComponent");
        return null;
    }
}

