/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.FontUIResource;
import snmp.SNMPIPAddress;
import snmp.SNMPObject;
import snmp.SNMPObjectIdentifier;
import snmp.SNMPTimeTicks;
import snmp.SNMPTrapListener;
import snmp.SNMPTrapPDU;
import snmp.SNMPVarBindList;
import snmp.SNMPVariablePair;
import snmp.SNMPv1TrapListenerInterface;
import snmp.SNMPv1TrapSenderInterface;

public class SNMPTrapTest
extends JFrame
implements ActionListener,
SNMPTrapListener {
    JButton sendTrapButton;
    JButton clearButton;
    JTextArea messagesArea;
    JScrollPane messagesScroll;
    JTextField hostIDField;
    JTextField communityField;
    JTextField OIDField;
    JTextField valueField;
    JTextField enterpriseField;
    JTextField agentField;
    JLabel authorLabel;
    JLabel hostIDLabel;
    JLabel communityLabel;
    JLabel OIDLabel;
    JLabel valueLabel;
    JLabel enterpriseLabel;
    JLabel agentLabel;
    JLabel genericTrapLabel;
    JLabel specificTrapLabel;
    JComboBox valueTypeBox;
    JComboBox genericTrapBox;
    JComboBox specificTrapBox;
    MenuBar theMenubar;
    Menu fileMenu;
    MenuItem aboutItem;
    MenuItem quitItem;
    SNMPv1TrapListenerInterface trapListenerInterface;
    SNMPv1TrapSenderInterface trapSenderInterface;

    public SNMPTrapTest() {
        this.setUpDisplay();
        try {
            this.trapListenerInterface = new SNMPv1TrapListenerInterface();
            this.trapListenerInterface.addTrapListener(this);
            this.trapListenerInterface.startReceiving();
            this.trapSenderInterface = new SNMPv1TrapSenderInterface();
        }
        catch (Exception exception) {
            this.messagesArea.append("Problem starting Trap Test: " + exception.toString() + "\n");
        }
    }

    private void setUpDisplay() {
        Object object;
        this.setTitle("SNMP Trap Listener");
        this.getRootPane().setBorder(new BevelBorder(0));
        UIManager uIManager = new UIManager();
        FontUIResource fontUIResource = new FontUIResource("SansSerif", 0, 10);
        UIDefaults uIDefaults = uIManager.getLookAndFeelDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).indexOf("font") <= -1 && ((String)object).indexOf("Font") <= -1) continue;
            UIManager.put(object, fontUIResource);
        }
        this.addWindowListener(new WindowCloseAdapter());
        this.theMenubar = new MenuBar();
        this.setMenuBar(this.theMenubar);
        this.fileMenu = new Menu("File");
        this.aboutItem = new MenuItem("About...");
        this.aboutItem.setActionCommand("about");
        this.aboutItem.addActionListener(this);
        this.fileMenu.add(this.aboutItem);
        this.fileMenu.addSeparator();
        this.quitItem = new MenuItem("Quit");
        this.quitItem.setActionCommand("quit");
        this.quitItem.addActionListener(this);
        this.fileMenu.add(this.quitItem);
        this.theMenubar.add(this.fileMenu);
        this.hostIDLabel = new JLabel("Trap receiver address:");
        this.hostIDField = new JTextField(20);
        this.hostIDField.setText("10.0.1.1");
        this.hostIDField.setEditable(true);
        this.OIDLabel = new JLabel("additional variable OID:");
        this.OIDField = new JTextField(20);
        this.OIDField.setEditable(true);
        this.valueLabel = new JLabel("Value for additional variable:");
        this.valueField = new JTextField(20);
        this.valueField.setEditable(true);
        this.communityLabel = new JLabel("Community:");
        this.communityField = new JTextField(20);
        this.communityField.setText("public");
        this.communityField.setEditable(true);
        this.authorLabel = new JLabel(" Version 1.1        J. Sevy, January 2001 ");
        this.authorLabel.setFont(new Font("SansSerif", 2, 8));
        this.sendTrapButton = new JButton("Send trap");
        this.sendTrapButton.setActionCommand("send trap");
        this.sendTrapButton.addActionListener(this);
        this.clearButton = new JButton("Clear messages");
        this.clearButton.setActionCommand("clear messages");
        this.clearButton.addActionListener(this);
        this.messagesArea = new JTextArea(10, 60);
        this.messagesScroll = new JScrollPane(this.messagesArea);
        this.valueTypeBox = new JComboBox();
        this.valueTypeBox.addItem("SNMPInteger");
        this.valueTypeBox.addItem("SNMPCounter32");
        this.valueTypeBox.addItem("SNMPCounter64");
        this.valueTypeBox.addItem("SNMPGauge32");
        this.valueTypeBox.addItem("SNMPOctetString");
        this.valueTypeBox.addItem("SNMPIPAddress");
        this.valueTypeBox.addItem("SNMPNSAPAddress");
        this.valueTypeBox.addItem("SNMPObjectIdentifier");
        this.valueTypeBox.addItem("SNMPTimeTicks");
        this.valueTypeBox.addItem("SNMPUInteger32");
        this.enterpriseLabel = new JLabel("Enterprise OID:");
        this.enterpriseField = new JTextField(20);
        this.enterpriseField.setEditable(true);
        this.agentLabel = new JLabel("Agent IP address:");
        this.agentField = new JTextField(20);
        this.agentField.setEditable(true);
        this.genericTrapLabel = new JLabel("Generic trap:");
        this.genericTrapBox = new JComboBox();
        this.genericTrapBox.addItem("Cold start (0)");
        this.genericTrapBox.addItem("Warm start (1)");
        this.genericTrapBox.addItem("Link down (2)");
        this.genericTrapBox.addItem("Link up (3)");
        this.genericTrapBox.addItem("Authentication failure (4)");
        this.genericTrapBox.addItem("EGP neighbor loss (5)");
        this.genericTrapBox.addItem("Enterprise specific (6)");
        this.specificTrapLabel = new JLabel("Specific trap:");
        this.specificTrapBox = new JComboBox();
        this.specificTrapBox.addItem("0");
        this.specificTrapBox.addItem("1");
        this.specificTrapBox.addItem("2");
        this.specificTrapBox.addItem("3");
        this.specificTrapBox.addItem("4");
        this.specificTrapBox.addItem("4");
        object = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)object);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.sendTrapButton, gridBagConstraints);
        jPanel.add(this.sendTrapButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)object);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.hostIDLabel, gridBagConstraints);
        jPanel2.add(this.hostIDLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.hostIDField, gridBagConstraints);
        jPanel2.add(this.hostIDField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)object).setConstraints(this.communityLabel, gridBagConstraints);
        jPanel2.add(this.communityLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)object).setConstraints(this.communityField, gridBagConstraints);
        jPanel2.add(this.communityField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)object);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.enterpriseLabel, gridBagConstraints);
        jPanel3.add(this.enterpriseLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.enterpriseField, gridBagConstraints);
        jPanel3.add(this.enterpriseField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)object).setConstraints(this.agentLabel, gridBagConstraints);
        jPanel3.add(this.agentLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)object).setConstraints(this.agentField, gridBagConstraints);
        jPanel3.add(this.agentField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        ((GridBagLayout)object).setConstraints(this.genericTrapLabel, gridBagConstraints);
        jPanel3.add(this.genericTrapLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        ((GridBagLayout)object).setConstraints(this.genericTrapBox, gridBagConstraints);
        jPanel3.add(this.genericTrapBox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        ((GridBagLayout)object).setConstraints(this.specificTrapLabel, gridBagConstraints);
        jPanel3.add(this.specificTrapLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        ((GridBagLayout)object).setConstraints(this.specificTrapBox, gridBagConstraints);
        jPanel3.add(this.specificTrapBox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        ((GridBagLayout)object).setConstraints(this.OIDLabel, gridBagConstraints);
        jPanel3.add(this.OIDLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        ((GridBagLayout)object).setConstraints(this.OIDField, gridBagConstraints);
        jPanel3.add(this.OIDField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        ((GridBagLayout)object).setConstraints(this.valueLabel, gridBagConstraints);
        jPanel3.add(this.valueLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        ((GridBagLayout)object).setConstraints(this.valueField, gridBagConstraints);
        jPanel3.add(this.valueField);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        ((GridBagLayout)object).setConstraints(this.valueTypeBox, gridBagConstraints);
        jPanel3.add(this.valueTypeBox);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)object);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel("Received traps:");
        ((GridBagLayout)object).setConstraints(jLabel, gridBagConstraints);
        jPanel4.add(jLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        ((GridBagLayout)object).setConstraints(this.clearButton, gridBagConstraints);
        jPanel4.add(this.clearButton);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.anchor = 10;
        ((GridBagLayout)object).setConstraints(this.messagesScroll, gridBagConstraints);
        jPanel4.add(this.messagesScroll);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().setLayout((LayoutManager)object);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(jPanel2, gridBagConstraints);
        this.getContentPane().add(jPanel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)object).setConstraints(jPanel3, gridBagConstraints);
        this.getContentPane().add(jPanel3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        ((GridBagLayout)object).setConstraints(jPanel, gridBagConstraints);
        this.getContentPane().add(jPanel);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        ((GridBagLayout)object).setConstraints(jPanel4, gridBagConstraints);
        this.getContentPane().add(jPanel4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ((GridBagLayout)object).setConstraints(this.authorLabel, gridBagConstraints);
        this.getContentPane().add(this.authorLabel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "quit") {
            System.exit(0);
        }
        if (string == "clear messages") {
            this.messagesArea.setText("");
        }
        if (string == "about") {
            // empty if block
        }
        if (string == "send trap") {
            try {
                SNMPObject sNMPObject;
                String string2 = this.communityField.getText();
                boolean bl = false;
                InetAddress inetAddress = InetAddress.getByName(this.hostIDField.getText());
                SNMPObjectIdentifier sNMPObjectIdentifier = new SNMPObjectIdentifier(this.enterpriseField.getText());
                SNMPIPAddress sNMPIPAddress = new SNMPIPAddress(this.agentField.getText());
                int n = this.genericTrapBox.getSelectedIndex();
                int n2 = this.specificTrapBox.getSelectedIndex();
                SNMPTimeTicks sNMPTimeTicks = new SNMPTimeTicks(System.currentTimeMillis());
                SNMPVarBindList sNMPVarBindList = new SNMPVarBindList();
                String string3 = this.OIDField.getText();
                if (!string3.equals("")) {
                    sNMPObject = new SNMPObjectIdentifier(string3);
                    String string4 = this.valueField.getText();
                    String string5 = (String)this.valueTypeBox.getSelectedItem();
                    string5 = "snmp." + string5;
                    Class<?> clazz = Class.forName(string5);
                    SNMPObject sNMPObject2 = (SNMPObject)clazz.newInstance();
                    sNMPObject2.setValue(string4);
                    sNMPVarBindList.addSNMPObject(new SNMPVariablePair((SNMPObjectIdentifier)sNMPObject, sNMPObject2));
                }
                sNMPObject = new SNMPTrapPDU(sNMPObjectIdentifier, sNMPIPAddress, n, n2, sNMPTimeTicks, sNMPVarBindList);
                this.trapSenderInterface.sendTrap(inetAddress, string2, (SNMPTrapPDU)sNMPObject);
                this.messagesArea.append("Sent trap to " + this.hostIDField.getText() + ":\n");
                this.messagesArea.append("  enterprise OID:     " + ((SNMPTrapPDU)sNMPObject).getEnterpriseOID().toString() + "\n");
                this.messagesArea.append("  agent address:      " + ((SNMPTrapPDU)sNMPObject).getAgentAddress().toString() + "\n");
                this.messagesArea.append("  generic trap:       " + ((SNMPTrapPDU)sNMPObject).getGenericTrap() + "\n");
                this.messagesArea.append("  specific trap:      " + ((SNMPTrapPDU)sNMPObject).getSpecificTrap() + "\n");
                this.messagesArea.append("  timestamp:          " + ((SNMPTrapPDU)sNMPObject).getTimestamp() + "\n");
                this.messagesArea.append("  supplementary vars: " + ((SNMPTrapPDU)sNMPObject).getVarBindList().toString() + "\n");
                this.messagesArea.append("\n");
            }
            catch (InterruptedIOException interruptedIOException) {
                this.messagesArea.append("Interrupted during trap send:  " + interruptedIOException + "\n");
            }
            catch (Exception exception) {
                this.messagesArea.append("Exception during trap send:  " + exception + "\n");
            }
        }
    }

    public void processTrap(SNMPTrapPDU sNMPTrapPDU) {
        this.messagesArea.append("Got trap:\n");
        this.messagesArea.append("  enterprise OID:     " + sNMPTrapPDU.getEnterpriseOID().toString() + "\n");
        this.messagesArea.append("  agent address:      " + sNMPTrapPDU.getAgentAddress().toString() + "\n");
        this.messagesArea.append("  generic trap:       " + sNMPTrapPDU.getGenericTrap() + "\n");
        this.messagesArea.append("  specific trap:      " + sNMPTrapPDU.getSpecificTrap() + "\n");
        this.messagesArea.append("  timestamp:          " + sNMPTrapPDU.getTimestamp() + "\n");
        this.messagesArea.append("  supplementary vars: " + sNMPTrapPDU.getVarBindList().toString() + "\n");
        this.messagesArea.append("\n");
    }

    public static void main(String[] stringArray) {
        try {
            SNMPTrapTest sNMPTrapTest = new SNMPTrapTest();
            sNMPTrapTest.pack();
            sNMPTrapTest.setSize(600, 500);
            sNMPTrapTest.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class WindowCloseAdapter
    extends WindowAdapter {
        private WindowCloseAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }
}

