/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;
import gnu.math.RealNum;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Arithmetic {
    public static final int INT_CODE = 1;
    public static final int LONG_CODE = 2;
    public static final int BIGINTEGER_CODE = 3;
    public static final int INTNUM_CODE = 4;
    public static final int BIGDECIMAL_CODE = 5;
    public static final int RATNUM_CODE = 6;
    public static final int FLOAT_CODE = 7;
    public static final int DOUBLE_CODE = 8;
    public static final int FLONUM_CODE = 9;
    public static final int REALNUM_CODE = 10;
    public static final int NUMERIC_CODE = 11;
    static ClassType typeDFloNum = ClassType.make("gnu.math.DFloNum");
    static ClassType typeRatNum = ClassType.make("gnu.math.RatNum");
    static ClassType typeRealNum = ClassType.make("gnu.math.RealNum");
    static ClassType typeNumber = ClassType.make("java.lang.Number");
    static ClassType typeNumeric = ClassType.make("gnu.math.Numeric");
    static ClassType typeIntNum = ClassType.make("gnu.math.IntNum");
    public static final IntNum ten_exp_9 = IntNum.make(1000000000);

    public static int classifyValue(Object object2) {
        if (object2 instanceof Numeric) {
            if (object2 instanceof IntNum) {
                return 4;
            }
            if (object2 instanceof RatNum) {
                return 6;
            }
            if (object2 instanceof DFloNum) {
                return 9;
            }
            if (object2 instanceof RealNum) {
                return 10;
            }
            return 11;
        }
        if (object2 instanceof Number) {
            if (object2 instanceof Integer || object2 instanceof Short || object2 instanceof Byte) {
                return 1;
            }
            if (object2 instanceof Long) {
                return 2;
            }
            if (object2 instanceof Float) {
                return 7;
            }
            if (object2 instanceof Double) {
                return 8;
            }
            if (object2 instanceof BigInteger) {
                return 3;
            }
            if (object2 instanceof BigDecimal) {
                return 5;
            }
            return -1;
        }
        return -1;
    }

    public static Type kindType(int n) {
        switch (n) {
            case 1: {
                return LangPrimType.intType;
            }
            case 2: {
                return LangPrimType.longType;
            }
            case 3: {
                return ClassType.make("java.math.BigInteger");
            }
            case 4: {
                return typeIntNum;
            }
            case 5: {
                return ClassType.make("java.math.BigDecimal");
            }
            case 6: {
                return typeRatNum;
            }
            case 7: {
                return LangPrimType.floatType;
            }
            case 8: {
                return LangPrimType.doubleType;
            }
            case 9: {
                return typeDFloNum;
            }
            case 10: {
                return typeRealNum;
            }
            case 11: {
                return typeNumeric;
            }
        }
        return Type.pointer_type;
    }

    public static int classifyType(Type type) {
        boolean bl = false;
        if (type instanceof PrimType) {
            char c = type.getSignature().charAt(0);
            if (c == 'V' || c == 'Z' || c == 'C') {
                return 0;
            }
            if (c == 'D') {
                return 8;
            }
            if (c == 'F') {
                return 7;
            }
            if (c == 'J') {
                return 2;
            }
            return 1;
        }
        String string = type.getName();
        if (type.isSubtype(typeIntNum)) {
            return 4;
        }
        if (type.isSubtype(typeRatNum)) {
            return 6;
        }
        if (type.isSubtype(typeDFloNum)) {
            return 9;
        }
        if ("java.lang.Double".equals(string)) {
            return 8;
        }
        if ("java.lang.Float".equals(string)) {
            return 7;
        }
        if ("java.lang.Long".equals(string)) {
            return 2;
        }
        if ("java.lang.Integer".equals(string) || "java.lang.Short".equals(string) || "java.lang.Byte".equals(string)) {
            return 1;
        }
        if ("java.math.BigInteger".equals(string)) {
            return 3;
        }
        if ("java.math.BigDecimal".equals(string)) {
            return 5;
        }
        if (type.isSubtype(typeRealNum)) {
            return 10;
        }
        if (type.isSubtype(typeNumeric)) {
            return 11;
        }
        return 0;
    }

    public static int asInt(Object object2) {
        return ((Number)object2).intValue();
    }

    public static long asLong(Object object2) {
        return ((Number)object2).longValue();
    }

    public static float asFloat(Object object2) {
        return ((Number)object2).floatValue();
    }

    public static double asDouble(Object object2) {
        return ((Number)object2).doubleValue();
    }

    public static BigInteger asBigInteger(Object object2) {
        if (object2 instanceof BigInteger) {
            return (BigInteger)object2;
        }
        if (object2 instanceof IntNum) {
            return new BigInteger(object2.toString());
        }
        return BigInteger.valueOf(((Number)object2).longValue());
    }

    public static IntNum asIntNum(BigDecimal bigDecimal) {
        return IntNum.valueOf(bigDecimal.toBigInteger().toString(), 10);
    }

    public static IntNum asIntNum(BigInteger bigInteger) {
        return IntNum.valueOf(bigInteger.toString(), 10);
    }

    public static IntNum asIntNum(Object object2) {
        if (object2 instanceof IntNum) {
            return (IntNum)object2;
        }
        if (object2 instanceof BigInteger) {
            return IntNum.valueOf(object2.toString(), 10);
        }
        if (object2 instanceof BigDecimal) {
            return Arithmetic.asIntNum((BigDecimal)object2);
        }
        return IntNum.make(((Number)object2).longValue());
    }

    public static BigDecimal asBigDecimal(Object object2) {
        if (object2 instanceof BigDecimal) {
            return (BigDecimal)object2;
        }
        if (object2 instanceof BigInteger) {
            return new BigDecimal((BigInteger)object2);
        }
        if (object2 instanceof Long || object2 instanceof Integer || object2 instanceof Short || object2 instanceof Byte) {
            return BigDecimal.valueOf(((Number)object2).longValue());
        }
        return new BigDecimal(object2.toString());
    }

    public static RatNum asRatNum(Object object2) {
        if (object2 instanceof RatNum) {
            return (RatNum)object2;
        }
        if (object2 instanceof BigInteger) {
            return IntNum.valueOf(object2.toString(), 10);
        }
        if (object2 instanceof BigDecimal) {
            IntNum intNum;
            int n;
            BigDecimal bigDecimal = (BigDecimal)object2;
            RatNum ratNum = IntNum.valueOf(bigDecimal.unscaledValue().toString(), 10);
            for (n = bigDecimal.scale(); n >= 9; n -= 9) {
                ratNum = RatNum.divide(ratNum, ten_exp_9);
            }
            while (n <= -9) {
                ratNum = RatNum.times(ratNum, ten_exp_9);
                n += 9;
            }
            switch (n > 0 ? n : -n) {
                case 1: {
                    intNum = IntNum.make(10);
                    break;
                }
                case 2: {
                    intNum = IntNum.make(100);
                    break;
                }
                case 3: {
                    intNum = IntNum.make(1000);
                    break;
                }
                case 4: {
                    intNum = IntNum.make(10000);
                    break;
                }
                case 5: {
                    intNum = IntNum.make(100000);
                    break;
                }
                case 6: {
                    intNum = IntNum.make(1000000);
                    break;
                }
                case 7: {
                    intNum = IntNum.make(10000000);
                    break;
                }
                case 8: {
                    intNum = IntNum.make(100000000);
                    break;
                }
                default: {
                    return ratNum;
                }
            }
            if (n > 0) {
                return RatNum.divide(ratNum, intNum);
            }
            return RatNum.times(ratNum, intNum);
        }
        return IntNum.make(((Number)object2).longValue());
    }

    public static Numeric asNumeric(Object object2) {
        if (!(object2 instanceof Numeric)) {
            if (object2 instanceof BigInteger || object2 instanceof Long || object2 instanceof Short || object2 instanceof Byte || object2 instanceof Integer) {
                return Arithmetic.asIntNum(object2);
            }
            if (object2 instanceof BigDecimal) {
                return Arithmetic.asRatNum(object2);
            }
            if (object2 instanceof Float || object2 instanceof Double) {
                return new DFloNum(Arithmetic.asDouble(object2));
            }
        }
        return (Numeric)object2;
    }

    public static String toString(Object object2, int n) {
        int n2 = Arithmetic.classifyValue(object2);
        switch (n2) {
            case 1: {
                return Integer.toString(Arithmetic.asInt(object2), n);
            }
            case 2: {
                return Long.toString(Arithmetic.asLong(object2), n);
            }
            case 3: {
                return Arithmetic.asBigInteger(object2).toString(n);
            }
            case 4: {
                return Arithmetic.asIntNum(object2).toString(n);
            }
            case 5: {
                if (n == 10) {
                    return Arithmetic.asBigDecimal(object2).toString();
                }
            }
            case 7: {
                if (n == 10) {
                    return Float.toString(Arithmetic.asFloat(object2));
                }
            }
            case 8: 
            case 9: {
                if (n != 10) break;
                return Double.toString(Arithmetic.asDouble(object2));
            }
        }
        return Arithmetic.asNumeric(object2).toString(n);
    }

    public static Object convert(Object object2, int n) {
        switch (n) {
            case 1: {
                if (object2 instanceof Integer) {
                    return object2;
                }
                int n2 = ((Number)object2).intValue();
                return n2;
            }
            case 2: {
                if (object2 instanceof Long) {
                    return object2;
                }
                long l = ((Number)object2).longValue();
                return l;
            }
            case 3: {
                return Arithmetic.asBigInteger(object2);
            }
            case 4: {
                return Arithmetic.asIntNum(object2);
            }
            case 5: {
                return Arithmetic.asBigDecimal(object2);
            }
            case 6: {
                return Arithmetic.asRatNum(object2);
            }
            case 7: {
                if (object2 instanceof Float) {
                    return object2;
                }
                float f = Arithmetic.asFloat(object2);
                return Float.valueOf(f);
            }
            case 8: {
                if (object2 instanceof Double) {
                    return object2;
                }
                double d = Arithmetic.asDouble(object2);
                return d;
            }
            case 9: {
                if (object2 instanceof DFloNum) {
                    return object2;
                }
                return DFloNum.make(Arithmetic.asDouble(object2));
            }
            case 11: {
                return Arithmetic.asNumeric(object2);
            }
            case 10: {
                return (RealNum)Arithmetic.asNumeric(object2);
            }
        }
        return (Number)object2;
    }
}

