/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.Member;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Keyword;
import gnu.expr.Language;
import gnu.expr.LetExp;
import gnu.expr.PairClassType;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.TypeValue;
import gnu.kawa.lispexpr.ClassNamespace;
import gnu.kawa.reflect.ArrayNew;
import gnu.kawa.reflect.ArraySet;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.SlotSet;
import gnu.lists.FString;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.Symbol;
import gnu.mapping.WrongType;
import java.lang.reflect.Array;

public class Invoke
extends ProcedureN
implements CanInline {
    char kind;
    Language language;
    public static final Invoke invoke = new Invoke("invoke", '*');
    public static final Invoke invokeStatic = new Invoke("invoke-static", 'S');
    public static final Invoke invokeSpecial = new Invoke("invoke-special", 'P');
    public static final Invoke make = new Invoke("make", 'N');

    public Invoke(String string, char c) {
        super(string);
        this.kind = c;
        this.language = Language.getDefaultLanguage();
    }

    public Invoke(String string, char c, Language language) {
        super(string);
        this.kind = c;
        this.language = language;
    }

    public static Object invoke$V(Object[] objectArray) throws Throwable {
        return invoke.applyN(objectArray);
    }

    public static Object invokeStatic$V(Object[] objectArray) throws Throwable {
        return invokeStatic.applyN(objectArray);
    }

    public static Object make$V(Object[] objectArray) throws Throwable {
        return make.applyN(objectArray);
    }

    private static ObjectType typeFrom(Object object2, Invoke invoke) {
        if (object2 instanceof Class) {
            object2 = Type.make((Class)object2);
        }
        if (object2 instanceof ObjectType) {
            return (ObjectType)object2;
        }
        if (object2 instanceof String || object2 instanceof FString) {
            return ClassType.make(object2.toString());
        }
        if (object2 instanceof Symbol) {
            return ClassType.make(((Symbol)object2).getName());
        }
        if (object2 instanceof ClassNamespace) {
            return ((ClassNamespace)object2).getClassType();
        }
        throw new WrongType((Procedure)invoke, 0, object2, "class-specifier");
    }

    public void apply(CallContext callContext) throws Throwable {
        Object[] objectArray = callContext.getArgs();
        if (this.kind == 'S' || this.kind == 'V' || this.kind == 's' || this.kind == '*') {
            int n = objectArray.length;
            Procedure.checkArgCount(this, n);
            Object object2 = objectArray[0];
            ObjectType objectType = this.kind == 'S' || this.kind == 's' ? Invoke.typeFrom(object2, this) : Type.make(object2.getClass());
            MethodProc methodProc = this.lookupMethods(objectType, objectArray[1]);
            Object[] objectArray2 = new Object[n - (this.kind == 'S' ? 2 : 1)];
            int n2 = 0;
            if (this.kind == 'V' || this.kind == '*') {
                objectArray2[n2++] = objectArray[0];
            }
            System.arraycopy(objectArray, 2, objectArray2, n2, n - 2);
            methodProc.checkN(objectArray2, callContext);
        } else {
            callContext.writeValue(this.applyN(objectArray));
        }
    }

    public Object applyN(Object[] objectArray) throws Throwable {
        MethodProc methodProc;
        Object object2;
        Object object3;
        ObjectType objectType;
        if (this.kind == 'P') {
            throw new RuntimeException(this.getName() + ": invoke-special not allowed at run time");
        }
        int n = objectArray.length;
        Procedure.checkArgCount(this, n);
        Object object4 = objectArray[0];
        ObjectType objectType2 = objectType = this.kind != 'V' && this.kind != '*' ? Invoke.typeFrom(object4, this) : (ObjectType)Type.make(object4.getClass());
        if (this.kind == 'N') {
            object3 = null;
            if (objectType instanceof TypeValue && (object2 = ((TypeValue)((Object)objectType)).getConstructor()) != null) {
                Object[] objectArray2 = new Object[--n];
                System.arraycopy(objectArray, 1, objectArray2, 0, n);
                return ((Procedure)object2).applyN(objectArray2);
            }
            if (objectType instanceof PairClassType) {
                object2 = (PairClassType)objectType;
                objectType = ((PairClassType)object2).instanceType;
            }
            if (objectType instanceof ArrayType) {
                boolean bl;
                int n2;
                int n3;
                String string;
                object2 = ((ArrayType)objectType).getComponentType();
                int n4 = objectArray.length - 1;
                if (n4 >= 2 && objectArray[1] instanceof Keyword && ("length".equals(string = ((Keyword)objectArray[1]).getName()) || "size".equals(string))) {
                    n3 = ((Number)objectArray[2]).intValue();
                    n2 = 3;
                    bl = true;
                } else {
                    n3 = n4;
                    n2 = 1;
                    bl = false;
                }
                Object object5 = Array.newInstance(((Type)object2).getReflectClass(), n3);
                int n5 = 0;
                while (n2 <= n4) {
                    Object object6 = objectArray[n2];
                    if (bl && object6 instanceof Keyword && n2 < n4) {
                        String string2 = ((Keyword)object6).getName();
                        try {
                            n5 = Integer.parseInt(string2);
                        }
                        catch (Throwable throwable) {
                            throw new RuntimeException("non-integer keyword '" + string2 + "' in array constructor");
                        }
                        object6 = objectArray[++n2];
                    }
                    Array.set(object5, n5, ((Type)object2).coerceFromObject(object6));
                    ++n5;
                    ++n2;
                }
                return object5;
            }
        } else {
            object3 = objectArray[1];
        }
        object2 = this.lookupMethods(objectType, object3);
        if (this.kind != 'N') {
            Object[] objectArray3 = new Object[n - (this.kind == 'S' || this.kind == 's' ? 2 : 1)];
            int n6 = 0;
            if (this.kind == 'V' || this.kind == '*') {
                objectArray3[n6++] = objectArray[0];
            }
            System.arraycopy(objectArray, 2, objectArray3, n6, n - 2);
            return ((MethodProc)object2).applyN(objectArray3);
        }
        CallContext callContext = CallContext.getInstance();
        int n7 = ((Procedure)object2).matchN(objectArray, callContext);
        if (n7 == 0) {
            return callContext.runUntilValue();
        }
        if ((n & 1) == 1) {
            int n8 = 1;
            while (true) {
                if (n8 == n) {
                    Object object7 = ((ProcedureN)object2).apply1(objectArray[0]);
                    for (n8 = 1; n8 < n; n8 += 2) {
                        Keyword keyword = (Keyword)objectArray[n8];
                        Object object8 = objectArray[n8 + 1];
                        SlotSet.apply(false, object7, keyword.getName(), object8);
                    }
                    return object7;
                }
                if (!(objectArray[n8] instanceof Keyword)) break;
                n8 += 2;
            }
        }
        if ((methodProc = ClassMethods.apply((ClassType)objectType, "valueOf", '\u0000', this.language)) != null) {
            Object[] objectArray4 = new Object[n - 1];
            System.arraycopy(objectArray, 1, objectArray4, 0, n - 1);
            n7 = methodProc.matchN(objectArray4, callContext);
            if (n7 == 0) {
                return callContext.runUntilValue();
            }
        }
        throw MethodProc.matchFailAsException(n7, (Procedure)object2, objectArray);
    }

    public int numArgs() {
        return 0xFFFFF000 | (this.kind == 'N' ? 1 : 2);
    }

    protected MethodProc lookupMethods(ObjectType objectType, Object object2) {
        String string;
        if (this.kind == 'N') {
            string = "<init>";
        } else {
            if (object2 instanceof String || object2 instanceof FString) {
                string = object2.toString();
            } else if (object2 instanceof Symbol) {
                string = ((Symbol)object2).getName();
            } else {
                throw new WrongType((Procedure)this, 1, null);
            }
            string = Compilation.mangleName(string);
        }
        MethodProc methodProc = ClassMethods.apply(objectType, string, (char)(this.kind == 'P' ? 80 : (this.kind == '*' || this.kind == 'V' ? 86 : 0)), this.language);
        if (methodProc == null) {
            throw new RuntimeException(this.getName() + ": no method named `" + string + "' in class " + objectType.getName());
        }
        return methodProc;
    }

    protected PrimProcedure[] getMethods(ObjectType objectType, String string, ClassType classType) {
        return ClassMethods.getMethods(objectType, string, this.kind == 'P' ? (char)'P' : (this.kind == '*' || this.kind == 'V' ? (char)'V' : '\u0000'), classType, this.language);
    }

    private static long selectApplicable(PrimProcedure[] primProcedureArray, ObjectType objectType, Expression[] expressionArray, int n, int n2, int n3) {
        Type[] typeArray = new Type[n];
        int n4 = 0;
        if (n3 >= 0) {
            typeArray[n4++] = objectType;
        }
        for (int i = n2; i < expressionArray.length && n4 < typeArray.length; ++i, ++n4) {
            typeArray[n4] = expressionArray[i].getType();
        }
        return ClassMethods.selectApplicable(primProcedureArray, typeArray);
    }

    static Object[] checkKeywords(Type type, Expression[] expressionArray, int n, ClassType classType) {
        int n2 = expressionArray.length;
        if ((n2 - n & 1) != 0) {
            return null;
        }
        Object[] objectArray = new Object[n2 - n >> 1];
        int n3 = objectArray.length;
        while (--n3 >= 0) {
            Expression expression = expressionArray[n + 2 * n3];
            if (!(expression instanceof QuoteExp)) {
                return null;
            }
            Object object2 = ((QuoteExp)expression).getValue();
            if (!(object2 instanceof Keyword)) {
                return null;
            }
            String string = ((Keyword)object2).getName();
            Member member = SlotSet.lookupMember((ObjectType)type, string, classType);
            objectArray[n3] = member != null ? member : string;
        }
        return objectArray;
    }

    public static int checkKnownClass(Type type, Compilation compilation) {
        if (type instanceof ClassType && ((ClassType)type).isExisting()) {
            try {
                type.getReflectClass();
                return 1;
            }
            catch (Exception exception) {
                compilation.error('e', "unknown class: " + type.getName());
                return -1;
            }
        }
        return 0;
    }

    public static ApplyExp inlineClassName(ApplyExp applyExp, int n, InlineCalls inlineCalls) {
        Compilation compilation = inlineCalls.getCompilation();
        Language language = compilation.getLanguage();
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length > n) {
            Type type = language.getTypeFor(expressionArray[n]);
            if (!(type instanceof Type)) {
                return applyExp;
            }
            Invoke.checkKnownClass(type, compilation);
            Expression[] expressionArray2 = new Expression[expressionArray.length];
            System.arraycopy(expressionArray, 0, expressionArray2, 0, expressionArray.length);
            expressionArray2[n] = new QuoteExp(type);
            ApplyExp applyExp2 = new ApplyExp(applyExp.getFunction(), expressionArray2);
            applyExp2.setLine(applyExp);
            return applyExp2;
        }
        return applyExp;
    }

    public Expression inline(ApplyExp applyExp, InlineCalls inlineCalls, boolean bl) {
        int n;
        int n2;
        int n3;
        Type type;
        applyExp.walkArgs(inlineCalls, bl);
        Compilation compilation = inlineCalls.getCompilation();
        Expression[] expressionArray = applyExp.getArgs();
        int n4 = expressionArray.length;
        if (!compilation.mustCompile || n4 == 0 || (this.kind == 'V' || this.kind == '*') && n4 == 1) {
            return applyExp;
        }
        Expression expression = expressionArray[0];
        Type type2 = type = this.kind == 'V' || this.kind == '*' ? expression.getType() : this.language.getTypeFor(expression);
        ObjectType objectType = type instanceof PairClassType ? ((PairClassType)type).instanceType : (type instanceof ObjectType ? (ObjectType)type : null);
        String string = this.getMethodName(expressionArray);
        if (this.kind == 'V' || this.kind == '*') {
            n3 = n4 - 1;
            n2 = 2;
            n = 0;
        } else if (this.kind == 'N') {
            n3 = n4;
            n2 = 0;
            n = -1;
        } else if (this.kind == 'S' || this.kind == 's') {
            n3 = n4 - 2;
            n2 = 2;
            n = -1;
        } else if (this.kind == 'P') {
            n3 = n4 - 2;
            n2 = 3;
            n = 1;
        } else {
            return applyExp;
        }
        if (this.kind == 'N' && objectType instanceof ArrayType) {
            int n5;
            Object object2;
            ArrayType arrayType = (ArrayType)objectType;
            Type type3 = arrayType.getComponentType();
            Expression expression2 = null;
            boolean bl2 = false;
            if (expressionArray.length >= 3 && expressionArray[1] instanceof QuoteExp && (object2 = ((QuoteExp)expressionArray[1]).getValue()) instanceof Keyword && ("length".equals(string = ((Keyword)object2).getName()) || "size".equals(string))) {
                expression2 = expressionArray[2];
                bl2 = true;
            }
            if (expression2 == null) {
                expression2 = QuoteExp.getInstance(new Integer(expressionArray.length - 1));
            }
            object2 = new ApplyExp(new ArrayNew(type3), new Expression[]{expression2});
            if (bl2 && expressionArray.length == 3) {
                return object2;
            }
            LetExp letExp = new LetExp(new Expression[]{object2});
            Declaration declaration = letExp.addDeclaration(null, arrayType);
            declaration.noteValue((Expression)object2);
            BeginExp beginExp = new BeginExp();
            int n6 = 0;
            int n7 = n5 = bl2 ? 3 : 1;
            while (n5 < expressionArray.length) {
                Object object3;
                Expression expression3 = expressionArray[n5];
                if (bl2 && n5 + 1 < expressionArray.length && expression3 instanceof QuoteExp && (object3 = ((QuoteExp)expression3).getValue()) instanceof Keyword) {
                    String string2 = ((Keyword)object3).getName();
                    try {
                        n6 = Integer.parseInt(string2);
                        expression3 = expressionArray[++n5];
                    }
                    catch (Throwable throwable) {
                        compilation.error('e', "non-integer keyword '" + string2 + "' in array constructor");
                        return applyExp;
                    }
                }
                beginExp.add(new ApplyExp(new ArraySet(type3), new Expression[]{new ReferenceExp(declaration), QuoteExp.getInstance(new Integer(n6)), expression3}));
                ++n6;
                ++n5;
            }
            beginExp.add(new ReferenceExp(declaration));
            letExp.body = beginExp;
            return letExp;
        }
        if (objectType != null && string != null) {
            Object[] objectArray;
            int n8;
            int n9;
            MethodProc[] methodProcArray;
            if (objectType instanceof TypeValue && this.kind == 'N' && (methodProcArray = ((TypeValue)((Object)objectType)).getConstructor()) != null) {
                Expression[] expressionArray2 = new Expression[n4 - 1];
                System.arraycopy(expressionArray, 1, expressionArray2, 0, n4 - 1);
                return inlineCalls.walkApplyOnly(new ApplyExp((Procedure)methodProcArray, expressionArray2));
            }
            ClassType classType = compilation == null ? null : (compilation.curClass != null ? compilation.curClass : compilation.mainClass);
            ObjectType objectType2 = objectType;
            try {
                methodProcArray = this.getMethods(objectType2, string, classType);
                long l = Invoke.selectApplicable((PrimProcedure[])methodProcArray, objectType2, expressionArray, n3, n2, n);
                n9 = (int)(l >> 32);
                n8 = (int)l;
            }
            catch (Exception exception) {
                compilation.error('w', "unknown class: " + objectType.getName());
                return applyExp;
            }
            int n10 = -1;
            if (n9 + n8 == 0 && this.kind == 'N' && ClassMethods.selectApplicable((PrimProcedure[])methodProcArray, new Type[]{Compilation.typeClassType}) >> 32 == 1L && (objectArray = Invoke.checkKeywords(objectType, expressionArray, 1, classType)) != null) {
                StringBuffer stringBuffer = null;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!(objectArray[i] instanceof String)) continue;
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("no field or setter ");
                    } else {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append('`');
                    stringBuffer.append(objectArray[i]);
                    stringBuffer.append('\'');
                }
                if (stringBuffer != null) {
                    stringBuffer.append(" in class ");
                    stringBuffer.append(objectType.getName());
                    compilation.error('w', stringBuffer.toString());
                    return applyExp;
                }
                ApplyExp applyExp2 = new ApplyExp(methodProcArray[0], new Expression[]{expression});
                for (int i = 0; i < objectArray.length; ++i) {
                    Expression[] expressionArray3 = new Expression[]{applyExp2, new QuoteExp(objectArray[i]), expressionArray[2 * i + 2]};
                    applyExp2 = new ApplyExp(SlotSet.setFieldReturnObject, expressionArray3);
                }
                return applyExp2.setLine(applyExp);
            }
            int n11 = methodProcArray.length;
            if (n9 + n8 == 0 && this.kind == 'N') {
                methodProcArray = invokeStatic.getMethods(objectType2, "valueOf", classType);
                n2 = 1;
                n3 = n4 - 1;
                long l = Invoke.selectApplicable((PrimProcedure[])methodProcArray, objectType2, expressionArray, n3, n2, -1);
                n9 = (int)(l >> 32);
                n8 = (int)l;
            }
            if (n9 + n8 == 0) {
                if (this.kind == 'P' || compilation.getBooleanOption("warn-invoke-unknown-method", true)) {
                    if (this.kind == 'N') {
                        string = string + "/valueOf";
                    }
                    String string3 = n11 + methodProcArray.length == 0 ? "no accessible method '" + string + "' in " + objectType.getName() : "no possibly applicable method '" + string + "' in " + objectType.getName();
                    compilation.error(this.kind == 'P' ? (char)'e' : 'w', string3);
                }
            } else if (n9 == 1 || n9 == 0 && n8 == 1) {
                n10 = 0;
            } else if (n9 > 0) {
                n10 = MethodProc.mostSpecific(methodProcArray, n9);
                if (n10 < 0 && this.kind == 'S') {
                    for (int i = 0; i < n9; ++i) {
                        if (!((PrimProcedure)methodProcArray[i]).getStaticFlag()) continue;
                        if (n10 >= 0) {
                            n10 = -1;
                            break;
                        }
                        n10 = i;
                    }
                }
                if (n10 < 0 && (this.kind == 'P' || compilation.getBooleanOption("warn-invoke-unknown-method", true))) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("more than one definitely applicable method `");
                    stringBuffer.append(string);
                    stringBuffer.append("' in ");
                    stringBuffer.append(objectType.getName());
                    this.append((PrimProcedure[])methodProcArray, n9, stringBuffer);
                    compilation.error(this.kind == 'P' ? (char)'e' : 'w', stringBuffer.toString());
                }
            } else if (this.kind == 'P' || compilation.getBooleanOption("warn-invoke-unknown-method", true)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("more than one possibly applicable method '");
                stringBuffer.append(string);
                stringBuffer.append("' in ");
                stringBuffer.append(objectType.getName());
                this.append((PrimProcedure[])methodProcArray, n8, stringBuffer);
                compilation.error(this.kind == 'P' ? (char)'e' : 'w', stringBuffer.toString());
            }
            if (n10 >= 0) {
                Expression[] expressionArray4 = new Expression[n3];
                int n12 = 0;
                if (n >= 0) {
                    expressionArray4[n12++] = expressionArray[n];
                }
                for (int i = n2; i < expressionArray.length && n12 < expressionArray4.length; ++i, ++n12) {
                    expressionArray4[n12] = expressionArray[i];
                }
                return new ApplyExp(methodProcArray[n10], expressionArray4).setLine(applyExp);
            }
        }
        return applyExp;
    }

    private void append(PrimProcedure[] primProcedureArray, int n, StringBuffer stringBuffer) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\n  candidate: ");
            stringBuffer.append(primProcedureArray[i]);
        }
    }

    private String getMethodName(Expression[] expressionArray) {
        int n;
        if (this.kind == 'N') {
            return "<init>";
        }
        int n2 = n = this.kind == 'P' ? 2 : 1;
        if (expressionArray.length >= n + 1) {
            return ClassMethods.checkName(expressionArray[n], false);
        }
        return null;
    }

    public static synchronized ApplyExp makeInvokeStatic(ClassType classType, String string, Expression[] expressionArray) {
        PrimProcedure primProcedure = Invoke.getStaticMethod(classType, string, expressionArray);
        if (primProcedure == null) {
            throw new RuntimeException("missing or ambiguous method `" + string + "' in " + classType.getName());
        }
        return new ApplyExp(primProcedure, expressionArray);
    }

    public static synchronized PrimProcedure getStaticMethod(ClassType classType, String string, Expression[] expressionArray) {
        MethodProc[] methodProcArray = invokeStatic.getMethods(classType, string, null);
        long l = Invoke.selectApplicable((PrimProcedure[])methodProcArray, classType, expressionArray, expressionArray.length, 0, -1);
        int n = (int)(l >> 32);
        int n2 = (int)l;
        int n3 = methodProcArray == null ? -1 : (n > 0 ? MethodProc.mostSpecific(methodProcArray, n) : (n2 == 1 ? 0 : -1));
        return n3 < 0 ? null : methodProcArray[n3];
    }
}

