import{RelatedIssue as t}from"../browser_sdk/browser_sdk.js";import{UIString as e,ParsedURL as i}from"../common/common.js";import{DataGrid as s}from"../data_grid/data_grid.js";import{Cookie as a}from"../sdk/sdk.js";import{Widget as o,Tooltip as r,Icon as l}from"../ui/ui.js";const n=e.UIString("Session");class d extends o.VBox{constructor(t,e,i,o,r){super(),this.registerRequiredCSS("cookie_table/cookiesTable.css",{enableLegacyPatching:!0}),this.element.classList.add("cookies-table"),this._saveCallback=e,this._refreshCallback=i,this._deleteCallback=r;const l=!!e,n=[{id:a.Attributes.Name,title:ls`Name`,sortable:!0,disclosure:l,sort:s.Order.Ascending,longText:!0,weight:24,editable:l},{id:a.Attributes.Value,title:ls`Value`,sortable:!0,longText:!0,weight:34,editable:l},{id:a.Attributes.Domain,title:ls`Domain`,sortable:!0,weight:7,editable:l},{id:a.Attributes.Path,title:ls`Path`,sortable:!0,weight:7,editable:l},{id:a.Attributes.Expires,title:ls`Expires / Max-Age`,sortable:!0,weight:7,editable:l},{id:a.Attributes.Size,title:ls`Size`,sortable:!0,align:s.Align.Right,weight:7},{id:a.Attributes.HttpOnly,title:ls`HttpOnly`,sortable:!0,align:s.Align.Center,weight:7,dataType:s.DataType.Boolean,editable:l},{id:a.Attributes.Secure,title:ls`Secure`,sortable:!0,align:s.Align.Center,weight:7,dataType:s.DataType.Boolean,editable:l},{id:a.Attributes.SameSite,title:ls`SameSite`,sortable:!0,weight:7,editable:l},{id:a.Attributes.Priority,title:ls`Priority`,sortable:!0,sort:s.Order.Descending,weight:7,editable:l}];this._dataGrid=l?new s.DataGridImpl({displayName:ls`Editable Cookies`,columns:n,editCallback:this._onUpdateCookie.bind(this),deleteCallback:this._onDeleteCookie.bind(this),refreshCallback:i}):new s.DataGridImpl({displayName:ls`Cookies`,columns:n,editCallback:void 0,deleteCallback:void 0,refreshCallback:void 0}),this._dataGrid.setStriped(!0),this._dataGrid.setName("cookiesTable"),this._dataGrid.addEventListener(s.Events.SortingChanged,this._rebuildTable,this),this._dataGrid.setRowContextMenuCallback(this._populateContextMenu.bind(this)),t&&this._dataGrid.renderInline(),o&&this._dataGrid.addEventListener(s.Events.SelectedNode,o,this),this._lastEditedColumnId=null,this._dataGrid.asWidget().show(this.element),this._data=[],this._cookieDomain="",this._cookieToBlockedReasons=null}setCookies(t,e){this.setCookieFolders([{cookies:t,folderName:null}],e)}setCookieFolders(t,e){this._data=t,this._cookieToBlockedReasons=e||null,this._rebuildTable()}setCookieDomain(t){this._cookieDomain=t}selectedCookie(){const t=this._dataGrid.selectedNode;return t?t.cookie:null}_getSelectionCookies(){const t=this._dataGrid.selectedNode,e=t&&t.traverseNextNode(!0),i=t&&t.traversePreviousNode(!0);return{current:t&&t.cookie,neighbor:e&&e.cookie||i&&i.cookie}}willHide(){this._lastEditedColumnId=null}_findSelectedCookie(t,e){if(!e)return null;const i=t.current,s=e.find((t=>this._isSameCookie(t,i)));if(s)return s;const a=t.neighbor,o=e.find((t=>this._isSameCookie(t,a)));return o||null}_isSameCookie(t,e){return!!e&&e.name()===t.name()&&e.domain()===t.domain()&&e.path()===t.path()}_rebuildTable(){const t=this._getSelectionCookies(),e=this._lastEditedColumnId;this._lastEditedColumnId=null,this._dataGrid.rootNode().removeChildren();for(let i=0;i<this._data.length;++i){const o=this._data[i],r=this._findSelectedCookie(t,o.cookies);if(o.folderName){const t={};t[a.Attributes.Name]=o.folderName,t[a.Attributes.Value]="",t[a.Attributes.Size]=this._totalSize(o.cookies),t[a.Attributes.Domain]="",t[a.Attributes.Path]="",t[a.Attributes.Expires]="",t[a.Attributes.HttpOnly]="",t[a.Attributes.Secure]="",t[a.Attributes.SameSite]="",t[a.Attributes.Priority]="";const i=new s.DataGridNode(t);i.selectable=!0,this._dataGrid.rootNode().appendChild(i),i.element().classList.add("row-group"),this._populateNode(i,o.cookies,r,e),i.expand()}else this._populateNode(this._dataGrid.rootNode(),o.cookies,r,e)}t.current&&e&&!this._dataGrid.selectedNode&&this._addInactiveNode(this._dataGrid.rootNode(),t.current,e),this._saveCallback&&this._dataGrid.addCreationNode(!1)}_populateNode(t,e,i,s){if(t.removeChildren(),e){this._sortCookies(e);for(let a=0;a<e.length;++a){const o=e[a],r=this._createGridNode(o);t.appendChild(r),this._isSameCookie(o,i)&&(r.select(),null!==s&&this._dataGrid.startEditingNextEditableColumnOfDataGridNode(r,s))}}}_addInactiveNode(t,e,i){const s=this._createGridNode(e);t.appendChild(s),s.select(),s.setInactive(!0),null!==i&&this._dataGrid.startEditingNextEditableColumnOfDataGridNode(s,i)}_totalSize(t){let e=0;for(let i=0;t&&i<t.length;++i)e+=t[i].size();return e}_sortCookies(t){const e=this._dataGrid.isSortOrderAscending()?1:-1;function i(t,e){switch(e){case a.Attributes.Name:return String(t.name());case a.Attributes.Value:return String(t.value());case a.Attributes.Domain:return String(t.domain());case a.Attributes.Path:return String(t.path());case a.Attributes.HttpOnly:return String(t.httpOnly());case a.Attributes.Secure:return String(t.secure());case a.Attributes.SameSite:return String(t.sameSite());default:return String(t.name())}}let s;const o=this._dataGrid.sortColumnId()||a.Attributes.Name;s=o===a.Attributes.Expires?function(t,i){return t.session()!==i.session()?e*(t.session()?1:-1):t.session()?0:t.maxAge()&&i.maxAge()?e*(t.maxAge()-i.maxAge()):t.expires()&&i.expires()?e*(t.expires()-i.expires()):e*(t.expires()?1:-1)}:o===a.Attributes.Size?function(t,i){return e*(t.size()-i.size())}:o===a.Attributes.Priority?function(t,i){const s=[Protocol.Network.CookiePriority.Low,Protocol.Network.CookiePriority.Medium,Protocol.Network.CookiePriority.High],a=s.indexOf(t.priority()),o=s.indexOf(i.priority());return e*(a-o)}:function(t,s,a){return e*i(s,t).compareTo(i(a,t))}.bind(null,o),t.sort(s)}_createGridNode(t){const e={};e[a.Attributes.Name]=t.name(),e[a.Attributes.Value]=t.value(),t.type()===a.Type.Request?(e[a.Attributes.Domain]=t.domain()?t.domain():ls`N/A`,e[a.Attributes.Path]=t.path()?t.path():ls`N/A`):(e[a.Attributes.Domain]=t.domain()||"",e[a.Attributes.Path]=t.path()||""),t.maxAge()?e[a.Attributes.Expires]=Number.secondsToString(Math.floor(t.maxAge())):t.expires()?t.expires()<0?e[a.Attributes.Expires]=n:e[a.Attributes.Expires]=new Date(t.expires()).toISOString():e[a.Attributes.Expires]=t.type()===a.Type.Request?ls`N/A`:n,e[a.Attributes.Size]=t.size(),e[a.Attributes.HttpOnly]=t.httpOnly(),e[a.Attributes.Secure]=t.secure(),e[a.Attributes.SameSite]=t.sameSite()||"",e[a.Attributes.Priority]=t.priority()||"";const i=this._cookieToBlockedReasons?this._cookieToBlockedReasons.get(t):null,s=new u(e,t,i||null);return s.selectable=!0,s}_onDeleteCookie(t){t.cookie&&this._deleteCallback&&this._deleteCallback(t.cookie,(()=>this._refresh()))}_onUpdateCookie(t,e,i,s){this._lastEditedColumnId=e,this._setDefaults(t),this._isValidCookieData(t.data)?this._saveNode(t):t.setDirty(!0)}_setDefaults(t){null===t.data[a.Attributes.Name]&&(t.data[a.Attributes.Name]=""),null===t.data[a.Attributes.Value]&&(t.data[a.Attributes.Value]=""),null===t.data[a.Attributes.Domain]&&(t.data[a.Attributes.Domain]=this._cookieDomain),null===t.data[a.Attributes.Path]&&(t.data[a.Attributes.Path]="/"),null===t.data[a.Attributes.Expires]&&(t.data[a.Attributes.Expires]=n)}_saveNode(t){const e=t.cookie,i=this._createCookieFromData(t.data);t.cookie=i,this._saveCallback&&this._saveCallback(i,e).then((e=>{e?this._refresh():t.setDirty(!0)}))}_createCookieFromData(t){const e=new a.Cookie(t[a.Attributes.Name],t[a.Attributes.Value],null,t[a.Attributes.Priority]);return e.addAttribute(a.Attributes.Domain,t[a.Attributes.Domain]),e.addAttribute(a.Attributes.Path,t[a.Attributes.Path]),t.expires&&t.expires!==n&&e.addAttribute(a.Attributes.Expires,new Date(t[a.Attributes.Expires]).toUTCString()),t[a.Attributes.HttpOnly]&&e.addAttribute(a.Attributes.HttpOnly),t[a.Attributes.Secure]&&e.addAttribute(a.Attributes.Secure),t[a.Attributes.SameSite]&&e.addAttribute(a.Attributes.SameSite,t[a.Attributes.SameSite]),e.setSize(t[a.Attributes.Name].length+t[a.Attributes.Value].length),e}_isValidCookieData(t){return(t.name||t.value)&&this._isValidDomain(t.domain)&&this._isValidPath(t.path)&&this._isValidDate(t.expires)}_isValidDomain(t){if(!t)return!0;const e=i.ParsedURL.fromString("http://"+t);return!!e&&e.domain()===t}_isValidPath(t){const e=i.ParsedURL.fromString("http://example.com"+t);return!!e&&e.path===t}_isValidDate(t){return""===t||t===n||!isNaN(Date.parse(t))}_refresh(){this._refreshCallback&&this._refreshCallback()}_populateContextMenu(e,i){const s=i.cookie;if(!s)return;const a=s;e.revealSection().appendItem(ls`Show Requests With This Cookie`,(()=>{const t=new CustomEvent("networkrevealandfilter",{bubbles:!0,composed:!0,detail:[{filterType:"cookie-domain",filterValue:a.domain()},{filterType:"cookie-name",filterValue:a.name()}]});this.element.dispatchEvent(t)})),t.hasIssues(a)&&e.revealSection().appendItem(ls`Show issue associated with this cookie`,(()=>{t.reveal(a)}))}}class u extends s.DataGridNode{constructor(t,e,i){super(t),this.cookie=e,this._blockedReasons=i}createCells(t){super.createCells(t),this._blockedReasons&&this._blockedReasons.length&&t.classList.add("flagged-cookie-attribute-row")}createCell(t){const e=super.createCell(t);r.Tooltip.install(e,e.textContent||"");let i="";if(this._blockedReasons)for(const e of this._blockedReasons){const s=e.attribute===t,o=!e.attribute&&t===a.Attributes.Name;(s||o)&&(i&&(i+="\n"),i+=e.uiString)}if(i){const t=l.Icon.create("smallicon-info","cookie-warning-icon");r.Tooltip.install(t,i),e.insertBefore(t,e.firstChild),e.classList.add("flagged-cookie-attribute-cell")}return e}}var c=Object.freeze({__proto__:null,CookiesTable:d,DataGridNode:u});export{c as CookiesTable};
