import{ObjectWrapper as e,Revealer as t,Settings as s}from"../common/common.js";import{SDKModel as o,CPUProfilerModel as i,CSSModel as n,DebuggerModel as r,ResourceTreeModel as a}from"../sdk/sdk.js";import{Text as c,TextRange as l}from"../text_utils/text_utils.js";import{DataGrid as d,SortableDataGrid as h}from"../data_grid/data_grid.js";import{SourceFormatter as u}from"../formatter/formatter.js";import{i18n as g}from"../i18n/i18n.js";import{Widget as _,Tooltip as p,UIUtils as v,Toolbar as f,ActionRegistry as m,ViewManager as S}from"../ui/ui.js";import{Workspace as C,UISourceCode as y}from"../workspace/workspace.js";import{DebuggerWorkspaceBinding as b,CSSWorkspaceBinding as B,FileUtils as T}from"../bindings/bindings.js";import{userMetrics as P,UserMetrics as w}from"../host/host.js";import{Multimap as x,NumberUtilities as R,DateUtilities as k}from"../platform/platform.js";import{SourcesTextEditor as I}from"../source_frame/source_frame.js";const L={CSS:1,JavaScript:2,JavaScriptPerFunction:4},F={Active:Symbol("Active"),Suspending:Symbol("Suspending"),Suspended:Symbol("Suspended")},E={CoverageUpdated:Symbol("CoverageUpdated"),CoverageReset:Symbol("CoverageReset")};class M extends o.SDKModel{constructor(e){super(e),this._cpuProfilerModel=e.model(i.CPUProfilerModel),this._cssModel=e.model(n.CSSModel),this._debuggerModel=e.model(r.DebuggerModel),this._coverageByURL=new Map,this._coverageByContentProvider=new Map,this._coverageUpdateTimes=new Set,this._suspensionState=F.Active,this._pollTimer=null,this._currentPollPromise=null,this._shouldResumePollingOnResume=!1,this._jsBacklog=[],this._cssBacklog=[],this._performanceTraceRecording=!1}async start(e){if(this._suspensionState!==F.Active)throw Error("Cannot start CoverageModel while it is not active.");const t=[];return this._cssModel&&(this._clearCSS(),this._cssModel.addEventListener(n.Events.StyleSheetAdded,this._handleStyleSheetAdded,this),t.push(this._cssModel.startCoverage())),this._cpuProfilerModel&&t.push(this._cpuProfilerModel.startPreciseCoverage(e,this.preciseCoverageDeltaUpdate.bind(this))),await Promise.all(t),!(!this._cssModel&&!this._cpuProfilerModel)}preciseCoverageDeltaUpdate(e,t,s){this._coverageUpdateTimes.add(e),this._backlogOrProcessJSCoverage(s,e)}async stop(){await this.stopPolling();const e=[];this._cpuProfilerModel&&e.push(this._cpuProfilerModel.stopPreciseCoverage()),this._cssModel&&(e.push(this._cssModel.stopCoverage()),this._cssModel.removeEventListener(n.Events.StyleSheetAdded,this._handleStyleSheetAdded,this)),await Promise.all(e)}reset(){this._coverageByURL=new Map,this._coverageByContentProvider=new Map,this._coverageUpdateTimes=new Set,this.dispatchEventToListeners(E.CoverageReset)}async startPolling(){this._currentPollPromise||this._suspensionState!==F.Active||await this._pollLoop()}async _pollLoop(){this._clearTimer(),this._currentPollPromise=this._pollAndCallback(),await this._currentPollPromise,(this._suspensionState===F.Active||this._performanceTraceRecording)&&(this._pollTimer=window.setTimeout((()=>this._pollLoop()),200))}async stopPolling(){this._clearTimer(),await this._currentPollPromise,this._currentPollPromise=null,await this._pollAndCallback()}async _pollAndCallback(){if(this._suspensionState===F.Suspended&&!this._performanceTraceRecording)return;const e=await this._takeAllCoverage();console.assert(this._suspensionState!==F.Suspended||!!this._performanceTraceRecording,"CoverageModel was suspended while polling."),e.length&&this.dispatchEventToListeners(E.CoverageUpdated,e)}_clearTimer(){this._pollTimer&&(clearTimeout(this._pollTimer),this._pollTimer=null)}async preSuspendModel(e){this._suspensionState===F.Active&&(this._suspensionState=F.Suspending,"performance-timeline"!==e?this._currentPollPromise&&(await this.stopPolling(),this._shouldResumePollingOnResume=!0):this._performanceTraceRecording=!0)}async suspendModel(e){this._suspensionState=F.Suspended}async resumeModel(){}async postResumeModel(){this._suspensionState=F.Active,this._performanceTraceRecording=!1,this._shouldResumePollingOnResume&&(this._shouldResumePollingOnResume=!1,await this.startPolling())}entries(){return Array.from(this._coverageByURL.values())}getCoverageForUrl(e){return this._coverageByURL.get(e)||null}usageForRange(e,t,s){const o=this._coverageByContentProvider.get(e);return o&&o.usageForRange(t,s)}_clearCSS(){for(const e of this._coverageByContentProvider.values()){if(e.type()!==L.CSS)continue;const t=e.contentProvider();this._coverageByContentProvider.delete(t);const s=`${t.startLine}:${t.startColumn}`,o=this._coverageByURL.get(e.url());o&&o._coverageInfoByLocation.delete(s)&&(o._addToSizes(-e._usedSize,-e._size),o._coverageInfoByLocation.size||this._coverageByURL.delete(e.url()))}if(this._cssModel)for(const e of this._cssModel.getAllStyleSheetHeaders())this._addStyleSheetToCSSCoverage(e)}async _takeAllCoverage(){const[e,t]=await Promise.all([this._takeCSSCoverage(),this._takeJSCoverage()]);return[...e,...t]}async _takeJSCoverage(){if(!this._cpuProfilerModel)return[];const{coverage:e,timestamp:t}=await this._cpuProfilerModel.takePreciseCoverage();return this._coverageUpdateTimes.add(t),this._backlogOrProcessJSCoverage(e,t)}coverageUpdateTimes(){return this._coverageUpdateTimes}async _backlogOrProcessJSCoverage(e,t){if(e.length>0&&this._jsBacklog.push({rawCoverageData:e,stamp:t}),this._suspensionState!==F.Active)return[];const s=(e,t)=>e.stamp-t.stamp,o=[];for(const{rawCoverageData:e,stamp:t}of this._jsBacklog.sort(s))o.push(this._processJSCoverage(e,t));return this._jsBacklog=[],o.flat()}async processJSBacklog(){this._backlogOrProcessJSCoverage([],0)}_processJSCoverage(e,t){if(!this._debuggerModel)return[];const s=[];for(const o of e){const e=this._debuggerModel.scriptForId(o.scriptId);if(!e)continue;const i=[];let n=L.JavaScript;for(const e of o.functions){!1!==e.isBlockCoverage||1===e.ranges.length&&!e.ranges[0].count||(n|=L.JavaScriptPerFunction);for(const t of e.ranges)i.push(t)}const r=this._addCoverage(e,e.contentLength,e.lineOffset,e.columnOffset,i,n,t);r&&s.push(r)}return s}_handleStyleSheetAdded(e){const t=e.data;this._addStyleSheetToCSSCoverage(t)}async _takeCSSCoverage(){if(!this._cssModel||this._suspensionState!==F.Active)return[];const{coverage:e,timestamp:t}=await this._cssModel.takeCoverageDelta();return this._coverageUpdateTimes.add(t),this._backlogOrProcessCSSCoverage(e,t)}async _backlogOrProcessCSSCoverage(e,t){if(e.length>0&&this._cssBacklog.push({rawCoverageData:e,stamp:t}),this._suspensionState!==F.Active)return[];const s=(e,t)=>e.stamp-t.stamp,o=[];for(const{rawCoverageData:e,stamp:t}of this._cssBacklog.sort(s))o.push(this._processCSSCoverage(e,t));return this._cssBacklog=[],o.flat()}_processCSSCoverage(e,t){if(!this._cssModel)return[];const s=[],o=new Map;for(const t of e){const e=this._cssModel.styleSheetHeaderForId(t.styleSheetId);if(!e)continue;let s=o.get(e);s||(s=[],o.set(e,s)),s.push({startOffset:t.startOffset,endOffset:t.endOffset,count:Number(t.used)})}for(const e of o){const o=e[0],i=e[1],n=this._addCoverage(o,o.contentLength,o.startLine,o.startColumn,i,L.CSS,t);n&&s.push(n)}return s}static _convertToDisjointSegments(e,t){e.sort(((e,t)=>e.startOffset-t.startOffset));const s=[],o=[];for(const t of e){let e=o.peekLast();for(;e&&e.endOffset<=t.startOffset;)i(e.endOffset,e.count),o.pop(),e=o.peekLast();i(t.startOffset,e?e.count:0),o.push(t)}for(let e=o.pop();e;e=o.pop())i(e.endOffset,e.count);function i(e,o){const i=s.peekLast();if(i){if(i.end===e)return;if(i.count===o)return void(i.end=e)}s.push({end:e,count:o,stamp:t})}return s}_addStyleSheetToCSSCoverage(e){this._addCoverage(e,e.contentLength,e.startLine,e.startColumn,[],L.CSS,Date.now())}_addCoverage(e,t,s,o,i,n,r){const a=e.contentURL();if(!a)return null;let c=this._coverageByURL.get(a),l=!1;c||(l=!0,c=new z(a),this._coverageByURL.set(a,c));const d=c._ensureEntry(e,t,s,o,n);this._coverageByContentProvider.set(e,d);const h=M._convertToDisjointSegments(i,r),u=h.peekLast();u&&u.end<t&&h.push({end:t,stamp:r,count:0});const g=d._usedSize;return d.mergeCoverage(h),l||d._usedSize!==g?(c._addToSizes(d._usedSize-g,0),d):null}async exportReport(e){const t=[];function s(e,t){const[s,o]=e.split(":"),[i,n]=t.split(":");return Number.parseInt(s,10)-Number.parseInt(i,10)||Number.parseInt(o,10)-Number.parseInt(n,10)}const o=Array.from(this._coverageByURL.keys()).sort();for(const e of o){const o=this._coverageByURL.get(e);if(!o)continue;const i=o.url();if(i.startsWith("extensions::")||i.startsWith("chrome-extension://"))continue;let n=!1;for(const e of o._coverageInfoByLocation.values())if(e._lineOffset||e._columnOffset){n=!!i;break}let r=null;if(n){const e=a.ResourceTreeModel.resourceForURL(i);if(e){const t=(await e.requestContent()).content;r=new c.Text(t||"")}}const l=Array.from(o._coverageInfoByLocation.keys()).sort(s);if(r){const e={url:i,ranges:[],text:r.value()};for(const t of l){const s=o._coverageInfoByLocation.get(t);if(!s)continue;const i=r?r.offsetFromPosition(s._lineOffset,s._columnOffset):0;let n=0;for(const t of s._segments)t.count?e.ranges.push({start:n+i,end:t.end+i}):n=t.end}t.push(e)}else for(const e of l){const s=o._coverageInfoByLocation.get(e);if(!s)continue;const n={url:i,ranges:[],text:(await s.contentProvider().requestContent()).content};let r=0;for(const e of s._segments)e.count?n.ranges.push({start:r,end:e.end}):r=e.end;t.push(n)}}await e.write(JSON.stringify(t,void 0,2)),e.close()}}o.SDKModel.register(M,o.Capability.None,!1);class z extends e.ObjectWrapper{constructor(e){super(),this._url=e,this._coverageInfoByLocation=new Map,this._size=0,this._usedSize=0,this._type,this._isContentScript=!1}url(){return this._url}type(){return this._type}size(){return this._size}usedSize(){return this._usedSize}unusedSize(){return this._size-this._usedSize}usedPercentage(){return 0===this._size?0:this.usedSize()/this.size()*100}unusedPercentage(){return 0===this._size?100:this.unusedSize()/this.size()*100}isContentScript(){return this._isContentScript}entries(){return this._coverageInfoByLocation.values()}_addToSizes(e,t){this._usedSize+=e,this._size+=t,0===e&&0===t||this.dispatchEventToListeners(z.Events.SizesChanged)}_ensureEntry(e,t,s,o,i){const n=`${s}:${o}`;let r=this._coverageInfoByLocation.get(n);return i&L.JavaScript&&!this._coverageInfoByLocation.size&&(this._isContentScript=e.isContentScript()),this._type|=i,r?(r._coverageType|=i,r):(i&L.JavaScript&&!this._coverageInfoByLocation.size&&(this._isContentScript=e.isContentScript()),r=new U(e,t,s,o,i),this._coverageInfoByLocation.set(n,r),this._addToSizes(0,t),r)}}z.Events={SizesChanged:Symbol("SizesChanged")};const A=(e,t)=>{const s=[];let o=0,i=0;for(;o<e.length&&i<t.length;){const n=e[o],r=t[i],a=(n.count||0)+(r.count||0),c=Math.min(n.end,r.end),l=s.peekLast(),d=Math.min(n.stamp,r.stamp);l&&l.count===a&&l.stamp===d?l.end=c:s.push({end:c,count:a,stamp:d}),n.end<=r.end&&o++,n.end>=r.end&&i++}for(;o<e.length;o++)s.push(e[o]);for(;i<t.length;i++)s.push(t[i]);return s};class U{constructor(e,t,s,o,i){this._contentProvider=e,this._size=t,this._usedSize=0,this._statsByTimestamp=new Map,this._lineOffset=s,this._columnOffset=o,this._coverageType=i,this._segments=[]}contentProvider(){return this._contentProvider}url(){return this._contentProvider.contentURL()}type(){return this._coverageType}mergeCoverage(e){this._segments=A(this._segments,e),this._updateStats()}usedByTimestamp(){return this._statsByTimestamp}size(){return this._size}usageForRange(e,t){let s=this._segments.upperBound(e,((e,t)=>e-t.end));for(;s<this._segments.length&&this._segments[s].end<t;++s)if(this._segments[s].count)return!0;return s<this._segments.length&&!!this._segments[s].count}_updateStats(){this._statsByTimestamp=new Map,this._usedSize=0;let e=0;for(const t of this._segments){let s=this._statsByTimestamp.get(t.stamp);if(void 0===s&&(s=0),t.count){const o=t.end-e;this._usedSize+=o,this._statsByTimestamp.set(t.stamp,s+o)}e=t.end}}}var O=Object.freeze({__proto__:null,CoverageType:L,SuspensionState:F,Events:E,CoverageModel:M,URLCoverageInfo:z,mergeSegments:A,CoverageInfo:U,RangeUseCount:undefined,CoverageSegment:undefined});const H={css:"CSS",jsPerFunction:"JS (per function)",jsPerBlock:"JS (per block)",url:"URL",type:"Type",totalBytes:"Total Bytes",unusedBytes:"Unused Bytes",usageVisualization:"Usage Visualization",codeCoverage:"Code Coverage",jsCoverageWithPerFunction:"JS coverage with per function granularity: Once a function was executed, the whole function is marked as covered.",jsCoverageWithPerBlock:"JS coverage with per block granularity: Once a block of JavaScript was executed, that block is marked as covered.",Byte:"1 byte",sBytes:"{PH1} bytes",sPercent:"{PH1} %",ByteS:"1 byte, {PH1}",sBytesS:"{PH1} bytes, {PH2}",sBytesSBelongToFunctionsThatHave:"{PH1} bytes ({PH2} %) belong to functions that have not (yet) been executed.",sBytesSBelongToBlocksOf:"{PH1} bytes ({PH2} %) belong to blocks of JavaScript that have not (yet) been executed.",sBytesSBelongToFunctionsThatHaveExecuted:"{PH1} bytes ({PH2} %) belong to functions that have executed at least once.",sBytesSBelongToBlocksOfJavascript:"{PH1} bytes ({PH2} %) belong to blocks of JavaScript that have executed at least once.",sOfFileUnusedSOfFileUsed:"{PH1} % of file unused, {PH2} % of file used"},V=g.registerUIStrings("coverage/CoverageListView.js",H),N=g.getLocalizedString.bind(void 0,V);function j(e){const t=[];return e&L.CSS&&t.push(N(H.css)),e&L.JavaScriptPerFunction?t.push(N(H.jsPerFunction)):e&L.JavaScript&&t.push(N(H.jsPerBlock)),t.join("+")}class J extends _.VBox{constructor(e){super(!0),this._nodeForCoverageInfo=new Map,this._isVisibleFilter=e,this._highlightRegExp=null,this.registerRequiredCSS("coverage/coverageListView.css",{enableLegacyPatching:!0});const t=[{id:"url",title:N(H.url),width:"250px",fixedWidth:!1,sortable:!0},{id:"type",title:N(H.type),width:"45px",fixedWidth:!0,sortable:!0},{id:"size",title:N(H.totalBytes),width:"60px",fixedWidth:!0,sortable:!0,align:d.Align.Right},{id:"unusedSize",title:N(H.unusedBytes),width:"100px",fixedWidth:!0,sortable:!0,align:d.Align.Right,sort:d.Order.Descending},{id:"bars",title:N(H.usageVisualization),width:"250px",fixedWidth:!1,sortable:!0}];this._dataGrid=new h.SortableDataGrid({displayName:N(H.codeCoverage),columns:t,editCallback:void 0,refreshCallback:void 0,deleteCallback:void 0}),this._dataGrid.setResizeMethod(d.ResizeMethod.Last),this._dataGrid.element.classList.add("flex-auto"),this._dataGrid.element.addEventListener("keydown",this._onKeyDown.bind(this),!1),this._dataGrid.addEventListener(d.Events.OpenedNode,this._onOpenedNode,this),this._dataGrid.addEventListener(d.Events.SortingChanged,this._sortingChanged,this);const s=this._dataGrid.asWidget();s.show(this.contentElement),this.setDefaultFocusedChild(s)}update(e){let t=!1;const s=e.reduce(((e,t)=>Math.max(e,t.size())),0),o=this._dataGrid.rootNode();for(const i of e){let e=this._nodeForCoverageInfo.get(i);e?this._isVisibleFilter(e._coverageInfo)&&(t=e._refreshIfNeeded(s)||t):(e=new D(i,s),this._nodeForCoverageInfo.set(i,e),this._isVisibleFilter(e._coverageInfo)&&(o.appendChild(e),t=!0))}t&&this._sortingChanged()}reset(){this._nodeForCoverageInfo.clear(),this._dataGrid.rootNode().removeChildren()}updateFilterAndHighlight(e){this._highlightRegExp=e;let t=!1;for(const e of this._nodeForCoverageInfo.values()){const s=this._isVisibleFilter(e._coverageInfo),o=!!e.parent;s&&e._setHighlight(this._highlightRegExp),s!==o&&(t=!0,s?this._dataGrid.rootNode().appendChild(e):e.remove())}t&&this._sortingChanged()}selectByUrl(e){for(const[t,s]of this._nodeForCoverageInfo.entries())if(t.url()===e){s.revealAndSelect();break}}_onOpenedNode(){this._revealSourceForSelectedNode()}_onKeyDown(e){isEnterKey(e)&&(e.consume(!0),this._revealSourceForSelectedNode())}async _revealSourceForSelectedNode(){const e=this._dataGrid.selectedNode;if(!e)return;const s=e._coverageInfo;let o=C.WorkspaceImpl.instance().uiSourceCodeForURL(s.url());if(!o)return;o=(await u.SourceFormatter.instance().format(o)).formattedSourceCode,this._dataGrid.selectedNode===e&&t.reveal(o)}_sortingChanged(){const e=this._dataGrid.sortColumnId();if(!e)return;const t=D.sortFunctionForColumn(e);t&&this._dataGrid.sortNodes(t,!this._dataGrid.isSortOrderAscending())}}class D extends h.SortableDataGridNode{constructor(e,t){super(),this._coverageInfo=e,this._lastUsedSize,this._url=e.url(),this._maxSize=t,this._highlightRegExp=null}_setHighlight(e){this._highlightRegExp!==e&&(this._highlightRegExp=e,this.refresh())}_refreshIfNeeded(e){return(this._lastUsedSize!==this._coverageInfo.usedSize()||e!==this._maxSize)&&(this._lastUsedSize=this._coverageInfo.usedSize(),this._maxSize=e,this.refresh(),!0)}createCell(e){const t=this.createTD(e);switch(e){case"url":{p.Tooltip.install(t,this._url);const s=t.createChild("div","url-outer"),o=s.createChild("div","url-prefix"),i=s.createChild("div","url-suffix"),n=/^(.*)(\/[^/]*)$/.exec(this._url);o.textContent=n?n[1]:this._url,i.textContent=n?n[2]:"",this._highlightRegExp&&this._highlight(s,this._url),this.setCellAccessibleName(this._url,t,e);break}case"type":t.textContent=j(this._coverageInfo.type()),this._coverageInfo.type()&L.JavaScriptPerFunction?p.Tooltip.install(t,N(H.jsCoverageWithPerFunction)):this._coverageInfo.type()&L.JavaScript&&p.Tooltip.install(t,N(H.jsCoverageWithPerBlock));break;case"size":{t.createChild("span").textContent=Number.withThousandsSeparator(this._coverageInfo.size()||0);const s=1===this._coverageInfo.size()?N(H.Byte):N(H.sBytes,{PH1:this._coverageInfo.size()||0});this.setCellAccessibleName(s,t,e);break}case"unusedSize":{const s=this._coverageInfo.unusedSize()||0,o=t.createChild("span"),i=t.createChild("span","percent-value");o.textContent=Number.withThousandsSeparator(s);const n=N(H.sPercent,{PH1:this._percentageString(this._coverageInfo.unusedPercentage())});i.textContent=n;const r=1===s?N(H.ByteS,{PH1:n}):N(H.sBytesS,{PH1:s,PH2:n});this.setCellAccessibleName(r,t,e);break}case"bars":{const s=t.createChild("div","bar-container"),o=this._percentageString(this._coverageInfo.unusedPercentage()),i=this._percentageString(this._coverageInfo.usedPercentage());if(this._coverageInfo.unusedSize()>0){const e=s.createChild("div","bar bar-unused-size");e.style.width=(this._coverageInfo.unusedSize()/this._maxSize*100||0)+"%",this._coverageInfo.type()&L.JavaScriptPerFunction?p.Tooltip.install(e,N(H.sBytesSBelongToFunctionsThatHave,{PH1:this._coverageInfo.unusedSize(),PH2:o})):this._coverageInfo.type()&L.JavaScript&&p.Tooltip.install(e,N(H.sBytesSBelongToBlocksOf,{PH1:this._coverageInfo.unusedSize(),PH2:o}))}if(this._coverageInfo.usedSize()>0){const e=s.createChild("div","bar bar-used-size");e.style.width=(this._coverageInfo.usedSize()/this._maxSize*100||0)+"%",this._coverageInfo.type()&L.JavaScriptPerFunction?p.Tooltip.install(e,N(H.sBytesSBelongToFunctionsThatHaveExecuted,{PH1:this._coverageInfo.usedSize(),PH2:i})):this._coverageInfo.type()&L.JavaScript&&p.Tooltip.install(e,N(H.sBytesSBelongToBlocksOfJavascript,{PH1:this._coverageInfo.usedSize(),PH2:i}))}this.setCellAccessibleName(N(H.sOfFileUnusedSOfFileUsed,{PH1:o,PH2:i}),t,e)}}return t}_percentageString(e){return e.toFixed(1)}_highlight(e,t){if(!this._highlightRegExp)return;const s=this._highlightRegExp.exec(t);if(!s||!s.length)return;const o=new l.SourceRange(s.index,s[0].length);v.highlightRangesWithStyleClass(e,[o],"filter-highlight")}static sortFunctionForColumn(e){const t=(e,t)=>e._url.localeCompare(t._url);switch(e){case"url":return t;case"type":return(e,s)=>{const o=j(e._coverageInfo.type()),i=j(s._coverageInfo.type());return o.localeCompare(i)||t(e,s)};case"size":return(e,s)=>e._coverageInfo.size()-s._coverageInfo.size()||t(e,s);case"bars":case"unusedSize":return(e,s)=>e._coverageInfo.unusedSize()-s._coverageInfo.unusedSize()||t(e,s);default:return console.assert(!1,"Unknown sort field: "+e),null}}}var W=Object.freeze({__proto__:null,UIStrings:H,coverageTypeToString:j,CoverageListView:J,GridNode:D});class G{constructor(e){this._coverageModel=e,this._textByProvider=new Map,this._uiSourceCodeByContentProvider=new x;for(const e of C.WorkspaceImpl.instance().uiSourceCodes())e.addLineDecoration(0,"coverage",this);C.WorkspaceImpl.instance().addEventListener(C.Events.UISourceCodeAdded,this._onUISourceCodeAdded,this)}reset(){for(const e of C.WorkspaceImpl.instance().uiSourceCodes())e.removeDecorationsForType("coverage")}dispose(){this.reset(),C.WorkspaceImpl.instance().removeEventListener(C.Events.UISourceCodeAdded,this._onUISourceCodeAdded,this)}update(e){for(const t of e)for(const e of this._uiSourceCodeByContentProvider.get(t.contentProvider()))e.removeDecorationsForType("coverage"),e.addLineDecoration(0,"coverage",this)}async usageByLine(e){const t=[],{content:s}=await e.requestContent();if(!s)return[];const o=new c.Text(s);await this._updateTexts(e,o);const i=o.lineEndings();for(let s=0;s<o.lineCount();++s){const o=i[s]-(s?i[s-1]:0)-1;if(!o){t.push(void 0);continue}const n=this._rawLocationsForSourceLocation(e,s,0),r=this._rawLocationsForSourceLocation(e,s,o),[a,c]=await Promise.all([n,r]);let l=void 0;for(let e=0,t=0;e<a.length;++e){const s=a[e];for(;t<c.length&&G._compareLocations(s,c[t])>=0;)++t;if(t>=c.length||c[t].id!==s.id)continue;const o=c[t++],i=this._textByProvider.get(o.contentProvider);if(!i)continue;const n=i.value();let r=Math.min(i.offsetFromPosition(s.line,s.column),n.length-1),d=Math.min(i.offsetFromPosition(o.line,o.column),n.length-1);for(;r<=d&&/\s/.test(n[r]);)++r;for(;r<=d&&/\s/.test(n[d]);)--d;if(r<=d&&(l=this._coverageModel.usageForRange(o.contentProvider,r,d)),l)break}t.push(l)}return t}async _updateTexts(e,t){const s=[];for(let o=0;o<t.lineCount();++o)for(const t of await this._rawLocationsForSourceLocation(e,o,0))this._textByProvider.has(t.contentProvider)||(this._textByProvider.set(t.contentProvider,null),this._uiSourceCodeByContentProvider.set(t.contentProvider,e),s.push(this._updateTextForProvider(t.contentProvider)));await Promise.all(s)}async _updateTextForProvider(e){const{content:t}=await e.requestContent();this._textByProvider.set(e,new c.Text(t||""))}async _rawLocationsForSourceLocation(e,t,s){const o=[],i=e.contentType();if(i.hasScripts()){let n=await b.DebuggerWorkspaceBinding.instance().uiLocationToRawLocations(e,t,s);n=n.filter((e=>!!e.script()));for(const e of n){const t=e.script();t&&(t.isInlineScript()&&i.isDocument()&&(e.lineNumber-=t.lineOffset,e.lineNumber||(e.columnNumber-=t.columnOffset)),o.push({id:"js:"+e.scriptId,contentProvider:t,line:e.lineNumber,column:e.columnNumber}))}}if(i.isStyleSheet()||i.isDocument()){const n=B.CSSWorkspaceBinding.instance().uiLocationToRawLocations(new y.UILocation(e,t,s));for(const e of n){const t=e.header();t&&(t.isInline&&i.isDocument()&&(e.lineNumber-=t.startLine,e.lineNumber||(e.columnNumber-=t.startColumn)),o.push({id:"css:"+e.styleSheetId,contentProvider:t,line:e.lineNumber,column:e.columnNumber}))}}return o.sort(G._compareLocations)}static _compareLocations(e,t){return e.id.localeCompare(t.id)||e.line-t.line||e.column-t.column}_onUISourceCodeAdded(e){e.data.addLineDecoration(0,"coverage",this)}}var $=Object.freeze({__proto__:null,decoratorType:"coverage",CoverageDecorationManager:G,RawLocation:undefined});const q={chooseCoverageGranularityPer:"Choose coverage granularity: Per function has low overhead, per block has significant overhead.",perFunction:"Per function",perBlock:"Per block",clearAll:"Clear all",export:"Export...",urlFilter:"URL filter",filterCoverageByType:"Filter coverage by type",all:"All",css:"CSS",javascript:"JavaScript",includeExtensionContentScripts:"Include extension content scripts",contentScripts:"Content scripts",clickTheReloadButtonSToReloadAnd:"Click the reload button {PH1} to reload and start capturing coverage.",clickTheRecordButtonSToStart:"Click the record button {PH1} to start capturing coverage.",filteredSTotalS:"Filtered: {PH1}  Total: {PH2}",sOfSSUsedSoFarSUnused:"{PH1} of {PH2} ({PH3}%) used so far,\n        {PH4} unused."},K=g.registerUIStrings("coverage/CoverageView.js",q),Q=g.getLocalizedString.bind(void 0,K);class X extends _.VBox{constructor(){super(!0),this._model=null,this._decorationManager=null,this._resourceTreeModel=null,this.registerRequiredCSS("coverage/coverageView.css",{enableLegacyPatching:!0});const e=this.contentElement.createChild("div","coverage-toolbar-container"),t=new f.Toolbar("coverage-toolbar",e);this._coverageTypeComboBox=new f.ToolbarComboBox(this._onCoverageTypeComboBoxSelectionChanged.bind(this),Q(q.chooseCoverageGranularityPer));const i=[{label:Q(q.perFunction),value:L.JavaScript|L.JavaScriptPerFunction},{label:Q(q.perBlock),value:L.JavaScript}];for(const e of i)this._coverageTypeComboBox.addOption(this._coverageTypeComboBox.createOption(e.label,""+e.value));this._coverageTypeComboBoxSetting=s.Settings.instance().createSetting("coverageViewCoverageType",0),this._coverageTypeComboBox.setSelectedIndex(this._coverageTypeComboBoxSetting.get()),this._coverageTypeComboBox.setEnabled(!0),t.appendToolbarItem(this._coverageTypeComboBox),this._toggleRecordAction=m.ActionRegistry.instance().action("coverage.toggle-recording"),this._toggleRecordButton=f.Toolbar.createActionButton(this._toggleRecordAction),t.appendToolbarItem(this._toggleRecordButton);const n=o.TargetManager.instance().mainTarget();if(n&&n.model(a.ResourceTreeModel)){this._inlineReloadButton=null;const e=m.ActionRegistry.instance().action("coverage.start-with-reload");this._startWithReloadButton=f.Toolbar.createActionButton(e),t.appendToolbarItem(this._startWithReloadButton),this._toggleRecordButton.setEnabled(!1),this._toggleRecordButton.setVisible(!1)}this._clearButton=new f.ToolbarButton(Q(q.clearAll),"largeicon-clear"),this._clearButton.addEventListener(f.ToolbarButton.Events.Click,this._clear.bind(this)),t.appendToolbarItem(this._clearButton),t.appendSeparator(),this._saveButton=new f.ToolbarButton(Q(q.export),"largeicon-download"),this._saveButton.addEventListener(f.ToolbarButton.Events.Click,(e=>{this._exportReport()})),t.appendToolbarItem(this._saveButton),this._saveButton.setEnabled(!1),this._textFilterRegExp=null,t.appendSeparator(),this._filterInput=new f.ToolbarInput(Q(q.urlFilter),"",.4,1),this._filterInput.setEnabled(!1),this._filterInput.addEventListener(f.ToolbarInput.Event.TextChanged,this._onFilterChanged,this),t.appendToolbarItem(this._filterInput),t.appendSeparator(),this._typeFilterValue=null,this._filterByTypeComboBox=new f.ToolbarComboBox(this._onFilterByTypeChanged.bind(this),Q(q.filterCoverageByType));const r=[{label:Q(q.all),value:""},{label:Q(q.css),value:L.CSS},{label:Q(q.javascript),value:L.JavaScript|L.JavaScriptPerFunction}];for(const e of r)this._filterByTypeComboBox.addOption(this._filterByTypeComboBox.createOption(e.label,""+e.value));this._filterByTypeComboBox.setSelectedIndex(0),this._filterByTypeComboBox.setEnabled(!1),t.appendToolbarItem(this._filterByTypeComboBox),t.appendSeparator(),this._showContentScriptsSetting=s.Settings.instance().createSetting("showContentScripts",!1),this._showContentScriptsSetting.addChangeListener(this._onFilterChanged,this),this._contentScriptsCheckbox=new f.ToolbarSettingCheckbox(this._showContentScriptsSetting,Q(q.includeExtensionContentScripts),Q(q.contentScripts)),this._contentScriptsCheckbox.setEnabled(!1),t.appendToolbarItem(this._contentScriptsCheckbox),this._coverageResultsElement=this.contentElement.createChild("div","coverage-results"),this._landingPage=this._buildLandingPage(),this._listView=new J(this._isVisible.bind(this,!1)),this._statusToolbarElement=this.contentElement.createChild("div","coverage-toolbar-summary"),this._statusMessageElement=this._statusToolbarElement.createChild("div","coverage-message"),this._landingPage.show(this._coverageResultsElement)}_buildLandingPage(){const e=new _.VBox;let t;if(this._startWithReloadButton)this._inlineReloadButton=v.createInlineButton(f.Toolbar.createActionButtonForId("coverage.start-with-reload")),t=g.getFormatLocalizedString(K,q.clickTheReloadButtonSToReloadAnd,{PH1:this._inlineReloadButton});else{const e=v.createInlineButton(f.Toolbar.createActionButton(this._toggleRecordAction));t=g.getFormatLocalizedString(K,q.clickTheRecordButtonSToStart,{PH1:e})}return t.classList.add("message"),e.contentElement.appendChild(t),e.element.classList.add("landing-page"),e}_clear(){this._model&&this._model.reset(),this._reset()}_reset(){this._decorationManager&&(this._decorationManager.dispose(),this._decorationManager=null),this._listView.reset(),this._listView.detach(),this._landingPage.show(this._coverageResultsElement),this._statusMessageElement.textContent="",this._filterInput.setEnabled(!1),this._filterByTypeComboBox.setEnabled(!1),this._contentScriptsCheckbox.setEnabled(!1),this._saveButton.setEnabled(!1)}_toggleRecording(){!this._toggleRecordAction.toggled()?this._startRecording({reload:!1,jsCoveragePerBlock:this.isBlockCoverageSelected()}):this.stopRecording()}isBlockCoverageSelected(){const e=this._coverageTypeComboBox.selectedOption();return Number(e?e.value:Number.NaN)===L.JavaScript}_selectCoverageType(e){const t=e?1:0;this._coverageTypeComboBox.setSelectedIndex(t)}_onCoverageTypeComboBoxSelectionChanged(){this._coverageTypeComboBoxSetting.set(this._coverageTypeComboBox.selectedIndex())}async ensureRecordingStarted(){this._toggleRecordAction.toggled()&&await this.stopRecording(),await this._startRecording({reload:!1,jsCoveragePerBlock:!1})}async _startRecording(e){let t,s;this._startWithReloadButton&&this._startWithReloadButton.element.hasFocus()||this._inlineReloadButton&&this._inlineReloadButton.hasFocus()?s=!0:this.hasFocus()&&(t=!0),this._reset();const i=o.TargetManager.instance().mainTarget();if(!i)return;const{reload:n,jsCoveragePerBlock:r}={reload:!1,jsCoveragePerBlock:!1,...e};if(this._model&&!n||(this._model=i.model(M)),!this._model)return;P.actionTaken(w.Action.CoverageStarted),r&&P.actionTaken(w.Action.CoverageStartedPerBlock);await this._model.start(!!r)&&(this._selectCoverageType(!!r),this._model.addEventListener(E.CoverageUpdated,this._onCoverageDataReceived,this),this._resourceTreeModel=i.model(a.ResourceTreeModel),this._resourceTreeModel&&this._resourceTreeModel.addEventListener(a.Events.MainFrameNavigated,this._onMainFrameNavigated,this),this._decorationManager=new G(this._model),this._toggleRecordAction.setToggled(!0),this._clearButton.setEnabled(!1),this._startWithReloadButton&&(this._startWithReloadButton.setEnabled(!1),this._startWithReloadButton.setVisible(!1),this._toggleRecordButton.setEnabled(!0),this._toggleRecordButton.setVisible(!0),s&&this._toggleRecordButton.focus()),this._coverageTypeComboBox.setEnabled(!1),this._filterInput.setEnabled(!0),this._filterByTypeComboBox.setEnabled(!0),this._contentScriptsCheckbox.setEnabled(!0),this._landingPage.isShowing()&&this._landingPage.detach(),this._listView.show(this._coverageResultsElement),t&&!s&&this._listView.focus(),n&&this._resourceTreeModel?this._resourceTreeModel.reloadPage():this._model.startPolling())}_onCoverageDataReceived(e){const t=e.data;this._updateViews(t)}async stopRecording(){this._resourceTreeModel&&(this._resourceTreeModel.removeEventListener(a.Events.MainFrameNavigated,this._onMainFrameNavigated,this),this._resourceTreeModel=null),this.hasFocus()&&this._listView.focus(),this._model&&(await this._model.stop(),this._model.removeEventListener(E.CoverageUpdated,this._onCoverageDataReceived,this)),this._toggleRecordAction.setToggled(!1),this._coverageTypeComboBox.setEnabled(!0),this._startWithReloadButton&&(this._startWithReloadButton.setEnabled(!0),this._startWithReloadButton.setVisible(!0),this._toggleRecordButton.setEnabled(!1),this._toggleRecordButton.setVisible(!1)),this._clearButton.setEnabled(!0)}processBacklog(){this._model&&this._model.processJSBacklog()}_onMainFrameNavigated(){this._model&&this._model.reset(),this._decorationManager&&this._decorationManager.reset(),this._listView.reset(),this._model&&this._model.startPolling()}_updateViews(e){this._updateStats(),this._listView.update(this._model&&this._model.entries()||[]),this._saveButton.setEnabled(!!this._model&&this._model.entries().length>0),this._decorationManager&&this._decorationManager.update(e)}_updateStats(){const e={total:0,unused:0},t={total:0,unused:0};let s=!1;if(this._model)for(const o of this._model.entries())e.total+=o.size(),e.unused+=o.unusedSize(),this._isVisible(!1,o)?(t.total+=o.size(),t.unused+=o.unusedSize()):s=!0;function o({total:e,unused:t}){const s=e-t,o=e?Math.round(100*s/e):0;return Q(q.sOfSSUsedSoFarSUnused,{PH1:R.bytesToString(s),PH2:R.bytesToString(e),PH3:o,PH4:R.bytesToString(t)})}this._statusMessageElement.textContent=s?Q(q.filteredSTotalS,{PH1:o(t),PH2:o(e)}):o(e)}_onFilterChanged(){if(!this._listView)return;const e=this._filterInput.value();this._textFilterRegExp=e?createPlainTextSearchRegex(e,"i"):null,this._listView.updateFilterAndHighlight(this._textFilterRegExp),this._updateStats()}_onFilterByTypeChanged(){if(!this._listView)return;P.actionTaken(w.Action.CoverageReportFiltered);const e=this._filterByTypeComboBox.selectedOption(),t=e&&e.value;this._typeFilterValue=parseInt(t||"",10)||null,this._listView.updateFilterAndHighlight(this._textFilterRegExp),this._updateStats()}_isVisible(e,t){const s=t.url();return!s.startsWith(X._extensionBindingsURLPrefix)&&(!(t.isContentScript()&&!this._showContentScriptsSetting.get())&&(!(this._typeFilterValue&&!(t.type()&this._typeFilterValue))&&(e||!this._textFilterRegExp||this._textFilterRegExp.test(s))))}async _exportReport(){const e=new T.FileOutputStream,t=`Coverage-${k.toISO8601Compact(new Date)}.json`;await e.open(t)&&this._model&&this._model.exportReport(e)}selectCoverageItemByUrl(e){this._listView.selectByUrl(e)}}X._extensionBindingsURLPrefix="extensions::";class Y{constructor(){this._listeners=new WeakMap}decorate(e,t){const s=e.decorationsForType("coverage");if(!s||!s.size)return void this._uninstallGutter(t);s.values().next().value.data().usageByLine(e).then((s=>{t.operation((()=>this._innerDecorate(e,t,s)))}))}_innerDecorate(e,t,s){const o=Y._gutterType;this._uninstallGutter(t),s.length&&this._installGutter(t,e.url());for(let e=0;e<s.length;++e){if("boolean"!=typeof s[e])continue;const i=s[e]?"text-editor-coverage-used-marker":"text-editor-coverage-unused-marker",n=document.createElement("div");n.classList.add(i),t.setGutterDecoration(e,o,n)}}makeGutterClickHandler(e){return function(t){if(t.data.gutterType!==Y._gutterType)return;const s="coverage";S.ViewManager.instance().showView(s).then((()=>{const e=S.ViewManager.instance().view(s);return e&&e.widget()})).then((t=>{const s=e.match(/(.*):formatted$/),o=s&&s[1]||e;t.selectCoverageItemByUrl(o)}))}}_installGutter(e,t){let s=this._listeners.get(e);s||(s=this.makeGutterClickHandler(t),this._listeners.set(e,s)),e.installGutter(Y._gutterType,!1),e.addEventListener(I.Events.GutterClick,s,this)}_uninstallGutter(e){e.uninstallGutter(Y._gutterType);const t=this._listeners.get(e);t&&(e.removeEventListener(I.Events.GutterClick,t,this),this._listeners.delete(e))}}Y._gutterType="CodeMirror-gutter-coverage";var Z=Object.freeze({__proto__:null,UIStrings:q,CoverageView:X,ActionDelegate:class{handleAction(e,t){const s="coverage";return S.ViewManager.instance().showView(s,!1,!0).then((()=>{const e=S.ViewManager.instance().view(s);return e&&e.widget()})).then((e=>this._innerHandleAction(e,t))),!0}_innerHandleAction(e,t){switch(t){case"coverage.toggle-recording":e._toggleRecording();break;case"coverage.start-with-reload":e._startRecording({reload:!0,jsCoveragePerBlock:e.isBlockCoverageSelected()});break;default:console.assert(!1,"Unknown action: "+t)}}},LineDecorator:Y});export{$ as CoverageDecorationManager,W as CoverageListView,O as CoverageModel,Z as CoverageView};
