/*
 * Copyright (C) 2015 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#import <WebKit/WKFoundation.h>

#import <Foundation/Foundation.h>
#import <WebKit/WKDeclarationSpecifiers.h>

WK_EXPORT extern NSString * const _WKMenuItemIdentifierCopy API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierCopyImage API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierCopyLink API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierCopyMediaLink API_AVAILABLE(macos(10.14), ios(12.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierDownloadImage API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierDownloadLinkedFile API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierDownloadMedia API_AVAILABLE(macos(10.14), ios(12.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierGoBack API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierGoForward API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierInspectElement API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierLookUp API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierOpenFrameInNewWindow API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierOpenImageInNewWindow API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierOpenLink API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierOpenLinkInNewWindow API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierOpenMediaInNewWindow API_AVAILABLE(macos(10.14), ios(12.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierPaste API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierReload API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierRevealImage API_AVAILABLE(macos(12.0), ios(15.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierSearchWeb API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierShowHideMediaControls API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierToggleEnhancedFullScreen API_AVAILABLE(macos(10.14), ios(12.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierToggleFullScreen API_AVAILABLE(macos(10.12), ios(10.0));

WK_EXPORT extern NSString * const _WKMenuItemIdentifierShareMenu API_AVAILABLE(macos(10.12), ios(10.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierSpeechMenu API_AVAILABLE(macos(10.12), ios(10.0));

WK_EXPORT extern NSString * const _WKMenuItemIdentifierAddHighlightToCurrentQuickNote API_AVAILABLE(macos(12.0), ios(15.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierAddHighlightToNewQuickNote API_AVAILABLE(macos(12.0), ios(15.0));

WK_EXPORT extern NSString * const _WKMenuItemIdentifierTranslate API_AVAILABLE(macos(12.0), ios(15.0));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierCopyCroppedImage API_AVAILABLE(macos(12.1), ios(NA));

WK_EXPORT extern NSString * const _WKMenuItemIdentifierSpellingMenu API_AVAILABLE(macos(12.1), ios(NA));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierShowSpellingPanel API_AVAILABLE(macos(12.1), ios(NA));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierCheckSpelling API_AVAILABLE(macos(12.1), ios(NA));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierCheckSpellingWhileTyping API_AVAILABLE(macos(12.1), ios(NA));
WK_EXPORT extern NSString * const _WKMenuItemIdentifierCheckGrammarWithSpelling API_AVAILABLE(macos(12.1), ios(NA));
