// This file is automatically generated from CSSProperties.json by the process-css-properties script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyWritingMode = 3,
    CSSPropertyWebkitRubyPosition = 4,
    CSSPropertyColor = 5,
    CSSPropertyDirection = 6,
    CSSPropertyDisplay = 7,
    CSSPropertyFontFamily = 8,
    CSSPropertyFontFeatureSettings = 9,
    CSSPropertyFontKerning = 10,
    CSSPropertyFontOpticalSizing = 11,
    CSSPropertyFontPalette = 12,
    CSSPropertyFontSize = 13,
    CSSPropertyFontSizeAdjust = 14,
    CSSPropertyFontStretch = 15,
    CSSPropertyFontStyle = 16,
    CSSPropertyFontSynthesisSmallCaps = 17,
    CSSPropertyFontSynthesisStyle = 18,
    CSSPropertyFontSynthesisWeight = 19,
    CSSPropertyFontVariantAlternates = 20,
    CSSPropertyFontVariantCaps = 21,
    CSSPropertyFontVariantEastAsian = 22,
    CSSPropertyFontVariantLigatures = 23,
    CSSPropertyFontVariantNumeric = 24,
    CSSPropertyFontVariantPosition = 25,
    CSSPropertyFontVariationSettings = 26,
    CSSPropertyFontWeight = 27,
    CSSPropertyTextOrientation = 28,
    CSSPropertyTextRendering = 29,
    CSSPropertyZoom = 30,
    CSSPropertyWebkitFontSmoothing = 31,
    CSSPropertyWebkitLocale = 32,
    CSSPropertyWebkitTextSizeAdjust = 33,
    CSSPropertyWebkitTextZoom = 34,
    CSSPropertyLetterSpacing = 35,
    CSSPropertyAccentColor = 36,
    CSSPropertyAdditiveSymbols = 37,
    CSSPropertyAlignContent = 38,
    CSSPropertyAlignItems = 39,
    CSSPropertyAlignSelf = 40,
    CSSPropertyAlignmentBaseline = 41,
    CSSPropertyAlt = 42,
    CSSPropertyAnimationComposition = 43,
    CSSPropertyAnimationDelay = 44,
    CSSPropertyAnimationDirection = 45,
    CSSPropertyAnimationDuration = 46,
    CSSPropertyAnimationFillMode = 47,
    CSSPropertyAnimationIterationCount = 48,
    CSSPropertyAnimationName = 49,
    CSSPropertyAnimationPlayState = 50,
    CSSPropertyAnimationTimingFunction = 51,
    CSSPropertyAppearance = 52,
    CSSPropertyAspectRatio = 53,
    CSSPropertyBackfaceVisibility = 54,
    CSSPropertyBackgroundAttachment = 55,
    CSSPropertyBackgroundBlendMode = 56,
    CSSPropertyBackgroundColor = 57,
    CSSPropertyBackgroundImage = 58,
    CSSPropertyBackgroundPositionX = 59,
    CSSPropertyBackgroundPositionY = 60,
    CSSPropertyBackgroundRepeat = 61,
    CSSPropertyBackgroundSize = 62,
    CSSPropertyBasePalette = 63,
    CSSPropertyBaselineShift = 64,
    CSSPropertyBorderCollapse = 65,
    CSSPropertyBorderImageOutset = 66,
    CSSPropertyBorderImageRepeat = 67,
    CSSPropertyBorderImageSlice = 68,
    CSSPropertyBorderImageSource = 69,
    CSSPropertyBorderImageWidth = 70,
    CSSPropertyBoxSizing = 71,
    CSSPropertyBreakAfter = 72,
    CSSPropertyBreakBefore = 73,
    CSSPropertyBreakInside = 74,
    CSSPropertyBufferedRendering = 75,
    CSSPropertyCaptionSide = 76,
    CSSPropertyCaretColor = 77,
    CSSPropertyClear = 78,
    CSSPropertyClip = 79,
    CSSPropertyClipPath = 80,
    CSSPropertyClipRule = 81,
    CSSPropertyColorInterpolation = 82,
    CSSPropertyColorInterpolationFilters = 83,
    CSSPropertyColumnCount = 84,
    CSSPropertyColumnFill = 85,
    CSSPropertyColumnGap = 86,
    CSSPropertyColumnRuleColor = 87,
    CSSPropertyColumnRuleStyle = 88,
    CSSPropertyColumnRuleWidth = 89,
    CSSPropertyColumnSpan = 90,
    CSSPropertyColumnWidth = 91,
    CSSPropertyContain = 92,
    CSSPropertyContainerName = 93,
    CSSPropertyContainerType = 94,
    CSSPropertyContent = 95,
    CSSPropertyContentVisibility = 96,
    CSSPropertyCounterIncrement = 97,
    CSSPropertyCounterReset = 98,
    CSSPropertyCursor = 99,
    CSSPropertyCx = 100,
    CSSPropertyCy = 101,
    CSSPropertyDominantBaseline = 102,
    CSSPropertyEmptyCells = 103,
    CSSPropertyFallback = 104,
    CSSPropertyFill = 105,
    CSSPropertyFillOpacity = 106,
    CSSPropertyFillRule = 107,
    CSSPropertyFilter = 108,
    CSSPropertyFlexBasis = 109,
    CSSPropertyFlexDirection = 110,
    CSSPropertyFlexGrow = 111,
    CSSPropertyFlexShrink = 112,
    CSSPropertyFlexWrap = 113,
    CSSPropertyFloat = 114,
    CSSPropertyFloodColor = 115,
    CSSPropertyFloodOpacity = 116,
    CSSPropertyFontDisplay = 117,
    CSSPropertyGlyphOrientationHorizontal = 118,
    CSSPropertyGlyphOrientationVertical = 119,
    CSSPropertyGridAutoColumns = 120,
    CSSPropertyGridAutoFlow = 121,
    CSSPropertyGridAutoRows = 122,
    CSSPropertyGridColumnEnd = 123,
    CSSPropertyGridColumnStart = 124,
    CSSPropertyGridRowEnd = 125,
    CSSPropertyGridRowStart = 126,
    CSSPropertyGridTemplateAreas = 127,
    CSSPropertyGridTemplateColumns = 128,
    CSSPropertyGridTemplateRows = 129,
    CSSPropertyHangingPunctuation = 130,
    CSSPropertyImageOrientation = 131,
    CSSPropertyImageRendering = 132,
    CSSPropertyInherits = 133,
    CSSPropertyInitialValue = 134,
    CSSPropertyInputSecurity = 135,
    CSSPropertyIsolation = 136,
    CSSPropertyJustifyContent = 137,
    CSSPropertyJustifyItems = 138,
    CSSPropertyJustifySelf = 139,
    CSSPropertyKerning = 140,
    CSSPropertyLeadingTrim = 141,
    CSSPropertyLightingColor = 142,
    CSSPropertyLineBreak = 143,
    CSSPropertyLineHeight = 144,
    CSSPropertyListStyleImage = 145,
    CSSPropertyListStylePosition = 146,
    CSSPropertyListStyleType = 147,
    CSSPropertyMarginTrim = 148,
    CSSPropertyMarkerEnd = 149,
    CSSPropertyMarkerMid = 150,
    CSSPropertyMarkerStart = 151,
    CSSPropertyMaskImage = 152,
    CSSPropertyMaskOrigin = 153,
    CSSPropertyMaskRepeat = 154,
    CSSPropertyMaskSize = 155,
    CSSPropertyMaskType = 156,
    CSSPropertyMasonryAutoFlow = 157,
    CSSPropertyMathStyle = 158,
    CSSPropertyMixBlendMode = 159,
    CSSPropertyNegative = 160,
    CSSPropertyObjectFit = 161,
    CSSPropertyObjectPosition = 162,
    CSSPropertyOffsetAnchor = 163,
    CSSPropertyOffsetDistance = 164,
    CSSPropertyOffsetPath = 165,
    CSSPropertyOffsetPosition = 166,
    CSSPropertyOffsetRotate = 167,
    CSSPropertyOpacity = 168,
    CSSPropertyOrder = 169,
    CSSPropertyOrphans = 170,
    CSSPropertyOutlineColor = 171,
    CSSPropertyOutlineOffset = 172,
    CSSPropertyOutlineStyle = 173,
    CSSPropertyOutlineWidth = 174,
    CSSPropertyOverflowAnchor = 175,
    CSSPropertyOverflowWrap = 176,
    CSSPropertyOverflowX = 177,
    CSSPropertyOverflowY = 178,
    CSSPropertyOverrideColors = 179,
    CSSPropertyPad = 180,
    CSSPropertyPage = 181,
    CSSPropertyPaintOrder = 182,
    CSSPropertyPerspective = 183,
    CSSPropertyPerspectiveOriginX = 184,
    CSSPropertyPerspectiveOriginY = 185,
    CSSPropertyPointerEvents = 186,
    CSSPropertyPosition = 187,
    CSSPropertyPrefix = 188,
    CSSPropertyPrintColorAdjust = 189,
    CSSPropertyQuotes = 190,
    CSSPropertyR = 191,
    CSSPropertyRange = 192,
    CSSPropertyResize = 193,
    CSSPropertyRotate = 194,
    CSSPropertyRowGap = 195,
    CSSPropertyRx = 196,
    CSSPropertyRy = 197,
    CSSPropertyScale = 198,
    CSSPropertyScrollBehavior = 199,
    CSSPropertyScrollSnapAlign = 200,
    CSSPropertyScrollSnapStop = 201,
    CSSPropertyScrollSnapType = 202,
    CSSPropertyShapeImageThreshold = 203,
    CSSPropertyShapeMargin = 204,
    CSSPropertyShapeOutside = 205,
    CSSPropertyShapeRendering = 206,
    CSSPropertySize = 207,
    CSSPropertySpeakAs = 208,
    CSSPropertySrc = 209,
    CSSPropertyStopColor = 210,
    CSSPropertyStopOpacity = 211,
    CSSPropertyStroke = 212,
    CSSPropertyStrokeColor = 213,
    CSSPropertyStrokeDasharray = 214,
    CSSPropertyStrokeDashoffset = 215,
    CSSPropertyStrokeLinecap = 216,
    CSSPropertyStrokeLinejoin = 217,
    CSSPropertyStrokeMiterlimit = 218,
    CSSPropertyStrokeOpacity = 219,
    CSSPropertyStrokeWidth = 220,
    CSSPropertySuffix = 221,
    CSSPropertySymbols = 222,
    CSSPropertySyntax = 223,
    CSSPropertySystem = 224,
    CSSPropertyTabSize = 225,
    CSSPropertyTableLayout = 226,
    CSSPropertyTextAlign = 227,
    CSSPropertyTextAlignLast = 228,
    CSSPropertyTextAnchor = 229,
    CSSPropertyTextDecorationColor = 230,
    CSSPropertyTextDecorationLine = 231,
    CSSPropertyTextDecorationSkipInk = 232,
    CSSPropertyTextDecorationStyle = 233,
    CSSPropertyTextDecorationThickness = 234,
    CSSPropertyTextEdge = 235,
    CSSPropertyTextEmphasisColor = 236,
    CSSPropertyTextEmphasisPosition = 237,
    CSSPropertyTextEmphasisStyle = 238,
    CSSPropertyTextGroupAlign = 239,
    CSSPropertyTextIndent = 240,
    CSSPropertyTextJustify = 241,
    CSSPropertyTextOverflow = 242,
    CSSPropertyTextShadow = 243,
    CSSPropertyTextTransform = 244,
    CSSPropertyTextUnderlineOffset = 245,
    CSSPropertyTextUnderlinePosition = 246,
    CSSPropertyTextWrap = 247,
    CSSPropertyTouchAction = 248,
    CSSPropertyTransform = 249,
    CSSPropertyTransformBox = 250,
    CSSPropertyTransformOriginX = 251,
    CSSPropertyTransformOriginY = 252,
    CSSPropertyTransformOriginZ = 253,
    CSSPropertyTransformStyle = 254,
    CSSPropertyTransitionDelay = 255,
    CSSPropertyTransitionDuration = 256,
    CSSPropertyTransitionProperty = 257,
    CSSPropertyTransitionTimingFunction = 258,
    CSSPropertyTranslate = 259,
    CSSPropertyUnicodeBidi = 260,
    CSSPropertyUnicodeRange = 261,
    CSSPropertyVectorEffect = 262,
    CSSPropertyVerticalAlign = 263,
    CSSPropertyVisibility = 264,
    CSSPropertyWhiteSpace = 265,
    CSSPropertyWidows = 266,
    CSSPropertyWillChange = 267,
    CSSPropertyWordBreak = 268,
    CSSPropertyWordSpacing = 269,
    CSSPropertyX = 270,
    CSSPropertyY = 271,
    CSSPropertyZIndex = 272,
    CSSPropertyAppleColorFilter = 273,
    CSSPropertyApplePayButtonStyle = 274,
    CSSPropertyApplePayButtonType = 275,
    CSSPropertyInternalTextAutosizingStatus = 276,
    CSSPropertyWebkitBackdropFilter = 277,
    CSSPropertyWebkitBorderHorizontalSpacing = 278,
    CSSPropertyWebkitBorderVerticalSpacing = 279,
    CSSPropertyWebkitBoxAlign = 280,
    CSSPropertyWebkitBoxDecorationBreak = 281,
    CSSPropertyWebkitBoxDirection = 282,
    CSSPropertyWebkitBoxFlex = 283,
    CSSPropertyWebkitBoxFlexGroup = 284,
    CSSPropertyWebkitBoxLines = 285,
    CSSPropertyWebkitBoxOrdinalGroup = 286,
    CSSPropertyWebkitBoxOrient = 287,
    CSSPropertyWebkitBoxPack = 288,
    CSSPropertyWebkitBoxReflect = 289,
    CSSPropertyWebkitColumnAxis = 290,
    CSSPropertyWebkitColumnProgression = 291,
    CSSPropertyWebkitCursorVisibility = 292,
    CSSPropertyWebkitFontSizeDelta = 293,
    CSSPropertyWebkitHyphenateCharacter = 294,
    CSSPropertyWebkitHyphenateLimitAfter = 295,
    CSSPropertyWebkitHyphenateLimitBefore = 296,
    CSSPropertyWebkitHyphenateLimitLines = 297,
    CSSPropertyWebkitHyphens = 298,
    CSSPropertyWebkitInitialLetter = 299,
    CSSPropertyWebkitLineAlign = 300,
    CSSPropertyWebkitLineBoxContain = 301,
    CSSPropertyWebkitLineClamp = 302,
    CSSPropertyWebkitLineGrid = 303,
    CSSPropertyWebkitLineSnap = 304,
    CSSPropertyWebkitMarqueeDirection = 305,
    CSSPropertyWebkitMarqueeIncrement = 306,
    CSSPropertyWebkitMarqueeRepetition = 307,
    CSSPropertyWebkitMarqueeSpeed = 308,
    CSSPropertyWebkitMarqueeStyle = 309,
    CSSPropertyWebkitMaskBoxImageOutset = 310,
    CSSPropertyWebkitMaskBoxImageRepeat = 311,
    CSSPropertyWebkitMaskBoxImageSlice = 312,
    CSSPropertyWebkitMaskBoxImageSource = 313,
    CSSPropertyWebkitMaskBoxImageWidth = 314,
    CSSPropertyWebkitMaskPositionX = 315,
    CSSPropertyWebkitMaskPositionY = 316,
    CSSPropertyWebkitNbspMode = 317,
    CSSPropertyWebkitRtlOrdering = 318,
    CSSPropertyWebkitTapHighlightColor = 319,
    CSSPropertyWebkitTextDecorationsInEffect = 320,
    CSSPropertyWebkitTextFillColor = 321,
    CSSPropertyWebkitTextSecurity = 322,
    CSSPropertyWebkitTextStrokeColor = 323,
    CSSPropertyWebkitTextStrokeWidth = 324,
    CSSPropertyWebkitUserDrag = 325,
    CSSPropertyWebkitUserModify = 326,
    CSSPropertyWebkitUserSelect = 327,
    CSSPropertyBackgroundClip = 328,
    CSSPropertyBackgroundOrigin = 329,
    CSSPropertyBlockSize = 330,
    CSSPropertyBorderBlockEndColor = 331,
    CSSPropertyBorderBlockEndStyle = 332,
    CSSPropertyBorderBlockEndWidth = 333,
    CSSPropertyBorderBlockStartColor = 334,
    CSSPropertyBorderBlockStartStyle = 335,
    CSSPropertyBorderBlockStartWidth = 336,
    CSSPropertyBorderBottomColor = 337,
    CSSPropertyBorderBottomLeftRadius = 338,
    CSSPropertyBorderBottomRightRadius = 339,
    CSSPropertyBorderBottomStyle = 340,
    CSSPropertyBorderBottomWidth = 341,
    CSSPropertyBorderEndEndRadius = 342,
    CSSPropertyBorderEndStartRadius = 343,
    CSSPropertyBorderInlineEndColor = 344,
    CSSPropertyBorderInlineEndStyle = 345,
    CSSPropertyBorderInlineEndWidth = 346,
    CSSPropertyBorderInlineStartColor = 347,
    CSSPropertyBorderInlineStartStyle = 348,
    CSSPropertyBorderInlineStartWidth = 349,
    CSSPropertyBorderLeftColor = 350,
    CSSPropertyBorderLeftStyle = 351,
    CSSPropertyBorderLeftWidth = 352,
    CSSPropertyBorderRightColor = 353,
    CSSPropertyBorderRightStyle = 354,
    CSSPropertyBorderRightWidth = 355,
    CSSPropertyBorderStartEndRadius = 356,
    CSSPropertyBorderStartStartRadius = 357,
    CSSPropertyBorderTopColor = 358,
    CSSPropertyBorderTopLeftRadius = 359,
    CSSPropertyBorderTopRightRadius = 360,
    CSSPropertyBorderTopStyle = 361,
    CSSPropertyBorderTopWidth = 362,
    CSSPropertyBottom = 363,
    CSSPropertyBoxShadow = 364,
    CSSPropertyContainIntrinsicBlockSize = 365,
    CSSPropertyContainIntrinsicHeight = 366,
    CSSPropertyContainIntrinsicInlineSize = 367,
    CSSPropertyContainIntrinsicWidth = 368,
    CSSPropertyHeight = 369,
    CSSPropertyInlineSize = 370,
    CSSPropertyInsetBlockEnd = 371,
    CSSPropertyInsetBlockStart = 372,
    CSSPropertyInsetInlineEnd = 373,
    CSSPropertyInsetInlineStart = 374,
    CSSPropertyLeft = 375,
    CSSPropertyMarginBlockEnd = 376,
    CSSPropertyMarginBlockStart = 377,
    CSSPropertyMarginBottom = 378,
    CSSPropertyMarginInlineEnd = 379,
    CSSPropertyMarginInlineStart = 380,
    CSSPropertyMarginLeft = 381,
    CSSPropertyMarginRight = 382,
    CSSPropertyMarginTop = 383,
    CSSPropertyMaskClip = 384,
    CSSPropertyMaskComposite = 385,
    CSSPropertyMaskMode = 386,
    CSSPropertyMaxBlockSize = 387,
    CSSPropertyMaxHeight = 388,
    CSSPropertyMaxInlineSize = 389,
    CSSPropertyMaxWidth = 390,
    CSSPropertyMinBlockSize = 391,
    CSSPropertyMinHeight = 392,
    CSSPropertyMinInlineSize = 393,
    CSSPropertyMinWidth = 394,
    CSSPropertyOverscrollBehaviorBlock = 395,
    CSSPropertyOverscrollBehaviorInline = 396,
    CSSPropertyOverscrollBehaviorX = 397,
    CSSPropertyOverscrollBehaviorY = 398,
    CSSPropertyPaddingBlockEnd = 399,
    CSSPropertyPaddingBlockStart = 400,
    CSSPropertyPaddingBottom = 401,
    CSSPropertyPaddingInlineEnd = 402,
    CSSPropertyPaddingInlineStart = 403,
    CSSPropertyPaddingLeft = 404,
    CSSPropertyPaddingRight = 405,
    CSSPropertyPaddingTop = 406,
    CSSPropertyRight = 407,
    CSSPropertyScrollMarginBlockEnd = 408,
    CSSPropertyScrollMarginBlockStart = 409,
    CSSPropertyScrollMarginBottom = 410,
    CSSPropertyScrollMarginInlineEnd = 411,
    CSSPropertyScrollMarginInlineStart = 412,
    CSSPropertyScrollMarginLeft = 413,
    CSSPropertyScrollMarginRight = 414,
    CSSPropertyScrollMarginTop = 415,
    CSSPropertyScrollPaddingBlockEnd = 416,
    CSSPropertyScrollPaddingBlockStart = 417,
    CSSPropertyScrollPaddingBottom = 418,
    CSSPropertyScrollPaddingInlineEnd = 419,
    CSSPropertyScrollPaddingInlineStart = 420,
    CSSPropertyScrollPaddingLeft = 421,
    CSSPropertyScrollPaddingRight = 422,
    CSSPropertyScrollPaddingTop = 423,
    CSSPropertyTextCombineUpright = 424,
    CSSPropertyTop = 425,
    CSSPropertyWidth = 426,
    CSSPropertyWebkitBackgroundClip = 427,
    CSSPropertyWebkitBackgroundOrigin = 428,
    CSSPropertyWebkitBoxShadow = 429,
    CSSPropertyWebkitMaskClip = 430,
    CSSPropertyWebkitMaskComposite = 431,
    CSSPropertyWebkitMaskSourceType = 432,
    CSSPropertyWebkitTextCombine = 433,
    CSSPropertyAll = 434,
    CSSPropertyAnimation = 435,
    CSSPropertyBackground = 436,
    CSSPropertyBackgroundPosition = 437,
    CSSPropertyBorder = 438,
    CSSPropertyBorderBlock = 439,
    CSSPropertyBorderBlockColor = 440,
    CSSPropertyBorderBlockEnd = 441,
    CSSPropertyBorderBlockStart = 442,
    CSSPropertyBorderBlockStyle = 443,
    CSSPropertyBorderBlockWidth = 444,
    CSSPropertyBorderBottom = 445,
    CSSPropertyBorderColor = 446,
    CSSPropertyBorderImage = 447,
    CSSPropertyBorderInline = 448,
    CSSPropertyBorderInlineColor = 449,
    CSSPropertyBorderInlineEnd = 450,
    CSSPropertyBorderInlineStart = 451,
    CSSPropertyBorderInlineStyle = 452,
    CSSPropertyBorderInlineWidth = 453,
    CSSPropertyBorderLeft = 454,
    CSSPropertyBorderRadius = 455,
    CSSPropertyBorderRight = 456,
    CSSPropertyBorderSpacing = 457,
    CSSPropertyBorderStyle = 458,
    CSSPropertyBorderTop = 459,
    CSSPropertyBorderWidth = 460,
    CSSPropertyColumnRule = 461,
    CSSPropertyColumns = 462,
    CSSPropertyContainIntrinsicSize = 463,
    CSSPropertyContainer = 464,
    CSSPropertyFlex = 465,
    CSSPropertyFlexFlow = 466,
    CSSPropertyFont = 467,
    CSSPropertyFontSynthesis = 468,
    CSSPropertyFontVariant = 469,
    CSSPropertyGap = 470,
    CSSPropertyGrid = 471,
    CSSPropertyGridArea = 472,
    CSSPropertyGridColumn = 473,
    CSSPropertyGridRow = 474,
    CSSPropertyGridTemplate = 475,
    CSSPropertyInset = 476,
    CSSPropertyInsetBlock = 477,
    CSSPropertyInsetInline = 478,
    CSSPropertyListStyle = 479,
    CSSPropertyMargin = 480,
    CSSPropertyMarginBlock = 481,
    CSSPropertyMarginInline = 482,
    CSSPropertyMarker = 483,
    CSSPropertyMask = 484,
    CSSPropertyMaskPosition = 485,
    CSSPropertyOffset = 486,
    CSSPropertyOutline = 487,
    CSSPropertyOverflow = 488,
    CSSPropertyOverscrollBehavior = 489,
    CSSPropertyPadding = 490,
    CSSPropertyPaddingBlock = 491,
    CSSPropertyPaddingInline = 492,
    CSSPropertyPageBreakAfter = 493,
    CSSPropertyPageBreakBefore = 494,
    CSSPropertyPageBreakInside = 495,
    CSSPropertyPerspectiveOrigin = 496,
    CSSPropertyPlaceContent = 497,
    CSSPropertyPlaceItems = 498,
    CSSPropertyPlaceSelf = 499,
    CSSPropertyScrollMargin = 500,
    CSSPropertyScrollMarginBlock = 501,
    CSSPropertyScrollMarginInline = 502,
    CSSPropertyScrollPadding = 503,
    CSSPropertyScrollPaddingBlock = 504,
    CSSPropertyScrollPaddingInline = 505,
    CSSPropertyTextDecoration = 506,
    CSSPropertyTextDecorationSkip = 507,
    CSSPropertyTextEmphasis = 508,
    CSSPropertyTransformOrigin = 509,
    CSSPropertyTransition = 510,
    CSSPropertyWebkitBackgroundSize = 511,
    CSSPropertyWebkitBorderImage = 512,
    CSSPropertyWebkitBorderRadius = 513,
    CSSPropertyWebkitColumnBreakAfter = 514,
    CSSPropertyWebkitColumnBreakBefore = 515,
    CSSPropertyWebkitColumnBreakInside = 516,
    CSSPropertyWebkitMask = 517,
    CSSPropertyWebkitMaskBoxImage = 518,
    CSSPropertyWebkitMaskPosition = 519,
    CSSPropertyWebkitPerspective = 520,
    CSSPropertyWebkitTextDecoration = 521,
    CSSPropertyWebkitTextOrientation = 522,
    CSSPropertyWebkitTextStroke = 523,
};

constexpr uint16_t firstCSSProperty = 2;
constexpr uint16_t numCSSProperties = 522;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWebkitRubyPosition;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyColor;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyLetterSpacing;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWebkitUserSelect;
constexpr auto firstDeferredProperty = CSSPropertyID::CSSPropertyBackgroundClip;
constexpr auto lastDeferredProperty = CSSPropertyID::CSSPropertyWebkitTextCombine;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;
extern const std::array<CSSPropertyID, 402> computedPropertyIDs;

struct CSSPropertySettings {
    WTF_MAKE_STRUCT_FAST_ALLOCATED;

    bool CSSOMViewSmoothScrollingEnabled { false };
    bool accentColorEnabled { false };
    bool aspectRatioEnabled { false };
    bool colorFilterEnabled { false };
    bool cssContainIntrinsicSizeEnabled { false };
    bool cssContainerQueriesEnabled { false };
    bool cssContainmentEnabled { false };
    bool cssContentVisibilityEnabled { false };
    bool cssCounterStyleAtRulesEnabled { false };
    bool cssCustomPropertiesAndValuesEnabled { false };
    bool cssIndividualTransformPropertiesEnabled { false };
    bool cssInputSecurityEnabled { false };
    bool cssLeadingTrimEnabled { false };
    bool cssMarginTrimEnabled { false };
    bool cssMotionPathEnabled { false };
    bool cssScrollAnchoringEnabled { false };
    bool cssTextAlignLastEnabled { false };
    bool cssTextGroupAlignEnabled { false };
    bool cssTextJustifyEnabled { false };
    bool cssTextWrapEnabled { false };
    bool masonryEnabled { false };
    bool overscrollBehaviorEnabled { false };
    bool textAutosizingEnabled { false };
    bool webAnimationsCompositeOperationsEnabled { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
inline bool operator!=(const CSSPropertySettings& a, const CSSPropertySettings& b) { return !(a == b); }
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID relatedProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
        constexpr bool operator!=(std::nullptr_t) const { return index <= static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastDeferredProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

