/*
 * (C) 1999-2003 Lars Knoll (knoll@kde.org)
 * Copyright (C) 2004, 2005, 2006, 2008 Apple Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#pragma once

#include <wtf/text/AtomString.h>

namespace WebCore {

enum CSSValueID : uint16_t;

struct Counter : RefCounted<Counter> {
    static Ref<Counter> create(AtomString identifier, AtomString separator, CSSValueID listStyle)
    {
        return adoptRef(*new Counter(WTFMove(identifier), WTFMove(separator), listStyle));
    }

    const AtomString identifier;
    const AtomString separator;
    const CSSValueID listStyle;

    bool equals(const Counter& other) const
    {
        return identifier == other.identifier
            && separator == other.separator
            && listStyle == other.listStyle;
    }

private:
    Counter(AtomString identifier, AtomString separator, CSSValueID listStyle)
        : identifier(WTFMove(identifier))
        , separator(WTFMove(separator))
        , listStyle(listStyle)
    {
    }
};

} // namespace WebCore
