// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyWritingMode = 3,
    CSSPropertyWebkitRubyPosition = 4,
    CSSPropertyColor = 5,
    CSSPropertyDirection = 6,
    CSSPropertyDisplay = 7,
    CSSPropertyFontFamily = 8,
    CSSPropertyFontFeatureSettings = 9,
    CSSPropertyFontKerning = 10,
    CSSPropertyFontOpticalSizing = 11,
    CSSPropertyFontPalette = 12,
    CSSPropertyFontSize = 13,
    CSSPropertyFontSizeAdjust = 14,
    CSSPropertyFontStretch = 15,
    CSSPropertyFontStyle = 16,
    CSSPropertyFontSynthesisSmallCaps = 17,
    CSSPropertyFontSynthesisStyle = 18,
    CSSPropertyFontSynthesisWeight = 19,
    CSSPropertyFontVariantAlternates = 20,
    CSSPropertyFontVariantCaps = 21,
    CSSPropertyFontVariantEastAsian = 22,
    CSSPropertyFontVariantLigatures = 23,
    CSSPropertyFontVariantNumeric = 24,
    CSSPropertyFontVariantPosition = 25,
    CSSPropertyFontVariationSettings = 26,
    CSSPropertyFontWeight = 27,
    CSSPropertyTextOrientation = 28,
    CSSPropertyTextRendering = 29,
    CSSPropertyZoom = 30,
    CSSPropertyWebkitFontSmoothing = 31,
    CSSPropertyWebkitLocale = 32,
    CSSPropertyWebkitTextSizeAdjust = 33,
    CSSPropertyWebkitTextZoom = 34,
    CSSPropertyLetterSpacing = 35,
    CSSPropertyAccentColor = 36,
    CSSPropertyAdditiveSymbols = 37,
    CSSPropertyAlignContent = 38,
    CSSPropertyAlignItems = 39,
    CSSPropertyAlignSelf = 40,
    CSSPropertyAlignTracks = 41,
    CSSPropertyAlignmentBaseline = 42,
    CSSPropertyAlt = 43,
    CSSPropertyAnimationComposition = 44,
    CSSPropertyAnimationDelay = 45,
    CSSPropertyAnimationDirection = 46,
    CSSPropertyAnimationDuration = 47,
    CSSPropertyAnimationFillMode = 48,
    CSSPropertyAnimationIterationCount = 49,
    CSSPropertyAnimationName = 50,
    CSSPropertyAnimationPlayState = 51,
    CSSPropertyAnimationTimingFunction = 52,
    CSSPropertyAppearance = 53,
    CSSPropertyAspectRatio = 54,
    CSSPropertyBackfaceVisibility = 55,
    CSSPropertyBackgroundAttachment = 56,
    CSSPropertyBackgroundBlendMode = 57,
    CSSPropertyBackgroundColor = 58,
    CSSPropertyBackgroundImage = 59,
    CSSPropertyBackgroundPositionX = 60,
    CSSPropertyBackgroundPositionY = 61,
    CSSPropertyBackgroundRepeat = 62,
    CSSPropertyBackgroundSize = 63,
    CSSPropertyBasePalette = 64,
    CSSPropertyBaselineShift = 65,
    CSSPropertyBorderCollapse = 66,
    CSSPropertyBorderImageOutset = 67,
    CSSPropertyBorderImageRepeat = 68,
    CSSPropertyBorderImageSlice = 69,
    CSSPropertyBorderImageSource = 70,
    CSSPropertyBorderImageWidth = 71,
    CSSPropertyBoxSizing = 72,
    CSSPropertyBreakAfter = 73,
    CSSPropertyBreakBefore = 74,
    CSSPropertyBreakInside = 75,
    CSSPropertyBufferedRendering = 76,
    CSSPropertyCaptionSide = 77,
    CSSPropertyCaretColor = 78,
    CSSPropertyClear = 79,
    CSSPropertyClip = 80,
    CSSPropertyClipPath = 81,
    CSSPropertyClipRule = 82,
    CSSPropertyColorInterpolation = 83,
    CSSPropertyColorInterpolationFilters = 84,
    CSSPropertyColumnCount = 85,
    CSSPropertyColumnFill = 86,
    CSSPropertyColumnGap = 87,
    CSSPropertyColumnRuleColor = 88,
    CSSPropertyColumnRuleStyle = 89,
    CSSPropertyColumnRuleWidth = 90,
    CSSPropertyColumnSpan = 91,
    CSSPropertyColumnWidth = 92,
    CSSPropertyContain = 93,
    CSSPropertyContainerName = 94,
    CSSPropertyContainerType = 95,
    CSSPropertyContent = 96,
    CSSPropertyContentVisibility = 97,
    CSSPropertyCounterIncrement = 98,
    CSSPropertyCounterReset = 99,
    CSSPropertyCursor = 100,
    CSSPropertyCx = 101,
    CSSPropertyCy = 102,
    CSSPropertyDominantBaseline = 103,
    CSSPropertyEmptyCells = 104,
    CSSPropertyFallback = 105,
    CSSPropertyFill = 106,
    CSSPropertyFillOpacity = 107,
    CSSPropertyFillRule = 108,
    CSSPropertyFilter = 109,
    CSSPropertyFlexBasis = 110,
    CSSPropertyFlexDirection = 111,
    CSSPropertyFlexGrow = 112,
    CSSPropertyFlexShrink = 113,
    CSSPropertyFlexWrap = 114,
    CSSPropertyFloat = 115,
    CSSPropertyFloodColor = 116,
    CSSPropertyFloodOpacity = 117,
    CSSPropertyFontDisplay = 118,
    CSSPropertyGlyphOrientationHorizontal = 119,
    CSSPropertyGlyphOrientationVertical = 120,
    CSSPropertyGridAutoColumns = 121,
    CSSPropertyGridAutoFlow = 122,
    CSSPropertyGridAutoRows = 123,
    CSSPropertyGridColumnEnd = 124,
    CSSPropertyGridColumnStart = 125,
    CSSPropertyGridRowEnd = 126,
    CSSPropertyGridRowStart = 127,
    CSSPropertyGridTemplateAreas = 128,
    CSSPropertyGridTemplateColumns = 129,
    CSSPropertyGridTemplateRows = 130,
    CSSPropertyHangingPunctuation = 131,
    CSSPropertyImageOrientation = 132,
    CSSPropertyImageRendering = 133,
    CSSPropertyInherits = 134,
    CSSPropertyInitialValue = 135,
    CSSPropertyInputSecurity = 136,
    CSSPropertyIsolation = 137,
    CSSPropertyJustifyContent = 138,
    CSSPropertyJustifyItems = 139,
    CSSPropertyJustifySelf = 140,
    CSSPropertyJustifyTracks = 141,
    CSSPropertyKerning = 142,
    CSSPropertyLeadingTrim = 143,
    CSSPropertyLightingColor = 144,
    CSSPropertyLineBreak = 145,
    CSSPropertyLineHeight = 146,
    CSSPropertyListStyleImage = 147,
    CSSPropertyListStylePosition = 148,
    CSSPropertyListStyleType = 149,
    CSSPropertyMarginTrim = 150,
    CSSPropertyMarkerEnd = 151,
    CSSPropertyMarkerMid = 152,
    CSSPropertyMarkerStart = 153,
    CSSPropertyMaskImage = 154,
    CSSPropertyMaskOrigin = 155,
    CSSPropertyMaskRepeat = 156,
    CSSPropertyMaskSize = 157,
    CSSPropertyMaskType = 158,
    CSSPropertyMasonryAutoFlow = 159,
    CSSPropertyMathStyle = 160,
    CSSPropertyMixBlendMode = 161,
    CSSPropertyNegative = 162,
    CSSPropertyObjectFit = 163,
    CSSPropertyObjectPosition = 164,
    CSSPropertyOffsetAnchor = 165,
    CSSPropertyOffsetDistance = 166,
    CSSPropertyOffsetPath = 167,
    CSSPropertyOffsetPosition = 168,
    CSSPropertyOffsetRotate = 169,
    CSSPropertyOpacity = 170,
    CSSPropertyOrder = 171,
    CSSPropertyOrphans = 172,
    CSSPropertyOutlineColor = 173,
    CSSPropertyOutlineOffset = 174,
    CSSPropertyOutlineStyle = 175,
    CSSPropertyOutlineWidth = 176,
    CSSPropertyOverflowAnchor = 177,
    CSSPropertyOverflowWrap = 178,
    CSSPropertyOverflowX = 179,
    CSSPropertyOverflowY = 180,
    CSSPropertyOverrideColors = 181,
    CSSPropertyPad = 182,
    CSSPropertyPage = 183,
    CSSPropertyPaintOrder = 184,
    CSSPropertyPerspective = 185,
    CSSPropertyPerspectiveOriginX = 186,
    CSSPropertyPerspectiveOriginY = 187,
    CSSPropertyPointerEvents = 188,
    CSSPropertyPosition = 189,
    CSSPropertyPrefix = 190,
    CSSPropertyPrintColorAdjust = 191,
    CSSPropertyQuotes = 192,
    CSSPropertyR = 193,
    CSSPropertyRange = 194,
    CSSPropertyResize = 195,
    CSSPropertyRotate = 196,
    CSSPropertyRowGap = 197,
    CSSPropertyRx = 198,
    CSSPropertyRy = 199,
    CSSPropertyScale = 200,
    CSSPropertyScrollBehavior = 201,
    CSSPropertyScrollSnapAlign = 202,
    CSSPropertyScrollSnapStop = 203,
    CSSPropertyScrollSnapType = 204,
    CSSPropertyShapeImageThreshold = 205,
    CSSPropertyShapeMargin = 206,
    CSSPropertyShapeOutside = 207,
    CSSPropertyShapeRendering = 208,
    CSSPropertySize = 209,
    CSSPropertySpeakAs = 210,
    CSSPropertySrc = 211,
    CSSPropertyStopColor = 212,
    CSSPropertyStopOpacity = 213,
    CSSPropertyStroke = 214,
    CSSPropertyStrokeColor = 215,
    CSSPropertyStrokeDasharray = 216,
    CSSPropertyStrokeDashoffset = 217,
    CSSPropertyStrokeLinecap = 218,
    CSSPropertyStrokeLinejoin = 219,
    CSSPropertyStrokeMiterlimit = 220,
    CSSPropertyStrokeOpacity = 221,
    CSSPropertyStrokeWidth = 222,
    CSSPropertySuffix = 223,
    CSSPropertySymbols = 224,
    CSSPropertySyntax = 225,
    CSSPropertySystem = 226,
    CSSPropertyTabSize = 227,
    CSSPropertyTableLayout = 228,
    CSSPropertyTextAlign = 229,
    CSSPropertyTextAlignLast = 230,
    CSSPropertyTextAnchor = 231,
    CSSPropertyTextAutospace = 232,
    CSSPropertyTextDecorationColor = 233,
    CSSPropertyTextDecorationLine = 234,
    CSSPropertyTextDecorationSkipInk = 235,
    CSSPropertyTextDecorationStyle = 236,
    CSSPropertyTextDecorationThickness = 237,
    CSSPropertyTextEdge = 238,
    CSSPropertyTextEmphasisColor = 239,
    CSSPropertyTextEmphasisPosition = 240,
    CSSPropertyTextEmphasisStyle = 241,
    CSSPropertyTextGroupAlign = 242,
    CSSPropertyTextIndent = 243,
    CSSPropertyTextJustify = 244,
    CSSPropertyTextOverflow = 245,
    CSSPropertyTextShadow = 246,
    CSSPropertyTextSpacingTrim = 247,
    CSSPropertyTextTransform = 248,
    CSSPropertyTextUnderlineOffset = 249,
    CSSPropertyTextUnderlinePosition = 250,
    CSSPropertyTextWrap = 251,
    CSSPropertyTouchAction = 252,
    CSSPropertyTransform = 253,
    CSSPropertyTransformBox = 254,
    CSSPropertyTransformOriginX = 255,
    CSSPropertyTransformOriginY = 256,
    CSSPropertyTransformOriginZ = 257,
    CSSPropertyTransformStyle = 258,
    CSSPropertyTransitionDelay = 259,
    CSSPropertyTransitionDuration = 260,
    CSSPropertyTransitionProperty = 261,
    CSSPropertyTransitionTimingFunction = 262,
    CSSPropertyTranslate = 263,
    CSSPropertyUnicodeBidi = 264,
    CSSPropertyUnicodeRange = 265,
    CSSPropertyVectorEffect = 266,
    CSSPropertyVerticalAlign = 267,
    CSSPropertyVisibility = 268,
    CSSPropertyWhiteSpace = 269,
    CSSPropertyWidows = 270,
    CSSPropertyWillChange = 271,
    CSSPropertyWordBreak = 272,
    CSSPropertyWordSpacing = 273,
    CSSPropertyX = 274,
    CSSPropertyY = 275,
    CSSPropertyZIndex = 276,
    CSSPropertyAppleColorFilter = 277,
    CSSPropertyApplePayButtonStyle = 278,
    CSSPropertyApplePayButtonType = 279,
    CSSPropertyInternalTextAutosizingStatus = 280,
    CSSPropertyWebkitBackdropFilter = 281,
    CSSPropertyWebkitBorderHorizontalSpacing = 282,
    CSSPropertyWebkitBorderVerticalSpacing = 283,
    CSSPropertyWebkitBoxAlign = 284,
    CSSPropertyWebkitBoxDecorationBreak = 285,
    CSSPropertyWebkitBoxDirection = 286,
    CSSPropertyWebkitBoxFlex = 287,
    CSSPropertyWebkitBoxFlexGroup = 288,
    CSSPropertyWebkitBoxLines = 289,
    CSSPropertyWebkitBoxOrdinalGroup = 290,
    CSSPropertyWebkitBoxOrient = 291,
    CSSPropertyWebkitBoxPack = 292,
    CSSPropertyWebkitBoxReflect = 293,
    CSSPropertyWebkitColumnAxis = 294,
    CSSPropertyWebkitColumnProgression = 295,
    CSSPropertyWebkitCursorVisibility = 296,
    CSSPropertyWebkitFontSizeDelta = 297,
    CSSPropertyWebkitHyphenateCharacter = 298,
    CSSPropertyWebkitHyphenateLimitAfter = 299,
    CSSPropertyWebkitHyphenateLimitBefore = 300,
    CSSPropertyWebkitHyphenateLimitLines = 301,
    CSSPropertyWebkitHyphens = 302,
    CSSPropertyWebkitInitialLetter = 303,
    CSSPropertyWebkitLineAlign = 304,
    CSSPropertyWebkitLineBoxContain = 305,
    CSSPropertyWebkitLineClamp = 306,
    CSSPropertyWebkitLineGrid = 307,
    CSSPropertyWebkitLineSnap = 308,
    CSSPropertyWebkitMarqueeDirection = 309,
    CSSPropertyWebkitMarqueeIncrement = 310,
    CSSPropertyWebkitMarqueeRepetition = 311,
    CSSPropertyWebkitMarqueeSpeed = 312,
    CSSPropertyWebkitMarqueeStyle = 313,
    CSSPropertyWebkitMaskBoxImageOutset = 314,
    CSSPropertyWebkitMaskBoxImageRepeat = 315,
    CSSPropertyWebkitMaskBoxImageSlice = 316,
    CSSPropertyWebkitMaskBoxImageSource = 317,
    CSSPropertyWebkitMaskBoxImageWidth = 318,
    CSSPropertyWebkitMaskPositionX = 319,
    CSSPropertyWebkitMaskPositionY = 320,
    CSSPropertyWebkitNbspMode = 321,
    CSSPropertyWebkitRtlOrdering = 322,
    CSSPropertyWebkitTapHighlightColor = 323,
    CSSPropertyWebkitTextDecorationsInEffect = 324,
    CSSPropertyWebkitTextFillColor = 325,
    CSSPropertyWebkitTextSecurity = 326,
    CSSPropertyWebkitTextStrokeColor = 327,
    CSSPropertyWebkitTextStrokeWidth = 328,
    CSSPropertyWebkitUserDrag = 329,
    CSSPropertyWebkitUserModify = 330,
    CSSPropertyWebkitUserSelect = 331,
    CSSPropertyBackgroundClip = 332,
    CSSPropertyBackgroundOrigin = 333,
    CSSPropertyBlockSize = 334,
    CSSPropertyBorderBlockEndColor = 335,
    CSSPropertyBorderBlockEndStyle = 336,
    CSSPropertyBorderBlockEndWidth = 337,
    CSSPropertyBorderBlockStartColor = 338,
    CSSPropertyBorderBlockStartStyle = 339,
    CSSPropertyBorderBlockStartWidth = 340,
    CSSPropertyBorderBottomColor = 341,
    CSSPropertyBorderBottomLeftRadius = 342,
    CSSPropertyBorderBottomRightRadius = 343,
    CSSPropertyBorderBottomStyle = 344,
    CSSPropertyBorderBottomWidth = 345,
    CSSPropertyBorderEndEndRadius = 346,
    CSSPropertyBorderEndStartRadius = 347,
    CSSPropertyBorderInlineEndColor = 348,
    CSSPropertyBorderInlineEndStyle = 349,
    CSSPropertyBorderInlineEndWidth = 350,
    CSSPropertyBorderInlineStartColor = 351,
    CSSPropertyBorderInlineStartStyle = 352,
    CSSPropertyBorderInlineStartWidth = 353,
    CSSPropertyBorderLeftColor = 354,
    CSSPropertyBorderLeftStyle = 355,
    CSSPropertyBorderLeftWidth = 356,
    CSSPropertyBorderRightColor = 357,
    CSSPropertyBorderRightStyle = 358,
    CSSPropertyBorderRightWidth = 359,
    CSSPropertyBorderStartEndRadius = 360,
    CSSPropertyBorderStartStartRadius = 361,
    CSSPropertyBorderTopColor = 362,
    CSSPropertyBorderTopLeftRadius = 363,
    CSSPropertyBorderTopRightRadius = 364,
    CSSPropertyBorderTopStyle = 365,
    CSSPropertyBorderTopWidth = 366,
    CSSPropertyBottom = 367,
    CSSPropertyBoxShadow = 368,
    CSSPropertyContainIntrinsicBlockSize = 369,
    CSSPropertyContainIntrinsicHeight = 370,
    CSSPropertyContainIntrinsicInlineSize = 371,
    CSSPropertyContainIntrinsicWidth = 372,
    CSSPropertyHeight = 373,
    CSSPropertyInlineSize = 374,
    CSSPropertyInsetBlockEnd = 375,
    CSSPropertyInsetBlockStart = 376,
    CSSPropertyInsetInlineEnd = 377,
    CSSPropertyInsetInlineStart = 378,
    CSSPropertyLeft = 379,
    CSSPropertyMarginBlockEnd = 380,
    CSSPropertyMarginBlockStart = 381,
    CSSPropertyMarginBottom = 382,
    CSSPropertyMarginInlineEnd = 383,
    CSSPropertyMarginInlineStart = 384,
    CSSPropertyMarginLeft = 385,
    CSSPropertyMarginRight = 386,
    CSSPropertyMarginTop = 387,
    CSSPropertyMaskClip = 388,
    CSSPropertyMaskComposite = 389,
    CSSPropertyMaskMode = 390,
    CSSPropertyMaxBlockSize = 391,
    CSSPropertyMaxHeight = 392,
    CSSPropertyMaxInlineSize = 393,
    CSSPropertyMaxWidth = 394,
    CSSPropertyMinBlockSize = 395,
    CSSPropertyMinHeight = 396,
    CSSPropertyMinInlineSize = 397,
    CSSPropertyMinWidth = 398,
    CSSPropertyOverscrollBehaviorBlock = 399,
    CSSPropertyOverscrollBehaviorInline = 400,
    CSSPropertyOverscrollBehaviorX = 401,
    CSSPropertyOverscrollBehaviorY = 402,
    CSSPropertyPaddingBlockEnd = 403,
    CSSPropertyPaddingBlockStart = 404,
    CSSPropertyPaddingBottom = 405,
    CSSPropertyPaddingInlineEnd = 406,
    CSSPropertyPaddingInlineStart = 407,
    CSSPropertyPaddingLeft = 408,
    CSSPropertyPaddingRight = 409,
    CSSPropertyPaddingTop = 410,
    CSSPropertyRight = 411,
    CSSPropertyScrollMarginBlockEnd = 412,
    CSSPropertyScrollMarginBlockStart = 413,
    CSSPropertyScrollMarginBottom = 414,
    CSSPropertyScrollMarginInlineEnd = 415,
    CSSPropertyScrollMarginInlineStart = 416,
    CSSPropertyScrollMarginLeft = 417,
    CSSPropertyScrollMarginRight = 418,
    CSSPropertyScrollMarginTop = 419,
    CSSPropertyScrollPaddingBlockEnd = 420,
    CSSPropertyScrollPaddingBlockStart = 421,
    CSSPropertyScrollPaddingBottom = 422,
    CSSPropertyScrollPaddingInlineEnd = 423,
    CSSPropertyScrollPaddingInlineStart = 424,
    CSSPropertyScrollPaddingLeft = 425,
    CSSPropertyScrollPaddingRight = 426,
    CSSPropertyScrollPaddingTop = 427,
    CSSPropertyTextCombineUpright = 428,
    CSSPropertyTop = 429,
    CSSPropertyWidth = 430,
    CSSPropertyWebkitBackgroundClip = 431,
    CSSPropertyWebkitBackgroundOrigin = 432,
    CSSPropertyWebkitBoxShadow = 433,
    CSSPropertyWebkitMaskClip = 434,
    CSSPropertyWebkitMaskComposite = 435,
    CSSPropertyWebkitMaskSourceType = 436,
    CSSPropertyWebkitTextCombine = 437,
    CSSPropertyAll = 438,
    CSSPropertyAnimation = 439,
    CSSPropertyBackground = 440,
    CSSPropertyBackgroundPosition = 441,
    CSSPropertyBorder = 442,
    CSSPropertyBorderBlock = 443,
    CSSPropertyBorderBlockColor = 444,
    CSSPropertyBorderBlockEnd = 445,
    CSSPropertyBorderBlockStart = 446,
    CSSPropertyBorderBlockStyle = 447,
    CSSPropertyBorderBlockWidth = 448,
    CSSPropertyBorderBottom = 449,
    CSSPropertyBorderColor = 450,
    CSSPropertyBorderImage = 451,
    CSSPropertyBorderInline = 452,
    CSSPropertyBorderInlineColor = 453,
    CSSPropertyBorderInlineEnd = 454,
    CSSPropertyBorderInlineStart = 455,
    CSSPropertyBorderInlineStyle = 456,
    CSSPropertyBorderInlineWidth = 457,
    CSSPropertyBorderLeft = 458,
    CSSPropertyBorderRadius = 459,
    CSSPropertyBorderRight = 460,
    CSSPropertyBorderSpacing = 461,
    CSSPropertyBorderStyle = 462,
    CSSPropertyBorderTop = 463,
    CSSPropertyBorderWidth = 464,
    CSSPropertyColumnRule = 465,
    CSSPropertyColumns = 466,
    CSSPropertyContainIntrinsicSize = 467,
    CSSPropertyContainer = 468,
    CSSPropertyFlex = 469,
    CSSPropertyFlexFlow = 470,
    CSSPropertyFont = 471,
    CSSPropertyFontSynthesis = 472,
    CSSPropertyFontVariant = 473,
    CSSPropertyGap = 474,
    CSSPropertyGrid = 475,
    CSSPropertyGridArea = 476,
    CSSPropertyGridColumn = 477,
    CSSPropertyGridRow = 478,
    CSSPropertyGridTemplate = 479,
    CSSPropertyInset = 480,
    CSSPropertyInsetBlock = 481,
    CSSPropertyInsetInline = 482,
    CSSPropertyListStyle = 483,
    CSSPropertyMargin = 484,
    CSSPropertyMarginBlock = 485,
    CSSPropertyMarginInline = 486,
    CSSPropertyMarker = 487,
    CSSPropertyMask = 488,
    CSSPropertyMaskPosition = 489,
    CSSPropertyOffset = 490,
    CSSPropertyOutline = 491,
    CSSPropertyOverflow = 492,
    CSSPropertyOverscrollBehavior = 493,
    CSSPropertyPadding = 494,
    CSSPropertyPaddingBlock = 495,
    CSSPropertyPaddingInline = 496,
    CSSPropertyPageBreakAfter = 497,
    CSSPropertyPageBreakBefore = 498,
    CSSPropertyPageBreakInside = 499,
    CSSPropertyPerspectiveOrigin = 500,
    CSSPropertyPlaceContent = 501,
    CSSPropertyPlaceItems = 502,
    CSSPropertyPlaceSelf = 503,
    CSSPropertyScrollMargin = 504,
    CSSPropertyScrollMarginBlock = 505,
    CSSPropertyScrollMarginInline = 506,
    CSSPropertyScrollPadding = 507,
    CSSPropertyScrollPaddingBlock = 508,
    CSSPropertyScrollPaddingInline = 509,
    CSSPropertyTextDecoration = 510,
    CSSPropertyTextDecorationSkip = 511,
    CSSPropertyTextEmphasis = 512,
    CSSPropertyTransformOrigin = 513,
    CSSPropertyTransition = 514,
    CSSPropertyWebkitBackgroundSize = 515,
    CSSPropertyWebkitBorderImage = 516,
    CSSPropertyWebkitBorderRadius = 517,
    CSSPropertyWebkitColumnBreakAfter = 518,
    CSSPropertyWebkitColumnBreakBefore = 519,
    CSSPropertyWebkitColumnBreakInside = 520,
    CSSPropertyWebkitMask = 521,
    CSSPropertyWebkitMaskBoxImage = 522,
    CSSPropertyWebkitMaskPosition = 523,
    CSSPropertyWebkitPerspective = 524,
    CSSPropertyWebkitTextDecoration = 525,
    CSSPropertyWebkitTextOrientation = 526,
    CSSPropertyWebkitTextStroke = 527,
};

constexpr uint16_t firstCSSProperty = 2;
constexpr uint16_t numCSSProperties = 526;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWebkitRubyPosition;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyColor;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyLetterSpacing;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWebkitUserSelect;
constexpr auto firstDeferredProperty = CSSPropertyID::CSSPropertyBackgroundClip;
constexpr auto lastDeferredProperty = CSSPropertyID::CSSPropertyWebkitTextCombine;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;
extern const std::array<CSSPropertyID, 406> computedPropertyIDs;

struct CSSPropertySettings {
    WTF_MAKE_STRUCT_FAST_ALLOCATED;

    bool CSSOMViewSmoothScrollingEnabled { false };
    bool accentColorEnabled { false };
    bool aspectRatioEnabled { false };
    bool colorFilterEnabled { false };
    bool cssContainIntrinsicSizeEnabled { false };
    bool cssContainerQueriesEnabled { false };
    bool cssContainmentEnabled { false };
    bool cssContentVisibilityEnabled { false };
    bool cssCounterStyleAtRulesEnabled { false };
    bool cssCustomPropertiesAndValuesEnabled { false };
    bool cssIndividualTransformPropertiesEnabled { false };
    bool cssInputSecurityEnabled { false };
    bool cssLeadingTrimEnabled { false };
    bool cssMarginTrimEnabled { false };
    bool cssMotionPathEnabled { false };
    bool cssScrollAnchoringEnabled { false };
    bool cssTextAlignLastEnabled { false };
    bool cssTextGroupAlignEnabled { false };
    bool cssTextJustifyEnabled { false };
    bool cssTextSpacingEnabled { false };
    bool cssTextWrapEnabled { false };
    bool masonryEnabled { false };
    bool overscrollBehaviorEnabled { false };
    bool textAutosizingEnabled { false };
    bool webAnimationsCompositeOperationsEnabled { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
inline bool operator!=(const CSSPropertySettings& a, const CSSPropertySettings& b) { return !(a == b); }
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID relatedProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
        constexpr bool operator!=(std::nullptr_t) const { return index <= static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastDeferredProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}
constexpr bool isShorthand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstShorthandProperty) && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastShorthandProperty);
}

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

