// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyWritingMode = 3,
    CSSPropertyWebkitRubyPosition = 4,
    CSSPropertyColor = 5,
    CSSPropertyDirection = 6,
    CSSPropertyDisplay = 7,
    CSSPropertyFontFamily = 8,
    CSSPropertyFontFeatureSettings = 9,
    CSSPropertyFontKerning = 10,
    CSSPropertyFontOpticalSizing = 11,
    CSSPropertyFontPalette = 12,
    CSSPropertyFontSize = 13,
    CSSPropertyFontSizeAdjust = 14,
    CSSPropertyFontStretch = 15,
    CSSPropertyFontStyle = 16,
    CSSPropertyFontSynthesisSmallCaps = 17,
    CSSPropertyFontSynthesisStyle = 18,
    CSSPropertyFontSynthesisWeight = 19,
    CSSPropertyFontVariantAlternates = 20,
    CSSPropertyFontVariantCaps = 21,
    CSSPropertyFontVariantEastAsian = 22,
    CSSPropertyFontVariantLigatures = 23,
    CSSPropertyFontVariantNumeric = 24,
    CSSPropertyFontVariantPosition = 25,
    CSSPropertyFontVariationSettings = 26,
    CSSPropertyFontWeight = 27,
    CSSPropertyTextOrientation = 28,
    CSSPropertyTextRendering = 29,
    CSSPropertyZoom = 30,
    CSSPropertyWebkitFontSmoothing = 31,
    CSSPropertyWebkitLocale = 32,
    CSSPropertyWebkitTextSizeAdjust = 33,
    CSSPropertyWebkitTextZoom = 34,
    CSSPropertyLetterSpacing = 35,
    CSSPropertyTextAutospace = 36,
    CSSPropertyTextSpacingTrim = 37,
    CSSPropertyAccentColor = 38,
    CSSPropertyAdditiveSymbols = 39,
    CSSPropertyAlignContent = 40,
    CSSPropertyAlignItems = 41,
    CSSPropertyAlignSelf = 42,
    CSSPropertyAlignTracks = 43,
    CSSPropertyAlignmentBaseline = 44,
    CSSPropertyAlt = 45,
    CSSPropertyAnimationComposition = 46,
    CSSPropertyAnimationDelay = 47,
    CSSPropertyAnimationDirection = 48,
    CSSPropertyAnimationDuration = 49,
    CSSPropertyAnimationFillMode = 50,
    CSSPropertyAnimationIterationCount = 51,
    CSSPropertyAnimationName = 52,
    CSSPropertyAnimationPlayState = 53,
    CSSPropertyAnimationTimingFunction = 54,
    CSSPropertyAppearance = 55,
    CSSPropertyAspectRatio = 56,
    CSSPropertyBackfaceVisibility = 57,
    CSSPropertyBackgroundAttachment = 58,
    CSSPropertyBackgroundBlendMode = 59,
    CSSPropertyBackgroundColor = 60,
    CSSPropertyBackgroundImage = 61,
    CSSPropertyBackgroundPositionX = 62,
    CSSPropertyBackgroundPositionY = 63,
    CSSPropertyBackgroundRepeat = 64,
    CSSPropertyBackgroundSize = 65,
    CSSPropertyBasePalette = 66,
    CSSPropertyBaselineShift = 67,
    CSSPropertyBlockStepInsert = 68,
    CSSPropertyBlockStepSize = 69,
    CSSPropertyBorderCollapse = 70,
    CSSPropertyBorderImageOutset = 71,
    CSSPropertyBorderImageRepeat = 72,
    CSSPropertyBorderImageSlice = 73,
    CSSPropertyBorderImageSource = 74,
    CSSPropertyBorderImageWidth = 75,
    CSSPropertyBoxSizing = 76,
    CSSPropertyBreakAfter = 77,
    CSSPropertyBreakBefore = 78,
    CSSPropertyBreakInside = 79,
    CSSPropertyBufferedRendering = 80,
    CSSPropertyCaptionSide = 81,
    CSSPropertyCaretColor = 82,
    CSSPropertyClear = 83,
    CSSPropertyClip = 84,
    CSSPropertyClipPath = 85,
    CSSPropertyClipRule = 86,
    CSSPropertyColorInterpolation = 87,
    CSSPropertyColorInterpolationFilters = 88,
    CSSPropertyColumnCount = 89,
    CSSPropertyColumnFill = 90,
    CSSPropertyColumnGap = 91,
    CSSPropertyColumnRuleColor = 92,
    CSSPropertyColumnRuleStyle = 93,
    CSSPropertyColumnRuleWidth = 94,
    CSSPropertyColumnSpan = 95,
    CSSPropertyColumnWidth = 96,
    CSSPropertyContain = 97,
    CSSPropertyContainerName = 98,
    CSSPropertyContainerType = 99,
    CSSPropertyContent = 100,
    CSSPropertyContentVisibility = 101,
    CSSPropertyCounterIncrement = 102,
    CSSPropertyCounterReset = 103,
    CSSPropertyCounterSet = 104,
    CSSPropertyCursor = 105,
    CSSPropertyCx = 106,
    CSSPropertyCy = 107,
    CSSPropertyDominantBaseline = 108,
    CSSPropertyEmptyCells = 109,
    CSSPropertyFallback = 110,
    CSSPropertyFill = 111,
    CSSPropertyFillOpacity = 112,
    CSSPropertyFillRule = 113,
    CSSPropertyFilter = 114,
    CSSPropertyFlexBasis = 115,
    CSSPropertyFlexDirection = 116,
    CSSPropertyFlexGrow = 117,
    CSSPropertyFlexShrink = 118,
    CSSPropertyFlexWrap = 119,
    CSSPropertyFloat = 120,
    CSSPropertyFloodColor = 121,
    CSSPropertyFloodOpacity = 122,
    CSSPropertyFontDisplay = 123,
    CSSPropertyGlyphOrientationHorizontal = 124,
    CSSPropertyGlyphOrientationVertical = 125,
    CSSPropertyGridAutoColumns = 126,
    CSSPropertyGridAutoFlow = 127,
    CSSPropertyGridAutoRows = 128,
    CSSPropertyGridColumnEnd = 129,
    CSSPropertyGridColumnStart = 130,
    CSSPropertyGridRowEnd = 131,
    CSSPropertyGridRowStart = 132,
    CSSPropertyGridTemplateAreas = 133,
    CSSPropertyGridTemplateColumns = 134,
    CSSPropertyGridTemplateRows = 135,
    CSSPropertyHangingPunctuation = 136,
    CSSPropertyHyphenateCharacter = 137,
    CSSPropertyHyphens = 138,
    CSSPropertyImageOrientation = 139,
    CSSPropertyImageRendering = 140,
    CSSPropertyInherits = 141,
    CSSPropertyInitialValue = 142,
    CSSPropertyInputSecurity = 143,
    CSSPropertyIsolation = 144,
    CSSPropertyJustifyContent = 145,
    CSSPropertyJustifyItems = 146,
    CSSPropertyJustifySelf = 147,
    CSSPropertyJustifyTracks = 148,
    CSSPropertyKerning = 149,
    CSSPropertyLightingColor = 150,
    CSSPropertyLineBreak = 151,
    CSSPropertyLineHeight = 152,
    CSSPropertyListStyleImage = 153,
    CSSPropertyListStylePosition = 154,
    CSSPropertyListStyleType = 155,
    CSSPropertyMarginTrim = 156,
    CSSPropertyMarkerEnd = 157,
    CSSPropertyMarkerMid = 158,
    CSSPropertyMarkerStart = 159,
    CSSPropertyMaskImage = 160,
    CSSPropertyMaskOrigin = 161,
    CSSPropertyMaskRepeat = 162,
    CSSPropertyMaskSize = 163,
    CSSPropertyMaskType = 164,
    CSSPropertyMasonryAutoFlow = 165,
    CSSPropertyMathStyle = 166,
    CSSPropertyMixBlendMode = 167,
    CSSPropertyNegative = 168,
    CSSPropertyObjectFit = 169,
    CSSPropertyObjectPosition = 170,
    CSSPropertyOffsetAnchor = 171,
    CSSPropertyOffsetDistance = 172,
    CSSPropertyOffsetPath = 173,
    CSSPropertyOffsetPosition = 174,
    CSSPropertyOffsetRotate = 175,
    CSSPropertyOpacity = 176,
    CSSPropertyOrder = 177,
    CSSPropertyOrphans = 178,
    CSSPropertyOutlineColor = 179,
    CSSPropertyOutlineOffset = 180,
    CSSPropertyOutlineStyle = 181,
    CSSPropertyOutlineWidth = 182,
    CSSPropertyOverflowAnchor = 183,
    CSSPropertyOverflowWrap = 184,
    CSSPropertyOverflowX = 185,
    CSSPropertyOverflowY = 186,
    CSSPropertyOverrideColors = 187,
    CSSPropertyPad = 188,
    CSSPropertyPage = 189,
    CSSPropertyPaintOrder = 190,
    CSSPropertyPerspective = 191,
    CSSPropertyPerspectiveOriginX = 192,
    CSSPropertyPerspectiveOriginY = 193,
    CSSPropertyPointerEvents = 194,
    CSSPropertyPosition = 195,
    CSSPropertyPrefix = 196,
    CSSPropertyPrintColorAdjust = 197,
    CSSPropertyQuotes = 198,
    CSSPropertyR = 199,
    CSSPropertyRange = 200,
    CSSPropertyResize = 201,
    CSSPropertyRotate = 202,
    CSSPropertyRowGap = 203,
    CSSPropertyRx = 204,
    CSSPropertyRy = 205,
    CSSPropertyScale = 206,
    CSSPropertyScrollBehavior = 207,
    CSSPropertyScrollSnapAlign = 208,
    CSSPropertyScrollSnapStop = 209,
    CSSPropertyScrollSnapType = 210,
    CSSPropertyScrollbarColor = 211,
    CSSPropertyScrollbarGutter = 212,
    CSSPropertyScrollbarWidth = 213,
    CSSPropertyShapeImageThreshold = 214,
    CSSPropertyShapeMargin = 215,
    CSSPropertyShapeOutside = 216,
    CSSPropertyShapeRendering = 217,
    CSSPropertySize = 218,
    CSSPropertySizeAdjust = 219,
    CSSPropertySpeakAs = 220,
    CSSPropertySrc = 221,
    CSSPropertyStopColor = 222,
    CSSPropertyStopOpacity = 223,
    CSSPropertyStroke = 224,
    CSSPropertyStrokeColor = 225,
    CSSPropertyStrokeDasharray = 226,
    CSSPropertyStrokeDashoffset = 227,
    CSSPropertyStrokeLinecap = 228,
    CSSPropertyStrokeLinejoin = 229,
    CSSPropertyStrokeMiterlimit = 230,
    CSSPropertyStrokeOpacity = 231,
    CSSPropertyStrokeWidth = 232,
    CSSPropertySuffix = 233,
    CSSPropertySymbols = 234,
    CSSPropertySyntax = 235,
    CSSPropertySystem = 236,
    CSSPropertyTabSize = 237,
    CSSPropertyTableLayout = 238,
    CSSPropertyTextAlign = 239,
    CSSPropertyTextAlignLast = 240,
    CSSPropertyTextAnchor = 241,
    CSSPropertyTextBoxEdge = 242,
    CSSPropertyTextBoxTrim = 243,
    CSSPropertyTextDecorationColor = 244,
    CSSPropertyTextDecorationLine = 245,
    CSSPropertyTextDecorationSkipInk = 246,
    CSSPropertyTextDecorationStyle = 247,
    CSSPropertyTextDecorationThickness = 248,
    CSSPropertyTextEmphasisColor = 249,
    CSSPropertyTextEmphasisPosition = 250,
    CSSPropertyTextEmphasisStyle = 251,
    CSSPropertyTextGroupAlign = 252,
    CSSPropertyTextIndent = 253,
    CSSPropertyTextJustify = 254,
    CSSPropertyTextOverflow = 255,
    CSSPropertyTextShadow = 256,
    CSSPropertyTextTransform = 257,
    CSSPropertyTextUnderlineOffset = 258,
    CSSPropertyTextUnderlinePosition = 259,
    CSSPropertyTextWrap = 260,
    CSSPropertyTouchAction = 261,
    CSSPropertyTransform = 262,
    CSSPropertyTransformBox = 263,
    CSSPropertyTransformOriginX = 264,
    CSSPropertyTransformOriginY = 265,
    CSSPropertyTransformOriginZ = 266,
    CSSPropertyTransformStyle = 267,
    CSSPropertyTransitionDelay = 268,
    CSSPropertyTransitionDuration = 269,
    CSSPropertyTransitionProperty = 270,
    CSSPropertyTransitionTimingFunction = 271,
    CSSPropertyTranslate = 272,
    CSSPropertyUnicodeBidi = 273,
    CSSPropertyUnicodeRange = 274,
    CSSPropertyVectorEffect = 275,
    CSSPropertyVerticalAlign = 276,
    CSSPropertyVisibility = 277,
    CSSPropertyWhiteSpaceCollapse = 278,
    CSSPropertyWidows = 279,
    CSSPropertyWillChange = 280,
    CSSPropertyWordBreak = 281,
    CSSPropertyWordSpacing = 282,
    CSSPropertyX = 283,
    CSSPropertyY = 284,
    CSSPropertyZIndex = 285,
    CSSPropertyAppleColorFilter = 286,
    CSSPropertyApplePayButtonStyle = 287,
    CSSPropertyApplePayButtonType = 288,
    CSSPropertyInternalTextAutosizingStatus = 289,
    CSSPropertyWebkitBackdropFilter = 290,
    CSSPropertyWebkitBorderHorizontalSpacing = 291,
    CSSPropertyWebkitBorderVerticalSpacing = 292,
    CSSPropertyWebkitBoxAlign = 293,
    CSSPropertyWebkitBoxDecorationBreak = 294,
    CSSPropertyWebkitBoxDirection = 295,
    CSSPropertyWebkitBoxFlex = 296,
    CSSPropertyWebkitBoxFlexGroup = 297,
    CSSPropertyWebkitBoxLines = 298,
    CSSPropertyWebkitBoxOrdinalGroup = 299,
    CSSPropertyWebkitBoxOrient = 300,
    CSSPropertyWebkitBoxPack = 301,
    CSSPropertyWebkitBoxReflect = 302,
    CSSPropertyWebkitColumnAxis = 303,
    CSSPropertyWebkitColumnProgression = 304,
    CSSPropertyWebkitCursorVisibility = 305,
    CSSPropertyWebkitFontSizeDelta = 306,
    CSSPropertyWebkitHyphenateLimitAfter = 307,
    CSSPropertyWebkitHyphenateLimitBefore = 308,
    CSSPropertyWebkitHyphenateLimitLines = 309,
    CSSPropertyWebkitInitialLetter = 310,
    CSSPropertyWebkitLineAlign = 311,
    CSSPropertyWebkitLineBoxContain = 312,
    CSSPropertyWebkitLineClamp = 313,
    CSSPropertyWebkitLineGrid = 314,
    CSSPropertyWebkitLineSnap = 315,
    CSSPropertyWebkitMarqueeDirection = 316,
    CSSPropertyWebkitMarqueeIncrement = 317,
    CSSPropertyWebkitMarqueeRepetition = 318,
    CSSPropertyWebkitMarqueeSpeed = 319,
    CSSPropertyWebkitMarqueeStyle = 320,
    CSSPropertyWebkitMaskBoxImageOutset = 321,
    CSSPropertyWebkitMaskBoxImageRepeat = 322,
    CSSPropertyWebkitMaskBoxImageSlice = 323,
    CSSPropertyWebkitMaskBoxImageSource = 324,
    CSSPropertyWebkitMaskBoxImageWidth = 325,
    CSSPropertyWebkitMaskPositionX = 326,
    CSSPropertyWebkitMaskPositionY = 327,
    CSSPropertyWebkitNbspMode = 328,
    CSSPropertyWebkitRtlOrdering = 329,
    CSSPropertyWebkitTapHighlightColor = 330,
    CSSPropertyWebkitTextDecorationsInEffect = 331,
    CSSPropertyWebkitTextFillColor = 332,
    CSSPropertyWebkitTextSecurity = 333,
    CSSPropertyWebkitTextStrokeColor = 334,
    CSSPropertyWebkitTextStrokeWidth = 335,
    CSSPropertyWebkitUserDrag = 336,
    CSSPropertyWebkitUserModify = 337,
    CSSPropertyWebkitUserSelect = 338,
    CSSPropertyBackgroundClip = 339,
    CSSPropertyBackgroundOrigin = 340,
    CSSPropertyBlockSize = 341,
    CSSPropertyBorderBlockEndColor = 342,
    CSSPropertyBorderBlockEndStyle = 343,
    CSSPropertyBorderBlockEndWidth = 344,
    CSSPropertyBorderBlockStartColor = 345,
    CSSPropertyBorderBlockStartStyle = 346,
    CSSPropertyBorderBlockStartWidth = 347,
    CSSPropertyBorderBottomColor = 348,
    CSSPropertyBorderBottomLeftRadius = 349,
    CSSPropertyBorderBottomRightRadius = 350,
    CSSPropertyBorderBottomStyle = 351,
    CSSPropertyBorderBottomWidth = 352,
    CSSPropertyBorderEndEndRadius = 353,
    CSSPropertyBorderEndStartRadius = 354,
    CSSPropertyBorderInlineEndColor = 355,
    CSSPropertyBorderInlineEndStyle = 356,
    CSSPropertyBorderInlineEndWidth = 357,
    CSSPropertyBorderInlineStartColor = 358,
    CSSPropertyBorderInlineStartStyle = 359,
    CSSPropertyBorderInlineStartWidth = 360,
    CSSPropertyBorderLeftColor = 361,
    CSSPropertyBorderLeftStyle = 362,
    CSSPropertyBorderLeftWidth = 363,
    CSSPropertyBorderRightColor = 364,
    CSSPropertyBorderRightStyle = 365,
    CSSPropertyBorderRightWidth = 366,
    CSSPropertyBorderStartEndRadius = 367,
    CSSPropertyBorderStartStartRadius = 368,
    CSSPropertyBorderTopColor = 369,
    CSSPropertyBorderTopLeftRadius = 370,
    CSSPropertyBorderTopRightRadius = 371,
    CSSPropertyBorderTopStyle = 372,
    CSSPropertyBorderTopWidth = 373,
    CSSPropertyBottom = 374,
    CSSPropertyBoxShadow = 375,
    CSSPropertyContainIntrinsicBlockSize = 376,
    CSSPropertyContainIntrinsicHeight = 377,
    CSSPropertyContainIntrinsicInlineSize = 378,
    CSSPropertyContainIntrinsicWidth = 379,
    CSSPropertyHeight = 380,
    CSSPropertyInlineSize = 381,
    CSSPropertyInsetBlockEnd = 382,
    CSSPropertyInsetBlockStart = 383,
    CSSPropertyInsetInlineEnd = 384,
    CSSPropertyInsetInlineStart = 385,
    CSSPropertyLeft = 386,
    CSSPropertyMarginBlockEnd = 387,
    CSSPropertyMarginBlockStart = 388,
    CSSPropertyMarginBottom = 389,
    CSSPropertyMarginInlineEnd = 390,
    CSSPropertyMarginInlineStart = 391,
    CSSPropertyMarginLeft = 392,
    CSSPropertyMarginRight = 393,
    CSSPropertyMarginTop = 394,
    CSSPropertyMaskClip = 395,
    CSSPropertyMaskComposite = 396,
    CSSPropertyMaskMode = 397,
    CSSPropertyMaxBlockSize = 398,
    CSSPropertyMaxHeight = 399,
    CSSPropertyMaxInlineSize = 400,
    CSSPropertyMaxWidth = 401,
    CSSPropertyMinBlockSize = 402,
    CSSPropertyMinHeight = 403,
    CSSPropertyMinInlineSize = 404,
    CSSPropertyMinWidth = 405,
    CSSPropertyOverscrollBehaviorBlock = 406,
    CSSPropertyOverscrollBehaviorInline = 407,
    CSSPropertyOverscrollBehaviorX = 408,
    CSSPropertyOverscrollBehaviorY = 409,
    CSSPropertyPaddingBlockEnd = 410,
    CSSPropertyPaddingBlockStart = 411,
    CSSPropertyPaddingBottom = 412,
    CSSPropertyPaddingInlineEnd = 413,
    CSSPropertyPaddingInlineStart = 414,
    CSSPropertyPaddingLeft = 415,
    CSSPropertyPaddingRight = 416,
    CSSPropertyPaddingTop = 417,
    CSSPropertyRight = 418,
    CSSPropertyScrollMarginBlockEnd = 419,
    CSSPropertyScrollMarginBlockStart = 420,
    CSSPropertyScrollMarginBottom = 421,
    CSSPropertyScrollMarginInlineEnd = 422,
    CSSPropertyScrollMarginInlineStart = 423,
    CSSPropertyScrollMarginLeft = 424,
    CSSPropertyScrollMarginRight = 425,
    CSSPropertyScrollMarginTop = 426,
    CSSPropertyScrollPaddingBlockEnd = 427,
    CSSPropertyScrollPaddingBlockStart = 428,
    CSSPropertyScrollPaddingBottom = 429,
    CSSPropertyScrollPaddingInlineEnd = 430,
    CSSPropertyScrollPaddingInlineStart = 431,
    CSSPropertyScrollPaddingLeft = 432,
    CSSPropertyScrollPaddingRight = 433,
    CSSPropertyScrollPaddingTop = 434,
    CSSPropertyTextCombineUpright = 435,
    CSSPropertyTop = 436,
    CSSPropertyWidth = 437,
    CSSPropertyWebkitBackgroundClip = 438,
    CSSPropertyWebkitBackgroundOrigin = 439,
    CSSPropertyWebkitBoxShadow = 440,
    CSSPropertyWebkitMaskClip = 441,
    CSSPropertyWebkitMaskComposite = 442,
    CSSPropertyWebkitMaskSourceType = 443,
    CSSPropertyWebkitTextCombine = 444,
    CSSPropertyAll = 445,
    CSSPropertyAnimation = 446,
    CSSPropertyBackground = 447,
    CSSPropertyBackgroundPosition = 448,
    CSSPropertyBorder = 449,
    CSSPropertyBorderBlock = 450,
    CSSPropertyBorderBlockColor = 451,
    CSSPropertyBorderBlockEnd = 452,
    CSSPropertyBorderBlockStart = 453,
    CSSPropertyBorderBlockStyle = 454,
    CSSPropertyBorderBlockWidth = 455,
    CSSPropertyBorderBottom = 456,
    CSSPropertyBorderColor = 457,
    CSSPropertyBorderImage = 458,
    CSSPropertyBorderInline = 459,
    CSSPropertyBorderInlineColor = 460,
    CSSPropertyBorderInlineEnd = 461,
    CSSPropertyBorderInlineStart = 462,
    CSSPropertyBorderInlineStyle = 463,
    CSSPropertyBorderInlineWidth = 464,
    CSSPropertyBorderLeft = 465,
    CSSPropertyBorderRadius = 466,
    CSSPropertyBorderRight = 467,
    CSSPropertyBorderSpacing = 468,
    CSSPropertyBorderStyle = 469,
    CSSPropertyBorderTop = 470,
    CSSPropertyBorderWidth = 471,
    CSSPropertyColumnRule = 472,
    CSSPropertyColumns = 473,
    CSSPropertyContainIntrinsicSize = 474,
    CSSPropertyContainer = 475,
    CSSPropertyFlex = 476,
    CSSPropertyFlexFlow = 477,
    CSSPropertyFont = 478,
    CSSPropertyFontSynthesis = 479,
    CSSPropertyFontVariant = 480,
    CSSPropertyGap = 481,
    CSSPropertyGrid = 482,
    CSSPropertyGridArea = 483,
    CSSPropertyGridColumn = 484,
    CSSPropertyGridRow = 485,
    CSSPropertyGridTemplate = 486,
    CSSPropertyInset = 487,
    CSSPropertyInsetBlock = 488,
    CSSPropertyInsetInline = 489,
    CSSPropertyListStyle = 490,
    CSSPropertyMargin = 491,
    CSSPropertyMarginBlock = 492,
    CSSPropertyMarginInline = 493,
    CSSPropertyMarker = 494,
    CSSPropertyMask = 495,
    CSSPropertyMaskPosition = 496,
    CSSPropertyOffset = 497,
    CSSPropertyOutline = 498,
    CSSPropertyOverflow = 499,
    CSSPropertyOverscrollBehavior = 500,
    CSSPropertyPadding = 501,
    CSSPropertyPaddingBlock = 502,
    CSSPropertyPaddingInline = 503,
    CSSPropertyPageBreakAfter = 504,
    CSSPropertyPageBreakBefore = 505,
    CSSPropertyPageBreakInside = 506,
    CSSPropertyPerspectiveOrigin = 507,
    CSSPropertyPlaceContent = 508,
    CSSPropertyPlaceItems = 509,
    CSSPropertyPlaceSelf = 510,
    CSSPropertyScrollMargin = 511,
    CSSPropertyScrollMarginBlock = 512,
    CSSPropertyScrollMarginInline = 513,
    CSSPropertyScrollPadding = 514,
    CSSPropertyScrollPaddingBlock = 515,
    CSSPropertyScrollPaddingInline = 516,
    CSSPropertyTextDecoration = 517,
    CSSPropertyTextDecorationSkip = 518,
    CSSPropertyTextEmphasis = 519,
    CSSPropertyTransformOrigin = 520,
    CSSPropertyTransition = 521,
    CSSPropertyWhiteSpace = 522,
    CSSPropertyWebkitBackgroundSize = 523,
    CSSPropertyWebkitBorderImage = 524,
    CSSPropertyWebkitBorderRadius = 525,
    CSSPropertyWebkitColumnBreakAfter = 526,
    CSSPropertyWebkitColumnBreakBefore = 527,
    CSSPropertyWebkitColumnBreakInside = 528,
    CSSPropertyWebkitMask = 529,
    CSSPropertyWebkitMaskBoxImage = 530,
    CSSPropertyWebkitMaskPosition = 531,
    CSSPropertyWebkitPerspective = 532,
    CSSPropertyWebkitTextDecoration = 533,
    CSSPropertyWebkitTextOrientation = 534,
    CSSPropertyWebkitTextStroke = 535,
};

constexpr uint16_t firstCSSProperty = 2;
constexpr uint16_t numCSSProperties = 534;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWebkitRubyPosition;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyColor;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyTextSpacingTrim;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWebkitUserSelect;
constexpr auto firstDeferredProperty = CSSPropertyID::CSSPropertyBackgroundClip;
constexpr auto lastDeferredProperty = CSSPropertyID::CSSPropertyWebkitTextCombine;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;
extern const std::array<CSSPropertyID, 412> computedPropertyIDs;

struct CSSPropertySettings {
    WTF_MAKE_STRUCT_FAST_ALLOCATED;

    bool CSSOMViewSmoothScrollingEnabled { false };
    bool accentColorEnabled { false };
    bool aspectRatioEnabled { false };
    bool colorFilterEnabled { false };
    bool cssContainIntrinsicSizeEnabled { false };
    bool cssContainerQueriesEnabled { false };
    bool cssContainmentEnabled { false };
    bool cssContentVisibilityEnabled { false };
    bool cssCounterStyleAtRulesEnabled { false };
    bool cssCustomPropertiesAndValuesEnabled { false };
    bool cssFontFaceSizeAdjustEnabled { false };
    bool cssIndividualTransformPropertiesEnabled { false };
    bool cssInputSecurityEnabled { false };
    bool cssMarginTrimEnabled { false };
    bool cssMotionPathEnabled { false };
    bool cssRhythmicSizingEnabled { false };
    bool cssScrollAnchoringEnabled { false };
    bool cssScrollbarColorEnabled { false };
    bool cssScrollbarGutterEnabled { false };
    bool cssScrollbarWidthEnabled { false };
    bool cssTextAlignLastEnabled { false };
    bool cssTextBoxTrimEnabled { false };
    bool cssTextGroupAlignEnabled { false };
    bool cssTextJustifyEnabled { false };
    bool cssTextSpacingEnabled { false };
    bool cssWhiteSpaceLonghandsEnabled { false };
    bool masonryEnabled { false };
    bool masonryTrackAlignmentEnabled { false };
    bool overscrollBehaviorEnabled { false };
    bool textAutosizingEnabled { false };
    bool webAnimationsCompositeOperationsEnabled { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID relatedProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastDeferredProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}
constexpr bool isShorthand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstShorthandProperty) && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastShorthandProperty);
}

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

