/*
 * Copyright (C) 2014-2024 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// This file is automatically generated from CSSPseudoSelectors.json by the process-css-pseudo-selectors.py script, do not edit by hand.

#pragma once

namespace WebCore {

enum class CSSSelectorPseudoClass : uint8_t {
#if ENABLE(ATTACHMENT_ELEMENT)
    AppleHasAttachment,
#endif
#if ENABLE(FULLSCREEN_API)
    InternalAnimatingFullscreenTransition,
#endif
#if ENABLE(FULLSCREEN_API)
    InternalFullscreenDocument,
#endif
    InternalHTMLDocument,
#if ENABLE(FULLSCREEN_API)
    InternalInWindowFullscreen,
#endif
    InternalMediaDocument,
    WebKitAny,
    WebKitAutofillAndObscured,
    WebKitAutofillStrongPassword,
    WebKitAutofillStrongPasswordViewable,
    WebKitDrag,
    Active,
    ActiveViewTransition,
    AnyLink,
    Autofill,
#if ENABLE(VIDEO)
    Buffering,
#endif
    Checked,
    CornerPresent,
    Decrement,
    Default,
    Defined,
    Dir,
    Disabled,
    DoubleButton,
    Empty,
    Enabled,
    End,
    FirstChild,
    FirstOfType,
    Focus,
    FocusVisible,
    FocusWithin,
#if ENABLE(FULLSCREEN_API)
    Fullscreen,
#endif
#if ENABLE(VIDEO)
    Future,
#endif
    Has,
    Horizontal,
    Host,
    Hover,
    InRange,
    Increment,
    Indeterminate,
    Invalid,
    Is,
    Lang,
    LastChild,
    LastOfType,
    Link,
    Modal,
#if ENABLE(VIDEO)
    Muted,
#endif
    NoButton,
    Not,
    NthChild,
    NthLastChild,
    NthLastOfType,
    NthOfType,
    OnlyChild,
    OnlyOfType,
    Optional,
    OutOfRange,
#if ENABLE(VIDEO)
    Past,
#endif
#if ENABLE(VIDEO)
    Paused,
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    PictureInPicture,
#endif
    PlaceholderShown,
#if ENABLE(VIDEO)
    Playing,
#endif
    PopoverOpen,
    ReadOnly,
    ReadWrite,
    Required,
    Root,
    Scope,
#if ENABLE(VIDEO)
    Seeking,
#endif
#if ENABLE(VIDEO)
    Stalled,
#endif
    State,
    SingleButton,
    Start,
    Target,
    UserInvalid,
    UserValid,
    Valid,
    Vertical,
    Visited,
#if ENABLE(VIDEO)
    VolumeLocked,
#endif
    Where,
    WindowInactive,
};

enum class CSSSelectorPseudoElement : uint8_t {
    InternalWritingSuggestions,
    WebKitResizer,
    WebKitScrollbar,
    WebKitScrollbarButton,
    WebKitScrollbarCorner,
    WebKitScrollbarThumb,
    WebKitScrollbarTrack,
    WebKitScrollbarTrackPiece,
    After,
    Backdrop,
    Before,
#if ENABLE(VIDEO)
    Cue,
#endif
    FirstLetter,
    FirstLine,
    GrammarError,
    Highlight,
    Marker,
    Part,
    Selection,
    Slotted,
    SpellingError,
    TargetText,
    ViewTransition,
    ViewTransitionGroup,
    ViewTransitionImagePair,
    ViewTransitionNew,
    ViewTransitionOld,
    UserAgentPart,
    UserAgentPartLegacyAlias,
    WebKitUnknown,
};

} // namespace WebCore
