// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyRubyPosition = 3,
    CSSPropertyWritingMode = 4,
    CSSPropertyDirection = 5,
    CSSPropertyDisplay = 6,
    CSSPropertyFontFamily = 7,
    CSSPropertyFontFeatureSettings = 8,
    CSSPropertyFontKerning = 9,
    CSSPropertyFontOpticalSizing = 10,
    CSSPropertyFontPalette = 11,
    CSSPropertyFontSize = 12,
    CSSPropertyFontSizeAdjust = 13,
    CSSPropertyFontStyle = 14,
    CSSPropertyFontSynthesisSmallCaps = 15,
    CSSPropertyFontSynthesisStyle = 16,
    CSSPropertyFontSynthesisWeight = 17,
    CSSPropertyFontVariantAlternates = 18,
    CSSPropertyFontVariantCaps = 19,
    CSSPropertyFontVariantEastAsian = 20,
    CSSPropertyFontVariantEmoji = 21,
    CSSPropertyFontVariantLigatures = 22,
    CSSPropertyFontVariantNumeric = 23,
    CSSPropertyFontVariantPosition = 24,
    CSSPropertyFontVariationSettings = 25,
    CSSPropertyFontWeight = 26,
    CSSPropertyFontWidth = 27,
    CSSPropertyTextOrientation = 28,
    CSSPropertyTextRendering = 29,
    CSSPropertyZoom = 30,
    CSSPropertyWebkitFontSmoothing = 31,
    CSSPropertyWebkitLocale = 32,
    CSSPropertyWebkitTextSizeAdjust = 33,
    CSSPropertyWebkitTextZoom = 34,
    CSSPropertyLetterSpacing = 35,
    CSSPropertyTextAutospace = 36,
    CSSPropertyTextSpacingTrim = 37,
    CSSPropertyAccentColor = 38,
    CSSPropertyAdditiveSymbols = 39,
    CSSPropertyAlignContent = 40,
    CSSPropertyAlignItems = 41,
    CSSPropertyAlignSelf = 42,
    CSSPropertyAlignmentBaseline = 43,
    CSSPropertyAnchorName = 44,
    CSSPropertyAnchorScope = 45,
    CSSPropertyAnimationComposition = 46,
    CSSPropertyAnimationDelay = 47,
    CSSPropertyAnimationDirection = 48,
    CSSPropertyAnimationDuration = 49,
    CSSPropertyAnimationFillMode = 50,
    CSSPropertyAnimationIterationCount = 51,
    CSSPropertyAnimationName = 52,
    CSSPropertyAnimationPlayState = 53,
    CSSPropertyAnimationRangeEnd = 54,
    CSSPropertyAnimationRangeStart = 55,
    CSSPropertyAnimationTimeline = 56,
    CSSPropertyAnimationTimingFunction = 57,
    CSSPropertyAppearance = 58,
    CSSPropertyAspectRatio = 59,
    CSSPropertyBackdropFilter = 60,
    CSSPropertyBackfaceVisibility = 61,
    CSSPropertyBackgroundAttachment = 62,
    CSSPropertyBackgroundBlendMode = 63,
    CSSPropertyBackgroundClip = 64,
    CSSPropertyBackgroundColor = 65,
    CSSPropertyBackgroundImage = 66,
    CSSPropertyBackgroundOrigin = 67,
    CSSPropertyBackgroundPositionX = 68,
    CSSPropertyBackgroundPositionY = 69,
    CSSPropertyBackgroundRepeat = 70,
    CSSPropertyBackgroundSize = 71,
    CSSPropertyBasePalette = 72,
    CSSPropertyBaselineShift = 73,
    CSSPropertyBlockEllipsis = 74,
    CSSPropertyBlockStepAlign = 75,
    CSSPropertyBlockStepInsert = 76,
    CSSPropertyBlockStepRound = 77,
    CSSPropertyBlockStepSize = 78,
    CSSPropertyBorderCollapse = 79,
    CSSPropertyBorderImageOutset = 80,
    CSSPropertyBorderImageRepeat = 81,
    CSSPropertyBorderImageSlice = 82,
    CSSPropertyBorderImageSource = 83,
    CSSPropertyBorderImageWidth = 84,
    CSSPropertyBoxShadow = 85,
    CSSPropertyBoxSizing = 86,
    CSSPropertyBreakAfter = 87,
    CSSPropertyBreakBefore = 88,
    CSSPropertyBreakInside = 89,
    CSSPropertyBufferedRendering = 90,
    CSSPropertyCaptionSide = 91,
    CSSPropertyCaretColor = 92,
    CSSPropertyClear = 93,
    CSSPropertyClip = 94,
    CSSPropertyClipPath = 95,
    CSSPropertyClipRule = 96,
    CSSPropertyColor = 97,
    CSSPropertyColorInterpolation = 98,
    CSSPropertyColorInterpolationFilters = 99,
    CSSPropertyColumnCount = 100,
    CSSPropertyColumnFill = 101,
    CSSPropertyColumnGap = 102,
    CSSPropertyColumnRuleColor = 103,
    CSSPropertyColumnRuleStyle = 104,
    CSSPropertyColumnRuleWidth = 105,
    CSSPropertyColumnSpan = 106,
    CSSPropertyColumnWidth = 107,
    CSSPropertyContain = 108,
    CSSPropertyContainerName = 109,
    CSSPropertyContainerType = 110,
    CSSPropertyContent = 111,
    CSSPropertyContentVisibility = 112,
    CSSPropertyContinue = 113,
    CSSPropertyCounterIncrement = 114,
    CSSPropertyCounterReset = 115,
    CSSPropertyCounterSet = 116,
    CSSPropertyCursor = 117,
    CSSPropertyCx = 118,
    CSSPropertyCy = 119,
    CSSPropertyD = 120,
    CSSPropertyDominantBaseline = 121,
    CSSPropertyDynamicRangeLimit = 122,
    CSSPropertyEmptyCells = 123,
    CSSPropertyFallback = 124,
    CSSPropertyFieldSizing = 125,
    CSSPropertyFill = 126,
    CSSPropertyFillOpacity = 127,
    CSSPropertyFillRule = 128,
    CSSPropertyFilter = 129,
    CSSPropertyFlexBasis = 130,
    CSSPropertyFlexDirection = 131,
    CSSPropertyFlexGrow = 132,
    CSSPropertyFlexShrink = 133,
    CSSPropertyFlexWrap = 134,
    CSSPropertyFloat = 135,
    CSSPropertyFloodColor = 136,
    CSSPropertyFloodOpacity = 137,
    CSSPropertyFontDisplay = 138,
    CSSPropertyGlyphOrientationHorizontal = 139,
    CSSPropertyGlyphOrientationVertical = 140,
    CSSPropertyGridAutoColumns = 141,
    CSSPropertyGridAutoFlow = 142,
    CSSPropertyGridAutoRows = 143,
    CSSPropertyGridColumnEnd = 144,
    CSSPropertyGridColumnStart = 145,
    CSSPropertyGridRowEnd = 146,
    CSSPropertyGridRowStart = 147,
    CSSPropertyGridTemplateAreas = 148,
    CSSPropertyGridTemplateColumns = 149,
    CSSPropertyGridTemplateRows = 150,
    CSSPropertyHangingPunctuation = 151,
    CSSPropertyHyphenateCharacter = 152,
    CSSPropertyHyphens = 153,
    CSSPropertyImageOrientation = 154,
    CSSPropertyImageRendering = 155,
    CSSPropertyInherits = 156,
    CSSPropertyInitialValue = 157,
    CSSPropertyInputSecurity = 158,
    CSSPropertyIsolation = 159,
    CSSPropertyJustifyContent = 160,
    CSSPropertyJustifyItems = 161,
    CSSPropertyJustifySelf = 162,
    CSSPropertyLightingColor = 163,
    CSSPropertyLineBreak = 164,
    CSSPropertyLineFitEdge = 165,
    CSSPropertyLineHeight = 166,
    CSSPropertyListStyleImage = 167,
    CSSPropertyListStylePosition = 168,
    CSSPropertyListStyleType = 169,
    CSSPropertyMarginTrim = 170,
    CSSPropertyMarkerEnd = 171,
    CSSPropertyMarkerMid = 172,
    CSSPropertyMarkerStart = 173,
    CSSPropertyMaskBorderOutset = 174,
    CSSPropertyMaskBorderRepeat = 175,
    CSSPropertyMaskBorderSlice = 176,
    CSSPropertyMaskBorderSource = 177,
    CSSPropertyMaskBorderWidth = 178,
    CSSPropertyMaskClip = 179,
    CSSPropertyMaskComposite = 180,
    CSSPropertyMaskImage = 181,
    CSSPropertyMaskMode = 182,
    CSSPropertyMaskOrigin = 183,
    CSSPropertyMaskRepeat = 184,
    CSSPropertyMaskSize = 185,
    CSSPropertyMaskType = 186,
    CSSPropertyMathShift = 187,
    CSSPropertyMathStyle = 188,
    CSSPropertyMaxLines = 189,
    CSSPropertyMixBlendMode = 190,
    CSSPropertyNavigation = 191,
    CSSPropertyNegative = 192,
    CSSPropertyObjectFit = 193,
    CSSPropertyObjectPosition = 194,
    CSSPropertyOffsetAnchor = 195,
    CSSPropertyOffsetDistance = 196,
    CSSPropertyOffsetPath = 197,
    CSSPropertyOffsetPosition = 198,
    CSSPropertyOffsetRotate = 199,
    CSSPropertyOpacity = 200,
    CSSPropertyOrder = 201,
    CSSPropertyOrphans = 202,
    CSSPropertyOutlineColor = 203,
    CSSPropertyOutlineOffset = 204,
    CSSPropertyOutlineStyle = 205,
    CSSPropertyOutlineWidth = 206,
    CSSPropertyOverflowAnchor = 207,
    CSSPropertyOverflowWrap = 208,
    CSSPropertyOverrideColors = 209,
    CSSPropertyPad = 210,
    CSSPropertyPage = 211,
    CSSPropertyPaintOrder = 212,
    CSSPropertyPerspective = 213,
    CSSPropertyPerspectiveOriginX = 214,
    CSSPropertyPerspectiveOriginY = 215,
    CSSPropertyPointerEvents = 216,
    CSSPropertyPosition = 217,
    CSSPropertyPositionAnchor = 218,
    CSSPropertyPositionArea = 219,
    CSSPropertyPositionTryFallbacks = 220,
    CSSPropertyPositionTryOrder = 221,
    CSSPropertyPositionVisibility = 222,
    CSSPropertyPrefix = 223,
    CSSPropertyPrintColorAdjust = 224,
    CSSPropertyQuotes = 225,
    CSSPropertyR = 226,
    CSSPropertyRange = 227,
    CSSPropertyResize = 228,
    CSSPropertyResult = 229,
    CSSPropertyRotate = 230,
    CSSPropertyRowGap = 231,
    CSSPropertyRubyAlign = 232,
    CSSPropertyRubyOverhang = 233,
    CSSPropertyRx = 234,
    CSSPropertyRy = 235,
    CSSPropertyScale = 236,
    CSSPropertyScrollBehavior = 237,
    CSSPropertyScrollSnapAlign = 238,
    CSSPropertyScrollSnapStop = 239,
    CSSPropertyScrollSnapType = 240,
    CSSPropertyScrollTimelineAxis = 241,
    CSSPropertyScrollTimelineName = 242,
    CSSPropertyScrollbarColor = 243,
    CSSPropertyScrollbarGutter = 244,
    CSSPropertyScrollbarWidth = 245,
    CSSPropertyShapeImageThreshold = 246,
    CSSPropertyShapeMargin = 247,
    CSSPropertyShapeOutside = 248,
    CSSPropertyShapeRendering = 249,
    CSSPropertySize = 250,
    CSSPropertySizeAdjust = 251,
    CSSPropertySpeakAs = 252,
    CSSPropertySrc = 253,
    CSSPropertyStopColor = 254,
    CSSPropertyStopOpacity = 255,
    CSSPropertyStroke = 256,
    CSSPropertyStrokeColor = 257,
    CSSPropertyStrokeDasharray = 258,
    CSSPropertyStrokeDashoffset = 259,
    CSSPropertyStrokeLinecap = 260,
    CSSPropertyStrokeLinejoin = 261,
    CSSPropertyStrokeMiterlimit = 262,
    CSSPropertyStrokeOpacity = 263,
    CSSPropertyStrokeWidth = 264,
    CSSPropertySuffix = 265,
    CSSPropertySymbols = 266,
    CSSPropertySyntax = 267,
    CSSPropertySystem = 268,
    CSSPropertyTabSize = 269,
    CSSPropertyTableLayout = 270,
    CSSPropertyTextAlign = 271,
    CSSPropertyTextAlignLast = 272,
    CSSPropertyTextAnchor = 273,
    CSSPropertyTextBoxEdge = 274,
    CSSPropertyTextBoxTrim = 275,
    CSSPropertyTextCombineUpright = 276,
    CSSPropertyTextDecorationColor = 277,
    CSSPropertyTextDecorationLine = 278,
    CSSPropertyTextDecorationSkipInk = 279,
    CSSPropertyTextDecorationStyle = 280,
    CSSPropertyTextDecorationThickness = 281,
    CSSPropertyTextEmphasisColor = 282,
    CSSPropertyTextEmphasisPosition = 283,
    CSSPropertyTextEmphasisStyle = 284,
    CSSPropertyTextGroupAlign = 285,
    CSSPropertyTextIndent = 286,
    CSSPropertyTextJustify = 287,
    CSSPropertyTextOverflow = 288,
    CSSPropertyTextShadow = 289,
    CSSPropertyTextTransform = 290,
    CSSPropertyTextUnderlineOffset = 291,
    CSSPropertyTextUnderlinePosition = 292,
    CSSPropertyTextWrapMode = 293,
    CSSPropertyTextWrapStyle = 294,
    CSSPropertyTimelineScope = 295,
    CSSPropertyTouchAction = 296,
    CSSPropertyTransform = 297,
    CSSPropertyTransformBox = 298,
    CSSPropertyTransformOriginX = 299,
    CSSPropertyTransformOriginY = 300,
    CSSPropertyTransformOriginZ = 301,
    CSSPropertyTransformStyle = 302,
    CSSPropertyTransitionBehavior = 303,
    CSSPropertyTransitionDelay = 304,
    CSSPropertyTransitionDuration = 305,
    CSSPropertyTransitionProperty = 306,
    CSSPropertyTransitionTimingFunction = 307,
    CSSPropertyTranslate = 308,
    CSSPropertyTypes = 309,
    CSSPropertyUnicodeBidi = 310,
    CSSPropertyUnicodeRange = 311,
    CSSPropertyVectorEffect = 312,
    CSSPropertyVerticalAlign = 313,
    CSSPropertyViewTimelineAxis = 314,
    CSSPropertyViewTimelineInset = 315,
    CSSPropertyViewTimelineName = 316,
    CSSPropertyViewTransitionClass = 317,
    CSSPropertyViewTransitionName = 318,
    CSSPropertyVisibility = 319,
    CSSPropertyWhiteSpaceCollapse = 320,
    CSSPropertyWidows = 321,
    CSSPropertyWillChange = 322,
    CSSPropertyWordBreak = 323,
    CSSPropertyX = 324,
    CSSPropertyY = 325,
    CSSPropertyZIndex = 326,
    CSSPropertyAppleColorFilter = 327,
    CSSPropertyApplePayButtonStyle = 328,
    CSSPropertyApplePayButtonType = 329,
    CSSPropertyAppleVisualEffect = 330,
    CSSPropertyInternalTextAutosizingStatus = 331,
    CSSPropertyWebkitBackdropFilter = 332,
    CSSPropertyWebkitBackgroundClip = 333,
    CSSPropertyWebkitBackgroundOrigin = 334,
    CSSPropertyWebkitBorderHorizontalSpacing = 335,
    CSSPropertyWebkitBorderVerticalSpacing = 336,
    CSSPropertyWebkitBoxAlign = 337,
    CSSPropertyWebkitBoxDecorationBreak = 338,
    CSSPropertyWebkitBoxDirection = 339,
    CSSPropertyWebkitBoxFlex = 340,
    CSSPropertyWebkitBoxFlexGroup = 341,
    CSSPropertyWebkitBoxLines = 342,
    CSSPropertyWebkitBoxOrdinalGroup = 343,
    CSSPropertyWebkitBoxOrient = 344,
    CSSPropertyWebkitBoxPack = 345,
    CSSPropertyWebkitBoxReflect = 346,
    CSSPropertyWebkitBoxShadow = 347,
    CSSPropertyWebkitColumnAxis = 348,
    CSSPropertyWebkitColumnProgression = 349,
    CSSPropertyWebkitCursorVisibility = 350,
    CSSPropertyWebkitFontSizeDelta = 351,
    CSSPropertyWebkitHyphenateLimitAfter = 352,
    CSSPropertyWebkitHyphenateLimitBefore = 353,
    CSSPropertyWebkitHyphenateLimitLines = 354,
    CSSPropertyWebkitInitialLetter = 355,
    CSSPropertyWebkitLineAlign = 356,
    CSSPropertyWebkitLineBoxContain = 357,
    CSSPropertyWebkitLineClamp = 358,
    CSSPropertyWebkitLineGrid = 359,
    CSSPropertyWebkitLineSnap = 360,
    CSSPropertyWebkitMarqueeDirection = 361,
    CSSPropertyWebkitMarqueeIncrement = 362,
    CSSPropertyWebkitMarqueeRepetition = 363,
    CSSPropertyWebkitMarqueeSpeed = 364,
    CSSPropertyWebkitMarqueeStyle = 365,
    CSSPropertyWebkitMaskClip = 366,
    CSSPropertyWebkitMaskComposite = 367,
    CSSPropertyWebkitMaskPositionX = 368,
    CSSPropertyWebkitMaskPositionY = 369,
    CSSPropertyWebkitMaskSourceType = 370,
    CSSPropertyWebkitNbspMode = 371,
    CSSPropertyWebkitRtlOrdering = 372,
    CSSPropertyWebkitRubyPosition = 373,
    CSSPropertyWebkitTapHighlightColor = 374,
    CSSPropertyWebkitTextCombine = 375,
    CSSPropertyWebkitTextDecorationsInEffect = 376,
    CSSPropertyWebkitTextFillColor = 377,
    CSSPropertyWebkitTextSecurity = 378,
    CSSPropertyWebkitTextStrokeColor = 379,
    CSSPropertyWebkitTextStrokeWidth = 380,
    CSSPropertyWebkitUserDrag = 381,
    CSSPropertyWebkitUserModify = 382,
    CSSPropertyWebkitUserSelect = 383,
    CSSPropertyWordSpacing = 384,
    CSSPropertyBorderBottomColor = 385,
    CSSPropertyBorderBottomLeftRadius = 386,
    CSSPropertyBorderBottomRightRadius = 387,
    CSSPropertyBorderBottomStyle = 388,
    CSSPropertyBorderBottomWidth = 389,
    CSSPropertyBorderLeftColor = 390,
    CSSPropertyBorderLeftStyle = 391,
    CSSPropertyBorderLeftWidth = 392,
    CSSPropertyBorderRightColor = 393,
    CSSPropertyBorderRightStyle = 394,
    CSSPropertyBorderRightWidth = 395,
    CSSPropertyBorderTopColor = 396,
    CSSPropertyBorderTopLeftRadius = 397,
    CSSPropertyBorderTopRightRadius = 398,
    CSSPropertyBorderTopStyle = 399,
    CSSPropertyBorderTopWidth = 400,
    CSSPropertyBottom = 401,
    CSSPropertyContainIntrinsicHeight = 402,
    CSSPropertyContainIntrinsicWidth = 403,
    CSSPropertyCornerBottomLeftShape = 404,
    CSSPropertyCornerBottomRightShape = 405,
    CSSPropertyCornerTopLeftShape = 406,
    CSSPropertyCornerTopRightShape = 407,
    CSSPropertyHeight = 408,
    CSSPropertyLeft = 409,
    CSSPropertyMarginBottom = 410,
    CSSPropertyMarginLeft = 411,
    CSSPropertyMarginRight = 412,
    CSSPropertyMarginTop = 413,
    CSSPropertyMaxHeight = 414,
    CSSPropertyMaxWidth = 415,
    CSSPropertyMinHeight = 416,
    CSSPropertyMinWidth = 417,
    CSSPropertyOverflowX = 418,
    CSSPropertyOverflowY = 419,
    CSSPropertyOverscrollBehaviorX = 420,
    CSSPropertyOverscrollBehaviorY = 421,
    CSSPropertyPaddingBottom = 422,
    CSSPropertyPaddingLeft = 423,
    CSSPropertyPaddingRight = 424,
    CSSPropertyPaddingTop = 425,
    CSSPropertyRight = 426,
    CSSPropertyScrollMarginBottom = 427,
    CSSPropertyScrollMarginLeft = 428,
    CSSPropertyScrollMarginRight = 429,
    CSSPropertyScrollMarginTop = 430,
    CSSPropertyScrollPaddingBottom = 431,
    CSSPropertyScrollPaddingLeft = 432,
    CSSPropertyScrollPaddingRight = 433,
    CSSPropertyScrollPaddingTop = 434,
    CSSPropertyTop = 435,
    CSSPropertyWidth = 436,
    CSSPropertyBlockSize = 437,
    CSSPropertyBorderBlockEndColor = 438,
    CSSPropertyBorderBlockEndStyle = 439,
    CSSPropertyBorderBlockEndWidth = 440,
    CSSPropertyBorderBlockStartColor = 441,
    CSSPropertyBorderBlockStartStyle = 442,
    CSSPropertyBorderBlockStartWidth = 443,
    CSSPropertyBorderEndEndRadius = 444,
    CSSPropertyBorderEndStartRadius = 445,
    CSSPropertyBorderInlineEndColor = 446,
    CSSPropertyBorderInlineEndStyle = 447,
    CSSPropertyBorderInlineEndWidth = 448,
    CSSPropertyBorderInlineStartColor = 449,
    CSSPropertyBorderInlineStartStyle = 450,
    CSSPropertyBorderInlineStartWidth = 451,
    CSSPropertyBorderStartEndRadius = 452,
    CSSPropertyBorderStartStartRadius = 453,
    CSSPropertyContainIntrinsicBlockSize = 454,
    CSSPropertyContainIntrinsicInlineSize = 455,
    CSSPropertyCornerEndEndShape = 456,
    CSSPropertyCornerEndStartShape = 457,
    CSSPropertyCornerStartEndShape = 458,
    CSSPropertyCornerStartStartShape = 459,
    CSSPropertyInlineSize = 460,
    CSSPropertyInsetBlockEnd = 461,
    CSSPropertyInsetBlockStart = 462,
    CSSPropertyInsetInlineEnd = 463,
    CSSPropertyInsetInlineStart = 464,
    CSSPropertyMarginBlockEnd = 465,
    CSSPropertyMarginBlockStart = 466,
    CSSPropertyMarginInlineEnd = 467,
    CSSPropertyMarginInlineStart = 468,
    CSSPropertyMaxBlockSize = 469,
    CSSPropertyMaxInlineSize = 470,
    CSSPropertyMinBlockSize = 471,
    CSSPropertyMinInlineSize = 472,
    CSSPropertyOverflowBlock = 473,
    CSSPropertyOverflowInline = 474,
    CSSPropertyOverscrollBehaviorBlock = 475,
    CSSPropertyOverscrollBehaviorInline = 476,
    CSSPropertyPaddingBlockEnd = 477,
    CSSPropertyPaddingBlockStart = 478,
    CSSPropertyPaddingInlineEnd = 479,
    CSSPropertyPaddingInlineStart = 480,
    CSSPropertyScrollMarginBlockEnd = 481,
    CSSPropertyScrollMarginBlockStart = 482,
    CSSPropertyScrollMarginInlineEnd = 483,
    CSSPropertyScrollMarginInlineStart = 484,
    CSSPropertyScrollPaddingBlockEnd = 485,
    CSSPropertyScrollPaddingBlockStart = 486,
    CSSPropertyScrollPaddingInlineEnd = 487,
    CSSPropertyScrollPaddingInlineStart = 488,
    CSSPropertyAll = 489,
    CSSPropertyAnimation = 490,
    CSSPropertyAnimationRange = 491,
    CSSPropertyBackground = 492,
    CSSPropertyBackgroundPosition = 493,
    CSSPropertyBlockStep = 494,
    CSSPropertyBorder = 495,
    CSSPropertyBorderBlock = 496,
    CSSPropertyBorderBlockColor = 497,
    CSSPropertyBorderBlockEnd = 498,
    CSSPropertyBorderBlockStart = 499,
    CSSPropertyBorderBlockStyle = 500,
    CSSPropertyBorderBlockWidth = 501,
    CSSPropertyBorderBottom = 502,
    CSSPropertyBorderColor = 503,
    CSSPropertyBorderImage = 504,
    CSSPropertyBorderInline = 505,
    CSSPropertyBorderInlineColor = 506,
    CSSPropertyBorderInlineEnd = 507,
    CSSPropertyBorderInlineStart = 508,
    CSSPropertyBorderInlineStyle = 509,
    CSSPropertyBorderInlineWidth = 510,
    CSSPropertyBorderLeft = 511,
    CSSPropertyBorderRadius = 512,
    CSSPropertyBorderRight = 513,
    CSSPropertyBorderSpacing = 514,
    CSSPropertyBorderStyle = 515,
    CSSPropertyBorderTop = 516,
    CSSPropertyBorderWidth = 517,
    CSSPropertyColumnRule = 518,
    CSSPropertyColumns = 519,
    CSSPropertyContainIntrinsicSize = 520,
    CSSPropertyContainer = 521,
    CSSPropertyCornerShape = 522,
    CSSPropertyFlex = 523,
    CSSPropertyFlexFlow = 524,
    CSSPropertyFont = 525,
    CSSPropertyFontSynthesis = 526,
    CSSPropertyFontVariant = 527,
    CSSPropertyGap = 528,
    CSSPropertyGrid = 529,
    CSSPropertyGridArea = 530,
    CSSPropertyGridColumn = 531,
    CSSPropertyGridRow = 532,
    CSSPropertyGridTemplate = 533,
    CSSPropertyInset = 534,
    CSSPropertyInsetBlock = 535,
    CSSPropertyInsetInline = 536,
    CSSPropertyLineClamp = 537,
    CSSPropertyListStyle = 538,
    CSSPropertyMargin = 539,
    CSSPropertyMarginBlock = 540,
    CSSPropertyMarginInline = 541,
    CSSPropertyMarker = 542,
    CSSPropertyMask = 543,
    CSSPropertyMaskBorder = 544,
    CSSPropertyMaskPosition = 545,
    CSSPropertyOffset = 546,
    CSSPropertyOutline = 547,
    CSSPropertyOverflow = 548,
    CSSPropertyOverscrollBehavior = 549,
    CSSPropertyPadding = 550,
    CSSPropertyPaddingBlock = 551,
    CSSPropertyPaddingInline = 552,
    CSSPropertyPageBreakAfter = 553,
    CSSPropertyPageBreakBefore = 554,
    CSSPropertyPageBreakInside = 555,
    CSSPropertyPerspectiveOrigin = 556,
    CSSPropertyPlaceContent = 557,
    CSSPropertyPlaceItems = 558,
    CSSPropertyPlaceSelf = 559,
    CSSPropertyPositionTry = 560,
    CSSPropertyScrollMargin = 561,
    CSSPropertyScrollMarginBlock = 562,
    CSSPropertyScrollMarginInline = 563,
    CSSPropertyScrollPadding = 564,
    CSSPropertyScrollPaddingBlock = 565,
    CSSPropertyScrollPaddingInline = 566,
    CSSPropertyScrollTimeline = 567,
    CSSPropertyTextBox = 568,
    CSSPropertyTextDecoration = 569,
    CSSPropertyTextDecorationSkip = 570,
    CSSPropertyTextEmphasis = 571,
    CSSPropertyTextWrap = 572,
    CSSPropertyTransformOrigin = 573,
    CSSPropertyTransition = 574,
    CSSPropertyViewTimeline = 575,
    CSSPropertyWhiteSpace = 576,
    CSSPropertyWebkitBackgroundSize = 577,
    CSSPropertyWebkitBorderImage = 578,
    CSSPropertyWebkitBorderRadius = 579,
    CSSPropertyWebkitColumnBreakAfter = 580,
    CSSPropertyWebkitColumnBreakBefore = 581,
    CSSPropertyWebkitColumnBreakInside = 582,
    CSSPropertyWebkitMask = 583,
    CSSPropertyWebkitMaskBoxImage = 584,
    CSSPropertyWebkitMaskPosition = 585,
    CSSPropertyWebkitPerspective = 586,
    CSSPropertyWebkitTextOrientation = 587,
    CSSPropertyWebkitTextStroke = 588,
};

// Enum value of the first "real" CSS property, which excludes
// CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t firstCSSProperty = 2;
// Total number of enum values in the CSSPropertyID enum. If making an array
// that can be indexed into using the enum value, use this as the size.
constexpr uint16_t cssPropertyIDEnumValueCount = 589;
// Number of "real" CSS properties. This differs from cssPropertyIDEnumValueCount,
// as this doesn't consider CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t numCSSProperties = 587;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWritingMode;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyDirection;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyTextSpacingTrim;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWordSpacing;
constexpr auto firstLogicalGroupPhysicalProperty = CSSPropertyID::CSSPropertyBorderBottomColor;
constexpr auto lastLogicalGroupPhysicalProperty = CSSPropertyID::CSSPropertyWidth;
constexpr auto firstLogicalGroupLogicalProperty = CSSPropertyID::CSSPropertyBlockSize;
constexpr auto lastLogicalGroupLogicalProperty = CSSPropertyID::CSSPropertyScrollPaddingInlineStart;
constexpr auto firstLogicalGroupProperty = firstLogicalGroupPhysicalProperty;
constexpr auto lastLogicalGroupProperty = lastLogicalGroupLogicalProperty;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;
extern const std::array<CSSPropertyID, 453> computedPropertyIDs;

struct CSSPropertySettings {
    WTF_DEPRECATED_MAKE_STRUCT_FAST_ALLOCATED(CSSPropertySettings);

    bool accentColorEnabled : 1 { false };
    bool colorFilterEnabled : 1 { false };
    bool crossDocumentViewTransitionsEnabled : 1 { false };
    bool cssAnchorPositioningEnabled : 1 { false };
    bool cssCornerShapeEnabled : 1 { false };
    bool cssDPropertyEnabled : 1 { false };
    bool cssFieldSizingEnabled : 1 { false };
    bool cssFontVariantEmojiEnabled : 1 { false };
    bool cssFunctionAtRuleEnabled : 1 { false };
    bool cssInputSecurityEnabled : 1 { false };
    bool cssLineClampEnabled : 1 { false };
    bool cssLineFitEdgeEnabled : 1 { false };
    bool cssRhythmicSizingEnabled : 1 { false };
    bool cssRubyAlignEnabled : 1 { false };
    bool cssRubyOverhangEnabled : 1 { false };
    bool cssScrollAnchoringEnabled : 1 { false };
    bool cssScrollbarColorEnabled : 1 { false };
    bool cssScrollbarGutterEnabled : 1 { false };
    bool cssScrollbarWidthEnabled : 1 { false };
    bool cssTextAutospaceEnabled : 1 { false };
    bool cssTextBoxTrimEnabled : 1 { false };
    bool cssTextGroupAlignEnabled : 1 { false };
    bool cssTextJustifyEnabled : 1 { false };
    bool cssTextSpacingTrimEnabled : 1 { false };
    bool cssUnprefixedBackdropFilterEnabled : 1 { false };
    bool overscrollBehaviorEnabled : 1 { false };
    bool scrollDrivenAnimationsEnabled : 1 { false };
    bool supportHDRDisplayEnabled : 1 { false };
    bool textAutosizingEnabled : 1 { false };
    bool useSystemAppearance : 1 { false };
    bool viewTransitionClassesEnabled : 1 { false };
    bool viewTransitionsEnabled : 1 { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID cascadeAliasProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastLogicalGroupProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty
        && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}
constexpr bool isShorthand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstShorthandProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastShorthandProperty);
}

constexpr bool isLogicalPropertyGroupProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupPhysicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupLogicalProperty);
}

constexpr bool isLogicalPropertyGroupPhysicalProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupPhysicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupPhysicalProperty);
}

constexpr bool isLogicalPropertyGroupLogicalProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupLogicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupLogicalProperty);
}

WTF::TextStream& operator<<(WTF::TextStream&, CSSPropertyID);

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

