// This file was generated by qlalr - DO NOT EDIT!

/**************************************************************************
**
** This file is part of Qt Creator
**
** Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** Commercial Usage
**
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
**
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at http://qt.nokia.com/contact.
**
**************************************************************************/

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

//
// This file is automatically generated from javascript.g.
// Changes will be lost.
//

#ifndef JAVASCRIPTPARSER_P_H
#define JAVASCRIPTPARSER_P_H

#include "javascriptgrammar_p.h"



#include "javascriptastfwd_p.h"
#include <QtCore/QList>

QT_BEGIN_NAMESPACE

class QString;
class JavaScriptEnginePrivate;
class JavaScriptNameIdImpl;

class JavaScriptParser: protected JavaScriptGrammar
{
public:
    union Value {
      int ival;
      double dval;
      JavaScriptNameIdImpl *sval;
      JavaScript::AST::ArgumentList *ArgumentList;
      JavaScript::AST::CaseBlock *CaseBlock;
      JavaScript::AST::CaseClause *CaseClause;
      JavaScript::AST::CaseClauses *CaseClauses;
      JavaScript::AST::Catch *Catch;
      JavaScript::AST::DefaultClause *DefaultClause;
      JavaScript::AST::ElementList *ElementList;
      JavaScript::AST::Elision *Elision;
      JavaScript::AST::ExpressionNode *Expression;
      JavaScript::AST::Finally *Finally;
      JavaScript::AST::FormalParameterList *FormalParameterList;
      JavaScript::AST::FunctionBody *FunctionBody;
      JavaScript::AST::FunctionDeclaration *FunctionDeclaration;
      JavaScript::AST::Node *Node;
      JavaScript::AST::PropertyName *PropertyName;
      JavaScript::AST::PropertyNameAndValueList *PropertyNameAndValueList;
      JavaScript::AST::SourceElement *SourceElement;
      JavaScript::AST::SourceElements *SourceElements;
      JavaScript::AST::Statement *Statement;
      JavaScript::AST::StatementList *StatementList;
      JavaScript::AST::VariableDeclaration *VariableDeclaration;
      JavaScript::AST::VariableDeclarationList *VariableDeclarationList;
    };

    struct Location {
      int startLine;
      int startColumn;
      int endLine;
      int endColumn;
    };

    struct DiagnosticMessage {
        enum Kind { Warning, Error };

        DiagnosticMessage()
            : kind(Error), line(0), column(0) {}

        DiagnosticMessage(Kind kind, int line, int column, const QString &message)
            : kind(kind), line(line), column(column), message(message) {}

        bool isWarning() const
        { return kind == Warning; }

        bool isError() const
        { return kind == Error; }

        Kind kind;
        int line;
        int column;
        QString message;
    };

public:
    JavaScriptParser();
    ~JavaScriptParser();

    bool parse(JavaScriptEnginePrivate *driver);

    QList<DiagnosticMessage> diagnosticMessages() const
    { return diagnostic_messages; }

    inline DiagnosticMessage diagnosticMessage() const
    {
        foreach (const DiagnosticMessage &d, diagnostic_messages) {
            if (! d.kind == DiagnosticMessage::Warning)
                return d;
        }

        return DiagnosticMessage();
    }

    inline QString errorMessage() const
    { return diagnosticMessage().message; }

    inline int errorLineNumber() const
    { return diagnosticMessage().line; }

    inline int errorColumnNumber() const
    { return diagnosticMessage().column; }

protected:
    inline void reallocateStack();

    inline Value &sym(int index)
    { return sym_stack [tos + index - 1]; }

    inline Location &loc(int index)
    { return location_stack [tos + index - 1]; }

protected:
    int tos;
    int stack_size;
    Value *sym_stack;
    int *state_stack;
    Location *location_stack;

    // error recovery
    enum { TOKEN_BUFFER_SIZE = 3 };

    struct SavedToken {
       int token;
       double dval;
       Location loc;
    };

    double yylval;
    Location yylloc;
    Location yyprevlloc;

    SavedToken token_buffer[TOKEN_BUFFER_SIZE];
    SavedToken *first_token;
    SavedToken *last_token;

    QList<DiagnosticMessage> diagnostic_messages;
};

inline void JavaScriptParser::reallocateStack()
{
    if (! stack_size)
        stack_size = 128;
    else
        stack_size <<= 1;

    sym_stack = reinterpret_cast<Value*> (qRealloc(sym_stack, stack_size * sizeof(Value)));
    state_stack = reinterpret_cast<int*> (qRealloc(state_stack, stack_size * sizeof(int)));
    location_stack = reinterpret_cast<Location*> (qRealloc(location_stack, stack_size * sizeof(Location)));
}


#define J_SCRIPT_REGEXPLITERAL_RULE1 7

#define J_SCRIPT_REGEXPLITERAL_RULE2 8

QT_END_NAMESPACE



#endif // JAVASCRIPTPARSER_P_H
