#############################################################################
##
## Copyright (C) 2014 Digia Plc and/or its subsidiary(-ies).
## Contact: http://www.qt-project.org/legal
##
## This file is part of Qt Creator.
##
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and Digia.  For licensing terms and
## conditions see http://qt.digia.com/licensing.  For further information
## use the contact form at http://qt.digia.com/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 2.1 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL included in the
## packaging of this file.  Please review the following information to
## ensure the GNU Lesser General Public License version 2.1 requirements
## will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
##
## In addition, as a special exception, Digia gives you certain additional
## rights.  These rights are described in the Digia Qt LGPL Exception
## version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
##
#############################################################################

source("../../shared/qtcreator.py")
source("../../shared/suites_qtta.py")

gettingStartedText = getQmlItem("Button", ":WelcomePage.scrollView_ScrollView", False,
                                "text='Get Started Now' id='gettingStartedButton'")

def clickItemVerifyHelpCombo(qmlItem, expectedHelpComboRegex, testDetails):
    global gettingStartedText
    mouseClick(waitForObject(qmlItem), 5, 5, 0, Qt.LeftButton)
    helpCombo = waitForObject(":Qt Creator_HelpSelector_QComboBox")
    if not test.verify(waitFor('re.match(expectedHelpComboRegex, str(helpCombo.currentText))',
                               5000), testDetails):
        test.log("Found %s" % str(helpCombo.currentText))
    # select "Welcome" page from left toolbar again
    switchViewTo(ViewConstants.WELCOME)
    test.verify(checkIfObjectExists(gettingStartedText),
                "Verifying: Get Started Now button is being displayed.")

def waitForButtonsState(projectsChecked, examplesChecked, tutorialsChecked, timeout=5000):
    projButton = waitForObject(getQmlItem("Button", ":WelcomePage.scrollView_ScrollView", False,
                                          "text='Projects'"))
    exmpButton = waitForObject(getQmlItem("Button", ":WelcomePage.scrollView_ScrollView", False,
                                          "text='Examples'"))
    tutoButton = waitForObject(getQmlItem("Button", ":WelcomePage.scrollView_ScrollView", False,
                                          "text='Tutorials'"))
    return waitFor('projButton.checked == projectsChecked '
                   'and exmpButton.checked == examplesChecked '
                   'and tutoButton.checked == tutorialsChecked', timeout)

def main():
    if isQt4Build or not canTestEmbeddedQtQuick():
        test.log("Welcome mode is not available or not scriptable with this Squish version")
        return
    global gettingStartedText
    # open Qt Creator
    startApplication("qtcreator" + SettingsPath)
    if not startedWithoutPluginError():
        return

    setAlwaysStartFullHelp()
    addCurrentCreatorDocumentation()

    buttonsAndState = {'Projects':True, 'Examples':False, 'Tutorials':False, 'New Project':False,
                       'Open Project':False}
    for button, state in buttonsAndState.items():
        qmlItem = getQmlItem("Button", ":WelcomePage.scrollView_ScrollView", False,
                             "text='%s'" % button)
        if test.verify(checkIfObjectExists(qmlItem),
                       "Verifying whether '%s' button is shown." % button):
            buttonObj = findObject(qmlItem)
            test.compare(buttonObj.checked, state, "Verifying whether '%s' button is checked."
                         % button)

    test.verify(checkIfObjectExists(gettingStartedText),
                   "Verifying: Qt Creator displays Welcome Page with 'Get Started Now' button.")
    expectedText = "(QtCreator : Qt Creator Manual)|(Qt Creator Manual [|] QtCreator)"
    testDetails = "Verifying: Help with Creator Documentation is being opened."

    clickItemVerifyHelpCombo(gettingStartedText, expectedText, testDetails)
    textUrls = {'Online Community':'http://qt-project.org/forums',
                'Blogs':'http://planet.qt-project.org',
                'Qt Account':'https://login.qt.digia.com/qtaccount',
                'Qt Cloud Services':'https://developer.qtcloudservices.com',
                'User Guide':'qthelp://org.qt-project.qtcreator/doc/index.html'
                }
    for text, url in textUrls.items():
        qmlItem = getQmlItem("LinkedText", ":WelcomePage.scrollView_ScrollView", False,
                             "text='%s'" % text)
        if test.verify(checkIfObjectExists(qmlItem),
                       "Verifying: Link to %s exists." % text):
            itemObj = findObject(qmlItem)
            # some URLs might have varying parameters - limiting them to URL without a query
            if url.startswith("qthelp"):
                relevantUrlPart = str(itemObj.parent.openHelpUrl).split("?")[0]
            else:
                relevantUrlPart = str(itemObj.parent.openUrl).split("?")[0]
            test.compare(relevantUrlPart, url, "Verifying link.")

    mouseClick(gettingStartedText, 5, 5, 0, Qt.LeftButton)
    qcManualQModelIndexStr = getQModelIndexStr("text~='Qt Creator Manual [0-9.]+'",
                                               ":Qt Creator_QHelpContentWidget")
    if str(waitForObject(":Qt Creator_HelpSelector_QComboBox").currentText) == "(Untitled)":
        mouseClick(qcManualQModelIndexStr, 5, 5, 0, Qt.LeftButton)
        test.warning("Clicking 'Get Started Now' the second time showed blank page (Untitled)")

    # select "Welcome" page from left toolbar again
    switchViewTo(ViewConstants.WELCOME)
    test.verify(checkIfObjectExists(gettingStartedText),
                "Verifying: Getting Started topic is being displayed.")
    # select Examples and roughly check them
    mouseClick(waitForObject(getQmlItem("Button", ":WelcomePage.scrollView_ScrollView", False,
                                        "text='Examples'")), 5, 5, 0, Qt.LeftButton)
    waitForButtonsState(False, True, False)
    expect = (("Rectangle", "id='rectangle1' radius='0'", "examples rectangle"),
              ("TextField", "id='lineEdit' placeholderText='Search in Examples...'",
               "examples search line edit"),
              ("ComboBox", "id='comboBox'", "Qt version combo box"),
              ("Delegate", "id='delegate' radius='0' caption~='.*Example'", "at least one example")
              )
    for (qType, prop, info) in expect:
        test.verify(checkIfObjectExists(getQmlItem(qType, ":WelcomePage.scrollView_ScrollView",
                                                   None, prop)),
                    "Verifying whether %s is shown" % info)
    # select Tutorials and roughly check them
    mouseClick(waitForObject(getQmlItem("Button", ":WelcomePage.scrollView_ScrollView", False,
                                        "text='Tutorials'")), 5, 5, 0, Qt.LeftButton)
    waitForButtonsState(False, False, True)
    expect = (("Rectangle", "id='rectangle1' radius='0'", "tutorials rectangle"),
              ("TextField", "id='lineEdit' placeholderText='Search in Tutorials...'",
               "tutorials search line edit"),
              ("Delegate", "id='delegate' radius='0' caption~='Creating.*'", "at least one tutorial")
              )
    for (qType, prop, info) in expect:
        test.verify(checkIfObjectExists(getQmlItem(qType, ":WelcomePage.scrollView_ScrollView",
                                                   None, prop)),
                    "Verifying whether %s is shown" % info)
    # exit Qt Creator
    invokeMenuItem("File", "Exit")
