case RISCVVector::BI__builtin_rvv_vundefined:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

        return llvm::PoisonValue::get(ResultType);
      break;
case RISCVVector::BI__builtin_rvv_vget_v:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        auto *VecTy = cast<ScalableVectorType>(ResultType);
        if (auto *OpVecTy = dyn_cast<ScalableVectorType>(Ops[0]->getType())) {
          unsigned MaxIndex = OpVecTy->getMinNumElements() / VecTy->getMinNumElements();
          assert(isPowerOf2_32(MaxIndex));
          // Mask to only valid indices.
          Ops[1] = Builder.CreateZExt(Ops[1], Builder.getInt64Ty());
          Ops[1] = Builder.CreateAnd(Ops[1], MaxIndex - 1);
          Ops[1] = Builder.CreateMul(Ops[1],
                                     ConstantInt::get(Ops[1]->getType(),
                                                      VecTy->getMinNumElements()));
          return Builder.CreateExtractVector(ResultType, Ops[0], Ops[1]);
        }

        return Builder.CreateIntrinsic(Intrinsic::riscv_tuple_extract,
                                       {ResultType, Ops[0]->getType()},
                                       {Ops[0], Builder.CreateTrunc(Ops[1],
                                        Builder.getInt32Ty())});
      }
      break;
case RISCVVector::BI__builtin_rvv_vset_v:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (auto *ResVecTy = dyn_cast<ScalableVectorType>(ResultType)) {
          auto *VecTy = cast<ScalableVectorType>(Ops[2]->getType());
          unsigned MaxIndex = ResVecTy->getMinNumElements() / VecTy->getMinNumElements();
          assert(isPowerOf2_32(MaxIndex));
          // Mask to only valid indices.
          Ops[1] = Builder.CreateZExt(Ops[1], Builder.getInt64Ty());
          Ops[1] = Builder.CreateAnd(Ops[1], MaxIndex - 1);
          Ops[1] = Builder.CreateMul(Ops[1],
                                     ConstantInt::get(Ops[1]->getType(),
                                                      VecTy->getMinNumElements()));
          return Builder.CreateInsertVector(ResultType, Ops[0], Ops[2], Ops[1]);
        }

        return Builder.CreateIntrinsic(Intrinsic::riscv_tuple_insert,
                                       {ResultType, Ops[2]->getType()},
                                       {Ops[0], Ops[2],
                                        Builder.CreateTrunc(Ops[1],Builder.getInt32Ty())});
      }
      break;
case RISCVVector::BI__builtin_rvv_vcreate_v:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        llvm::Value *ReturnVector = llvm::PoisonValue::get(ResultType);
        auto *VecTy = cast<ScalableVectorType>(Ops[0]->getType());
        for (unsigned I = 0, N = Ops.size(); I < N; ++I) {
          if (isa<ScalableVectorType>(ResultType)) {
            llvm::Value *Idx = ConstantInt::get(Builder.getInt64Ty(),
                                                VecTy->getMinNumElements() * I);
            ReturnVector =
              Builder.CreateInsertVector(ResultType, ReturnVector, Ops[I], Idx);
          } else {
            llvm::Value *Idx = ConstantInt::get(Builder.getInt32Ty(), I);
            ReturnVector =
              Builder.CreateIntrinsic(Intrinsic::riscv_tuple_insert,
                                      {ResultType, Ops[I]->getType()},
                                      {ReturnVector, Ops[I], Idx});
          }

        }
        return ReturnVector;
      }
      break;
case RISCVVector::BI__builtin_rvv_vlenb:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      LLVMContext &Context = CGM.getLLVMContext();
      llvm::MDBuilder MDHelper(Context);

      llvm::Metadata *Ops[] = {llvm::MDString::get(Context, "vlenb")};
      llvm::MDNode *RegName = llvm::MDNode::get(Context, Ops);
      llvm::Value *Metadata = llvm::MetadataAsValue::get(Context, RegName);
      llvm::Function *F =
        CGM.getIntrinsic(llvm::Intrinsic::read_register, {SizeTy});
      return Builder.CreateCall(F, Metadata);
    }
    break;
case RISCVVector::BI__builtin_rvv_vlmul_ext_v:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

        return Builder.CreateInsertVector(ResultType,
                                          llvm::PoisonValue::get(ResultType),
                                          Ops[0], ConstantInt::get(Int64Ty, 0));
      break;
case RISCVVector::BI__builtin_rvv_vlmul_trunc_v:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}
 {
        return Builder.CreateExtractVector(ResultType, Ops[0],
                                           ConstantInt::get(Int64Ty, 0));
      } break;
case RISCVVector::BI__builtin_rvv_vreinterpret_v:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

        if (ResultType->isIntOrIntVectorTy(1) ||
            Ops[0]->getType()->isIntOrIntVectorTy(1)) {
          assert(isa<ScalableVectorType>(ResultType) &&
                 isa<ScalableVectorType>(Ops[0]->getType()));

          LLVMContext &Context = CGM.getLLVMContext();
          ScalableVectorType *Boolean64Ty =
              ScalableVectorType::get(llvm::Type::getInt1Ty(Context), 64);

          if (ResultType->isIntOrIntVectorTy(1)) {
            // Casting from m1 vector integer -> vector boolean
            // Ex: <vscale x 8 x i8>
            //     --(bitcast)--------> <vscale x 64 x i1>
            //     --(vector_extract)-> <vscale x  8 x i1>
            llvm::Value *BitCast = Builder.CreateBitCast(Ops[0], Boolean64Ty);
            return Builder.CreateExtractVector(ResultType, BitCast,
                                               ConstantInt::get(Int64Ty, 0));
          } else {
            // Casting from vector boolean -> m1 vector integer
            // Ex: <vscale x  1 x i1>
            //       --(vector_insert)-> <vscale x 64 x i1>
            //       --(bitcast)-------> <vscale x  8 x i8>
            llvm::Value *Boolean64Val =
              Builder.CreateInsertVector(Boolean64Ty,
                                         llvm::PoisonValue::get(Boolean64Ty),
                                         Ops[0],
                                         ConstantInt::get(Int64Ty, 0));
            return Builder.CreateBitCast(Boolean64Val, ResultType);
          }
        }
        return Builder.CreateBitCast(Ops[0], ResultType);
      break;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

        return llvm::PoisonValue::get(ResultType);
      break;
case RISCVVector::BI__builtin_rvv_vaadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vaadd_vx_tu:
  ID = Intrinsic::riscv_vaadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaadd_vv:
case RISCVVector::BI__builtin_rvv_vaadd_vx:
  ID = Intrinsic::riscv_vaadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vaadd_vx_tum:
  ID = Intrinsic::riscv_vaadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaadd_vv_m:
case RISCVVector::BI__builtin_rvv_vaadd_vx_m:
  ID = Intrinsic::riscv_vaadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vaadd_vx_tumu:
  ID = Intrinsic::riscv_vaadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vaadd_vx_mu:
  ID = Intrinsic::riscv_vaadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv_tu:
case RISCVVector::BI__builtin_rvv_vaaddu_vx_tu:
  ID = Intrinsic::riscv_vaaddu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv:
case RISCVVector::BI__builtin_rvv_vaaddu_vx:
  ID = Intrinsic::riscv_vaaddu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv_tum:
case RISCVVector::BI__builtin_rvv_vaaddu_vx_tum:
  ID = Intrinsic::riscv_vaaddu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv_m:
case RISCVVector::BI__builtin_rvv_vaaddu_vx_m:
  ID = Intrinsic::riscv_vaaddu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vaaddu_vx_tumu:
  ID = Intrinsic::riscv_vaaddu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv_mu:
case RISCVVector::BI__builtin_rvv_vaaddu_vx_mu:
  ID = Intrinsic::riscv_vaaddu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vadc_vvm_tu:
case RISCVVector::BI__builtin_rvv_vadc_vxm_tu:
  ID = Intrinsic::riscv_vadc;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadc_vvm:
case RISCVVector::BI__builtin_rvv_vadc_vxm:
  ID = Intrinsic::riscv_vadc;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vadd_vx_tu:
  ID = Intrinsic::riscv_vadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv:
case RISCVVector::BI__builtin_rvv_vadd_vx:
  ID = Intrinsic::riscv_vadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vadd_vx_tum:
  ID = Intrinsic::riscv_vadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv_m:
case RISCVVector::BI__builtin_rvv_vadd_vx_m:
  ID = Intrinsic::riscv_vadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vadd_vx_tumu:
  ID = Intrinsic::riscv_vadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vadd_vx_mu:
  ID = Intrinsic::riscv_vadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdf_vs_tu:
  ID = Intrinsic::riscv_vaesdf_vs;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdf_vs:
  ID = Intrinsic::riscv_vaesdf_vs;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdf_vv_tu:
  ID = Intrinsic::riscv_vaesdf_vv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdf_vv:
  ID = Intrinsic::riscv_vaesdf_vv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdm_vs_tu:
  ID = Intrinsic::riscv_vaesdm_vs;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdm_vs:
  ID = Intrinsic::riscv_vaesdm_vs;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdm_vv_tu:
  ID = Intrinsic::riscv_vaesdm_vv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdm_vv:
  ID = Intrinsic::riscv_vaesdm_vv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesef_vs_tu:
  ID = Intrinsic::riscv_vaesef_vs;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesef_vs:
  ID = Intrinsic::riscv_vaesef_vs;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesef_vv_tu:
  ID = Intrinsic::riscv_vaesef_vv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesef_vv:
  ID = Intrinsic::riscv_vaesef_vv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesem_vs_tu:
  ID = Intrinsic::riscv_vaesem_vs;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesem_vs:
  ID = Intrinsic::riscv_vaesem_vs;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesem_vv_tu:
  ID = Intrinsic::riscv_vaesem_vv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesem_vv:
  ID = Intrinsic::riscv_vaesem_vv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaeskf1_vi_tu:
  ID = Intrinsic::riscv_vaeskf1;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaeskf1_vi:
  ID = Intrinsic::riscv_vaeskf1;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaeskf2_vi_tu:
  ID = Intrinsic::riscv_vaeskf2;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaeskf2_vi:
  ID = Intrinsic::riscv_vaeskf2;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesz_vs_tu:
  ID = Intrinsic::riscv_vaesz_vs;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesz_vs:
  ID = Intrinsic::riscv_vaesz_vs;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv_tu:
case RISCVVector::BI__builtin_rvv_vand_vx_tu:
  ID = Intrinsic::riscv_vand;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv:
case RISCVVector::BI__builtin_rvv_vand_vx:
  ID = Intrinsic::riscv_vand;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv_tum:
case RISCVVector::BI__builtin_rvv_vand_vx_tum:
  ID = Intrinsic::riscv_vand_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv_m:
case RISCVVector::BI__builtin_rvv_vand_vx_m:
  ID = Intrinsic::riscv_vand_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv_tumu:
case RISCVVector::BI__builtin_rvv_vand_vx_tumu:
  ID = Intrinsic::riscv_vand_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv_mu:
case RISCVVector::BI__builtin_rvv_vand_vx_mu:
  ID = Intrinsic::riscv_vand_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vandn_vv_tu:
case RISCVVector::BI__builtin_rvv_vandn_vx_tu:
  ID = Intrinsic::riscv_vandn;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vandn_vv:
case RISCVVector::BI__builtin_rvv_vandn_vx:
  ID = Intrinsic::riscv_vandn;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vandn_vv_tum:
case RISCVVector::BI__builtin_rvv_vandn_vx_tum:
  ID = Intrinsic::riscv_vandn_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vandn_vv_m:
case RISCVVector::BI__builtin_rvv_vandn_vx_m:
  ID = Intrinsic::riscv_vandn_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vandn_vv_tumu:
case RISCVVector::BI__builtin_rvv_vandn_vx_tumu:
  ID = Intrinsic::riscv_vandn_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vandn_vv_mu:
case RISCVVector::BI__builtin_rvv_vandn_vx_mu:
  ID = Intrinsic::riscv_vandn_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vasub_vv_tu:
case RISCVVector::BI__builtin_rvv_vasub_vx_tu:
  ID = Intrinsic::riscv_vasub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasub_vv:
case RISCVVector::BI__builtin_rvv_vasub_vx:
  ID = Intrinsic::riscv_vasub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasub_vv_tum:
case RISCVVector::BI__builtin_rvv_vasub_vx_tum:
  ID = Intrinsic::riscv_vasub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasub_vv_m:
case RISCVVector::BI__builtin_rvv_vasub_vx_m:
  ID = Intrinsic::riscv_vasub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vasub_vx_tumu:
  ID = Intrinsic::riscv_vasub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasub_vv_mu:
case RISCVVector::BI__builtin_rvv_vasub_vx_mu:
  ID = Intrinsic::riscv_vasub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv_tu:
case RISCVVector::BI__builtin_rvv_vasubu_vx_tu:
  ID = Intrinsic::riscv_vasubu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv:
case RISCVVector::BI__builtin_rvv_vasubu_vx:
  ID = Intrinsic::riscv_vasubu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv_tum:
case RISCVVector::BI__builtin_rvv_vasubu_vx_tum:
  ID = Intrinsic::riscv_vasubu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv_m:
case RISCVVector::BI__builtin_rvv_vasubu_vx_m:
  ID = Intrinsic::riscv_vasubu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vasubu_vx_tumu:
  ID = Intrinsic::riscv_vasubu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv_mu:
case RISCVVector::BI__builtin_rvv_vasubu_vx_mu:
  ID = Intrinsic::riscv_vasubu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vbrev_v_tu:
  ID = Intrinsic::riscv_vbrev;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev_v:
  ID = Intrinsic::riscv_vbrev;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev8_v_tu:
  ID = Intrinsic::riscv_vbrev8;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev8_v:
  ID = Intrinsic::riscv_vbrev8;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev8_v_tum:
  ID = Intrinsic::riscv_vbrev8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev8_v_m:
  ID = Intrinsic::riscv_vbrev8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev8_v_tumu:
  ID = Intrinsic::riscv_vbrev8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev8_v_mu:
  ID = Intrinsic::riscv_vbrev8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev_v_tum:
  ID = Intrinsic::riscv_vbrev_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev_v_m:
  ID = Intrinsic::riscv_vbrev_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev_v_tumu:
  ID = Intrinsic::riscv_vbrev_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev_v_mu:
  ID = Intrinsic::riscv_vbrev_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmul_vv_tu:
case RISCVVector::BI__builtin_rvv_vclmul_vx_tu:
  ID = Intrinsic::riscv_vclmul;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmul_vv:
case RISCVVector::BI__builtin_rvv_vclmul_vx:
  ID = Intrinsic::riscv_vclmul;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmul_vv_tum:
case RISCVVector::BI__builtin_rvv_vclmul_vx_tum:
  ID = Intrinsic::riscv_vclmul_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmul_vv_m:
case RISCVVector::BI__builtin_rvv_vclmul_vx_m:
  ID = Intrinsic::riscv_vclmul_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmul_vv_tumu:
case RISCVVector::BI__builtin_rvv_vclmul_vx_tumu:
  ID = Intrinsic::riscv_vclmul_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmul_vv_mu:
case RISCVVector::BI__builtin_rvv_vclmul_vx_mu:
  ID = Intrinsic::riscv_vclmul_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmulh_vv_tu:
case RISCVVector::BI__builtin_rvv_vclmulh_vx_tu:
  ID = Intrinsic::riscv_vclmulh;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmulh_vv:
case RISCVVector::BI__builtin_rvv_vclmulh_vx:
  ID = Intrinsic::riscv_vclmulh;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmulh_vv_tum:
case RISCVVector::BI__builtin_rvv_vclmulh_vx_tum:
  ID = Intrinsic::riscv_vclmulh_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmulh_vv_m:
case RISCVVector::BI__builtin_rvv_vclmulh_vx_m:
  ID = Intrinsic::riscv_vclmulh_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmulh_vv_tumu:
case RISCVVector::BI__builtin_rvv_vclmulh_vx_tumu:
  ID = Intrinsic::riscv_vclmulh_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmulh_vv_mu:
case RISCVVector::BI__builtin_rvv_vclmulh_vx_mu:
  ID = Intrinsic::riscv_vclmulh_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclz_v_tu:
  ID = Intrinsic::riscv_vclz;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclz_v:
  ID = Intrinsic::riscv_vclz;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclz_v_tum:
  ID = Intrinsic::riscv_vclz_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclz_v_m:
  ID = Intrinsic::riscv_vclz_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclz_v_tumu:
  ID = Intrinsic::riscv_vclz_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclz_v_mu:
  ID = Intrinsic::riscv_vclz_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcompress_vm_tu:
  ID = Intrinsic::riscv_vcompress;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vcompress_vm:
  ID = Intrinsic::riscv_vcompress;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vcpop_m:
  ID = Intrinsic::riscv_vcpop;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcpop_m_m:
  ID = Intrinsic::riscv_vcpop_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[0]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcpop_v_tu:
  ID = Intrinsic::riscv_vcpopv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcpop_v:
  ID = Intrinsic::riscv_vcpopv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcpop_v_tum:
  ID = Intrinsic::riscv_vcpopv_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcpop_v_m:
  ID = Intrinsic::riscv_vcpopv_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcpop_v_tumu:
  ID = Intrinsic::riscv_vcpopv_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcpop_v_mu:
  ID = Intrinsic::riscv_vcpopv_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vctz_v_tu:
  ID = Intrinsic::riscv_vctz;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vctz_v:
  ID = Intrinsic::riscv_vctz;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vctz_v_tum:
  ID = Intrinsic::riscv_vctz_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vctz_v_m:
  ID = Intrinsic::riscv_vctz_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vctz_v_tumu:
  ID = Intrinsic::riscv_vctz_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vctz_v_mu:
  ID = Intrinsic::riscv_vctz_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv_tu:
case RISCVVector::BI__builtin_rvv_vdiv_vx_tu:
  ID = Intrinsic::riscv_vdiv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv:
case RISCVVector::BI__builtin_rvv_vdiv_vx:
  ID = Intrinsic::riscv_vdiv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv_tum:
case RISCVVector::BI__builtin_rvv_vdiv_vx_tum:
  ID = Intrinsic::riscv_vdiv_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv_m:
case RISCVVector::BI__builtin_rvv_vdiv_vx_m:
  ID = Intrinsic::riscv_vdiv_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv_tumu:
case RISCVVector::BI__builtin_rvv_vdiv_vx_tumu:
  ID = Intrinsic::riscv_vdiv_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv_mu:
case RISCVVector::BI__builtin_rvv_vdiv_vx_mu:
  ID = Intrinsic::riscv_vdiv_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv_tu:
case RISCVVector::BI__builtin_rvv_vdivu_vx_tu:
  ID = Intrinsic::riscv_vdivu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv:
case RISCVVector::BI__builtin_rvv_vdivu_vx:
  ID = Intrinsic::riscv_vdivu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv_tum:
case RISCVVector::BI__builtin_rvv_vdivu_vx_tum:
  ID = Intrinsic::riscv_vdivu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv_m:
case RISCVVector::BI__builtin_rvv_vdivu_vx_m:
  ID = Intrinsic::riscv_vdivu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vdivu_vx_tumu:
  ID = Intrinsic::riscv_vdivu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv_mu:
case RISCVVector::BI__builtin_rvv_vdivu_vx_mu:
  ID = Intrinsic::riscv_vdivu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_tu:
  ID = Intrinsic::riscv_vfadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm:
case RISCVVector::BI__builtin_rvv_vfadd_vv:
case RISCVVector::BI__builtin_rvv_vfadd_vf:
  ID = Intrinsic::riscv_vfadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vfadd_vf_tum:
  ID = Intrinsic::riscv_vfadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfadd_vv_m:
case RISCVVector::BI__builtin_rvv_vfadd_vf_m:
  ID = Intrinsic::riscv_vfadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_tumu:
  ID = Intrinsic::riscv_vfadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_mu:
  ID = Intrinsic::riscv_vfadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfclass_v_tu:
  ID = Intrinsic::riscv_vfclass;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfclass_v:
  ID = Intrinsic::riscv_vfclass;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfclass_v_tum:
  ID = Intrinsic::riscv_vfclass_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfclass_v_m:
  ID = Intrinsic::riscv_vfclass_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfclass_v_tumu:
  ID = Intrinsic::riscv_vfclass_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfclass_v_mu:
  ID = Intrinsic::riscv_vfclass_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_tu:
  ID = Intrinsic::riscv_vfcvt_f_x_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v:
  ID = Intrinsic::riscv_vfcvt_f_x_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_tum:
  ID = Intrinsic::riscv_vfcvt_f_x_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_m:
  ID = Intrinsic::riscv_vfcvt_f_x_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_tumu:
  ID = Intrinsic::riscv_vfcvt_f_x_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_mu:
  ID = Intrinsic::riscv_vfcvt_f_x_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_tu:
  ID = Intrinsic::riscv_vfcvt_f_xu_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v:
  ID = Intrinsic::riscv_vfcvt_f_xu_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_tum:
  ID = Intrinsic::riscv_vfcvt_f_xu_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_m:
  ID = Intrinsic::riscv_vfcvt_f_xu_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_tumu:
  ID = Intrinsic::riscv_vfcvt_f_xu_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_mu:
  ID = Intrinsic::riscv_vfcvt_f_xu_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v_tu:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v_tum:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v_m:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v_tumu:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v_mu:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v_tu:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v_tum:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v_m:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v_tumu:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v_mu:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_tu:
  ID = Intrinsic::riscv_vfcvt_x_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v:
  ID = Intrinsic::riscv_vfcvt_x_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_tum:
  ID = Intrinsic::riscv_vfcvt_x_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_m:
  ID = Intrinsic::riscv_vfcvt_x_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_tumu:
  ID = Intrinsic::riscv_vfcvt_x_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_mu:
  ID = Intrinsic::riscv_vfcvt_x_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_tu:
  ID = Intrinsic::riscv_vfcvt_xu_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v:
  ID = Intrinsic::riscv_vfcvt_xu_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_tum:
  ID = Intrinsic::riscv_vfcvt_xu_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_m:
  ID = Intrinsic::riscv_vfcvt_xu_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_tumu:
  ID = Intrinsic::riscv_vfcvt_xu_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_mu:
  ID = Intrinsic::riscv_vfcvt_xu_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfdiv_vv_tu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_tu:
  ID = Intrinsic::riscv_vfdiv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm:
case RISCVVector::BI__builtin_rvv_vfdiv_vv:
case RISCVVector::BI__builtin_rvv_vfdiv_vf:
  ID = Intrinsic::riscv_vfdiv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfdiv_vv_tum:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_tum:
  ID = Intrinsic::riscv_vfdiv_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfdiv_vv_m:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_m:
  ID = Intrinsic::riscv_vfdiv_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfdiv_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_tumu:
  ID = Intrinsic::riscv_vfdiv_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfdiv_vv_mu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_mu:
  ID = Intrinsic::riscv_vfdiv_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfirst_m:
  ID = Intrinsic::riscv_vfirst;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfirst_m_m:
  ID = Intrinsic::riscv_vfirst_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[0]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmacc_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_tu:
  ID = Intrinsic::riscv_vfmacc;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm:
case RISCVVector::BI__builtin_rvv_vfmacc_vv:
case RISCVVector::BI__builtin_rvv_vfmacc_vf:
  ID = Intrinsic::riscv_vfmacc;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmacc_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_tum:
  ID = Intrinsic::riscv_vfmacc_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfmacc_vv_m:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_m:
  ID = Intrinsic::riscv_vfmacc_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmacc_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_tumu:
  ID = Intrinsic::riscv_vfmacc_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmacc_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_mu:
  ID = Intrinsic::riscv_vfmacc_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_tu:
  ID = Intrinsic::riscv_vfmadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm:
case RISCVVector::BI__builtin_rvv_vfmadd_vv:
case RISCVVector::BI__builtin_rvv_vfmadd_vf:
  ID = Intrinsic::riscv_vfmadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_tum:
  ID = Intrinsic::riscv_vfmadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfmadd_vv_m:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_m:
  ID = Intrinsic::riscv_vfmadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_tumu:
  ID = Intrinsic::riscv_vfmadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_mu:
  ID = Intrinsic::riscv_vfmadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmax_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmax_vf_tu:
  ID = Intrinsic::riscv_vfmax;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmax_vv:
case RISCVVector::BI__builtin_rvv_vfmax_vf:
  ID = Intrinsic::riscv_vfmax;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmax_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmax_vf_tum:
  ID = Intrinsic::riscv_vfmax_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmax_vv_m:
case RISCVVector::BI__builtin_rvv_vfmax_vf_m:
  ID = Intrinsic::riscv_vfmax_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmax_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmax_vf_tumu:
  ID = Intrinsic::riscv_vfmax_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmax_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmax_vf_mu:
  ID = Intrinsic::riscv_vfmax_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmerge_vfm_tu:
  ID = Intrinsic::riscv_vfmerge;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vfmerge_vfm:
  ID = Intrinsic::riscv_vfmerge;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vfmin_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmin_vf_tu:
  ID = Intrinsic::riscv_vfmin;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmin_vv:
case RISCVVector::BI__builtin_rvv_vfmin_vf:
  ID = Intrinsic::riscv_vfmin;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmin_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmin_vf_tum:
  ID = Intrinsic::riscv_vfmin_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmin_vv_m:
case RISCVVector::BI__builtin_rvv_vfmin_vf_m:
  ID = Intrinsic::riscv_vfmin_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmin_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmin_vf_tumu:
  ID = Intrinsic::riscv_vfmin_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmin_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmin_vf_mu:
  ID = Intrinsic::riscv_vfmin_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmsac_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_tu:
  ID = Intrinsic::riscv_vfmsac;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm:
case RISCVVector::BI__builtin_rvv_vfmsac_vv:
case RISCVVector::BI__builtin_rvv_vfmsac_vf:
  ID = Intrinsic::riscv_vfmsac;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmsac_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_tum:
  ID = Intrinsic::riscv_vfmsac_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfmsac_vv_m:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_m:
  ID = Intrinsic::riscv_vfmsac_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmsac_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_tumu:
  ID = Intrinsic::riscv_vfmsac_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmsac_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_mu:
  ID = Intrinsic::riscv_vfmsac_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_tu:
  ID = Intrinsic::riscv_vfmsub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm:
case RISCVVector::BI__builtin_rvv_vfmsub_vv:
case RISCVVector::BI__builtin_rvv_vfmsub_vf:
  ID = Intrinsic::riscv_vfmsub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_tum:
  ID = Intrinsic::riscv_vfmsub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfmsub_vv_m:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_m:
  ID = Intrinsic::riscv_vfmsub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_tumu:
  ID = Intrinsic::riscv_vfmsub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_mu:
  ID = Intrinsic::riscv_vfmsub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmul_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_tu:
  ID = Intrinsic::riscv_vfmul;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm:
case RISCVVector::BI__builtin_rvv_vfmul_vv:
case RISCVVector::BI__builtin_rvv_vfmul_vf:
  ID = Intrinsic::riscv_vfmul;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmul_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmul_vf_tum:
  ID = Intrinsic::riscv_vfmul_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfmul_vv_m:
case RISCVVector::BI__builtin_rvv_vfmul_vf_m:
  ID = Intrinsic::riscv_vfmul_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmul_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_tumu:
  ID = Intrinsic::riscv_vfmul_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmul_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_mu:
  ID = Intrinsic::riscv_vfmul_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmv_f_s:
  ID = Intrinsic::riscv_vfmv_f_s;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmv_s_f_tu:
case RISCVVector::BI__builtin_rvv_vfmv_s_x_tu:
  ID = Intrinsic::riscv_vfmv_s_f;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmv_s_f:
case RISCVVector::BI__builtin_rvv_vfmv_s_x:
  ID = Intrinsic::riscv_vfmv_s_f;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmv_v_f_tu:
  ID = Intrinsic::riscv_vfmv_v_f;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmv_v_f:
  ID = Intrinsic::riscv_vfmv_v_f;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_f_f_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w:
  ID = Intrinsic::riscv_vfncvt_f_f_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_f_f_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_m:
  ID = Intrinsic::riscv_vfncvt_f_f_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_f_f_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_f_f_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_tu:
  ID = Intrinsic::riscv_vfncvt_f_x_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w:
  ID = Intrinsic::riscv_vfncvt_f_x_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_tum:
  ID = Intrinsic::riscv_vfncvt_f_x_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_m:
  ID = Intrinsic::riscv_vfncvt_f_x_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_tumu:
  ID = Intrinsic::riscv_vfncvt_f_x_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_mu:
  ID = Intrinsic::riscv_vfncvt_f_x_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_tu:
  ID = Intrinsic::riscv_vfncvt_f_xu_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w:
  ID = Intrinsic::riscv_vfncvt_f_xu_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_tum:
  ID = Intrinsic::riscv_vfncvt_f_xu_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_m:
  ID = Intrinsic::riscv_vfncvt_f_xu_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_tumu:
  ID = Intrinsic::riscv_vfncvt_f_xu_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_mu:
  ID = Intrinsic::riscv_vfncvt_f_xu_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w_m:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w_m:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w_m:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_x_f_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w:
  ID = Intrinsic::riscv_vfncvt_x_f_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_x_f_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_m:
  ID = Intrinsic::riscv_vfncvt_x_f_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_x_f_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_x_f_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_xu_f_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w:
  ID = Intrinsic::riscv_vfncvt_xu_f_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_xu_f_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_m:
  ID = Intrinsic::riscv_vfncvt_xu_f_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_xu_f_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_xu_f_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_tu:
  ID = Intrinsic::riscv_vfncvtbf16_f_f_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w:
  ID = Intrinsic::riscv_vfncvtbf16_f_f_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_tum:
  ID = Intrinsic::riscv_vfncvtbf16_f_f_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_m:
  ID = Intrinsic::riscv_vfncvtbf16_f_f_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_tumu:
  ID = Intrinsic::riscv_vfncvtbf16_f_f_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_mu:
  ID = Intrinsic::riscv_vfncvtbf16_f_f_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_tu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_tu:
  ID = Intrinsic::riscv_vfnmacc;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf:
  ID = Intrinsic::riscv_vfnmacc;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_tum:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_tum:
  ID = Intrinsic::riscv_vfnmacc_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_m:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_m:
  ID = Intrinsic::riscv_vfnmacc_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_tumu:
  ID = Intrinsic::riscv_vfnmacc_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_mu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_mu:
  ID = Intrinsic::riscv_vfnmacc_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_tu:
  ID = Intrinsic::riscv_vfnmadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf:
  ID = Intrinsic::riscv_vfnmadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_tum:
  ID = Intrinsic::riscv_vfnmadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_m:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_m:
  ID = Intrinsic::riscv_vfnmadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_tumu:
  ID = Intrinsic::riscv_vfnmadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_mu:
  ID = Intrinsic::riscv_vfnmadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_tu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_tu:
  ID = Intrinsic::riscv_vfnmsac;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf:
  ID = Intrinsic::riscv_vfnmsac;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_tum:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_tum:
  ID = Intrinsic::riscv_vfnmsac_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_m:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_m:
  ID = Intrinsic::riscv_vfnmsac_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_tumu:
  ID = Intrinsic::riscv_vfnmsac_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_mu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_mu:
  ID = Intrinsic::riscv_vfnmsac_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_tu:
  ID = Intrinsic::riscv_vfnmsub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf:
  ID = Intrinsic::riscv_vfnmsub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_tum:
  ID = Intrinsic::riscv_vfnmsub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_m:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_m:
  ID = Intrinsic::riscv_vfnmsub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_tumu:
  ID = Intrinsic::riscv_vfnmsub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_mu:
  ID = Intrinsic::riscv_vfnmsub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_tu:
  ID = Intrinsic::riscv_vfrdiv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf:
  ID = Intrinsic::riscv_vfrdiv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_tum:
  ID = Intrinsic::riscv_vfrdiv_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_m:
  ID = Intrinsic::riscv_vfrdiv_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_tumu:
  ID = Intrinsic::riscv_vfrdiv_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_mu:
  ID = Intrinsic::riscv_vfrdiv_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfrec7_v_tu:
  ID = Intrinsic::riscv_vfrec7;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm:
case RISCVVector::BI__builtin_rvv_vfrec7_v:
  ID = Intrinsic::riscv_vfrec7;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfrec7_v_tum:
  ID = Intrinsic::riscv_vfrec7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfrec7_v_m:
  ID = Intrinsic::riscv_vfrec7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfrec7_v_tumu:
  ID = Intrinsic::riscv_vfrec7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfrec7_v_mu:
  ID = Intrinsic::riscv_vfrec7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredmax_vs_tu:
  ID = Intrinsic::riscv_vfredmax;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmax_vs:
  ID = Intrinsic::riscv_vfredmax;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmax_vs_tum:
  ID = Intrinsic::riscv_vfredmax_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmax_vs_m:
  ID = Intrinsic::riscv_vfredmax_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmin_vs_tu:
  ID = Intrinsic::riscv_vfredmin;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmin_vs:
  ID = Intrinsic::riscv_vfredmin;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmin_vs_tum:
  ID = Intrinsic::riscv_vfredmin_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmin_vs_m:
  ID = Intrinsic::riscv_vfredmin_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredosum_vs_rm_tu:
case RISCVVector::BI__builtin_rvv_vfredosum_vs_tu:
  ID = Intrinsic::riscv_vfredosum;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredosum_vs_rm:
case RISCVVector::BI__builtin_rvv_vfredosum_vs:
  ID = Intrinsic::riscv_vfredosum;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredosum_vs_rm_tum:
case RISCVVector::BI__builtin_rvv_vfredosum_vs_tum:
  ID = Intrinsic::riscv_vfredosum_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredosum_vs_rm_m:
case RISCVVector::BI__builtin_rvv_vfredosum_vs_m:
  ID = Intrinsic::riscv_vfredosum_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredusum_vs_rm_tu:
case RISCVVector::BI__builtin_rvv_vfredusum_vs_tu:
  ID = Intrinsic::riscv_vfredusum;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredusum_vs_rm:
case RISCVVector::BI__builtin_rvv_vfredusum_vs:
  ID = Intrinsic::riscv_vfredusum;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredusum_vs_rm_tum:
case RISCVVector::BI__builtin_rvv_vfredusum_vs_tum:
  ID = Intrinsic::riscv_vfredusum_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredusum_vs_rm_m:
case RISCVVector::BI__builtin_rvv_vfredusum_vs_m:
  ID = Intrinsic::riscv_vfredusum_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v_tu:
  ID = Intrinsic::riscv_vfrsqrt7;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v:
  ID = Intrinsic::riscv_vfrsqrt7;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v_tum:
  ID = Intrinsic::riscv_vfrsqrt7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v_m:
  ID = Intrinsic::riscv_vfrsqrt7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v_tumu:
  ID = Intrinsic::riscv_vfrsqrt7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v_mu:
  ID = Intrinsic::riscv_vfrsqrt7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfrsub_vf_tu:
  ID = Intrinsic::riscv_vfrsub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm:
case RISCVVector::BI__builtin_rvv_vfrsub_vf:
  ID = Intrinsic::riscv_vfrsub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfrsub_vf_tum:
  ID = Intrinsic::riscv_vfrsub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfrsub_vf_m:
  ID = Intrinsic::riscv_vfrsub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfrsub_vf_tumu:
  ID = Intrinsic::riscv_vfrsub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfrsub_vf_mu:
  ID = Intrinsic::riscv_vfrsub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv_tu:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf_tu:
  ID = Intrinsic::riscv_vfsgnj;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf:
  ID = Intrinsic::riscv_vfsgnj;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv_tum:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf_tum:
  ID = Intrinsic::riscv_vfsgnj_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv_m:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf_m:
  ID = Intrinsic::riscv_vfsgnj_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf_tumu:
  ID = Intrinsic::riscv_vfsgnj_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv_mu:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf_mu:
  ID = Intrinsic::riscv_vfsgnj_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfneg_v_tu:
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv_tu:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf_tu:
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfneg_v:
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf:
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfneg_v_tum:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv_tum:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf_tum:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfneg_v_m:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv_m:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf_m:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfneg_v_tumu:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf_tumu:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfneg_v_mu:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv_mu:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf_mu:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv_tu:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf_tu:
  ID = Intrinsic::riscv_vfsgnjx;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v_tu:
  ID = Intrinsic::riscv_vfsgnjx;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf:
  ID = Intrinsic::riscv_vfsgnjx;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v:
  ID = Intrinsic::riscv_vfsgnjx;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv_tum:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf_tum:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v_tum:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv_m:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf_m:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v_m:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf_tumu:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v_tumu:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv_mu:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf_mu:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v_mu:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf_tu:
  ID = Intrinsic::riscv_vfslide1down;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf:
  ID = Intrinsic::riscv_vfslide1down;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf_tum:
  ID = Intrinsic::riscv_vfslide1down_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf_m:
  ID = Intrinsic::riscv_vfslide1down_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf_tumu:
  ID = Intrinsic::riscv_vfslide1down_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf_mu:
  ID = Intrinsic::riscv_vfslide1down_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf_tu:
  ID = Intrinsic::riscv_vfslide1up;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf:
  ID = Intrinsic::riscv_vfslide1up;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf_tum:
  ID = Intrinsic::riscv_vfslide1up_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf_m:
  ID = Intrinsic::riscv_vfslide1up_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf_tumu:
  ID = Intrinsic::riscv_vfslide1up_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf_mu:
  ID = Intrinsic::riscv_vfslide1up_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfsqrt_v_tu:
  ID = Intrinsic::riscv_vfsqrt;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm:
case RISCVVector::BI__builtin_rvv_vfsqrt_v:
  ID = Intrinsic::riscv_vfsqrt;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfsqrt_v_tum:
  ID = Intrinsic::riscv_vfsqrt_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfsqrt_v_m:
  ID = Intrinsic::riscv_vfsqrt_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfsqrt_v_tumu:
  ID = Intrinsic::riscv_vfsqrt_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfsqrt_v_mu:
  ID = Intrinsic::riscv_vfsqrt_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_tu:
  ID = Intrinsic::riscv_vfsub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm:
case RISCVVector::BI__builtin_rvv_vfsub_vv:
case RISCVVector::BI__builtin_rvv_vfsub_vf:
  ID = Intrinsic::riscv_vfsub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vfsub_vf_tum:
  ID = Intrinsic::riscv_vfsub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfsub_vv_m:
case RISCVVector::BI__builtin_rvv_vfsub_vf_m:
  ID = Intrinsic::riscv_vfsub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_tumu:
  ID = Intrinsic::riscv_vfsub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_mu:
  ID = Intrinsic::riscv_vfsub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_tu:
  ID = Intrinsic::riscv_vfwadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwadd_vv:
case RISCVVector::BI__builtin_rvv_vfwadd_vf:
  ID = Intrinsic::riscv_vfwadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_tum:
  ID = Intrinsic::riscv_vfwadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwadd_vv_m:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_m:
  ID = Intrinsic::riscv_vfwadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_tumu:
  ID = Intrinsic::riscv_vfwadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_mu:
  ID = Intrinsic::riscv_vfwadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_wv_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_tu:
  ID = Intrinsic::riscv_vfwadd_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm:
case RISCVVector::BI__builtin_rvv_vfwadd_wv:
case RISCVVector::BI__builtin_rvv_vfwadd_wf:
  ID = Intrinsic::riscv_vfwadd_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_wv_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_tum:
  ID = Intrinsic::riscv_vfwadd_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwadd_wv_m:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_m:
  ID = Intrinsic::riscv_vfwadd_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_wv_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_tumu:
  ID = Intrinsic::riscv_vfwadd_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_wv_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_mu:
  ID = Intrinsic::riscv_vfwadd_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v_tu:
  ID = Intrinsic::riscv_vfwcvt_f_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v:
  ID = Intrinsic::riscv_vfwcvt_f_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v_tum:
  ID = Intrinsic::riscv_vfwcvt_f_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v_m:
  ID = Intrinsic::riscv_vfwcvt_f_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_f_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v_mu:
  ID = Intrinsic::riscv_vfwcvt_f_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v_tu:
  ID = Intrinsic::riscv_vfwcvt_f_x_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v:
  ID = Intrinsic::riscv_vfwcvt_f_x_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v_tum:
  ID = Intrinsic::riscv_vfwcvt_f_x_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v_m:
  ID = Intrinsic::riscv_vfwcvt_f_x_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_f_x_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v_mu:
  ID = Intrinsic::riscv_vfwcvt_f_x_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v_tu:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v_tum:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v_m:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v_mu:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v_tu:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v_tum:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v_m:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v_mu:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v_tu:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v_tum:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v_m:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v_mu:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_tu:
  ID = Intrinsic::riscv_vfwcvt_x_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v:
  ID = Intrinsic::riscv_vfwcvt_x_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_tum:
  ID = Intrinsic::riscv_vfwcvt_x_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_m:
  ID = Intrinsic::riscv_vfwcvt_x_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_x_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_mu:
  ID = Intrinsic::riscv_vfwcvt_x_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_tu:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_tum:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_m:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_mu:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvtbf16_f_f_v_tu:
  ID = Intrinsic::riscv_vfwcvtbf16_f_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvtbf16_f_f_v:
  ID = Intrinsic::riscv_vfwcvtbf16_f_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvtbf16_f_f_v_tum:
  ID = Intrinsic::riscv_vfwcvtbf16_f_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvtbf16_f_f_v_m:
  ID = Intrinsic::riscv_vfwcvtbf16_f_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvtbf16_f_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvtbf16_f_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvtbf16_f_f_v_mu:
  ID = Intrinsic::riscv_vfwcvtbf16_f_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_tu:
  ID = Intrinsic::riscv_vfwmacc;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf:
  ID = Intrinsic::riscv_vfwmacc;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_tum:
  ID = Intrinsic::riscv_vfwmacc_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_m:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_m:
  ID = Intrinsic::riscv_vfwmacc_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_tumu:
  ID = Intrinsic::riscv_vfwmacc_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_mu:
  ID = Intrinsic::riscv_vfwmacc_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_tu:
  ID = Intrinsic::riscv_vfwmaccbf16;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf:
  ID = Intrinsic::riscv_vfwmaccbf16;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_tum:
  ID = Intrinsic::riscv_vfwmaccbf16_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_m:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_m:
  ID = Intrinsic::riscv_vfwmaccbf16_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_tumu:
  ID = Intrinsic::riscv_vfwmaccbf16_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_mu:
  ID = Intrinsic::riscv_vfwmaccbf16_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_tu:
  ID = Intrinsic::riscv_vfwmsac;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf:
  ID = Intrinsic::riscv_vfwmsac;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_tum:
  ID = Intrinsic::riscv_vfwmsac_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_m:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_m:
  ID = Intrinsic::riscv_vfwmsac_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_tumu:
  ID = Intrinsic::riscv_vfwmsac_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_mu:
  ID = Intrinsic::riscv_vfwmsac_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmul_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_tu:
  ID = Intrinsic::riscv_vfwmul;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwmul_vv:
case RISCVVector::BI__builtin_rvv_vfwmul_vf:
  ID = Intrinsic::riscv_vfwmul;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmul_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_tum:
  ID = Intrinsic::riscv_vfwmul_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmul_vv_m:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_m:
  ID = Intrinsic::riscv_vfwmul_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmul_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_tumu:
  ID = Intrinsic::riscv_vfwmul_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmul_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_mu:
  ID = Intrinsic::riscv_vfwmul_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_tu:
  ID = Intrinsic::riscv_vfwnmacc;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf:
  ID = Intrinsic::riscv_vfwnmacc;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_tum:
  ID = Intrinsic::riscv_vfwnmacc_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_m:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_m:
  ID = Intrinsic::riscv_vfwnmacc_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_tumu:
  ID = Intrinsic::riscv_vfwnmacc_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_mu:
  ID = Intrinsic::riscv_vfwnmacc_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_tu:
  ID = Intrinsic::riscv_vfwnmsac;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf:
  ID = Intrinsic::riscv_vfwnmsac;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_tum:
  ID = Intrinsic::riscv_vfwnmsac_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_m:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_m:
  ID = Intrinsic::riscv_vfwnmsac_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_tumu:
  ID = Intrinsic::riscv_vfwnmsac_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_mu:
  ID = Intrinsic::riscv_vfwnmsac_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_tu:
  ID = Intrinsic::riscv_vfwredosum;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_rm:
case RISCVVector::BI__builtin_rvv_vfwredosum_vs:
  ID = Intrinsic::riscv_vfwredosum;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_tum:
  ID = Intrinsic::riscv_vfwredosum_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_rm_m:
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_m:
  ID = Intrinsic::riscv_vfwredosum_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_tu:
  ID = Intrinsic::riscv_vfwredusum;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_rm:
case RISCVVector::BI__builtin_rvv_vfwredusum_vs:
  ID = Intrinsic::riscv_vfwredusum;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_tum:
  ID = Intrinsic::riscv_vfwredusum_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_rm_m:
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_m:
  ID = Intrinsic::riscv_vfwredusum_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 6> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_tu:
  ID = Intrinsic::riscv_vfwsub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwsub_vv:
case RISCVVector::BI__builtin_rvv_vfwsub_vf:
  ID = Intrinsic::riscv_vfwsub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_tum:
  ID = Intrinsic::riscv_vfwsub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwsub_vv_m:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_m:
  ID = Intrinsic::riscv_vfwsub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_tumu:
  ID = Intrinsic::riscv_vfwsub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_mu:
  ID = Intrinsic::riscv_vfwsub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_wv_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_tu:
  ID = Intrinsic::riscv_vfwsub_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm:
case RISCVVector::BI__builtin_rvv_vfwsub_wv:
case RISCVVector::BI__builtin_rvv_vfwsub_wf:
  ID = Intrinsic::riscv_vfwsub_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_wv_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_tum:
  ID = Intrinsic::riscv_vfwsub_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwsub_wv_m:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_m:
  ID = Intrinsic::riscv_vfwsub_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_wv_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_tumu:
  ID = Intrinsic::riscv_vfwsub_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_wv_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_mu:
  ID = Intrinsic::riscv_vfwsub_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vghsh_vv_tu:
  ID = Intrinsic::riscv_vghsh;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vghsh_vv:
  ID = Intrinsic::riscv_vghsh;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vgmul_vv_tu:
  ID = Intrinsic::riscv_vgmul_vv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vgmul_vv:
  ID = Intrinsic::riscv_vgmul_vv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v_tu:
  ID = Intrinsic::riscv_vid;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v:
  ID = Intrinsic::riscv_vid;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v_tum:
  ID = Intrinsic::riscv_vid_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v_m:
  ID = Intrinsic::riscv_vid_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v_tumu:
  ID = Intrinsic::riscv_vid_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v_mu:
  ID = Intrinsic::riscv_vid_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m_tu:
  ID = Intrinsic::riscv_viota;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m:
  ID = Intrinsic::riscv_viota;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m_tum:
  ID = Intrinsic::riscv_viota_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m_m:
  ID = Intrinsic::riscv_viota_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m_tumu:
  ID = Intrinsic::riscv_viota_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m_mu:
  ID = Intrinsic::riscv_viota_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v_tu:
case RISCVVector::BI__builtin_rvv_vle16_v_tu:
case RISCVVector::BI__builtin_rvv_vle32_v_tu:
case RISCVVector::BI__builtin_rvv_vle64_v_tu:
  ID = Intrinsic::riscv_vle;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v:
case RISCVVector::BI__builtin_rvv_vle16_v:
case RISCVVector::BI__builtin_rvv_vle32_v:
case RISCVVector::BI__builtin_rvv_vle64_v:
  ID = Intrinsic::riscv_vle;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v_tum:
case RISCVVector::BI__builtin_rvv_vle16_v_tum:
case RISCVVector::BI__builtin_rvv_vle32_v_tum:
case RISCVVector::BI__builtin_rvv_vle64_v_tum:
  ID = Intrinsic::riscv_vle_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v_m:
case RISCVVector::BI__builtin_rvv_vle16_v_m:
case RISCVVector::BI__builtin_rvv_vle32_v_m:
case RISCVVector::BI__builtin_rvv_vle64_v_m:
  ID = Intrinsic::riscv_vle_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v_tumu:
case RISCVVector::BI__builtin_rvv_vle16_v_tumu:
case RISCVVector::BI__builtin_rvv_vle32_v_tumu:
case RISCVVector::BI__builtin_rvv_vle64_v_tumu:
  ID = Intrinsic::riscv_vle_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v_mu:
case RISCVVector::BI__builtin_rvv_vle16_v_mu:
case RISCVVector::BI__builtin_rvv_vle32_v_mu:
case RISCVVector::BI__builtin_rvv_vle64_v_mu:
  ID = Intrinsic::riscv_vle_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8ff_v_tu:
case RISCVVector::BI__builtin_rvv_vle16ff_v_tu:
case RISCVVector::BI__builtin_rvv_vle32ff_v_tu:
case RISCVVector::BI__builtin_rvv_vle64ff_v_tu:
  ID = Intrinsic::riscv_vleff;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          // Move mask to right before vl.
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          IntrinsicTypes = {ResultType, Ops[4]->getType(), Ops[2]->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          IntrinsicTypes = {ResultType, Ops[3]->getType(), Ops[1]->getType()};
        }
        Value *NewVL = Ops[2];
        Ops.erase(Ops.begin() + 2);
        llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
        llvm::Value *LoadValue = Builder.CreateCall(F, Ops, "");
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {0});
        // Store new_vl.
        clang::CharUnits Align;
        if (IsMasked)
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(E->getNumArgs()-2)->getType());
        else
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(1)->getType());
        llvm::Value *Val = Builder.CreateExtractValue(LoadValue, {1});
        Builder.CreateStore(Val, Address(NewVL, Val->getType(), Align));
        return V;
      }
      break;
case RISCVVector::BI__builtin_rvv_vle8ff_v:
case RISCVVector::BI__builtin_rvv_vle16ff_v:
case RISCVVector::BI__builtin_rvv_vle32ff_v:
case RISCVVector::BI__builtin_rvv_vle64ff_v:
  ID = Intrinsic::riscv_vleff;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          // Move mask to right before vl.
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          IntrinsicTypes = {ResultType, Ops[4]->getType(), Ops[2]->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          IntrinsicTypes = {ResultType, Ops[3]->getType(), Ops[1]->getType()};
        }
        Value *NewVL = Ops[2];
        Ops.erase(Ops.begin() + 2);
        llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
        llvm::Value *LoadValue = Builder.CreateCall(F, Ops, "");
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {0});
        // Store new_vl.
        clang::CharUnits Align;
        if (IsMasked)
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(E->getNumArgs()-2)->getType());
        else
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(1)->getType());
        llvm::Value *Val = Builder.CreateExtractValue(LoadValue, {1});
        Builder.CreateStore(Val, Address(NewVL, Val->getType(), Align));
        return V;
      }
      break;
case RISCVVector::BI__builtin_rvv_vle8ff_v_tum:
case RISCVVector::BI__builtin_rvv_vle16ff_v_tum:
case RISCVVector::BI__builtin_rvv_vle32ff_v_tum:
case RISCVVector::BI__builtin_rvv_vle64ff_v_tum:
  ID = Intrinsic::riscv_vleff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          // Move mask to right before vl.
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          IntrinsicTypes = {ResultType, Ops[4]->getType(), Ops[2]->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          IntrinsicTypes = {ResultType, Ops[3]->getType(), Ops[1]->getType()};
        }
        Value *NewVL = Ops[2];
        Ops.erase(Ops.begin() + 2);
        llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
        llvm::Value *LoadValue = Builder.CreateCall(F, Ops, "");
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {0});
        // Store new_vl.
        clang::CharUnits Align;
        if (IsMasked)
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(E->getNumArgs()-2)->getType());
        else
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(1)->getType());
        llvm::Value *Val = Builder.CreateExtractValue(LoadValue, {1});
        Builder.CreateStore(Val, Address(NewVL, Val->getType(), Align));
        return V;
      }
      break;
case RISCVVector::BI__builtin_rvv_vle8ff_v_m:
case RISCVVector::BI__builtin_rvv_vle16ff_v_m:
case RISCVVector::BI__builtin_rvv_vle32ff_v_m:
case RISCVVector::BI__builtin_rvv_vle64ff_v_m:
  ID = Intrinsic::riscv_vleff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          // Move mask to right before vl.
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          IntrinsicTypes = {ResultType, Ops[4]->getType(), Ops[2]->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          IntrinsicTypes = {ResultType, Ops[3]->getType(), Ops[1]->getType()};
        }
        Value *NewVL = Ops[2];
        Ops.erase(Ops.begin() + 2);
        llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
        llvm::Value *LoadValue = Builder.CreateCall(F, Ops, "");
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {0});
        // Store new_vl.
        clang::CharUnits Align;
        if (IsMasked)
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(E->getNumArgs()-2)->getType());
        else
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(1)->getType());
        llvm::Value *Val = Builder.CreateExtractValue(LoadValue, {1});
        Builder.CreateStore(Val, Address(NewVL, Val->getType(), Align));
        return V;
      }
      break;
case RISCVVector::BI__builtin_rvv_vle8ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vle16ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vle32ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vle64ff_v_tumu:
  ID = Intrinsic::riscv_vleff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          // Move mask to right before vl.
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          IntrinsicTypes = {ResultType, Ops[4]->getType(), Ops[2]->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          IntrinsicTypes = {ResultType, Ops[3]->getType(), Ops[1]->getType()};
        }
        Value *NewVL = Ops[2];
        Ops.erase(Ops.begin() + 2);
        llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
        llvm::Value *LoadValue = Builder.CreateCall(F, Ops, "");
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {0});
        // Store new_vl.
        clang::CharUnits Align;
        if (IsMasked)
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(E->getNumArgs()-2)->getType());
        else
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(1)->getType());
        llvm::Value *Val = Builder.CreateExtractValue(LoadValue, {1});
        Builder.CreateStore(Val, Address(NewVL, Val->getType(), Align));
        return V;
      }
      break;
case RISCVVector::BI__builtin_rvv_vle8ff_v_mu:
case RISCVVector::BI__builtin_rvv_vle16ff_v_mu:
case RISCVVector::BI__builtin_rvv_vle32ff_v_mu:
case RISCVVector::BI__builtin_rvv_vle64ff_v_mu:
  ID = Intrinsic::riscv_vleff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

      {
        if (IsMasked) {
          // Move mask to right before vl.
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          IntrinsicTypes = {ResultType, Ops[4]->getType(), Ops[2]->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          IntrinsicTypes = {ResultType, Ops[3]->getType(), Ops[1]->getType()};
        }
        Value *NewVL = Ops[2];
        Ops.erase(Ops.begin() + 2);
        llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
        llvm::Value *LoadValue = Builder.CreateCall(F, Ops, "");
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {0});
        // Store new_vl.
        clang::CharUnits Align;
        if (IsMasked)
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(E->getNumArgs()-2)->getType());
        else
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(1)->getType());
        llvm::Value *Val = Builder.CreateExtractValue(LoadValue, {1});
        Builder.CreateStore(Val, Address(NewVL, Val->getType(), Align));
        return V;
      }
      break;
case RISCVVector::BI__builtin_rvv_vlm_v:
  ID = Intrinsic::riscv_vlm;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[0]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxei64_v_tu:
  ID = Intrinsic::riscv_vloxei;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v:
case RISCVVector::BI__builtin_rvv_vloxei16_v:
case RISCVVector::BI__builtin_rvv_vloxei32_v:
case RISCVVector::BI__builtin_rvv_vloxei64_v:
  ID = Intrinsic::riscv_vloxei;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxei64_v_tum:
  ID = Intrinsic::riscv_vloxei_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxei64_v_m:
  ID = Intrinsic::riscv_vloxei_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxei64_v_tumu:
  ID = Intrinsic::riscv_vloxei_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxei64_v_mu:
  ID = Intrinsic::riscv_vloxei_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg2;
  PolicyAttrs = 2;
  SegInstSEW = 4294967295;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(1      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v:
  ID = Intrinsic::riscv_vloxseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4294967295;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(0      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v_m:
  ID = Intrinsic::riscv_vloxseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(1      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg3;
  PolicyAttrs = 2;
  SegInstSEW = 4294967295;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(1      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v:
  ID = Intrinsic::riscv_vloxseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4294967295;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(0      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v_m:
  ID = Intrinsic::riscv_vloxseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(1      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg4;
  PolicyAttrs = 2;
  SegInstSEW = 4294967295;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(1      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v:
  ID = Intrinsic::riscv_vloxseg4;
  PolicyAttrs = 3;
  SegInstSEW = 4294967295;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(0      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v_m:
  ID = Intrinsic::riscv_vloxseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(1      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg5;
  PolicyAttrs = 2;
  SegInstSEW = 4294967295;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(1      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v:
  ID = Intrinsic::riscv_vloxseg5;
  PolicyAttrs = 3;
  SegInstSEW = 4294967295;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(0      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v_m:
  ID = Intrinsic::riscv_vloxseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(1      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg6;
  PolicyAttrs = 2;
  SegInstSEW = 4294967295;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(1      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v:
  ID = Intrinsic::riscv_vloxseg6;
  PolicyAttrs = 3;
  SegInstSEW = 4294967295;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(0      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v_m:
  ID = Intrinsic::riscv_vloxseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(1      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg7;
  PolicyAttrs = 2;
  SegInstSEW = 4294967295;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(1      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v:
  ID = Intrinsic::riscv_vloxseg7;
  PolicyAttrs = 3;
  SegInstSEW = 4294967295;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(0      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v_m:
  ID = Intrinsic::riscv_vloxseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(1      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg8;
  PolicyAttrs = 2;
  SegInstSEW = 4294967295;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(1      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v:
  ID = Intrinsic::riscv_vloxseg8;
  PolicyAttrs = 3;
  SegInstSEW = 4294967295;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(0      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v_m:
  ID = Intrinsic::riscv_vloxseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(1      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4294967295;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(2      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 7> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops[0]->getType(),
                          Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                          Ops[Offset + 1]->getType(),
                          Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlse8_v_tu:
case RISCVVector::BI__builtin_rvv_vlse16_v_tu:
case RISCVVector::BI__builtin_rvv_vlse32_v_tu:
case RISCVVector::BI__builtin_rvv_vlse64_v_tu:
  ID = Intrinsic::riscv_vlse;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlse8_v:
case RISCVVector::BI__builtin_rvv_vlse16_v:
case RISCVVector::BI__builtin_rvv_vlse32_v:
case RISCVVector::BI__builtin_rvv_vlse64_v:
  ID = Intrinsic::riscv_vlse;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlse8_v_tum:
case RISCVVector::BI__builtin_rvv_vlse16_v_tum:
case RISCVVector::BI__builtin_rvv_vlse32_v_tum:
case RISCVVector::BI__builtin_rvv_vlse64_v_tum:
  ID = Intrinsic::riscv_vlse_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlse8_v_m:
case RISCVVector::BI__builtin_rvv_vlse16_v_m:
case RISCVVector::BI__builtin_rvv_vlse32_v_m:
case RISCVVector::BI__builtin_rvv_vlse64_v_m:
  ID = Intrinsic::riscv_vlse_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlse8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlse16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlse32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlse64_v_tumu:
  ID = Intrinsic::riscv_vlse_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlse8_v_mu:
case RISCVVector::BI__builtin_rvv_vlse16_v_mu:
case RISCVVector::BI__builtin_rvv_vlse32_v_mu:
case RISCVVector::BI__builtin_rvv_vlse64_v_mu:
  ID = Intrinsic::riscv_vlse_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v_tu:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16_v_tu:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32_v_tu:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64_v_tu:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16_v:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32_v:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64_v:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v_tum:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16_v_tum:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32_v_tum:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64_v_tum:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v_m:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16_v_m:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32_v_m:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64_v_m:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v_tumu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16_v_tumu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32_v_tumu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64_v_tumu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v_mu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16_v_mu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32_v_mu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64_v_mu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v_tu:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v_tu:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v_tu:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v_tum:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v_tum:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v_tum:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v_tum:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v_m:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v_m:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v_m:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v_m:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v_tumu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v_tumu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v_tumu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v_tumu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v_mu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v_mu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v_mu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v_mu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v_tu:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e16_v_tu:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e32_v_tu:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e64_v_tu:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e16_v:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e32_v:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e64_v:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v_tum:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e16_v_tum:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e32_v_tum:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e64_v_tum:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v_m:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e16_v_m:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e32_v_m:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e64_v_m:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v_tumu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e16_v_tumu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e32_v_tumu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e64_v_tumu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v_mu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e16_v_mu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e32_v_mu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e64_v_mu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[0]->getType(), Ops.back()->getType()};
      else
        IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops.back()->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8ff_v_tu:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e16ff_v_tu:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e32ff_v_tu:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8ff_v:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e16ff_v:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e32ff_v:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e64ff_v:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8ff_v_tum:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e16ff_v_tum:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType()->getPointeeType();
  SegInstSEW =       llvm::Log2_64(getContext().getTypeSize(PointeeType));
}

    {
      SmallVector<llvm::Value*, 6> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (IsMasked)
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType(), Ops[0]->getType()};
      else
        IntrinsicTypes = {ResultType, Ops.back()->getType(), Ops[Offset]->getType()};

      if (NoPassthru) { // Push poison into passthru
        Operands.push_back(llvm::PoisonValue::get(ResultType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        Operands.push_back(PassthruOperand);
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), SegInstSEW));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = Builder.CreateExtractValue(LoadValue, 0);

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, 1);
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e32ff_v_tum:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;
if (SegInstSEW == (unsigned)-1) {
  auto PointeeType = E->getArg(4294967295      )->getType