/*
 * Operation Parameters Test
 *
 * This specification is intended for testing purposes. It demonstrates a wide range of content types for requestBody. The goal is to verify correct url for each case.
 *
 * API version: 1.0.0
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package openapi

import (
	"net/http"

	"github.com/gin-gonic/gin"
)

// Route is the information for every URI.
type Route struct {
	// Name is the name of this Route.
	Name string
	// Method is the string for the HTTP method. ex) GET, POST etc..
	Method string
	// Pattern is the pattern of the URI.
	Pattern string
	// HandlerFunc is the handler function of this route.
	HandlerFunc gin.HandlerFunc
}

// NewRouter returns a new router.
func NewRouter(handleFunctions ApiHandleFunctions) *gin.Engine {
	return NewRouterWithGinEngine(gin.Default(), handleFunctions)
}

// NewRouter add routes to existing gin engine.
func NewRouterWithGinEngine(router *gin.Engine, handleFunctions ApiHandleFunctions) *gin.Engine {
	for _, route := range getRoutes(handleFunctions) {
		if route.HandlerFunc == nil {
			route.HandlerFunc = DefaultHandleFunc
		}
		switch route.Method {
		case http.MethodGet:
			router.GET(route.Pattern, route.HandlerFunc)
		case http.MethodPost:
			router.POST(route.Pattern, route.HandlerFunc)
		case http.MethodPut:
			router.PUT(route.Pattern, route.HandlerFunc)
		case http.MethodPatch:
			router.PATCH(route.Pattern, route.HandlerFunc)
		case http.MethodDelete:
			router.DELETE(route.Pattern, route.HandlerFunc)
		}
	}

	return router
}

// Default handler for not yet implemented routes
func DefaultHandleFunc(c *gin.Context) {
	c.String(http.StatusNotImplemented, "501 not implemented")
}

type ApiHandleFunctions struct {

	// Routes for the TestAPI part of the API
	TestAPI TestAPI
}

func getRoutes(handleFunctions ApiHandleFunctions) []Route {
	return []Route{
		{
			"BinaryType",
			http.MethodPost,
			"/v2/reqBody/octetstream/binaryType",
			handleFunctions.TestAPI.BinaryType,
		},
		{
			"PostApplicationJsonArray",
			http.MethodPost,
			"/v2/reqBody/appjson/array/postApplicationJsonArray",
			handleFunctions.TestAPI.PostApplicationJsonArray,
		},
		{
			"PostApplicationJsonBool",
			http.MethodPost,
			"/v2/reqBody/appjson/bool/postApplicationJsonBool",
			handleFunctions.TestAPI.PostApplicationJsonBool,
		},
		{
			"PostApplicationJsonInt",
			http.MethodPost,
			"/v2/reqBody/appjson/integer/postApplicationJsonInt",
			handleFunctions.TestAPI.PostApplicationJsonInt,
		},
		{
			"PostApplicationJsonMap",
			http.MethodPost,
			"/v2/reqBody/appjson/object/postApplicationJsonMap",
			handleFunctions.TestAPI.PostApplicationJsonMap,
		},
		{
			"PostApplicationJsonObject",
			http.MethodPost,
			"/v2/reqBody/appjson/object/postApplicationJsonObject",
			handleFunctions.TestAPI.PostApplicationJsonObject,
		},
		{
			"PostApplicationJsonSeveralObjects",
			http.MethodPost,
			"/v2/reqBody/appjson/object/postApplicationJsonSeveralObjects",
			handleFunctions.TestAPI.PostApplicationJsonSeveralObjects,
		},
		{
			"PostApplicationJsonString",
			http.MethodPost,
			"/v2/reqBody/appjson/string/postApplicationJsonString",
			handleFunctions.TestAPI.PostApplicationJsonString,
		},
		{
			"PostMultiPartData",
			http.MethodPost,
			"/v2/reqBody/multipart/postMultiPartData",
			handleFunctions.TestAPI.PostMultiPartData,
		},
		{
			"PostPlainTextType",
			http.MethodPost,
			"/v2/reqBody/string/postPlainTextType",
			handleFunctions.TestAPI.PostPlainTextType,
		},
		{
			"PostUrlEncodedFields",
			http.MethodPost,
			"/v2/reqBody/urlencoded/postUrlEncodedFields",
			handleFunctions.TestAPI.PostUrlEncodedFields,
		},
		{
			"PostUrlEncodedNestedObject",
			http.MethodPost,
			"/v2/reqBody/urlencoded/postUrlEncodedNestedObject",
			handleFunctions.TestAPI.PostUrlEncodedNestedObject,
		},
		{
			"PostUrlEncodedObject",
			http.MethodPost,
			"/v2/reqBody/urlencoded/postUrlEncodedObject",
			handleFunctions.TestAPI.PostUrlEncodedObject,
		},
	}
}
