#############################################################################
##
## Copyright (C) 2018 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the simplified signatures for all functions in PySide
for module 'exists_redhatenterpriselinuxworkstation74_5_12_0_ci'. There are no default values, no variable
names and no self parameter. Only types are present after simplification.
The functions 'next' resp. '__next__' are removed to make the output
identical for Python 2 and 3. '__div__' is also removed,
since it exists in Python 2, only.
"""

import sys

dict = {}

# Module PySide2.QtCore
if "PySide2.QtCore" in sys.modules:
    dict.update({
        "QT_TRANSLATE_NOOP": ('object', 'object'),
        "QT_TRANSLATE_NOOP3": ('object', 'object', 'object'),
        "QT_TRANSLATE_NOOP_UTF8": ('object',),
        "QT_TR_NOOP": ('object',),
        "QT_TR_NOOP_UTF8": ('object',),
        "SIGNAL": ('str',),
        "SLOT": ('str',),
        "__moduleShutdown": (),
        "qAbs": ('float',),
        "qAcos": ('float',),
        "qAddPostRoutine": ('object',),
        "qAsin": ('float',),
        "qAtan": ('float',),
        "qAtan2": ('float', 'float'),
        "qChecksum": ('str', 'int'),
        "qCompress": [('PySide2.QtCore.QByteArray', 'int'), ('typing.Union[str, int]', 'int', 'int')],
        "qCritical": ('str',),
        "qDebug": ('str',),
        "qExp": ('float',),
        "qFabs": ('float',),
        "qFastCos": ('float',),
        "qFastSin": ('float',),
        "qFatal": ('str',),
        "qFuzzyCompare": ('float', 'float'),
        "qFuzzyIsNull": ('float',),
        "qInstallMessageHandler": ('object',),
        "qIsFinite": ('float',),
        "qIsInf": ('float',),
        "qIsNaN": ('float',),
        "qIsNull": ('float',),
        "qRegisterResourceData": ('int', 'str', 'str', 'str'),
        "qTan": ('float',),
        "qUncompress": [('PySide2.QtCore.QByteArray',), ('typing.Union[str, int]', 'int')],
        "qUnregisterResourceData": ('int', 'str', 'str', 'str'),
        "qVersion": (),
        "qWarning": ('str',),
        "qrand": (),
        "qsrand": ('int',),
        "qtTrId": ('str', 'int'),

    # class PySide2.QtCore.QAbstractAnimation:
        "QAbstractAnimation.__init__": ('PySide2.QtCore.QObject',),
        "QAbstractAnimation.currentLoop": (),
        "QAbstractAnimation.currentLoopTime": (),
        "QAbstractAnimation.currentTime": (),
        "QAbstractAnimation.direction": (),
        "QAbstractAnimation.duration": (),
        "QAbstractAnimation.event": ('PySide2.QtCore.QEvent',),
        "QAbstractAnimation.group": (),
        "QAbstractAnimation.loopCount": (),
        "QAbstractAnimation.pause": (),
        "QAbstractAnimation.resume": (),
        "QAbstractAnimation.setCurrentTime": ('int',),
        "QAbstractAnimation.setDirection": ('PySide2.QtCore.QAbstractAnimation.Direction',),
        "QAbstractAnimation.setLoopCount": ('int',),
        "QAbstractAnimation.setPaused": ('bool',),
        "QAbstractAnimation.start": ('PySide2.QtCore.QAbstractAnimation.DeletionPolicy',),
        "QAbstractAnimation.state": (),
        "QAbstractAnimation.stop": (),
        "QAbstractAnimation.totalDuration": (),
        "QAbstractAnimation.updateCurrentTime": ('int',),
        "QAbstractAnimation.updateDirection": ('PySide2.QtCore.QAbstractAnimation.Direction',),
        "QAbstractAnimation.updateState": ('PySide2.QtCore.QAbstractAnimation.State', 'PySide2.QtCore.QAbstractAnimation.State'),

    # class PySide2.QtCore.QAbstractEventDispatcher:
        "QAbstractEventDispatcher.__init__": ('PySide2.QtCore.QObject',),
        "QAbstractEventDispatcher.closingDown": (),
        "QAbstractEventDispatcher.filterNativeEvent": ('PySide2.QtCore.QByteArray', 'int', 'int'),
        "QAbstractEventDispatcher.flush": (),
        "QAbstractEventDispatcher.hasPendingEvents": (),
        "QAbstractEventDispatcher.installNativeEventFilter": ('PySide2.QtCore.QAbstractNativeEventFilter',),
        "QAbstractEventDispatcher.instance": ('PySide2.QtCore.QThread',),
        "QAbstractEventDispatcher.interrupt": (),
        "QAbstractEventDispatcher.processEvents": ('PySide2.QtCore.QEventLoop.ProcessEventsFlags',),
        "QAbstractEventDispatcher.registerSocketNotifier": ('PySide2.QtCore.QSocketNotifier',),
        "QAbstractEventDispatcher.registerTimer": [('int', 'PySide2.QtCore.Qt.TimerType', 'PySide2.QtCore.QObject'), ('int', 'int', 'PySide2.QtCore.Qt.TimerType', 'PySide2.QtCore.QObject')],
        "QAbstractEventDispatcher.registeredTimers": ('PySide2.QtCore.QObject',),
        "QAbstractEventDispatcher.remainingTime": ('int',),
        "QAbstractEventDispatcher.removeNativeEventFilter": ('PySide2.QtCore.QAbstractNativeEventFilter',),
        "QAbstractEventDispatcher.startingUp": (),
        "QAbstractEventDispatcher.unregisterSocketNotifier": ('PySide2.QtCore.QSocketNotifier',),
        "QAbstractEventDispatcher.unregisterTimer": ('int',),
        "QAbstractEventDispatcher.unregisterTimers": ('PySide2.QtCore.QObject',),
        "QAbstractEventDispatcher.wakeUp": (),

    # class PySide2.QtCore.QAbstractEventDispatcher.TimerInfo:
        "QAbstractEventDispatcher.TimerInfo.__init__": ('int', 'int', 'PySide2.QtCore.Qt.TimerType'),

    # class PySide2.QtCore.QAbstractItemModel:
        "QAbstractItemModel.__init__": ('PySide2.QtCore.QObject',),
        "QAbstractItemModel.beginInsertColumns": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QAbstractItemModel.beginInsertRows": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QAbstractItemModel.beginMoveColumns": ('PySide2.QtCore.QModelIndex', 'int', 'int', 'PySide2.QtCore.QModelIndex', 'int'),
        "QAbstractItemModel.beginMoveRows": ('PySide2.QtCore.QModelIndex', 'int', 'int', 'PySide2.QtCore.QModelIndex', 'int'),
        "QAbstractItemModel.beginRemoveColumns": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QAbstractItemModel.beginRemoveRows": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QAbstractItemModel.beginResetModel": (),
        "QAbstractItemModel.buddy": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemModel.canDropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemModel.canFetchMore": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemModel.changePersistentIndex": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemModel.changePersistentIndexList": ('typing.List[int]', 'typing.List[int]'),
        "QAbstractItemModel.checkIndex": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QAbstractItemModel.CheckIndexOptions'),
        "QAbstractItemModel.columnCount": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemModel.createIndex": [('int', 'int', 'int'), ('int', 'int', 'object')],
        "QAbstractItemModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
        "QAbstractItemModel.decodeData": ('int', 'int', 'PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QDataStream'),
        "QAbstractItemModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemModel.encodeData": ('typing.List[int]', 'PySide2.QtCore.QDataStream'),
        "QAbstractItemModel.endInsertColumns": (),
        "QAbstractItemModel.endInsertRows": (),
        "QAbstractItemModel.endMoveColumns": (),
        "QAbstractItemModel.endMoveRows": (),
        "QAbstractItemModel.endRemoveColumns": (),
        "QAbstractItemModel.endRemoveRows": (),
        "QAbstractItemModel.endResetModel": (),
        "QAbstractItemModel.fetchMore": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemModel.flags": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemModel.hasIndex": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
        "QAbstractItemModel.index": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemModel.insertColumn": ('int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemModel.insertColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemModel.insertRow": ('int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemModel.insertRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemModel.itemData": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemModel.match": ('PySide2.QtCore.QModelIndex', 'int', 'typing.Any', 'int', 'PySide2.QtCore.Qt.MatchFlags'),
        "QAbstractItemModel.mimeData": ('typing.List[int]',),
        "QAbstractItemModel.mimeTypes": (),
        "QAbstractItemModel.moveColumn": ('PySide2.QtCore.QModelIndex', 'int', 'PySide2.QtCore.QModelIndex', 'int'),
        "QAbstractItemModel.moveColumns": ('PySide2.QtCore.QModelIndex', 'int', 'int', 'PySide2.QtCore.QModelIndex', 'int'),
        "QAbstractItemModel.moveRow": ('PySide2.QtCore.QModelIndex', 'int', 'PySide2.QtCore.QModelIndex', 'int'),
        "QAbstractItemModel.moveRows": ('PySide2.QtCore.QModelIndex', 'int', 'int', 'PySide2.QtCore.QModelIndex', 'int'),
        "QAbstractItemModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
        "QAbstractItemModel.persistentIndexList": (),
        "QAbstractItemModel.removeColumn": ('int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemModel.removeColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemModel.removeRow": ('int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemModel.removeRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemModel.resetInternalData": (),
        "QAbstractItemModel.revert": (),
        "QAbstractItemModel.roleNames": (),
        "QAbstractItemModel.rowCount": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
        "QAbstractItemModel.setHeaderData": ('int', 'PySide2.QtCore.Qt.Orientation', 'typing.Any', 'int'),
        "QAbstractItemModel.setItemData": ('PySide2.QtCore.QModelIndex', 'dict'),
        "QAbstractItemModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
        "QAbstractItemModel.span": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemModel.submit": (),
        "QAbstractItemModel.supportedDragActions": (),
        "QAbstractItemModel.supportedDropActions": (),

    # class PySide2.QtCore.QAbstractListModel:
        "QAbstractListModel.__init__": ('PySide2.QtCore.QObject',),
        "QAbstractListModel.columnCount": ('PySide2.QtCore.QModelIndex',),
        "QAbstractListModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractListModel.flags": ('PySide2.QtCore.QModelIndex',),
        "QAbstractListModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
        "QAbstractListModel.index": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractListModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
        "QAbstractListModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),

    # class PySide2.QtCore.QAbstractNativeEventFilter:
        "QAbstractNativeEventFilter.__init__": (),
        "QAbstractNativeEventFilter.nativeEventFilter": ('PySide2.QtCore.QByteArray', 'int', 'int'),

    # class PySide2.QtCore.QAbstractProxyModel:
        "QAbstractProxyModel.__init__": ('PySide2.QtCore.QObject',),
        "QAbstractProxyModel.buddy": ('PySide2.QtCore.QModelIndex',),
        "QAbstractProxyModel.canDropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractProxyModel.canFetchMore": ('PySide2.QtCore.QModelIndex',),
        "QAbstractProxyModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
        "QAbstractProxyModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractProxyModel.fetchMore": ('PySide2.QtCore.QModelIndex',),
        "QAbstractProxyModel.flags": ('PySide2.QtCore.QModelIndex',),
        "QAbstractProxyModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
        "QAbstractProxyModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
        "QAbstractProxyModel.itemData": ('PySide2.QtCore.QModelIndex',),
        "QAbstractProxyModel.mapFromSource": ('PySide2.QtCore.QModelIndex',),
        "QAbstractProxyModel.mapSelectionFromSource": ('PySide2.QtCore.QItemSelection',),
        "QAbstractProxyModel.mapSelectionToSource": ('PySide2.QtCore.QItemSelection',),
        "QAbstractProxyModel.mapToSource": ('PySide2.QtCore.QModelIndex',),
        "QAbstractProxyModel.mimeData": ('typing.List[int]',),
        "QAbstractProxyModel.mimeTypes": (),
        "QAbstractProxyModel.resetInternalData": (),
        "QAbstractProxyModel.revert": (),
        "QAbstractProxyModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
        "QAbstractProxyModel.setHeaderData": ('int', 'PySide2.QtCore.Qt.Orientation', 'typing.Any', 'int'),
        "QAbstractProxyModel.setItemData": ('PySide2.QtCore.QModelIndex', 'dict'),
        "QAbstractProxyModel.setSourceModel": ('PySide2.QtCore.QAbstractItemModel',),
        "QAbstractProxyModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractProxyModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
        "QAbstractProxyModel.sourceModel": (),
        "QAbstractProxyModel.span": ('PySide2.QtCore.QModelIndex',),
        "QAbstractProxyModel.submit": (),
        "QAbstractProxyModel.supportedDragActions": (),
        "QAbstractProxyModel.supportedDropActions": (),

    # class PySide2.QtCore.QAbstractState:
        "QAbstractState.__init__": ('PySide2.QtCore.QState',),
        "QAbstractState.active": (),
        "QAbstractState.event": ('PySide2.QtCore.QEvent',),
        "QAbstractState.machine": (),
        "QAbstractState.onEntry": ('PySide2.QtCore.QEvent',),
        "QAbstractState.onExit": ('PySide2.QtCore.QEvent',),
        "QAbstractState.parentState": (),

    # class PySide2.QtCore.QAbstractTableModel:
        "QAbstractTableModel.__init__": ('PySide2.QtCore.QObject',),
        "QAbstractTableModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractTableModel.flags": ('PySide2.QtCore.QModelIndex',),
        "QAbstractTableModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
        "QAbstractTableModel.index": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QAbstractTableModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
        "QAbstractTableModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),

    # class PySide2.QtCore.QAbstractTransition:
        "QAbstractTransition.__init__": ('PySide2.QtCore.QState',),
        "QAbstractTransition.addAnimation": ('PySide2.QtCore.QAbstractAnimation',),
        "QAbstractTransition.animations": (),
        "QAbstractTransition.event": ('PySide2.QtCore.QEvent',),
        "QAbstractTransition.eventTest": ('PySide2.QtCore.QEvent',),
        "QAbstractTransition.machine": (),
        "QAbstractTransition.onTransition": ('PySide2.QtCore.QEvent',),
        "QAbstractTransition.removeAnimation": ('PySide2.QtCore.QAbstractAnimation',),
        "QAbstractTransition.setTargetState": ('PySide2.QtCore.QAbstractState',),
        "QAbstractTransition.setTargetStates": ('list',),
        "QAbstractTransition.setTransitionType": ('PySide2.QtCore.QAbstractTransition.TransitionType',),
        "QAbstractTransition.sourceState": (),
        "QAbstractTransition.targetState": (),
        "QAbstractTransition.targetStates": (),
        "QAbstractTransition.transitionType": (),

    # class PySide2.QtCore.QAnimationGroup:
        "QAnimationGroup.__init__": ('PySide2.QtCore.QObject',),
        "QAnimationGroup.addAnimation": ('PySide2.QtCore.QAbstractAnimation',),
        "QAnimationGroup.animationAt": ('int',),
        "QAnimationGroup.animationCount": (),
        "QAnimationGroup.clear": (),
        "QAnimationGroup.event": ('PySide2.QtCore.QEvent',),
        "QAnimationGroup.indexOfAnimation": ('PySide2.QtCore.QAbstractAnimation',),
        "QAnimationGroup.insertAnimation": ('int', 'PySide2.QtCore.QAbstractAnimation'),
        "QAnimationGroup.removeAnimation": ('PySide2.QtCore.QAbstractAnimation',),
        "QAnimationGroup.takeAnimation": ('int',),

    # class PySide2.QtCore.QBasicMutex:
        "QBasicMutex.__init__": (),
        "QBasicMutex.isRecursive": (),
        "QBasicMutex.lock": (),
        "QBasicMutex.tryLock": (),
        "QBasicMutex.try_lock": (),
        "QBasicMutex.unlock": (),

    # class PySide2.QtCore.QBasicTimer:
        "QBasicTimer.__init__": [(), ('PySide2.QtCore.QBasicTimer',)],
        "QBasicTimer.__copy__": (),
        "QBasicTimer.isActive": (),
        "QBasicTimer.start": [('int', 'PySide2.QtCore.QObject'), ('int', 'PySide2.QtCore.Qt.TimerType', 'PySide2.QtCore.QObject')],
        "QBasicTimer.stop": (),
        "QBasicTimer.timerId": (),

    # class PySide2.QtCore.QBitArray:
        "QBitArray.__init__": [(), ('PySide2.QtCore.QBitArray',), ('int', 'bool')],
        "QBitArray.__and__": ('PySide2.QtCore.QBitArray',),
        "QBitArray.__copy__": (),
        "QBitArray.__iand__": ('PySide2.QtCore.QBitArray',),
        "QBitArray.__invert__": (),
        "QBitArray.__ior__": ('PySide2.QtCore.QBitArray',),
        "QBitArray.__ixor__": ('PySide2.QtCore.QBitArray',),
        "QBitArray.__or__": ('PySide2.QtCore.QBitArray',),
        "QBitArray.__xor__": ('PySide2.QtCore.QBitArray',),
        "QBitArray.at": ('int',),
        "QBitArray.bits": (),
        "QBitArray.clear": (),
        "QBitArray.clearBit": ('int',),
        "QBitArray.count": [(), ('bool',)],
        "QBitArray.fill": [('bool', 'int'), ('bool', 'int', 'int')],
        "QBitArray.fromBits": ('str', 'int'),
        "QBitArray.isEmpty": (),
        "QBitArray.isNull": (),
        "QBitArray.resize": ('int',),
        "QBitArray.setBit": [('int',), ('int', 'bool')],
        "QBitArray.size": (),
        "QBitArray.swap": ('PySide2.QtCore.QBitArray',),
        "QBitArray.testBit": ('int',),
        "QBitArray.toggleBit": ('int',),
        "QBitArray.truncate": ('int',),

    # class PySide2.QtCore.QBuffer:
        "QBuffer.__init__": [('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QObject'), ('PySide2.QtCore.QObject',)],
        "QBuffer.atEnd": (),
        "QBuffer.buffer": (),
        "QBuffer.canReadLine": (),
        "QBuffer.close": (),
        "QBuffer.connectNotify": ('PySide2.QtCore.QMetaMethod',),
        "QBuffer.data": (),
        "QBuffer.disconnectNotify": ('PySide2.QtCore.QMetaMethod',),
        "QBuffer.open": ('PySide2.QtCore.QIODevice.OpenMode',),
        "QBuffer.pos": (),
        "QBuffer.readData": ('str', 'int'),
        "QBuffer.seek": ('int',),
        "QBuffer.setBuffer": ('PySide2.QtCore.QByteArray',),
        "QBuffer.setData": ('PySide2.QtCore.QByteArray',),
        "QBuffer.size": (),
        "QBuffer.writeData": ('str', 'int'),

    # class PySide2.QtCore.QByteArray:
        "QByteArray.__init__": [(), ('PySide2.QtCore.QByteArray',), ('bytearray',), ('int', 'typing.Union[str, int]'), ('str',)],
        "QByteArray.__add__": [('PySide2.QtCore.QByteArray',), ('bytearray',), ('str',), ('typing.Union[str, int]',)],
        "QByteArray.__copy__": (),
        "QByteArray.__iadd__": [('PySide2.QtCore.QByteArray',), ('bytearray',), ('typing.Union[str, int]',)],
        "QByteArray.__reduce__": (),
        "QByteArray.__repr__": (),
        "QByteArray.__str__": (),
        "QByteArray.append": [('PySide2.QtCore.QByteArray',), ('int', 'typing.Union[str, int]'), ('typing.Union[str, int]',)],
        "QByteArray.at": ('int',),
        "QByteArray.back": (),
        "QByteArray.capacity": (),
        "QByteArray.cbegin": (),
        "QByteArray.cend": (),
        "QByteArray.chop": ('int',),
        "QByteArray.chopped": ('int',),
        "QByteArray.clear": (),
        "QByteArray.compare": [('PySide2.QtCore.QByteArray', 'PySide2.QtCore.Qt.CaseSensitivity'), ('str', 'PySide2.QtCore.Qt.CaseSensitivity')],
        "QByteArray.contains": [('PySide2.QtCore.QByteArray',), ('typing.Union[str, int]',)],
        "QByteArray.count": [(), ('PySide2.QtCore.QByteArray',), ('typing.Union[str, int]',)],
        "QByteArray.data": (),
        "QByteArray.endsWith": [('PySide2.QtCore.QByteArray',), ('typing.Union[str, int]',)],
        "QByteArray.fill": ('typing.Union[str, int]', 'int'),
        "QByteArray.fromBase64": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray.Base64Options')],
        "QByteArray.fromHex": ('PySide2.QtCore.QByteArray',),
        "QByteArray.fromPercentEncoding": ('PySide2.QtCore.QByteArray', 'typing.Union[str, int]'),
        "QByteArray.fromRawData": ('str', 'int'),
        "QByteArray.front": (),
        "QByteArray.indexOf": ('PySide2.QtCore.QByteArray', 'int'),
        "QByteArray.insert": [('int', 'PySide2.QtCore.QByteArray'), ('int', 'int', 'typing.Union[str, int]')],
        "QByteArray.isEmpty": (),
        "QByteArray.isLower": (),
        "QByteArray.isNull": (),
        "QByteArray.isSharedWith": ('PySide2.QtCore.QByteArray',),
        "QByteArray.isUpper": (),
        "QByteArray.lastIndexOf": ('PySide2.QtCore.QByteArray', 'int'),
        "QByteArray.left": ('int',),
        "QByteArray.leftJustified": ('int', 'typing.Union[str, int]', 'bool'),
        "QByteArray.length": (),
        "QByteArray.mid": ('int', 'int'),
        "QByteArray.number": [('float', 'typing.Union[str, int]', 'int'), ('int', 'int')],
        "QByteArray.prepend": [('PySide2.QtCore.QByteArray',), ('int', 'typing.Union[str, int]'), ('typing.Union[str, int]',)],
        "QByteArray.remove": ('int', 'int'),
        "QByteArray.repeated": ('int',),
        "QByteArray.replace": [('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray'), ('int', 'int', 'PySide2.QtCore.QByteArray'), ('str', 'PySide2.QtCore.QByteArray'), ('typing.Union[str, int]', 'PySide2.QtCore.QByteArray'), ('typing.Union[str, int]', 'typing.Union[str, int]')],
        "QByteArray.reserve": ('int',),
        "QByteArray.resize": ('int',),
        "QByteArray.right": ('int',),
        "QByteArray.rightJustified": ('int', 'typing.Union[str, int]', 'bool'),
        "QByteArray.setNum": [('float', 'typing.Union[str, int]', 'int'), ('int', 'int')],
        "QByteArray.setRawData": ('str', 'int'),
        "QByteArray.shrink_to_fit": (),
        "QByteArray.simplified": (),
        "QByteArray.size": (),
        "QByteArray.split": ('typing.Union[str, int]',),
        "QByteArray.squeeze": (),
        "QByteArray.startsWith": [('PySide2.QtCore.QByteArray',), ('typing.Union[str, int]',)],
        "QByteArray.swap": ('PySide2.QtCore.QByteArray',),
        "QByteArray.toBase64": [(), ('PySide2.QtCore.QByteArray.Base64Options',)],
        "QByteArray.toDouble": ('bool',),
        "QByteArray.toFloat": ('bool',),
        "QByteArray.toHex": [(), ('typing.Union[str, int]',)],
        "QByteArray.toInt": ('bool', 'int'),
        "QByteArray.toLong": ('bool', 'int'),
        "QByteArray.toLongLong": ('bool', 'int'),
        "QByteArray.toLower": (),
        "QByteArray.toPercentEncoding": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray', 'typing.Union[str, int]'),
        "QByteArray.toShort": ('bool', 'int'),
        "QByteArray.toUInt": ('bool', 'int'),
        "QByteArray.toULong": ('bool', 'int'),
        "QByteArray.toULongLong": ('bool', 'int'),
        "QByteArray.toUShort": ('bool', 'int'),
        "QByteArray.toUpper": (),
        "QByteArray.trimmed": (),
        "QByteArray.truncate": ('int',),

    # class PySide2.QtCore.QByteArrayMatcher:
        "QByteArrayMatcher.__init__": [(), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArrayMatcher',), ('str', 'int')],
        "QByteArrayMatcher.__copy__": (),
        "QByteArrayMatcher.indexIn": [('PySide2.QtCore.QByteArray', 'int'), ('str', 'int', 'int')],
        "QByteArrayMatcher.pattern": (),
        "QByteArrayMatcher.setPattern": ('PySide2.QtCore.QByteArray',),

    # class PySide2.QtCore.QCborArray:
        "QCborArray.__init__": [(), ('PySide2.QtCore.QCborArray',)],
        "QCborArray.__add__": ('PySide2.QtCore.QCborValue',),
        "QCborArray.__copy__": (),
        "QCborArray.__iadd__": ('PySide2.QtCore.QCborValue',),
        "QCborArray.__lshift__": ('PySide2.QtCore.QCborValue',),
        "QCborArray.append": ('PySide2.QtCore.QCborValue',),
        "QCborArray.at": ('int',),
        "QCborArray.clear": (),
        "QCborArray.compare": ('PySide2.QtCore.QCborArray',),
        "QCborArray.contains": ('PySide2.QtCore.QCborValue',),
        "QCborArray.empty": (),
        "QCborArray.first": (),
        "QCborArray.fromJsonArray": ('PySide2.QtCore.QJsonArray',),
        "QCborArray.fromStringList": ('typing.List[str]',),
        "QCborArray.fromVariantList": ('list',),
        "QCborArray.insert": ('int', 'PySide2.QtCore.QCborValue'),
        "QCborArray.isEmpty": (),
        "QCborArray.last": (),
        "QCborArray.pop_back": (),
        "QCborArray.pop_front": (),
        "QCborArray.prepend": ('PySide2.QtCore.QCborValue',),
        "QCborArray.push_back": ('PySide2.QtCore.QCborValue',),
        "QCborArray.push_front": ('PySide2.QtCore.QCborValue',),
        "QCborArray.removeAt": ('int',),
        "QCborArray.removeFirst": (),
        "QCborArray.removeLast": (),
        "QCborArray.size": (),
        "QCborArray.swap": ('PySide2.QtCore.QCborArray',),
        "QCborArray.takeAt": ('int',),
        "QCborArray.takeFirst": (),
        "QCborArray.takeLast": (),
        "QCborArray.toCborValue": (),
        "QCborArray.toJsonArray": (),
        "QCborArray.toVariantList": (),

    # class PySide2.QtCore.QCborError:
        "QCborError.__init__": [(), ('PySide2.QtCore.QCborError',)],
        "QCborError.__copy__": (),
        "QCborError.toString": (),

    # class PySide2.QtCore.QCborMap:
        "QCborMap.__init__": [(), ('PySide2.QtCore.QCborMap',)],
        "QCborMap.__copy__": (),
        "QCborMap.clear": (),
        "QCborMap.compare": ('PySide2.QtCore.QCborMap',),
        "QCborMap.contains": [('PySide2.QtCore.QCborValue',), ('int',), ('str',)],
        "QCborMap.empty": (),
        "QCborMap.fromJsonObject": ('dict',),
        "QCborMap.fromVariantHash": ('dict',),
        "QCborMap.fromVariantMap": ('dict',),
        "QCborMap.isEmpty": (),
        "QCborMap.keys": (),
        "QCborMap.remove": [('PySide2.QtCore.QCborValue',), ('int',), ('str',)],
        "QCborMap.size": (),
        "QCborMap.swap": ('PySide2.QtCore.QCborMap',),
        "QCborMap.take": [('PySide2.QtCore.QCborValue',), ('int',), ('str',)],
        "QCborMap.toCborValue": (),
        "QCborMap.toJsonObject": (),
        "QCborMap.toVariantHash": (),
        "QCborMap.toVariantMap": (),
        "QCborMap.value": [('PySide2.QtCore.QCborValue',), ('int',), ('str',)],

    # class PySide2.QtCore.QCborParserError:
        "QCborParserError.__init__": [(), ('PySide2.QtCore.QCborParserError',)],
        "QCborParserError.__copy__": (),
        "QCborParserError.errorString": (),

    # class PySide2.QtCore.QCborStreamReader:
        "QCborStreamReader.__init__": [(), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QIODevice',), ('int', 'int'), ('str', 'int')],
        "QCborStreamReader.addData": [('PySide2.QtCore.QByteArray',), ('int', 'int'), ('str', 'int')],
        "QCborStreamReader.clear": (),
        "QCborStreamReader.containerDepth": (),
        "QCborStreamReader.currentOffset": (),
        "QCborStreamReader.currentStringChunkSize": (),
        "QCborStreamReader.device": (),
        "QCborStreamReader.enterContainer": (),
        "QCborStreamReader.hasNext": (),
        "QCborStreamReader.isArray": (),
        "QCborStreamReader.isBool": (),
        "QCborStreamReader.isByteArray": (),
        "QCborStreamReader.isContainer": (),
        "QCborStreamReader.isDouble": (),
        "QCborStreamReader.isFalse": (),
        "QCborStreamReader.isFloat": (),
        "QCborStreamReader.isFloat16": (),
        "QCborStreamReader.isInteger": (),
        "QCborStreamReader.isInvalid": (),
        "QCborStreamReader.isLengthKnown": (),
        "QCborStreamReader.isMap": (),
        "QCborStreamReader.isNegativeInteger": (),
        "QCborStreamReader.isNull": (),
        "QCborStreamReader.isSimpleType": [(), ('PySide2.QtCore.QCborSimpleType',)],
        "QCborStreamReader.isString": (),
        "QCborStreamReader.isTag": (),
        "QCborStreamReader.isTrue": (),
        "QCborStreamReader.isUndefined": (),
        "QCborStreamReader.isUnsignedInteger": (),
        "QCborStreamReader.isValid": (),
        "QCborStreamReader.lastError": (),
        "QCborStreamReader.leaveContainer": (),
        "QCborStreamReader.length": (),
        "QCborStreamReader.parentContainerType": (),
        "QCborStreamReader.readByteArray": (),
        "QCborStreamReader.readString": (),
        "QCborStreamReader.reparse": (),
        "QCborStreamReader.reset": (),
        "QCborStreamReader.setDevice": ('PySide2.QtCore.QIODevice',),
        "QCborStreamReader.toBool": (),
        "QCborStreamReader.toDouble": (),
        "QCborStreamReader.toFloat": (),
        "QCborStreamReader.toInteger": (),
        "QCborStreamReader.toSimpleType": (),
        "QCborStreamReader.toUnsignedInteger": (),
        "QCborStreamReader.type": (),

    # class PySide2.QtCore.QCborStreamWriter:
        "QCborStreamWriter.__init__": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QIODevice',)],
        "QCborStreamWriter.append": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QCborKnownTags',), ('PySide2.QtCore.QCborSimpleType',), ('bool',), ('float',), ('int',), ('str', 'int')],
        "QCborStreamWriter.appendByteString": ('str', 'int'),
        "QCborStreamWriter.appendNull": (),
        "QCborStreamWriter.appendTextString": ('str', 'int'),
        "QCborStreamWriter.appendUndefined": (),
        "QCborStreamWriter.device": (),
        "QCborStreamWriter.endArray": (),
        "QCborStreamWriter.endMap": (),
        "QCborStreamWriter.setDevice": ('PySide2.QtCore.QIODevice',),
        "QCborStreamWriter.startArray": [(), ('int',)],
        "QCborStreamWriter.startMap": [(), ('int',)],

    # class PySide2.QtCore.QCborStringResultByteArray:
        "QCborStringResultByteArray.__init__": [(), ('PySide2.QtCore.QCborStringResultByteArray',)],
        "QCborStringResultByteArray.__copy__": (),

    # class PySide2.QtCore.QCborStringResultString:
        "QCborStringResultString.__init__": [(), ('PySide2.QtCore.QCborStringResultString',)],
        "QCborStringResultString.__copy__": (),

    # class PySide2.QtCore.QCborValue:
        "QCborValue.__init__": [(), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QCborArray',), ('PySide2.QtCore.QCborKnownTags', 'PySide2.QtCore.QCborValue'), ('PySide2.QtCore.QCborMap',), ('PySide2.QtCore.QCborSimpleType',), ('PySide2.QtCore.QCborValue',), ('PySide2.QtCore.QCborValue.Type',), ('PySide2.QtCore.QDateTime',), ('PySide2.QtCore.QRegularExpression',), ('PySide2.QtCore.QUrl',), ('PySide2.QtCore.QUuid',), ('bool',), ('float',), ('int',), ('str',)],
        "QCborValue.__copy__": (),
        "QCborValue.compare": ('PySide2.QtCore.QCborValue',),
        "QCborValue.fromCbor": [('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QCborParserError'), ('PySide2.QtCore.QCborStreamReader',), ('int', 'int', 'PySide2.QtCore.QCborParserError'), ('str', 'int', 'PySide2.QtCore.QCborParserError')],
        "QCborValue.fromJsonValue": ('PySide2.QtCore.QJsonValue',),
        "QCborValue.fromVariant": ('typing.Any',),
        "QCborValue.isArray": (),
        "QCborValue.isBool": (),
        "QCborValue.isByteArray": (),
        "QCborValue.isContainer": (),
        "QCborValue.isDateTime": (),
        "QCborValue.isDouble": (),
        "QCborValue.isFalse": (),
        "QCborValue.isInteger": (),
        "QCborValue.isInvalid": (),
        "QCborValue.isMap": (),
        "QCborValue.isNull": (),
        "QCborValue.isRegularExpression": (),
        "QCborValue.isSimpleType": [(), ('PySide2.QtCore.QCborSimpleType',)],
        "QCborValue.isString": (),
        "QCborValue.isTag": (),
        "QCborValue.isTrue": (),
        "QCborValue.isUndefined": (),
        "QCborValue.isUrl": (),
        "QCborValue.isUuid": (),
        "QCborValue.swap": ('PySide2.QtCore.QCborValue',),
        "QCborValue.taggedValue": ('PySide2.QtCore.QCborValue',),
        "QCborValue.toArray": [(), ('PySide2.QtCore.QCborArray',)],
        "QCborValue.toBool": ('bool',),
        "QCborValue.toByteArray": ('PySide2.QtCore.QByteArray',),
        "QCborValue.toCbor": [('PySide2.QtCore.QCborStreamWriter', 'PySide2.QtCore.QCborValue.EncodingOptions'), ('PySide2.QtCore.QCborValue.EncodingOptions',)],
        "QCborValue.toDateTime": ('PySide2.QtCore.QDateTime',),
        "QCborValue.toDiagnosticNotation": ('PySide2.QtCore.QCborValue.DiagnosticNotationOptions',),
        "QCborValue.toDouble": ('float',),
        "QCborValue.toInteger": ('int',),
        "QCborValue.toJsonValue": (),
        "QCborValue.toMap": [(), ('PySide2.QtCore.QCborMap',)],
        "QCborValue.toRegularExpression": ('PySide2.QtCore.QRegularExpression',),
        "QCborValue.toSimpleType": ('PySide2.QtCore.QCborSimpleType',),
        "QCborValue.toString": ('str',),
        "QCborValue.toUrl": ('PySide2.QtCore.QUrl',),
        "QCborValue.toUuid": ('PySide2.QtCore.QUuid',),
        "QCborValue.toVariant": (),
        "QCborValue.type": (),

    # class PySide2.QtCore.QChildEvent:
        "QChildEvent.__init__": ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QObject'),
        "QChildEvent.added": (),
        "QChildEvent.child": (),
        "QChildEvent.polished": (),
        "QChildEvent.removed": (),

    # class PySide2.QtCore.QCollator:
        "QCollator.__init__": [('PySide2.QtCore.QCollator',), ('PySide2.QtCore.QLocale',)],
        "QCollator.__call__": ('str', 'str'),
        "QCollator.caseSensitivity": (),
        "QCollator.compare": [('str', 'str'), ('typing.Union[str, int]', 'int', 'typing.Union[str, int]', 'int')],
        "QCollator.ignorePunctuation": (),
        "QCollator.locale": (),
        "QCollator.numericMode": (),
        "QCollator.setCaseSensitivity": ('PySide2.QtCore.Qt.CaseSensitivity',),
        "QCollator.setIgnorePunctuation": ('bool',),
        "QCollator.setLocale": ('PySide2.QtCore.QLocale',),
        "QCollator.setNumericMode": ('bool',),
        "QCollator.sortKey": ('str',),
        "QCollator.swap": ('PySide2.QtCore.QCollator',),

    # class PySide2.QtCore.QCollatorSortKey:
        "QCollatorSortKey.__init__": ('PySide2.QtCore.QCollatorSortKey',),
        "QCollatorSortKey.compare": ('PySide2.QtCore.QCollatorSortKey',),
        "QCollatorSortKey.swap": ('PySide2.QtCore.QCollatorSortKey',),

    # class PySide2.QtCore.QCommandLineOption:
        "QCommandLineOption.__init__": [('PySide2.QtCore.QCommandLineOption',), ('str',), ('str', 'str', 'str', 'str'), ('typing.List[str]',), ('typing.List[str]', 'str', 'str', 'str')],
        "QCommandLineOption.defaultValues": (),
        "QCommandLineOption.description": (),
        "QCommandLineOption.flags": (),
        "QCommandLineOption.isHidden": (),
        "QCommandLineOption.names": (),
        "QCommandLineOption.setDefaultValue": ('str',),
        "QCommandLineOption.setDefaultValues": ('typing.List[str]',),
        "QCommandLineOption.setDescription": ('str',),
        "QCommandLineOption.setFlags": ('PySide2.QtCore.QCommandLineOption.Flags',),
        "QCommandLineOption.setHidden": ('bool',),
        "QCommandLineOption.setValueName": ('str',),
        "QCommandLineOption.swap": ('PySide2.QtCore.QCommandLineOption',),
        "QCommandLineOption.valueName": (),

    # class PySide2.QtCore.QCommandLineParser:
        "QCommandLineParser.__init__": (),
        "QCommandLineParser.addHelpOption": (),
        "QCommandLineParser.addOption": ('PySide2.QtCore.QCommandLineOption',),
        "QCommandLineParser.addOptions": ('list',),
        "QCommandLineParser.addPositionalArgument": ('str', 'str', 'str'),
        "QCommandLineParser.addVersionOption": (),
        "QCommandLineParser.applicationDescription": (),
        "QCommandLineParser.clearPositionalArguments": (),
        "QCommandLineParser.errorText": (),
        "QCommandLineParser.helpText": (),
        "QCommandLineParser.isSet": [('PySide2.QtCore.QCommandLineOption',), ('str',)],
        "QCommandLineParser.optionNames": (),
        "QCommandLineParser.parse": ('typing.List[str]',),
        "QCommandLineParser.positionalArguments": (),
        "QCommandLineParser.process": [('PySide2.QtCore.QCoreApplication',), ('typing.List[str]',)],
        "QCommandLineParser.setApplicationDescription": ('str',),
        "QCommandLineParser.setOptionsAfterPositionalArgumentsMode": ('PySide2.QtCore.QCommandLineParser.OptionsAfterPositionalArgumentsMode',),
        "QCommandLineParser.setSingleDashWordOptionMode": ('PySide2.QtCore.QCommandLineParser.SingleDashWordOptionMode',),
        "QCommandLineParser.showHelp": ('int',),
        "QCommandLineParser.showVersion": (),
        "QCommandLineParser.unknownOptionNames": (),
        "QCommandLineParser.value": [('PySide2.QtCore.QCommandLineOption',), ('str',)],
        "QCommandLineParser.values": [('PySide2.QtCore.QCommandLineOption',), ('str',)],

    # class PySide2.QtCore.QCoreApplication:
        "QCoreApplication.__init__": [(), ('typing.List[str]',)],
        "QCoreApplication.addLibraryPath": ('str',),
        "QCoreApplication.applicationDirPath": (),
        "QCoreApplication.applicationFilePath": (),
        "QCoreApplication.applicationName": (),
        "QCoreApplication.applicationPid": (),
        "QCoreApplication.applicationVersion": (),
        "QCoreApplication.arguments": (),
        "QCoreApplication.closingDown": (),
        "QCoreApplication.event": ('PySide2.QtCore.QEvent',),
        "QCoreApplication.eventDispatcher": (),
        "QCoreApplication.exec_": (),
        "QCoreApplication.exit": ('int',),
        "QCoreApplication.flush": (),
        "QCoreApplication.hasPendingEvents": (),
        "QCoreApplication.installNativeEventFilter": ('PySide2.QtCore.QAbstractNativeEventFilter',),
        "QCoreApplication.installTranslator": ('PySide2.QtCore.QTranslator',),
        "QCoreApplication.instance": (),
        "QCoreApplication.isQuitLockEnabled": (),
        "QCoreApplication.isSetuidAllowed": (),
        "QCoreApplication.libraryPaths": (),
        "QCoreApplication.notify": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QCoreApplication.organizationDomain": (),
        "QCoreApplication.organizationName": (),
        "QCoreApplication.postEvent": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent', 'int'),
        "QCoreApplication.processEvents": [('PySide2.QtCore.QEventLoop.ProcessEventsFlags',), ('PySide2.QtCore.QEventLoop.ProcessEventsFlags', 'int')],
        "QCoreApplication.quit": (),
        "QCoreApplication.removeLibraryPath": ('str',),
        "QCoreApplication.removeNativeEventFilter": ('PySide2.QtCore.QAbstractNativeEventFilter',),
        "QCoreApplication.removePostedEvents": ('PySide2.QtCore.QObject', 'int'),
        "QCoreApplication.removeTranslator": ('PySide2.QtCore.QTranslator',),
        "QCoreApplication.sendEvent": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QCoreApplication.sendPostedEvents": ('PySide2.QtCore.QObject', 'int'),
        "QCoreApplication.setApplicationName": ('str',),
        "QCoreApplication.setApplicationVersion": ('str',),
        "QCoreApplication.setAttribute": ('PySide2.QtCore.Qt.ApplicationAttribute', 'bool'),
        "QCoreApplication.setEventDispatcher": ('PySide2.QtCore.QAbstractEventDispatcher',),
        "QCoreApplication.setLibraryPaths": ('typing.List[str]',),
        "QCoreApplication.setOrganizationDomain": ('str',),
        "QCoreApplication.setOrganizationName": ('str',),
        "QCoreApplication.setQuitLockEnabled": ('bool',),
        "QCoreApplication.setSetuidAllowed": ('bool',),
        "QCoreApplication.startingUp": (),
        "QCoreApplication.testAttribute": ('PySide2.QtCore.Qt.ApplicationAttribute',),
        "QCoreApplication.translate": ('str', 'str', 'str', 'int'),

    # class PySide2.QtCore.QCryptographicHash:
        "QCryptographicHash.__init__": ('PySide2.QtCore.QCryptographicHash.Algorithm',),
        "QCryptographicHash.addData": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QIODevice',), ('str', 'int')],
        "QCryptographicHash.hash": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QCryptographicHash.Algorithm'),
        "QCryptographicHash.hashLength": ('PySide2.QtCore.QCryptographicHash.Algorithm',),
        "QCryptographicHash.reset": (),
        "QCryptographicHash.result": (),

    # class PySide2.QtCore.QDataStream:
        "QDataStream.__init__": [(), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QIODevice.OpenMode'), ('PySide2.QtCore.QIODevice',)],
        "QDataStream.__lshift__": [('PySide2.QtCore.QBitArray',), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QDate',), ('PySide2.QtCore.QDateTime',), ('PySide2.QtCore.QEasingCurve',), ('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QLocale',), ('PySide2.QtCore.QMargins',), ('PySide2.QtCore.QMarginsF',), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',), ('PySide2.QtCore.QRegExp',), ('PySide2.QtCore.QRegularExpression',), ('PySide2.QtCore.QSize',), ('PySide2.QtCore.QSizeF',), ('PySide2.QtCore.QTime',), ('PySide2.QtCore.QTimeZone',), ('PySide2.QtCore.QUrl',), ('PySide2.QtCore.QUuid',), ('PySide2.QtCore.QVersionNumber',), ('str',)],
        "QDataStream.__rshift__": [('PySide2.QtCore.QBitArray',), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QDate',), ('PySide2.QtCore.QDateTime',), ('PySide2.QtCore.QEasingCurve',), ('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QLocale',), ('PySide2.QtCore.QMargins',), ('PySide2.QtCore.QMarginsF',), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',), ('PySide2.QtCore.QRegExp',), ('PySide2.QtCore.QRegularExpression',), ('PySide2.QtCore.QSize',), ('PySide2.QtCore.QSizeF',), ('PySide2.QtCore.QTime',), ('PySide2.QtCore.QTimeZone',), ('PySide2.QtCore.QUrl',), ('PySide2.QtCore.QUuid',), ('PySide2.QtCore.QVersionNumber',)],
        "QDataStream.abortTransaction": (),
        "QDataStream.atEnd": (),
        "QDataStream.byteOrder": (),
        "QDataStream.commitTransaction": (),
        "QDataStream.device": (),
        "QDataStream.floatingPointPrecision": (),
        "QDataStream.readBool": (),
        "QDataStream.readDouble": (),
        "QDataStream.readFloat": (),
        "QDataStream.readInt16": (),
        "QDataStream.readInt32": (),
        "QDataStream.readInt64": (),
        "QDataStream.readInt8": (),
        "QDataStream.readQChar": (),
        "QDataStream.readQString": (),
        "QDataStream.readQStringList": (),
        "QDataStream.readQVariant": (),
        "QDataStream.readRawData": ('str', 'int'),
        "QDataStream.readString": (),
        "QDataStream.readUInt16": (),
        "QDataStream.readUInt32": (),
        "QDataStream.readUInt64": (),
        "QDataStream.readUInt8": (),
        "QDataStream.resetStatus": (),
        "QDataStream.rollbackTransaction": (),
        "QDataStream.setByteOrder": ('PySide2.QtCore.QDataStream.ByteOrder',),
        "QDataStream.setDevice": ('PySide2.QtCore.QIODevice',),
        "QDataStream.setFloatingPointPrecision": ('PySide2.QtCore.QDataStream.FloatingPointPrecision',),
        "QDataStream.setStatus": ('PySide2.QtCore.QDataStream.Status',),
        "QDataStream.setVersion": ('int',),
        "QDataStream.skipRawData": ('int',),
        "QDataStream.startTransaction": (),
        "QDataStream.status": (),
        "QDataStream.unsetDevice": (),
        "QDataStream.version": (),
        "QDataStream.writeBool": ('bool',),
        "QDataStream.writeDouble": ('float',),
        "QDataStream.writeFloat": ('float',),
        "QDataStream.writeInt16": ('int',),
        "QDataStream.writeInt32": ('int',),
        "QDataStream.writeInt64": ('int',),
        "QDataStream.writeInt8": ('typing.Union[str, int]',),
        "QDataStream.writeQChar": ('typing.Union[str, int]',),
        "QDataStream.writeQString": ('str',),
        "QDataStream.writeQStringList": ('typing.List[str]',),
        "QDataStream.writeQVariant": ('typing.Any',),
        "QDataStream.writeRawData": ('str', 'int'),
        "QDataStream.writeString": ('str',),
        "QDataStream.writeUInt16": ('int',),
        "QDataStream.writeUInt32": ('int',),
        "QDataStream.writeUInt64": ('int',),
        "QDataStream.writeUInt8": ('typing.Union[str, int]',),

    # class PySide2.QtCore.QDate:
        "QDate.__init__": [(), ('PySide2.QtCore.QDate',), ('int', 'int', 'int')],
        "QDate.__copy__": (),
        "QDate.__reduce__": (),
        "QDate.__repr__": (),
        "QDate.addDays": ('int',),
        "QDate.addMonths": ('int',),
        "QDate.addYears": ('int',),
        "QDate.currentDate": (),
        "QDate.day": (),
        "QDate.dayOfWeek": (),
        "QDate.dayOfYear": (),
        "QDate.daysInMonth": (),
        "QDate.daysInYear": (),
        "QDate.daysTo": ('PySide2.QtCore.QDate',),
        "QDate.fromJulianDay": ('int',),
        "QDate.fromString": [('str', 'PySide2.QtCore.Qt.DateFormat'), ('str', 'str')],
        "QDate.getDate": ('int', 'int', 'int'),
        "QDate.isLeapYear": ('int',),
        "QDate.isNull": (),
        "QDate.isValid": [(), ('int', 'int', 'int')],
        "QDate.longDayName": ('int', 'PySide2.QtCore.QDate.MonthNameType'),
        "QDate.longMonthName": ('int', 'PySide2.QtCore.QDate.MonthNameType'),
        "QDate.month": (),
        "QDate.setDate": ('int', 'int', 'int'),
        "QDate.shortDayName": ('int', 'PySide2.QtCore.QDate.MonthNameType'),
        "QDate.shortMonthName": ('int', 'PySide2.QtCore.QDate.MonthNameType'),
        "QDate.toJulianDay": (),
        "QDate.toPython": (),
        "QDate.toString": [('PySide2.QtCore.Qt.DateFormat',), ('str',)],
        "QDate.weekNumber": ('int',),
        "QDate.year": (),

    # class PySide2.QtCore.QDateTime:
        "QDateTime.__init__": [(), ('PySide2.QtCore.QDate',), ('PySide2.QtCore.QDate', 'PySide2.QtCore.QTime', 'PySide2.QtCore.QTimeZone'), ('PySide2.QtCore.QDate', 'PySide2.QtCore.QTime', 'PySide2.QtCore.Qt.TimeSpec'), ('PySide2.QtCore.QDate', 'PySide2.QtCore.QTime', 'PySide2.QtCore.Qt.TimeSpec', 'int'), ('PySide2.QtCore.QDateTime',), ('int', 'int', 'int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int')],
        "QDateTime.__copy__": (),
        "QDateTime.__reduce__": (),
        "QDateTime.__repr__": (),
        "QDateTime.addDays": ('int',),
        "QDateTime.addMSecs": ('int',),
        "QDateTime.addMonths": ('int',),
        "QDateTime.addSecs": ('int',),
        "QDateTime.addYears": ('int',),
        "QDateTime.currentDateTime": (),
        "QDateTime.currentDateTimeUtc": (),
        "QDateTime.currentMSecsSinceEpoch": (),
        "QDateTime.currentSecsSinceEpoch": (),
        "QDateTime.date": (),
        "QDateTime.daysTo": ('PySide2.QtCore.QDateTime',),
        "QDateTime.fromMSecsSinceEpoch": [('int',), ('int', 'PySide2.QtCore.QTimeZone'), ('int', 'PySide2.QtCore.Qt.TimeSpec', 'int')],
        "QDateTime.fromSecsSinceEpoch": [('int', 'PySide2.QtCore.QTimeZone'), ('int', 'PySide2.QtCore.Qt.TimeSpec', 'int')],
        "QDateTime.fromString": [('str', 'PySide2.QtCore.Qt.DateFormat'), ('str', 'str')],
        "QDateTime.fromTime_t": [('int',), ('int', 'PySide2.QtCore.QTimeZone'), ('int', 'PySide2.QtCore.Qt.TimeSpec', 'int')],
        "QDateTime.isDaylightTime": (),
        "QDateTime.isNull": (),
        "QDateTime.isValid": (),
        "QDateTime.msecsTo": ('PySide2.QtCore.QDateTime',),
        "QDateTime.offsetFromUtc": (),
        "QDateTime.secsTo": ('PySide2.QtCore.QDateTime',),
        "QDateTime.setDate": ('PySide2.QtCore.QDate',),
        "QDateTime.setMSecsSinceEpoch": ('int',),
        "QDateTime.setOffsetFromUtc": ('int',),
        "QDateTime.setSecsSinceEpoch": ('int',),
        "QDateTime.setTime": ('PySide2.QtCore.QTime',),
        "QDateTime.setTimeSpec": ('PySide2.QtCore.Qt.TimeSpec',),
        "QDateTime.setTimeZone": ('PySide2.QtCore.QTimeZone',),
        "QDateTime.setTime_t": ('int',),
        "QDateTime.setUtcOffset": ('int',),
        "QDateTime.swap": ('PySide2.QtCore.QDateTime',),
        "QDateTime.time": (),
        "QDateTime.timeSpec": (),
        "QDateTime.timeZone": (),
        "QDateTime.timeZoneAbbreviation": (),
        "QDateTime.toLocalTime": (),
        "QDateTime.toMSecsSinceEpoch": (),
        "QDateTime.toOffsetFromUtc": ('int',),
        "QDateTime.toPython": (),
        "QDateTime.toSecsSinceEpoch": (),
        "QDateTime.toString": [('PySide2.QtCore.Qt.DateFormat',), ('str',)],
        "QDateTime.toTimeSpec": ('PySide2.QtCore.Qt.TimeSpec',),
        "QDateTime.toTimeZone": ('PySide2.QtCore.QTimeZone',),
        "QDateTime.toTime_t": (),
        "QDateTime.toUTC": (),
        "QDateTime.utcOffset": (),

    # class PySide2.QtCore.QDir:
        "QDir.__init__": [('PySide2.QtCore.QDir',), ('str',), ('str', 'str', 'PySide2.QtCore.QDir.SortFlags', 'PySide2.QtCore.QDir.Filters')],
        "QDir.__copy__": (),
        "QDir.__reduce__": (),
        "QDir.absoluteFilePath": ('str',),
        "QDir.absolutePath": (),
        "QDir.addResourceSearchPath": ('str',),
        "QDir.addSearchPath": ('str', 'str'),
        "QDir.canonicalPath": (),
        "QDir.cd": ('str',),
        "QDir.cdUp": (),
        "QDir.cleanPath": ('str',),
        "QDir.count": (),
        "QDir.current": (),
        "QDir.currentPath": (),
        "QDir.dirName": (),
        "QDir.drives": (),
        "QDir.entryInfoList": [('PySide2.QtCore.QDir.Filters', 'PySide2.QtCore.QDir.SortFlags'), ('typing.List[str]', 'PySide2.QtCore.QDir.Filters', 'PySide2.QtCore.QDir.SortFlags')],
        "QDir.entryList": [('PySide2.QtCore.QDir.Filters', 'PySide2.QtCore.QDir.SortFlags'), ('typing.List[str]', 'PySide2.QtCore.QDir.Filters', 'PySide2.QtCore.QDir.SortFlags')],
        "QDir.exists": [(), ('str',)],
        "QDir.filePath": ('str',),
        "QDir.filter": (),
        "QDir.fromNativeSeparators": ('str',),
        "QDir.home": (),
        "QDir.homePath": (),
        "QDir.isAbsolute": (),
        "QDir.isAbsolutePath": ('str',),
        "QDir.isEmpty": ('PySide2.QtCore.QDir.Filters',),
        "QDir.isReadable": (),
        "QDir.isRelative": (),
        "QDir.isRelativePath": ('str',),
        "QDir.isRoot": (),
        "QDir.listSeparator": (),
        "QDir.makeAbsolute": (),
        "QDir.match": [('str', 'str'), ('typing.List[str]', 'str')],
        "QDir.mkdir": ('str',),
        "QDir.mkpath": ('str',),
        "QDir.nameFilters": (),
        "QDir.nameFiltersFromString": ('str',),
        "QDir.path": (),
        "QDir.refresh": (),
        "QDir.relativeFilePath": ('str',),
        "QDir.remove": ('str',),
        "QDir.removeRecursively": (),
        "QDir.rename": ('str', 'str'),
        "QDir.rmdir": ('str',),
        "QDir.rmpath": ('str',),
        "QDir.root": (),
        "QDir.rootPath": (),
        "QDir.searchPaths": ('str',),
        "QDir.separator": (),
        "QDir.setCurrent": ('str',),
        "QDir.setFilter": ('PySide2.QtCore.QDir.Filters',),
        "QDir.setNameFilters": ('typing.List[str]',),
        "QDir.setPath": ('str',),
        "QDir.setSearchPaths": ('str', 'typing.List[str]'),
        "QDir.setSorting": ('PySide2.QtCore.QDir.SortFlags',),
        "QDir.sorting": (),
        "QDir.swap": ('PySide2.QtCore.QDir',),
        "QDir.temp": (),
        "QDir.tempPath": (),
        "QDir.toNativeSeparators": ('str',),

    # class PySide2.QtCore.QDirIterator:
        "QDirIterator.__init__": [('PySide2.QtCore.QDir', 'PySide2.QtCore.QDirIterator.IteratorFlags'), ('str', 'PySide2.QtCore.QDir.Filters', 'PySide2.QtCore.QDirIterator.IteratorFlags'), ('str', 'PySide2.QtCore.QDirIterator.IteratorFlags'), ('str', 'typing.List[str]', 'PySide2.QtCore.QDir.Filters', 'PySide2.QtCore.QDirIterator.IteratorFlags')],
        "QDirIterator.fileInfo": (),
        "QDirIterator.fileName": (),
        "QDirIterator.filePath": (),
        "QDirIterator.hasNext": (),
        "QDirIterator.path": (),

    # class PySide2.QtCore.QDynamicPropertyChangeEvent:
        "QDynamicPropertyChangeEvent.__init__": ('PySide2.QtCore.QByteArray',),
        "QDynamicPropertyChangeEvent.propertyName": (),

    # class PySide2.QtCore.QEasingCurve:
        "QEasingCurve.__init__": [('PySide2.QtCore.QEasingCurve',), ('PySide2.QtCore.QEasingCurve.Type',)],
        "QEasingCurve.__copy__": (),
        "QEasingCurve.addCubicBezierSegment": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'),
        "QEasingCurve.addTCBSegment": ('PySide2.QtCore.QPointF', 'float', 'float', 'float'),
        "QEasingCurve.amplitude": (),
        "QEasingCurve.customType": (),
        "QEasingCurve.overshoot": (),
        "QEasingCurve.period": (),
        "QEasingCurve.setAmplitude": ('float',),
        "QEasingCurve.setCustomType": ('object',),
        "QEasingCurve.setOvershoot": ('float',),
        "QEasingCurve.setPeriod": ('float',),
        "QEasingCurve.setType": ('PySide2.QtCore.QEasingCurve.Type',),
        "QEasingCurve.swap": ('PySide2.QtCore.QEasingCurve',),
        "QEasingCurve.toCubicSpline": (),
        "QEasingCurve.type": (),
        "QEasingCurve.valueForProgress": ('float',),

    # class PySide2.QtCore.QElapsedTimer:
        "QElapsedTimer.__init__": [(), ('PySide2.QtCore.QElapsedTimer',)],
        "QElapsedTimer.__copy__": (),
        "QElapsedTimer.clockType": (),
        "QElapsedTimer.elapsed": (),
        "QElapsedTimer.hasExpired": ('int',),
        "QElapsedTimer.invalidate": (),
        "QElapsedTimer.isMonotonic": (),
        "QElapsedTimer.isValid": (),
        "QElapsedTimer.msecsSinceReference": (),
        "QElapsedTimer.msecsTo": ('PySide2.QtCore.QElapsedTimer',),
        "QElapsedTimer.nsecsElapsed": (),
        "QElapsedTimer.restart": (),
        "QElapsedTimer.secsTo": ('PySide2.QtCore.QElapsedTimer',),
        "QElapsedTimer.start": (),

    # class PySide2.QtCore.QEvent:
        "QEvent.__init__": [('PySide2.QtCore.QEvent',), ('PySide2.QtCore.QEvent.Type',)],
        "QEvent.accept": (),
        "QEvent.ignore": (),
        "QEvent.isAccepted": (),
        "QEvent.registerEventType": ('int',),
        "QEvent.setAccepted": ('bool',),
        "QEvent.spontaneous": (),
        "QEvent.type": (),

    # class PySide2.QtCore.QEventLoop:
        "QEventLoop.__init__": ('PySide2.QtCore.QObject',),
        "QEventLoop.event": ('PySide2.QtCore.QEvent',),
        "QEventLoop.exec_": ('PySide2.QtCore.QEventLoop.ProcessEventsFlags',),
        "QEventLoop.exit": ('int',),
        "QEventLoop.isRunning": (),
        "QEventLoop.processEvents": [('PySide2.QtCore.QEventLoop.ProcessEventsFlags',), ('PySide2.QtCore.QEventLoop.ProcessEventsFlags', 'int')],
        "QEventLoop.quit": (),
        "QEventLoop.wakeUp": (),

    # class PySide2.QtCore.QEventTransition:
        "QEventTransition.__init__": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QState'), ('PySide2.QtCore.QState',)],
        "QEventTransition.event": ('PySide2.QtCore.QEvent',),
        "QEventTransition.eventSource": (),
        "QEventTransition.eventTest": ('PySide2.QtCore.QEvent',),
        "QEventTransition.eventType": (),
        "QEventTransition.onTransition": ('PySide2.QtCore.QEvent',),
        "QEventTransition.setEventSource": ('PySide2.QtCore.QObject',),
        "QEventTransition.setEventType": ('PySide2.QtCore.QEvent.Type',),

    # class PySide2.QtCore.QFactoryInterface:
        "QFactoryInterface.__init__": (),
        "QFactoryInterface.keys": (),

    # class PySide2.QtCore.QFile:
        "QFile.__init__": [(), ('PySide2.QtCore.QObject',), ('str',), ('str', 'PySide2.QtCore.QObject')],
        "QFile.copy": [('str',), ('str', 'str')],
        "QFile.decodeName": [('PySide2.QtCore.QByteArray',), ('str',)],
        "QFile.encodeName": ('str',),
        "QFile.exists": [(), ('str',)],
        "QFile.fileName": (),
        "QFile.link": [('str',), ('str', 'str')],
        "QFile.open": [('PySide2.QtCore.QIODevice.OpenMode',), ('int', 'PySide2.QtCore.QIODevice.OpenMode', 'PySide2.QtCore.QFileDevice.FileHandleFlags')],
        "QFile.permissions": [(), ('str',)],
        "QFile.readLink": [(), ('str',)],
        "QFile.remove": [(), ('str',)],
        "QFile.rename": [('str',), ('str', 'str')],
        "QFile.resize": [('int',), ('str', 'int')],
        "QFile.setFileName": ('str',),
        "QFile.setPermissions": [('PySide2.QtCore.QFileDevice.Permissions',), ('str', 'PySide2.QtCore.QFileDevice.Permissions')],
        "QFile.size": (),
        "QFile.symLinkTarget": [(), ('str',)],

    # class PySide2.QtCore.QFileDevice:
        "QFileDevice.__init__": [(), ('PySide2.QtCore.QObject',)],
        "QFileDevice.atEnd": (),
        "QFileDevice.close": (),
        "QFileDevice.error": (),
        "QFileDevice.fileName": (),
        "QFileDevice.fileTime": ('PySide2.QtCore.QFileDevice.FileTime',),
        "QFileDevice.flush": (),
        "QFileDevice.handle": (),
        "QFileDevice.isSequential": (),
        "QFileDevice.map": ('int', 'int', 'PySide2.QtCore.QFileDevice.MemoryMapFlags'),
        "QFileDevice.permissions": (),
        "QFileDevice.pos": (),
        "QFileDevice.readData": ('str', 'int'),
        "QFileDevice.readLineData": ('str', 'int'),
        "QFileDevice.resize": ('int',),
        "QFileDevice.seek": ('int',),
        "QFileDevice.setFileTime": ('PySide2.QtCore.QDateTime', 'PySide2.QtCore.QFileDevice.FileTime'),
        "QFileDevice.setPermissions": ('PySide2.QtCore.QFileDevice.Permissions',),
        "QFileDevice.size": (),
        "QFileDevice.unmap": ('typing.Union[str, int]',),
        "QFileDevice.unsetError": (),
        "QFileDevice.writeData": ('str', 'int'),

    # class PySide2.QtCore.QFileInfo:
        "QFileInfo.__init__": [(), ('PySide2.QtCore.QDir', 'str'), ('PySide2.QtCore.QFile',), ('PySide2.QtCore.QFileInfo',), ('str',)],
        "QFileInfo.__copy__": (),
        "QFileInfo.__reduce__": (),
        "QFileInfo.absoluteDir": (),
        "QFileInfo.absoluteFilePath": (),
        "QFileInfo.absolutePath": (),
        "QFileInfo.baseName": (),
        "QFileInfo.birthTime": (),
        "QFileInfo.bundleName": (),
        "QFileInfo.caching": (),
        "QFileInfo.canonicalFilePath": (),
        "QFileInfo.canonicalPath": (),
        "QFileInfo.completeBaseName": (),
        "QFileInfo.completeSuffix": (),
        "QFileInfo.created": (),
        "QFileInfo.dir": (),
        "QFileInfo.exists": [(), ('str',)],
        "QFileInfo.fileName": (),
        "QFileInfo.filePath": (),
        "QFileInfo.group": (),
        "QFileInfo.groupId": (),
        "QFileInfo.isAbsolute": (),
        "QFileInfo.isBundle": (),
        "QFileInfo.isDir": (),
        "QFileInfo.isExecutable": (),
        "QFileInfo.isFile": (),
        "QFileInfo.isHidden": (),
        "QFileInfo.isNativePath": (),
        "QFileInfo.isReadable": (),
        "QFileInfo.isRelative": (),
        "QFileInfo.isRoot": (),
        "QFileInfo.isSymLink": (),
        "QFileInfo.isWritable": (),
        "QFileInfo.lastModified": (),
        "QFileInfo.lastRead": (),
        "QFileInfo.makeAbsolute": (),
        "QFileInfo.metadataChangeTime": (),
        "QFileInfo.owner": (),
        "QFileInfo.ownerId": (),
        "QFileInfo.path": (),
        "QFileInfo.readLink": (),
        "QFileInfo.refresh": (),
        "QFileInfo.setCaching": ('bool',),
        "QFileInfo.setFile": [('PySide2.QtCore.QDir', 'str'), ('PySide2.QtCore.QFile',), ('str',)],
        "QFileInfo.size": (),
        "QFileInfo.suffix": (),
        "QFileInfo.swap": ('PySide2.QtCore.QFileInfo',),
        "QFileInfo.symLinkTarget": (),

    # class PySide2.QtCore.QFileSelector:
        "QFileSelector.__init__": ('PySide2.QtCore.QObject',),
        "QFileSelector.allSelectors": (),
        "QFileSelector.extraSelectors": (),
        "QFileSelector.select": [('PySide2.QtCore.QUrl',), ('str',)],
        "QFileSelector.setExtraSelectors": ('typing.List[str]',),

    # class PySide2.QtCore.QFileSystemWatcher:
        "QFileSystemWatcher.__init__": [('PySide2.QtCore.QObject',), ('typing.List[str]', 'PySide2.QtCore.QObject')],
        "QFileSystemWatcher.addPath": ('str',),
        "QFileSystemWatcher.addPaths": ('typing.List[str]',),
        "QFileSystemWatcher.directories": (),
        "QFileSystemWatcher.files": (),
        "QFileSystemWatcher.removePath": ('str',),
        "QFileSystemWatcher.removePaths": ('typing.List[str]',),

    # class PySide2.QtCore.QFinalState:
        "QFinalState.__init__": ('PySide2.QtCore.QState',),
        "QFinalState.event": ('PySide2.QtCore.QEvent',),
        "QFinalState.onEntry": ('PySide2.QtCore.QEvent',),
        "QFinalState.onExit": ('PySide2.QtCore.QEvent',),

    # class PySide2.QtCore.QGenericArgument:
        "QGenericArgument.__init__": [('PySide2.QtCore.QGenericArgument',), ('str', 'int')],
        "QGenericArgument.__copy__": (),
        "QGenericArgument.data": (),
        "QGenericArgument.name": (),

    # class PySide2.QtCore.QGenericReturnArgument:
        "QGenericReturnArgument.__init__": [('PySide2.QtCore.QGenericReturnArgument',), ('str', 'int')],
        "QGenericReturnArgument.__copy__": (),

    # class PySide2.QtCore.QHistoryState:
        "QHistoryState.__init__": [('PySide2.QtCore.QHistoryState.HistoryType', 'PySide2.QtCore.QState'), ('PySide2.QtCore.QState',)],
        "QHistoryState.defaultState": (),
        "QHistoryState.defaultTransition": (),
        "QHistoryState.event": ('PySide2.QtCore.QEvent',),
        "QHistoryState.historyType": (),
        "QHistoryState.onEntry": ('PySide2.QtCore.QEvent',),
        "QHistoryState.onExit": ('PySide2.QtCore.QEvent',),
        "QHistoryState.setDefaultState": ('PySide2.QtCore.QAbstractState',),
        "QHistoryState.setDefaultTransition": ('PySide2.QtCore.QAbstractTransition',),
        "QHistoryState.setHistoryType": ('PySide2.QtCore.QHistoryState.HistoryType',),

    # class PySide2.QtCore.QIODevice:
        "QIODevice.__init__": [(), ('PySide2.QtCore.QObject',)],
        "QIODevice.atEnd": (),
        "QIODevice.bytesAvailable": (),
        "QIODevice.bytesToWrite": (),
        "QIODevice.canReadLine": (),
        "QIODevice.close": (),
        "QIODevice.commitTransaction": (),
        "QIODevice.currentReadChannel": (),
        "QIODevice.currentWriteChannel": (),
        "QIODevice.errorString": (),
        "QIODevice.getChar": ('str',),
        "QIODevice.isOpen": (),
        "QIODevice.isReadable": (),
        "QIODevice.isSequential": (),
        "QIODevice.isTextModeEnabled": (),
        "QIODevice.isTransactionStarted": (),
        "QIODevice.isWritable": (),
        "QIODevice.open": ('PySide2.QtCore.QIODevice.OpenMode',),
        "QIODevice.openMode": (),
        "QIODevice.peek": ('int',),
        "QIODevice.pos": (),
        "QIODevice.putChar": ('typing.Union[str, int]',),
        "QIODevice.read": ('int',),
        "QIODevice.readAll": (),
        "QIODevice.readChannelCount": (),
        "QIODevice.readData": ('str', 'int'),
        "QIODevice.readLine": ('int',),
        "QIODevice.readLineData": ('str', 'int'),
        "QIODevice.reset": (),
        "QIODevice.rollbackTransaction": (),
        "QIODevice.seek": ('int',),
        "QIODevice.setCurrentReadChannel": ('int',),
        "QIODevice.setCurrentWriteChannel": ('int',),
        "QIODevice.setErrorString": ('str',),
        "QIODevice.setOpenMode": ('PySide2.QtCore.QIODevice.OpenMode',),
        "QIODevice.setTextModeEnabled": ('bool',),
        "QIODevice.size": (),
        "QIODevice.skip": ('int',),
        "QIODevice.startTransaction": (),
        "QIODevice.ungetChar": ('typing.Union[str, int]',),
        "QIODevice.waitForBytesWritten": ('int',),
        "QIODevice.waitForReadyRead": ('int',),
        "QIODevice.write": ('PySide2.QtCore.QByteArray',),
        "QIODevice.writeChannelCount": (),
        "QIODevice.writeData": ('str', 'int'),

    # class PySide2.QtCore.QIdentityProxyModel:
        "QIdentityProxyModel.__init__": ('PySide2.QtCore.QObject',),
        "QIdentityProxyModel.columnCount": ('PySide2.QtCore.QModelIndex',),
        "QIdentityProxyModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QIdentityProxyModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
        "QIdentityProxyModel.index": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QIdentityProxyModel.insertColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QIdentityProxyModel.insertRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QIdentityProxyModel.mapFromSource": ('PySide2.QtCore.QModelIndex',),
        "QIdentityProxyModel.mapSelectionFromSource": ('PySide2.QtCore.QItemSelection',),
        "QIdentityProxyModel.mapSelectionToSource": ('PySide2.QtCore.QItemSelection',),
        "QIdentityProxyModel.mapToSource": ('PySide2.QtCore.QModelIndex',),
        "QIdentityProxyModel.match": ('PySide2.QtCore.QModelIndex', 'int', 'typing.Any', 'int', 'PySide2.QtCore.Qt.MatchFlags'),
        "QIdentityProxyModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
        "QIdentityProxyModel.removeColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QIdentityProxyModel.removeRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QIdentityProxyModel.rowCount": ('PySide2.QtCore.QModelIndex',),
        "QIdentityProxyModel.setSourceModel": ('PySide2.QtCore.QAbstractItemModel',),
        "QIdentityProxyModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),

    # class PySide2.QtCore.QItemSelection:
        "QItemSelection.__init__": [(), ('PySide2.QtCore.QItemSelection',), ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex')],
        "QItemSelection.__add__": ('list',),
        "QItemSelection.__copy__": (),
        "QItemSelection.__iadd__": [('PySide2.QtCore.QItemSelectionRange',), ('list',)],
        "QItemSelection.__lshift__": [('PySide2.QtCore.QItemSelectionRange',), ('list',)],
        "QItemSelection.append": [('PySide2.QtCore.QItemSelectionRange',), ('list',)],
        "QItemSelection.at": ('int',),
        "QItemSelection.back": (),
        "QItemSelection.clear": (),
        "QItemSelection.constFirst": (),
        "QItemSelection.constLast": (),
        "QItemSelection.contains": ('PySide2.QtCore.QModelIndex',),
        "QItemSelection.count": [(), ('PySide2.QtCore.QItemSelectionRange',)],
        "QItemSelection.detachShared": (),
        "QItemSelection.empty": (),
        "QItemSelection.endsWith": ('PySide2.QtCore.QItemSelectionRange',),
        "QItemSelection.first": (),
        "QItemSelection.fromSet": ('set',),
        "QItemSelection.fromVector": ('list',),
        "QItemSelection.front": (),
        "QItemSelection.indexOf": ('PySide2.QtCore.QItemSelectionRange', 'int'),
        "QItemSelection.indexes": (),
        "QItemSelection.insert": ('int', 'PySide2.QtCore.QItemSelectionRange'),
        "QItemSelection.isEmpty": (),
        "QItemSelection.isSharedWith": ('list',),
        "QItemSelection.last": (),
        "QItemSelection.lastIndexOf": ('PySide2.QtCore.QItemSelectionRange', 'int'),
        "QItemSelection.length": (),
        "QItemSelection.merge": ('PySide2.QtCore.QItemSelection', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
        "QItemSelection.mid": ('int', 'int'),
        "QItemSelection.move": ('int', 'int'),
        "QItemSelection.pop_back": (),
        "QItemSelection.pop_front": (),
        "QItemSelection.prepend": ('PySide2.QtCore.QItemSelectionRange',),
        "QItemSelection.push_back": ('PySide2.QtCore.QItemSelectionRange',),
        "QItemSelection.push_front": ('PySide2.QtCore.QItemSelectionRange',),
        "QItemSelection.removeAll": ('PySide2.QtCore.QItemSelectionRange',),
        "QItemSelection.removeAt": ('int',),
        "QItemSelection.removeFirst": (),
        "QItemSelection.removeLast": (),
        "QItemSelection.removeOne": ('PySide2.QtCore.QItemSelectionRange',),
        "QItemSelection.replace": ('int', 'PySide2.QtCore.QItemSelectionRange'),
        "QItemSelection.reserve": ('int',),
        "QItemSelection.select": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
        "QItemSelection.setSharable": ('bool',),
        "QItemSelection.size": (),
        "QItemSelection.split": ('PySide2.QtCore.QItemSelectionRange', 'PySide2.QtCore.QItemSelectionRange', 'PySide2.QtCore.QItemSelection'),
        "QItemSelection.startsWith": ('PySide2.QtCore.QItemSelectionRange',),
        "QItemSelection.swap": [('int', 'int'), ('list',)],
        "QItemSelection.takeAt": ('int',),
        "QItemSelection.takeFirst": (),
        "QItemSelection.takeLast": (),
        "QItemSelection.toSet": (),
        "QItemSelection.toVector": (),
        "QItemSelection.value": [('int',), ('int', 'PySide2.QtCore.QItemSelectionRange')],

    # class PySide2.QtCore.QItemSelectionModel:
        "QItemSelectionModel.__init__": [('PySide2.QtCore.QAbstractItemModel',), ('PySide2.QtCore.QAbstractItemModel', 'PySide2.QtCore.QObject')],
        "QItemSelectionModel.clear": (),
        "QItemSelectionModel.clearCurrentIndex": (),
        "QItemSelectionModel.clearSelection": (),
        "QItemSelectionModel.columnIntersectsSelection": ('int', 'PySide2.QtCore.QModelIndex'),
        "QItemSelectionModel.currentIndex": (),
        "QItemSelectionModel.emitSelectionChanged": ('PySide2.QtCore.QItemSelection', 'PySide2.QtCore.QItemSelection'),
        "QItemSelectionModel.hasSelection": (),
        "QItemSelectionModel.isColumnSelected": ('int', 'PySide2.QtCore.QModelIndex'),
        "QItemSelectionModel.isRowSelected": ('int', 'PySide2.QtCore.QModelIndex'),
        "QItemSelectionModel.isSelected": ('PySide2.QtCore.QModelIndex',),
        "QItemSelectionModel.model": (),
        "QItemSelectionModel.reset": (),
        "QItemSelectionModel.rowIntersectsSelection": ('int', 'PySide2.QtCore.QModelIndex'),
        "QItemSelectionModel.select": [('PySide2.QtCore.QItemSelection', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'), ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags')],
        "QItemSelectionModel.selectedColumns": ('int',),
        "QItemSelectionModel.selectedIndexes": (),
        "QItemSelectionModel.selectedRows": ('int',),
        "QItemSelectionModel.selection": (),
        "QItemSelectionModel.setCurrentIndex": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
        "QItemSelectionModel.setModel": ('PySide2.QtCore.QAbstractItemModel',),

    # class PySide2.QtCore.QItemSelectionRange:
        "QItemSelectionRange.__init__": [(), ('PySide2.QtCore.QItemSelectionRange',), ('PySide2.QtCore.QModelIndex',), ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex')],
        "QItemSelectionRange.__copy__": (),
        "QItemSelectionRange.bottom": (),
        "QItemSelectionRange.bottomRight": (),
        "QItemSelectionRange.contains": [('PySide2.QtCore.QModelIndex',), ('int', 'int', 'PySide2.QtCore.QModelIndex')],
        "QItemSelectionRange.height": (),
        "QItemSelectionRange.indexes": (),
        "QItemSelectionRange.intersected": ('PySide2.QtCore.QItemSelectionRange',),
        "QItemSelectionRange.intersects": ('PySide2.QtCore.QItemSelectionRange',),
        "QItemSelectionRange.isEmpty": (),
        "QItemSelectionRange.isValid": (),
        "QItemSelectionRange.left": (),
        "QItemSelectionRange.model": (),
        "QItemSelectionRange.parent": (),
        "QItemSelectionRange.right": (),
        "QItemSelectionRange.swap": ('PySide2.QtCore.QItemSelectionRange',),
        "QItemSelectionRange.top": (),
        "QItemSelectionRange.topLeft": (),
        "QItemSelectionRange.width": (),

    # class PySide2.QtCore.QJsonArray:
        "QJsonArray.__init__": [(), ('PySide2.QtCore.QJsonArray',)],
        "QJsonArray.__add__": ('PySide2.QtCore.QJsonValue',),
        "QJsonArray.__copy__": (),
        "QJsonArray.__iadd__": ('PySide2.QtCore.QJsonValue',),
        "QJsonArray.__lshift__": ('PySide2.QtCore.QJsonValue',),
        "QJsonArray.append": ('PySide2.QtCore.QJsonValue',),
        "QJsonArray.at": ('int',),
        "QJsonArray.contains": ('PySide2.QtCore.QJsonValue',),
        "QJsonArray.count": (),
        "QJsonArray.empty": (),
        "QJsonArray.first": (),
        "QJsonArray.fromStringList": ('typing.List[str]',),
        "QJsonArray.fromVariantList": ('list',),
        "QJsonArray.insert": ('int', 'PySide2.QtCore.QJsonValue'),
        "QJsonArray.isEmpty": (),
        "QJsonArray.last": (),
        "QJsonArray.pop_back": (),
        "QJsonArray.pop_front": (),
        "QJsonArray.prepend": ('PySide2.QtCore.QJsonValue',),
        "QJsonArray.push_back": ('PySide2.QtCore.QJsonValue',),
        "QJsonArray.push_front": ('PySide2.QtCore.QJsonValue',),
        "QJsonArray.removeAt": ('int',),
        "QJsonArray.removeFirst": (),
        "QJsonArray.removeLast": (),
        "QJsonArray.replace": ('int', 'PySide2.QtCore.QJsonValue'),
        "QJsonArray.size": (),
        "QJsonArray.swap": ('PySide2.QtCore.QJsonArray',),
        "QJsonArray.takeAt": ('int',),
        "QJsonArray.toVariantList": (),

    # class PySide2.QtCore.QJsonDocument:
        "QJsonDocument.__init__": [(), ('PySide2.QtCore.QJsonArray',), ('PySide2.QtCore.QJsonDocument',), ('dict',)],
        "QJsonDocument.__copy__": (),
        "QJsonDocument.array": (),
        "QJsonDocument.fromBinaryData": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QJsonDocument.DataValidation'),
        "QJsonDocument.fromJson": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QJsonParseError'),
        "QJsonDocument.fromRawData": ('str', 'int', 'PySide2.QtCore.QJsonDocument.DataValidation'),
        "QJsonDocument.fromVariant": ('typing.Any',),
        "QJsonDocument.isArray": (),
        "QJsonDocument.isEmpty": (),
        "QJsonDocument.isNull": (),
        "QJsonDocument.isObject": (),
        "QJsonDocument.object": (),
        "QJsonDocument.rawData": ('int',),
        "QJsonDocument.setArray": ('PySide2.QtCore.QJsonArray',),
        "QJsonDocument.setObject": ('dict',),
        "QJsonDocument.swap": ('PySide2.QtCore.QJsonDocument',),
        "QJsonDocument.toBinaryData": (),
        "QJsonDocument.toJson": [(), ('PySide2.QtCore.QJsonDocument.JsonFormat',)],
        "QJsonDocument.toVariant": (),

    # class PySide2.QtCore.QJsonParseError:
        "QJsonParseError.__init__": [(), ('PySide2.QtCore.QJsonParseError',)],
        "QJsonParseError.__copy__": (),
        "QJsonParseError.errorString": (),

    # class PySide2.QtCore.QJsonValue:
        "QJsonValue.__init__": [('PySide2.QtCore.QJsonArray',), ('PySide2.QtCore.QJsonValue',), ('PySide2.QtCore.QJsonValue.Type',), ('bool',), ('dict',), ('float',), ('int',), ('str',)],
        "QJsonValue.__copy__": (),
        "QJsonValue.fromVariant": ('typing.Any',),
        "QJsonValue.isArray": (),
        "QJsonValue.isBool": (),
        "QJsonValue.isDouble": (),
        "QJsonValue.isNull": (),
        "QJsonValue.isObject": (),
        "QJsonValue.isString": (),
        "QJsonValue.isUndefined": (),
        "QJsonValue.swap": ('PySide2.QtCore.QJsonValue',),
        "QJsonValue.toArray": [(), ('PySide2.QtCore.QJsonArray',)],
        "QJsonValue.toBool": ('bool',),
        "QJsonValue.toDouble": ('float',),
        "QJsonValue.toInt": ('int',),
        "QJsonValue.toObject": [(), ('dict',)],
        "QJsonValue.toString": [(), ('str',)],
        "QJsonValue.toVariant": (),
        "QJsonValue.type": (),

    # class PySide2.QtCore.QLibraryInfo:
        "QLibraryInfo.build": (),
        "QLibraryInfo.buildDate": (),
        "QLibraryInfo.isDebugBuild": (),
        "QLibraryInfo.licensedProducts": (),
        "QLibraryInfo.licensee": (),
        "QLibraryInfo.location": ('PySide2.QtCore.QLibraryInfo.LibraryLocation',),
        "QLibraryInfo.platformPluginArguments": ('str',),
        "QLibraryInfo.version": (),

    # class PySide2.QtCore.QLine:
        "QLine.__init__": [(), ('PySide2.QtCore.QLine',), ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'), ('int', 'int', 'int', 'int')],
        "QLine.__copy__": (),
        "QLine.__reduce__": (),
        "QLine.__repr__": (),
        "QLine.center": (),
        "QLine.dx": (),
        "QLine.dy": (),
        "QLine.isNull": (),
        "QLine.p1": (),
        "QLine.p2": (),
        "QLine.setLine": ('int', 'int', 'int', 'int'),
        "QLine.setP1": ('PySide2.QtCore.QPoint',),
        "QLine.setP2": ('PySide2.QtCore.QPoint',),
        "QLine.setPoints": ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'),
        "QLine.toTuple": (),
        "QLine.translate": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QLine.translated": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QLine.x1": (),
        "QLine.x2": (),
        "QLine.y1": (),
        "QLine.y2": (),

    # class PySide2.QtCore.QLineF:
        "QLineF.__init__": [(), ('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'), ('float', 'float', 'float', 'float')],
        "QLineF.__copy__": (),
        "QLineF.__reduce__": (),
        "QLineF.__repr__": (),
        "QLineF.angle": [(), ('PySide2.QtCore.QLineF',)],
        "QLineF.angleTo": ('PySide2.QtCore.QLineF',),
        "QLineF.center": (),
        "QLineF.dx": (),
        "QLineF.dy": (),
        "QLineF.fromPolar": ('float', 'float'),
        "QLineF.intersect": ('PySide2.QtCore.QLineF', 'PySide2.QtCore.QPointF'),
        "QLineF.isNull": (),
        "QLineF.length": (),
        "QLineF.normalVector": (),
        "QLineF.p1": (),
        "QLineF.p2": (),
        "QLineF.pointAt": ('float',),
        "QLineF.setAngle": ('float',),
        "QLineF.setLength": ('float',),
        "QLineF.setLine": ('float', 'float', 'float', 'float'),
        "QLineF.setP1": ('PySide2.QtCore.QPointF',),
        "QLineF.setP2": ('PySide2.QtCore.QPointF',),
        "QLineF.setPoints": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'),
        "QLineF.toLine": (),
        "QLineF.toTuple": (),
        "QLineF.translate": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QLineF.translated": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QLineF.unitVector": (),
        "QLineF.x1": (),
        "QLineF.x2": (),
        "QLineF.y1": (),
        "QLineF.y2": (),

    # class PySide2.QtCore.QLocale:
        "QLocale.__init__": [(), ('PySide2.QtCore.QLocale',), ('PySide2.QtCore.QLocale.Language', 'PySide2.QtCore.QLocale.Country'), ('PySide2.QtCore.QLocale.Language', 'PySide2.QtCore.QLocale.Script', 'PySide2.QtCore.QLocale.Country'), ('str',)],
        "QLocale.__copy__": (),
        "QLocale.amText": (),
        "QLocale.bcp47Name": (),
        "QLocale.c": (),
        "QLocale.countriesForLanguage": ('PySide2.QtCore.QLocale.Language',),
        "QLocale.country": (),
        "QLocale.countryToString": ('PySide2.QtCore.QLocale.Country',),
        "QLocale.createSeparatedList": ('typing.List[str]',),
        "QLocale.currencySymbol": ('PySide2.QtCore.QLocale.CurrencySymbolFormat',),
        "QLocale.dateFormat": ('PySide2.QtCore.QLocale.FormatType',),
        "QLocale.dateTimeFormat": ('PySide2.QtCore.QLocale.FormatType',),
        "QLocale.dayName": ('int', 'PySide2.QtCore.QLocale.FormatType'),
        "QLocale.decimalPoint": (),
        "QLocale.exponential": (),
        "QLocale.firstDayOfWeek": (),
        "QLocale.formattedDataSize": ('int', 'int', 'PySide2.QtCore.QLocale.DataSizeFormats'),
        "QLocale.groupSeparator": (),
        "QLocale.language": (),
        "QLocale.languageToString": ('PySide2.QtCore.QLocale.Language',),
        "QLocale.matchingLocales": ('PySide2.QtCore.QLocale.Language', 'PySide2.QtCore.QLocale.Script', 'PySide2.QtCore.QLocale.Country'),
        "QLocale.measurementSystem": (),
        "QLocale.monthName": ('int', 'PySide2.QtCore.QLocale.FormatType'),
        "QLocale.name": (),
        "QLocale.nativeCountryName": (),
        "QLocale.nativeLanguageName": (),
        "QLocale.negativeSign": (),
        "QLocale.numberOptions": (),
        "QLocale.percent": (),
        "QLocale.pmText": (),
        "QLocale.positiveSign": (),
        "QLocale.quoteString": ('str', 'PySide2.QtCore.QLocale.QuotationStyle'),
        "QLocale.script": (),
        "QLocale.scriptToString": ('PySide2.QtCore.QLocale.Script',),
        "QLocale.setDefault": ('PySide2.QtCore.QLocale',),
        "QLocale.setNumberOptions": ('PySide2.QtCore.QLocale.NumberOptions',),
        "QLocale.standaloneDayName": ('int', 'PySide2.QtCore.QLocale.FormatType'),
        "QLocale.standaloneMonthName": ('int', 'PySide2.QtCore.QLocale.FormatType'),
        "QLocale.swap": ('PySide2.QtCore.QLocale',),
        "QLocale.system": (),
        "QLocale.textDirection": (),
        "QLocale.timeFormat": ('PySide2.QtCore.QLocale.FormatType',),
        "QLocale.toCurrencyString": [('float', 'str'), ('float', 'str', 'int'), ('int', 'str')],
        "QLocale.toDate": [('str', 'PySide2.QtCore.QLocale.FormatType'), ('str', 'str')],
        "QLocale.toDateTime": [('str', 'PySide2.QtCore.QLocale.FormatType'), ('str', 'str')],
        "QLocale.toDouble": ('str', 'bool'),
        "QLocale.toFloat": ('str', 'bool'),
        "QLocale.toInt": ('str', 'bool'),
        "QLocale.toLongLong": ('str', 'bool'),
        "QLocale.toLower": ('str',),
        "QLocale.toShort": ('str', 'bool'),
        "QLocale.toString": [('PySide2.QtCore.QDate', 'PySide2.QtCore.QLocale.FormatType'), ('PySide2.QtCore.QDate', 'str'), ('PySide2.QtCore.QDateTime', 'PySide2.QtCore.QLocale.FormatType'), ('PySide2.QtCore.QDateTime', 'str'), ('PySide2.QtCore.QTime', 'PySide2.QtCore.QLocale.FormatType'), ('PySide2.QtCore.QTime', 'str'), ('float', 'typing.Union[str, int]', 'int'), ('int',)],
        "QLocale.toTime": [('str', 'PySide2.QtCore.QLocale.FormatType'), ('str', 'str')],
        "QLocale.toUInt": ('str', 'bool'),
        "QLocale.toULongLong": ('str', 'bool'),
        "QLocale.toUShort": ('str', 'bool'),
        "QLocale.toUpper": ('str',),
        "QLocale.uiLanguages": (),
        "QLocale.weekdays": (),
        "QLocale.zeroDigit": (),

    # class PySide2.QtCore.QLockFile:
        "QLockFile.__init__": ('str',),
        "QLockFile.error": (),
        "QLockFile.getLockInfo": ('int', 'str', 'str'),
        "QLockFile.isLocked": (),
        "QLockFile.lock": (),
        "QLockFile.removeStaleLockFile": (),
        "QLockFile.setStaleLockTime": ('int',),
        "QLockFile.staleLockTime": (),
        "QLockFile.tryLock": ('int',),
        "QLockFile.unlock": (),

    # class PySide2.QtCore.QMargins:
        "QMargins.__init__": [(), ('PySide2.QtCore.QMargins',), ('int', 'int', 'int', 'int')],
        "QMargins.__add__": [('PySide2.QtCore.QMargins',), ('int',)],
        "QMargins.__copy__": (),
        "QMargins.__iadd__": [('PySide2.QtCore.QMargins',), ('int',)],
        "QMargins.__imul__": [('float',), ('int',)],
        "QMargins.__isub__": [('PySide2.QtCore.QMargins',), ('int',)],
        "QMargins.__mul__": [('float',), ('int',)],
        "QMargins.__neg__": (),
        "QMargins.__pos__": (),
        "QMargins.__sub__": [('PySide2.QtCore.QMargins',), ('int',)],
        "QMargins.bottom": (),
        "QMargins.isNull": (),
        "QMargins.left": (),
        "QMargins.right": (),
        "QMargins.setBottom": ('int',),
        "QMargins.setLeft": ('int',),
        "QMargins.setRight": ('int',),
        "QMargins.setTop": ('int',),
        "QMargins.top": (),

    # class PySide2.QtCore.QMarginsF:
        "QMarginsF.__init__": [(), ('PySide2.QtCore.QMargins',), ('PySide2.QtCore.QMarginsF',), ('float', 'float', 'float', 'float')],
        "QMarginsF.__add__": [('PySide2.QtCore.QMarginsF',), ('float',)],
        "QMarginsF.__copy__": (),
        "QMarginsF.__iadd__": [('PySide2.QtCore.QMarginsF',), ('float',)],
        "QMarginsF.__imul__": ('float',),
        "QMarginsF.__isub__": [('PySide2.QtCore.QMarginsF',), ('float',)],
        "QMarginsF.__mul__": ('float',),
        "QMarginsF.__neg__": (),
        "QMarginsF.__pos__": (),
        "QMarginsF.__sub__": [('PySide2.QtCore.QMarginsF',), ('float',)],
        "QMarginsF.bottom": (),
        "QMarginsF.isNull": (),
        "QMarginsF.left": (),
        "QMarginsF.right": (),
        "QMarginsF.setBottom": ('float',),
        "QMarginsF.setLeft": ('float',),
        "QMarginsF.setRight": ('float',),
        "QMarginsF.setTop": ('float',),
        "QMarginsF.toMargins": (),
        "QMarginsF.top": (),

    # class PySide2.QtCore.QMessageAuthenticationCode:
        "QMessageAuthenticationCode.__init__": ('PySide2.QtCore.QCryptographicHash.Algorithm', 'PySide2.QtCore.QByteArray'),
        "QMessageAuthenticationCode.addData": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QIODevice',), ('str', 'int')],
        "QMessageAuthenticationCode.hash": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray', 'PySide2.QtCore.QCryptographicHash.Algorithm'),
        "QMessageAuthenticationCode.reset": (),
        "QMessageAuthenticationCode.result": (),
        "QMessageAuthenticationCode.setKey": ('PySide2.QtCore.QByteArray',),

    # class PySide2.QtCore.QMessageLogContext:
        "QMessageLogContext.__init__": [(), ('str', 'int', 'str', 'str')],

    # class PySide2.QtCore.QMetaClassInfo:
        "QMetaClassInfo.__init__": [(), ('PySide2.QtCore.QMetaClassInfo',)],
        "QMetaClassInfo.__copy__": (),
        "QMetaClassInfo.name": (),
        "QMetaClassInfo.value": (),

    # class PySide2.QtCore.QMetaEnum:
        "QMetaEnum.__init__": [(), ('PySide2.QtCore.QMetaEnum',)],
        "QMetaEnum.__copy__": (),
        "QMetaEnum.enumName": (),
        "QMetaEnum.isFlag": (),
        "QMetaEnum.isScoped": (),
        "QMetaEnum.isValid": (),
        "QMetaEnum.key": ('int',),
        "QMetaEnum.keyCount": (),
        "QMetaEnum.keyToValue": ('str', 'bool'),
        "QMetaEnum.keysToValue": ('str', 'bool'),
        "QMetaEnum.name": (),
        "QMetaEnum.scope": (),
        "QMetaEnum.value": ('int',),
        "QMetaEnum.valueToKey": ('int',),
        "QMetaEnum.valueToKeys": ('int',),

    # class PySide2.QtCore.QMetaMethod:
        "QMetaMethod.__init__": [(), ('PySide2.QtCore.QMetaMethod',)],
        "QMetaMethod.__copy__": (),
        "QMetaMethod.access": (),
        "QMetaMethod.enclosingMetaObject": (),
        "QMetaMethod.invoke": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'), ('PySide2.QtCore.QObject', 'PySide2.QtCore.QGenericReturnArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'), ('PySide2.QtCore.QObject', 'PySide2.QtCore.Qt.ConnectionType', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'), ('PySide2.QtCore.QObject', 'PySide2.QtCore.Qt.ConnectionType', 'PySide2.QtCore.QGenericReturnArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument')],
        "QMetaMethod.invokeOnGadget": [('int', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'), ('int', 'PySide2.QtCore.QGenericReturnArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument')],
        "QMetaMethod.isValid": (),
        "QMetaMethod.methodIndex": (),
        "QMetaMethod.methodSignature": (),
        "QMetaMethod.methodType": (),
        "QMetaMethod.name": (),
        "QMetaMethod.parameterCount": (),
        "QMetaMethod.parameterNames": (),
        "QMetaMethod.parameterType": ('int',),
        "QMetaMethod.parameterTypes": (),
        "QMetaMethod.returnType": (),
        "QMetaMethod.revision": (),
        "QMetaMethod.tag": (),
        "QMetaMethod.typeName": (),

    # class PySide2.QtCore.QMetaObject:
        "QMetaObject.__init__": (),
        "QMetaObject.cast": ('PySide2.QtCore.QObject',),
        "QMetaObject.checkConnectArgs": [('PySide2.QtCore.QMetaMethod', 'PySide2.QtCore.QMetaMethod'), ('str', 'str')],
        "QMetaObject.classInfo": ('int',),
        "QMetaObject.classInfoCount": (),
        "QMetaObject.classInfoOffset": (),
        "QMetaObject.className": (),
        "QMetaObject.connectSlotsByName": ('PySide2.QtCore.QObject',),
        "QMetaObject.constructor": ('int',),
        "QMetaObject.constructorCount": (),
        "QMetaObject.disconnect": ('PySide2.QtCore.QObject', 'int', 'PySide2.QtCore.QObject', 'int'),
        "QMetaObject.disconnectOne": ('PySide2.QtCore.QObject', 'int', 'PySide2.QtCore.QObject', 'int'),
        "QMetaObject.enumerator": ('int',),
        "QMetaObject.enumeratorCount": (),
        "QMetaObject.enumeratorOffset": (),
        "QMetaObject.indexOfClassInfo": ('str',),
        "QMetaObject.indexOfConstructor": ('str',),
        "QMetaObject.indexOfEnumerator": ('str',),
        "QMetaObject.indexOfMethod": ('str',),
        "QMetaObject.indexOfProperty": ('str',),
        "QMetaObject.indexOfSignal": ('str',),
        "QMetaObject.indexOfSlot": ('str',),
        "QMetaObject.inherits": ('PySide2.QtCore.QMetaObject',),
        "QMetaObject.invokeMethod": [('PySide2.QtCore.QObject', 'str', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'), ('PySide2.QtCore.QObject', 'str', 'PySide2.QtCore.QGenericReturnArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'), ('PySide2.QtCore.QObject', 'str', 'PySide2.QtCore.Qt.ConnectionType', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'), ('PySide2.QtCore.QObject', 'str', 'PySide2.QtCore.Qt.ConnectionType', 'PySide2.QtCore.QGenericReturnArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument')],
        "QMetaObject.method": ('int',),
        "QMetaObject.methodCount": (),
        "QMetaObject.methodOffset": (),
        "QMetaObject.newInstance": ('PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'),
        "QMetaObject.normalizedSignature": ('str',),
        "QMetaObject.normalizedType": ('str',),
        "QMetaObject.property": ('int',),
        "QMetaObject.propertyCount": (),
        "QMetaObject.propertyOffset": (),
        "QMetaObject.superClass": (),
        "QMetaObject.userProperty": (),

    # class PySide2.QtCore.QMetaObject.Connection:
        "QMetaObject.Connection.__init__": [(), ('PySide2.QtCore.QMetaObject.Connection',)],

    # class PySide2.QtCore.QMetaProperty:
        "QMetaProperty.__init__": [(), ('PySide2.QtCore.QMetaProperty',)],
        "QMetaProperty.__copy__": (),
        "QMetaProperty.enumerator": (),
        "QMetaProperty.hasNotifySignal": (),
        "QMetaProperty.hasStdCppSet": (),
        "QMetaProperty.isConstant": (),
        "QMetaProperty.isDesignable": ('PySide2.QtCore.QObject',),
        "QMetaProperty.isEditable": ('PySide2.QtCore.QObject',),
        "QMetaProperty.isEnumType": (),
        "QMetaProperty.isFinal": (),
        "QMetaProperty.isFlagType": (),
        "QMetaProperty.isReadable": (),
        "QMetaProperty.isResettable": (),
        "QMetaProperty.isScriptable": ('PySide2.QtCore.QObject',),
        "QMetaProperty.isStored": ('PySide2.QtCore.QObject',),
        "QMetaProperty.isUser": ('PySide2.QtCore.QObject',),
        "QMetaProperty.isValid": (),
        "QMetaProperty.isWritable": (),
        "QMetaProperty.name": (),
        "QMetaProperty.notifySignal": (),
        "QMetaProperty.notifySignalIndex": (),
        "QMetaProperty.propertyIndex": (),
        "QMetaProperty.read": ('PySide2.QtCore.QObject',),
        "QMetaProperty.readOnGadget": ('int',),
        "QMetaProperty.reset": ('PySide2.QtCore.QObject',),
        "QMetaProperty.resetOnGadget": ('int',),
        "QMetaProperty.revision": (),
        "QMetaProperty.type": (),
        "QMetaProperty.typeName": (),
        "QMetaProperty.userType": (),
        "QMetaProperty.write": ('PySide2.QtCore.QObject', 'typing.Any'),
        "QMetaProperty.writeOnGadget": ('int', 'typing.Any'),

    # class PySide2.QtCore.QMimeData:
        "QMimeData.__init__": (),
        "QMimeData.clear": (),
        "QMimeData.colorData": (),
        "QMimeData.data": ('str',),
        "QMimeData.formats": (),
        "QMimeData.hasColor": (),
        "QMimeData.hasFormat": ('str',),
        "QMimeData.hasHtml": (),
        "QMimeData.hasImage": (),
        "QMimeData.hasText": (),
        "QMimeData.hasUrls": (),
        "QMimeData.html": (),
        "QMimeData.imageData": (),
        "QMimeData.removeFormat": ('str',),
        "QMimeData.retrieveData": ('str', 'type'),
        "QMimeData.setColorData": ('typing.Any',),
        "QMimeData.setData": ('str', 'PySide2.QtCore.QByteArray'),
        "QMimeData.setHtml": ('str',),
        "QMimeData.setImageData": ('typing.Any',),
        "QMimeData.setText": ('str',),
        "QMimeData.setUrls": ('list',),
        "QMimeData.text": (),
        "QMimeData.urls": (),

    # class PySide2.QtCore.QMimeDatabase:
        "QMimeDatabase.__init__": (),
        "QMimeDatabase.allMimeTypes": (),
        "QMimeDatabase.mimeTypeForData": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QIODevice',)],
        "QMimeDatabase.mimeTypeForFile": [('PySide2.QtCore.QFileInfo', 'PySide2.QtCore.QMimeDatabase.MatchMode'), ('str', 'PySide2.QtCore.QMimeDatabase.MatchMode')],
        "QMimeDatabase.mimeTypeForFileNameAndData": [('str', 'PySide2.QtCore.QByteArray'), ('str', 'PySide2.QtCore.QIODevice')],
        "QMimeDatabase.mimeTypeForName": ('str',),
        "QMimeDatabase.mimeTypeForUrl": ('PySide2.QtCore.QUrl',),
        "QMimeDatabase.mimeTypesForFileName": ('str',),
        "QMimeDatabase.suffixForFileName": ('str',),

    # class PySide2.QtCore.QMimeType:
        "QMimeType.__init__": [(), ('PySide2.QtCore.QMimeType',)],
        "QMimeType.__copy__": (),
        "QMimeType.aliases": (),
        "QMimeType.allAncestors": (),
        "QMimeType.comment": (),
        "QMimeType.filterString": (),
        "QMimeType.genericIconName": (),
        "QMimeType.globPatterns": (),
        "QMimeType.iconName": (),
        "QMimeType.inherits": ('str',),
        "QMimeType.isDefault": (),
        "QMimeType.isValid": (),
        "QMimeType.name": (),
        "QMimeType.parentMimeTypes": (),
        "QMimeType.preferredSuffix": (),
        "QMimeType.suffixes": (),
        "QMimeType.swap": ('PySide2.QtCore.QMimeType',),

    # class PySide2.QtCore.QModelIndex:
        "QModelIndex.__init__": [(), ('PySide2.QtCore.QModelIndex',)],
        "QModelIndex.__copy__": (),
        "QModelIndex.child": ('int', 'int'),
        "QModelIndex.column": (),
        "QModelIndex.data": ('int',),
        "QModelIndex.flags": (),
        "QModelIndex.internalId": (),
        "QModelIndex.internalPointer": (),
        "QModelIndex.isValid": (),
        "QModelIndex.model": (),
        "QModelIndex.parent": (),
        "QModelIndex.row": (),
        "QModelIndex.sibling": ('int', 'int'),
        "QModelIndex.siblingAtColumn": ('int',),
        "QModelIndex.siblingAtRow": ('int',),

    # class PySide2.QtCore.QMutex:
        "QMutex.__init__": ('PySide2.QtCore.QMutex.RecursionMode',),
        "QMutex.isRecursive": (),
        "QMutex.lock": (),
        "QMutex.tryLock": [(), ('int',)],
        "QMutex.try_lock": (),
        "QMutex.unlock": (),

    # class PySide2.QtCore.QMutexLocker:
        "QMutexLocker.__init__": ('PySide2.QtCore.QBasicMutex',),
        "QMutexLocker.__enter__": (),
        "QMutexLocker.__exit__": ('object', 'object', 'object'),
        "QMutexLocker.mutex": (),
        "QMutexLocker.relock": (),
        "QMutexLocker.unlock": (),

    # class PySide2.QtCore.QObject:
        "QObject.__init__": ('PySide2.QtCore.QObject',),
        "QObject.blockSignals": ('bool',),
        "QObject.childEvent": ('PySide2.QtCore.QChildEvent',),
        "QObject.children": (),
        "QObject.connect": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QMetaMethod', 'PySide2.QtCore.QObject', 'PySide2.QtCore.QMetaMethod', 'PySide2.QtCore.Qt.ConnectionType'), ('PySide2.QtCore.QObject', 'str', 'PySide2.QtCore.QObject', 'str', 'PySide2.QtCore.Qt.ConnectionType'), ('PySide2.QtCore.QObject', 'str', 'str', 'PySide2.QtCore.Qt.ConnectionType'), ('PySide2.QtCore.QObject', 'str', 'typing.Callable', 'PySide2.QtCore.Qt.ConnectionType'), ('str', 'PySide2.QtCore.QObject', 'str', 'PySide2.QtCore.Qt.ConnectionType'), ('str', 'typing.Callable', 'PySide2.QtCore.Qt.ConnectionType')],
        "QObject.connectNotify": ('PySide2.QtCore.QMetaMethod',),
        "QObject.customEvent": ('PySide2.QtCore.QEvent',),
        "QObject.deleteLater": (),
        "QObject.disconnect": [('PySide2.QtCore.QMetaObject.Connection',), ('PySide2.QtCore.QObject', 'PySide2.QtCore.QMetaMethod', 'PySide2.QtCore.QObject', 'PySide2.QtCore.QMetaMethod'), ('PySide2.QtCore.QObject', 'str'), ('PySide2.QtCore.QObject', 'str', 'PySide2.QtCore.QObject', 'str'), ('PySide2.QtCore.QObject', 'str', 'typing.Callable'), ('str', 'PySide2.QtCore.QObject', 'str'), ('str', 'typing.Callable')],
        "QObject.disconnectNotify": ('PySide2.QtCore.QMetaMethod',),
        "QObject.dumpObjectInfo": (),
        "QObject.dumpObjectTree": (),
        "QObject.dynamicPropertyNames": (),
        "QObject.emit": ('str', '*args'),
        "QObject.event": ('PySide2.QtCore.QEvent',),
        "QObject.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QObject.findChild": ('type', 'str'),
        "QObject.findChildren": [('type', 'PySide2.QtCore.QRegExp'), ('type', 'str')],
        "QObject.inherits": ('str',),
        "QObject.installEventFilter": ('PySide2.QtCore.QObject',),
        "QObject.isSignalConnected": ('PySide2.QtCore.QMetaMethod',),
        "QObject.isWidgetType": (),
        "QObject.isWindowType": (),
        "QObject.killTimer": ('int',),
        "QObject.metaObject": (),
        "QObject.moveToThread": ('PySide2.QtCore.QThread',),
        "QObject.objectName": (),
        "QObject.parent": (),
        "QObject.property": ('str',),
        "QObject.receivers": ('str',),
        "QObject.registerUserData": (),
        "QObject.removeEventFilter": ('PySide2.QtCore.QObject',),
        "QObject.sender": (),
        "QObject.senderSignalIndex": (),
        "QObject.setObjectName": ('str',),
        "QObject.setParent": ('PySide2.QtCore.QObject',),
        "QObject.setProperty": ('str', 'typing.Any'),
        "QObject.signalsBlocked": (),
        "QObject.startTimer": ('int', 'PySide2.QtCore.Qt.TimerType'),
        "QObject.thread": (),
        "QObject.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QObject.tr": ('str', 'str', 'int'),

    # class PySide2.QtCore.QOperatingSystemVersion:
        "QOperatingSystemVersion.__init__": [('PySide2.QtCore.QOperatingSystemVersion',), ('PySide2.QtCore.QOperatingSystemVersion.OSType', 'int', 'int', 'int')],
        "QOperatingSystemVersion.__copy__": (),
        "QOperatingSystemVersion.current": (),
        "QOperatingSystemVersion.currentType": (),
        "QOperatingSystemVersion.majorVersion": (),
        "QOperatingSystemVersion.microVersion": (),
        "QOperatingSystemVersion.minorVersion": (),
        "QOperatingSystemVersion.name": (),
        "QOperatingSystemVersion.segmentCount": (),
        "QOperatingSystemVersion.type": (),

    # class PySide2.QtCore.QParallelAnimationGroup:
        "QParallelAnimationGroup.__init__": ('PySide2.QtCore.QObject',),
        "QParallelAnimationGroup.duration": (),
        "QParallelAnimationGroup.event": ('PySide2.QtCore.QEvent',),
        "QParallelAnimationGroup.updateCurrentTime": ('int',),
        "QParallelAnimationGroup.updateDirection": ('PySide2.QtCore.QAbstractAnimation.Direction',),
        "QParallelAnimationGroup.updateState": ('PySide2.QtCore.QAbstractAnimation.State', 'PySide2.QtCore.QAbstractAnimation.State'),

    # class PySide2.QtCore.QPauseAnimation:
        "QPauseAnimation.__init__": [('PySide2.QtCore.QObject',), ('int', 'PySide2.QtCore.QObject')],
        "QPauseAnimation.duration": (),
        "QPauseAnimation.event": ('PySide2.QtCore.QEvent',),
        "QPauseAnimation.setDuration": ('int',),
        "QPauseAnimation.updateCurrentTime": ('int',),

    # class PySide2.QtCore.QPersistentModelIndex:
        "QPersistentModelIndex.__init__": [(), ('PySide2.QtCore.QModelIndex',), ('PySide2.QtCore.QPersistentModelIndex',)],
        "QPersistentModelIndex.__copy__": (),
        "QPersistentModelIndex.child": ('int', 'int'),
        "QPersistentModelIndex.column": (),
        "QPersistentModelIndex.data": ('int',),
        "QPersistentModelIndex.flags": (),
        "QPersistentModelIndex.internalId": (),
        "QPersistentModelIndex.internalPointer": (),
        "QPersistentModelIndex.isValid": (),
        "QPersistentModelIndex.model": (),
        "QPersistentModelIndex.parent": (),
        "QPersistentModelIndex.row": (),
        "QPersistentModelIndex.sibling": ('int', 'int'),
        "QPersistentModelIndex.swap": ('PySide2.QtCore.QPersistentModelIndex',),

    # class PySide2.QtCore.QPluginLoader:
        "QPluginLoader.__init__": [('PySide2.QtCore.QObject',), ('str', 'PySide2.QtCore.QObject')],
        "QPluginLoader.errorString": (),
        "QPluginLoader.fileName": (),
        "QPluginLoader.instance": (),
        "QPluginLoader.isLoaded": (),
        "QPluginLoader.load": (),
        "QPluginLoader.metaData": (),
        "QPluginLoader.setFileName": ('str',),
        "QPluginLoader.staticInstances": (),
        "QPluginLoader.unload": (),

    # class PySide2.QtCore.QPoint:
        "QPoint.__init__": [(), ('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QPoint.__add__": ('PySide2.QtCore.QPoint',),
        "QPoint.__copy__": (),
        "QPoint.__iadd__": ('PySide2.QtCore.QPoint',),
        "QPoint.__imul__": [('float',), ('int',)],
        "QPoint.__isub__": ('PySide2.QtCore.QPoint',),
        "QPoint.__mul__": [('float',), ('int',)],
        "QPoint.__neg__": (),
        "QPoint.__pos__": (),
        "QPoint.__reduce__": (),
        "QPoint.__repr__": (),
        "QPoint.__sub__": ('PySide2.QtCore.QPoint',),
        "QPoint.dotProduct": ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'),
        "QPoint.isNull": (),
        "QPoint.manhattanLength": (),
        "QPoint.setX": ('int',),
        "QPoint.setY": ('int',),
        "QPoint.toTuple": (),
        "QPoint.x": (),
        "QPoint.y": (),

    # class PySide2.QtCore.QPointF:
        "QPointF.__init__": [(), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QPointF.__add__": ('PySide2.QtCore.QPointF',),
        "QPointF.__copy__": (),
        "QPointF.__iadd__": ('PySide2.QtCore.QPointF',),
        "QPointF.__imul__": ('float',),
        "QPointF.__isub__": ('PySide2.QtCore.QPointF',),
        "QPointF.__mul__": ('float',),
        "QPointF.__neg__": (),
        "QPointF.__pos__": (),
        "QPointF.__reduce__": (),
        "QPointF.__repr__": (),
        "QPointF.__sub__": ('PySide2.QtCore.QPointF',),
        "QPointF.dotProduct": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'),
        "QPointF.isNull": (),
        "QPointF.manhattanLength": (),
        "QPointF.setX": ('float',),
        "QPointF.setY": ('float',),
        "QPointF.toPoint": (),
        "QPointF.toTuple": (),
        "QPointF.x": (),
        "QPointF.y": (),

    # class PySide2.QtCore.QProcess:
        "QProcess.__init__": ('PySide2.QtCore.QObject',),
        "QProcess.arguments": (),
        "QProcess.atEnd": (),
        "QProcess.bytesAvailable": (),
        "QProcess.bytesToWrite": (),
        "QProcess.canReadLine": (),
        "QProcess.close": (),
        "QProcess.closeReadChannel": ('PySide2.QtCore.QProcess.ProcessChannel',),
        "QProcess.closeWriteChannel": (),
        "QProcess.environment": (),
        "QProcess.error": (),
        "QProcess.execute": [('str',), ('str', 'typing.List[str]')],
        "QProcess.exitCode": (),
        "QProcess.exitStatus": (),
        "QProcess.inputChannelMode": (),
        "QProcess.isSequential": (),
        "QProcess.kill": (),
        "QProcess.nullDevice": (),
        "QProcess.open": ('PySide2.QtCore.QIODevice.OpenMode',),
        "QProcess.pid": (),
        "QProcess.processChannelMode": (),
        "QProcess.processEnvironment": (),
        "QProcess.processId": (),
        "QProcess.program": (),
        "QProcess.readAllStandardError": (),
        "QProcess.readAllStandardOutput": (),
        "QProcess.readChannel": (),
        "QProcess.readData": ('str', 'int'),
        "QProcess.setArguments": ('typing.List[str]',),
        "QProcess.setEnvironment": ('typing.List[str]',),
        "QProcess.setInputChannelMode": ('PySide2.QtCore.QProcess.InputChannelMode',),
        "QProcess.setProcessChannelMode": ('PySide2.QtCore.QProcess.ProcessChannelMode',),
        "QProcess.setProcessEnvironment": ('PySide2.QtCore.QProcessEnvironment',),
        "QProcess.setProcessState": ('PySide2.QtCore.QProcess.ProcessState',),
        "QProcess.setProgram": ('str',),
        "QProcess.setReadChannel": ('PySide2.QtCore.QProcess.ProcessChannel',),
        "QProcess.setStandardErrorFile": ('str', 'PySide2.QtCore.QIODevice.OpenMode'),
        "QProcess.setStandardInputFile": ('str',),
        "QProcess.setStandardOutputFile": ('str', 'PySide2.QtCore.QIODevice.OpenMode'),
        "QProcess.setStandardOutputProcess": ('PySide2.QtCore.QProcess',),
        "QProcess.setWorkingDirectory": ('str',),
        "QProcess.setupChildProcess": (),
        "QProcess.start": [('PySide2.QtCore.QIODevice.OpenMode',), ('str', 'PySide2.QtCore.QIODevice.OpenMode'), ('str', 'typing.List[str]', 'PySide2.QtCore.QIODevice.OpenMode')],
        "QProcess.startDetached": [('int',), ('str',), ('str', 'typing.List[str]'), ('str', 'typing.List[str]', 'str', 'int')],
        "QProcess.state": (),
        "QProcess.systemEnvironment": (),
        "QProcess.terminate": (),
        "QProcess.waitForBytesWritten": ('int',),
        "QProcess.waitForFinished": ('int',),
        "QProcess.waitForReadyRead": ('int',),
        "QProcess.waitForStarted": ('int',),
        "QProcess.workingDirectory": (),
        "QProcess.writeData": ('str', 'int'),

    # class PySide2.QtCore.QProcessEnvironment:
        "QProcessEnvironment.__init__": [(), ('PySide2.QtCore.QProcessEnvironment',)],
        "QProcessEnvironment.__copy__": (),
        "QProcessEnvironment.clear": (),
        "QProcessEnvironment.contains": ('str',),
        "QProcessEnvironment.insert": [('PySide2.QtCore.QProcessEnvironment',), ('str', 'str')],
        "QProcessEnvironment.isEmpty": (),
        "QProcessEnvironment.keys": (),
        "QProcessEnvironment.remove": ('str',),
        "QProcessEnvironment.swap": ('PySide2.QtCore.QProcessEnvironment',),
        "QProcessEnvironment.systemEnvironment": (),
        "QProcessEnvironment.toStringList": (),
        "QProcessEnvironment.value": ('str', 'str'),

    # class PySide2.QtCore.QPropertyAnimation:
        "QPropertyAnimation.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtCore.QObject', 'PySide2.QtCore.QByteArray', 'PySide2.QtCore.QObject')],
        "QPropertyAnimation.event": ('PySide2.QtCore.QEvent',),
        "QPropertyAnimation.propertyName": (),
        "QPropertyAnimation.setPropertyName": ('PySide2.QtCore.QByteArray',),
        "QPropertyAnimation.setTargetObject": ('PySide2.QtCore.QObject',),
        "QPropertyAnimation.targetObject": (),
        "QPropertyAnimation.updateCurrentValue": ('typing.Any',),
        "QPropertyAnimation.updateState": ('PySide2.QtCore.QAbstractAnimation.State', 'PySide2.QtCore.QAbstractAnimation.State'),

    # class PySide2.QtCore.QRandomGenerator:
        "QRandomGenerator.__init__": [('PySide2.QtCore.QRandomGenerator',), ('int',), ('int', 'int')],
        "QRandomGenerator.bounded": [('float',), ('int',), ('int', 'int')],
        "QRandomGenerator.discard": ('int',),
        "QRandomGenerator.generate": [(), ('int', 'int')],
        "QRandomGenerator.generate64": (),
        "QRandomGenerator.generateDouble": (),
        "QRandomGenerator.global_": (),
        "QRandomGenerator.max": (),
        "QRandomGenerator.min": (),
        "QRandomGenerator.securelySeeded": (),
        "QRandomGenerator.seed": ('int',),
        "QRandomGenerator.system": (),

    # class PySide2.QtCore.QRandomGenerator64:
        "QRandomGenerator64.__init__": [('PySide2.QtCore.QRandomGenerator',), ('int',), ('int', 'int')],
        "QRandomGenerator64.discard": ('int',),
        "QRandomGenerator64.generate": (),
        "QRandomGenerator64.global_": (),
        "QRandomGenerator64.max": (),
        "QRandomGenerator64.min": (),
        "QRandomGenerator64.securelySeeded": (),
        "QRandomGenerator64.system": (),

    # class PySide2.QtCore.QReadLocker:
        "QReadLocker.__init__": ('PySide2.QtCore.QReadWriteLock',),
        "QReadLocker.__enter__": (),
        "QReadLocker.__exit__": ('object', 'object', 'object'),
        "QReadLocker.readWriteLock": (),
        "QReadLocker.relock": (),
        "QReadLocker.unlock": (),

    # class PySide2.QtCore.QReadWriteLock:
        "QReadWriteLock.__init__": ('PySide2.QtCore.QReadWriteLock.RecursionMode',),
        "QReadWriteLock.lockForRead": (),
        "QReadWriteLock.lockForWrite": (),
        "QReadWriteLock.tryLockForRead": [(), ('int',)],
        "QReadWriteLock.tryLockForWrite": [(), ('int',)],
        "QReadWriteLock.unlock": (),

    # class PySide2.QtCore.QRect:
        "QRect.__init__": [(), ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'), ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QSize'), ('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
        "QRect.__add__": ('PySide2.QtCore.QMargins',),
        "QRect.__and__": ('PySide2.QtCore.QRect',),
        "QRect.__copy__": (),
        "QRect.__iadd__": ('PySide2.QtCore.QMargins',),
        "QRect.__iand__": ('PySide2.QtCore.QRect',),
        "QRect.__ior__": ('PySide2.QtCore.QRect',),
        "QRect.__isub__": ('PySide2.QtCore.QMargins',),
        "QRect.__or__": ('PySide2.QtCore.QRect',),
        "QRect.__reduce__": (),
        "QRect.__repr__": (),
        "QRect.__sub__": ('PySide2.QtCore.QMargins',),
        "QRect.adjust": ('int', 'int', 'int', 'int'),
        "QRect.adjusted": ('int', 'int', 'int', 'int'),
        "QRect.bottom": (),
        "QRect.bottomLeft": (),
        "QRect.bottomRight": (),
        "QRect.center": (),
        "QRect.contains": [('PySide2.QtCore.QPoint', 'bool'), ('PySide2.QtCore.QRect', 'bool'), ('int', 'int'), ('int', 'int', 'bool')],
        "QRect.getCoords": ('int', 'int', 'int', 'int'),
        "QRect.getRect": ('int', 'int', 'int', 'int'),
        "QRect.height": (),
        "QRect.intersected": ('PySide2.QtCore.QRect',),
        "QRect.intersects": ('PySide2.QtCore.QRect',),
        "QRect.isEmpty": (),
        "QRect.isNull": (),
        "QRect.isValid": (),
        "QRect.left": (),
        "QRect.marginsAdded": ('PySide2.QtCore.QMargins',),
        "QRect.marginsRemoved": ('PySide2.QtCore.QMargins',),
        "QRect.moveBottom": ('int',),
        "QRect.moveBottomLeft": ('PySide2.QtCore.QPoint',),
        "QRect.moveBottomRight": ('PySide2.QtCore.QPoint',),
        "QRect.moveCenter": ('PySide2.QtCore.QPoint',),
        "QRect.moveLeft": ('int',),
        "QRect.moveRight": ('int',),
        "QRect.moveTo": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QRect.moveTop": ('int',),
        "QRect.moveTopLeft": ('PySide2.QtCore.QPoint',),
        "QRect.moveTopRight": ('PySide2.QtCore.QPoint',),
        "QRect.normalized": (),
        "QRect.right": (),
        "QRect.setBottom": ('int',),
        "QRect.setBottomLeft": ('PySide2.QtCore.QPoint',),
        "QRect.setBottomRight": ('PySide2.QtCore.QPoint',),
        "QRect.setCoords": ('int', 'int', 'int', 'int'),
        "QRect.setHeight": ('int',),
        "QRect.setLeft": ('int',),
        "QRect.setRect": ('int', 'int', 'int', 'int'),
        "QRect.setRight": ('int',),
        "QRect.setSize": ('PySide2.QtCore.QSize',),
        "QRect.setTop": ('int',),
        "QRect.setTopLeft": ('PySide2.QtCore.QPoint',),
        "QRect.setTopRight": ('PySide2.QtCore.QPoint',),
        "QRect.setWidth": ('int',),
        "QRect.setX": ('int',),
        "QRect.setY": ('int',),
        "QRect.size": (),
        "QRect.top": (),
        "QRect.topLeft": (),
        "QRect.topRight": (),
        "QRect.translate": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QRect.translated": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QRect.transposed": (),
        "QRect.united": ('PySide2.QtCore.QRect',),
        "QRect.width": (),
        "QRect.x": (),
        "QRect.y": (),

    # class PySide2.QtCore.QRectF:
        "QRectF.__init__": [(), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QSizeF'), ('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
        "QRectF.__add__": ('PySide2.QtCore.QMarginsF',),
        "QRectF.__and__": ('PySide2.QtCore.QRectF',),
        "QRectF.__copy__": (),
        "QRectF.__iadd__": ('PySide2.QtCore.QMarginsF',),
        "QRectF.__iand__": ('PySide2.QtCore.QRectF',),
        "QRectF.__ior__": ('PySide2.QtCore.QRectF',),
        "QRectF.__isub__": ('PySide2.QtCore.QMarginsF',),
        "QRectF.__or__": ('PySide2.QtCore.QRectF',),
        "QRectF.__reduce__": (),
        "QRectF.__repr__": (),
        "QRectF.__sub__": ('PySide2.QtCore.QMarginsF',),
        "QRectF.adjust": ('float', 'float', 'float', 'float'),
        "QRectF.adjusted": ('float', 'float', 'float', 'float'),
        "QRectF.bottom": (),
        "QRectF.bottomLeft": (),
        "QRectF.bottomRight": (),
        "QRectF.center": (),
        "QRectF.contains": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRectF',), ('float', 'float')],
        "QRectF.getCoords": ('float', 'float', 'float', 'float'),
        "QRectF.getRect": ('float', 'float', 'float', 'float'),
        "QRectF.height": (),
        "QRectF.intersected": ('PySide2.QtCore.QRectF',),
        "QRectF.intersects": ('PySide2.QtCore.QRectF',),
        "QRectF.isEmpty": (),
        "QRectF.isNull": (),
        "QRectF.isValid": (),
        "QRectF.left": (),
        "QRectF.marginsAdded": ('PySide2.QtCore.QMarginsF',),
        "QRectF.marginsRemoved": ('PySide2.QtCore.QMarginsF',),
        "QRectF.moveBottom": ('float',),
        "QRectF.moveBottomLeft": ('PySide2.QtCore.QPointF',),
        "QRectF.moveBottomRight": ('PySide2.QtCore.QPointF',),
        "QRectF.moveCenter": ('PySide2.QtCore.QPointF',),
        "QRectF.moveLeft": ('float',),
        "QRectF.moveRight": ('float',),
        "QRectF.moveTo": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QRectF.moveTop": ('float',),
        "QRectF.moveTopLeft": ('PySide2.QtCore.QPointF',),
        "QRectF.moveTopRight": ('PySide2.QtCore.QPointF',),
        "QRectF.normalized": (),
        "QRectF.right": (),
        "QRectF.setBottom": ('float',),
        "QRectF.setBottomLeft": ('PySide2.QtCore.QPointF',),
        "QRectF.setBottomRight": ('PySide2.QtCore.QPointF',),
        "QRectF.setCoords": ('float', 'float', 'float', 'float'),
        "QRectF.setHeight": ('float',),
        "QRectF.setLeft": ('float',),
        "QRectF.setRect": ('float', 'float', 'float', 'float'),
        "QRectF.setRight": ('float',),
        "QRectF.setSize": ('PySide2.QtCore.QSizeF',),
        "QRectF.setTop": ('float',),
        "QRectF.setTopLeft": ('PySide2.QtCore.QPointF',),
        "QRectF.setTopRight": ('PySide2.QtCore.QPointF',),
        "QRectF.setWidth": ('float',),
        "QRectF.setX": ('float',),
        "QRectF.setY": ('float',),
        "QRectF.size": (),
        "QRectF.toAlignedRect": (),
        "QRectF.toRect": (),
        "QRectF.top": (),
        "QRectF.topLeft": (),
        "QRectF.topRight": (),
        "QRectF.translate": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QRectF.translated": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QRectF.transposed": (),
        "QRectF.united": ('PySide2.QtCore.QRectF',),
        "QRectF.width": (),
        "QRectF.x": (),
        "QRectF.y": (),

    # class PySide2.QtCore.QRegExp:
        "QRegExp.__init__": [(), ('PySide2.QtCore.QRegExp',), ('str', 'PySide2.QtCore.Qt.CaseSensitivity', 'PySide2.QtCore.QRegExp.PatternSyntax')],
        "QRegExp.__copy__": (),
        "QRegExp.__reduce__": (),
        "QRegExp.__repr__": (),
        "QRegExp.cap": ('int',),
        "QRegExp.captureCount": (),
        "QRegExp.capturedTexts": (),
        "QRegExp.caseSensitivity": (),
        "QRegExp.errorString": (),
        "QRegExp.escape": ('str',),
        "QRegExp.exactMatch": ('str',),
        "QRegExp.indexIn": ('str', 'int', 'PySide2.QtCore.QRegExp.CaretMode'),
        "QRegExp.isEmpty": (),
        "QRegExp.isMinimal": (),
        "QRegExp.isValid": (),
        "QRegExp.lastIndexIn": ('str', 'int', 'PySide2.QtCore.QRegExp.CaretMode'),
        "QRegExp.matchedLength": (),
        "QRegExp.pattern": (),
        "QRegExp.patternSyntax": (),
        "QRegExp.pos": ('int',),
        "QRegExp.replace": ('str', 'str'),
        "QRegExp.setCaseSensitivity": ('PySide2.QtCore.Qt.CaseSensitivity',),
        "QRegExp.setMinimal": ('bool',),
        "QRegExp.setPattern": ('str',),
        "QRegExp.setPatternSyntax": ('PySide2.QtCore.QRegExp.PatternSyntax',),
        "QRegExp.swap": ('PySide2.QtCore.QRegExp',),

    # class PySide2.QtCore.QRegularExpression:
        "QRegularExpression.__init__": [(), ('PySide2.QtCore.QRegularExpression',), ('str', 'PySide2.QtCore.QRegularExpression.PatternOptions')],
        "QRegularExpression.__copy__": (),
        "QRegularExpression.anchoredPattern": ('str',),
        "QRegularExpression.captureCount": (),
        "QRegularExpression.errorString": (),
        "QRegularExpression.escape": ('str',),
        "QRegularExpression.globalMatch": ('str', 'int', 'PySide2.QtCore.QRegularExpression.MatchType', 'PySide2.QtCore.QRegularExpression.MatchOptions'),
        "QRegularExpression.isValid": (),
        "QRegularExpression.match": ('str', 'int', 'PySide2.QtCore.QRegularExpression.MatchType', 'PySide2.QtCore.QRegularExpression.MatchOptions'),
        "QRegularExpression.namedCaptureGroups": (),
        "QRegularExpression.optimize": (),
        "QRegularExpression.pattern": (),
        "QRegularExpression.patternErrorOffset": (),
        "QRegularExpression.patternOptions": (),
        "QRegularExpression.setPattern": ('str',),
        "QRegularExpression.setPatternOptions": ('PySide2.QtCore.QRegularExpression.PatternOptions',),
        "QRegularExpression.swap": ('PySide2.QtCore.QRegularExpression',),
        "QRegularExpression.wildcardToRegularExpression": ('str',),

    # class PySide2.QtCore.QRegularExpressionMatch:
        "QRegularExpressionMatch.__init__": [(), ('PySide2.QtCore.QRegularExpressionMatch',)],
        "QRegularExpressionMatch.__copy__": (),
        "QRegularExpressionMatch.captured": [('int',), ('str',)],
        "QRegularExpressionMatch.capturedEnd": [('int',), ('str',)],
        "QRegularExpressionMatch.capturedLength": [('int',), ('str',)],
        "QRegularExpressionMatch.capturedRef": [('int',), ('str',)],
        "QRegularExpressionMatch.capturedStart": [('int',), ('str',)],
        "QRegularExpressionMatch.capturedTexts": (),
        "QRegularExpressionMatch.hasMatch": (),
        "QRegularExpressionMatch.hasPartialMatch": (),
        "QRegularExpressionMatch.isValid": (),
        "QRegularExpressionMatch.lastCapturedIndex": (),
        "QRegularExpressionMatch.matchOptions": (),
        "QRegularExpressionMatch.matchType": (),
        "QRegularExpressionMatch.regularExpression": (),
        "QRegularExpressionMatch.swap": ('PySide2.QtCore.QRegularExpressionMatch',),

    # class PySide2.QtCore.QRegularExpressionMatchIterator:
        "QRegularExpressionMatchIterator.__init__": [(), ('PySide2.QtCore.QRegularExpressionMatchIterator',)],
        "QRegularExpressionMatchIterator.__copy__": (),
        "QRegularExpressionMatchIterator.hasNext": (),
        "QRegularExpressionMatchIterator.isValid": (),
        "QRegularExpressionMatchIterator.matchOptions": (),
        "QRegularExpressionMatchIterator.matchType": (),
        "QRegularExpressionMatchIterator.peekNext": (),
        "QRegularExpressionMatchIterator.regularExpression": (),
        "QRegularExpressionMatchIterator.swap": ('PySide2.QtCore.QRegularExpressionMatchIterator',),

    # class PySide2.QtCore.QResource:
        "QResource.__init__": ('str', 'PySide2.QtCore.QLocale'),
        "QResource.absoluteFilePath": (),
        "QResource.addSearchPath": ('str',),
        "QResource.children": (),
        "QResource.data": (),
        "QResource.fileName": (),
        "QResource.isCompressed": (),
        "QResource.isDir": (),
        "QResource.isFile": (),
        "QResource.isValid": (),
        "QResource.lastModified": (),
        "QResource.locale": (),
        "QResource.registerResource": ('str', 'str'),
        "QResource.registerResourceData": ('typing.Union[str, int]', 'str'),
        "QResource.searchPaths": (),
        "QResource.setFileName": ('str',),
        "QResource.setLocale": ('PySide2.QtCore.QLocale',),
        "QResource.size": (),
        "QResource.unregisterResource": ('str', 'str'),
        "QResource.unregisterResourceData": ('typing.Union[str, int]', 'str'),

    # class PySide2.QtCore.QRunnable:
        "QRunnable.__init__": (),
        "QRunnable.autoDelete": (),
        "QRunnable.run": (),
        "QRunnable.setAutoDelete": ('bool',),

    # class PySide2.QtCore.QSaveFile:
        "QSaveFile.__init__": [('PySide2.QtCore.QObject',), ('str',), ('str', 'PySide2.QtCore.QObject')],
        "QSaveFile.cancelWriting": (),
        "QSaveFile.close": (),
        "QSaveFile.commit": (),
        "QSaveFile.directWriteFallback": (),
        "QSaveFile.fileName": (),
        "QSaveFile.open": ('PySide2.QtCore.QIODevice.OpenMode',),
        "QSaveFile.setDirectWriteFallback": ('bool',),
        "QSaveFile.setFileName": ('str',),
        "QSaveFile.writeData": ('str', 'int'),

    # class PySide2.QtCore.QSemaphore:
        "QSemaphore.__init__": ('int',),
        "QSemaphore.acquire": ('int',),
        "QSemaphore.available": (),
        "QSemaphore.release": ('int',),
        "QSemaphore.tryAcquire": [('int',), ('int', 'int')],

    # class PySide2.QtCore.QSemaphoreReleaser:
        "QSemaphoreReleaser.__init__": [(), ('PySide2.QtCore.QSemaphore', 'int')],
        "QSemaphoreReleaser.cancel": (),
        "QSemaphoreReleaser.semaphore": (),
        "QSemaphoreReleaser.swap": ('PySide2.QtCore.QSemaphoreReleaser',),

    # class PySide2.QtCore.QSequentialAnimationGroup:
        "QSequentialAnimationGroup.__init__": ('PySide2.QtCore.QObject',),
        "QSequentialAnimationGroup.addPause": ('int',),
        "QSequentialAnimationGroup.currentAnimation": (),
        "QSequentialAnimationGroup.duration": (),
        "QSequentialAnimationGroup.event": ('PySide2.QtCore.QEvent',),
        "QSequentialAnimationGroup.insertPause": ('int', 'int'),
        "QSequentialAnimationGroup.updateCurrentTime": ('int',),
        "QSequentialAnimationGroup.updateDirection": ('PySide2.QtCore.QAbstractAnimation.Direction',),
        "QSequentialAnimationGroup.updateState": ('PySide2.QtCore.QAbstractAnimation.State', 'PySide2.QtCore.QAbstractAnimation.State'),

    # class PySide2.QtCore.QSettings:
        "QSettings.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtCore.QSettings.Format', 'PySide2.QtCore.QSettings.Scope', 'str', 'str', 'PySide2.QtCore.QObject'), ('PySide2.QtCore.QSettings.Scope', 'str', 'str', 'PySide2.QtCore.QObject'), ('str', 'PySide2.QtCore.QSettings.Format', 'PySide2.QtCore.QObject'), ('str', 'str', 'PySide2.QtCore.QObject')],
        "QSettings.allKeys": (),
        "QSettings.applicationName": (),
        "QSettings.beginGroup": ('str',),
        "QSettings.beginReadArray": ('str',),
        "QSettings.beginWriteArray": ('str', 'int'),
        "QSettings.childGroups": (),
        "QSettings.childKeys": (),
        "QSettings.clear": (),
        "QSettings.contains": ('str',),
        "QSettings.defaultFormat": (),
        "QSettings.endArray": (),
        "QSettings.endGroup": (),
        "QSettings.event": ('PySide2.QtCore.QEvent',),
        "QSettings.fallbacksEnabled": (),
        "QSettings.fileName": (),
        "QSettings.format": (),
        "QSettings.group": (),
        "QSettings.iniCodec": (),
        "QSettings.isAtomicSyncRequired": (),
        "QSettings.isWritable": (),
        "QSettings.organizationName": (),
        "QSettings.remove": ('str',),
        "QSettings.scope": (),
        "QSettings.setArrayIndex": ('int',),
        "QSettings.setAtomicSyncRequired": ('bool',),
        "QSettings.setDefaultFormat": ('PySide2.QtCore.QSettings.Format',),
        "QSettings.setFallbacksEnabled": ('bool',),
        "QSettings.setIniCodec": [('PySide2.QtCore.QTextCodec',), ('str',)],
        "QSettings.setPath": ('PySide2.QtCore.QSettings.Format', 'PySide2.QtCore.QSettings.Scope', 'str'),
        "QSettings.setValue": ('str', 'typing.Any'),
        "QSettings.status": (),
        "QSettings.sync": (),
        "QSettings.value": ('str', 'typing.Any'),

    # class PySide2.QtCore.QSignalBlocker:
        "QSignalBlocker.__init__": ('PySide2.QtCore.QObject',),
        "QSignalBlocker.reblock": (),
        "QSignalBlocker.unblock": (),

    # class PySide2.QtCore.QSignalMapper:
        "QSignalMapper.__init__": ('PySide2.QtCore.QObject',),
        "QSignalMapper.map": [(), ('PySide2.QtCore.QObject',)],
        "QSignalMapper.mapping": [('PySide2.QtCore.QObject',), ('int',), ('str',)],
        "QSignalMapper.removeMappings": ('PySide2.QtCore.QObject',),
        "QSignalMapper.setMapping": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QObject'), ('PySide2.QtCore.QObject', 'int'), ('PySide2.QtCore.QObject', 'str')],

    # class PySide2.QtCore.QSignalTransition:
        "QSignalTransition.__init__": [('PySide2.QtCore.QObject', 'str', 'PySide2.QtCore.QState'), ('PySide2.QtCore.QState',), ('object', 'PySide2.QtCore.QState')],
        "QSignalTransition.event": ('PySide2.QtCore.QEvent',),
        "QSignalTransition.eventTest": ('PySide2.QtCore.QEvent',),
        "QSignalTransition.onTransition": ('PySide2.QtCore.QEvent',),
        "QSignalTransition.senderObject": (),
        "QSignalTransition.setSenderObject": ('PySide2.QtCore.QObject',),
        "QSignalTransition.setSignal": ('PySide2.QtCore.QByteArray',),
        "QSignalTransition.signal": (),

    # class PySide2.QtCore.QSize:
        "QSize.__init__": [(), ('PySide2.QtCore.QSize',), ('int', 'int')],
        "QSize.__add__": ('PySide2.QtCore.QSize',),
        "QSize.__copy__": (),
        "QSize.__iadd__": ('PySide2.QtCore.QSize',),
        "QSize.__imul__": ('float',),
        "QSize.__isub__": ('PySide2.QtCore.QSize',),
        "QSize.__mul__": ('float',),
        "QSize.__reduce__": (),
        "QSize.__repr__": (),
        "QSize.__sub__": ('PySide2.QtCore.QSize',),
        "QSize.boundedTo": ('PySide2.QtCore.QSize',),
        "QSize.expandedTo": ('PySide2.QtCore.QSize',),
        "QSize.height": (),
        "QSize.isEmpty": (),
        "QSize.isNull": (),
        "QSize.isValid": (),
        "QSize.scale": [('PySide2.QtCore.QSize', 'PySide2.QtCore.Qt.AspectRatioMode'), ('int', 'int', 'PySide2.QtCore.Qt.AspectRatioMode')],
        "QSize.scaled": [('PySide2.QtCore.QSize', 'PySide2.QtCore.Qt.AspectRatioMode'), ('int', 'int', 'PySide2.QtCore.Qt.AspectRatioMode')],
        "QSize.setHeight": ('int',),
        "QSize.setWidth": ('int',),
        "QSize.toTuple": (),
        "QSize.transpose": (),
        "QSize.transposed": (),
        "QSize.width": (),

    # class PySide2.QtCore.QSizeF:
        "QSizeF.__init__": [(), ('PySide2.QtCore.QSize',), ('PySide2.QtCore.QSizeF',), ('float', 'float')],
        "QSizeF.__add__": ('PySide2.QtCore.QSizeF',),
        "QSizeF.__copy__": (),
        "QSizeF.__iadd__": ('PySide2.QtCore.QSizeF',),
        "QSizeF.__imul__": ('float',),
        "QSizeF.__isub__": ('PySide2.QtCore.QSizeF',),
        "QSizeF.__mul__": ('float',),
        "QSizeF.__reduce__": (),
        "QSizeF.__repr__": (),
        "QSizeF.__sub__": ('PySide2.QtCore.QSizeF',),
        "QSizeF.boundedTo": ('PySide2.QtCore.QSizeF',),
        "QSizeF.expandedTo": ('PySide2.QtCore.QSizeF',),
        "QSizeF.height": (),
        "QSizeF.isEmpty": (),
        "QSizeF.isNull": (),
        "QSizeF.isValid": (),
        "QSizeF.scale": [('PySide2.QtCore.QSizeF', 'PySide2.QtCore.Qt.AspectRatioMode'), ('float', 'float', 'PySide2.QtCore.Qt.AspectRatioMode')],
        "QSizeF.scaled": [('PySide2.QtCore.QSizeF', 'PySide2.QtCore.Qt.AspectRatioMode'), ('float', 'float', 'PySide2.QtCore.Qt.AspectRatioMode')],
        "QSizeF.setHeight": ('float',),
        "QSizeF.setWidth": ('float',),
        "QSizeF.toSize": (),
        "QSizeF.toTuple": (),
        "QSizeF.transpose": (),
        "QSizeF.transposed": (),
        "QSizeF.width": (),

    # class PySide2.QtCore.QSocketNotifier:
        "QSocketNotifier.__init__": [('int', 'PySide2.QtCore.QSocketNotifier.Type', 'PySide2.QtCore.QObject'), ('object', 'PySide2.QtCore.QSocketNotifier.Type', 'PySide2.QtCore.QObject')],
        "QSocketNotifier.event": ('PySide2.QtCore.QEvent',),
        "QSocketNotifier.isEnabled": (),
        "QSocketNotifier.setEnabled": ('bool',),
        "QSocketNotifier.socket": (),
        "QSocketNotifier.type": (),

    # class PySide2.QtCore.QSortFilterProxyModel:
        "QSortFilterProxyModel.__init__": ('PySide2.QtCore.QObject',),
        "QSortFilterProxyModel.buddy": ('PySide2.QtCore.QModelIndex',),
        "QSortFilterProxyModel.canFetchMore": ('PySide2.QtCore.QModelIndex',),
        "QSortFilterProxyModel.columnCount": ('PySide2.QtCore.QModelIndex',),
        "QSortFilterProxyModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
        "QSortFilterProxyModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QSortFilterProxyModel.dynamicSortFilter": (),
        "QSortFilterProxyModel.fetchMore": ('PySide2.QtCore.QModelIndex',),
        "QSortFilterProxyModel.filterAcceptsColumn": ('int', 'PySide2.QtCore.QModelIndex'),
        "QSortFilterProxyModel.filterAcceptsRow": ('int', 'PySide2.QtCore.QModelIndex'),
        "QSortFilterProxyModel.filterCaseSensitivity": (),
        "QSortFilterProxyModel.filterKeyColumn": (),
        "QSortFilterProxyModel.filterRegExp": (),
        "QSortFilterProxyModel.filterRegularExpression": (),
        "QSortFilterProxyModel.filterRole": (),
        "QSortFilterProxyModel.flags": ('PySide2.QtCore.QModelIndex',),
        "QSortFilterProxyModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
        "QSortFilterProxyModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
        "QSortFilterProxyModel.index": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QSortFilterProxyModel.insertColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QSortFilterProxyModel.insertRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QSortFilterProxyModel.invalidate": (),
        "QSortFilterProxyModel.invalidateFilter": (),
        "QSortFilterProxyModel.isRecursiveFilteringEnabled": (),
        "QSortFilterProxyModel.isSortLocaleAware": (),
        "QSortFilterProxyModel.lessThan": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
        "QSortFilterProxyModel.mapFromSource": ('PySide2.QtCore.QModelIndex',),
        "QSortFilterProxyModel.mapSelectionFromSource": ('PySide2.QtCore.QItemSelection',),
        "QSortFilterProxyModel.mapSelectionToSource": ('PySide2.QtCore.QItemSelection',),
        "QSortFilterProxyModel.mapToSource": ('PySide2.QtCore.QModelIndex',),
        "QSortFilterProxyModel.match": ('PySide2.QtCore.QModelIndex', 'int', 'typing.Any', 'int', 'PySide2.QtCore.Qt.MatchFlags'),
        "QSortFilterProxyModel.mimeData": ('typing.List[int]',),
        "QSortFilterProxyModel.mimeTypes": (),
        "QSortFilterProxyModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
        "QSortFilterProxyModel.removeColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QSortFilterProxyModel.removeRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QSortFilterProxyModel.rowCount": ('PySide2.QtCore.QModelIndex',),
        "QSortFilterProxyModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
        "QSortFilterProxyModel.setDynamicSortFilter": ('bool',),
        "QSortFilterProxyModel.setFilterCaseSensitivity": ('PySide2.QtCore.Qt.CaseSensitivity',),
        "QSortFilterProxyModel.setFilterFixedString": ('str',),
        "QSortFilterProxyModel.setFilterKeyColumn": ('int',),
        "QSortFilterProxyModel.setFilterRegExp": [('PySide2.QtCore.QRegExp',), ('str',)],
        "QSortFilterProxyModel.setFilterRegularExpression": [('PySide2.QtCore.QRegularExpression',), ('str',)],
        "QSortFilterProxyModel.setFilterRole": ('int',),
        "QSortFilterProxyModel.setFilterWildcard": ('str',),
        "QSortFilterProxyModel.setHeaderData": ('int', 'PySide2.QtCore.Qt.Orientation', 'typing.Any', 'int'),
        "QSortFilterProxyModel.setRecursiveFilteringEnabled": ('bool',),
        "QSortFilterProxyModel.setSortCaseSensitivity": ('PySide2.QtCore.Qt.CaseSensitivity',),
        "QSortFilterProxyModel.setSortLocaleAware": ('bool',),
        "QSortFilterProxyModel.setSortRole": ('int',),
        "QSortFilterProxyModel.setSourceModel": ('PySide2.QtCore.QAbstractItemModel',),
        "QSortFilterProxyModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QSortFilterProxyModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
        "QSortFilterProxyModel.sortCaseSensitivity": (),
        "QSortFilterProxyModel.sortColumn": (),
        "QSortFilterProxyModel.sortOrder": (),
        "QSortFilterProxyModel.sortRole": (),
        "QSortFilterProxyModel.span": ('PySide2.QtCore.QModelIndex',),
        "QSortFilterProxyModel.supportedDropActions": (),

    # class PySide2.QtCore.QStandardPaths:
        "QStandardPaths.displayName": ('PySide2.QtCore.QStandardPaths.StandardLocation',),
        "QStandardPaths.enableTestMode": ('bool',),
        "QStandardPaths.findExecutable": ('str', 'typing.List[str]'),
        "QStandardPaths.isTestModeEnabled": (),
        "QStandardPaths.locate": ('PySide2.QtCore.QStandardPaths.StandardLocation', 'str', 'PySide2.QtCore.QStandardPaths.LocateOptions'),
        "QStandardPaths.locateAll": ('PySide2.QtCore.QStandardPaths.StandardLocation', 'str', 'PySide2.QtCore.QStandardPaths.LocateOptions'),
        "QStandardPaths.setTestModeEnabled": ('bool',),
        "QStandardPaths.standardLocations": ('PySide2.QtCore.QStandardPaths.StandardLocation',),
        "QStandardPaths.writableLocation": ('PySide2.QtCore.QStandardPaths.StandardLocation',),

    # class PySide2.QtCore.QState:
        "QState.__init__": [('PySide2.QtCore.QState',), ('PySide2.QtCore.QState.ChildMode', 'PySide2.QtCore.QState')],
        "QState.addTransition": [('PySide2.QtCore.QAbstractState',), ('PySide2.QtCore.QAbstractTransition',), ('PySide2.QtCore.QObject', 'str', 'PySide2.QtCore.QAbstractState'), ('object', 'PySide2.QtCore.QAbstractState')],
        "QState.assignProperty": ('PySide2.QtCore.QObject', 'str', 'typing.Any'),
        "QState.childMode": (),
        "QState.errorState": (),
        "QState.event": ('PySide2.QtCore.QEvent',),
        "QState.initialState": (),
        "QState.onEntry": ('PySide2.QtCore.QEvent',),
        "QState.onExit": ('PySide2.QtCore.QEvent',),
        "QState.removeTransition": ('PySide2.QtCore.QAbstractTransition',),
        "QState.setChildMode": ('PySide2.QtCore.QState.ChildMode',),
        "QState.setErrorState": ('PySide2.QtCore.QAbstractState',),
        "QState.setInitialState": ('PySide2.QtCore.QAbstractState',),
        "QState.transitions": (),

    # class PySide2.QtCore.QStateMachine:
        "QStateMachine.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtCore.QState.ChildMode', 'PySide2.QtCore.QObject')],
        "QStateMachine.addDefaultAnimation": ('PySide2.QtCore.QAbstractAnimation',),
        "QStateMachine.addState": ('PySide2.QtCore.QAbstractState',),
        "QStateMachine.beginMicrostep": ('PySide2.QtCore.QEvent',),
        "QStateMachine.beginSelectTransitions": ('PySide2.QtCore.QEvent',),
        "QStateMachine.cancelDelayedEvent": ('int',),
        "QStateMachine.clearError": (),
        "QStateMachine.configuration": (),
        "QStateMachine.defaultAnimations": (),
        "QStateMachine.endMicrostep": ('PySide2.QtCore.QEvent',),
        "QStateMachine.endSelectTransitions": ('PySide2.QtCore.QEvent',),
        "QStateMachine.error": (),
        "QStateMachine.errorString": (),
        "QStateMachine.event": ('PySide2.QtCore.QEvent',),
        "QStateMachine.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QStateMachine.globalRestorePolicy": (),
        "QStateMachine.isAnimated": (),
        "QStateMachine.isRunning": (),
        "QStateMachine.onEntry": ('PySide2.QtCore.QEvent',),
        "QStateMachine.onExit": ('PySide2.QtCore.QEvent',),
        "QStateMachine.postDelayedEvent": ('PySide2.QtCore.QEvent', 'int'),
        "QStateMachine.postEvent": ('PySide2.QtCore.QEvent', 'PySide2.QtCore.QStateMachine.EventPriority'),
        "QStateMachine.removeDefaultAnimation": ('PySide2.QtCore.QAbstractAnimation',),
        "QStateMachine.removeState": ('PySide2.QtCore.QAbstractState',),
        "QStateMachine.setAnimated": ('bool',),
        "QStateMachine.setGlobalRestorePolicy": ('PySide2.QtCore.QState.RestorePolicy',),
        "QStateMachine.setRunning": ('bool',),
        "QStateMachine.start": (),
        "QStateMachine.stop": (),

    # class PySide2.QtCore.QStateMachine.SignalEvent:
        "QStateMachine.SignalEvent.__init__": [('PySide2.QtCore.QObject', 'int', 'list'), ('PySide2.QtCore.QStateMachine.SignalEvent',)],
        "QStateMachine.SignalEvent.__copy__": (),
        "QStateMachine.SignalEvent.arguments": (),
        "QStateMachine.SignalEvent.sender": (),
        "QStateMachine.SignalEvent.signalIndex": (),

    # class PySide2.QtCore.QStateMachine.WrappedEvent:
        "QStateMachine.WrappedEvent.__init__": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'), ('PySide2.QtCore.QStateMachine.WrappedEvent',)],
        "QStateMachine.WrappedEvent.__copy__": (),
        "QStateMachine.WrappedEvent.event": (),
        "QStateMachine.WrappedEvent.object": (),

    # class PySide2.QtCore.QStorageInfo:
        "QStorageInfo.__init__": [(), ('PySide2.QtCore.QDir',), ('PySide2.QtCore.QStorageInfo',), ('str',)],
        "QStorageInfo.__copy__": (),
        "QStorageInfo.blockSize": (),
        "QStorageInfo.bytesAvailable": (),
        "QStorageInfo.bytesFree": (),
        "QStorageInfo.bytesTotal": (),
        "QStorageInfo.device": (),
        "QStorageInfo.displayName": (),
        "QStorageInfo.fileSystemType": (),
        "QStorageInfo.isReadOnly": (),
        "QStorageInfo.isReady": (),
        "QStorageInfo.isRoot": (),
        "QStorageInfo.isValid": (),
        "QStorageInfo.mountedVolumes": (),
        "QStorageInfo.name": (),
        "QStorageInfo.refresh": (),
        "QStorageInfo.root": (),
        "QStorageInfo.rootPath": (),
        "QStorageInfo.setPath": ('str',),
        "QStorageInfo.subvolume": (),
        "QStorageInfo.swap": ('PySide2.QtCore.QStorageInfo',),

    # class PySide2.QtCore.QStringListModel:
        "QStringListModel.__init__": [('PySide2.QtCore.QObject',), ('typing.List[str]', 'PySide2.QtCore.QObject')],
        "QStringListModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
        "QStringListModel.flags": ('PySide2.QtCore.QModelIndex',),
        "QStringListModel.insertRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QStringListModel.removeRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QStringListModel.rowCount": ('PySide2.QtCore.QModelIndex',),
        "QStringListModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
        "QStringListModel.setStringList": ('typing.List[str]',),
        "QStringListModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QStringListModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
        "QStringListModel.stringList": (),
        "QStringListModel.supportedDropActions": (),

    # class PySide2.QtCore.QSysInfo:
        "QSysInfo.__init__": (),
        "QSysInfo.bootUniqueId": (),
        "QSysInfo.buildAbi": (),
        "QSysInfo.buildCpuArchitecture": (),
        "QSysInfo.currentCpuArchitecture": (),
        "QSysInfo.kernelType": (),
        "QSysInfo.kernelVersion": (),
        "QSysInfo.machineHostName": (),
        "QSysInfo.machineUniqueId": (),
        "QSysInfo.prettyProductName": (),
        "QSysInfo.productType": (),
        "QSysInfo.productVersion": (),

    # class PySide2.QtCore.QSystemSemaphore:
        "QSystemSemaphore.__init__": ('str', 'int', 'PySide2.QtCore.QSystemSemaphore.AccessMode'),
        "QSystemSemaphore.acquire": (),
        "QSystemSemaphore.error": (),
        "QSystemSemaphore.errorString": (),
        "QSystemSemaphore.key": (),
        "QSystemSemaphore.release": ('int',),
        "QSystemSemaphore.setKey": ('str', 'int', 'PySide2.QtCore.QSystemSemaphore.AccessMode'),

    # class PySide2.QtCore.QTemporaryDir:
        "QTemporaryDir.__init__": [(), ('str',)],
        "QTemporaryDir.autoRemove": (),
        "QTemporaryDir.errorString": (),
        "QTemporaryDir.filePath": ('str',),
        "QTemporaryDir.isValid": (),
        "QTemporaryDir.path": (),
        "QTemporaryDir.remove": (),
        "QTemporaryDir.setAutoRemove": ('bool',),

    # class PySide2.QtCore.QTemporaryFile:
        "QTemporaryFile.__init__": [(), ('PySide2.QtCore.QObject',), ('str',), ('str', 'PySide2.QtCore.QObject')],
        "QTemporaryFile.autoRemove": (),
        "QTemporaryFile.createLocalFile": [('PySide2.QtCore.QFile',), ('str',)],
        "QTemporaryFile.createNativeFile": [('PySide2.QtCore.QFile',), ('str',)],
        "QTemporaryFile.fileName": (),
        "QTemporaryFile.fileTemplate": (),
        "QTemporaryFile.open": [(), ('PySide2.QtCore.QIODevice.OpenMode',)],
        "QTemporaryFile.rename": ('str',),
        "QTemporaryFile.setAutoRemove": ('bool',),
        "QTemporaryFile.setFileTemplate": ('str',),

    # class PySide2.QtCore.QTextBoundaryFinder:
        "QTextBoundaryFinder.__init__": [(), ('PySide2.QtCore.QTextBoundaryFinder',), ('PySide2.QtCore.QTextBoundaryFinder.BoundaryType', 'str')],
        "QTextBoundaryFinder.__copy__": (),
        "QTextBoundaryFinder.boundaryReasons": (),
        "QTextBoundaryFinder.isAtBoundary": (),
        "QTextBoundaryFinder.isValid": (),
        "QTextBoundaryFinder.position": (),
        "QTextBoundaryFinder.setPosition": ('int',),
        "QTextBoundaryFinder.string": (),
        "QTextBoundaryFinder.toEnd": (),
        "QTextBoundaryFinder.toNextBoundary": (),
        "QTextBoundaryFinder.toPreviousBoundary": (),
        "QTextBoundaryFinder.toStart": (),
        "QTextBoundaryFinder.type": (),

    # class PySide2.QtCore.QTextCodec:
        "QTextCodec.__init__": (),
        "QTextCodec.aliases": (),
        "QTextCodec.availableCodecs": (),
        "QTextCodec.availableMibs": (),
        "QTextCodec.canEncode": [('str',), ('typing.Union[str, int]',)],
        "QTextCodec.codecForHtml": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QTextCodec')],
        "QTextCodec.codecForLocale": (),
        "QTextCodec.codecForMib": ('int',),
        "QTextCodec.codecForName": [('PySide2.QtCore.QByteArray',), ('str',)],
        "QTextCodec.codecForUtfText": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QTextCodec')],
        "QTextCodec.convertToUnicode": ('str', 'int', 'PySide2.QtCore.QTextCodec.ConverterState'),
        "QTextCodec.fromUnicode": ('str',),
        "QTextCodec.makeDecoder": ('PySide2.QtCore.QTextCodec.ConversionFlags',),
        "QTextCodec.makeEncoder": ('PySide2.QtCore.QTextCodec.ConversionFlags',),
        "QTextCodec.mibEnum": (),
        "QTextCodec.name": (),
        "QTextCodec.setCodecForLocale": ('PySide2.QtCore.QTextCodec',),
        "QTextCodec.toUnicode": [('PySide2.QtCore.QByteArray',), ('str',), ('str', 'int', 'PySide2.QtCore.QTextCodec.ConverterState')],

    # class PySide2.QtCore.QTextCodec.ConverterState:
        "QTextCodec.ConverterState.__init__": ('PySide2.QtCore.QTextCodec.ConversionFlags',),

    # class PySide2.QtCore.QTextDecoder:
        "QTextDecoder.__init__": [('PySide2.QtCore.QTextCodec',), ('PySide2.QtCore.QTextCodec', 'PySide2.QtCore.QTextCodec.ConversionFlags')],
        "QTextDecoder.hasFailure": (),
        "QTextDecoder.needsMoreData": (),
        "QTextDecoder.toUnicode": ('PySide2.QtCore.QByteArray',),

    # class PySide2.QtCore.QTextEncoder:
        "QTextEncoder.__init__": [('PySide2.QtCore.QTextCodec',), ('PySide2.QtCore.QTextCodec', 'PySide2.QtCore.QTextCodec.ConversionFlags')],
        "QTextEncoder.fromUnicode": ('str',),
        "QTextEncoder.hasFailure": (),

    # class PySide2.QtCore.QTextStream:
        "QTextStream.__init__": [(), ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QIODevice.OpenMode'), ('PySide2.QtCore.QIODevice',)],
        "QTextStream.__lshift__": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QTextStreamManipulator',), ('float',), ('int',), ('str',), ('typing.Union[str, int]',)],
        "QTextStream.__rshift__": ('PySide2.QtCore.QByteArray',),
        "QTextStream.atEnd": (),
        "QTextStream.autoDetectUnicode": (),
        "QTextStream.codec": (),
        "QTextStream.device": (),
        "QTextStream.fieldAlignment": (),
        "QTextStream.fieldWidth": (),
        "QTextStream.flush": (),
        "QTextStream.generateByteOrderMark": (),
        "QTextStream.integerBase": (),
        "QTextStream.locale": (),
        "QTextStream.numberFlags": (),
        "QTextStream.padChar": (),
        "QTextStream.pos": (),
        "QTextStream.read": ('int',),
        "QTextStream.readAll": (),
        "QTextStream.readLine": ('int',),
        "QTextStream.realNumberNotation": (),
        "QTextStream.realNumberPrecision": (),
        "QTextStream.reset": (),
        "QTextStream.resetStatus": (),
        "QTextStream.seek": ('int',),
        "QTextStream.setAutoDetectUnicode": ('bool',),
        "QTextStream.setCodec": [('PySide2.QtCore.QTextCodec',), ('str',)],
        "QTextStream.setDevice": ('PySide2.QtCore.QIODevice',),
        "QTextStream.setFieldAlignment": ('PySide2.QtCore.QTextStream.FieldAlignment',),
        "QTextStream.setFieldWidth": ('int',),
        "QTextStream.setGenerateByteOrderMark": ('bool',),
        "QTextStream.setIntegerBase": ('int',),
        "QTextStream.setLocale": ('PySide2.QtCore.QLocale',),
        "QTextStream.setNumberFlags": ('PySide2.QtCore.QTextStream.NumberFlags',),
        "QTextStream.setPadChar": ('typing.Union[str, int]',),
        "QTextStream.setRealNumberNotation": ('PySide2.QtCore.QTextStream.RealNumberNotation',),
        "QTextStream.setRealNumberPrecision": ('int',),
        "QTextStream.setStatus": ('PySide2.QtCore.QTextStream.Status',),
        "QTextStream.skipWhiteSpace": (),
        "QTextStream.status": (),
        "QTextStream.string": (),

    # class PySide2.QtCore.QTextStreamManipulator:
        "QTextStreamManipulator.__copy__": (),
        "QTextStreamManipulator.exec_": ('PySide2.QtCore.QTextStream',),

    # class PySide2.QtCore.QThread:
        "QThread.__init__": ('PySide2.QtCore.QObject',),
        "QThread.currentThread": (),
        "QThread.event": ('PySide2.QtCore.QEvent',),
        "QThread.eventDispatcher": (),
        "QThread.exec_": (),
        "QThread.exit": ('int',),
        "QThread.idealThreadCount": (),
        "QThread.isFinished": (),
        "QThread.isInterruptionRequested": (),
        "QThread.isRunning": (),
        "QThread.loopLevel": (),
        "QThread.msleep": ('int',),
        "QThread.priority": (),
        "QThread.quit": (),
        "QThread.requestInterruption": (),
        "QThread.run": (),
        "QThread.setEventDispatcher": ('PySide2.QtCore.QAbstractEventDispatcher',),
        "QThread.setPriority": ('PySide2.QtCore.QThread.Priority',),
        "QThread.setStackSize": ('int',),
        "QThread.setTerminationEnabled": ('bool',),
        "QThread.sleep": ('int',),
        "QThread.stackSize": (),
        "QThread.start": ('PySide2.QtCore.QThread.Priority',),
        "QThread.terminate": (),
        "QThread.usleep": ('int',),
        "QThread.wait": ('int',),
        "QThread.yieldCurrentThread": (),

    # class PySide2.QtCore.QThreadPool:
        "QThreadPool.__init__": ('PySide2.QtCore.QObject',),
        "QThreadPool.activeThreadCount": (),
        "QThreadPool.cancel": ('PySide2.QtCore.QRunnable',),
        "QThreadPool.clear": (),
        "QThreadPool.expiryTimeout": (),
        "QThreadPool.globalInstance": (),
        "QThreadPool.maxThreadCount": (),
        "QThreadPool.releaseThread": (),
        "QThreadPool.reserveThread": (),
        "QThreadPool.setExpiryTimeout": ('int',),
        "QThreadPool.setMaxThreadCount": ('int',),
        "QThreadPool.setStackSize": ('int',),
        "QThreadPool.stackSize": (),
        "QThreadPool.start": ('PySide2.QtCore.QRunnable', 'int'),
        "QThreadPool.tryStart": ('PySide2.QtCore.QRunnable',),
        "QThreadPool.tryTake": ('PySide2.QtCore.QRunnable',),
        "QThreadPool.waitForDone": ('int',),

    # class PySide2.QtCore.QTime:
        "QTime.__init__": [(), ('PySide2.QtCore.QTime',), ('int', 'int', 'int', 'int')],
        "QTime.__copy__": (),
        "QTime.__reduce__": (),
        "QTime.__repr__": (),
        "QTime.addMSecs": ('int',),
        "QTime.addSecs": ('int',),
        "QTime.currentTime": (),
        "QTime.elapsed": (),
        "QTime.fromMSecsSinceStartOfDay": ('int',),
        "QTime.fromString": [('str', 'PySide2.QtCore.Qt.DateFormat'), ('str', 'str')],
        "QTime.hour": (),
        "QTime.isNull": (),
        "QTime.isValid": [(), ('int', 'int', 'int', 'int')],
        "QTime.minute": (),
        "QTime.msec": (),
        "QTime.msecsSinceStartOfDay": (),
        "QTime.msecsTo": ('PySide2.QtCore.QTime',),
        "QTime.restart": (),
        "QTime.second": (),
        "QTime.secsTo": ('PySide2.QtCore.QTime',),
        "QTime.setHMS": ('int', 'int', 'int', 'int'),
        "QTime.start": (),
        "QTime.toPython": (),
        "QTime.toString": [('PySide2.QtCore.Qt.DateFormat',), ('str',)],

    # class PySide2.QtCore.QTimeLine:
        "QTimeLine.__init__": ('int', 'PySide2.QtCore.QObject'),
        "QTimeLine.currentFrame": (),
        "QTimeLine.currentTime": (),
        "QTimeLine.currentValue": (),
        "QTimeLine.curveShape": (),
        "QTimeLine.direction": (),
        "QTimeLine.duration": (),
        "QTimeLine.easingCurve": (),
        "QTimeLine.endFrame": (),
        "QTimeLine.frameForTime": ('int',),
        "QTimeLine.loopCount": (),
        "QTimeLine.resume": (),
        "QTimeLine.setCurrentTime": ('int',),
        "QTimeLine.setCurveShape": ('PySide2.QtCore.QTimeLine.CurveShape',),
        "QTimeLine.setDirection": ('PySide2.QtCore.QTimeLine.Direction',),
        "QTimeLine.setDuration": ('int',),
        "QTimeLine.setEasingCurve": ('PySide2.QtCore.QEasingCurve',),
        "QTimeLine.setEndFrame": ('int',),
        "QTimeLine.setFrameRange": ('int', 'int'),
        "QTimeLine.setLoopCount": ('int',),
        "QTimeLine.setPaused": ('bool',),
        "QTimeLine.setStartFrame": ('int',),
        "QTimeLine.setUpdateInterval": ('int',),
        "QTimeLine.start": (),
        "QTimeLine.startFrame": (),
        "QTimeLine.state": (),
        "QTimeLine.stop": (),
        "QTimeLine.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QTimeLine.toggleDirection": (),
        "QTimeLine.updateInterval": (),
        "QTimeLine.valueForTime": ('int',),

    # class PySide2.QtCore.QTimeZone:
        "QTimeZone.__init__": [(), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArray', 'int', 'str', 'str', 'PySide2.QtCore.QLocale.Country', 'str'), ('PySide2.QtCore.QTimeZone',), ('int',)],
        "QTimeZone.__copy__": (),
        "QTimeZone.abbreviation": ('PySide2.QtCore.QDateTime',),
        "QTimeZone.availableTimeZoneIds": [(), ('PySide2.QtCore.QLocale.Country',), ('int',)],
        "QTimeZone.comment": (),
        "QTimeZone.country": (),
        "QTimeZone.daylightTimeOffset": ('PySide2.QtCore.QDateTime',),
        "QTimeZone.displayName": [('PySide2.QtCore.QDateTime', 'PySide2.QtCore.QTimeZone.NameType', 'PySide2.QtCore.QLocale'), ('PySide2.QtCore.QTimeZone.TimeType', 'PySide2.QtCore.QTimeZone.NameType', 'PySide2.QtCore.QLocale')],
        "QTimeZone.hasDaylightTime": (),
        "QTimeZone.hasTransitions": (),
        "QTimeZone.ianaIdToWindowsId": ('PySide2.QtCore.QByteArray',),
        "QTimeZone.id": (),
        "QTimeZone.isDaylightTime": ('PySide2.QtCore.QDateTime',),
        "QTimeZone.isTimeZoneIdAvailable": ('PySide2.QtCore.QByteArray',),
        "QTimeZone.isValid": (),
        "QTimeZone.nextTransition": ('PySide2.QtCore.QDateTime',),
        "QTimeZone.offsetData": ('PySide2.QtCore.QDateTime',),
        "QTimeZone.offsetFromUtc": ('PySide2.QtCore.QDateTime',),
        "QTimeZone.previousTransition": ('PySide2.QtCore.QDateTime',),
        "QTimeZone.standardTimeOffset": ('PySide2.QtCore.QDateTime',),
        "QTimeZone.swap": ('PySide2.QtCore.QTimeZone',),
        "QTimeZone.systemTimeZone": (),
        "QTimeZone.systemTimeZoneId": (),
        "QTimeZone.transitions": ('PySide2.QtCore.QDateTime', 'PySide2.QtCore.QDateTime'),
        "QTimeZone.utc": (),
        "QTimeZone.windowsIdToDefaultIanaId": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QLocale.Country')],
        "QTimeZone.windowsIdToIanaIds": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QLocale.Country')],

    # class PySide2.QtCore.QTimeZone.OffsetData:
        "QTimeZone.OffsetData.__init__": [(), ('PySide2.QtCore.QTimeZone.OffsetData',)],
        "QTimeZone.OffsetData.__copy__": (),

    # class PySide2.QtCore.QTimer:
        "QTimer.__init__": ('PySide2.QtCore.QObject',),
        "QTimer.interval": (),
        "QTimer.isActive": (),
        "QTimer.isSingleShot": (),
        "QTimer.killTimer": ('int',),
        "QTimer.remainingTime": (),
        "QTimer.setInterval": ('int',),
        "QTimer.setSingleShot": ('bool',),
        "QTimer.setTimerType": ('PySide2.QtCore.Qt.TimerType',),
        "QTimer.singleShot": [('int', 'PySide2.QtCore.QObject', 'str'), ('int', 'PySide2.QtCore.Qt.TimerType', 'PySide2.QtCore.QObject', 'str'), ('int', 'typing.Callable')],
        "QTimer.start": [(), ('int',)],
        "QTimer.stop": (),
        "QTimer.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QTimer.timerId": (),
        "QTimer.timerType": (),

    # class PySide2.QtCore.QTimerEvent:
        "QTimerEvent.__init__": ('int',),
        "QTimerEvent.timerId": (),

    # class PySide2.QtCore.QTranslator:
        "QTranslator.__init__": ('PySide2.QtCore.QObject',),
        "QTranslator.isEmpty": (),
        "QTranslator.load": [('PySide2.QtCore.QLocale', 'str', 'str', 'str', 'str'), ('str', 'str', 'str', 'str'), ('typing.Union[str, int]', 'int', 'str')],
        "QTranslator.translate": ('str', 'str', 'str', 'int'),

    # class PySide2.QtCore.QUrl:
        "QUrl.__init__": [(), ('PySide2.QtCore.QUrl',), ('str', 'PySide2.QtCore.QUrl.ParsingMode')],
        "QUrl.__copy__": (),
        "QUrl.__reduce__": (),
        "QUrl.__repr__": (),
        "QUrl.adjusted": ('PySide2.QtCore.QUrl.FormattingOptions',),
        "QUrl.authority": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
        "QUrl.clear": (),
        "QUrl.errorString": (),
        "QUrl.fileName": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
        "QUrl.fragment": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
        "QUrl.fromAce": ('PySide2.QtCore.QByteArray',),
        "QUrl.fromEncoded": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QUrl.ParsingMode'),
        "QUrl.fromLocalFile": ('str',),
        "QUrl.fromPercentEncoding": ('PySide2.QtCore.QByteArray',),
        "QUrl.fromStringList": ('typing.List[str]', 'PySide2.QtCore.QUrl.ParsingMode'),
        "QUrl.fromUserInput": [('str',), ('str', 'str', 'PySide2.QtCore.QUrl.UserInputResolutionOptions')],
        "QUrl.hasFragment": (),
        "QUrl.hasQuery": (),
        "QUrl.host": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
        "QUrl.idnWhitelist": (),
        "QUrl.isEmpty": (),
        "QUrl.isLocalFile": (),
        "QUrl.isParentOf": ('PySide2.QtCore.QUrl',),
        "QUrl.isRelative": (),
        "QUrl.isValid": (),
        "QUrl.matches": ('PySide2.QtCore.QUrl', 'PySide2.QtCore.QUrl.FormattingOptions'),
        "QUrl.password": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
        "QUrl.path": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
        "QUrl.port": ('int',),
        "QUrl.query": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
        "QUrl.resolved": ('PySide2.QtCore.QUrl',),
        "QUrl.scheme": (),
        "QUrl.setAuthority": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
        "QUrl.setFragment": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
        "QUrl.setHost": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
        "QUrl.setIdnWhitelist": ('typing.List[str]',),
        "QUrl.setPassword": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
        "QUrl.setPath": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
        "QUrl.setPort": ('int',),
        "QUrl.setQuery": [('PySide2.QtCore.QUrlQuery',), ('str', 'PySide2.QtCore.QUrl.ParsingMode')],
        "QUrl.setScheme": ('str',),
        "QUrl.setUrl": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
        "QUrl.setUserInfo": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
        "QUrl.setUserName": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
        "QUrl.swap": ('PySide2.QtCore.QUrl',),
        "QUrl.toAce": ('str',),
        "QUrl.toDisplayString": ('PySide2.QtCore.QUrl.FormattingOptions',),
        "QUrl.toEncoded": ('PySide2.QtCore.QUrl.FormattingOptions',),
        "QUrl.toLocalFile": (),
        "QUrl.toPercentEncoding": ('str', 'PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray'),
        "QUrl.toString": ('PySide2.QtCore.QUrl.FormattingOptions',),
        "QUrl.toStringList": ('list', 'PySide2.QtCore.QUrl.FormattingOptions'),
        "QUrl.topLevelDomain": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
        "QUrl.url": ('PySide2.QtCore.QUrl.FormattingOptions',),
        "QUrl.userInfo": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
        "QUrl.userName": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),

    # class PySide2.QtCore.QUrlQuery:
        "QUrlQuery.__init__": [(), ('PySide2.QtCore.QUrl',), ('PySide2.QtCore.QUrlQuery',), ('str',)],
        "QUrlQuery.__copy__": (),
        "QUrlQuery.addQueryItem": ('str', 'str'),
        "QUrlQuery.allQueryItemValues": ('str', 'PySide2.QtCore.QUrl.ComponentFormattingOption'),
        "QUrlQuery.clear": (),
        "QUrlQuery.defaultQueryPairDelimiter": (),
        "QUrlQuery.defaultQueryValueDelimiter": (),
        "QUrlQuery.hasQueryItem": ('str',),
        "QUrlQuery.isEmpty": (),
        "QUrlQuery.query": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
        "QUrlQuery.queryItemValue": ('str', 'PySide2.QtCore.QUrl.ComponentFormattingOption'),
        "QUrlQuery.queryItems": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
        "QUrlQuery.queryPairDelimiter": (),
        "QUrlQuery.queryValueDelimiter": (),
        "QUrlQuery.removeAllQueryItems": ('str',),
        "QUrlQuery.removeQueryItem": ('str',),
        "QUrlQuery.setQuery": ('str',),
        "QUrlQuery.setQueryDelimiters": ('typing.Union[str, int]', 'typing.Union[str, int]'),
        "QUrlQuery.setQueryItems": ('list',),
        "QUrlQuery.swap": ('PySide2.QtCore.QUrlQuery',),
        "QUrlQuery.toString": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),

    # class PySide2.QtCore.QUuid:
        "QUuid.__init__": [(), ('PySide2.QtCore.QByteArray',), ('int', 'int', 'int', 'typing.Union[str, int]', 'typing.Union[str, int]', 'typing.Union[str, int]', 'typing.Union[str, int]', 'typing.Union[str, int]', 'typing.Union[str, int]', 'typing.Union[str, int]', 'typing.Union[str, int]'), ('str',)],
        "QUuid.__copy__": (),
        "QUuid.__reduce__": (),
        "QUuid.__repr__": (),
        "QUuid.createUuid": (),
        "QUuid.createUuidV3": [('PySide2.QtCore.QUuid', 'PySide2.QtCore.QByteArray'), ('PySide2.QtCore.QUuid', 'str')],
        "QUuid.createUuidV5": [('PySide2.QtCore.QUuid', 'PySide2.QtCore.QByteArray'), ('PySide2.QtCore.QUuid', 'str')],
        "QUuid.fromRfc4122": ('PySide2.QtCore.QByteArray',),
        "QUuid.isNull": (),
        "QUuid.toByteArray": [(), ('PySide2.QtCore.QUuid.StringFormat',)],
        "QUuid.toRfc4122": (),
        "QUuid.toString": [(), ('PySide2.QtCore.QUuid.StringFormat',)],
        "QUuid.variant": (),
        "QUuid.version": (),

    # class PySide2.QtCore.QVariantAnimation:
        "QVariantAnimation.__init__": ('PySide2.QtCore.QObject',),
        "QVariantAnimation.currentValue": (),
        "QVariantAnimation.duration": (),
        "QVariantAnimation.easingCurve": (),
        "QVariantAnimation.endValue": (),
        "QVariantAnimation.event": ('PySide2.QtCore.QEvent',),
        "QVariantAnimation.interpolated": ('typing.Any', 'typing.Any', 'float'),
        "QVariantAnimation.keyValueAt": ('float',),
        "QVariantAnimation.keyValues": (),
        "QVariantAnimation.setDuration": ('int',),
        "QVariantAnimation.setEasingCurve": ('PySide2.QtCore.QEasingCurve',),
        "QVariantAnimation.setEndValue": ('typing.Any',),
        "QVariantAnimation.setKeyValueAt": ('float', 'typing.Any'),
        "QVariantAnimation.setKeyValues": ('list',),
        "QVariantAnimation.setStartValue": ('typing.Any',),
        "QVariantAnimation.startValue": (),
        "QVariantAnimation.updateCurrentTime": ('int',),
        "QVariantAnimation.updateCurrentValue": ('typing.Any',),
        "QVariantAnimation.updateState": ('PySide2.QtCore.QAbstractAnimation.State', 'PySide2.QtCore.QAbstractAnimation.State'),

    # class PySide2.QtCore.QVersionNumber:
        "QVersionNumber.__init__": [(), ('int',), ('int', 'int'), ('int', 'int', 'int'), ('list',)],
        "QVersionNumber.__copy__": (),
        "QVersionNumber.commonPrefix": ('PySide2.QtCore.QVersionNumber', 'PySide2.QtCore.QVersionNumber'),
        "QVersionNumber.compare": ('PySide2.QtCore.QVersionNumber', 'PySide2.QtCore.QVersionNumber'),
        "QVersionNumber.fromString": ('str', 'int'),
        "QVersionNumber.isNormalized": (),
        "QVersionNumber.isNull": (),
        "QVersionNumber.isPrefixOf": ('PySide2.QtCore.QVersionNumber',),
        "QVersionNumber.majorVersion": (),
        "QVersionNumber.microVersion": (),
        "QVersionNumber.minorVersion": (),
        "QVersionNumber.normalized": (),
        "QVersionNumber.segmentAt": ('int',),
        "QVersionNumber.segmentCount": (),
        "QVersionNumber.segments": (),
        "QVersionNumber.toString": (),

    # class PySide2.QtCore.QWaitCondition:
        "QWaitCondition.__init__": (),
        "QWaitCondition.notify_all": (),
        "QWaitCondition.notify_one": (),
        "QWaitCondition.wait": [('PySide2.QtCore.QMutex', 'int'), ('PySide2.QtCore.QReadWriteLock', 'int')],
        "QWaitCondition.wakeAll": (),
        "QWaitCondition.wakeOne": (),

    # class PySide2.QtCore.QWriteLocker:
        "QWriteLocker.__init__": ('PySide2.QtCore.QReadWriteLock',),
        "QWriteLocker.__enter__": (),
        "QWriteLocker.__exit__": ('object', 'object', 'object'),
        "QWriteLocker.readWriteLock": (),
        "QWriteLocker.relock": (),
        "QWriteLocker.unlock": (),

    # class PySide2.QtCore.QXmlStreamAttribute:
        "QXmlStreamAttribute.__init__": [(), ('PySide2.QtCore.QXmlStreamAttribute',), ('str', 'str'), ('str', 'str', 'str')],
        "QXmlStreamAttribute.__copy__": (),
        "QXmlStreamAttribute.isDefault": (),
        "QXmlStreamAttribute.name": (),
        "QXmlStreamAttribute.namespaceUri": (),
        "QXmlStreamAttribute.prefix": (),
        "QXmlStreamAttribute.qualifiedName": (),
        "QXmlStreamAttribute.value": (),

    # class PySide2.QtCore.QXmlStreamAttributes:
        "QXmlStreamAttributes.__init__": [(), ('PySide2.QtCore.QXmlStreamAttributes',)],
        "QXmlStreamAttributes.__add__": ('list',),
        "QXmlStreamAttributes.__copy__": (),
        "QXmlStreamAttributes.__iadd__": ('PySide2.QtCore.QXmlStreamAttribute',),
        "QXmlStreamAttributes.__lshift__": [('PySide2.QtCore.QXmlStreamAttribute',), ('list',)],
        "QXmlStreamAttributes.append": [('str', 'str'), ('str', 'str', 'str')],
        "QXmlStreamAttributes.at": ('int',),
        "QXmlStreamAttributes.back": (),
        "QXmlStreamAttributes.capacity": (),
        "QXmlStreamAttributes.clear": (),
        "QXmlStreamAttributes.constData": (),
        "QXmlStreamAttributes.constFirst": (),
        "QXmlStreamAttributes.constLast": (),
        "QXmlStreamAttributes.contains": ('PySide2.QtCore.QXmlStreamAttribute',),
        "QXmlStreamAttributes.count": [(), ('PySide2.QtCore.QXmlStreamAttribute',)],
        "QXmlStreamAttributes.data": (),
        "QXmlStreamAttributes.empty": (),
        "QXmlStreamAttributes.endsWith": ('PySide2.QtCore.QXmlStreamAttribute',),
        "QXmlStreamAttributes.fill": ('PySide2.QtCore.QXmlStreamAttribute', 'int'),
        "QXmlStreamAttributes.first": (),
        "QXmlStreamAttributes.front": (),
        "QXmlStreamAttributes.hasAttribute": [('str',), ('str', 'str')],
        "QXmlStreamAttributes.indexOf": ('PySide2.QtCore.QXmlStreamAttribute', 'int'),
        "QXmlStreamAttributes.insert": [('int', 'PySide2.QtCore.QXmlStreamAttribute'), ('int', 'int', 'PySide2.QtCore.QXmlStreamAttribute')],
        "QXmlStreamAttributes.isEmpty": (),
        "QXmlStreamAttributes.isSharedWith": ('list',),
        "QXmlStreamAttributes.last": (),
        "QXmlStreamAttributes.lastIndexOf": ('PySide2.QtCore.QXmlStreamAttribute', 'int'),
        "QXmlStreamAttributes.length": (),
        "QXmlStreamAttributes.mid": ('int', 'int'),
        "QXmlStreamAttributes.move": ('int', 'int'),
        "QXmlStreamAttributes.prepend": ('PySide2.QtCore.QXmlStreamAttribute',),
        "QXmlStreamAttributes.remove": [('int',), ('int', 'int')],
        "QXmlStreamAttributes.removeAll": ('PySide2.QtCore.QXmlStreamAttribute',),
        "QXmlStreamAttributes.removeAt": ('int',),
        "QXmlStreamAttributes.removeFirst": (),
        "QXmlStreamAttributes.removeLast": (),
        "QXmlStreamAttributes.removeOne": ('PySide2.QtCore.QXmlStreamAttribute',),
        "QXmlStreamAttributes.replace": ('int', 'PySide2.QtCore.QXmlStreamAttribute'),
        "QXmlStreamAttributes.reserve": ('int',),
        "QXmlStreamAttributes.resize": ('int',),
        "QXmlStreamAttributes.setSharable": ('bool',),
        "QXmlStreamAttributes.shrink_to_fit": (),
        "QXmlStreamAttributes.size": (),
        "QXmlStreamAttributes.squeeze": (),
        "QXmlStreamAttributes.startsWith": ('PySide2.QtCore.QXmlStreamAttribute',),
        "QXmlStreamAttributes.swap": ('list',),
        "QXmlStreamAttributes.takeAt": ('int',),
        "QXmlStreamAttributes.takeFirst": (),
        "QXmlStreamAttributes.takeLast": (),
        "QXmlStreamAttributes.value": [('str',), ('str', 'str')],

    # class PySide2.QtCore.QXmlStreamEntityDeclaration:
        "QXmlStreamEntityDeclaration.__init__": [(), ('PySide2.QtCore.QXmlStreamEntityDeclaration',)],
        "QXmlStreamEntityDeclaration.__copy__": (),
        "QXmlStreamEntityDeclaration.name": (),
        "QXmlStreamEntityDeclaration.notationName": (),
        "QXmlStreamEntityDeclaration.publicId": (),
        "QXmlStreamEntityDeclaration.systemId": (),
        "QXmlStreamEntityDeclaration.value": (),

    # class PySide2.QtCore.QXmlStreamEntityResolver:
        "QXmlStreamEntityResolver.__init__": (),
        "QXmlStreamEntityResolver.resolveEntity": ('str', 'str'),
        "QXmlStreamEntityResolver.resolveUndeclaredEntity": ('str',),

    # class PySide2.QtCore.QXmlStreamNamespaceDeclaration:
        "QXmlStreamNamespaceDeclaration.__init__": [(), ('PySide2.QtCore.QXmlStreamNamespaceDeclaration',), ('str', 'str')],
        "QXmlStreamNamespaceDeclaration.__copy__": (),
        "QXmlStreamNamespaceDeclaration.namespaceUri": (),
        "QXmlStreamNamespaceDeclaration.prefix": (),

    # class PySide2.QtCore.QXmlStreamNotationDeclaration:
        "QXmlStreamNotationDeclaration.__init__": [(), ('PySide2.QtCore.QXmlStreamNotationDeclaration',)],
        "QXmlStreamNotationDeclaration.__copy__": (),
        "QXmlStreamNotationDeclaration.name": (),
        "QXmlStreamNotationDeclaration.publicId": (),
        "QXmlStreamNotationDeclaration.systemId": (),

    # class PySide2.QtCore.QXmlStreamReader:
        "QXmlStreamReader.__init__": [(), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QIODevice',), ('str',)],
        "QXmlStreamReader.addData": [('PySide2.QtCore.QByteArray',), ('str',)],
        "QXmlStreamReader.addExtraNamespaceDeclaration": ('PySide2.QtCore.QXmlStreamNamespaceDeclaration',),
        "QXmlStreamReader.addExtraNamespaceDeclarations": ('list',),
        "QXmlStreamReader.atEnd": (),
        "QXmlStreamReader.attributes": (),
        "QXmlStreamReader.characterOffset": (),
        "QXmlStreamReader.clear": (),
        "QXmlStreamReader.columnNumber": (),
        "QXmlStreamReader.device": (),
        "QXmlStreamReader.documentEncoding": (),
        "QXmlStreamReader.documentVersion": (),
        "QXmlStreamReader.dtdName": (),
        "QXmlStreamReader.dtdPublicId": (),
        "QXmlStreamReader.dtdSystemId": (),
        "QXmlStreamReader.entityDeclarations": (),
        "QXmlStreamReader.entityResolver": (),
        "QXmlStreamReader.error": (),
        "QXmlStreamReader.errorString": (),
        "QXmlStreamReader.hasError": (),
        "QXmlStreamReader.isCDATA": (),
        "QXmlStreamReader.isCharacters": (),
        "QXmlStreamReader.isComment": (),
        "QXmlStreamReader.isDTD": (),
        "QXmlStreamReader.isEndDocument": (),
        "QXmlStreamReader.isEndElement": (),
        "QXmlStreamReader.isEntityReference": (),
        "QXmlStreamReader.isProcessingInstruction": (),
        "QXmlStreamReader.isStandaloneDocument": (),
        "QXmlStreamReader.isStartDocument": (),
        "QXmlStreamReader.isStartElement": (),
        "QXmlStreamReader.isWhitespace": (),
        "QXmlStreamReader.lineNumber": (),
        "QXmlStreamReader.name": (),
        "QXmlStreamReader.namespaceDeclarations": (),
        "QXmlStreamReader.namespaceProcessing": (),
        "QXmlStreamReader.namespaceUri": (),
        "QXmlStreamReader.notationDeclarations": (),
        "QXmlStreamReader.prefix": (),
        "QXmlStreamReader.processingInstructionData": (),
        "QXmlStreamReader.processingInstructionTarget": (),
        "QXmlStreamReader.qualifiedName": (),
        "QXmlStreamReader.raiseError": ('str',),
        "QXmlStreamReader.readElementText": ('PySide2.QtCore.QXmlStreamReader.ReadElementTextBehaviour',),
        "QXmlStreamReader.readNext": (),
        "QXmlStreamReader.readNextStartElement": (),
        "QXmlStreamReader.setDevice": ('PySide2.QtCore.QIODevice',),
        "QXmlStreamReader.setEntityResolver": ('PySide2.QtCore.QXmlStreamEntityResolver',),
        "QXmlStreamReader.setNamespaceProcessing": ('bool',),
        "QXmlStreamReader.skipCurrentElement": (),
        "QXmlStreamReader.text": (),
        "QXmlStreamReader.tokenString": (),
        "QXmlStreamReader.tokenType": (),

    # class PySide2.QtCore.QXmlStreamWriter:
        "QXmlStreamWriter.__init__": [(), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QIODevice',)],
        "QXmlStreamWriter.autoFormatting": (),
        "QXmlStreamWriter.autoFormattingIndent": (),
        "QXmlStreamWriter.codec": (),
        "QXmlStreamWriter.device": (),
        "QXmlStreamWriter.hasError": (),
        "QXmlStreamWriter.setAutoFormatting": ('bool',),
        "QXmlStreamWriter.setAutoFormattingIndent": ('int',),
        "QXmlStreamWriter.setCodec": [('PySide2.QtCore.QTextCodec',), ('str',)],
        "QXmlStreamWriter.setDevice": ('PySide2.QtCore.QIODevice',),
        "QXmlStreamWriter.writeAttribute": [('PySide2.QtCore.QXmlStreamAttribute',), ('str', 'str'), ('str', 'str', 'str')],
        "QXmlStreamWriter.writeAttributes": ('PySide2.QtCore.QXmlStreamAttributes',),
        "QXmlStreamWriter.writeCDATA": ('str',),
        "QXmlStreamWriter.writeCharacters": ('str',),
        "QXmlStreamWriter.writeComment": ('str',),
        "QXmlStreamWriter.writeCurrentToken": ('PySide2.QtCore.QXmlStreamReader',),
        "QXmlStreamWriter.writeDTD": ('str',),
        "QXmlStreamWriter.writeDefaultNamespace": ('str',),
        "QXmlStreamWriter.writeEmptyElement": [('str',), ('str', 'str')],
        "QXmlStreamWriter.writeEndDocument": (),
        "QXmlStreamWriter.writeEndElement": (),
        "QXmlStreamWriter.writeEntityReference": ('str',),
        "QXmlStreamWriter.writeNamespace": ('str', 'str'),
        "QXmlStreamWriter.writeProcessingInstruction": ('str', 'str'),
        "QXmlStreamWriter.writeStartDocument": [(), ('str',), ('str', 'bool')],
        "QXmlStreamWriter.writeStartElement": [('str',), ('str', 'str')],
        "QXmlStreamWriter.writeTextElement": [('str', 'str'), ('str', 'str', 'str')],

    # class PySide2.QtCore.Qt:
    })

# Module PySide2.QtGui
if "PySide2.QtGui" in sys.modules:
    dict.update({
        "qAlpha": ('int',),
        "qBlue": ('int',),
        "qGray": [('int',), ('int', 'int', 'int')],
        "qGreen": ('int',),
        "qIsGray": ('int',),
        "qRed": ('int',),
        "qRgb": ('int', 'int', 'int'),
        "qRgba": ('int', 'int', 'int', 'int'),

    # class PySide2.QtGui.QAbstractOpenGLFunctions:
        "QAbstractOpenGLFunctions.__init__": (),
        "QAbstractOpenGLFunctions.initializeOpenGLFunctions": (),
        "QAbstractOpenGLFunctions.isInitialized": (),
        "QAbstractOpenGLFunctions.owningContext": (),
        "QAbstractOpenGLFunctions.setOwningContext": ('PySide2.QtGui.QOpenGLContext',),

    # class PySide2.QtGui.QAbstractTextDocumentLayout:
        "QAbstractTextDocumentLayout.__init__": ('PySide2.QtGui.QTextDocument',),
        "QAbstractTextDocumentLayout.anchorAt": ('PySide2.QtCore.QPointF',),
        "QAbstractTextDocumentLayout.blockBoundingRect": ('PySide2.QtGui.QTextBlock',),
        "QAbstractTextDocumentLayout.document": (),
        "QAbstractTextDocumentLayout.documentChanged": ('int', 'int', 'int'),
        "QAbstractTextDocumentLayout.documentSize": (),
        "QAbstractTextDocumentLayout.draw": ('PySide2.QtGui.QPainter', 'PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext'),
        "QAbstractTextDocumentLayout.drawInlineObject": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF', 'PySide2.QtGui.QTextInlineObject', 'int', 'PySide2.QtGui.QTextFormat'),
        "QAbstractTextDocumentLayout.format": ('int',),
        "QAbstractTextDocumentLayout.formatAt": ('PySide2.QtCore.QPointF',),
        "QAbstractTextDocumentLayout.formatIndex": ('int',),
        "QAbstractTextDocumentLayout.frameBoundingRect": ('PySide2.QtGui.QTextFrame',),
        "QAbstractTextDocumentLayout.handlerForObject": ('int',),
        "QAbstractTextDocumentLayout.hitTest": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.HitTestAccuracy'),
        "QAbstractTextDocumentLayout.imageAt": ('PySide2.QtCore.QPointF',),
        "QAbstractTextDocumentLayout.pageCount": (),
        "QAbstractTextDocumentLayout.paintDevice": (),
        "QAbstractTextDocumentLayout.positionInlineObject": ('PySide2.QtGui.QTextInlineObject', 'int', 'PySide2.QtGui.QTextFormat'),
        "QAbstractTextDocumentLayout.registerHandler": ('int', 'PySide2.QtCore.QObject'),
        "QAbstractTextDocumentLayout.resizeInlineObject": ('PySide2.QtGui.QTextInlineObject', 'int', 'PySide2.QtGui.QTextFormat'),
        "QAbstractTextDocumentLayout.setPaintDevice": ('PySide2.QtGui.QPaintDevice',),
        "QAbstractTextDocumentLayout.unregisterHandler": ('int', 'PySide2.QtCore.QObject'),

    # class PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext:
        "QAbstractTextDocumentLayout.PaintContext.__init__": [(), ('PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext',)],
        "QAbstractTextDocumentLayout.PaintContext.__copy__": (),

    # class PySide2.QtGui.QAbstractTextDocumentLayout.Selection:
        "QAbstractTextDocumentLayout.Selection.__init__": [(), ('PySide2.QtGui.QAbstractTextDocumentLayout.Selection',)],
        "QAbstractTextDocumentLayout.Selection.__copy__": (),

    # class PySide2.QtGui.QAccessible:
        "QAccessible.__copy__": (),
        "QAccessible.accessibleInterface": ('int',),
        "QAccessible.cleanup": (),
        "QAccessible.deleteAccessibleInterface": ('int',),
        "QAccessible.isActive": (),
        "QAccessible.qAccessibleTextBoundaryHelper": ('PySide2.QtGui.QTextCursor', 'PySide2.QtGui.QAccessible.TextBoundaryType'),
        "QAccessible.queryAccessibleInterface": ('PySide2.QtCore.QObject',),
        "QAccessible.registerAccessibleInterface": ('PySide2.QtGui.QAccessibleInterface',),
        "QAccessible.setActive": ('bool',),
        "QAccessible.setRootObject": ('PySide2.QtCore.QObject',),
        "QAccessible.uniqueId": ('PySide2.QtGui.QAccessibleInterface',),
        "QAccessible.updateAccessibility": ('PySide2.QtGui.QAccessibleEvent',),

    # class PySide2.QtGui.QAccessible.State:
        "QAccessible.State.__init__": [(), ('PySide2.QtGui.QAccessible.State',)],
        "QAccessible.State.__copy__": (),

    # class PySide2.QtGui.QAccessibleEditableTextInterface:
        "QAccessibleEditableTextInterface.__init__": (),
        "QAccessibleEditableTextInterface.deleteText": ('int', 'int'),
        "QAccessibleEditableTextInterface.insertText": ('int', 'str'),
        "QAccessibleEditableTextInterface.replaceText": ('int', 'int', 'str'),

    # class PySide2.QtGui.QAccessibleEvent:
        "QAccessibleEvent.__init__": [('PySide2.QtCore.QObject', 'PySide2.QtGui.QAccessible.Event'), ('PySide2.QtGui.QAccessibleInterface', 'PySide2.QtGui.QAccessible.Event')],
        "QAccessibleEvent.accessibleInterface": (),
        "QAccessibleEvent.child": (),
        "QAccessibleEvent.object": (),
        "QAccessibleEvent.setChild": ('int',),
        "QAccessibleEvent.type": (),
        "QAccessibleEvent.uniqueId": (),

    # class PySide2.QtGui.QAccessibleInterface:
        "QAccessibleInterface.__init__": (),
        "QAccessibleInterface.backgroundColor": (),
        "QAccessibleInterface.child": ('int',),
        "QAccessibleInterface.childAt": ('int', 'int'),
        "QAccessibleInterface.childCount": (),
        "QAccessibleInterface.editableTextInterface": (),
        "QAccessibleInterface.focusChild": (),
        "QAccessibleInterface.foregroundColor": (),
        "QAccessibleInterface.indexOfChild": ('PySide2.QtGui.QAccessibleInterface',),
        "QAccessibleInterface.interface_cast": ('PySide2.QtGui.QAccessible.InterfaceType',),
        "QAccessibleInterface.isValid": (),
        "QAccessibleInterface.object": (),
        "QAccessibleInterface.parent": (),
        "QAccessibleInterface.rect": (),
        "QAccessibleInterface.relations": ('PySide2.QtGui.QAccessible.Relation',),
        "QAccessibleInterface.role": (),
        "QAccessibleInterface.setText": ('PySide2.QtGui.QAccessible.Text', 'str'),
        "QAccessibleInterface.state": (),
        "QAccessibleInterface.tableCellInterface": (),
        "QAccessibleInterface.text": ('PySide2.QtGui.QAccessible.Text',),
        "QAccessibleInterface.textInterface": (),
        "QAccessibleInterface.valueInterface": (),
        "QAccessibleInterface.virtual_hook": ('int', 'int'),
        "QAccessibleInterface.window": (),

    # class PySide2.QtGui.QAccessibleObject:
        "QAccessibleObject.__init__": ('PySide2.QtCore.QObject',),
        "QAccessibleObject.childAt": ('int', 'int'),
        "QAccessibleObject.isValid": (),
        "QAccessibleObject.object": (),
        "QAccessibleObject.rect": (),
        "QAccessibleObject.setText": ('PySide2.QtGui.QAccessible.Text', 'str'),

    # class PySide2.QtGui.QAccessibleStateChangeEvent:
        "QAccessibleStateChangeEvent.__init__": [('PySide2.QtCore.QObject', 'PySide2.QtGui.QAccessible.State'), ('PySide2.QtGui.QAccessibleInterface', 'PySide2.QtGui.QAccessible.State')],
        "QAccessibleStateChangeEvent.changedStates": (),

    # class PySide2.QtGui.QAccessibleTableCellInterface:
        "QAccessibleTableCellInterface.__init__": (),
        "QAccessibleTableCellInterface.columnExtent": (),
        "QAccessibleTableCellInterface.columnHeaderCells": (),
        "QAccessibleTableCellInterface.columnIndex": (),
        "QAccessibleTableCellInterface.isSelected": (),
        "QAccessibleTableCellInterface.rowExtent": (),
        "QAccessibleTableCellInterface.rowHeaderCells": (),
        "QAccessibleTableCellInterface.rowIndex": (),
        "QAccessibleTableCellInterface.table": (),

    # class PySide2.QtGui.QAccessibleTableModelChangeEvent:
        "QAccessibleTableModelChangeEvent.__init__": [('PySide2.QtCore.QObject', 'PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType'), ('PySide2.QtGui.QAccessibleInterface', 'PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType')],
        "QAccessibleTableModelChangeEvent.firstColumn": (),
        "QAccessibleTableModelChangeEvent.firstRow": (),
        "QAccessibleTableModelChangeEvent.lastColumn": (),
        "QAccessibleTableModelChangeEvent.lastRow": (),
        "QAccessibleTableModelChangeEvent.modelChangeType": (),
        "QAccessibleTableModelChangeEvent.setFirstColumn": ('int',),
        "QAccessibleTableModelChangeEvent.setFirstRow": ('int',),
        "QAccessibleTableModelChangeEvent.setLastColumn": ('int',),
        "QAccessibleTableModelChangeEvent.setLastRow": ('int',),
        "QAccessibleTableModelChangeEvent.setModelChangeType": ('PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType',),

    # class PySide2.QtGui.QAccessibleTextCursorEvent:
        "QAccessibleTextCursorEvent.__init__": [('PySide2.QtCore.QObject', 'int'), ('PySide2.QtGui.QAccessibleInterface', 'int')],
        "QAccessibleTextCursorEvent.cursorPosition": (),
        "QAccessibleTextCursorEvent.setCursorPosition": ('int',),

    # class PySide2.QtGui.QAccessibleTextInsertEvent:
        "QAccessibleTextInsertEvent.__init__": [('PySide2.QtCore.QObject', 'int', 'str'), ('PySide2.QtGui.QAccessibleInterface', 'int', 'str')],
        "QAccessibleTextInsertEvent.changePosition": (),
        "QAccessibleTextInsertEvent.textInserted": (),

    # class PySide2.QtGui.QAccessibleTextInterface:
        "QAccessibleTextInterface.__init__": (),
        "QAccessibleTextInterface.addSelection": ('int', 'int'),
        "QAccessibleTextInterface.attributes": ('int', 'int', 'int'),
        "QAccessibleTextInterface.characterCount": (),
        "QAccessibleTextInterface.characterRect": ('int',),
        "QAccessibleTextInterface.cursorPosition": (),
        "QAccessibleTextInterface.offsetAtPoint": ('PySide2.QtCore.QPoint',),
        "QAccessibleTextInterface.removeSelection": ('int',),
        "QAccessibleTextInterface.scrollToSubstring": ('int', 'int'),
        "QAccessibleTextInterface.selection": ('int', 'int', 'int'),
        "QAccessibleTextInterface.selectionCount": (),
        "QAccessibleTextInterface.setCursorPosition": ('int',),
        "QAccessibleTextInterface.setSelection": ('int', 'int', 'int'),
        "QAccessibleTextInterface.text": ('int', 'int'),
        "QAccessibleTextInterface.textAfterOffset": ('int', 'PySide2.QtGui.QAccessible.TextBoundaryType', 'int', 'int'),
        "QAccessibleTextInterface.textAtOffset": ('int', 'PySide2.QtGui.QAccessible.TextBoundaryType', 'int', 'int'),
        "QAccessibleTextInterface.textBeforeOffset": ('int', 'PySide2.QtGui.QAccessible.TextBoundaryType', 'int', 'int'),

    # class PySide2.QtGui.QAccessibleTextRemoveEvent:
        "QAccessibleTextRemoveEvent.__init__": [('PySide2.QtCore.QObject', 'int', 'str'), ('PySide2.QtGui.QAccessibleInterface', 'int', 'str')],
        "QAccessibleTextRemoveEvent.changePosition": (),
        "QAccessibleTextRemoveEvent.textRemoved": (),

    # class PySide2.QtGui.QAccessibleTextSelectionEvent:
        "QAccessibleTextSelectionEvent.__init__": [('PySide2.QtCore.QObject', 'int', 'int'), ('PySide2.QtGui.QAccessibleInterface', 'int', 'int')],
        "QAccessibleTextSelectionEvent.selectionEnd": (),
        "QAccessibleTextSelectionEvent.selectionStart": (),
        "QAccessibleTextSelectionEvent.setSelection": ('int', 'int'),

    # class PySide2.QtGui.QAccessibleTextUpdateEvent:
        "QAccessibleTextUpdateEvent.__init__": [('PySide2.QtCore.QObject', 'int', 'str', 'str'), ('PySide2.QtGui.QAccessibleInterface', 'int', 'str', 'str')],
        "QAccessibleTextUpdateEvent.changePosition": (),
        "QAccessibleTextUpdateEvent.textInserted": (),
        "QAccessibleTextUpdateEvent.textRemoved": (),

    # class PySide2.QtGui.QAccessibleValueChangeEvent:
        "QAccessibleValueChangeEvent.__init__": [('PySide2.QtCore.QObject', 'typing.Any'), ('PySide2.QtGui.QAccessibleInterface', 'typing.Any')],
        "QAccessibleValueChangeEvent.setValue": ('typing.Any',),
        "QAccessibleValueChangeEvent.value": (),

    # class PySide2.QtGui.QAccessibleValueInterface:
        "QAccessibleValueInterface.__init__": (),
        "QAccessibleValueInterface.currentValue": (),
        "QAccessibleValueInterface.maximumValue": (),
        "QAccessibleValueInterface.minimumStepSize": (),
        "QAccessibleValueInterface.minimumValue": (),
        "QAccessibleValueInterface.setCurrentValue": ('typing.Any',),

    # class PySide2.QtGui.QActionEvent:

    # class PySide2.QtGui.QBackingStore:
        "QBackingStore.__init__": ('PySide2.QtGui.QWindow',),
        "QBackingStore.beginPaint": ('PySide2.QtGui.QRegion',),
        "QBackingStore.endPaint": (),
        "QBackingStore.flush": ('PySide2.QtGui.QRegion', 'PySide2.QtGui.QWindow', 'PySide2.QtCore.QPoint'),
        "QBackingStore.hasStaticContents": (),
        "QBackingStore.paintDevice": (),
        "QBackingStore.resize": ('PySide2.QtCore.QSize',),
        "QBackingStore.scroll": ('PySide2.QtGui.QRegion', 'int', 'int'),
        "QBackingStore.setStaticContents": ('PySide2.QtGui.QRegion',),
        "QBackingStore.size": (),
        "QBackingStore.staticContents": (),
        "QBackingStore.window": (),

    # class PySide2.QtGui.QBitmap:
        "QBitmap.__init__": [(), ('PySide2.QtCore.QSize',), ('PySide2.QtGui.QBitmap',), ('PySide2.QtGui.QPixmap',), ('int', 'int'), ('str', 'str')],
        "QBitmap.__copy__": (),
        "QBitmap.clear": (),
        "QBitmap.fromData": ('PySide2.QtCore.QSize', 'typing.Union[str, int]', 'PySide2.QtGui.QImage.Format'),
        "QBitmap.fromImage": ('PySide2.QtGui.QImage', 'PySide2.QtCore.Qt.ImageConversionFlags'),
        "QBitmap.swap": [('PySide2.QtGui.QBitmap',), ('PySide2.QtGui.QPixmap',)],
        "QBitmap.transformed": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QMatrix', 'PySide2.QtCore.Qt.TransformationMode'), ('PySide2.QtGui.QTransform',)],

    # class PySide2.QtGui.QBrush:
        "QBrush.__init__": [(), ('PySide2.QtCore.Qt.BrushStyle',), ('PySide2.QtCore.Qt.GlobalColor', 'PySide2.QtCore.Qt.BrushStyle'), ('PySide2.QtCore.Qt.GlobalColor', 'PySide2.QtGui.QPixmap'), ('PySide2.QtGui.QBrush',), ('PySide2.QtGui.QColor', 'PySide2.QtCore.Qt.BrushStyle'), ('PySide2.QtGui.QColor', 'PySide2.QtGui.QPixmap'), ('PySide2.QtGui.QGradient',), ('PySide2.QtGui.QImage',), ('PySide2.QtGui.QPixmap',)],
        "QBrush.__copy__": (),
        "QBrush.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QBrush.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QBrush.color": (),
        "QBrush.gradient": (),
        "QBrush.isOpaque": (),
        "QBrush.matrix": (),
        "QBrush.setColor": [('PySide2.QtCore.Qt.GlobalColor',), ('PySide2.QtGui.QColor',)],
        "QBrush.setMatrix": ('PySide2.QtGui.QMatrix',),
        "QBrush.setStyle": ('PySide2.QtCore.Qt.BrushStyle',),
        "QBrush.setTexture": ('PySide2.QtGui.QPixmap',),
        "QBrush.setTextureImage": ('PySide2.QtGui.QImage',),
        "QBrush.setTransform": ('PySide2.QtGui.QTransform',),
        "QBrush.style": (),
        "QBrush.swap": ('PySide2.QtGui.QBrush',),
        "QBrush.texture": (),
        "QBrush.textureImage": (),
        "QBrush.transform": (),

    # class PySide2.QtGui.QClipboard:
        "QClipboard.clear": ('PySide2.QtGui.QClipboard.Mode',),
        "QClipboard.image": ('PySide2.QtGui.QClipboard.Mode',),
        "QClipboard.mimeData": ('PySide2.QtGui.QClipboard.Mode',),
        "QClipboard.ownsClipboard": (),
        "QClipboard.ownsFindBuffer": (),
        "QClipboard.ownsSelection": (),
        "QClipboard.pixmap": ('PySide2.QtGui.QClipboard.Mode',),
        "QClipboard.setImage": ('PySide2.QtGui.QImage', 'PySide2.QtGui.QClipboard.Mode'),
        "QClipboard.setMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtGui.QClipboard.Mode'),
        "QClipboard.setPixmap": ('PySide2.QtGui.QPixmap', 'PySide2.QtGui.QClipboard.Mode'),
        "QClipboard.setText": ('str', 'PySide2.QtGui.QClipboard.Mode'),
        "QClipboard.supportsFindBuffer": (),
        "QClipboard.supportsSelection": (),
        "QClipboard.text": [('PySide2.QtGui.QClipboard.Mode',), ('str', 'PySide2.QtGui.QClipboard.Mode')],

    # class PySide2.QtGui.QCloseEvent:
        "QCloseEvent.__init__": (),

    # class PySide2.QtGui.QColor:
        "QColor.__init__": [(), ('PySide2.QtCore.Qt.GlobalColor',), ('PySide2.QtGui.QColor',), ('int',), ('int', 'int', 'int', 'int'), ('str',), ('typing.Any',)],
        "QColor.__copy__": (),
        "QColor.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QColor.__reduce__": (),
        "QColor.__repr__": (),
        "QColor.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QColor.__setstate__": ('object',),
        "QColor.__str__": (),
        "QColor.alpha": (),
        "QColor.alphaF": (),
        "QColor.black": (),
        "QColor.blackF": (),
        "QColor.blue": (),
        "QColor.blueF": (),
        "QColor.colorNames": (),
        "QColor.convertTo": ('PySide2.QtGui.QColor.Spec',),
        "QColor.cyan": (),
        "QColor.cyanF": (),
        "QColor.dark": ('int',),
        "QColor.darker": ('int',),
        "QColor.fromCmyk": ('int', 'int', 'int', 'int', 'int'),
        "QColor.fromCmykF": ('float', 'float', 'float', 'float', 'float'),
        "QColor.fromHsl": ('int', 'int', 'int', 'int'),
        "QColor.fromHslF": ('float', 'float', 'float', 'float'),
        "QColor.fromHsv": ('int', 'int', 'int', 'int'),
        "QColor.fromHsvF": ('float', 'float', 'float', 'float'),
        "QColor.fromRgb": [('int',), ('int', 'int', 'int', 'int')],
        "QColor.fromRgbF": ('float', 'float', 'float', 'float'),
        "QColor.fromRgba": ('int',),
        "QColor.fromRgba64": ('int', 'int', 'int', 'int'),
        "QColor.getCmyk": ('int', 'int', 'int', 'int', 'int'),
        "QColor.getCmykF": ('float', 'float', 'float', 'float', 'float'),
        "QColor.getHsl": ('int', 'int', 'int', 'int'),
        "QColor.getHslF": ('float', 'float', 'float', 'float'),
        "QColor.getHsv": ('int', 'int', 'int', 'int'),
        "QColor.getHsvF": ('float', 'float', 'float', 'float'),
        "QColor.getRgb": ('int', 'int', 'int', 'int'),
        "QColor.getRgbF": ('float', 'float', 'float', 'float'),
        "QColor.green": (),
        "QColor.greenF": (),
        "QColor.hslHue": (),
        "QColor.hslHueF": (),
        "QColor.hslSaturation": (),
        "QColor.hslSaturationF": (),
        "QColor.hsvHue": (),
        "QColor.hsvHueF": (),
        "QColor.hsvSaturation": (),
        "QColor.hsvSaturationF": (),
        "QColor.hue": (),
        "QColor.hueF": (),
        "QColor.isValid": (),
        "QColor.isValidColor": ('str',),
        "QColor.light": ('int',),
        "QColor.lighter": ('int',),
        "QColor.lightness": (),
        "QColor.lightnessF": (),
        "QColor.magenta": (),
        "QColor.magentaF": (),
        "QColor.name": [(), ('PySide2.QtGui.QColor.NameFormat',)],
        "QColor.red": (),
        "QColor.redF": (),
        "QColor.rgb": (),
        "QColor.rgba": (),
        "QColor.saturation": (),
        "QColor.saturationF": (),
        "QColor.setAlpha": ('int',),
        "QColor.setAlphaF": ('float',),
        "QColor.setBlue": ('int',),
        "QColor.setBlueF": ('float',),
        "QColor.setCmyk": ('int', 'int', 'int', 'int', 'int'),
        "QColor.setCmykF": ('float', 'float', 'float', 'float', 'float'),
        "QColor.setGreen": ('int',),
        "QColor.setGreenF": ('float',),
        "QColor.setHsl": ('int', 'int', 'int', 'int'),
        "QColor.setHslF": ('float', 'float', 'float', 'float'),
        "QColor.setHsv": ('int', 'int', 'int', 'int'),
        "QColor.setHsvF": ('float', 'float', 'float', 'float'),
        "QColor.setNamedColor": ('str',),
        "QColor.setRed": ('int',),
        "QColor.setRedF": ('float',),
        "QColor.setRgb": [('int',), ('int', 'int', 'int', 'int')],
        "QColor.setRgbF": ('float', 'float', 'float', 'float'),
        "QColor.setRgba": ('int',),
        "QColor.spec": (),
        "QColor.toCmyk": (),
        "QColor.toHsl": (),
        "QColor.toHsv": (),
        "QColor.toRgb": (),
        "QColor.toTuple": (),
        "QColor.value": (),
        "QColor.valueF": (),
        "QColor.yellow": (),
        "QColor.yellowF": (),

    # class PySide2.QtGui.QConicalGradient:
        "QConicalGradient.__init__": [(), ('PySide2.QtCore.QPointF', 'float'), ('PySide2.QtGui.QConicalGradient',), ('float', 'float', 'float')],
        "QConicalGradient.__copy__": (),
        "QConicalGradient.angle": (),
        "QConicalGradient.center": (),
        "QConicalGradient.setAngle": ('float',),
        "QConicalGradient.setCenter": [('PySide2.QtCore.QPointF',), ('float', 'float')],

    # class PySide2.QtGui.QContextMenuEvent:
        "QContextMenuEvent.__init__": [('PySide2.QtGui.QContextMenuEvent.Reason', 'PySide2.QtCore.QPoint'), ('PySide2.QtGui.QContextMenuEvent.Reason', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'), ('PySide2.QtGui.QContextMenuEvent.Reason', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.Qt.KeyboardModifiers')],
        "QContextMenuEvent.globalPos": (),
        "QContextMenuEvent.globalX": (),
        "QContextMenuEvent.global""Y": (),
        "QContextMenuEvent.pos": (),
        "QContextMenuEvent.reason": (),
        "QContextMenuEvent.x": (),
        "QContextMenuEvent.y": (),

    # class PySide2.QtGui.QCursor:
        "QCursor.__init__": [(), ('PySide2.QtCore.Qt.CursorShape',), ('PySide2.QtGui.QBitmap', 'PySide2.QtGui.QBitmap', 'int', 'int'), ('PySide2.QtGui.QCursor',), ('PySide2.QtGui.QPixmap', 'int', 'int')],
        "QCursor.__copy__": (),
        "QCursor.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QCursor.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QCursor.bitmap": (),
        "QCursor.hotSpot": (),
        "QCursor.mask": (),
        "QCursor.pixmap": (),
        "QCursor.pos": [(), ('PySide2.QtGui.QScreen',)],
        "QCursor.setPos": [('PySide2.QtCore.QPoint',), ('PySide2.QtGui.QScreen', 'PySide2.QtCore.QPoint'), ('PySide2.QtGui.QScreen', 'int', 'int'), ('int', 'int')],
        "QCursor.setShape": ('PySide2.QtCore.Qt.CursorShape',),
        "QCursor.shape": (),
        "QCursor.swap": ('PySide2.QtGui.QCursor',),

    # class PySide2.QtGui.QDesktopServices:
        "QDesktopServices.__init__": (),
        "QDesktopServices.openUrl": ('PySide2.QtCore.QUrl',),
        "QDesktopServices.setUrlHandler": ('str', 'PySide2.QtCore.QObject', 'str'),
        "QDesktopServices.unsetUrlHandler": ('str',),

    # class PySide2.QtGui.QDoubleValidator:
        "QDoubleValidator.__init__": [('PySide2.QtCore.QObject',), ('float', 'float', 'int', 'PySide2.QtCore.QObject')],
        "QDoubleValidator.bottom": (),
        "QDoubleValidator.decimals": (),
        "QDoubleValidator.notation": (),
        "QDoubleValidator.setBottom": ('float',),
        "QDoubleValidator.setDecimals": ('int',),
        "QDoubleValidator.setNotation": ('PySide2.QtGui.QDoubleValidator.Notation',),
        "QDoubleValidator.setRange": ('float', 'float', 'int'),
        "QDoubleValidator.setTop": ('float',),
        "QDoubleValidator.top": (),
        "QDoubleValidator.validate": ('str', 'int'),

    # class PySide2.QtGui.QDrag:
        "QDrag.__init__": ('PySide2.QtCore.QObject',),
        "QDrag.cancel": (),
        "QDrag.defaultAction": (),
        "QDrag.dragCursor": ('PySide2.QtCore.Qt.DropAction',),
        "QDrag.exec_": [('PySide2.QtCore.Qt.DropActions',), ('PySide2.QtCore.Qt.DropActions', 'PySide2.QtCore.Qt.DropAction')],
        "QDrag.hotSpot": (),
        "QDrag.mimeData": (),
        "QDrag.pixmap": (),
        "QDrag.setDragCursor": ('PySide2.QtGui.QPixmap', 'PySide2.QtCore.Qt.DropAction'),
        "QDrag.setHotSpot": ('PySide2.QtCore.QPoint',),
        "QDrag.setMimeData": ('PySide2.QtCore.QMimeData',),
        "QDrag.setPixmap": ('PySide2.QtGui.QPixmap',),
        "QDrag.source": (),
        "QDrag.start": ('PySide2.QtCore.Qt.DropActions',),
        "QDrag.supportedActions": (),
        "QDrag.target": (),

    # class PySide2.QtGui.QDragEnterEvent:
        "QDragEnterEvent.__init__": ('PySide2.QtCore.QPoint', 'PySide2.QtCore.Qt.DropActions', 'PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers'),

    # class PySide2.QtGui.QDragLeaveEvent:
        "QDragLeaveEvent.__init__": (),

    # class PySide2.QtGui.QDragMoveEvent:
        "QDragMoveEvent.__init__": ('PySide2.QtCore.QPoint', 'PySide2.QtCore.Qt.DropActions', 'PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.QEvent.Type'),
        "QDragMoveEvent.accept": [(), ('PySide2.QtCore.QRect',)],
        "QDragMoveEvent.answerRect": (),
        "QDragMoveEvent.ignore": [(), ('PySide2.QtCore.QRect',)],

    # class PySide2.QtGui.QDropEvent:
        "QDropEvent.__init__": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.DropActions', 'PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.QEvent.Type'),
        "QDropEvent.acceptProposedAction": (),
        "QDropEvent.dropAction": (),
        "QDropEvent.keyboardModifiers": (),
        "QDropEvent.mimeData": (),
        "QDropEvent.mouseButtons": (),
        "QDropEvent.pos": (),
        "QDropEvent.posF": (),
        "QDropEvent.possibleActions": (),
        "QDropEvent.proposedAction": (),
        "QDropEvent.setDropAction": ('PySide2.QtCore.Qt.DropAction',),
        "QDropEvent.source": (),

    # class PySide2.QtGui.QEnterEvent:
        "QEnterEvent.__init__": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'),
        "QEnterEvent.globalPos": (),
        "QEnterEvent.globalX": (),
        "QEnterEvent.global""Y": (),
        "QEnterEvent.localPos": (),
        "QEnterEvent.pos": (),
        "QEnterEvent.screenPos": (),
        "QEnterEvent.windowPos": (),
        "QEnterEvent.x": (),
        "QEnterEvent.y": (),

    # class PySide2.QtGui.QExposeEvent:
        "QExposeEvent.__init__": ('PySide2.QtGui.QRegion',),
        "QExposeEvent.region": (),

    # class PySide2.QtGui.QFileOpenEvent:
        "QFileOpenEvent.__init__": [('PySide2.QtCore.QUrl',), ('str',)],
        "QFileOpenEvent.file": (),
        "QFileOpenEvent.openFile": ('PySide2.QtCore.QFile', 'PySide2.QtCore.QIODevice.OpenMode'),
        "QFileOpenEvent.url": (),

    # class PySide2.QtGui.QFocusEvent:
        "QFocusEvent.__init__": ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.Qt.FocusReason'),
        "QFocusEvent.gotFocus": (),
        "QFocusEvent.lostFocus": (),
        "QFocusEvent.reason": (),

    # class PySide2.QtGui.QFont:
        "QFont.__init__": [(), ('PySide2.QtGui.QFont',), ('PySide2.QtGui.QFont', 'PySide2.QtGui.QPaintDevice'), ('str', 'int', 'int', 'bool')],
        "QFont.__copy__": (),
        "QFont.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QFont.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QFont.bold": (),
        "QFont.cacheStatistics": (),
        "QFont.capitalization": (),
        "QFont.cleanup": (),
        "QFont.defaultFamily": (),
        "QFont.exactMatch": (),
        "QFont.family": (),
        "QFont.fixedPitch": (),
        "QFont.fromString": ('str',),
        "QFont.hintingPreference": (),
        "QFont.initialize": (),
        "QFont.insertSubstitution": ('str', 'str'),
        "QFont.insertSubstitutions": ('str', 'typing.List[str]'),
        "QFont.isCopyOf": ('PySide2.QtGui.QFont',),
        "QFont.italic": (),
        "QFont.kerning": (),
        "QFont.key": (),
        "QFont.lastResortFamily": (),
        "QFont.lastResortFont": (),
        "QFont.letterSpacing": (),
        "QFont.letterSpacingType": (),
        "QFont.overline": (),
        "QFont.pixelSize": (),
        "QFont.pointSize": (),
        "QFont.pointSizeF": (),
        "QFont.rawMode": (),
        "QFont.rawName": (),
        "QFont.removeSubstitutions": ('str',),
        "QFont.resolve": [(), ('PySide2.QtGui.QFont',), ('int',)],
        "QFont.setBold": ('bool',),
        "QFont.setCapitalization": ('PySide2.QtGui.QFont.Capitalization',),
        "QFont.setFamily": ('str',),
        "QFont.setFixedPitch": ('bool',),
        "QFont.setHintingPreference": ('PySide2.QtGui.QFont.HintingPreference',),
        "QFont.setItalic": ('bool',),
        "QFont.setKerning": ('bool',),
        "QFont.setLetterSpacing": ('PySide2.QtGui.QFont.SpacingType', 'float'),
        "QFont.setOverline": ('bool',),
        "QFont.setPixelSize": ('int',),
        "QFont.setPointSize": ('int',),
        "QFont.setPointSizeF": ('float',),
        "QFont.setRawMode": ('bool',),
        "QFont.setRawName": ('str',),
        "QFont.setStretch": ('int',),
        "QFont.setStrikeOut": ('bool',),
        "QFont.setStyle": ('PySide2.QtGui.QFont.Style',),
        "QFont.setStyleHint": ('PySide2.QtGui.QFont.StyleHint', 'PySide2.QtGui.QFont.StyleStrategy'),
        "QFont.setStyleName": ('str',),
        "QFont.setStyleStrategy": ('PySide2.QtGui.QFont.StyleStrategy',),
        "QFont.setUnderline": ('bool',),
        "QFont.setWeight": ('int',),
        "QFont.setWordSpacing": ('float',),
        "QFont.stretch": (),
        "QFont.strikeOut": (),
        "QFont.style": (),
        "QFont.styleHint": (),
        "QFont.styleName": (),
        "QFont.styleStrategy": (),
        "QFont.substitute": ('str',),
        "QFont.substitutes": ('str',),
        "QFont.substitutions": (),
        "QFont.swap": ('PySide2.QtGui.QFont',),
        "QFont.toString": (),
        "QFont.underline": (),
        "QFont.weight": (),
        "QFont.wordSpacing": (),

    # class PySide2.QtGui.QFontDatabase:
        "QFontDatabase.__init__": [(), ('PySide2.QtGui.QFontDatabase',)],
        "QFontDatabase.__copy__": (),
        "QFontDatabase.addApplicationFont": ('str',),
        "QFontDatabase.addApplicationFontFromData": ('PySide2.QtCore.QByteArray',),
        "QFontDatabase.applicationFontFamilies": ('int',),
        "QFontDatabase.bold": ('str', 'str'),
        "QFontDatabase.families": ('PySide2.QtGui.QFontDatabase.WritingSystem',),
        "QFontDatabase.font": ('str', 'str', 'int'),
        "QFontDatabase.hasFamily": ('str',),
        "QFontDatabase.isBitmapScalable": ('str', 'str'),
        "QFontDatabase.isFixedPitch": ('str', 'str'),
        "QFontDatabase.isPrivateFamily": ('str',),
        "QFontDatabase.isScalable": ('str', 'str'),
        "QFontDatabase.isSmoothlyScalable": ('str', 'str'),
        "QFontDatabase.italic": ('str', 'str'),
        "QFontDatabase.pointSizes": ('str', 'str'),
        "QFontDatabase.removeAllApplicationFonts": (),
        "QFontDatabase.removeApplicationFont": ('int',),
        "QFontDatabase.smoothSizes": ('str', 'str'),
        "QFontDatabase.standardSizes": (),
        "QFontDatabase.styleString": [('PySide2.QtGui.QFont',), ('PySide2.QtGui.QFontInfo',)],
        "QFontDatabase.styles": ('str',),
        "QFontDatabase.supportsThreadedFontRendering": (),
        "QFontDatabase.systemFont": ('PySide2.QtGui.QFontDatabase.SystemFont',),
        "QFontDatabase.weight": ('str', 'str'),
        "QFontDatabase.writingSystemName": ('PySide2.QtGui.QFontDatabase.WritingSystem',),
        "QFontDatabase.writingSystemSample": ('PySide2.QtGui.QFontDatabase.WritingSystem',),
        "QFontDatabase.writingSystems": [(), ('str',)],

    # class PySide2.QtGui.QFontInfo:
        "QFontInfo.__init__": [('PySide2.QtGui.QFont',), ('PySide2.QtGui.QFontInfo',)],
        "QFontInfo.__copy__": (),
        "QFontInfo.bold": (),
        "QFontInfo.exactMatch": (),
        "QFontInfo.family": (),
        "QFontInfo.fixedPitch": (),
        "QFontInfo.italic": (),
        "QFontInfo.overline": (),
        "QFontInfo.pixelSize": (),
        "QFontInfo.pointSize": (),
        "QFontInfo.pointSizeF": (),
        "QFontInfo.rawMode": (),
        "QFontInfo.strikeOut": (),
        "QFontInfo.style": (),
        "QFontInfo.styleHint": (),
        "QFontInfo.styleName": (),
        "QFontInfo.swap": ('PySide2.QtGui.QFontInfo',),
        "QFontInfo.underline": (),
        "QFontInfo.weight": (),

    # class PySide2.QtGui.QFontMetrics:
        "QFontMetrics.__init__": [('PySide2.QtGui.QFont',), ('PySide2.QtGui.QFont', 'PySide2.QtGui.QPaintDevice'), ('PySide2.QtGui.QFontMetrics',)],
        "QFontMetrics.__copy__": (),
        "QFontMetrics.ascent": (),
        "QFontMetrics.averageCharWidth": (),
        "QFontMetrics.boundingRect": [('PySide2.QtCore.QRect', 'int', 'str', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'str', 'int', 'int'), ('str',)],
        "QFontMetrics.boundingRectChar": ('typing.Union[str, int]',),
        "QFontMetrics.capHeight": (),
        "QFontMetrics.charWidth": ('str', 'int'),
        "QFontMetrics.descent": (),
        "QFontMetrics.elidedText": ('str', 'PySide2.QtCore.Qt.TextElideMode', 'int', 'int'),
        "QFontMetrics.height": (),
        "QFontMetrics.horizontalAdvance": [('str', 'int'), ('typing.Union[str, int]',)],
        "QFontMetrics.inFont": ('typing.Union[str, int]',),
        "QFontMetrics.inFontUcs4": ('int',),
        "QFontMetrics.leading": (),
        "QFontMetrics.leftBearing": ('typing.Union[str, int]',),
        "QFontMetrics.lineSpacing": (),
        "QFontMetrics.lineWidth": (),
        "QFontMetrics.maxWidth": (),
        "QFontMetrics.minLeftBearing": (),
        "QFontMetrics.minRightBearing": (),
        "QFontMetrics.overlinePos": (),
        "QFontMetrics.rightBearing": ('typing.Union[str, int]',),
        "QFontMetrics.size": ('int', 'str', 'int', 'int'),
        "QFontMetrics.strikeOutPos": (),
        "QFontMetrics.swap": ('PySide2.QtGui.QFontMetrics',),
        "QFontMetrics.tightBoundingRect": ('str',),
        "QFontMetrics.underlinePos": (),
        "QFontMetrics.width": [('str', 'int'), ('str', 'int', 'int')],
        "QFontMetrics.widthChar": ('typing.Union[str, int]',),
        "QFontMetrics.xHeight": (),

    # class PySide2.QtGui.QFontMetricsF:
        "QFontMetricsF.__init__": [('PySide2.QtGui.QFont',), ('PySide2.QtGui.QFont', 'PySide2.QtGui.QPaintDevice'), ('PySide2.QtGui.QFontMetrics',), ('PySide2.QtGui.QFontMetricsF',)],
        "QFontMetricsF.__copy__": (),
        "QFontMetricsF.ascent": (),
        "QFontMetricsF.averageCharWidth": (),
        "QFontMetricsF.boundingRect": [('PySide2.QtCore.QRectF', 'int', 'str', 'int', 'int'), ('str',)],
        "QFontMetricsF.boundingRectChar": ('typing.Union[str, int]',),
        "QFontMetricsF.capHeight": (),
        "QFontMetricsF.descent": (),
        "QFontMetricsF.elidedText": ('str', 'PySide2.QtCore.Qt.TextElideMode', 'float', 'int'),
        "QFontMetricsF.height": (),
        "QFontMetricsF.horizontalAdvance": [('str', 'int'), ('typing.Union[str, int]',)],
        "QFontMetricsF.inFont": ('typing.Union[str, int]',),
        "QFontMetricsF.inFontUcs4": ('int',),
        "QFontMetricsF.leading": (),
        "QFontMetricsF.leftBearing": ('typing.Union[str, int]',),
        "QFontMetricsF.lineSpacing": (),
        "QFontMetricsF.lineWidth": (),
        "QFontMetricsF.maxWidth": (),
        "QFontMetricsF.minLeftBearing": (),
        "QFontMetricsF.minRightBearing": (),
        "QFontMetricsF.overlinePos": (),
        "QFontMetricsF.rightBearing": ('typing.Union[str, int]',),
        "QFontMetricsF.size": ('int', 'str', 'int', 'int'),
        "QFontMetricsF.strikeOutPos": (),
        "QFontMetricsF.swap": ('PySide2.QtGui.QFontMetricsF',),
        "QFontMetricsF.tightBoundingRect": ('str',),
        "QFontMetricsF.underlinePos": (),
        "QFontMetricsF.width": ('str',),
        "QFontMetricsF.widthChar": ('typing.Union[str, int]',),
        "QFontMetricsF.xHeight": (),

    # class PySide2.QtGui.QGradient:
        "QGradient.__init__": [(), ('PySide2.QtGui.QGradient',), ('PySide2.QtGui.QGradient.Preset',)],
        "QGradient.__copy__": (),
        "QGradient.coordinateMode": (),
        "QGradient.interpolationMode": (),
        "QGradient.setColorAt": ('float', 'PySide2.QtGui.QColor'),
        "QGradient.setCoordinateMode": ('PySide2.QtGui.QGradient.CoordinateMode',),
        "QGradient.setInterpolationMode": ('PySide2.QtGui.QGradient.InterpolationMode',),
        "QGradient.setSpread": ('PySide2.QtGui.QGradient.Spread',),
        "QGradient.setStops": ('list',),
        "QGradient.spread": (),
        "QGradient.stops": (),
        "QGradient.type": (),

    # class PySide2.QtGui.QGuiApplication:
        "QGuiApplication.__init__": [(), ('typing.List[str]',)],
        "QGuiApplication.allWindows": (),
        "QGuiApplication.applicationDisplayName": (),
        "QGuiApplication.applicationState": (),
        "QGuiApplication.changeOverrideCursor": ('PySide2.QtGui.QCursor',),
        "QGuiApplication.clipboard": (),
        "QGuiApplication.desktopFileName": (),
        "QGuiApplication.desktopSettingsAware": (),
        "QGuiApplication.devicePixelRatio": (),
        "QGuiApplication.event": ('PySide2.QtCore.QEvent',),
        "QGuiApplication.exec_": (),
        "QGuiApplication.focusObject": (),
        "QGuiApplication.focusWindow": (),
        "QGuiApplication.font": (),
        "QGuiApplication.inputMethod": (),
        "QGuiApplication.isFallbackSessionManagementEnabled": (),
        "QGuiApplication.isLeftToRight": (),
        "QGuiApplication.isRightToLeft": (),
        "QGuiApplication.isSavingSession": (),
        "QGuiApplication.isSessionRestored": (),
        "QGuiApplication.keyboardModifiers": (),
        "QGuiApplication.layoutDirection": (),
        "QGuiApplication.modalWindow": (),
        "QGuiApplication.mouseButtons": (),
        "QGuiApplication.notify": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QGuiApplication.overrideCursor": (),
        "QGuiApplication.palette": (),
        "QGuiApplication.platformName": (),
        "QGuiApplication.primaryScreen": (),
        "QGuiApplication.queryKeyboardModifiers": (),
        "QGuiApplication.quitOnLastWindowClosed": (),
        "QGuiApplication.restoreOverrideCursor": (),
        "QGuiApplication.screenAt": ('PySide2.QtCore.QPoint',),
        "QGuiApplication.screens": (),
        "QGuiApplication.sessionId": (),
        "QGuiApplication.sessionKey": (),
        "QGuiApplication.setApplicationDisplayName": ('str',),
        "QGuiApplication.setDesktopFileName": ('str',),
        "QGuiApplication.setDesktopSettingsAware": ('bool',),
        "QGuiApplication.setFallbackSessionManagementEnabled": ('bool',),
        "QGuiApplication.setFont": ('PySide2.QtGui.QFont',),
        "QGuiApplication.setLayoutDirection": ('PySide2.QtCore.Qt.LayoutDirection',),
        "QGuiApplication.setOverrideCursor": ('PySide2.QtGui.QCursor',),
        "QGuiApplication.setPalette": ('PySide2.QtGui.QPalette',),
        "QGuiApplication.setQuitOnLastWindowClosed": ('bool',),
        "QGuiApplication.setWindowIcon": ('PySide2.QtGui.QIcon',),
        "QGuiApplication.styleHints": (),
        "QGuiApplication.sync": (),
        "QGuiApplication.topLevelAt": ('PySide2.QtCore.QPoint',),
        "QGuiApplication.topLevelWindows": (),
        "QGuiApplication.windowIcon": (),

    # class PySide2.QtGui.QHelpEvent:
        "QHelpEvent.__init__": ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'),
        "QHelpEvent.globalPos": (),
        "QHelpEvent.globalX": (),
        "QHelpEvent.global""Y": (),
        "QHelpEvent.pos": (),
        "QHelpEvent.x": (),
        "QHelpEvent.y": (),

    # class PySide2.QtGui.QHideEvent:
        "QHideEvent.__init__": (),

    # class PySide2.QtGui.QHoverEvent:
        "QHoverEvent.__init__": ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.KeyboardModifiers'),
        "QHoverEvent.oldPos": (),
        "QHoverEvent.oldPosF": (),
        "QHoverEvent.pos": (),
        "QHoverEvent.posF": (),

    # class PySide2.QtGui.QIcon:
        "QIcon.__init__": [(), ('PySide2.QtGui.QIcon',), ('PySide2.QtGui.QIconEngine',), ('PySide2.QtGui.QPixmap',), ('str',)],
        "QIcon.__copy__": (),
        "QIcon.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QIcon.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QIcon.actualSize": [('PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'), ('PySide2.QtGui.QWindow', 'PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State')],
        "QIcon.addFile": ('str', 'PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
        "QIcon.addPixmap": ('PySide2.QtGui.QPixmap', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
        "QIcon.availableSizes": ('PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
        "QIcon.cacheKey": (),
        "QIcon.fallbackSearchPaths": (),
        "QIcon.fallbackThemeName": (),
        "QIcon.fromTheme": [('str',), ('str', 'PySide2.QtGui.QIcon')],
        "QIcon.hasThemeIcon": ('str',),
        "QIcon.isMask": (),
        "QIcon.isNull": (),
        "QIcon.name": (),
        "QIcon.paint": [('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.Alignment', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'), ('PySide2.QtGui.QPainter', 'int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.Alignment', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State')],
        "QIcon.pixmap": [('PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'), ('PySide2.QtGui.QWindow', 'PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'), ('int', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'), ('int', 'int', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State')],
        "QIcon.setFallbackSearchPaths": ('typing.List[str]',),
        "QIcon.setFallbackThemeName": ('str',),
        "QIcon.setIsMask": ('bool',),
        "QIcon.setThemeName": ('str',),
        "QIcon.setThemeSearchPaths": ('typing.List[str]',),
        "QIcon.swap": ('PySide2.QtGui.QIcon',),
        "QIcon.themeName": (),
        "QIcon.themeSearchPaths": (),

    # class PySide2.QtGui.QIconDragEvent:
        "QIconDragEvent.__init__": (),

    # class PySide2.QtGui.QIconEngine:
        "QIconEngine.__init__": [(), ('PySide2.QtGui.QIconEngine',)],
        "QIconEngine.actualSize": ('PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
        "QIconEngine.addFile": ('str', 'PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
        "QIconEngine.addPixmap": ('PySide2.QtGui.QPixmap', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
        "QIconEngine.availableSizes": ('PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
        "QIconEngine.clone": (),
        "QIconEngine.iconName": (),
        "QIconEngine.isNull": (),
        "QIconEngine.key": (),
        "QIconEngine.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
        "QIconEngine.pixmap": ('PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
        "QIconEngine.read": ('PySide2.QtCore.QDataStream',),
        "QIconEngine.scaledPixmap": ('PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State', 'float'),
        "QIconEngine.write": ('PySide2.QtCore.QDataStream',),

    # class PySide2.QtGui.QIconEngine.AvailableSizesArgument:
        "QIconEngine.AvailableSizesArgument.__init__": (),

    # class PySide2.QtGui.QImage:
        "QImage.__init__": [(), ('PySide2.QtCore.QSize', 'PySide2.QtGui.QImage.Format'), ('PySide2.QtGui.QImage',), ('int', 'int', 'PySide2.QtGui.QImage.Format'), ('str', 'int', 'int', 'PySide2.QtGui.QImage.Format'), ('str', 'int', 'int', 'int', 'PySide2.QtGui.QImage.Format'), ('str', 'str'), ('typing.List[str]',), ('typing.Union[str, int]', 'int', 'int', 'PySide2.QtGui.QImage.Format', 'typing.Callable', 'int'), ('typing.Union[str, int]', 'int', 'int', 'int', 'PySide2.QtGui.QImage.Format', 'typing.Callable', 'int')],
        "QImage.__copy__": (),
        "QImage.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QImage.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QImage.allGray": (),
        "QImage.alphaChannel": (),
        "QImage.bitPlaneCount": (),
        "QImage.bits": (),
        "QImage.byteCount": (),
        "QImage.bytesPerLine": (),
        "QImage.cacheKey": (),
        "QImage.color": ('int',),
        "QImage.colorCount": (),
        "QImage.colorTable": (),
        "QImage.constBits": (),
        "QImage.constScanLine": ('int',),
        "QImage.convertToFormat": [('PySide2.QtGui.QImage.Format', 'PySide2.QtCore.Qt.ImageConversionFlags'), ('PySide2.QtGui.QImage.Format', 'list', 'PySide2.QtCore.Qt.ImageConversionFlags')],
        "QImage.convertToFormat_helper": ('PySide2.QtGui.QImage.Format', 'PySide2.QtCore.Qt.ImageConversionFlags'),
        "QImage.convertToFormat_inplace": ('PySide2.QtGui.QImage.Format', 'PySide2.QtCore.Qt.ImageConversionFlags'),
        "QImage.copy": [('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
        "QImage.createAlphaMask": ('PySide2.QtCore.Qt.ImageConversionFlags',),
        "QImage.createHeuristicMask": ('bool',),
        "QImage.createMaskFromColor": ('int', 'PySide2.QtCore.Qt.MaskMode'),
        "QImage.depth": (),
        "QImage.devType": (),
        "QImage.devicePixelRatio": (),
        "QImage.dotsPerMeterX": (),
        "QImage.dotsPerMeterY": (),
        "QImage.fill": [('PySide2.QtCore.Qt.GlobalColor',), ('PySide2.QtGui.QColor',), ('int',)],
        "QImage.format": (),
        "QImage.fromData": ('PySide2.QtCore.QByteArray', 'str'),
        "QImage.hasAlphaChannel": (),
        "QImage.height": (),
        "QImage.invertPixels": ('PySide2.QtGui.QImage.InvertMode',),
        "QImage.isGrayscale": (),
        "QImage.isNull": (),
        "QImage.load": [('PySide2.QtCore.QIODevice', 'str'), ('str', 'str')],
        "QImage.loadFromData": ('PySide2.QtCore.QByteArray', 'str'),
        "QImage.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
        "QImage.mirrored": ('bool', 'bool'),
        "QImage.mirrored_helper": ('bool', 'bool'),
        "QImage.mirrored_inplace": ('bool', 'bool'),
        "QImage.offset": (),
        "QImage.paintEngine": (),
        "QImage.pixel": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QImage.pixelColor": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QImage.pixelFormat": (),
        "QImage.pixelIndex": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QImage.rect": (),
        "QImage.reinterpretAsFormat": ('PySide2.QtGui.QImage.Format',),
        "QImage.rgbSwapped": (),
        "QImage.rgbSwapped_helper": (),
        "QImage.rgbSwapped_inplace": (),
        "QImage.save": [('PySide2.QtCore.QIODevice', 'str', 'int'), ('str', 'str', 'int')],
        "QImage.scaled": [('PySide2.QtCore.QSize', 'PySide2.QtCore.Qt.AspectRatioMode', 'PySide2.QtCore.Qt.TransformationMode'), ('int', 'int', 'PySide2.QtCore.Qt.AspectRatioMode', 'PySide2.QtCore.Qt.TransformationMode')],
        "QImage.scaledToHeight": ('int', 'PySide2.QtCore.Qt.TransformationMode'),
        "QImage.scaledToWidth": ('int', 'PySide2.QtCore.Qt.TransformationMode'),
        "QImage.scanLine": ('int',),
        "QImage.setAlphaChannel": ('PySide2.QtGui.QImage',),
        "QImage.setColor": ('int', 'int'),
        "QImage.setColorCount": ('int',),
        "QImage.setColorTable": ('list',),
        "QImage.setDevicePixelRatio": ('float',),
        "QImage.setDotsPerMeterX": ('int',),
        "QImage.setDotsPerMeterY": ('int',),
        "QImage.setOffset": ('PySide2.QtCore.QPoint',),
        "QImage.setPixel": [('PySide2.QtCore.QPoint', 'int'), ('int', 'int', 'int')],
        "QImage.setPixelColor": [('PySide2.QtCore.QPoint', 'PySide2.QtGui.QColor'), ('int', 'int', 'PySide2.QtGui.QColor')],
        "QImage.setText": ('str', 'str'),
        "QImage.size": (),
        "QImage.sizeInBytes": (),
        "QImage.smoothScaled": ('int', 'int'),
        "QImage.swap": ('PySide2.QtGui.QImage',),
        "QImage.text": ('str',),
        "QImage.textKeys": (),
        "QImage.toImageFormat": ('PySide2.QtGui.QPixelFormat',),
        "QImage.toPixelFormat": ('PySide2.QtGui.QImage.Format',),
        "QImage.transformed": [('PySide2.QtGui.QMatrix', 'PySide2.QtCore.Qt.TransformationMode'), ('PySide2.QtGui.QTransform', 'PySide2.QtCore.Qt.TransformationMode')],
        "QImage.trueMatrix": [('PySide2.QtGui.QMatrix', 'int', 'int'), ('PySide2.QtGui.QTransform', 'int', 'int')],
        "QImage.valid": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QImage.width": (),

    # class PySide2.QtGui.QImageIOHandler:
        "QImageIOHandler.__init__": (),
        "QImageIOHandler.canRead": (),
        "QImageIOHandler.currentImageNumber": (),
        "QImageIOHandler.currentImageRect": (),
        "QImageIOHandler.device": (),
        "QImageIOHandler.format": (),
        "QImageIOHandler.imageCount": (),
        "QImageIOHandler.jumpToImage": ('int',),
        "QImageIOHandler.jumpToNextImage": (),
        "QImageIOHandler.loopCount": (),
        "QImageIOHandler.name": (),
        "QImageIOHandler.nextImageDelay": (),
        "QImageIOHandler.option": ('PySide2.QtGui.QImageIOHandler.ImageOption',),
        "QImageIOHandler.read": ('PySide2.QtGui.QImage',),
        "QImageIOHandler.setDevice": ('PySide2.QtCore.QIODevice',),
        "QImageIOHandler.setFormat": ('PySide2.QtCore.QByteArray',),
        "QImageIOHandler.setOption": ('PySide2.QtGui.QImageIOHandler.ImageOption', 'typing.Any'),
        "QImageIOHandler.supportsOption": ('PySide2.QtGui.QImageIOHandler.ImageOption',),
        "QImageIOHandler.write": ('PySide2.QtGui.QImage',),

    # class PySide2.QtGui.QImageReader:
        "QImageReader.__init__": [(), ('PySide2.QtCore.QIODevice', 'PySide2.QtCore.QByteArray'), ('str', 'PySide2.QtCore.QByteArray')],
        "QImageReader.autoDetectImageFormat": (),
        "QImageReader.autoTransform": (),
        "QImageReader.backgroundColor": (),
        "QImageReader.canRead": (),
        "QImageReader.clipRect": (),
        "QImageReader.currentImageNumber": (),
        "QImageReader.currentImageRect": (),
        "QImageReader.decideFormatFromContent": (),
        "QImageReader.device": (),
        "QImageReader.error": (),
        "QImageReader.errorString": (),
        "QImageReader.fileName": (),
        "QImageReader.format": (),
        "QImageReader.gamma": (),
        "QImageReader.imageCount": (),
        "QImageReader.imageFormat": [(), ('PySide2.QtCore.QIODevice',), ('str',)],
        "QImageReader.imageFormatsForMimeType": ('PySide2.QtCore.QByteArray',),
        "QImageReader.jumpToImage": ('int',),
        "QImageReader.jumpToNextImage": (),
        "QImageReader.loopCount": (),
        "QImageReader.nextImageDelay": (),
        "QImageReader.quality": (),
        "QImageReader.read": (),
        "QImageReader.scaledClipRect": (),
        "QImageReader.scaledSize": (),
        "QImageReader.setAutoDetectImageFormat": ('bool',),
        "QImageReader.setAutoTransform": ('bool',),
        "QImageReader.setBackgroundColor": ('PySide2.QtGui.QColor',),
        "QImageReader.setClipRect": ('PySide2.QtCore.QRect',),
        "QImageReader.setDecideFormatFromContent": ('bool',),
        "QImageReader.setDevice": ('PySide2.QtCore.QIODevice',),
        "QImageReader.setFileName": ('str',),
        "QImageReader.setFormat": ('PySide2.QtCore.QByteArray',),
        "QImageReader.setGamma": ('float',),
        "QImageReader.setQuality": ('int',),
        "QImageReader.setScaledClipRect": ('PySide2.QtCore.QRect',),
        "QImageReader.setScaledSize": ('PySide2.QtCore.QSize',),
        "QImageReader.size": (),
        "QImageReader.subType": (),
        "QImageReader.supportedImageFormats": (),
        "QImageReader.supportedMimeTypes": (),
        "QImageReader.supportedSubTypes": (),
        "QImageReader.supportsAnimation": (),
        "QImageReader.supportsOption": ('PySide2.QtGui.QImageIOHandler.ImageOption',),
        "QImageReader.text": ('str',),
        "QImageReader.textKeys": (),
        "QImageReader.transformation": (),

    # class PySide2.QtGui.QImageWriter:
        "QImageWriter.__init__": [(), ('PySide2.QtCore.QIODevice', 'PySide2.QtCore.QByteArray'), ('str', 'PySide2.QtCore.QByteArray')],
        "QImageWriter.canWrite": (),
        "QImageWriter.compression": (),
        "QImageWriter.description": (),
        "QImageWriter.device": (),
        "QImageWriter.error": (),
        "QImageWriter.errorString": (),
        "QImageWriter.fileName": (),
        "QImageWriter.format": (),
        "QImageWriter.gamma": (),
        "QImageWriter.imageFormatsForMimeType": ('PySide2.QtCore.QByteArray',),
        "QImageWriter.optimizedWrite": (),
        "QImageWriter.progressiveScanWrite": (),
        "QImageWriter.quality": (),
        "QImageWriter.setCompression": ('int',),
        "QImageWriter.setDescription": ('str',),
        "QImageWriter.setDevice": ('PySide2.QtCore.QIODevice',),
        "QImageWriter.setFileName": ('str',),
        "QImageWriter.setFormat": ('PySide2.QtCore.QByteArray',),
        "QImageWriter.setGamma": ('float',),
        "QImageWriter.setOptimizedWrite": ('bool',),
        "QImageWriter.setProgressiveScanWrite": ('bool',),
        "QImageWriter.setQuality": ('int',),
        "QImageWriter.setSubType": ('PySide2.QtCore.QByteArray',),
        "QImageWriter.setText": ('str', 'str'),
        "QImageWriter.setTransformation": ('PySide2.QtGui.QImageIOHandler.Transformations',),
        "QImageWriter.subType": (),
        "QImageWriter.supportedImageFormats": (),
        "QImageWriter.supportedMimeTypes": (),
        "QImageWriter.supportedSubTypes": (),
        "QImageWriter.supportsOption": ('PySide2.QtGui.QImageIOHandler.ImageOption',),
        "QImageWriter.transformation": (),
        "QImageWriter.write": ('PySide2.QtGui.QImage',),

    # class PySide2.QtGui.QInputEvent:
        "QInputEvent.__init__": ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.Qt.KeyboardModifiers'),
        "QInputEvent.modifiers": (),
        "QInputEvent.setModifiers": ('PySide2.QtCore.Qt.KeyboardModifiers',),
        "QInputEvent.setTimestamp": ('int',),
        "QInputEvent.timestamp": (),

    # class PySide2.QtGui.QInputMethod:
        "QInputMethod.anchorRectangle": (),
        "QInputMethod.commit": (),
        "QInputMethod.cursorRectangle": (),
        "QInputMethod.hide": (),
        "QInputMethod.inputDirection": (),
        "QInputMethod.inputItemClipRectangle": (),
        "QInputMethod.inputItemRectangle": (),
        "QInputMethod.inputItemTransform": (),
        "QInputMethod.invokeAction": ('PySide2.QtGui.QInputMethod.Action', 'int'),
        "QInputMethod.isAnimating": (),
        "QInputMethod.isVisible": (),
        "QInputMethod.keyboardRectangle": (),
        "QInputMethod.locale": (),
        "QInputMethod.queryFocusObject": ('PySide2.QtCore.Qt.InputMethodQuery', 'typing.Any'),
        "QInputMethod.reset": (),
        "QInputMethod.setInputItemRectangle": ('PySide2.QtCore.QRectF',),
        "QInputMethod.setInputItemTransform": ('PySide2.QtGui.QTransform',),
        "QInputMethod.setVisible": ('bool',),
        "QInputMethod.show": (),
        "QInputMethod.update": ('PySide2.QtCore.Qt.InputMethodQueries',),

    # class PySide2.QtGui.QInputMethodEvent:
        "QInputMethodEvent.__init__": [(), ('PySide2.QtGui.QInputMethodEvent',), ('str', 'list')],
        "QInputMethodEvent.attributes": (),
        "QInputMethodEvent.commitString": (),
        "QInputMethodEvent.preeditString": (),
        "QInputMethodEvent.replacementLength": (),
        "QInputMethodEvent.replacementStart": (),
        "QInputMethodEvent.setCommitString": ('str', 'int', 'int'),

    # class PySide2.QtGui.QInputMethodEvent.Attribute:
        "QInputMethodEvent.Attribute.__init__": [('PySide2.QtGui.QInputMethodEvent.Attribute',), ('PySide2.QtGui.QInputMethodEvent.AttributeType', 'int', 'int'), ('PySide2.QtGui.QInputMethodEvent.AttributeType', 'int', 'int', 'typing.Any')],
        "QInputMethodEvent.Attribute.__copy__": (),

    # class PySide2.QtGui.QInputMethodQueryEvent:
        "QInputMethodQueryEvent.__init__": ('PySide2.QtCore.Qt.InputMethodQueries',),
        "QInputMethodQueryEvent.queries": (),
        "QInputMethodQueryEvent.setValue": ('PySide2.QtCore.Qt.InputMethodQuery', 'typing.Any'),
        "QInputMethodQueryEvent.value": ('PySide2.QtCore.Qt.InputMethodQuery',),

    # class PySide2.QtGui.QIntValidator:
        "QIntValidator.__init__": [('PySide2.QtCore.QObject',), ('int', 'int', 'PySide2.QtCore.QObject')],
        "QIntValidator.bottom": (),
        "QIntValidator.fixup": ('str',),
        "QIntValidator.setBottom": ('int',),
        "QIntValidator.setRange": ('int', 'int'),
        "QIntValidator.setTop": ('int',),
        "QIntValidator.top": (),
        "QIntValidator.validate": ('str', 'int'),

    # class PySide2.QtGui.QKeyEvent:
        "QKeyEvent.__init__": [('PySide2.QtCore.QEvent.Type', 'int', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int', 'int', 'int', 'str', 'bool', 'int'), ('PySide2.QtCore.QEvent.Type', 'int', 'PySide2.QtCore.Qt.KeyboardModifiers', 'str', 'bool', 'int')],
        "QKeyEvent.count": (),
        "QKeyEvent.isAutoRepeat": (),
        "QKeyEvent.key": (),
        "QKeyEvent.matches": ('PySide2.QtGui.QKeySequence.StandardKey',),
        "QKeyEvent.modifiers": (),
        "QKeyEvent.nativeModifiers": (),
        "QKeyEvent.nativeScanCode": (),
        "QKeyEvent.nativeVirtualKey": (),
        "QKeyEvent.text": (),

    # class PySide2.QtGui.QKeySequence:
        "QKeySequence.__init__": [(), ('PySide2.QtGui.QKeySequence',), ('PySide2.QtGui.QKeySequence.StandardKey',), ('int', 'int', 'int', 'int'), ('str', 'PySide2.QtGui.QKeySequence.SequenceFormat')],
        "QKeySequence.__copy__": (),
        "QKeySequence.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QKeySequence.__reduce__": (),
        "QKeySequence.__repr__": (),
        "QKeySequence.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QKeySequence.count": (),
        "QKeySequence.fromString": ('str', 'PySide2.QtGui.QKeySequence.SequenceFormat'),
        "QKeySequence.isEmpty": (),
        "QKeySequence.keyBindings": ('PySide2.QtGui.QKeySequence.StandardKey',),
        "QKeySequence.listFromString": ('str', 'PySide2.QtGui.QKeySequence.SequenceFormat'),
        "QKeySequence.listToString": ('list', 'PySide2.QtGui.QKeySequence.SequenceFormat'),
        "QKeySequence.matches": ('PySide2.QtGui.QKeySequence',),
        "QKeySequence.mnemonic": ('str',),
        "QKeySequence.swap": ('PySide2.QtGui.QKeySequence',),
        "QKeySequence.toString": ('PySide2.QtGui.QKeySequence.SequenceFormat',),

    # class PySide2.QtGui.QLinearGradient:
        "QLinearGradient.__init__": [(), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'), ('PySide2.QtGui.QLinearGradient',), ('float', 'float', 'float', 'float')],
        "QLinearGradient.__copy__": (),
        "QLinearGradient.finalStop": (),
        "QLinearGradient.setFinalStop": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QLinearGradient.setStart": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QLinearGradient.start": (),

    # class PySide2.QtGui.QMatrix:
        "QMatrix.__init__": [(), ('PySide2.QtGui.QMatrix',), ('float', 'float', 'float', 'float', 'float', 'float')],
        "QMatrix.__copy__": (),
        "QMatrix.__imul__": ('PySide2.QtGui.QMatrix',),
        "QMatrix.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QMatrix.__mul__": [('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QMatrix',)],
        "QMatrix.__reduce__": (),
        "QMatrix.__repr__": (),
        "QMatrix.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QMatrix.determinant": (),
        "QMatrix.dx": (),
        "QMatrix.dy": (),
        "QMatrix.inverted": ('bool',),
        "QMatrix.isIdentity": (),
        "QMatrix.isInvertible": (),
        "QMatrix.m11": (),
        "QMatrix.m12": (),
        "QMatrix.m21": (),
        "QMatrix.m22": (),
        "QMatrix.map": [('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygon',), ('PySide2.QtGui.QPolygonF',), ('PySide2.QtGui.QRegion',), ('float', 'float', 'float', 'float'), ('int', 'int', 'int', 'int')],
        "QMatrix.mapRect": [('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',)],
        "QMatrix.mapToPolygon": ('PySide2.QtCore.QRect',),
        "QMatrix.reset": (),
        "QMatrix.rotate": ('float',),
        "QMatrix.scale": ('float', 'float'),
        "QMatrix.setMatrix": ('float', 'float', 'float', 'float', 'float', 'float'),
        "QMatrix.shear": ('float', 'float'),
        "QMatrix.translate": ('float', 'float'),

    # class PySide2.QtGui.QMatrix2x2:
        "QMatrix2x2.__init__": [(), ('PySide2.QtGui.QMatrix2x2',), ('typing.Iterable',)],
        "QMatrix2x2.__call__": ('int', 'int'),
        "QMatrix2x2.__copy__": (),
        "QMatrix2x2.__iadd__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix2x2.__imul__": ('float',),
        "QMatrix2x2.__isub__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix2x2.__reduce__": (),
        "QMatrix2x2.__repr__": (),
        "QMatrix2x2.constData": (),
        "QMatrix2x2.data": (),
        "QMatrix2x2.fill": ('float',),
        "QMatrix2x2.isIdentity": (),
        "QMatrix2x2.setToIdentity": (),
        "QMatrix2x2.transposed": (),

    # class PySide2.QtGui.QMatrix2x3:
        "QMatrix2x3.__init__": [(), ('PySide2.QtGui.QMatrix2x3',), ('typing.Iterable',)],
        "QMatrix2x3.__call__": ('int', 'int'),
        "QMatrix2x3.__copy__": (),
        "QMatrix2x3.__iadd__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix2x3.__imul__": ('float',),
        "QMatrix2x3.__isub__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix2x3.__reduce__": (),
        "QMatrix2x3.__repr__": (),
        "QMatrix2x3.constData": (),
        "QMatrix2x3.data": (),
        "QMatrix2x3.fill": ('float',),
        "QMatrix2x3.isIdentity": (),
        "QMatrix2x3.setToIdentity": (),
        "QMatrix2x3.transposed": (),

    # class PySide2.QtGui.QMatrix2x4:
        "QMatrix2x4.__init__": [(), ('PySide2.QtGui.QMatrix2x4',), ('typing.Iterable',)],
        "QMatrix2x4.__call__": ('int', 'int'),
        "QMatrix2x4.__copy__": (),
        "QMatrix2x4.__iadd__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix2x4.__imul__": ('float',),
        "QMatrix2x4.__isub__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix2x4.__reduce__": (),
        "QMatrix2x4.__repr__": (),
        "QMatrix2x4.constData": (),
        "QMatrix2x4.data": (),
        "QMatrix2x4.fill": ('float',),
        "QMatrix2x4.isIdentity": (),
        "QMatrix2x4.setToIdentity": (),
        "QMatrix2x4.transposed": (),

    # class PySide2.QtGui.QMatrix3x2:
        "QMatrix3x2.__init__": [(), ('PySide2.QtGui.QMatrix3x2',), ('typing.Iterable',)],
        "QMatrix3x2.__call__": ('int', 'int'),
        "QMatrix3x2.__copy__": (),
        "QMatrix3x2.__iadd__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix3x2.__imul__": ('float',),
        "QMatrix3x2.__isub__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix3x2.__reduce__": (),
        "QMatrix3x2.__repr__": (),
        "QMatrix3x2.constData": (),
        "QMatrix3x2.data": (),
        "QMatrix3x2.fill": ('float',),
        "QMatrix3x2.isIdentity": (),
        "QMatrix3x2.setToIdentity": (),
        "QMatrix3x2.transposed": (),

    # class PySide2.QtGui.QMatrix3x3:
        "QMatrix3x3.__init__": [(), ('PySide2.QtGui.QMatrix3x3',), ('typing.Iterable',)],
        "QMatrix3x3.__call__": ('int', 'int'),
        "QMatrix3x3.__copy__": (),
        "QMatrix3x3.__iadd__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix3x3.__imul__": ('float',),
        "QMatrix3x3.__isub__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix3x3.__reduce__": (),
        "QMatrix3x3.__repr__": (),
        "QMatrix3x3.constData": (),
        "QMatrix3x3.data": (),
        "QMatrix3x3.fill": ('float',),
        "QMatrix3x3.isIdentity": (),
        "QMatrix3x3.setToIdentity": (),
        "QMatrix3x3.transposed": (),

    # class PySide2.QtGui.QMatrix3x4:
        "QMatrix3x4.__init__": [(), ('PySide2.QtGui.QMatrix3x4',), ('typing.Iterable',)],
        "QMatrix3x4.__call__": ('int', 'int'),
        "QMatrix3x4.__copy__": (),
        "QMatrix3x4.__iadd__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix3x4.__imul__": ('float',),
        "QMatrix3x4.__isub__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix3x4.__reduce__": (),
        "QMatrix3x4.__repr__": (),
        "QMatrix3x4.constData": (),
        "QMatrix3x4.data": (),
        "QMatrix3x4.fill": ('float',),
        "QMatrix3x4.isIdentity": (),
        "QMatrix3x4.setToIdentity": (),
        "QMatrix3x4.transposed": (),

    # class PySide2.QtGui.QMatrix4x2:
        "QMatrix4x2.__init__": [(), ('PySide2.QtGui.QMatrix4x2',), ('typing.Iterable',)],
        "QMatrix4x2.__call__": ('int', 'int'),
        "QMatrix4x2.__copy__": (),
        "QMatrix4x2.__iadd__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix4x2.__imul__": ('float',),
        "QMatrix4x2.__isub__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix4x2.__reduce__": (),
        "QMatrix4x2.__repr__": (),
        "QMatrix4x2.constData": (),
        "QMatrix4x2.data": (),
        "QMatrix4x2.fill": ('float',),
        "QMatrix4x2.isIdentity": (),
        "QMatrix4x2.setToIdentity": (),
        "QMatrix4x2.transposed": (),

    # class PySide2.QtGui.QMatrix4x3:
        "QMatrix4x3.__init__": [(), ('PySide2.QtGui.QMatrix4x3',), ('typing.Iterable',)],
        "QMatrix4x3.__call__": ('int', 'int'),
        "QMatrix4x3.__copy__": (),
        "QMatrix4x3.__iadd__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix4x3.__imul__": ('float',),
        "QMatrix4x3.__isub__": ('Missing("PySide2.QtGui.QGenericMatrix")',),
        "QMatrix4x3.__reduce__": (),
        "QMatrix4x3.__repr__": (),
        "QMatrix4x3.constData": (),
        "QMatrix4x3.data": (),
        "QMatrix4x3.fill": ('float',),
        "QMatrix4x3.isIdentity": (),
        "QMatrix4x3.setToIdentity": (),
        "QMatrix4x3.transposed": (),

    # class PySide2.QtGui.QMatrix4x4:
        "QMatrix4x4.__init__": [(), ('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',), ('float',), ('float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float')],
        "QMatrix4x4.__add__": ('PySide2.QtGui.QMatrix4x4',),
        "QMatrix4x4.__copy__": (),
        "QMatrix4x4.__iadd__": ('PySide2.QtGui.QMatrix4x4',),
        "QMatrix4x4.__imul__": [('PySide2.QtGui.QMatrix4x4',), ('float',)],
        "QMatrix4x4.__isub__": ('PySide2.QtGui.QMatrix4x4',),
        "QMatrix4x4.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QMatrix4x4.__mul__": [('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QMatrix4x4',), ('float',)],
        "QMatrix4x4.__neg__": (),
        "QMatrix4x4.__reduce__": (),
        "QMatrix4x4.__repr__": (),
        "QMatrix4x4.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QMatrix4x4.__sub__": ('PySide2.QtGui.QMatrix4x4',),
        "QMatrix4x4.column": ('int',),
        "QMatrix4x4.copyDataTo": ('float',),
        "QMatrix4x4.data": (),
        "QMatrix4x4.determinant": (),
        "QMatrix4x4.fill": ('float',),
        "QMatrix4x4.flipCoordinates": (),
        "QMatrix4x4.frustum": ('float', 'float', 'float', 'float', 'float', 'float'),
        "QMatrix4x4.inverted": ('bool',),
        "QMatrix4x4.isAffine": (),
        "QMatrix4x4.isIdentity": (),
        "QMatrix4x4.lookAt": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
        "QMatrix4x4.map": [('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QVector3D',), ('PySide2.QtGui.QVector4D',)],
        "QMatrix4x4.mapRect": [('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',)],
        "QMatrix4x4.mapVector": ('PySide2.QtGui.QVector3D',),
        "QMatrix4x4.normalMatrix": (),
        "QMatrix4x4.optimize": (),
        "QMatrix4x4.ortho": [('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float', 'float', 'float')],
        "QMatrix4x4.perspective": ('float', 'float', 'float', 'float'),
        "QMatrix4x4.rotate": [('PySide2.QtGui.QQuaternion',), ('float', 'PySide2.QtGui.QVector3D'), ('float', 'float', 'float', 'float')],
        "QMatrix4x4.row": ('int',),
        "QMatrix4x4.scale": [('PySide2.QtGui.QVector3D',), ('float',), ('float', 'float'), ('float', 'float', 'float')],
        "QMatrix4x4.setColumn": ('int', 'PySide2.QtGui.QVector4D'),
        "QMatrix4x4.setRow": ('int', 'PySide2.QtGui.QVector4D'),
        "QMatrix4x4.setToIdentity": (),
        "QMatrix4x4.toAffine": (),
        "QMatrix4x4.toTransform": [(), ('float',)],
        "QMatrix4x4.translate": [('PySide2.QtGui.QVector3D',), ('float', 'float'), ('float', 'float', 'float')],
        "QMatrix4x4.transposed": (),
        "QMatrix4x4.viewport": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float', 'float', 'float')],

    # class PySide2.QtGui.QMouseEvent:
        "QMouseEvent.__init__": [('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers'), ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.MouseEventSource'), ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers'), ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers')],
        "QMouseEvent.button": (),
        "QMouseEvent.buttons": (),
        "QMouseEvent.flags": (),
        "QMouseEvent.globalPos": (),
        "QMouseEvent.globalX": (),
        "QMouseEvent.global""Y": (),
        "QMouseEvent.localPos": (),
        "QMouseEvent.pos": (),
        "QMouseEvent.screenPos": (),
        "QMouseEvent.setLocalPos": ('PySide2.QtCore.QPointF',),
        "QMouseEvent.source": (),
        "QMouseEvent.windowPos": (),
        "QMouseEvent.x": (),
        "QMouseEvent.y": (),

    # class PySide2.QtGui.QMoveEvent:
        "QMoveEvent.__init__": ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'),
        "QMoveEvent.oldPos": (),
        "QMoveEvent.pos": (),

    # class PySide2.QtGui.QMovie:
        "QMovie.__init__": [('PySide2.QtCore.QIODevice', 'PySide2.QtCore.QByteArray', 'PySide2.QtCore.QObject'), ('PySide2.QtCore.QObject',), ('str', 'PySide2.QtCore.QByteArray', 'PySide2.QtCore.QObject')],
        "QMovie.backgroundColor": (),
        "QMovie.cacheMode": (),
        "QMovie.currentFrameNumber": (),
        "QMovie.currentImage": (),
        "QMovie.currentPixmap": (),
        "QMovie.device": (),
        "QMovie.fileName": (),
        "QMovie.format": (),
        "QMovie.frameCount": (),
        "QMovie.frameRect": (),
        "QMovie.isValid": (),
        "QMovie.jumpToFrame": ('int',),
        "QMovie.jumpToNextFrame": (),
        "QMovie.lastError": (),
        "QMovie.lastErrorString": (),
        "QMovie.loopCount": (),
        "QMovie.nextFrameDelay": (),
        "QMovie.scaledSize": (),
        "QMovie.setBackgroundColor": ('PySide2.QtGui.QColor',),
        "QMovie.setCacheMode": ('PySide2.QtGui.QMovie.CacheMode',),
        "QMovie.setDevice": ('PySide2.QtCore.QIODevice',),
        "QMovie.setFileName": ('str',),
        "QMovie.setFormat": ('PySide2.QtCore.QByteArray',),
        "QMovie.setPaused": ('bool',),
        "QMovie.setScaledSize": ('PySide2.QtCore.QSize',),
        "QMovie.setSpeed": ('int',),
        "QMovie.speed": (),
        "QMovie.start": (),
        "QMovie.state": (),
        "QMovie.stop": (),
        "QMovie.supportedFormats": (),

    # class PySide2.QtGui.QNativeGestureEvent:
        "QNativeGestureEvent.__init__": [('PySide2.QtCore.Qt.NativeGestureType', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'float', 'int', 'int'), ('PySide2.QtCore.Qt.NativeGestureType', 'PySide2.QtGui.QTouchDevice', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'float', 'int', 'int')],
        "QNativeGestureEvent.device": (),
        "QNativeGestureEvent.gestureType": (),
        "QNativeGestureEvent.globalPos": (),
        "QNativeGestureEvent.localPos": (),
        "QNativeGestureEvent.pos": (),
        "QNativeGestureEvent.screenPos": (),
        "QNativeGestureEvent.value": (),
        "QNativeGestureEvent.windowPos": (),

    # class PySide2.QtGui.QOffscreenSurface:
        "QOffscreenSurface.__init__": [('PySide2.QtGui.QScreen',), ('PySide2.QtGui.QScreen', 'PySide2.QtCore.QObject')],
        "QOffscreenSurface.create": (),
        "QOffscreenSurface.destroy": (),
        "QOffscreenSurface.format": (),
        "QOffscreenSurface.isValid": (),
        "QOffscreenSurface.nativeHandle": (),
        "QOffscreenSurface.requestedFormat": (),
        "QOffscreenSurface.screen": (),
        "QOffscreenSurface.setFormat": ('PySide2.QtGui.QSurfaceFormat',),
        "QOffscreenSurface.setNativeHandle": ('int',),
        "QOffscreenSurface.setScreen": ('PySide2.QtGui.QScreen',),
        "QOffscreenSurface.size": (),
        "QOffscreenSurface.surfaceHandle": (),
        "QOffscreenSurface.surfaceType": (),

    # class PySide2.QtGui.QOpenGLBuffer:
        "QOpenGLBuffer.__init__": [(), ('PySide2.QtGui.QOpenGLBuffer',), ('PySide2.QtGui.QOpenGLBuffer.Type',)],
        "QOpenGLBuffer.allocate": [('int',), ('int', 'int')],
        "QOpenGLBuffer.bind": (),
        "QOpenGLBuffer.bufferId": (),
        "QOpenGLBuffer.create": (),
        "QOpenGLBuffer.destroy": (),
        "QOpenGLBuffer.isCreated": (),
        "QOpenGLBuffer.map": ('PySide2.QtGui.QOpenGLBuffer.Access',),
        "QOpenGLBuffer.mapRange": ('int', 'int', 'PySide2.QtGui.QOpenGLBuffer.RangeAccessFlags'),
        "QOpenGLBuffer.read": ('int', 'int', 'int'),
        "QOpenGLBuffer.release": [(), ('PySide2.QtGui.QOpenGLBuffer.Type',)],
        "QOpenGLBuffer.setUsagePattern": ('PySide2.QtGui.QOpenGLBuffer.UsagePattern',),
        "QOpenGLBuffer.size": (),
        "QOpenGLBuffer.type": (),
        "QOpenGLBuffer.unmap": (),
        "QOpenGLBuffer.usagePattern": (),
        "QOpenGLBuffer.write": ('int', 'int', 'int'),

    # class PySide2.QtGui.QOpenGLContext:
        "QOpenGLContext.__init__": ('PySide2.QtCore.QObject',),
        "QOpenGLContext.areSharing": ('PySide2.QtGui.QOpenGLContext', 'PySide2.QtGui.QOpenGLContext'),
        "QOpenGLContext.create": (),
        "QOpenGLContext.currentContext": (),
        "QOpenGLContext.defaultFramebufferObject": (),
        "QOpenGLContext.doneCurrent": (),
        "QOpenGLContext.extensions": (),
        "QOpenGLContext.extraFunctions": (),
        "QOpenGLContext.format": (),
        "QOpenGLContext.functions": (),
        "QOpenGLContext.globalShareContext": (),
        "QOpenGLContext.hasExtension": ('PySide2.QtCore.QByteArray',),
        "QOpenGLContext.isOpenGLES": (),
        "QOpenGLContext.isValid": (),
        "QOpenGLContext.makeCurrent": ('PySide2.QtGui.QSurface',),
        "QOpenGLContext.nativeHandle": (),
        "QOpenGLContext.openGLModuleHandle": (),
        "QOpenGLContext.openGLModuleType": (),
        "QOpenGLContext.screen": (),
        "QOpenGLContext.setFormat": ('PySide2.QtGui.QSurfaceFormat',),
        "QOpenGLContext.setNativeHandle": ('typing.Any',),
        "QOpenGLContext.setScreen": ('PySide2.QtGui.QScreen',),
        "QOpenGLContext.setShareContext": ('PySide2.QtGui.QOpenGLContext',),
        "QOpenGLContext.shareContext": (),
        "QOpenGLContext.shareGroup": (),
        "QOpenGLContext.supportsThreadedOpenGL": (),
        "QOpenGLContext.surface": (),
        "QOpenGLContext.swapBuffers": ('PySide2.QtGui.QSurface',),
        "QOpenGLContext.versionFunctions": ('PySide2.QtGui.QOpenGLVersionProfile',),

    # class PySide2.QtGui.QOpenGLContextGroup:
        "QOpenGLContextGroup.currentContextGroup": (),
        "QOpenGLContextGroup.shares": (),

    # class PySide2.QtGui.QOpenGLDebugLogger:
        "QOpenGLDebugLogger.__init__": ('PySide2.QtCore.QObject',),
        "QOpenGLDebugLogger.disableMessages": [('PySide2.QtGui.QOpenGLDebugMessage.Sources', 'PySide2.QtGui.QOpenGLDebugMessage.Types', 'PySide2.QtGui.QOpenGLDebugMessage.Severities'), ('list', 'PySide2.QtGui.QOpenGLDebugMessage.Sources', 'PySide2.QtGui.QOpenGLDebugMessage.Types')],
        "QOpenGLDebugLogger.enableMessages": [('PySide2.QtGui.QOpenGLDebugMessage.Sources', 'PySide2.QtGui.QOpenGLDebugMessage.Types', 'PySide2.QtGui.QOpenGLDebugMessage.Severities'), ('list', 'PySide2.QtGui.QOpenGLDebugMessage.Sources', 'PySide2.QtGui.QOpenGLDebugMessage.Types')],
        "QOpenGLDebugLogger.initialize": (),
        "QOpenGLDebugLogger.isLogging": (),
        "QOpenGLDebugLogger.logMessage": ('PySide2.QtGui.QOpenGLDebugMessage',),
        "QOpenGLDebugLogger.loggedMessages": (),
        "QOpenGLDebugLogger.loggingMode": (),
        "QOpenGLDebugLogger.maximumMessageLength": (),
        "QOpenGLDebugLogger.popGroup": (),
        "QOpenGLDebugLogger.pushGroup": ('str', 'int', 'PySide2.QtGui.QOpenGLDebugMessage.Source'),
        "QOpenGLDebugLogger.startLogging": ('PySide2.QtGui.QOpenGLDebugLogger.LoggingMode',),
        "QOpenGLDebugLogger.stopLogging": (),

    # class PySide2.QtGui.QOpenGLDebugMessage:
        "QOpenGLDebugMessage.__init__": [(), ('PySide2.QtGui.QOpenGLDebugMessage',)],
        "QOpenGLDebugMessage.__copy__": (),
        "QOpenGLDebugMessage.createApplicationMessage": ('str', 'int', 'PySide2.QtGui.QOpenGLDebugMessage.Severity', 'PySide2.QtGui.QOpenGLDebugMessage.Type'),
        "QOpenGLDebugMessage.createThirdPartyMessage": ('str', 'int', 'PySide2.QtGui.QOpenGLDebugMessage.Severity', 'PySide2.QtGui.QOpenGLDebugMessage.Type'),
        "QOpenGLDebugMessage.id": (),
        "QOpenGLDebugMessage.message": (),
        "QOpenGLDebugMessage.severity": (),
        "QOpenGLDebugMessage.source": (),
        "QOpenGLDebugMessage.swap": ('PySide2.QtGui.QOpenGLDebugMessage',),
        "QOpenGLDebugMessage.type": (),

    # class PySide2.QtGui.QOpenGLExtraFunctions:
        "QOpenGLExtraFunctions.__init__": [(), ('PySide2.QtGui.QOpenGLContext',)],
        "QOpenGLExtraFunctions.glActiveShaderProgram": ('int', 'int'),
        "QOpenGLExtraFunctions.glBeginQuery": ('int', 'int'),
        "QOpenGLExtraFunctions.glBeginTransformFeedback": ('int',),
        "QOpenGLExtraFunctions.glBindBufferBase": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glBindImageTexture": ('int', 'int', 'int', 'typing.Union[str, int]', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glBindProgramPipeline": ('int',),
        "QOpenGLExtraFunctions.glBindSampler": ('int', 'int'),
        "QOpenGLExtraFunctions.glBindTransformFeedback": ('int', 'int'),
        "QOpenGLExtraFunctions.glBindVertexArray": ('int',),
        "QOpenGLExtraFunctions.glBlendBarrier": (),
        "QOpenGLExtraFunctions.glBlendEquationSeparatei": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glBlendEquationi": ('int', 'int'),
        "QOpenGLExtraFunctions.glBlendFuncSeparatei": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glBlendFunci": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glBlitFramebuffer": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glClearBufferfi": ('int', 'int', 'float', 'int'),
        "QOpenGLExtraFunctions.glClearBufferfv": ('int', 'int', 'float'),
        "QOpenGLExtraFunctions.glClearBufferiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glClearBufferuiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glColorMaski": ('int', 'typing.Union[str, int]', 'typing.Union[str, int]', 'typing.Union[str, int]', 'typing.Union[str, int]'),
        "QOpenGLExtraFunctions.glCompressedTexImage3D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glCompressedTexSubImage3D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glCopyImageSubData": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glCopyTexSubImage3D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glDebugMessageControl": ('int', 'int', 'int', 'int', 'int', 'typing.Union[str, int]'),
        "QOpenGLExtraFunctions.glDebugMessageInsert": ('int', 'int', 'int', 'int', 'int', 'str'),
        "QOpenGLExtraFunctions.glDeleteProgramPipelines": ('int', 'int'),
        "QOpenGLExtraFunctions.glDeleteQueries": ('int', 'int'),
        "QOpenGLExtraFunctions.glDeleteSamplers": ('int', 'int'),
        "QOpenGLExtraFunctions.glDeleteTransformFeedbacks": ('int', 'int'),
        "QOpenGLExtraFunctions.glDeleteVertexArrays": ('int', 'int'),
        "QOpenGLExtraFunctions.glDisablei": ('int', 'int'),
        "QOpenGLExtraFunctions.glDispatchCompute": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glDrawArraysIndirect": ('int', 'int'),
        "QOpenGLExtraFunctions.glDrawArraysInstanced": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glDrawBuffers": ('int', 'int'),
        "QOpenGLExtraFunctions.glDrawElementsBaseVertex": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glDrawElementsIndirect": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glDrawElementsInstanced": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glDrawElementsInstancedBaseVertex": ('int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glDrawRangeElements": ('int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glDrawRangeElementsBaseVertex": ('int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glEnablei": ('int', 'int'),
        "QOpenGLExtraFunctions.glEndQuery": ('int',),
        "QOpenGLExtraFunctions.glFramebufferParameteri": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glFramebufferTexture": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glFramebufferTextureLayer": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGenProgramPipelines": ('int', 'int'),
        "QOpenGLExtraFunctions.glGenQueries": ('int', 'int'),
        "QOpenGLExtraFunctions.glGenSamplers": ('int', 'int'),
        "QOpenGLExtraFunctions.glGenTransformFeedbacks": ('int', 'int'),
        "QOpenGLExtraFunctions.glGenVertexArrays": ('int', 'int'),
        "QOpenGLExtraFunctions.glGetActiveUniformBlockiv": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetActiveUniformsiv": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetBufferParameteri64v": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetFragDataLocation": ('int', 'str'),
        "QOpenGLExtraFunctions.glGetFramebufferParameteriv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetGraphicsResetStatus": (),
        "QOpenGLExtraFunctions.glGetInteger64i_v": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetInteger64v": ('int', 'int'),
        "QOpenGLExtraFunctions.glGetIntegeri_v": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetInternalformativ": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetMultisamplefv": ('int', 'int', 'float'),
        "QOpenGLExtraFunctions.glGetProgramBinary": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetProgramInterfaceiv": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetProgramPipelineiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetProgramResourceIndex": ('int', 'int', 'str'),
        "QOpenGLExtraFunctions.glGetProgramResourceLocation": ('int', 'int', 'str'),
        "QOpenGLExtraFunctions.glGetProgramResourceiv": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetQueryObjectuiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetQueryiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetSamplerParameterIiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetSamplerParameterIuiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetSamplerParameterfv": ('int', 'int', 'float'),
        "QOpenGLExtraFunctions.glGetSamplerParameteriv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetStringi": ('int', 'int'),
        "QOpenGLExtraFunctions.glGetTexLevelParameterfv": ('int', 'int', 'int', 'float'),
        "QOpenGLExtraFunctions.glGetTexLevelParameteriv": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetTexParameterIiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetTexParameterIuiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetUniformBlockIndex": ('int', 'str'),
        "QOpenGLExtraFunctions.glGetUniformuiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetVertexAttribIiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetVertexAttribIuiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetnUniformfv": ('int', 'int', 'int', 'float'),
        "QOpenGLExtraFunctions.glGetnUniformiv": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glGetnUniformuiv": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glInvalidateFramebuffer": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glInvalidateSubFramebuffer": ('int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glIsEnabledi": ('int', 'int'),
        "QOpenGLExtraFunctions.glIsProgramPipeline": ('int',),
        "QOpenGLExtraFunctions.glIsQuery": ('int',),
        "QOpenGLExtraFunctions.glIsSampler": ('int',),
        "QOpenGLExtraFunctions.glIsTransformFeedback": ('int',),
        "QOpenGLExtraFunctions.glIsVertexArray": ('int',),
        "QOpenGLExtraFunctions.glMemoryBarrier": ('int',),
        "QOpenGLExtraFunctions.glMemoryBarrierByRegion": ('int',),
        "QOpenGLExtraFunctions.glMinSampleShading": ('float',),
        "QOpenGLExtraFunctions.glObjectLabel": ('int', 'int', 'int', 'str'),
        "QOpenGLExtraFunctions.glObjectPtrLabel": ('int', 'int', 'str'),
        "QOpenGLExtraFunctions.glPatchParameteri": ('int', 'int'),
        "QOpenGLExtraFunctions.glPopDebugGroup": (),
        "QOpenGLExtraFunctions.glPrimitiveBoundingBox": ('float', 'float', 'float', 'float', 'float', 'float', 'float', 'float'),
        "QOpenGLExtraFunctions.glProgramBinary": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramParameteri": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform1f": ('int', 'int', 'float'),
        "QOpenGLExtraFunctions.glProgramUniform1fv": ('int', 'int', 'int', 'float'),
        "QOpenGLExtraFunctions.glProgramUniform1i": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform1iv": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform1ui": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform1uiv": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform2f": ('int', 'int', 'float', 'float'),
        "QOpenGLExtraFunctions.glProgramUniform2fv": ('int', 'int', 'int', 'float'),
        "QOpenGLExtraFunctions.glProgramUniform2i": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform2iv": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform2ui": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform2uiv": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform3f": ('int', 'int', 'float', 'float', 'float'),
        "QOpenGLExtraFunctions.glProgramUniform3fv": ('int', 'int', 'int', 'float'),
        "QOpenGLExtraFunctions.glProgramUniform3i": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform3iv": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform3ui": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform3uiv": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform4f": ('int', 'int', 'float', 'float', 'float', 'float'),
        "QOpenGLExtraFunctions.glProgramUniform4fv": ('int', 'int', 'int', 'float'),
        "QOpenGLExtraFunctions.glProgramUniform4i": ('int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform4iv": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform4ui": ('int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniform4uiv": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glProgramUniformMatrix2fv": ('int', 'int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLExtraFunctions.glProgramUniformMatrix2x3fv": ('int', 'int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLExtraFunctions.glProgramUniformMatrix2x4fv": ('int', 'int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLExtraFunctions.glProgramUniformMatrix3fv": ('int', 'int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLExtraFunctions.glProgramUniformMatrix3x2fv": ('int', 'int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLExtraFunctions.glProgramUniformMatrix3x4fv": ('int', 'int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLExtraFunctions.glProgramUniformMatrix4fv": ('int', 'int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLExtraFunctions.glProgramUniformMatrix4x2fv": ('int', 'int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLExtraFunctions.glProgramUniformMatrix4x3fv": ('int', 'int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLExtraFunctions.glPushDebugGroup": ('int', 'int', 'int', 'str'),
        "QOpenGLExtraFunctions.glReadBuffer": ('int',),
        "QOpenGLExtraFunctions.glReadnPixels": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glRenderbufferStorageMultisample": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glSampleMaski": ('int', 'int'),
        "QOpenGLExtraFunctions.glSamplerParameterIiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glSamplerParameterIuiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glSamplerParameterf": ('int', 'int', 'float'),
        "QOpenGLExtraFunctions.glSamplerParameterfv": ('int', 'int', 'float'),
        "QOpenGLExtraFunctions.glSamplerParameteri": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glSamplerParameteriv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glTexBuffer": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glTexImage3D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glTexParameterIiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glTexParameterIuiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glTexStorage2D": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glTexStorage2DMultisample": ('int', 'int', 'int', 'int', 'int', 'typing.Union[str, int]'),
        "QOpenGLExtraFunctions.glTexStorage3D": ('int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glTexStorage3DMultisample": ('int', 'int', 'int', 'int', 'int', 'int', 'typing.Union[str, int]'),
        "QOpenGLExtraFunctions.glTexSubImage3D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glUniform1ui": ('int', 'int'),
        "QOpenGLExtraFunctions.glUniform1uiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glUniform2ui": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glUniform2uiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glUniform3ui": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glUniform3uiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glUniform4ui": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glUniform4uiv": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glUniformBlockBinding": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glUniformMatrix2x3fv": ('int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLExtraFunctions.glUniformMatrix2x4fv": ('int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLExtraFunctions.glUniformMatrix3x2fv": ('int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLExtraFunctions.glUniformMatrix3x4fv": ('int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLExtraFunctions.glUniformMatrix4x2fv": ('int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLExtraFunctions.glUniformMatrix4x3fv": ('int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLExtraFunctions.glUnmapBuffer": ('int',),
        "QOpenGLExtraFunctions.glUseProgramStages": ('int', 'int', 'int'),
        "QOpenGLExtraFunctions.glValidateProgramPipeline": ('int',),
        "QOpenGLExtraFunctions.glVertexAttribBinding": ('int', 'int'),
        "QOpenGLExtraFunctions.glVertexAttribDivisor": ('int', 'int'),
        "QOpenGLExtraFunctions.glVertexAttribFormat": ('int', 'int', 'int', 'typing.Union[str, int]', 'int'),
        "QOpenGLExtraFunctions.glVertexAttribI4i": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glVertexAttribI4iv": ('int', 'int'),
        "QOpenGLExtraFunctions.glVertexAttribI4ui": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glVertexAttribI4uiv": ('int', 'int'),
        "QOpenGLExtraFunctions.glVertexAttribIFormat": ('int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glVertexAttribIPointer": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLExtraFunctions.glVertexBindingDivisor": ('int', 'int'),

    # class PySide2.QtGui.QOpenGLFramebufferObject:
        "QOpenGLFramebufferObject.__init__": [('PySide2.QtCore.QSize', 'PySide2.QtGui.QOpenGLFramebufferObject.Attachment', 'int', 'int'), ('PySide2.QtCore.QSize', 'PySide2.QtGui.QOpenGLFramebufferObjectFormat'), ('PySide2.QtCore.QSize', 'int'), ('int', 'int', 'PySide2.QtGui.QOpenGLFramebufferObject.Attachment', 'int', 'int'), ('int', 'int', 'PySide2.QtGui.QOpenGLFramebufferObjectFormat'), ('int', 'int', 'int')],
        "QOpenGLFramebufferObject.addColorAttachment": [('PySide2.QtCore.QSize', 'int'), ('int', 'int', 'int')],
        "QOpenGLFramebufferObject.attachment": (),
        "QOpenGLFramebufferObject.bind": (),
        "QOpenGLFramebufferObject.bindDefault": (),
        "QOpenGLFramebufferObject.blitFramebuffer": [('PySide2.QtGui.QOpenGLFramebufferObject', 'PySide2.QtCore.QRect', 'PySide2.QtGui.QOpenGLFramebufferObject', 'PySide2.QtCore.QRect', 'int', 'int'), ('PySide2.QtGui.QOpenGLFramebufferObject', 'PySide2.QtCore.QRect', 'PySide2.QtGui.QOpenGLFramebufferObject', 'PySide2.QtCore.QRect', 'int', 'int', 'int', 'int'), ('PySide2.QtGui.QOpenGLFramebufferObject', 'PySide2.QtCore.QRect', 'PySide2.QtGui.QOpenGLFramebufferObject', 'PySide2.QtCore.QRect', 'int', 'int', 'int', 'int', 'PySide2.QtGui.QOpenGLFramebufferObject.FramebufferRestorePolicy'), ('PySide2.QtGui.QOpenGLFramebufferObject', 'PySide2.QtGui.QOpenGLFramebufferObject', 'int', 'int')],
        "QOpenGLFramebufferObject.format": (),
        "QOpenGLFramebufferObject.handle": (),
        "QOpenGLFramebufferObject.hasOpenGLFramebufferBlit": (),
        "QOpenGLFramebufferObject.hasOpenGLFramebufferObjects": (),
        "QOpenGLFramebufferObject.height": (),
        "QOpenGLFramebufferObject.isBound": (),
        "QOpenGLFramebufferObject.isValid": (),
        "QOpenGLFramebufferObject.release": (),
        "QOpenGLFramebufferObject.setAttachment": ('PySide2.QtGui.QOpenGLFramebufferObject.Attachment',),
        "QOpenGLFramebufferObject.size": (),
        "QOpenGLFramebufferObject.sizes": (),
        "QOpenGLFramebufferObject.takeTexture": [(), ('int',)],
        "QOpenGLFramebufferObject.texture": (),
        "QOpenGLFramebufferObject.textures": (),
        "QOpenGLFramebufferObject.toImage": [(), ('bool',), ('bool', 'int')],
        "QOpenGLFramebufferObject.width": (),

    # class PySide2.QtGui.QOpenGLFramebufferObjectFormat:
        "QOpenGLFramebufferObjectFormat.__init__": [(), ('PySide2.QtGui.QOpenGLFramebufferObjectFormat',)],
        "QOpenGLFramebufferObjectFormat.__copy__": (),
        "QOpenGLFramebufferObjectFormat.attachment": (),
        "QOpenGLFramebufferObjectFormat.internalTextureFormat": (),
        "QOpenGLFramebufferObjectFormat.mipmap": (),
        "QOpenGLFramebufferObjectFormat.samples": (),
        "QOpenGLFramebufferObjectFormat.setAttachment": ('PySide2.QtGui.QOpenGLFramebufferObject.Attachment',),
        "QOpenGLFramebufferObjectFormat.setInternalTextureFormat": ('int',),
        "QOpenGLFramebufferObjectFormat.setMipmap": ('bool',),
        "QOpenGLFramebufferObjectFormat.setSamples": ('int',),
        "QOpenGLFramebufferObjectFormat.setTextureTarget": ('int',),
        "QOpenGLFramebufferObjectFormat.textureTarget": (),

    # class PySide2.QtGui.QOpenGLFunctions:
        "QOpenGLFunctions.__init__": [(), ('PySide2.QtGui.QOpenGLContext',)],
        "QOpenGLFunctions.glActiveTexture": ('int',),
        "QOpenGLFunctions.glAttachShader": ('int', 'int'),
        "QOpenGLFunctions.glBindAttribLocation": ('int', 'int', 'str'),
        "QOpenGLFunctions.glBindBuffer": ('int', 'int'),
        "QOpenGLFunctions.glBindFramebuffer": ('int', 'int'),
        "QOpenGLFunctions.glBindRenderbuffer": ('int', 'int'),
        "QOpenGLFunctions.glBindTexture": ('int', 'int'),
        "QOpenGLFunctions.glBlendColor": ('float', 'float', 'float', 'float'),
        "QOpenGLFunctions.glBlendEquation": ('int',),
        "QOpenGLFunctions.glBlendEquationSeparate": ('int', 'int'),
        "QOpenGLFunctions.glBlendFunc": ('int', 'int'),
        "QOpenGLFunctions.glBlendFuncSeparate": ('int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glCheckFramebufferStatus": ('int',),
        "QOpenGLFunctions.glClear": ('int',),
        "QOpenGLFunctions.glClearColor": ('float', 'float', 'float', 'float'),
        "QOpenGLFunctions.glClearDepthf": ('float',),
        "QOpenGLFunctions.glClearStencil": ('int',),
        "QOpenGLFunctions.glColorMask": ('typing.Union[str, int]', 'typing.Union[str, int]', 'typing.Union[str, int]', 'typing.Union[str, int]'),
        "QOpenGLFunctions.glCompileShader": ('int',),
        "QOpenGLFunctions.glCompressedTexImage2D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glCompressedTexSubImage2D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glCopyTexImage2D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glCopyTexSubImage2D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glCreateProgram": (),
        "QOpenGLFunctions.glCreateShader": ('int',),
        "QOpenGLFunctions.glCullFace": ('int',),
        "QOpenGLFunctions.glDeleteBuffers": ('int', 'int'),
        "QOpenGLFunctions.glDeleteFramebuffers": ('int', 'int'),
        "QOpenGLFunctions.glDeleteProgram": ('int',),
        "QOpenGLFunctions.glDeleteRenderbuffers": ('int', 'int'),
        "QOpenGLFunctions.glDeleteShader": ('int',),
        "QOpenGLFunctions.glDeleteTextures": ('int', 'int'),
        "QOpenGLFunctions.glDepthFunc": ('int',),
        "QOpenGLFunctions.glDepthMask": ('typing.Union[str, int]',),
        "QOpenGLFunctions.glDepthRangef": ('float', 'float'),
        "QOpenGLFunctions.glDetachShader": ('int', 'int'),
        "QOpenGLFunctions.glDisable": ('int',),
        "QOpenGLFunctions.glDisableVertexAttribArray": ('int',),
        "QOpenGLFunctions.glDrawArrays": ('int', 'int', 'int'),
        "QOpenGLFunctions.glDrawElements": ('int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glEnable": ('int',),
        "QOpenGLFunctions.glEnableVertexAttribArray": ('int',),
        "QOpenGLFunctions.glFinish": (),
        "QOpenGLFunctions.glFlush": (),
        "QOpenGLFunctions.glFramebufferRenderbuffer": ('int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glFramebufferTexture2D": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glFrontFace": ('int',),
        "QOpenGLFunctions.glGenBuffers": ('int', 'int'),
        "QOpenGLFunctions.glGenFramebuffers": ('int', 'int'),
        "QOpenGLFunctions.glGenRenderbuffers": ('int', 'int'),
        "QOpenGLFunctions.glGenTextures": ('int', 'int'),
        "QOpenGLFunctions.glGenerateMipmap": ('int',),
        "QOpenGLFunctions.glGetAttachedShaders": ('int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glGetAttribLocation": ('int', 'str'),
        "QOpenGLFunctions.glGetBufferParameteriv": ('int', 'int', 'int'),
        "QOpenGLFunctions.glGetError": (),
        "QOpenGLFunctions.glGetFloatv": ('int', 'float'),
        "QOpenGLFunctions.glGetFramebufferAttachmentParameteriv": ('int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glGetIntegerv": ('int', 'int'),
        "QOpenGLFunctions.glGetProgramiv": ('int', 'int', 'int'),
        "QOpenGLFunctions.glGetRenderbufferParameteriv": ('int', 'int', 'int'),
        "QOpenGLFunctions.glGetShaderPrecisionFormat": ('int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glGetShaderiv": ('int', 'int', 'int'),
        "QOpenGLFunctions.glGetString": ('int',),
        "QOpenGLFunctions.glGetTexParameterfv": ('int', 'int', 'float'),
        "QOpenGLFunctions.glGetTexParameteriv": ('int', 'int', 'int'),
        "QOpenGLFunctions.glGetUniformLocation": ('int', 'str'),
        "QOpenGLFunctions.glGetUniformfv": ('int', 'int', 'float'),
        "QOpenGLFunctions.glGetUniformiv": ('int', 'int', 'int'),
        "QOpenGLFunctions.glGetVertexAttribfv": ('int', 'int', 'float'),
        "QOpenGLFunctions.glGetVertexAttribiv": ('int', 'int', 'int'),
        "QOpenGLFunctions.glHint": ('int', 'int'),
        "QOpenGLFunctions.glIsBuffer": ('int',),
        "QOpenGLFunctions.glIsEnabled": ('int',),
        "QOpenGLFunctions.glIsFramebuffer": ('int',),
        "QOpenGLFunctions.glIsProgram": ('int',),
        "QOpenGLFunctions.glIsRenderbuffer": ('int',),
        "QOpenGLFunctions.glIsShader": ('int',),
        "QOpenGLFunctions.glIsTexture": ('int',),
        "QOpenGLFunctions.glLineWidth": ('float',),
        "QOpenGLFunctions.glLinkProgram": ('int',),
        "QOpenGLFunctions.glPixelStorei": ('int', 'int'),
        "QOpenGLFunctions.glPolygonOffset": ('float', 'float'),
        "QOpenGLFunctions.glReadPixels": ('int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glReleaseShaderCompiler": (),
        "QOpenGLFunctions.glRenderbufferStorage": ('int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glSampleCoverage": ('float', 'typing.Union[str, int]'),
        "QOpenGLFunctions.glScissor": ('int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glShaderBinary": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glStencilFunc": ('int', 'int', 'int'),
        "QOpenGLFunctions.glStencilFuncSeparate": ('int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glStencilMask": ('int',),
        "QOpenGLFunctions.glStencilMaskSeparate": ('int', 'int'),
        "QOpenGLFunctions.glStencilOp": ('int', 'int', 'int'),
        "QOpenGLFunctions.glStencilOpSeparate": ('int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glTexImage2D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glTexParameterf": ('int', 'int', 'float'),
        "QOpenGLFunctions.glTexParameterfv": ('int', 'int', 'float'),
        "QOpenGLFunctions.glTexParameteri": ('int', 'int', 'int'),
        "QOpenGLFunctions.glTexParameteriv": ('int', 'int', 'int'),
        "QOpenGLFunctions.glTexSubImage2D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glUniform1f": ('int', 'float'),
        "QOpenGLFunctions.glUniform1fv": ('int', 'int', 'float'),
        "QOpenGLFunctions.glUniform1i": ('int', 'int'),
        "QOpenGLFunctions.glUniform1iv": ('int', 'int', 'int'),
        "QOpenGLFunctions.glUniform2f": ('int', 'float', 'float'),
        "QOpenGLFunctions.glUniform2fv": ('int', 'int', 'float'),
        "QOpenGLFunctions.glUniform2i": ('int', 'int', 'int'),
        "QOpenGLFunctions.glUniform2iv": ('int', 'int', 'int'),
        "QOpenGLFunctions.glUniform3f": ('int', 'float', 'float', 'float'),
        "QOpenGLFunctions.glUniform3fv": ('int', 'int', 'float'),
        "QOpenGLFunctions.glUniform3i": ('int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glUniform3iv": ('int', 'int', 'int'),
        "QOpenGLFunctions.glUniform4f": ('int', 'float', 'float', 'float', 'float'),
        "QOpenGLFunctions.glUniform4fv": ('int', 'int', 'float'),
        "QOpenGLFunctions.glUniform4i": ('int', 'int', 'int', 'int', 'int'),
        "QOpenGLFunctions.glUniform4iv": ('int', 'int', 'int'),
        "QOpenGLFunctions.glUniformMatrix2fv": ('int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLFunctions.glUniformMatrix3fv": ('int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLFunctions.glUniformMatrix4fv": ('int', 'int', 'typing.Union[str, int]', 'float'),
        "QOpenGLFunctions.glUseProgram": ('int',),
        "QOpenGLFunctions.glValidateProgram": ('int',),
        "QOpenGLFunctions.glVertexAttrib1f": ('int', 'float'),
        "QOpenGLFunctions.glVertexAttrib1fv": ('int', 'float'),
        "QOpenGLFunctions.glVertexAttrib2f": ('int', 'float', 'float'),
        "QOpenGLFunctions.glVertexAttrib2fv": ('int', 'float'),
        "QOpenGLFunctions.glVertexAttrib3f": ('int', 'float', 'float', 'float'),
        "QOpenGLFunctions.glVertexAttrib3fv": ('int', 'float'),
        "QOpenGLFunctions.glVertexAttrib4f": ('int', 'float', 'float', 'float', 'float'),
        "QOpenGLFunctions.glVertexAttrib4fv": ('int', 'float'),
        "QOpenGLFunctions.glVertexAttribPointer": ('int', 'int', 'int', 'typing.Union[str, int]', 'int', 'int'),
        "QOpenGLFunctions.glViewport": ('int', 'int', 'int', 'int'),
        "QOpenGLFunctions.hasOpenGLFeature": ('PySide2.QtGui.QOpenGLFunctions.OpenGLFeature',),
        "QOpenGLFunctions.initializeOpenGLFunctions": (),
        "QOpenGLFunctions.openGLFeatures": (),

    # class PySide2.QtGui.QOpenGLPixelTransferOptions:
        "QOpenGLPixelTransferOptions.__init__": [(), ('PySide2.QtGui.QOpenGLPixelTransferOptions',)],
        "QOpenGLPixelTransferOptions.__copy__": (),
        "QOpenGLPixelTransferOptions.alignment": (),
        "QOpenGLPixelTransferOptions.imageHeight": (),
        "QOpenGLPixelTransferOptions.isLeastSignificantBitFirst": (),
        "QOpenGLPixelTransferOptions.isSwapBytesEnabled": (),
        "QOpenGLPixelTransferOptions.rowLength": (),
        "QOpenGLPixelTransferOptions.setAlignment": ('int',),
        "QOpenGLPixelTransferOptions.setImageHeight": ('int',),
        "QOpenGLPixelTransferOptions.setLeastSignificantByteFirst": ('bool',),
        "QOpenGLPixelTransferOptions.setRowLength": ('int',),
        "QOpenGLPixelTransferOptions.setSkipImages": ('int',),
        "QOpenGLPixelTransferOptions.setSkipPixels": ('int',),
        "QOpenGLPixelTransferOptions.setSkipRows": ('int',),
        "QOpenGLPixelTransferOptions.setSwapBytesEnabled": ('bool',),
        "QOpenGLPixelTransferOptions.skipImages": (),
        "QOpenGLPixelTransferOptions.skipPixels": (),
        "QOpenGLPixelTransferOptions.skipRows": (),
        "QOpenGLPixelTransferOptions.swap": ('PySide2.QtGui.QOpenGLPixelTransferOptions',),

    # class PySide2.QtGui.QOpenGLShader:
        "QOpenGLShader.__init__": ('PySide2.QtGui.QOpenGLShader.ShaderType', 'PySide2.QtCore.QObject'),
        "QOpenGLShader.compileSourceCode": [('PySide2.QtCore.QByteArray',), ('str',)],
        "QOpenGLShader.compileSourceFile": ('str',),
        "QOpenGLShader.hasOpenGLShaders": ('PySide2.QtGui.QOpenGLShader.ShaderType', 'PySide2.QtGui.QOpenGLContext'),
        "QOpenGLShader.isCompiled": (),
        "QOpenGLShader.log": (),
        "QOpenGLShader.shaderId": (),
        "QOpenGLShader.shaderType": (),
        "QOpenGLShader.sourceCode": (),

    # class PySide2.QtGui.QOpenGLShaderProgram:
        "QOpenGLShaderProgram.__init__": ('PySide2.QtCore.QObject',),
        "QOpenGLShaderProgram.addCacheableShaderFromSourceCode": [('PySide2.QtGui.QOpenGLShader.ShaderType', 'PySide2.QtCore.QByteArray'), ('PySide2.QtGui.QOpenGLShader.ShaderType', 'str')],
        "QOpenGLShaderProgram.addCacheableShaderFromSourceFile": ('PySide2.QtGui.QOpenGLShader.ShaderType', 'str'),
        "QOpenGLShaderProgram.addShader": ('PySide2.QtGui.QOpenGLShader',),
        "QOpenGLShaderProgram.addShaderFromSourceCode": [('PySide2.QtGui.QOpenGLShader.ShaderType', 'PySide2.QtCore.QByteArray'), ('PySide2.QtGui.QOpenGLShader.ShaderType', 'str')],
        "QOpenGLShaderProgram.addShaderFromSourceFile": ('PySide2.QtGui.QOpenGLShader.ShaderType', 'str'),
        "QOpenGLShaderProgram.attributeLocation": [('PySide2.QtCore.QByteArray',), ('str',)],
        "QOpenGLShaderProgram.bind": (),
        "QOpenGLShaderProgram.bindAttributeLocation": [('PySide2.QtCore.QByteArray', 'int'), ('str', 'int')],
        "QOpenGLShaderProgram.create": (),
        "QOpenGLShaderProgram.defaultInnerTessellationLevels": (),
        "QOpenGLShaderProgram.defaultOuterTessellationLevels": (),
        "QOpenGLShaderProgram.disableAttributeArray": [('int',), ('str',)],
        "QOpenGLShaderProgram.enableAttributeArray": [('int',), ('str',)],
        "QOpenGLShaderProgram.hasOpenGLShaderPrograms": ('PySide2.QtGui.QOpenGLContext',),
        "QOpenGLShaderProgram.isLinked": (),
        "QOpenGLShaderProgram.link": (),
        "QOpenGLShaderProgram.log": (),
        "QOpenGLShaderProgram.maxGeometryOutputVertices": (),
        "QOpenGLShaderProgram.patchVertexCount": (),
        "QOpenGLShaderProgram.programId": (),
        "QOpenGLShaderProgram.release": (),
        "QOpenGLShaderProgram.removeAllShaders": (),
        "QOpenGLShaderProgram.removeShader": ('PySide2.QtGui.QOpenGLShader',),
        "QOpenGLShaderProgram.setAttributeArray": [('int', 'float', 'int', 'int'), ('int', 'int', 'int', 'int', 'int'), ('str', 'float', 'int', 'int'), ('str', 'int', 'int', 'int', 'int')],
        "QOpenGLShaderProgram.setAttributeBuffer": [('int', 'int', 'int', 'int', 'int'), ('str', 'int', 'int', 'int', 'int')],
        "QOpenGLShaderProgram.setAttributeValue": [('int', 'PySide2.QtGui.QColor'), ('int', 'PySide2.QtGui.QVector2D'), ('int', 'PySide2.QtGui.QVector3D'), ('int', 'PySide2.QtGui.QVector4D'), ('int', 'float'), ('int', 'float', 'float'), ('int', 'float', 'float', 'float'), ('int', 'float', 'float', 'float', 'float'), ('int', 'float', 'int', 'int'), ('str', 'PySide2.QtGui.QColor'), ('str', 'PySide2.QtGui.QVector2D'), ('str', 'PySide2.QtGui.QVector3D'), ('str', 'PySide2.QtGui.QVector4D'), ('str', 'float'), ('str', 'float', 'float'), ('str', 'float', 'float', 'float'), ('str', 'float', 'float', 'float', 'float'), ('str', 'float', 'int', 'int')],
        "QOpenGLShaderProgram.setDefaultInnerTessellationLevels": ('list',),
        "QOpenGLShaderProgram.setDefaultOuterTessellationLevels": ('list',),
        "QOpenGLShaderProgram.setPatchVertexCount": ('int',),
        "QOpenGLShaderProgram.setUniformValue": [('int', 'PySide2.QtCore.QPoint'), ('int', 'PySide2.QtCore.QPointF'), ('int', 'PySide2.QtCore.QSize'), ('int', 'PySide2.QtCore.QSizeF'), ('int', 'PySide2.QtGui.QColor'), ('int', 'PySide2.QtGui.QMatrix2x2'), ('int', 'PySide2.QtGui.QMatrix2x3'), ('int', 'PySide2.QtGui.QMatrix2x4'), ('int', 'PySide2.QtGui.QMatrix3x2'), ('int', 'PySide2.QtGui.QMatrix3x3'), ('int', 'PySide2.QtGui.QMatrix3x4'), ('int', 'PySide2.QtGui.QMatrix4x2'), ('int', 'PySide2.QtGui.QMatrix4x3'), ('int', 'PySide2.QtGui.QMatrix4x4'), ('int', 'PySide2.QtGui.QTransform'), ('int', 'PySide2.QtGui.QVector2D'), ('int', 'PySide2.QtGui.QVector3D'), ('int', 'PySide2.QtGui.QVector4D'), ('int', 'float'), ('int', 'float', 'float'), ('int', 'float', 'float', 'float'), ('int', 'float', 'float', 'float', 'float'), ('int', 'int'), ('int', 'typing.List[typing.List[float]]'), ('str', 'PySide2.QtCore.QPoint'), ('str', 'PySide2.QtCore.QPointF'), ('str', 'PySide2.QtCore.QSize'), ('str', 'PySide2.QtCore.QSizeF'), ('str', 'PySide2.QtGui.QColor'), ('str', 'PySide2.QtGui.QMatrix2x2'), ('str', 'PySide2.QtGui.QMatrix2x3'), ('str', 'PySide2.QtGui.QMatrix2x4'), ('str', 'PySide2.QtGui.QMatrix3x2'), ('str', 'PySide2.QtGui.QMatrix3x3'), ('str', 'PySide2.QtGui.QMatrix3x4'), ('str', 'PySide2.QtGui.QMatrix4x2'), ('str', 'PySide2.QtGui.QMatrix4x3'), ('str', 'PySide2.QtGui.QMatrix4x4'), ('str', 'PySide2.QtGui.QTransform'), ('str', 'PySide2.QtGui.QVector2D'), ('str', 'PySide2.QtGui.QVector3D'), ('str', 'PySide2.QtGui.QVector4D'), ('str', 'float'), ('str', 'float', 'float'), ('str', 'float', 'float', 'float'), ('str', 'float', 'float', 'float', 'float'), ('str', 'int'), ('str', 'typing.List[typing.List[float]]')],
        "QOpenGLShaderProgram.setUniformValueArray": [('int', 'float', 'int', 'int'), ('int', 'int', 'int'), ('str', 'float', 'int', 'int'), ('str', 'int', 'int')],
        "QOpenGLShaderProgram.shaders": (),
        "QOpenGLShaderProgram.uniformLocation": [('PySide2.QtCore.QByteArray',), ('str',)],

    # class PySide2.QtGui.QOpenGLTexture:
        "QOpenGLTexture.__init__": [('PySide2.QtGui.QImage', 'PySide2.QtGui.QOpenGLTexture.MipMapGeneration'), ('PySide2.QtGui.QOpenGLTexture.Target',)],
        "QOpenGLTexture.allocateStorage": [(), ('PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType')],
        "QOpenGLTexture.bind": [(), ('int', 'PySide2.QtGui.QOpenGLTexture.TextureUnitReset')],
        "QOpenGLTexture.borderColor": (),
        "QOpenGLTexture.boundTextureId": [('PySide2.QtGui.QOpenGLTexture.BindingTarget',), ('int', 'PySide2.QtGui.QOpenGLTexture.BindingTarget')],
        "QOpenGLTexture.comparisonFunction": (),
        "QOpenGLTexture.comparisonMode": (),
        "QOpenGLTexture.create": (),
        "QOpenGLTexture.createTextureView": ('PySide2.QtGui.QOpenGLTexture.Target', 'PySide2.QtGui.QOpenGLTexture.TextureFormat', 'int', 'int', 'int', 'int'),
        "QOpenGLTexture.depth": (),
        "QOpenGLTexture.depthStencilMode": (),
        "QOpenGLTexture.destroy": (),
        "QOpenGLTexture.faces": (),
        "QOpenGLTexture.format": (),
        "QOpenGLTexture.generateMipMaps": [(), ('int', 'bool')],
        "QOpenGLTexture.hasFeature": ('PySide2.QtGui.QOpenGLTexture.Feature',),
        "QOpenGLTexture.height": (),
        "QOpenGLTexture.isAutoMipMapGenerationEnabled": (),
        "QOpenGLTexture.isBound": [(), ('int',)],
        "QOpenGLTexture.isCreated": (),
        "QOpenGLTexture.isFixedSamplePositions": (),
        "QOpenGLTexture.isStorageAllocated": (),
        "QOpenGLTexture.isTextureView": (),
        "QOpenGLTexture.layers": (),
        "QOpenGLTexture.levelOfDetailRange": (),
        "QOpenGLTexture.levelofDetailBias": (),
        "QOpenGLTexture.magnificationFilter": (),
        "QOpenGLTexture.maximumAnisotropy": (),
        "QOpenGLTexture.maximumLevelOfDetail": (),
        "QOpenGLTexture.maximumMipLevels": (),
        "QOpenGLTexture.minMagFilters": (),
        "QOpenGLTexture.minificationFilter": (),
        "QOpenGLTexture.minimumLevelOfDetail": (),
        "QOpenGLTexture.mipBaseLevel": (),
        "QOpenGLTexture.mipLevelRange": (),
        "QOpenGLTexture.mipLevels": (),
        "QOpenGLTexture.mipMaxLevel": (),
        "QOpenGLTexture.release": [(), ('int', 'PySide2.QtGui.QOpenGLTexture.TextureUnitReset')],
        "QOpenGLTexture.samples": (),
        "QOpenGLTexture.setAutoMipMapGenerationEnabled": ('bool',),
        "QOpenGLTexture.setBorderColor": [('PySide2.QtGui.QColor',), ('float', 'float', 'float', 'float'), ('int', 'int', 'int', 'int')],
        "QOpenGLTexture.setComparisonFunction": ('PySide2.QtGui.QOpenGLTexture.ComparisonFunction',),
        "QOpenGLTexture.setComparisonMode": ('PySide2.QtGui.QOpenGLTexture.ComparisonMode',),
        "QOpenGLTexture.setCompressedData": [('int', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'PySide2.QtGui.QOpenGLTexture.CubeMapFace', 'int', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'int', 'PySide2.QtGui.QOpenGLTexture.CubeMapFace', 'int', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions')],
        "QOpenGLTexture.setData": [('PySide2.QtGui.QImage', 'PySide2.QtGui.QOpenGLTexture.MipMapGeneration'), ('PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'PySide2.QtGui.QOpenGLTexture.CubeMapFace', 'PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'int', 'PySide2.QtGui.QOpenGLTexture.CubeMapFace', 'PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions')],
        "QOpenGLTexture.setDepthStencilMode": ('PySide2.QtGui.QOpenGLTexture.DepthStencilMode',),
        "QOpenGLTexture.setFixedSamplePositions": ('bool',),
        "QOpenGLTexture.setFormat": ('PySide2.QtGui.QOpenGLTexture.TextureFormat',),
        "QOpenGLTexture.setLayers": ('int',),
        "QOpenGLTexture.setLevelOfDetailRange": ('float', 'float'),
        "QOpenGLTexture.setLevelofDetailBias": ('float',),
        "QOpenGLTexture.setMagnificationFilter": ('PySide2.QtGui.QOpenGLTexture.Filter',),
        "QOpenGLTexture.setMaximumAnisotropy": ('float',),
        "QOpenGLTexture.setMaximumLevelOfDetail": ('float',),
        "QOpenGLTexture.setMinMagFilters": ('PySide2.QtGui.QOpenGLTexture.Filter', 'PySide2.QtGui.QOpenGLTexture.Filter'),
        "QOpenGLTexture.setMinificationFilter": ('PySide2.QtGui.QOpenGLTexture.Filter',),
        "QOpenGLTexture.setMinimumLevelOfDetail": ('float',),
        "QOpenGLTexture.setMipBaseLevel": ('int',),
        "QOpenGLTexture.setMipLevelRange": ('int', 'int'),
        "QOpenGLTexture.setMipLevels": ('int',),
        "QOpenGLTexture.setMipMaxLevel": ('int',),
        "QOpenGLTexture.setSamples": ('int',),
        "QOpenGLTexture.setSize": ('int', 'int', 'int'),
        "QOpenGLTexture.setSwizzleMask": [('PySide2.QtGui.QOpenGLTexture.SwizzleComponent', 'PySide2.QtGui.QOpenGLTexture.SwizzleValue'), ('PySide2.QtGui.QOpenGLTexture.SwizzleValue', 'PySide2.QtGui.QOpenGLTexture.SwizzleValue', 'PySide2.QtGui.QOpenGLTexture.SwizzleValue', 'PySide2.QtGui.QOpenGLTexture.SwizzleValue')],
        "QOpenGLTexture.setWrapMode": [('PySide2.QtGui.QOpenGLTexture.CoordinateDirection', 'PySide2.QtGui.QOpenGLTexture.WrapMode'), ('PySide2.QtGui.QOpenGLTexture.WrapMode',)],
        "QOpenGLTexture.swizzleMask": ('PySide2.QtGui.QOpenGLTexture.SwizzleComponent',),
        "QOpenGLTexture.target": (),
        "QOpenGLTexture.textureId": (),
        "QOpenGLTexture.width": (),
        "QOpenGLTexture.wrapMode": ('PySide2.QtGui.QOpenGLTexture.CoordinateDirection',),

    # class PySide2.QtGui.QOpenGLTextureBlitter:
        "QOpenGLTextureBlitter.__init__": (),
        "QOpenGLTextureBlitter.bind": ('int',),
        "QOpenGLTextureBlitter.blit": [('int', 'PySide2.QtGui.QMatrix4x4', 'PySide2.QtGui.QMatrix3x3'), ('int', 'PySide2.QtGui.QMatrix4x4', 'PySide2.QtGui.QOpenGLTextureBlitter.Origin')],
        "QOpenGLTextureBlitter.create": (),
        "QOpenGLTextureBlitter.destroy": (),
        "QOpenGLTextureBlitter.isCreated": (),
        "QOpenGLTextureBlitter.release": (),
        "QOpenGLTextureBlitter.setOpacity": ('float',),
        "QOpenGLTextureBlitter.setRedBlueSwizzle": ('bool',),
        "QOpenGLTextureBlitter.sourceTransform": ('PySide2.QtCore.QRectF', 'PySide2.QtCore.QSize', 'PySide2.QtGui.QOpenGLTextureBlitter.Origin'),
        "QOpenGLTextureBlitter.supportsExternalOESTarget": (),
        "QOpenGLTextureBlitter.targetTransform": ('PySide2.QtCore.QRectF', 'PySide2.QtCore.QRect'),

    # class PySide2.QtGui.QOpenGLTimeMonitor:
        "QOpenGLTimeMonitor.__init__": ('PySide2.QtCore.QObject',),
        "QOpenGLTimeMonitor.create": (),
        "QOpenGLTimeMonitor.destroy": (),
        "QOpenGLTimeMonitor.isCreated": (),
        "QOpenGLTimeMonitor.isResultAvailable": (),
        "QOpenGLTimeMonitor.objectIds": (),
        "QOpenGLTimeMonitor.recordSample": (),
        "QOpenGLTimeMonitor.reset": (),
        "QOpenGLTimeMonitor.sampleCount": (),
        "QOpenGLTimeMonitor.setSampleCount": ('int',),
        "QOpenGLTimeMonitor.waitForIntervals": (),
        "QOpenGLTimeMonitor.waitForSamples": (),

    # class PySide2.QtGui.QOpenGLTimerQuery:
        "QOpenGLTimerQuery.__init__": ('PySide2.QtCore.QObject',),
        "QOpenGLTimerQuery.begin": (),
        "QOpenGLTimerQuery.create": (),
        "QOpenGLTimerQuery.destroy": (),
        "QOpenGLTimerQuery.end": (),
        "QOpenGLTimerQuery.isCreated": (),
        "QOpenGLTimerQuery.isResultAvailable": (),
        "QOpenGLTimerQuery.objectId": (),
        "QOpenGLTimerQuery.recordTimestamp": (),
        "QOpenGLTimerQuery.waitForResult": (),
        "QOpenGLTimerQuery.waitForTimestamp": (),

    # class PySide2.QtGui.QOpenGLVersionProfile:
        "QOpenGLVersionProfile.__init__": [(), ('PySide2.QtGui.QOpenGLVersionProfile',), ('PySide2.QtGui.QSurfaceFormat',)],
        "QOpenGLVersionProfile.__copy__": (),
        "QOpenGLVersionProfile.hasProfiles": (),
        "QOpenGLVersionProfile.isLegacyVersion": (),
        "QOpenGLVersionProfile.isValid": (),
        "QOpenGLVersionProfile.profile": (),
        "QOpenGLVersionProfile.setProfile": ('PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile',),
        "QOpenGLVersionProfile.setVersion": ('int', 'int'),
        "QOpenGLVersionProfile.version": (),

    # class PySide2.QtGui.QOpenGLVertexArrayObject:
        "QOpenGLVertexArrayObject.__init__": ('PySide2.QtCore.QObject',),
        "QOpenGLVertexArrayObject.bind": (),
        "QOpenGLVertexArrayObject.create": (),
        "QOpenGLVertexArrayObject.destroy": (),
        "QOpenGLVertexArrayObject.isCreated": (),
        "QOpenGLVertexArrayObject.objectId": (),
        "QOpenGLVertexArrayObject.release": (),

    # class PySide2.QtGui.QOpenGLVertexArrayObject.Binder:
        "QOpenGLVertexArrayObject.Binder.__init__": ('PySide2.QtGui.QOpenGLVertexArrayObject',),
        "QOpenGLVertexArrayObject.Binder.rebind": (),
        "QOpenGLVertexArrayObject.Binder.release": (),

    # class PySide2.QtGui.QOpenGLWindow:
        "QOpenGLWindow.__init__": [('PySide2.QtGui.QOpenGLContext', 'PySide2.QtGui.QOpenGLWindow.UpdateBehavior', 'PySide2.QtGui.QWindow'), ('PySide2.QtGui.QOpenGLWindow.UpdateBehavior', 'PySide2.QtGui.QWindow')],
        "QOpenGLWindow.context": (),
        "QOpenGLWindow.defaultFramebufferObject": (),
        "QOpenGLWindow.doneCurrent": (),
        "QOpenGLWindow.grabFramebuffer": (),
        "QOpenGLWindow.initializeGL": (),
        "QOpenGLWindow.isValid": (),
        "QOpenGLWindow.makeCurrent": (),
        "QOpenGLWindow.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
        "QOpenGLWindow.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QOpenGLWindow.paintGL": (),
        "QOpenGLWindow.paintOverGL": (),
        "QOpenGLWindow.paintUnderGL": (),
        "QOpenGLWindow.redirected": ('PySide2.QtCore.QPoint',),
        "QOpenGLWindow.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QOpenGLWindow.resizeGL": ('int', 'int'),
        "QOpenGLWindow.shareContext": (),
        "QOpenGLWindow.updateBehavior": (),

    # class PySide2.QtGui.QPageLayout:
        "QPageLayout.__init__": [(), ('PySide2.QtGui.QPageLayout',), ('PySide2.QtGui.QPageSize', 'PySide2.QtGui.QPageLayout.Orientation', 'PySide2.QtCore.QMarginsF', 'PySide2.QtGui.QPageLayout.Unit', 'PySide2.QtCore.QMarginsF')],
        "QPageLayout.__copy__": (),
        "QPageLayout.fullRect": [(), ('PySide2.QtGui.QPageLayout.Unit',)],
        "QPageLayout.fullRectPixels": ('int',),
        "QPageLayout.fullRectPoints": (),
        "QPageLayout.isEquivalentTo": ('PySide2.QtGui.QPageLayout',),
        "QPageLayout.isValid": (),
        "QPageLayout.margins": [(), ('PySide2.QtGui.QPageLayout.Unit',)],
        "QPageLayout.marginsPixels": ('int',),
        "QPageLayout.marginsPoints": (),
        "QPageLayout.maximumMargins": (),
        "QPageLayout.minimumMargins": (),
        "QPageLayout.mode": (),
        "QPageLayout.orientation": (),
        "QPageLayout.pageSize": (),
        "QPageLayout.paintRect": [(), ('PySide2.QtGui.QPageLayout.Unit',)],
        "QPageLayout.paintRectPixels": ('int',),
        "QPageLayout.paintRectPoints": (),
        "QPageLayout.setBottomMargin": ('float',),
        "QPageLayout.setLeftMargin": ('float',),
        "QPageLayout.setMargins": ('PySide2.QtCore.QMarginsF',),
        "QPageLayout.setMinimumMargins": ('PySide2.QtCore.QMarginsF',),
        "QPageLayout.setMode": ('PySide2.QtGui.QPageLayout.Mode',),
        "QPageLayout.setOrientation": ('PySide2.QtGui.QPageLayout.Orientation',),
        "QPageLayout.setPageSize": ('PySide2.QtGui.QPageSize', 'PySide2.QtCore.QMarginsF'),
        "QPageLayout.setRightMargin": ('float',),
        "QPageLayout.setTopMargin": ('float',),
        "QPageLayout.setUnits": ('PySide2.QtGui.QPageLayout.Unit',),
        "QPageLayout.swap": ('PySide2.QtGui.QPageLayout',),
        "QPageLayout.units": (),

    # class PySide2.QtGui.QPageSize:
        "QPageSize.__init__": [(), ('PySide2.QtCore.QSize', 'str', 'PySide2.QtGui.QPageSize.SizeMatchPolicy'), ('PySide2.QtCore.QSizeF', 'PySide2.QtGui.QPageSize.Unit', 'str', 'PySide2.QtGui.QPageSize.SizeMatchPolicy'), ('PySide2.QtGui.QPageSize',), ('PySide2.QtGui.QPageSize.PageSizeId',)],
        "QPageSize.__copy__": (),
        "QPageSize.definitionSize": [(), ('PySide2.QtGui.QPageSize.PageSizeId',)],
        "QPageSize.definitionUnits": [(), ('PySide2.QtGui.QPageSize.PageSizeId',)],
        "QPageSize.id": [(), ('PySide2.QtCore.QSize', 'PySide2.QtGui.QPageSize.SizeMatchPolicy'), ('PySide2.QtCore.QSizeF', 'PySide2.QtGui.QPageSize.Unit', 'PySide2.QtGui.QPageSize.SizeMatchPolicy'), ('int',)],
        "QPageSize.isEquivalentTo": ('PySide2.QtGui.QPageSize',),
        "QPageSize.isValid": (),
        "QPageSize.key": [(), ('PySide2.QtGui.QPageSize.PageSizeId',)],
        "QPageSize.name": [(), ('PySide2.QtGui.QPageSize.PageSizeId',)],
        "QPageSize.rect": ('PySide2.QtGui.QPageSize.Unit',),
        "QPageSize.rectPixels": ('int',),
        "QPageSize.rectPoints": (),
        "QPageSize.size": [('PySide2.QtGui.QPageSize.PageSizeId', 'PySide2.QtGui.QPageSize.Unit'), ('PySide2.QtGui.QPageSize.Unit',)],
        "QPageSize.sizePixels": [('PySide2.QtGui.QPageSize.PageSizeId', 'int'), ('int',)],
        "QPageSize.sizePoints": [(), ('PySide2.QtGui.QPageSize.PageSizeId',)],
        "QPageSize.swap": ('PySide2.QtGui.QPageSize',),
        "QPageSize.windowsId": [(), ('PySide2.QtGui.QPageSize.PageSizeId',)],

    # class PySide2.QtGui.QPagedPaintDevice:
        "QPagedPaintDevice.__init__": (),
        "QPagedPaintDevice.devicePageLayout": (),
        "QPagedPaintDevice.margins": (),
        "QPagedPaintDevice.newPage": (),
        "QPagedPaintDevice.pageLayout": (),
        "QPagedPaintDevice.pageSize": (),
        "QPagedPaintDevice.pageSizeMM": (),
        "QPagedPaintDevice.setMargins": ('PySide2.QtGui.QPagedPaintDevice.Margins',),
        "QPagedPaintDevice.setPageLayout": ('PySide2.QtGui.QPageLayout',),
        "QPagedPaintDevice.setPageMargins": [('PySide2.QtCore.QMarginsF',), ('PySide2.QtCore.QMarginsF', 'PySide2.QtGui.QPageLayout.Unit')],
        "QPagedPaintDevice.setPageOrientation": ('PySide2.QtGui.QPageLayout.Orientation',),
        "QPagedPaintDevice.setPageSize": [('PySide2.QtGui.QPageSize',), ('PySide2.QtGui.QPagedPaintDevice.PageSize',)],
        "QPagedPaintDevice.setPageSizeMM": ('PySide2.QtCore.QSizeF',),

    # class PySide2.QtGui.QPagedPaintDevice.Margins:
        "QPagedPaintDevice.Margins.__init__": [(), ('PySide2.QtGui.QPagedPaintDevice.Margins',)],
        "QPagedPaintDevice.Margins.__copy__": (),

    # class PySide2.QtGui.QPaintDevice:
        "QPaintDevice.__init__": (),
        "QPaintDevice.colorCount": (),
        "QPaintDevice.depth": (),
        "QPaintDevice.devType": (),
        "QPaintDevice.devicePixelRatio": (),
        "QPaintDevice.devicePixelRatioF": (),
        "QPaintDevice.devicePixelRatioFScale": (),
        "QPaintDevice.height": (),
        "QPaintDevice.heightMM": (),
        "QPaintDevice.initPainter": ('PySide2.QtGui.QPainter',),
        "QPaintDevice.logicalDpiX": (),
        "QPaintDevice.logicalDpiY": (),
        "QPaintDevice.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
        "QPaintDevice.paintEngine": (),
        "QPaintDevice.paintingActive": (),
        "QPaintDevice.physicalDpiX": (),
        "QPaintDevice.physicalDpiY": (),
        "QPaintDevice.redirected": ('PySide2.QtCore.QPoint',),
        "QPaintDevice.sharedPainter": (),
        "QPaintDevice.width": (),
        "QPaintDevice.widthMM": (),

    # class PySide2.QtGui.QPaintDeviceWindow:
        "QPaintDeviceWindow.event": ('PySide2.QtCore.QEvent',),
        "QPaintDeviceWindow.exposeEvent": ('PySide2.QtGui.QExposeEvent',),
        "QPaintDeviceWindow.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
        "QPaintDeviceWindow.paintEngine": (),
        "QPaintDeviceWindow.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QPaintDeviceWindow.update": [(), ('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],

    # class PySide2.QtGui.QPaintEngine:
        "QPaintEngine.__init__": ('PySide2.QtGui.QPaintEngine.PaintEngineFeatures',),
        "QPaintEngine.begin": ('PySide2.QtGui.QPaintDevice',),
        "QPaintEngine.clearDirty": ('PySide2.QtGui.QPaintEngine.DirtyFlags',),
        "QPaintEngine.coordinateOffset": (),
        "QPaintEngine.drawEllipse": [('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',)],
        "QPaintEngine.drawImage": ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QImage', 'PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.ImageConversionFlags'),
        "QPaintEngine.drawLines": [('PySide2.QtCore.QLine', 'int'), ('PySide2.QtCore.QLineF', 'int')],
        "QPaintEngine.drawPath": ('PySide2.QtGui.QPainterPath',),
        "QPaintEngine.drawPixmap": ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QRectF'),
        "QPaintEngine.drawPoints": [('PySide2.QtCore.QPoint', 'int'), ('PySide2.QtCore.QPointF', 'int')],
        "QPaintEngine.drawPolygon": [('PySide2.QtCore.QPoint', 'int', 'PySide2.QtGui.QPaintEngine.PolygonDrawMode'), ('PySide2.QtCore.QPointF', 'int', 'PySide2.QtGui.QPaintEngine.PolygonDrawMode')],
        "QPaintEngine.drawRects": [('PySide2.QtCore.QRect', 'int'), ('PySide2.QtCore.QRectF', 'int')],
        "QPaintEngine.drawTextItem": ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QTextItem'),
        "QPaintEngine.drawTiledPixmap": ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QPointF'),
        "QPaintEngine.end": (),
        "QPaintEngine.hasFeature": ('PySide2.QtGui.QPaintEngine.PaintEngineFeatures',),
        "QPaintEngine.isActive": (),
        "QPaintEngine.isExtended": (),
        "QPaintEngine.paintDevice": (),
        "QPaintEngine.painter": (),
        "QPaintEngine.setActive": ('bool',),
        "QPaintEngine.setDirty": ('PySide2.QtGui.QPaintEngine.DirtyFlags',),
        "QPaintEngine.setSystemClip": ('PySide2.QtGui.QRegion',),
        "QPaintEngine.setSystemRect": ('PySide2.QtCore.QRect',),
        "QPaintEngine.syncState": (),
        "QPaintEngine.systemClip": (),
        "QPaintEngine.systemRect": (),
        "QPaintEngine.testDirty": ('PySide2.QtGui.QPaintEngine.DirtyFlags',),
        "QPaintEngine.type": (),
        "QPaintEngine.updateState": ('PySide2.QtGui.QPaintEngineState',),

    # class PySide2.QtGui.QPaintEngineState:
        "QPaintEngineState.__init__": (),
        "QPaintEngineState.backgroundBrush": (),
        "QPaintEngineState.backgroundMode": (),
        "QPaintEngineState.brush": (),
        "QPaintEngineState.brushNeedsResolving": (),
        "QPaintEngineState.brushOrigin": (),
        "QPaintEngineState.clipOperation": (),
        "QPaintEngineState.clipPath": (),
        "QPaintEngineState.clipRegion": (),
        "QPaintEngineState.compositionMode": (),
        "QPaintEngineState.font": (),
        "QPaintEngineState.isClipEnabled": (),
        "QPaintEngineState.matrix": (),
        "QPaintEngineState.opacity": (),
        "QPaintEngineState.painter": (),
        "QPaintEngineState.pen": (),
        "QPaintEngineState.penNeedsResolving": (),
        "QPaintEngineState.renderHints": (),
        "QPaintEngineState.state": (),
        "QPaintEngineState.transform": (),

    # class PySide2.QtGui.QPaintEvent:
        "QPaintEvent.__init__": [('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],
        "QPaintEvent.rect": (),
        "QPaintEvent.region": (),

    # class PySide2.QtGui.QPainter:
        "QPainter.__init__": [(), ('PySide2.QtGui.QPaintDevice',)],
        "QPainter.background": (),
        "QPainter.backgroundMode": (),
        "QPainter.begin": ('PySide2.QtGui.QPaintDevice',),
        "QPainter.beginNativePainting": (),
        "QPainter.boundingRect": [('PySide2.QtCore.QRect', 'int', 'str'), ('PySide2.QtCore.QRectF', 'int', 'str'), ('PySide2.QtCore.QRectF', 'str', 'PySide2.QtGui.QTextOption'), ('int', 'int', 'int', 'int', 'int', 'str')],
        "QPainter.brush": (),
        "QPainter.brushOrigin": (),
        "QPainter.clipBoundingRect": (),
        "QPainter.clipPath": (),
        "QPainter.clipRegion": (),
        "QPainter.combinedMatrix": (),
        "QPainter.combinedTransform": (),
        "QPainter.compositionMode": (),
        "QPainter.device": (),
        "QPainter.deviceMatrix": (),
        "QPainter.deviceTransform": (),
        "QPainter.drawArc": [('PySide2.QtCore.QRect', 'int', 'int'), ('PySide2.QtCore.QRectF', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'int')],
        "QPainter.drawChord": [('PySide2.QtCore.QRect', 'int', 'int'), ('PySide2.QtCore.QRectF', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'int')],
        "QPainter.drawConvexPolygon": [('PySide2.QtGui.QPolygon',), ('PySide2.QtGui.QPolygonF',), ('list',)],
        "QPainter.drawEllipse": [('PySide2.QtCore.QPoint', 'int', 'int'), ('PySide2.QtCore.QPointF', 'float', 'float'), ('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',), ('int', 'int', 'int', 'int')],
        "QPainter.drawImage": [('PySide2.QtCore.QPoint', 'PySide2.QtGui.QImage'), ('PySide2.QtCore.QPoint', 'PySide2.QtGui.QImage', 'PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.ImageConversionFlags'), ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QImage'), ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QImage', 'PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.ImageConversionFlags'), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QImage'), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QImage', 'PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.ImageConversionFlags'), ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QImage'), ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QImage', 'PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.ImageConversionFlags'), ('int', 'int', 'PySide2.QtGui.QImage', 'int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.ImageConversionFlags')],
        "QPainter.drawLine": [('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'), ('int', 'int', 'int', 'int')],
        "QPainter.drawLines": ('list',),
        "QPainter.drawPath": ('PySide2.QtGui.QPainterPath',),
        "QPainter.drawPicture": [('PySide2.QtCore.QPoint', 'PySide2.QtGui.QPicture'), ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QPicture'), ('int', 'int', 'PySide2.QtGui.QPicture')],
        "QPainter.drawPie": [('PySide2.QtCore.QRect', 'int', 'int'), ('PySide2.QtCore.QRectF', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'int')],
        "QPainter.drawPixmap": [('PySide2.QtCore.QPoint', 'PySide2.QtGui.QPixmap'), ('PySide2.QtCore.QPoint', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QRect'), ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QPixmap'), ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QRectF'), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QPixmap'), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QRect'), ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QRectF'), ('int', 'int', 'PySide2.QtGui.QPixmap'), ('int', 'int', 'PySide2.QtGui.QPixmap', 'int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QPixmap'), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QPixmap', 'int', 'int', 'int', 'int')],
        "QPainter.drawPixmapFragments": ('PySide2.QtGui.QPainter.PixmapFragment', 'int', 'PySide2.QtGui.QPixmap', 'PySide2.QtGui.QPainter.PixmapFragmentHints'),
        "QPainter.drawPoint": [('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('int', 'int')],
        "QPainter.drawPoints": [('PySide2.QtGui.QPolygon',), ('PySide2.QtGui.QPolygonF',), ('list',)],
        "QPainter.drawPolygon": [('PySide2.QtGui.QPolygon', 'PySide2.QtCore.Qt.FillRule'), ('PySide2.QtGui.QPolygonF', 'PySide2.QtCore.Qt.FillRule'), ('list', 'PySide2.QtCore.Qt.FillRule')],
        "QPainter.drawPolyline": [('PySide2.QtGui.QPolygon',), ('PySide2.QtGui.QPolygonF',), ('list',)],
        "QPainter.drawRect": [('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',), ('int', 'int', 'int', 'int')],
        "QPainter.drawRects": ('list',),
        "QPainter.drawRoundRect": [('PySide2.QtCore.QRect', 'int', 'int'), ('PySide2.QtCore.QRectF', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'int')],
        "QPainter.drawRoundedRect": [('PySide2.QtCore.QRect', 'float', 'float', 'PySide2.QtCore.Qt.SizeMode'), ('PySide2.QtCore.QRectF', 'float', 'float', 'PySide2.QtCore.Qt.SizeMode'), ('int', 'int', 'int', 'int', 'float', 'float', 'PySide2.QtCore.Qt.SizeMode')],
        "QPainter.drawStaticText": [('PySide2.QtCore.QPoint', 'PySide2.QtGui.QStaticText'), ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QStaticText'), ('int', 'int', 'PySide2.QtGui.QStaticText')],
        "QPainter.drawText": [('PySide2.QtCore.QPoint', 'str'), ('PySide2.QtCore.QPointF', 'str'), ('PySide2.QtCore.QRect', 'int', 'str', 'PySide2.QtCore.QRect'), ('PySide2.QtCore.QRectF', 'int', 'str', 'PySide2.QtCore.QRectF'), ('PySide2.QtCore.QRectF', 'str', 'PySide2.QtGui.QTextOption'), ('int', 'int', 'int', 'int', 'int', 'str', 'PySide2.QtCore.QRect'), ('int', 'int', 'str')],
        "QPainter.drawTextItem": [('PySide2.QtCore.QPoint', 'PySide2.QtGui.QTextItem'), ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QTextItem'), ('int', 'int', 'PySide2.QtGui.QTextItem')],
        "QPainter.drawTiledPixmap": [('PySide2.QtCore.QRect', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QPoint'), ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QPointF'), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QPixmap', 'int', 'int')],
        "QPainter.end": (),
        "QPainter.endNativePainting": (),
        "QPainter.eraseRect": [('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',), ('int', 'int', 'int', 'int')],
        "QPainter.fillPath": ('PySide2.QtGui.QPainterPath', 'PySide2.QtGui.QBrush'),
        "QPainter.fillRect": [('PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.BrushStyle'), ('PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.GlobalColor'), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QBrush'), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QColor'), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QGradient.Preset'), ('PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.BrushStyle'), ('PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.GlobalColor'), ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QBrush'), ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QColor'), ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QGradient.Preset'), ('int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.BrushStyle'), ('int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.GlobalColor'), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QBrush'), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QColor'), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QGradient.Preset')],
        "QPainter.font": (),
        "QPainter.fontInfo": (),
        "QPainter.fontMetrics": (),
        "QPainter.hasClipping": (),
        "QPainter.initFrom": ('PySide2.QtGui.QPaintDevice',),
        "QPainter.isActive": (),
        "QPainter.layoutDirection": (),
        "QPainter.matrix": (),
        "QPainter.matrixEnabled": (),
        "QPainter.opacity": (),
        "QPainter.paintEngine": (),
        "QPainter.pen": (),
        "QPainter.redirected": ('PySide2.QtGui.QPaintDevice', 'PySide2.QtCore.QPoint'),
        "QPainter.renderHints": (),
        "QPainter.resetMatrix": (),
        "QPainter.resetTransform": (),
        "QPainter.restore": (),
        "QPainter.restoreRedirected": ('PySide2.QtGui.QPaintDevice',),
        "QPainter.rotate": ('float',),
        "QPainter.save": (),
        "QPainter.scale": ('float', 'float'),
        "QPainter.setBackground": ('PySide2.QtGui.QBrush',),
        "QPainter.setBackgroundMode": ('PySide2.QtCore.Qt.BGMode',),
        "QPainter.setBrush": [('PySide2.QtCore.Qt.BrushStyle',), ('PySide2.QtGui.QBrush',)],
        "QPainter.setBrushOrigin": [('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('int', 'int')],
        "QPainter.setClipPath": ('PySide2.QtGui.QPainterPath', 'PySide2.QtCore.Qt.ClipOperation'),
        "QPainter.setClipRect": [('PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.ClipOperation'), ('PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.ClipOperation'), ('int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.ClipOperation')],
        "QPainter.setClipRegion": ('PySide2.QtGui.QRegion', 'PySide2.QtCore.Qt.ClipOperation'),
        "QPainter.setClipping": ('bool',),
        "QPainter.setCompositionMode": ('PySide2.QtGui.QPainter.CompositionMode',),
        "QPainter.setFont": ('PySide2.QtGui.QFont',),
        "QPainter.setLayoutDirection": ('PySide2.QtCore.Qt.LayoutDirection',),
        "QPainter.setMatrix": ('PySide2.QtGui.QMatrix', 'bool'),
        "QPainter.setMatrixEnabled": ('bool',),
        "QPainter.setOpacity": ('float',),
        "QPainter.setPen": [('PySide2.QtCore.Qt.PenStyle',), ('PySide2.QtGui.QColor',), ('PySide2.QtGui.QPen',)],
        "QPainter.setRedirected": ('PySide2.QtGui.QPaintDevice', 'PySide2.QtGui.QPaintDevice', 'PySide2.QtCore.QPoint'),
        "QPainter.setRenderHint": ('PySide2.QtGui.QPainter.RenderHint', 'bool'),
        "QPainter.setRenderHints": ('PySide2.QtGui.QPainter.RenderHints', 'bool'),
        "QPainter.setTransform": ('PySide2.QtGui.QTransform', 'bool'),
        "QPainter.setViewTransformEnabled": ('bool',),
        "QPainter.setViewport": [('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
        "QPainter.setWindow": [('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
        "QPainter.setWorldMatrix": ('PySide2.QtGui.QMatrix', 'bool'),
        "QPainter.setWorldMatrixEnabled": ('bool',),
        "QPainter.setWorldTransform": ('PySide2.QtGui.QTransform', 'bool'),
        "QPainter.shear": ('float', 'float'),
        "QPainter.strokePath": ('PySide2.QtGui.QPainterPath', 'PySide2.QtGui.QPen'),
        "QPainter.testRenderHint": ('PySide2.QtGui.QPainter.RenderHint',),
        "QPainter.transform": (),
        "QPainter.translate": [('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QPainter.viewTransformEnabled": (),
        "QPainter.viewport": (),
        "QPainter.window": (),
        "QPainter.worldMatrix": (),
        "QPainter.worldMatrixEnabled": (),
        "QPainter.worldTransform": (),

    # class PySide2.QtGui.QPainter.PixmapFragment:
        "QPainter.PixmapFragment.__init__": [(), ('PySide2.QtGui.QPainter.PixmapFragment',)],
        "QPainter.PixmapFragment.__copy__": (),
        "QPainter.PixmapFragment.create": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QRectF', 'float', 'float', 'float', 'float'),

    # class PySide2.QtGui.QPainterPath:
        "QPainterPath.__init__": [(), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QPainterPath',)],
        "QPainterPath.__add__": ('PySide2.QtGui.QPainterPath',),
        "QPainterPath.__and__": ('PySide2.QtGui.QPainterPath',),
        "QPainterPath.__copy__": (),
        "QPainterPath.__iadd__": ('PySide2.QtGui.QPainterPath',),
        "QPainterPath.__iand__": ('PySide2.QtGui.QPainterPath',),
        "QPainterPath.__ior__": ('PySide2.QtGui.QPainterPath',),
        "QPainterPath.__isub__": ('PySide2.QtGui.QPainterPath',),
        "QPainterPath.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QPainterPath.__mul__": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',)],
        "QPainterPath.__or__": ('PySide2.QtGui.QPainterPath',),
        "QPainterPath.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QPainterPath.__sub__": ('PySide2.QtGui.QPainterPath',),
        "QPainterPath.addEllipse": [('PySide2.QtCore.QPointF', 'float', 'float'), ('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
        "QPainterPath.addPath": ('PySide2.QtGui.QPainterPath',),
        "QPainterPath.addPolygon": ('PySide2.QtGui.QPolygonF',),
        "QPainterPath.addRect": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
        "QPainterPath.addRegion": ('PySide2.QtGui.QRegion',),
        "QPainterPath.addRoundRect": [('PySide2.QtCore.QRectF', 'int'), ('PySide2.QtCore.QRectF', 'int', 'int'), ('float', 'float', 'float', 'float', 'int'), ('float', 'float', 'float', 'float', 'int', 'int')],
        "QPainterPath.addRoundedRect": [('PySide2.QtCore.QRectF', 'float', 'float', 'PySide2.QtCore.Qt.SizeMode'), ('float', 'float', 'float', 'float', 'float', 'float', 'PySide2.QtCore.Qt.SizeMode')],
        "QPainterPath.addText": [('PySide2.QtCore.QPointF', 'PySide2.QtGui.QFont', 'str'), ('float', 'float', 'PySide2.QtGui.QFont', 'str')],
        "QPainterPath.angleAtPercent": ('float',),
        "QPainterPath.arcMoveTo": [('PySide2.QtCore.QRectF', 'float'), ('float', 'float', 'float', 'float', 'float')],
        "QPainterPath.arcTo": [('PySide2.QtCore.QRectF', 'float', 'float'), ('float', 'float', 'float', 'float', 'float', 'float')],
        "QPainterPath.boundingRect": (),
        "QPainterPath.closeSubpath": (),
        "QPainterPath.connectPath": ('PySide2.QtGui.QPainterPath',),
        "QPainterPath.contains": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPainterPath',)],
        "QPainterPath.controlPointRect": (),
        "QPainterPath.cubicTo": [('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'), ('float', 'float', 'float', 'float', 'float', 'float')],
        "QPainterPath.currentPosition": (),
        "QPainterPath.elementAt": ('int',),
        "QPainterPath.elementCount": (),
        "QPainterPath.fillRule": (),
        "QPainterPath.intersected": ('PySide2.QtGui.QPainterPath',),
        "QPainterPath.intersects": [('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPainterPath',)],
        "QPainterPath.isEmpty": (),
        "QPainterPath.length": (),
        "QPainterPath.lineTo": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QPainterPath.moveTo": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QPainterPath.percentAtLength": ('float',),
        "QPainterPath.pointAtPercent": ('float',),
        "QPainterPath.quadTo": [('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'), ('float', 'float', 'float', 'float')],
        "QPainterPath.setElementPositionAt": ('int', 'float', 'float'),
        "QPainterPath.setFillRule": ('PySide2.QtCore.Qt.FillRule',),
        "QPainterPath.simplified": (),
        "QPainterPath.slopeAtPercent": ('float',),
        "QPainterPath.subtracted": ('PySide2.QtGui.QPainterPath',),
        "QPainterPath.subtractedInverted": ('PySide2.QtGui.QPainterPath',),
        "QPainterPath.swap": ('PySide2.QtGui.QPainterPath',),
        "QPainterPath.toFillPolygon": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',)],
        "QPainterPath.toFillPolygons": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',)],
        "QPainterPath.toReversed": (),
        "QPainterPath.toSubpathPolygons": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',)],
        "QPainterPath.translate": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QPainterPath.translated": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QPainterPath.united": ('PySide2.QtGui.QPainterPath',),

    # class PySide2.QtGui.QPainterPath.Element:
        "QPainterPath.Element.__init__": [(), ('PySide2.QtGui.QPainterPath.Element',)],
        "QPainterPath.Element.__copy__": (),
        "QPainterPath.Element.isCurveTo": (),
        "QPainterPath.Element.isLineTo": (),
        "QPainterPath.Element.isMoveTo": (),

    # class PySide2.QtGui.QPainterPathStroker:
        "QPainterPathStroker.__init__": [(), ('PySide2.QtGui.QPen',)],
        "QPainterPathStroker.capStyle": (),
        "QPainterPathStroker.createStroke": ('PySide2.QtGui.QPainterPath',),
        "QPainterPathStroker.curveThreshold": (),
        "QPainterPathStroker.dashOffset": (),
        "QPainterPathStroker.dashPattern": (),
        "QPainterPathStroker.joinStyle": (),
        "QPainterPathStroker.miterLimit": (),
        "QPainterPathStroker.setCapStyle": ('PySide2.QtCore.Qt.PenCapStyle',),
        "QPainterPathStroker.setCurveThreshold": ('float',),
        "QPainterPathStroker.setDashOffset": ('float',),
        "QPainterPathStroker.setDashPattern": [('PySide2.QtCore.Qt.PenStyle',), ('list',)],
        "QPainterPathStroker.setJoinStyle": ('PySide2.QtCore.Qt.PenJoinStyle',),
        "QPainterPathStroker.setMiterLimit": ('float',),
        "QPainterPathStroker.setWidth": ('float',),
        "QPainterPathStroker.width": (),

    # class PySide2.QtGui.QPalette:
        "QPalette.__init__": [(), ('PySide2.QtCore.Qt.GlobalColor',), ('PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush'), ('PySide2.QtGui.QColor',), ('PySide2.QtGui.QColor', 'PySide2.QtGui.QColor'), ('PySide2.QtGui.QColor', 'PySide2.QtGui.QColor', 'PySide2.QtGui.QColor', 'PySide2.QtGui.QColor', 'PySide2.QtGui.QColor', 'PySide2.QtGui.QColor', 'PySide2.QtGui.QColor'), ('PySide2.QtGui.QPalette',)],
        "QPalette.__copy__": (),
        "QPalette.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QPalette.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QPalette.alternateBase": (),
        "QPalette.background": (),
        "QPalette.base": (),
        "QPalette.brightText": (),
        "QPalette.brush": [('PySide2.QtGui.QPalette.ColorGroup', 'PySide2.QtGui.QPalette.ColorRole'), ('PySide2.QtGui.QPalette.ColorRole',)],
        "QPalette.button": (),
        "QPalette.buttonText": (),
        "QPalette.cacheKey": (),
        "QPalette.color": [('PySide2.QtGui.QPalette.ColorGroup', 'PySide2.QtGui.QPalette.ColorRole'), ('PySide2.QtGui.QPalette.ColorRole',)],
        "QPalette.currentColorGroup": (),
        "QPalette.dark": (),
        "QPalette.foreground": (),
        "QPalette.highlight": (),
        "QPalette.highlightedText": (),
        "QPalette.isBrushSet": ('PySide2.QtGui.QPalette.ColorGroup', 'PySide2.QtGui.QPalette.ColorRole'),
        "QPalette.isCopyOf": ('PySide2.QtGui.QPalette',),
        "QPalette.isEqual": ('PySide2.QtGui.QPalette.ColorGroup', 'PySide2.QtGui.QPalette.ColorGroup'),
        "QPalette.light": (),
        "QPalette.link": (),
        "QPalette.linkVisited": (),
        "QPalette.mid": (),
        "QPalette.midlight": (),
        "QPalette.placeholderText": (),
        "QPalette.resolve": [(), ('PySide2.QtGui.QPalette',), ('int',)],
        "QPalette.setBrush": [('PySide2.QtGui.QPalette.ColorGroup', 'PySide2.QtGui.QPalette.ColorRole', 'PySide2.QtGui.QBrush'), ('PySide2.QtGui.QPalette.ColorRole', 'PySide2.QtGui.QBrush')],
        "QPalette.setColor": [('PySide2.QtGui.QPalette.ColorGroup', 'PySide2.QtGui.QPalette.ColorRole', 'PySide2.QtGui.QColor'), ('PySide2.QtGui.QPalette.ColorRole', 'PySide2.QtGui.QColor')],
        "QPalette.setColorGroup": ('PySide2.QtGui.QPalette.ColorGroup', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush'),
        "QPalette.setCurrentColorGroup": ('PySide2.QtGui.QPalette.ColorGroup',),
        "QPalette.shadow": (),
        "QPalette.swap": ('PySide2.QtGui.QPalette',),
        "QPalette.text": (),
        "QPalette.toolTipBase": (),
        "QPalette.toolTipText": (),
        "QPalette.window": (),
        "QPalette.windowText": (),

    # class PySide2.QtGui.QPdfWriter:
        "QPdfWriter.__init__": [('PySide2.QtCore.QIODevice',), ('str',)],
        "QPdfWriter.creator": (),
        "QPdfWriter.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
        "QPdfWriter.newPage": (),
        "QPdfWriter.paintEngine": (),
        "QPdfWriter.pdfVersion": (),
        "QPdfWriter.resolution": (),
        "QPdfWriter.setCreator": ('str',),
        "QPdfWriter.setMargins": ('PySide2.QtGui.QPagedPaintDevice.Margins',),
        "QPdfWriter.setPageSize": ('PySide2.QtGui.QPagedPaintDevice.PageSize',),
        "QPdfWriter.setPageSizeMM": ('PySide2.QtCore.QSizeF',),
        "QPdfWriter.setPdfVersion": ('PySide2.QtGui.QPagedPaintDevice.PdfVersion',),
        "QPdfWriter.setResolution": ('int',),
        "QPdfWriter.setTitle": ('str',),
        "QPdfWriter.title": (),

    # class PySide2.QtGui.QPen:
        "QPen.__init__": [(), ('PySide2.QtCore.Qt.PenStyle',), ('PySide2.QtGui.QBrush', 'float', 'PySide2.QtCore.Qt.PenStyle', 'PySide2.QtCore.Qt.PenCapStyle', 'PySide2.QtCore.Qt.PenJoinStyle'), ('PySide2.QtGui.QColor',), ('PySide2.QtGui.QPen',)],
        "QPen.__copy__": (),
        "QPen.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QPen.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QPen.brush": (),
        "QPen.capStyle": (),
        "QPen.color": (),
        "QPen.dashOffset": (),
        "QPen.dashPattern": (),
        "QPen.isCosmetic": (),
        "QPen.isSolid": (),
        "QPen.joinStyle": (),
        "QPen.miterLimit": (),
        "QPen.setBrush": ('PySide2.QtGui.QBrush',),
        "QPen.setCapStyle": ('PySide2.QtCore.Qt.PenCapStyle',),
        "QPen.setColor": ('PySide2.QtGui.QColor',),
        "QPen.setCosmetic": ('bool',),
        "QPen.setDashOffset": ('float',),
        "QPen.setDashPattern": ('list',),
        "QPen.setJoinStyle": ('PySide2.QtCore.Qt.PenJoinStyle',),
        "QPen.setMiterLimit": ('float',),
        "QPen.setStyle": ('PySide2.QtCore.Qt.PenStyle',),
        "QPen.setWidth": ('int',),
        "QPen.setWidthF": ('float',),
        "QPen.style": (),
        "QPen.swap": ('PySide2.QtGui.QPen',),
        "QPen.width": (),
        "QPen.widthF": (),

    # class PySide2.QtGui.QPicture:
        "QPicture.__init__": [('PySide2.QtGui.QPicture',), ('int',)],
        "QPicture.__copy__": (),
        "QPicture.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QPicture.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QPicture.boundingRect": (),
        "QPicture.data": (),
        "QPicture.devType": (),
        "QPicture.inputFormatList": (),
        "QPicture.inputFormats": (),
        "QPicture.isNull": (),
        "QPicture.load": [('PySide2.QtCore.QIODevice', 'str'), ('str', 'str')],
        "QPicture.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
        "QPicture.outputFormatList": (),
        "QPicture.outputFormats": (),
        "QPicture.paintEngine": (),
        "QPicture.pictureFormat": ('str',),
        "QPicture.play": ('PySide2.QtGui.QPainter',),
        "QPicture.save": [('PySide2.QtCore.QIODevice', 'str'), ('str', 'str')],
        "QPicture.setBoundingRect": ('PySide2.QtCore.QRect',),
        "QPicture.setData": ('str', 'int'),
        "QPicture.size": (),
        "QPicture.swap": ('PySide2.QtGui.QPicture',),

    # class PySide2.QtGui.QPictureIO:
        "QPictureIO.__init__": [(), ('PySide2.QtCore.QIODevice', 'str'), ('str', 'str')],
        "QPictureIO.description": (),
        "QPictureIO.fileName": (),
        "QPictureIO.format": (),
        "QPictureIO.gamma": (),
        "QPictureIO.inputFormats": (),
        "QPictureIO.ioDevice": (),
        "QPictureIO.outputFormats": (),
        "QPictureIO.parameters": (),
        "QPictureIO.picture": (),
        "QPictureIO.pictureFormat": [('PySide2.QtCore.QIODevice',), ('str',)],
        "QPictureIO.quality": (),
        "QPictureIO.read": (),
        "QPictureIO.setDescription": ('str',),
        "QPictureIO.setFileName": ('str',),
        "QPictureIO.setFormat": ('str',),
        "QPictureIO.setGamma": ('float',),
        "QPictureIO.setIODevice": ('PySide2.QtCore.QIODevice',),
        "QPictureIO.setParameters": ('str',),
        "QPictureIO.setPicture": ('PySide2.QtGui.QPicture',),
        "QPictureIO.setQuality": ('int',),
        "QPictureIO.setStatus": ('int',),
        "QPictureIO.status": (),
        "QPictureIO.write": (),

    # class PySide2.QtGui.QPixelFormat:
        "QPixelFormat.__init__": [(), ('PySide2.QtGui.QPixelFormat',), ('PySide2.QtGui.QPixelFormat.ColorModel', 'typing.Union[str, int]', 'typing.Union[str, int]', 'typing.Union[str, int]', 'typing.Union[str, int]', 'typing.Union[str, int]', 'typing.Union[str, int]', 'PySide2.QtGui.QPixelFormat.AlphaUsage', 'PySide2.QtGui.QPixelFormat.AlphaPosition', 'PySide2.QtGui.QPixelFormat.AlphaPremultiplied', 'PySide2.QtGui.QPixelFormat.TypeInterpretation', 'PySide2.QtGui.QPixelFormat.ByteOrder', 'typing.Union[str, int]')],
        "QPixelFormat.__copy__": (),
        "QPixelFormat.alphaPosition": (),
        "QPixelFormat.alphaSize": (),
        "QPixelFormat.alphaUsage": (),
        "QPixelFormat.bitsPerPixel": (),
        "QPixelFormat.blackSize": (),
        "QPixelFormat.blueSize": (),
        "QPixelFormat.brightnessSize": (),
        "QPixelFormat.byteOrder": (),
        "QPixelFormat.channelCount": (),
        "QPixelFormat.colorModel": (),
        "QPixelFormat.cyanSize": (),
        "QPixelFormat.greenSize": (),
        "QPixelFormat.hueSize": (),
        "QPixelFormat.lightnessSize": (),
        "QPixelFormat.magentaSize": (),
        "QPixelFormat.premultiplied": (),
        "QPixelFormat.redSize": (),
        "QPixelFormat.saturationSize": (),
        "QPixelFormat.subEnum": (),
        "QPixelFormat.typeInterpretation": (),
        "QPixelFormat.yellowSize": (),
        "QPixelFormat.yuvLayout": (),

    # class PySide2.QtGui.QPixmap:
        "QPixmap.__init__": [(), ('PySide2.QtCore.QSize',), ('PySide2.QtGui.QImage',), ('PySide2.QtGui.QPixmap',), ('int', 'int'), ('str', 'str', 'PySide2.QtCore.Qt.ImageConversionFlags'), ('typing.List[str]',)],
        "QPixmap.__copy__": (),
        "QPixmap.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QPixmap.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QPixmap.cacheKey": (),
        "QPixmap.convertFromImage": ('PySide2.QtGui.QImage', 'PySide2.QtCore.Qt.ImageConversionFlags'),
        "QPixmap.copy": [('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
        "QPixmap.createHeuristicMask": ('bool',),
        "QPixmap.createMaskFromColor": ('PySide2.QtGui.QColor', 'PySide2.QtCore.Qt.MaskMode'),
        "QPixmap.defaultDepth": (),
        "QPixmap.depth": (),
        "QPixmap.devType": (),
        "QPixmap.devicePixelRatio": (),
        "QPixmap.fill": [('PySide2.QtGui.QColor',), ('PySide2.QtGui.QPaintDevice', 'PySide2.QtCore.QPoint'), ('PySide2.QtGui.QPaintDevice', 'int', 'int')],
        "QPixmap.fromImage": ('PySide2.QtGui.QImage', 'PySide2.QtCore.Qt.ImageConversionFlags'),
        "QPixmap.fromImageInPlace": ('PySide2.QtGui.QImage', 'PySide2.QtCore.Qt.ImageConversionFlags'),
        "QPixmap.fromImageReader": ('PySide2.QtGui.QImageReader', 'PySide2.QtCore.Qt.ImageConversionFlags'),
        "QPixmap.grabWidget": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QRect'), ('PySide2.QtCore.QObject', 'int', 'int', 'int', 'int')],
        "QPixmap.grabWindow": ('int', 'int', 'int', 'int', 'int'),
        "QPixmap.hasAlpha": (),
        "QPixmap.hasAlphaChannel": (),
        "QPixmap.height": (),
        "QPixmap.isNull": (),
        "QPixmap.isQBitmap": (),
        "QPixmap.load": ('str', 'str', 'PySide2.QtCore.Qt.ImageConversionFlags'),
        "QPixmap.loadFromData": [('PySide2.QtCore.QByteArray', 'str', 'PySide2.QtCore.Qt.ImageConversionFlags'), ('typing.Union[str, int]', 'int', 'str', 'PySide2.QtCore.Qt.ImageConversionFlags')],
        "QPixmap.mask": (),
        "QPixmap.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
        "QPixmap.paintEngine": (),
        "QPixmap.rect": (),
        "QPixmap.save": [('PySide2.QtCore.QIODevice', 'str', 'int'), ('str', 'str', 'int')],
        "QPixmap.scaled": [('PySide2.QtCore.QSize', 'PySide2.QtCore.Qt.AspectRatioMode', 'PySide2.QtCore.Qt.TransformationMode'), ('int', 'int', 'PySide2.QtCore.Qt.AspectRatioMode', 'PySide2.QtCore.Qt.TransformationMode')],
        "QPixmap.scaledToHeight": ('int', 'PySide2.QtCore.Qt.TransformationMode'),
        "QPixmap.scaledToWidth": ('int', 'PySide2.QtCore.Qt.TransformationMode'),
        "QPixmap.scroll": [('int', 'int', 'PySide2.QtCore.QRect', 'PySide2.QtGui.QRegion'), ('int', 'int', 'int', 'int', 'int', 'int', 'PySide2.QtGui.QRegion')],
        "QPixmap.setDevicePixelRatio": ('float',),
        "QPixmap.setMask": ('PySide2.QtGui.QBitmap',),
        "QPixmap.size": (),
        "QPixmap.swap": ('PySide2.QtGui.QPixmap',),
        "QPixmap.toImage": (),
        "QPixmap.transformed": [('PySide2.QtGui.QMatrix', 'PySide2.QtCore.Qt.TransformationMode'), ('PySide2.QtGui.QTransform', 'PySide2.QtCore.Qt.TransformationMode')],
        "QPixmap.trueMatrix": [('PySide2.QtGui.QMatrix', 'int', 'int'), ('PySide2.QtGui.QTransform', 'int', 'int')],
        "QPixmap.width": (),

    # class PySide2.QtGui.QPixmapCache:
        "QPixmapCache.__init__": (),
        "QPixmapCache.cacheLimit": (),
        "QPixmapCache.clear": (),
        "QPixmapCache.find": [('PySide2.QtGui.QPixmapCache.Key',), ('PySide2.QtGui.QPixmapCache.Key', 'PySide2.QtGui.QPixmap'), ('str',), ('str', 'PySide2.QtGui.QPixmap')],
        "QPixmapCache.insert": [('PySide2.QtGui.QPixmap',), ('str', 'PySide2.QtGui.QPixmap')],
        "QPixmapCache.remove": [('PySide2.QtGui.QPixmapCache.Key',), ('str',)],
        "QPixmapCache.replace": ('PySide2.QtGui.QPixmapCache.Key', 'PySide2.QtGui.QPixmap'),
        "QPixmapCache.setCacheLimit": ('int',),

    # class PySide2.QtGui.QPixmapCache.Key:
        "QPixmapCache.Key.__init__": [(), ('PySide2.QtGui.QPixmapCache.Key',)],
        "QPixmapCache.Key.__copy__": (),
        "QPixmapCache.Key.isValid": (),
        "QPixmapCache.Key.swap": ('PySide2.QtGui.QPixmapCache.Key',),

    # class PySide2.QtGui.QPointingDeviceUniqueId:
        "QPointingDeviceUniqueId.__init__": [(), ('PySide2.QtGui.QPointingDeviceUniqueId',)],
        "QPointingDeviceUniqueId.__copy__": (),
        "QPointingDeviceUniqueId.fromNumericId": ('int',),
        "QPointingDeviceUniqueId.isValid": (),
        "QPointingDeviceUniqueId.numericId": (),

    # class PySide2.QtGui.QPolygon:
        "QPolygon.__init__": [(), ('PySide2.QtCore.QRect', 'bool'), ('PySide2.QtGui.QPolygon',), ('int',), ('list',)],
        "QPolygon.__add__": ('list',),
        "QPolygon.__copy__": (),
        "QPolygon.__iadd__": ('PySide2.QtCore.QPoint',),
        "QPolygon.__lshift__": [('PySide2.QtCore.QDataStream',), ('PySide2.QtCore.QPoint',), ('list',)],
        "QPolygon.__mul__": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',)],
        "QPolygon.__reduce__": (),
        "QPolygon.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QPolygon.append": [('PySide2.QtCore.QPoint',), ('list',)],
        "QPolygon.at": ('int',),
        "QPolygon.back": (),
        "QPolygon.boundingRect": (),
        "QPolygon.capacity": (),
        "QPolygon.clear": (),
        "QPolygon.constData": (),
        "QPolygon.constFirst": (),
        "QPolygon.constLast": (),
        "QPolygon.contains": ('PySide2.QtCore.QPoint',),
        "QPolygon.containsPoint": ('PySide2.QtCore.QPoint', 'PySide2.QtCore.Qt.FillRule'),
        "QPolygon.count": [(), ('PySide2.QtCore.QPoint',)],
        "QPolygon.data": (),
        "QPolygon.empty": (),
        "QPolygon.endsWith": ('PySide2.QtCore.QPoint',),
        "QPolygon.fill": ('PySide2.QtCore.QPoint', 'int'),
        "QPolygon.first": (),
        "QPolygon.fromList": ('list',),
        "QPolygon.front": (),
        "QPolygon.indexOf": ('PySide2.QtCore.QPoint', 'int'),
        "QPolygon.insert": [('int', 'PySide2.QtCore.QPoint'), ('int', 'int', 'PySide2.QtCore.QPoint')],
        "QPolygon.intersected": ('PySide2.QtGui.QPolygon',),
        "QPolygon.intersects": ('PySide2.QtGui.QPolygon',),
        "QPolygon.isEmpty": (),
        "QPolygon.isSharedWith": ('list',),
        "QPolygon.last": (),
        "QPolygon.lastIndexOf": ('PySide2.QtCore.QPoint', 'int'),
        "QPolygon.length": (),
        "QPolygon.mid": ('int', 'int'),
        "QPolygon.move": ('int', 'int'),
        "QPolygon.pop_back": (),
        "QPolygon.pop_front": (),
        "QPolygon.prepend": ('PySide2.QtCore.QPoint',),
        "QPolygon.push_back": ('PySide2.QtCore.QPoint',),
        "QPolygon.push_front": ('PySide2.QtCore.QPoint',),
        "QPolygon.remove": [('int',), ('int', 'int')],
        "QPolygon.removeAll": ('PySide2.QtCore.QPoint',),
        "QPolygon.removeAt": ('int',),
        "QPolygon.removeFirst": (),
        "QPolygon.removeLast": (),
        "QPolygon.removeOne": ('PySide2.QtCore.QPoint',),
        "QPolygon.replace": ('int', 'PySide2.QtCore.QPoint'),
        "QPolygon.reserve": ('int',),
        "QPolygon.resize": ('int',),
        "QPolygon.setSharable": ('bool',),
        "QPolygon.shrink_to_fit": (),
        "QPolygon.size": (),
        "QPolygon.squeeze": (),
        "QPolygon.startsWith": ('PySide2.QtCore.QPoint',),
        "QPolygon.subtracted": ('PySide2.QtGui.QPolygon',),
        "QPolygon.swap": ('PySide2.QtGui.QPolygon',),
        "QPolygon.takeAt": ('int',),
        "QPolygon.takeFirst": (),
        "QPolygon.takeLast": (),
        "QPolygon.toList": (),
        "QPolygon.translate": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QPolygon.translated": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QPolygon.united": ('PySide2.QtGui.QPolygon',),
        "QPolygon.value": [('int',), ('int', 'PySide2.QtCore.QPoint')],

    # class PySide2.QtGui.QPolygonF:
        "QPolygonF.__init__": [(), ('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPolygon',), ('PySide2.QtGui.QPolygonF',), ('int',), ('list',)],
        "QPolygonF.__add__": ('list',),
        "QPolygonF.__copy__": (),
        "QPolygonF.__iadd__": ('PySide2.QtCore.QPointF',),
        "QPolygonF.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QPolygonF.__mul__": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',)],
        "QPolygonF.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QPolygonF.append": [('PySide2.QtCore.QPointF',), ('list',)],
        "QPolygonF.at": ('int',),
        "QPolygonF.back": (),
        "QPolygonF.boundingRect": (),
        "QPolygonF.capacity": (),
        "QPolygonF.clear": (),
        "QPolygonF.constData": (),
        "QPolygonF.constFirst": (),
        "QPolygonF.constLast": (),
        "QPolygonF.contains": ('PySide2.QtCore.QPointF',),
        "QPolygonF.containsPoint": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.FillRule'),
        "QPolygonF.count": [(), ('PySide2.QtCore.QPointF',)],
        "QPolygonF.data": (),
        "QPolygonF.empty": (),
        "QPolygonF.endsWith": ('PySide2.QtCore.QPointF',),
        "QPolygonF.fill": ('PySide2.QtCore.QPointF', 'int'),
        "QPolygonF.first": (),
        "QPolygonF.fromList": ('list',),
        "QPolygonF.front": (),
        "QPolygonF.indexOf": ('PySide2.QtCore.QPointF', 'int'),
        "QPolygonF.insert": [('int', 'PySide2.QtCore.QPointF'), ('int', 'int', 'PySide2.QtCore.QPointF')],
        "QPolygonF.intersected": ('PySide2.QtGui.QPolygonF',),
        "QPolygonF.intersects": ('PySide2.QtGui.QPolygonF',),
        "QPolygonF.isClosed": (),
        "QPolygonF.isEmpty": (),
        "QPolygonF.isSharedWith": ('list',),
        "QPolygonF.last": (),
        "QPolygonF.lastIndexOf": ('PySide2.QtCore.QPointF', 'int'),
        "QPolygonF.length": (),
        "QPolygonF.mid": ('int', 'int'),
        "QPolygonF.move": ('int', 'int'),
        "QPolygonF.pop_back": (),
        "QPolygonF.pop_front": (),
        "QPolygonF.prepend": ('PySide2.QtCore.QPointF',),
        "QPolygonF.push_back": ('PySide2.QtCore.QPointF',),
        "QPolygonF.push_front": ('PySide2.QtCore.QPointF',),
        "QPolygonF.remove": [('int',), ('int', 'int')],
        "QPolygonF.removeAll": ('PySide2.QtCore.QPointF',),
        "QPolygonF.removeAt": ('int',),
        "QPolygonF.removeFirst": (),
        "QPolygonF.removeLast": (),
        "QPolygonF.removeOne": ('PySide2.QtCore.QPointF',),
        "QPolygonF.replace": ('int', 'PySide2.QtCore.QPointF'),
        "QPolygonF.reserve": ('int',),
        "QPolygonF.resize": ('int',),
        "QPolygonF.setSharable": ('bool',),
        "QPolygonF.shrink_to_fit": (),
        "QPolygonF.size": (),
        "QPolygonF.squeeze": (),
        "QPolygonF.startsWith": ('PySide2.QtCore.QPointF',),
        "QPolygonF.subtracted": ('PySide2.QtGui.QPolygonF',),
        "QPolygonF.swap": ('PySide2.QtGui.QPolygonF',),
        "QPolygonF.takeAt": ('int',),
        "QPolygonF.takeFirst": (),
        "QPolygonF.takeLast": (),
        "QPolygonF.toList": (),
        "QPolygonF.toPolygon": (),
        "QPolygonF.translate": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QPolygonF.translated": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QPolygonF.united": ('PySide2.QtGui.QPolygonF',),
        "QPolygonF.value": [('int',), ('int', 'PySide2.QtCore.QPointF')],

    # class PySide2.QtGui.QPyTextObject:
        "QPyTextObject.__init__": ('PySide2.QtCore.QObject',),
        "QPyTextObject.drawObject": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF', 'PySide2.QtGui.QTextDocument', 'int', 'PySide2.QtGui.QTextFormat'),
        "QPyTextObject.intrinsicSize": ('PySide2.QtGui.QTextDocument', 'int', 'PySide2.QtGui.QTextFormat'),

    # class PySide2.QtGui.QQuaternion:
        "QQuaternion.__init__": [(), ('PySide2.QtGui.QVector4D',), ('float', 'PySide2.QtGui.QVector3D'), ('float', 'float', 'float', 'float')],
        "QQuaternion.__add__": ('PySide2.QtGui.QQuaternion',),
        "QQuaternion.__copy__": (),
        "QQuaternion.__iadd__": ('PySide2.QtGui.QQuaternion',),
        "QQuaternion.__imul__": [('PySide2.QtGui.QQuaternion',), ('float',)],
        "QQuaternion.__isub__": ('PySide2.QtGui.QQuaternion',),
        "QQuaternion.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QQuaternion.__mul__": [('PySide2.QtGui.QQuaternion',), ('float',)],
        "QQuaternion.__neg__": (),
        "QQuaternion.__reduce__": (),
        "QQuaternion.__repr__": (),
        "QQuaternion.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QQuaternion.__sub__": ('PySide2.QtGui.QQuaternion',),
        "QQuaternion.conjugate": (),
        "QQuaternion.conjugated": (),
        "QQuaternion.dotProduct": ('PySide2.QtGui.QQuaternion', 'PySide2.QtGui.QQuaternion'),
        "QQuaternion.fromAxes": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
        "QQuaternion.fromAxisAndAngle": [('PySide2.QtGui.QVector3D', 'float'), ('float', 'float', 'float', 'float')],
        "QQuaternion.fromDirection": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
        "QQuaternion.fromEulerAngles": [('PySide2.QtGui.QVector3D',), ('float', 'float', 'float')],
        "QQuaternion.fromRotationMatrix": ('PySide2.QtGui.QMatrix3x3',),
        "QQuaternion.getAxes": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
        "QQuaternion.inverted": (),
        "QQuaternion.isIdentity": (),
        "QQuaternion.isNull": (),
        "QQuaternion.length": (),
        "QQuaternion.lengthSquared": (),
        "QQuaternion.nlerp": ('PySide2.QtGui.QQuaternion', 'PySide2.QtGui.QQuaternion', 'float'),
        "QQuaternion.normalize": (),
        "QQuaternion.normalized": (),
        "QQuaternion.rotatedVector": ('PySide2.QtGui.QVector3D',),
        "QQuaternion.rotationTo": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
        "QQuaternion.scalar": (),
        "QQuaternion.setScalar": ('float',),
        "QQuaternion.setVector": [('PySide2.QtGui.QVector3D',), ('float', 'float', 'float')],
        "QQuaternion.setX": ('float',),
        "QQuaternion.setY": ('float',),
        "QQuaternion.setZ": ('float',),
        "QQuaternion.slerp": ('PySide2.QtGui.QQuaternion', 'PySide2.QtGui.QQuaternion', 'float'),
        "QQuaternion.toEulerAngles": (),
        "QQuaternion.toRotationMatrix": (),
        "QQuaternion.toVector4D": (),
        "QQuaternion.vector": (),
        "QQuaternion.x": (),
        "QQuaternion.y": (),
        "QQuaternion.z": (),

    # class PySide2.QtGui.QRadialGradient:
        "QRadialGradient.__init__": [(), ('PySide2.QtCore.QPointF', 'float'), ('PySide2.QtCore.QPointF', 'float', 'PySide2.QtCore.QPointF'), ('PySide2.QtCore.QPointF', 'float', 'PySide2.QtCore.QPointF', 'float'), ('PySide2.QtGui.QRadialGradient',), ('float', 'float', 'float'), ('float', 'float', 'float', 'float', 'float'), ('float', 'float', 'float', 'float', 'float', 'float')],
        "QRadialGradient.__copy__": (),
        "QRadialGradient.center": (),
        "QRadialGradient.centerRadius": (),
        "QRadialGradient.focalPoint": (),
        "QRadialGradient.focalRadius": (),
        "QRadialGradient.radius": (),
        "QRadialGradient.setCenter": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QRadialGradient.setCenterRadius": ('float',),
        "QRadialGradient.setFocalPoint": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QRadialGradient.setFocalRadius": ('float',),
        "QRadialGradient.setRadius": ('float',),

    # class PySide2.QtGui.QRasterWindow:
        "QRasterWindow.__init__": ('PySide2.QtGui.QWindow',),
        "QRasterWindow.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
        "QRasterWindow.redirected": ('PySide2.QtCore.QPoint',),

    # class PySide2.QtGui.QRawFont:
        "QRawFont.__init__": [(), ('PySide2.QtCore.QByteArray', 'float', 'PySide2.QtGui.QFont.HintingPreference'), ('PySide2.QtGui.QRawFont',), ('str', 'float', 'PySide2.QtGui.QFont.HintingPreference')],
        "QRawFont.__copy__": (),
        "QRawFont.advancesForGlyphIndexes": [('list',), ('list', 'PySide2.QtGui.QRawFont.LayoutFlags')],
        "QRawFont.alphaMapForGlyph": ('int', 'PySide2.QtGui.QRawFont.AntialiasingType', 'PySide2.QtGui.QTransform'),
        "QRawFont.ascent": (),
        "QRawFont.averageCharWidth": (),
        "QRawFont.boundingRect": ('int',),
        "QRawFont.capHeight": (),
        "QRawFont.descent": (),
        "QRawFont.familyName": (),
        "QRawFont.fontTable": ('str',),
        "QRawFont.fromFont": ('PySide2.QtGui.QFont', 'PySide2.QtGui.QFontDatabase.WritingSystem'),
        "QRawFont.glyphIndexesForString": ('str',),
        "QRawFont.hintingPreference": (),
        "QRawFont.isValid": (),
        "QRawFont.leading": (),
        "QRawFont.lineThickness": (),
        "QRawFont.loadFromData": ('PySide2.QtCore.QByteArray', 'float', 'PySide2.QtGui.QFont.HintingPreference'),
        "QRawFont.loadFromFile": ('str', 'float', 'PySide2.QtGui.QFont.HintingPreference'),
        "QRawFont.maxCharWidth": (),
        "QRawFont.pathForGlyph": ('int',),
        "QRawFont.pixelSize": (),
        "QRawFont.setPixelSize": ('float',),
        "QRawFont.style": (),
        "QRawFont.styleName": (),
        "QRawFont.supportedWritingSystems": (),
        "QRawFont.supportsCharacter": [('int',), ('typing.Union[str, int]',)],
        "QRawFont.swap": ('PySide2.QtGui.QRawFont',),
        "QRawFont.underlinePosition": (),
        "QRawFont.unitsPerEm": (),
        "QRawFont.weight": (),
        "QRawFont.xHeight": (),

    # class PySide2.QtGui.QRegExpValidator:
        "QRegExpValidator.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtCore.QRegExp', 'PySide2.QtCore.QObject')],
        "QRegExpValidator.regExp": (),
        "QRegExpValidator.setRegExp": ('PySide2.QtCore.QRegExp',),
        "QRegExpValidator.validate": ('str', 'int'),

    # class PySide2.QtGui.QRegion:
        "QRegion.__init__": [(), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QRegion.RegionType'), ('PySide2.QtGui.QBitmap',), ('PySide2.QtGui.QPolygon', 'PySide2.QtCore.Qt.FillRule'), ('PySide2.QtGui.QRegion',), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QRegion.RegionType')],
        "QRegion.__add__": [('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],
        "QRegion.__and__": [('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],
        "QRegion.__copy__": (),
        "QRegion.__iadd__": [('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],
        "QRegion.__ior__": ('PySide2.QtGui.QRegion',),
        "QRegion.__isub__": ('PySide2.QtGui.QRegion',),
        "QRegion.__ixor__": ('PySide2.QtGui.QRegion',),
        "QRegion.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QRegion.__mul__": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',)],
        "QRegion.__or__": ('PySide2.QtGui.QRegion',),
        "QRegion.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QRegion.__sub__": ('PySide2.QtGui.QRegion',),
        "QRegion.__xor__": ('PySide2.QtGui.QRegion',),
        "QRegion.begin": (),
        "QRegion.boundingRect": (),
        "QRegion.cbegin": (),
        "QRegion.cend": (),
        "QRegion.contains": [('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QRect',)],
        "QRegion.end": (),
        "QRegion.intersected": [('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],
        "QRegion.intersects": [('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],
        "QRegion.isEmpty": (),
        "QRegion.isNull": (),
        "QRegion.rectCount": (),
        "QRegion.rects": (),
        "QRegion.setRects": ('PySide2.QtCore.QRect', 'int'),
        "QRegion.subtracted": ('PySide2.QtGui.QRegion',),
        "QRegion.swap": ('PySide2.QtGui.QRegion',),
        "QRegion.translate": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QRegion.translated": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QRegion.united": [('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],
        "QRegion.xored": ('PySide2.QtGui.QRegion',),

    # class PySide2.QtGui.QResizeEvent:
        "QResizeEvent.__init__": ('PySide2.QtCore.QSize', 'PySide2.QtCore.QSize'),
        "QResizeEvent.oldSize": (),
        "QResizeEvent.size": (),

    # class PySide2.QtGui.QScreen:
        "QScreen.angleBetween": ('PySide2.QtCore.Qt.ScreenOrientation', 'PySide2.QtCore.Qt.ScreenOrientation'),
        "QScreen.availableGeometry": (),
        "QScreen.availableSize": (),
        "QScreen.availableVirtualGeometry": (),
        "QScreen.availableVirtualSize": (),
        "QScreen.depth": (),
        "QScreen.devicePixelRatio": (),
        "QScreen.geometry": (),
        "QScreen.grabWindow": ('int', 'int', 'int', 'int', 'int'),
        "QScreen.isLandscape": ('PySide2.QtCore.Qt.ScreenOrientation',),
        "QScreen.isPortrait": ('PySide2.QtCore.Qt.ScreenOrientation',),
        "QScreen.logicalDotsPerInch": (),
        "QScreen.logicalDotsPerInchX": (),
        "QScreen.logicalDotsPerInchY": (),
        "QScreen.manufacturer": (),
        "QScreen.mapBetween": ('PySide2.QtCore.Qt.ScreenOrientation', 'PySide2.QtCore.Qt.ScreenOrientation', 'PySide2.QtCore.QRect'),
        "QScreen.model": (),
        "QScreen.name": (),
        "QScreen.nativeOrientation": (),
        "QScreen.orientation": (),
        "QScreen.orientationUpdateMask": (),
        "QScreen.physicalDotsPerInch": (),
        "QScreen.physicalDotsPerInchX": (),
        "QScreen.physicalDotsPerInchY": (),
        "QScreen.physicalSize": (),
        "QScreen.primaryOrientation": (),
        "QScreen.refreshRate": (),
        "QScreen.serialNumber": (),
        "QScreen.setOrientationUpdateMask": ('PySide2.QtCore.Qt.ScreenOrientations',),
        "QScreen.size": (),
        "QScreen.transformBetween": ('PySide2.QtCore.Qt.ScreenOrientation', 'PySide2.QtCore.Qt.ScreenOrientation', 'PySide2.QtCore.QRect'),
        "QScreen.virtualGeometry": (),
        "QScreen.virtualSiblings": (),
        "QScreen.virtualSize": (),

    # class PySide2.QtGui.QScrollEvent:
        "QScrollEvent.__init__": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtGui.QScrollEvent.ScrollState'),
        "QScrollEvent.contentPos": (),
        "QScrollEvent.overshootDistance": (),
        "QScrollEvent.scrollState": (),

    # class PySide2.QtGui.QScrollPrepareEvent:
        "QScrollPrepareEvent.__init__": ('PySide2.QtCore.QPointF',),
        "QScrollPrepareEvent.contentPos": (),
        "QScrollPrepareEvent.contentPosRange": (),
        "QScrollPrepareEvent.setContentPos": ('PySide2.QtCore.QPointF',),
        "QScrollPrepareEvent.setContentPosRange": ('PySide2.QtCore.QRectF',),
        "QScrollPrepareEvent.setViewportSize": ('PySide2.QtCore.QSizeF',),
        "QScrollPrepareEvent.startPos": (),
        "QScrollPrepareEvent.viewportSize": (),

    # class PySide2.QtGui.QSessionManager:
        "QSessionManager.allowsErrorInteraction": (),
        "QSessionManager.allowsInteraction": (),
        "QSessionManager.cancel": (),
        "QSessionManager.discardCommand": (),
        "QSessionManager.isPhase2": (),
        "QSessionManager.release": (),
        "QSessionManager.requestPhase2": (),
        "QSessionManager.restartCommand": (),
        "QSessionManager.restartHint": (),
        "QSessionManager.sessionId": (),
        "QSessionManager.sessionKey": (),
        "QSessionManager.setDiscardCommand": ('typing.List[str]',),
        "QSessionManager.setManagerProperty": [('str', 'str'), ('str', 'typing.List[str]')],
        "QSessionManager.setRestartCommand": ('typing.List[str]',),
        "QSessionManager.setRestartHint": ('PySide2.QtGui.QSessionManager.RestartHint',),

    # class PySide2.QtGui.QShortcutEvent:
        "QShortcutEvent.__init__": ('PySide2.QtGui.QKeySequence', 'int', 'bool'),
        "QShortcutEvent.isAmbiguous": (),
        "QShortcutEvent.key": (),
        "QShortcutEvent.shortcutId": (),

    # class PySide2.QtGui.QShowEvent:
        "QShowEvent.__init__": (),

    # class PySide2.QtGui.QStandardItem:
        "QStandardItem.__init__": [(), ('PySide2.QtGui.QIcon', 'str'), ('PySide2.QtGui.QStandardItem',), ('int', 'int'), ('str',)],
        "QStandardItem.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QStandardItem.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QStandardItem.accessibleDescription": (),
        "QStandardItem.accessibleText": (),
        "QStandardItem.appendColumn": ('list',),
        "QStandardItem.appendRow": [('PySide2.QtGui.QStandardItem',), ('list',)],
        "QStandardItem.appendRows": ('list',),
        "QStandardItem.background": (),
        "QStandardItem.checkState": (),
        "QStandardItem.child": ('int', 'int'),
        "QStandardItem.clearData": (),
        "QStandardItem.clone": (),
        "QStandardItem.column": (),
        "QStandardItem.columnCount": (),
        "QStandardItem.data": ('int',),
        "QStandardItem.emitDataChanged": (),
        "QStandardItem.flags": (),
        "QStandardItem.font": (),
        "QStandardItem.foreground": (),
        "QStandardItem.hasChildren": (),
        "QStandardItem.icon": (),
        "QStandardItem.index": (),
        "QStandardItem.insertColumn": ('int', 'list'),
        "QStandardItem.insertColumns": ('int', 'int'),
        "QStandardItem.insertRow": [('int', 'PySide2.QtGui.QStandardItem'), ('int', 'list')],
        "QStandardItem.insertRows": [('int', 'int'), ('int', 'list')],
        "QStandardItem.isAutoTristate": (),
        "QStandardItem.isCheckable": (),
        "QStandardItem.isDragEnabled": (),
        "QStandardItem.isDropEnabled": (),
        "QStandardItem.isEditable": (),
        "QStandardItem.isEnabled": (),
        "QStandardItem.isSelectable": (),
        "QStandardItem.isTristate": (),
        "QStandardItem.isUserTristate": (),
        "QStandardItem.model": (),
        "QStandardItem.parent": (),
        "QStandardItem.read": ('PySide2.QtCore.QDataStream',),
        "QStandardItem.removeColumn": ('int',),
        "QStandardItem.removeColumns": ('int', 'int'),
        "QStandardItem.removeRow": ('int',),
        "QStandardItem.removeRows": ('int', 'int'),
        "QStandardItem.row": (),
        "QStandardItem.rowCount": (),
        "QStandardItem.setAccessibleDescription": ('str',),
        "QStandardItem.setAccessibleText": ('str',),
        "QStandardItem.setAutoTristate": ('bool',),
        "QStandardItem.setBackground": ('PySide2.QtGui.QBrush',),
        "QStandardItem.setCheckState": ('PySide2.QtCore.Qt.CheckState',),
        "QStandardItem.setCheckable": ('bool',),
        "QStandardItem.setChild": [('int', 'PySide2.QtGui.QStandardItem'), ('int', 'int', 'PySide2.QtGui.QStandardItem')],
        "QStandardItem.setColumnCount": ('int',),
        "QStandardItem.setData": ('typing.Any', 'int'),
        "QStandardItem.setDragEnabled": ('bool',),
        "QStandardItem.setDropEnabled": ('bool',),
        "QStandardItem.setEditable": ('bool',),
        "QStandardItem.setEnabled": ('bool',),
        "QStandardItem.setFlags": ('PySide2.QtCore.Qt.ItemFlags',),
        "QStandardItem.setFont": ('PySide2.QtGui.QFont',),
        "QStandardItem.setForeground": ('PySide2.QtGui.QBrush',),
        "QStandardItem.setIcon": ('PySide2.QtGui.QIcon',),
        "QStandardItem.setRowCount": ('int',),
        "QStandardItem.setSelectable": ('bool',),
        "QStandardItem.setSizeHint": ('PySide2.QtCore.QSize',),
        "QStandardItem.setStatusTip": ('str',),
        "QStandardItem.setText": ('str',),
        "QStandardItem.setTextAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QStandardItem.setToolTip": ('str',),
        "QStandardItem.setTristate": ('bool',),
        "QStandardItem.setUserTristate": ('bool',),
        "QStandardItem.setWhatsThis": ('str',),
        "QStandardItem.sizeHint": (),
        "QStandardItem.sortChildren": ('int', 'PySide2.QtCore.Qt.SortOrder'),
        "QStandardItem.statusTip": (),
        "QStandardItem.takeChild": ('int', 'int'),
        "QStandardItem.takeColumn": ('int',),
        "QStandardItem.takeRow": ('int',),
        "QStandardItem.text": (),
        "QStandardItem.textAlignment": (),
        "QStandardItem.toolTip": (),
        "QStandardItem.type": (),
        "QStandardItem.whatsThis": (),
        "QStandardItem.write": ('PySide2.QtCore.QDataStream',),

    # class PySide2.QtGui.QStandardItemModel:
        "QStandardItemModel.__init__": [('PySide2.QtCore.QObject',), ('int', 'int', 'PySide2.QtCore.QObject')],
        "QStandardItemModel.appendColumn": ('list',),
        "QStandardItemModel.appendRow": [('PySide2.QtGui.QStandardItem',), ('list',)],
        "QStandardItemModel.clear": (),
        "QStandardItemModel.clearItemData": ('PySide2.QtCore.QModelIndex',),
        "QStandardItemModel.columnCount": ('PySide2.QtCore.QModelIndex',),
        "QStandardItemModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
        "QStandardItemModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QStandardItemModel.findItems": ('str', 'PySide2.QtCore.Qt.MatchFlags', 'int'),
        "QStandardItemModel.flags": ('PySide2.QtCore.QModelIndex',),
        "QStandardItemModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
        "QStandardItemModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
        "QStandardItemModel.horizontalHeaderItem": ('int',),
        "QStandardItemModel.index": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QStandardItemModel.indexFromItem": ('PySide2.QtGui.QStandardItem',),
        "QStandardItemModel.insertColumn": [('int', 'PySide2.QtCore.QModelIndex'), ('int', 'list')],
        "QStandardItemModel.insertColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QStandardItemModel.insertRow": [('int', 'PySide2.QtCore.QModelIndex'), ('int', 'PySide2.QtGui.QStandardItem'), ('int', 'list')],
        "QStandardItemModel.insertRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QStandardItemModel.invisibleRootItem": (),
        "QStandardItemModel.item": ('int', 'int'),
        "QStandardItemModel.itemData": ('PySide2.QtCore.QModelIndex',),
        "QStandardItemModel.itemFromIndex": ('PySide2.QtCore.QModelIndex',),
        "QStandardItemModel.itemPrototype": (),
        "QStandardItemModel.mimeData": ('typing.List[int]',),
        "QStandardItemModel.mimeTypes": (),
        "QStandardItemModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
        "QStandardItemModel.removeColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QStandardItemModel.removeRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QStandardItemModel.rowCount": ('PySide2.QtCore.QModelIndex',),
        "QStandardItemModel.setColumnCount": ('int',),
        "QStandardItemModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
        "QStandardItemModel.setHeaderData": ('int', 'PySide2.QtCore.Qt.Orientation', 'typing.Any', 'int'),
        "QStandardItemModel.setHorizontalHeaderItem": ('int', 'PySide2.QtGui.QStandardItem'),
        "QStandardItemModel.setHorizontalHeaderLabels": ('typing.List[str]',),
        "QStandardItemModel.setItem": [('int', 'PySide2.QtGui.QStandardItem'), ('int', 'int', 'PySide2.QtGui.QStandardItem')],
        "QStandardItemModel.setItemData": ('PySide2.QtCore.QModelIndex', 'dict'),
        "QStandardItemModel.setItemPrototype": ('PySide2.QtGui.QStandardItem',),
        "QStandardItemModel.setItemRoleNames": ('dict',),
        "QStandardItemModel.setRowCount": ('int',),
        "QStandardItemModel.setSortRole": ('int',),
        "QStandardItemModel.setVerticalHeaderItem": ('int', 'PySide2.QtGui.QStandardItem'),
        "QStandardItemModel.setVerticalHeaderLabels": ('typing.List[str]',),
        "QStandardItemModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QStandardItemModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
        "QStandardItemModel.sortRole": (),
        "QStandardItemModel.supportedDropActions": (),
        "QStandardItemModel.takeColumn": ('int',),
        "QStandardItemModel.takeHorizontalHeaderItem": ('int',),
        "QStandardItemModel.takeItem": ('int', 'int'),
        "QStandardItemModel.takeRow": ('int',),
        "QStandardItemModel.takeVerticalHeaderItem": ('int',),
        "QStandardItemModel.verticalHeaderItem": ('int',),

    # class PySide2.QtGui.QStaticText:
        "QStaticText.__init__": [(), ('PySide2.QtGui.QStaticText',), ('str',)],
        "QStaticText.__copy__": (),
        "QStaticText.performanceHint": (),
        "QStaticText.prepare": ('PySide2.QtGui.QTransform', 'PySide2.QtGui.QFont'),
        "QStaticText.setPerformanceHint": ('PySide2.QtGui.QStaticText.PerformanceHint',),
        "QStaticText.setText": ('str',),
        "QStaticText.setTextFormat": ('PySide2.QtCore.Qt.TextFormat',),
        "QStaticText.setTextOption": ('PySide2.QtGui.QTextOption',),
        "QStaticText.setTextWidth": ('float',),
        "QStaticText.size": (),
        "QStaticText.swap": ('PySide2.QtGui.QStaticText',),
        "QStaticText.text": (),
        "QStaticText.textFormat": (),
        "QStaticText.textOption": (),
        "QStaticText.textWidth": (),

    # class PySide2.QtGui.QStatusTipEvent:
        "QStatusTipEvent.__init__": ('str',),
        "QStatusTipEvent.tip": (),

    # class PySide2.QtGui.QStyleHints:
        "QStyleHints.cursorFlashTime": (),
        "QStyleHints.fontSmoothingGamma": (),
        "QStyleHints.keyboardAutoRepeatRate": (),
        "QStyleHints.keyboardInputInterval": (),
        "QStyleHints.mouseDoubleClickInterval": (),
        "QStyleHints.mousePressAndHoldInterval": (),
        "QStyleHints.mouseQuickSelectionThreshold": (),
        "QStyleHints.passwordMaskCharacter": (),
        "QStyleHints.passwordMaskDelay": (),
        "QStyleHints.setCursorFlashTime": ('int',),
        "QStyleHints.setFocusOnTouchRelease": (),
        "QStyleHints.setKeyboardInputInterval": ('int',),
        "QStyleHints.setMouseDoubleClickInterval": ('int',),
        "QStyleHints.setMousePressAndHoldInterval": ('int',),
        "QStyleHints.setMouseQuickSelectionThreshold": ('int',),
        "QStyleHints.setStartDragDistance": ('int',),
        "QStyleHints.setStartDragTime": ('int',),
        "QStyleHints.setTabFocusBehavior": ('PySide2.QtCore.Qt.TabFocusBehavior',),
        "QStyleHints.setUseHoverEffects": ('bool',),
        "QStyleHints.setWheelScrollLines": ('int',),
        "QStyleHints.showIsFullScreen": (),
        "QStyleHints.showIsMaximized": (),
        "QStyleHints.showShortcutsInContextMenus": (),
        "QStyleHints.singleClickActivation": (),
        "QStyleHints.startDragDistance": (),
        "QStyleHints.startDragTime": (),
        "QStyleHints.startDragVelocity": (),
        "QStyleHints.tabFocusBehavior": (),
        "QStyleHints.useHoverEffects": (),
        "QStyleHints.useRtlExtensions": (),
        "QStyleHints.wheelScrollLines": (),

    # class PySide2.QtGui.QSurface:
        "QSurface.__init__": ('PySide2.QtGui.QSurface.SurfaceClass',),
        "QSurface.format": (),
        "QSurface.size": (),
        "QSurface.supportsOpenGL": (),
        "QSurface.surfaceClass": (),
        "QSurface.surfaceHandle": (),
        "QSurface.surfaceType": (),

    # class PySide2.QtGui.QSurfaceFormat:
        "QSurfaceFormat.__init__": [(), ('PySide2.QtGui.QSurfaceFormat',), ('PySide2.QtGui.QSurfaceFormat.FormatOptions',)],
        "QSurfaceFormat.__copy__": (),
        "QSurfaceFormat.alphaBufferSize": (),
        "QSurfaceFormat.blueBufferSize": (),
        "QSurfaceFormat.colorSpace": (),
        "QSurfaceFormat.defaultFormat": (),
        "QSurfaceFormat.depthBufferSize": (),
        "QSurfaceFormat.greenBufferSize": (),
        "QSurfaceFormat.hasAlpha": (),
        "QSurfaceFormat.majorVersion": (),
        "QSurfaceFormat.minorVersion": (),
        "QSurfaceFormat.options": (),
        "QSurfaceFormat.profile": (),
        "QSurfaceFormat.redBufferSize": (),
        "QSurfaceFormat.renderableType": (),
        "QSurfaceFormat.samples": (),
        "QSurfaceFormat.setAlphaBufferSize": ('int',),
        "QSurfaceFormat.setBlueBufferSize": ('int',),
        "QSurfaceFormat.setColorSpace": ('PySide2.QtGui.QSurfaceFormat.ColorSpace',),
        "QSurfaceFormat.setDefaultFormat": ('PySide2.QtGui.QSurfaceFormat',),
        "QSurfaceFormat.setDepthBufferSize": ('int',),
        "QSurfaceFormat.setGreenBufferSize": ('int',),
        "QSurfaceFormat.setMajorVersion": ('int',),
        "QSurfaceFormat.setMinorVersion": ('int',),
        "QSurfaceFormat.setOption": [('PySide2.QtGui.QSurfaceFormat.FormatOption', 'bool'), ('PySide2.QtGui.QSurfaceFormat.FormatOptions',)],
        "QSurfaceFormat.setOptions": ('PySide2.QtGui.QSurfaceFormat.FormatOptions',),
        "QSurfaceFormat.setProfile": ('PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile',),
        "QSurfaceFormat.setRedBufferSize": ('int',),
        "QSurfaceFormat.setRenderableType": ('PySide2.QtGui.QSurfaceFormat.RenderableType',),
        "QSurfaceFormat.setSamples": ('int',),
        "QSurfaceFormat.setStencilBufferSize": ('int',),
        "QSurfaceFormat.setStereo": ('bool',),
        "QSurfaceFormat.setSwapBehavior": ('PySide2.QtGui.QSurfaceFormat.SwapBehavior',),
        "QSurfaceFormat.setSwapInterval": ('int',),
        "QSurfaceFormat.setVersion": ('int', 'int'),
        "QSurfaceFormat.stencilBufferSize": (),
        "QSurfaceFormat.stereo": (),
        "QSurfaceFormat.swapBehavior": (),
        "QSurfaceFormat.swapInterval": (),
        "QSurfaceFormat.testOption": [('PySide2.QtGui.QSurfaceFormat.FormatOption',), ('PySide2.QtGui.QSurfaceFormat.FormatOptions',)],
        "QSurfaceFormat.version": (),

    # class PySide2.QtGui.QSyntaxHighlighter:
        "QSyntaxHighlighter.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtGui.QTextDocument',)],
        "QSyntaxHighlighter.currentBlock": (),
        "QSyntaxHighlighter.currentBlockState": (),
        "QSyntaxHighlighter.currentBlockUserData": (),
        "QSyntaxHighlighter.document": (),
        "QSyntaxHighlighter.format": ('int',),
        "QSyntaxHighlighter.highlightBlock": ('str',),
        "QSyntaxHighlighter.previousBlockState": (),
        "QSyntaxHighlighter.rehighlight": (),
        "QSyntaxHighlighter.rehighlightBlock": ('PySide2.QtGui.QTextBlock',),
        "QSyntaxHighlighter.setCurrentBlockState": ('int',),
        "QSyntaxHighlighter.setCurrentBlockUserData": ('PySide2.QtGui.QTextBlockUserData',),
        "QSyntaxHighlighter.setDocument": ('PySide2.QtGui.QTextDocument',),
        "QSyntaxHighlighter.setFormat": [('int', 'int', 'PySide2.QtGui.QColor'), ('int', 'int', 'PySide2.QtGui.QFont'), ('int', 'int', 'PySide2.QtGui.QTextCharFormat')],

    # class PySide2.QtGui.QTabletEvent:
        "QTabletEvent.__init__": [('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'int', 'int', 'float', 'int', 'int', 'float', 'float', 'int', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'int', 'int', 'float', 'int', 'int', 'float', 'float', 'int', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.MouseButtons')],
        "QTabletEvent.button": (),
        "QTabletEvent.buttons": (),
        "QTabletEvent.device": (),
        "QTabletEvent.globalPos": (),
        "QTabletEvent.globalPosF": (),
        "QTabletEvent.globalX": (),
        "QTabletEvent.global""Y": (),
        "QTabletEvent.hiResGlobalX": (),
        "QTabletEvent.hiResGlobal""Y": (),
        "QTabletEvent.pointerType": (),
        "QTabletEvent.pos": (),
        "QTabletEvent.posF": (),
        "QTabletEvent.pressure": (),
        "QTabletEvent.rotation": (),
        "QTabletEvent.tangentialPressure": (),
        "QTabletEvent.uniqueId": (),
        "QTabletEvent.x": (),
        "QTabletEvent.xTilt": (),
        "QTabletEvent.y": (),
        "QTabletEvent.yTilt": (),
        "QTabletEvent.z": (),

    # class PySide2.QtGui.QTextBlock:
        "QTextBlock.__init__": [(), ('PySide2.QtGui.QTextBlock',)],
        "QTextBlock.__copy__": (),
        "QTextBlock.__iter__": (),
        "QTextBlock.begin": (),
        "QTextBlock.blockFormat": (),
        "QTextBlock.blockFormatIndex": (),
        "QTextBlock.blockNumber": (),
        "QTextBlock.charFormat": (),
        "QTextBlock.charFormatIndex": (),
        "QTextBlock.clearLayout": (),
        "QTextBlock.contains": ('int',),
        "QTextBlock.document": (),
        "QTextBlock.end": (),
        "QTextBlock.firstLineNumber": (),
        "QTextBlock.fragmentIndex": (),
        "QTextBlock.isValid": (),
        "QTextBlock.isVisible": (),
        "QTextBlock.layout": (),
        "QTextBlock.length": (),
        "QTextBlock.lineCount": (),
        "QTextBlock.position": (),
        "QTextBlock.previous": (),
        "QTextBlock.revision": (),
        "QTextBlock.setLineCount": ('int',),
        "QTextBlock.setRevision": ('int',),
        "QTextBlock.setUserData": ('PySide2.QtGui.QTextBlockUserData',),
        "QTextBlock.setUserState": ('int',),
        "QTextBlock.setVisible": ('bool',),
        "QTextBlock.text": (),
        "QTextBlock.textDirection": (),
        "QTextBlock.textFormats": (),
        "QTextBlock.textList": (),
        "QTextBlock.userData": (),
        "QTextBlock.userState": (),

    # class PySide2.QtGui.QTextBlock.iterator:
        "QTextBlock.iterator.__init__": [(), ('PySide2.QtGui.QTextBlock.iterator',)],
        "QTextBlock.iterator.__copy__": (),
        "QTextBlock.iterator.__iadd__": ('int',),
        "QTextBlock.iterator.__isub__": ('int',),
        "QTextBlock.iterator.__iter__": (),
        "QTextBlock.iterator.atEnd": (),
        "QTextBlock.iterator.fragment": (),

    # class PySide2.QtGui.QTextBlockFormat:
        "QTextBlockFormat.__init__": [(), ('PySide2.QtGui.QTextBlockFormat',), ('PySide2.QtGui.QTextFormat',)],
        "QTextBlockFormat.__copy__": (),
        "QTextBlockFormat.alignment": (),
        "QTextBlockFormat.bottomMargin": (),
        "QTextBlockFormat.headingLevel": (),
        "QTextBlockFormat.indent": (),
        "QTextBlockFormat.isValid": (),
        "QTextBlockFormat.leftMargin": (),
        "QTextBlockFormat.lineHeight": [(), ('float', 'float')],
        "QTextBlockFormat.lineHeightType": (),
        "QTextBlockFormat.nonBreakableLines": (),
        "QTextBlockFormat.pageBreakPolicy": (),
        "QTextBlockFormat.rightMargin": (),
        "QTextBlockFormat.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QTextBlockFormat.setBottomMargin": ('float',),
        "QTextBlockFormat.setHeadingLevel": ('int',),
        "QTextBlockFormat.setIndent": ('int',),
        "QTextBlockFormat.setLeftMargin": ('float',),
        "QTextBlockFormat.setLineHeight": ('float', 'int'),
        "QTextBlockFormat.setNonBreakableLines": ('bool',),
        "QTextBlockFormat.setPageBreakPolicy": ('PySide2.QtGui.QTextFormat.PageBreakFlags',),
        "QTextBlockFormat.setRightMargin": ('float',),
        "QTextBlockFormat.setTabPositions": ('list',),
        "QTextBlockFormat.setTextIndent": ('float',),
        "QTextBlockFormat.setTopMargin": ('float',),
        "QTextBlockFormat.tabPositions": (),
        "QTextBlockFormat.textIndent": (),
        "QTextBlockFormat.topMargin": (),

    # class PySide2.QtGui.QTextBlockGroup:
        "QTextBlockGroup.__init__": ('PySide2.QtGui.QTextDocument',),
        "QTextBlockGroup.blockFormatChanged": ('PySide2.QtGui.QTextBlock',),
        "QTextBlockGroup.blockInserted": ('PySide2.QtGui.QTextBlock',),
        "QTextBlockGroup.blockList": (),
        "QTextBlockGroup.blockRemoved": ('PySide2.QtGui.QTextBlock',),

    # class PySide2.QtGui.QTextBlockUserData:
        "QTextBlockUserData.__init__": (),

    # class PySide2.QtGui.QTextCharFormat:
        "QTextCharFormat.__init__": [(), ('PySide2.QtGui.QTextCharFormat',), ('PySide2.QtGui.QTextFormat',)],
        "QTextCharFormat.__copy__": (),
        "QTextCharFormat.anchorHref": (),
        "QTextCharFormat.anchorName": (),
        "QTextCharFormat.anchorNames": (),
        "QTextCharFormat.font": (),
        "QTextCharFormat.fontCapitalization": (),
        "QTextCharFormat.fontFamily": (),
        "QTextCharFormat.fontFixedPitch": (),
        "QTextCharFormat.fontHintingPreference": (),
        "QTextCharFormat.fontItalic": (),
        "QTextCharFormat.fontKerning": (),
        "QTextCharFormat.fontLetterSpacing": (),
        "QTextCharFormat.fontLetterSpacingType": (),
        "QTextCharFormat.fontOverline": (),
        "QTextCharFormat.fontPointSize": (),
        "QTextCharFormat.fontStretch": (),
        "QTextCharFormat.fontStrikeOut": (),
        "QTextCharFormat.fontStyleHint": (),
        "QTextCharFormat.fontStyleStrategy": (),
        "QTextCharFormat.fontUnderline": (),
        "QTextCharFormat.fontWeight": (),
        "QTextCharFormat.fontWordSpacing": (),
        "QTextCharFormat.isAnchor": (),
        "QTextCharFormat.isValid": (),
        "QTextCharFormat.setAnchor": ('bool',),
        "QTextCharFormat.setAnchorHref": ('str',),
        "QTextCharFormat.setAnchorName": ('str',),
        "QTextCharFormat.setAnchorNames": ('typing.List[str]',),
        "QTextCharFormat.setFont": [('PySide2.QtGui.QFont',), ('PySide2.QtGui.QFont', 'PySide2.QtGui.QTextCharFormat.FontPropertiesInheritanceBehavior')],
        "QTextCharFormat.setFontCapitalization": ('PySide2.QtGui.QFont.Capitalization',),
        "QTextCharFormat.setFontFamily": ('str',),
        "QTextCharFormat.setFontFixedPitch": ('bool',),
        "QTextCharFormat.setFontHintingPreference": ('PySide2.QtGui.QFont.HintingPreference',),
        "QTextCharFormat.setFontItalic": ('bool',),
        "QTextCharFormat.setFontKerning": ('bool',),
        "QTextCharFormat.setFontLetterSpacing": ('float',),
        "QTextCharFormat.setFontLetterSpacingType": ('PySide2.QtGui.QFont.SpacingType',),
        "QTextCharFormat.setFontOverline": ('bool',),
        "QTextCharFormat.setFontPointSize": ('float',),
        "QTextCharFormat.setFontStretch": ('int',),
        "QTextCharFormat.setFontStrikeOut": ('bool',),
        "QTextCharFormat.setFontStyleHint": ('PySide2.QtGui.QFont.StyleHint', 'PySide2.QtGui.QFont.StyleStrategy'),
        "QTextCharFormat.setFontStyleStrategy": ('PySide2.QtGui.QFont.StyleStrategy',),
        "QTextCharFormat.setFontUnderline": ('bool',),
        "QTextCharFormat.setFontWeight": ('int',),
        "QTextCharFormat.setFontWordSpacing": ('float',),
        "QTextCharFormat.setTableCellColumnSpan": ('int',),
        "QTextCharFormat.setTableCellRowSpan": ('int',),
        "QTextCharFormat.setTextOutline": ('PySide2.QtGui.QPen',),
        "QTextCharFormat.setToolTip": ('str',),
        "QTextCharFormat.setUnderlineColor": ('PySide2.QtGui.QColor',),
        "QTextCharFormat.setUnderlineStyle": ('PySide2.QtGui.QTextCharFormat.UnderlineStyle',),
        "QTextCharFormat.setVerticalAlignment": ('PySide2.QtGui.QTextCharFormat.VerticalAlignment',),
        "QTextCharFormat.tableCellColumnSpan": (),
        "QTextCharFormat.tableCellRowSpan": (),
        "QTextCharFormat.textOutline": (),
        "QTextCharFormat.toolTip": (),
        "QTextCharFormat.underlineColor": (),
        "QTextCharFormat.underlineStyle": (),
        "QTextCharFormat.verticalAlignment": (),

    # class PySide2.QtGui.QTextCursor:
        "QTextCursor.__init__": [(), ('PySide2.QtGui.QTextBlock',), ('PySide2.QtGui.QTextCursor',), ('PySide2.QtGui.QTextDocument',), ('PySide2.QtGui.QTextFrame',)],
        "QTextCursor.__copy__": (),
        "QTextCursor.anchor": (),
        "QTextCursor.atBlockEnd": (),
        "QTextCursor.atBlockStart": (),
        "QTextCursor.atEnd": (),
        "QTextCursor.atStart": (),
        "QTextCursor.beginEditBlock": (),
        "QTextCursor.block": (),
        "QTextCursor.blockCharFormat": (),
        "QTextCursor.blockFormat": (),
        "QTextCursor.blockNumber": (),
        "QTextCursor.charFormat": (),
        "QTextCursor.clearSelection": (),
        "QTextCursor.columnNumber": (),
        "QTextCursor.createList": [('PySide2.QtGui.QTextListFormat',), ('PySide2.QtGui.QTextListFormat.Style',)],
        "QTextCursor.currentFrame": (),
        "QTextCursor.currentList": (),
        "QTextCursor.currentTable": (),
        "QTextCursor.deleteChar": (),
        "QTextCursor.deletePreviousChar": (),
        "QTextCursor.document": (),
        "QTextCursor.endEditBlock": (),
        "QTextCursor.hasComplexSelection": (),
        "QTextCursor.hasSelection": (),
        "QTextCursor.insertBlock": [(), ('PySide2.QtGui.QTextBlockFormat',), ('PySide2.QtGui.QTextBlockFormat', 'PySide2.QtGui.QTextCharFormat')],
        "QTextCursor.insertFragment": ('PySide2.QtGui.QTextDocumentFragment',),
        "QTextCursor.insertFrame": ('PySide2.QtGui.QTextFrameFormat',),
        "QTextCursor.insertHtml": ('str',),
        "QTextCursor.insertImage": [('PySide2.QtGui.QImage', 'str'), ('PySide2.QtGui.QTextImageFormat',), ('PySide2.QtGui.QTextImageFormat', 'PySide2.QtGui.QTextFrameFormat.Position'), ('str',)],
        "QTextCursor.insertList": [('PySide2.QtGui.QTextListFormat',), ('PySide2.QtGui.QTextListFormat.Style',)],
        "QTextCursor.insertTable": [('int', 'int'), ('int', 'int', 'PySide2.QtGui.QTextTableFormat')],
        "QTextCursor.insertText": [('str',), ('str', 'PySide2.QtGui.QTextCharFormat')],
        "QTextCursor.isCopyOf": ('PySide2.QtGui.QTextCursor',),
        "QTextCursor.isNull": (),
        "QTextCursor.joinPreviousEditBlock": (),
        "QTextCursor.keepPositionOnInsert": (),
        "QTextCursor.mergeBlockCharFormat": ('PySide2.QtGui.QTextCharFormat',),
        "QTextCursor.mergeBlockFormat": ('PySide2.QtGui.QTextBlockFormat',),
        "QTextCursor.mergeCharFormat": ('PySide2.QtGui.QTextCharFormat',),
        "QTextCursor.movePosition": ('PySide2.QtGui.QTextCursor.MoveOperation', 'PySide2.QtGui.QTextCursor.MoveMode', 'int'),
        "QTextCursor.position": (),
        "QTextCursor.positionInBlock": (),
        "QTextCursor.removeSelectedText": (),
        "QTextCursor.select": ('PySide2.QtGui.QTextCursor.SelectionType',),
        "QTextCursor.selectedTableCells": ('int', 'int', 'int', 'int'),
        "QTextCursor.selectedText": (),
        "QTextCursor.selection": (),
        "QTextCursor.selectionEnd": (),
        "QTextCursor.selectionStart": (),
        "QTextCursor.setBlockCharFormat": ('PySide2.QtGui.QTextCharFormat',),
        "QTextCursor.setBlockFormat": ('PySide2.QtGui.QTextBlockFormat',),
        "QTextCursor.setCharFormat": ('PySide2.QtGui.QTextCharFormat',),
        "QTextCursor.setKeepPositionOnInsert": ('bool',),
        "QTextCursor.setPosition": ('int', 'PySide2.QtGui.QTextCursor.MoveMode'),
        "QTextCursor.setVerticalMovementX": ('int',),
        "QTextCursor.setVisualNavigation": ('bool',),
        "QTextCursor.swap": ('PySide2.QtGui.QTextCursor',),
        "QTextCursor.verticalMovementX": (),
        "QTextCursor.visualNavigation": (),

    # class PySide2.QtGui.QTextDocument:
        "QTextDocument.__init__": [('PySide2.QtCore.QObject',), ('str', 'PySide2.QtCore.QObject')],
        "QTextDocument.addResource": ('int', 'PySide2.QtCore.QUrl', 'typing.Any'),
        "QTextDocument.adjustSize": (),
        "QTextDocument.allFormats": (),
        "QTextDocument.availableRedoSteps": (),
        "QTextDocument.availableUndoSteps": (),
        "QTextDocument.baseUrl": (),
        "QTextDocument.begin": (),
        "QTextDocument.blockCount": (),
        "QTextDocument.characterAt": ('int',),
        "QTextDocument.characterCount": (),
        "QTextDocument.clear": (),
        "QTextDocument.clearUndoRedoStacks": ('PySide2.QtGui.QTextDocument.Stacks',),
        "QTextDocument.clone": ('PySide2.QtCore.QObject',),
        "QTextDocument.createObject": ('PySide2.QtGui.QTextFormat',),
        "QTextDocument.defaultCursorMoveStyle": (),
        "QTextDocument.defaultFont": (),
        "QTextDocument.defaultStyleSheet": (),
        "QTextDocument.defaultTextOption": (),
        "QTextDocument.documentLayout": (),
        "QTextDocument.documentMargin": (),
        "QTextDocument.drawContents": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF'),
        "QTextDocument.end": (),
        "QTextDocument.find": [('PySide2.QtCore.QRegExp', 'PySide2.QtGui.QTextCursor', 'PySide2.QtGui.QTextDocument.FindFlags'), ('PySide2.QtCore.QRegExp', 'int', 'PySide2.QtGui.QTextDocument.FindFlags'), ('PySide2.QtCore.QRegularExpression', 'PySide2.QtGui.QTextCursor', 'PySide2.QtGui.QTextDocument.FindFlags'), ('PySide2.QtCore.QRegularExpression', 'int', 'PySide2.QtGui.QTextDocument.FindFlags'), ('str', 'PySide2.QtGui.QTextCursor', 'PySide2.QtGui.QTextDocument.FindFlags'), ('str', 'int', 'PySide2.QtGui.QTextDocument.FindFlags')],
        "QTextDocument.findBlock": ('int',),
        "QTextDocument.findBlockByLineNumber": ('int',),
        "QTextDocument.findBlockByNumber": ('int',),
        "QTextDocument.firstBlock": (),
        "QTextDocument.frameAt": ('int',),
        "QTextDocument.idealWidth": (),
        "QTextDocument.indentWidth": (),
        "QTextDocument.isEmpty": (),
        "QTextDocument.isModified": (),
        "QTextDocument.isRedoAvailable": (),
        "QTextDocument.isUndoAvailable": (),
        "QTextDocument.isUndoRedoEnabled": (),
        "QTextDocument.lastBlock": (),
        "QTextDocument.lineCount": (),
        "QTextDocument.loadResource": ('int', 'PySide2.QtCore.QUrl'),
        "QTextDocument.markContentsDirty": ('int', 'int'),
        "QTextDocument.maximumBlockCount": (),
        "QTextDocument.metaInformation": ('PySide2.QtGui.QTextDocument.MetaInformation',),
        "QTextDocument.object": ('int',),
        "QTextDocument.objectForFormat": ('PySide2.QtGui.QTextFormat',),
        "QTextDocument.pageCount": (),
        "QTextDocument.pageSize": (),
        "QTextDocument.print_": ('PySide2.QtGui.QPagedPaintDevice',),
        "QTextDocument.redo": [(), ('PySide2.QtGui.QTextCursor',)],
        "QTextDocument.resource": ('int', 'PySide2.QtCore.QUrl'),
        "QTextDocument.revision": (),
        "QTextDocument.rootFrame": (),
        "QTextDocument.setBaseUrl": ('PySide2.QtCore.QUrl',),
        "QTextDocument.setDefaultCursorMoveStyle": ('PySide2.QtCore.Qt.CursorMoveStyle',),
        "QTextDocument.setDefaultFont": ('PySide2.QtGui.QFont',),
        "QTextDocument.setDefaultStyleSheet": ('str',),
        "QTextDocument.setDefaultTextOption": ('PySide2.QtGui.QTextOption',),
        "QTextDocument.setDocumentLayout": ('PySide2.QtGui.QAbstractTextDocumentLayout',),
        "QTextDocument.setDocumentMargin": ('float',),
        "QTextDocument.setHtml": ('str',),
        "QTextDocument.setIndentWidth": ('float',),
        "QTextDocument.setMaximumBlockCount": ('int',),
        "QTextDocument.setMetaInformation": ('PySide2.QtGui.QTextDocument.MetaInformation', 'str'),
        "QTextDocument.setModified": ('bool',),
        "QTextDocument.setPageSize": ('PySide2.QtCore.QSizeF',),
        "QTextDocument.setPlainText": ('str',),
        "QTextDocument.setTextWidth": ('float',),
        "QTextDocument.setUndoRedoEnabled": ('bool',),
        "QTextDocument.setUseDesignMetrics": ('bool',),
        "QTextDocument.size": (),
        "QTextDocument.textWidth": (),
        "QTextDocument.toHtml": ('PySide2.QtCore.QByteArray',),
        "QTextDocument.toPlainText": (),
        "QTextDocument.toRawText": (),
        "QTextDocument.undo": [(), ('PySide2.QtGui.QTextCursor',)],
        "QTextDocument.useDesignMetrics": (),

    # class PySide2.QtGui.QTextDocumentFragment:
        "QTextDocumentFragment.__init__": [(), ('PySide2.QtGui.QTextCursor',), ('PySide2.QtGui.QTextDocument',), ('PySide2.QtGui.QTextDocumentFragment',)],
        "QTextDocumentFragment.__copy__": (),
        "QTextDocumentFragment.fromHtml": [('str',), ('str', 'PySide2.QtGui.QTextDocument')],
        "QTextDocumentFragment.fromPlainText": ('str',),
        "QTextDocumentFragment.isEmpty": (),
        "QTextDocumentFragment.toHtml": ('PySide2.QtCore.QByteArray',),
        "QTextDocumentFragment.toPlainText": (),

    # class PySide2.QtGui.QTextDocumentWriter:
        "QTextDocumentWriter.__init__": [(), ('PySide2.QtCore.QIODevice', 'PySide2.QtCore.QByteArray'), ('str', 'PySide2.QtCore.QByteArray')],
        "QTextDocumentWriter.codec": (),
        "QTextDocumentWriter.device": (),
        "QTextDocumentWriter.fileName": (),
        "QTextDocumentWriter.format": (),
        "QTextDocumentWriter.setCodec": ('PySide2.QtCore.QTextCodec',),
        "QTextDocumentWriter.setDevice": ('PySide2.QtCore.QIODevice',),
        "QTextDocumentWriter.setFileName": ('str',),
        "QTextDocumentWriter.setFormat": ('PySide2.QtCore.QByteArray',),
        "QTextDocumentWriter.supportedDocumentFormats": (),
        "QTextDocumentWriter.write": [('PySide2.QtGui.QTextDocument',), ('PySide2.QtGui.QTextDocumentFragment',)],

    # class PySide2.QtGui.QTextFormat:
        "QTextFormat.__init__": [(), ('PySide2.QtGui.QTextFormat',), ('int',)],
        "QTextFormat.__copy__": (),
        "QTextFormat.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QTextFormat.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QTextFormat.background": (),
        "QTextFormat.boolProperty": ('int',),
        "QTextFormat.brushProperty": ('int',),
        "QTextFormat.clearBackground": (),
        "QTextFormat.clearForeground": (),
        "QTextFormat.clearProperty": ('int',),
        "QTextFormat.colorProperty": ('int',),
        "QTextFormat.doubleProperty": ('int',),
        "QTextFormat.foreground": (),
        "QTextFormat.hasProperty": ('int',),
        "QTextFormat.intProperty": ('int',),
        "QTextFormat.isBlockFormat": (),
        "QTextFormat.isCharFormat": (),
        "QTextFormat.isEmpty": (),
        "QTextFormat.isFrameFormat": (),
        "QTextFormat.isImageFormat": (),
        "QTextFormat.isListFormat": (),
        "QTextFormat.isTableCellFormat": (),
        "QTextFormat.isTableFormat": (),
        "QTextFormat.isValid": (),
        "QTextFormat.layoutDirection": (),
        "QTextFormat.lengthProperty": ('int',),
        "QTextFormat.lengthVectorProperty": ('int',),
        "QTextFormat.merge": ('PySide2.QtGui.QTextFormat',),
        "QTextFormat.objectIndex": (),
        "QTextFormat.objectType": (),
        "QTextFormat.penProperty": ('int',),
        "QTextFormat.properties": (),
        "QTextFormat.property": ('int',),
        "QTextFormat.propertyCount": (),
        "QTextFormat.setBackground": ('PySide2.QtGui.QBrush',),
        "QTextFormat.setForeground": ('PySide2.QtGui.QBrush',),
        "QTextFormat.setLayoutDirection": ('PySide2.QtCore.Qt.LayoutDirection',),
        "QTextFormat.setObjectIndex": ('int',),
        "QTextFormat.setObjectType": ('int',),
        "QTextFormat.setProperty": [('int', 'list'), ('int', 'typing.Any')],
        "QTextFormat.stringProperty": ('int',),
        "QTextFormat.swap": ('PySide2.QtGui.QTextFormat',),
        "QTextFormat.toBlockFormat": (),
        "QTextFormat.toCharFormat": (),
        "QTextFormat.toFrameFormat": (),
        "QTextFormat.toImageFormat": (),
        "QTextFormat.toListFormat": (),
        "QTextFormat.toTableCellFormat": (),
        "QTextFormat.toTableFormat": (),
        "QTextFormat.type": (),

    # class PySide2.QtGui.QTextFragment:
        "QTextFragment.__init__": [(), ('PySide2.QtGui.QTextFragment',)],
        "QTextFragment.__copy__": (),
        "QTextFragment.charFormat": (),
        "QTextFragment.charFormatIndex": (),
        "QTextFragment.contains": ('int',),
        "QTextFragment.isValid": (),
        "QTextFragment.length": (),
        "QTextFragment.position": (),
        "QTextFragment.text": (),

    # class PySide2.QtGui.QTextFrame:
        "QTextFrame.__init__": ('PySide2.QtGui.QTextDocument',),
        "QTextFrame.__iter__": (),
        "QTextFrame.begin": (),
        "QTextFrame.childFrames": (),
        "QTextFrame.end": (),
        "QTextFrame.firstCursorPosition": (),
        "QTextFrame.firstPosition": (),
        "QTextFrame.frameFormat": (),
        "QTextFrame.lastCursorPosition": (),
        "QTextFrame.lastPosition": (),
        "QTextFrame.parentFrame": (),
        "QTextFrame.setFrameFormat": ('PySide2.QtGui.QTextFrameFormat',),

    # class PySide2.QtGui.QTextFrame.iterator:
        "QTextFrame.iterator.__init__": [(), ('PySide2.QtGui.QTextFrame.iterator',)],
        "QTextFrame.iterator.__copy__": (),
        "QTextFrame.iterator.__iadd__": ('int',),
        "QTextFrame.iterator.__isub__": ('int',),
        "QTextFrame.iterator.__iter__": (),
        "QTextFrame.iterator.atEnd": (),
        "QTextFrame.iterator.currentBlock": (),
        "QTextFrame.iterator.currentFrame": (),
        "QTextFrame.iterator.parentFrame": (),

    # class PySide2.QtGui.QTextFrameFormat:
        "QTextFrameFormat.__init__": [(), ('PySide2.QtGui.QTextFormat',), ('PySide2.QtGui.QTextFrameFormat',)],
        "QTextFrameFormat.__copy__": (),
        "QTextFrameFormat.border": (),
        "QTextFrameFormat.borderBrush": (),
        "QTextFrameFormat.borderStyle": (),
        "QTextFrameFormat.bottomMargin": (),
        "QTextFrameFormat.height": (),
        "QTextFrameFormat.isValid": (),
        "QTextFrameFormat.leftMargin": (),
        "QTextFrameFormat.margin": (),
        "QTextFrameFormat.padding": (),
        "QTextFrameFormat.pageBreakPolicy": (),
        "QTextFrameFormat.position": (),
        "QTextFrameFormat.rightMargin": (),
        "QTextFrameFormat.setBorder": ('float',),
        "QTextFrameFormat.setBorderBrush": ('PySide2.QtGui.QBrush',),
        "QTextFrameFormat.setBorderStyle": ('PySide2.QtGui.QTextFrameFormat.BorderStyle',),
        "QTextFrameFormat.setBottomMargin": ('float',),
        "QTextFrameFormat.setHeight": [('PySide2.QtGui.QTextLength',), ('float',)],
        "QTextFrameFormat.setLeftMargin": ('float',),
        "QTextFrameFormat.setMargin": ('float',),
        "QTextFrameFormat.setPadding": ('float',),
        "QTextFrameFormat.setPageBreakPolicy": ('PySide2.QtGui.QTextFormat.PageBreakFlags',),
        "QTextFrameFormat.setPosition": ('PySide2.QtGui.QTextFrameFormat.Position',),
        "QTextFrameFormat.setRightMargin": ('float',),
        "QTextFrameFormat.setTopMargin": ('float',),
        "QTextFrameFormat.setWidth": [('PySide2.QtGui.QTextLength',), ('float',)],
        "QTextFrameFormat.topMargin": (),
        "QTextFrameFormat.width": (),

    # class PySide2.QtGui.QTextImageFormat:
        "QTextImageFormat.__init__": [(), ('PySide2.QtGui.QTextFormat',), ('PySide2.QtGui.QTextImageFormat',)],
        "QTextImageFormat.__copy__": (),
        "QTextImageFormat.height": (),
        "QTextImageFormat.isValid": (),
        "QTextImageFormat.name": (),
        "QTextImageFormat.quality": (),
        "QTextImageFormat.setHeight": ('float',),
        "QTextImageFormat.setName": ('str',),
        "QTextImageFormat.setQuality": ('int',),
        "QTextImageFormat.setWidth": ('float',),
        "QTextImageFormat.width": (),

    # class PySide2.QtGui.QTextInlineObject:
        "QTextInlineObject.__init__": (),
        "QTextInlineObject.__copy__": (),
        "QTextInlineObject.ascent": (),
        "QTextInlineObject.descent": (),
        "QTextInlineObject.format": (),
        "QTextInlineObject.formatIndex": (),
        "QTextInlineObject.height": (),
        "QTextInlineObject.isValid": (),
        "QTextInlineObject.rect": (),
        "QTextInlineObject.setAscent": ('float',),
        "QTextInlineObject.setDescent": ('float',),
        "QTextInlineObject.setWidth": ('float',),
        "QTextInlineObject.textDirection": (),
        "QTextInlineObject.textPosition": (),
        "QTextInlineObject.width": (),

    # class PySide2.QtGui.QTextItem:
        "QTextItem.__init__": (),
        "QTextItem.ascent": (),
        "QTextItem.descent": (),
        "QTextItem.font": (),
        "QTextItem.renderFlags": (),
        "QTextItem.text": (),
        "QTextItem.width": (),

    # class PySide2.QtGui.QTextLayout:
        "QTextLayout.__init__": [(), ('PySide2.QtGui.QTextBlock',), ('str',), ('str', 'PySide2.QtGui.QFont', 'PySide2.QtGui.QPaintDevice')],
        "QTextLayout.additionalFormats": (),
        "QTextLayout.beginLayout": (),
        "QTextLayout.boundingRect": (),
        "QTextLayout.cacheEnabled": (),
        "QTextLayout.clearAdditionalFormats": (),
        "QTextLayout.clearFormats": (),
        "QTextLayout.clearLayout": (),
        "QTextLayout.createLine": (),
        "QTextLayout.cursorMoveStyle": (),
        "QTextLayout.draw": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QPointF', 'list', 'PySide2.QtCore.QRectF'),
        "QTextLayout.drawCursor": [('PySide2.QtGui.QPainter', 'PySide2.QtCore.QPointF', 'int'), ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QPointF', 'int', 'int')],
        "QTextLayout.endLayout": (),
        "QTextLayout.font": (),
        "QTextLayout.formats": (),
        "QTextLayout.isValidCursorPosition": ('int',),
        "QTextLayout.leftCursorPosition": ('int',),
        "QTextLayout.lineAt": ('int',),
        "QTextLayout.lineCount": (),
        "QTextLayout.lineForTextPosition": ('int',),
        "QTextLayout.maximumWidth": (),
        "QTextLayout.minimumWidth": (),
        "QTextLayout.nextCursorPosition": ('int', 'PySide2.QtGui.QTextLayout.CursorMode'),
        "QTextLayout.position": (),
        "QTextLayout.preeditAreaPosition": (),
        "QTextLayout.preeditAreaText": (),
        "QTextLayout.previousCursorPosition": ('int', 'PySide2.QtGui.QTextLayout.CursorMode'),
        "QTextLayout.rightCursorPosition": ('int',),
        "QTextLayout.setAdditionalFormats": ('list',),
        "QTextLayout.setCacheEnabled": ('bool',),
        "QTextLayout.setCursorMoveStyle": ('PySide2.QtCore.Qt.CursorMoveStyle',),
        "QTextLayout.setFlags": ('int',),
        "QTextLayout.setFont": ('PySide2.QtGui.QFont',),
        "QTextLayout.setFormats": ('list',),
        "QTextLayout.setPosition": ('PySide2.QtCore.QPointF',),
        "QTextLayout.setPreeditArea": ('int', 'str'),
        "QTextLayout.setRawFont": ('PySide2.QtGui.QRawFont',),
        "QTextLayout.setText": ('str',),
        "QTextLayout.setTextOption": ('PySide2.QtGui.QTextOption',),
        "QTextLayout.text": (),
        "QTextLayout.textOption": (),

    # class PySide2.QtGui.QTextLayout.FormatRange:
        "QTextLayout.FormatRange.__init__": [(), ('PySide2.QtGui.QTextLayout.FormatRange',)],
        "QTextLayout.FormatRange.__copy__": (),

    # class PySide2.QtGui.QTextLength:
        "QTextLength.__init__": [(), ('PySide2.QtGui.QTextLength',), ('PySide2.QtGui.QTextLength.Type', 'float')],
        "QTextLength.__copy__": (),
        "QTextLength.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QTextLength.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QTextLength.rawValue": (),
        "QTextLength.type": (),
        "QTextLength.value": ('float',),

    # class PySide2.QtGui.QTextLine:
        "QTextLine.__init__": (),
        "QTextLine.__copy__": (),
        "QTextLine.ascent": (),
        "QTextLine.cursorToX": ('int', 'PySide2.QtGui.QTextLine.Edge'),
        "QTextLine.descent": (),
        "QTextLine.draw": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QPointF', 'PySide2.QtGui.QTextLayout.FormatRange'),
        "QTextLine.height": (),
        "QTextLine.horizontalAdvance": (),
        "QTextLine.isValid": (),
        "QTextLine.leading": (),
        "QTextLine.leadingIncluded": (),
        "QTextLine.lineNumber": (),
        "QTextLine.naturalTextRect": (),
        "QTextLine.naturalTextWidth": (),
        "QTextLine.position": (),
        "QTextLine.rect": (),
        "QTextLine.setLeadingIncluded": ('bool',),
        "QTextLine.setLineWidth": ('float',),
        "QTextLine.setNumColumns": [('int',), ('int', 'float')],
        "QTextLine.setPosition": ('PySide2.QtCore.QPointF',),
        "QTextLine.textLength": (),
        "QTextLine.textStart": (),
        "QTextLine.width": (),
        "QTextLine.x": (),
        "QTextLine.xToCursor": ('float', 'PySide2.QtGui.QTextLine.CursorPosition'),
        "QTextLine.y": (),

    # class PySide2.QtGui.QTextList:
        "QTextList.__init__": ('PySide2.QtGui.QTextDocument',),
        "QTextList.add": ('PySide2.QtGui.QTextBlock',),
        "QTextList.count": (),
        "QTextList.format": (),
        "QTextList.item": ('int',),
        "QTextList.itemNumber": ('PySide2.QtGui.QTextBlock',),
        "QTextList.itemText": ('PySide2.QtGui.QTextBlock',),
        "QTextList.remove": ('PySide2.QtGui.QTextBlock',),
        "QTextList.removeItem": ('int',),
        "QTextList.setFormat": [('PySide2.QtGui.QTextFormat',), ('PySide2.QtGui.QTextListFormat',)],

    # class PySide2.QtGui.QTextListFormat:
        "QTextListFormat.__init__": [(), ('PySide2.QtGui.QTextFormat',), ('PySide2.QtGui.QTextListFormat',)],
        "QTextListFormat.__copy__": (),
        "QTextListFormat.indent": (),
        "QTextListFormat.isValid": (),
        "QTextListFormat.numberPrefix": (),
        "QTextListFormat.numberSuffix": (),
        "QTextListFormat.setIndent": ('int',),
        "QTextListFormat.setNumberPrefix": ('str',),
        "QTextListFormat.setNumberSuffix": ('str',),
        "QTextListFormat.setStyle": ('PySide2.QtGui.QTextListFormat.Style',),
        "QTextListFormat.style": (),

    # class PySide2.QtGui.QTextObject:
        "QTextObject.__init__": ('PySide2.QtGui.QTextDocument',),
        "QTextObject.document": (),
        "QTextObject.format": (),
        "QTextObject.formatIndex": (),
        "QTextObject.objectIndex": (),
        "QTextObject.setFormat": ('PySide2.QtGui.QTextFormat',),

    # class PySide2.QtGui.QTextObjectInterface:
        "QTextObjectInterface.__init__": (),
        "QTextObjectInterface.drawObject": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF', 'PySide2.QtGui.QTextDocument', 'int', 'PySide2.QtGui.QTextFormat'),
        "QTextObjectInterface.intrinsicSize": ('PySide2.QtGui.QTextDocument', 'int', 'PySide2.QtGui.QTextFormat'),

    # class PySide2.QtGui.QTextOption:
        "QTextOption.__init__": [(), ('PySide2.QtCore.Qt.Alignment',), ('PySide2.QtGui.QTextOption',)],
        "QTextOption.__copy__": (),
        "QTextOption.alignment": (),
        "QTextOption.flags": (),
        "QTextOption.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QTextOption.setFlags": ('PySide2.QtGui.QTextOption.Flags',),
        "QTextOption.setTabArray": ('list',),
        "QTextOption.setTabStop": ('float',),
        "QTextOption.setTabStopDistance": ('float',),
        "QTextOption.setTabs": ('list',),
        "QTextOption.setTextDirection": ('PySide2.QtCore.Qt.LayoutDirection',),
        "QTextOption.setUseDesignMetrics": ('bool',),
        "QTextOption.setWrapMode": ('PySide2.QtGui.QTextOption.WrapMode',),
        "QTextOption.tabArray": (),
        "QTextOption.tabStop": (),
        "QTextOption.tabStopDistance": (),
        "QTextOption.tabs": (),
        "QTextOption.textDirection": (),
        "QTextOption.useDesignMetrics": (),
        "QTextOption.wrapMode": (),

    # class PySide2.QtGui.QTextOption.Tab:
        "QTextOption.Tab.__init__": [(), ('PySide2.QtGui.QTextOption.Tab',), ('float', 'PySide2.QtGui.QTextOption.TabType', 'typing.Union[str, int]')],
        "QTextOption.Tab.__copy__": (),

    # class PySide2.QtGui.QTextTable:
        "QTextTable.__init__": ('PySide2.QtGui.QTextDocument',),
        "QTextTable.appendColumns": ('int',),
        "QTextTable.appendRows": ('int',),
        "QTextTable.cellAt": [('PySide2.QtGui.QTextCursor',), ('int',), ('int', 'int')],
        "QTextTable.columns": (),
        "QTextTable.format": (),
        "QTextTable.insertColumns": ('int', 'int'),
        "QTextTable.insertRows": ('int', 'int'),
        "QTextTable.mergeCells": [('PySide2.QtGui.QTextCursor',), ('int', 'int', 'int', 'int')],
        "QTextTable.removeColumns": ('int', 'int'),
        "QTextTable.removeRows": ('int', 'int'),
        "QTextTable.resize": ('int', 'int'),
        "QTextTable.rowEnd": ('PySide2.QtGui.QTextCursor',),
        "QTextTable.rowStart": ('PySide2.QtGui.QTextCursor',),
        "QTextTable.rows": (),
        "QTextTable.setFormat": [('PySide2.QtGui.QTextFormat',), ('PySide2.QtGui.QTextTableFormat',)],
        "QTextTable.splitCell": ('int', 'int', 'int', 'int'),

    # class PySide2.QtGui.QTextTableCell:
        "QTextTableCell.__init__": [(), ('PySide2.QtGui.QTextTableCell',)],
        "QTextTableCell.__copy__": (),
        "QTextTableCell.begin": (),
        "QTextTableCell.column": (),
        "QTextTableCell.columnSpan": (),
        "QTextTableCell.end": (),
        "QTextTableCell.firstCursorPosition": (),
        "QTextTableCell.firstPosition": (),
        "QTextTableCell.format": (),
        "QTextTableCell.isValid": (),
        "QTextTableCell.lastCursorPosition": (),
        "QTextTableCell.lastPosition": (),
        "QTextTableCell.row": (),
        "QTextTableCell.rowSpan": (),
        "QTextTableCell.setFormat": ('PySide2.QtGui.QTextCharFormat',),
        "QTextTableCell.tableCellFormatIndex": (),

    # class PySide2.QtGui.QTextTableCellFormat:
        "QTextTableCellFormat.__init__": [(), ('PySide2.QtGui.QTextFormat',), ('PySide2.QtGui.QTextTableCellFormat',)],
        "QTextTableCellFormat.__copy__": (),
        "QTextTableCellFormat.bottomPadding": (),
        "QTextTableCellFormat.isValid": (),
        "QTextTableCellFormat.leftPadding": (),
        "QTextTableCellFormat.rightPadding": (),
        "QTextTableCellFormat.setBottomPadding": ('float',),
        "QTextTableCellFormat.setLeftPadding": ('float',),
        "QTextTableCellFormat.setPadding": ('float',),
        "QTextTableCellFormat.setRightPadding": ('float',),
        "QTextTableCellFormat.setTopPadding": ('float',),
        "QTextTableCellFormat.topPadding": (),

    # class PySide2.QtGui.QTextTableFormat:
        "QTextTableFormat.__init__": [(), ('PySide2.QtGui.QTextFormat',), ('PySide2.QtGui.QTextTableFormat',)],
        "QTextTableFormat.__copy__": (),
        "QTextTableFormat.alignment": (),
        "QTextTableFormat.cellPadding": (),
        "QTextTableFormat.cellSpacing": (),
        "QTextTableFormat.clearColumnWidthConstraints": (),
        "QTextTableFormat.columnWidthConstraints": (),
        "QTextTableFormat.columns": (),
        "QTextTableFormat.headerRowCount": (),
        "QTextTableFormat.isValid": (),
        "QTextTableFormat.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QTextTableFormat.setCellPadding": ('float',),
        "QTextTableFormat.setCellSpacing": ('float',),
        "QTextTableFormat.setColumnWidthConstraints": ('list',),
        "QTextTableFormat.setColumns": ('int',),
        "QTextTableFormat.setHeaderRowCount": ('int',),

    # class PySide2.QtGui.QToolBarChangeEvent:
        "QToolBarChangeEvent.__init__": ('bool',),
        "QToolBarChangeEvent.toggle": (),

    # class PySide2.QtGui.QTouchDevice:
        "QTouchDevice.__init__": (),
        "QTouchDevice.capabilities": (),
        "QTouchDevice.devices": (),
        "QTouchDevice.maximumTouchPoints": (),
        "QTouchDevice.name": (),
        "QTouchDevice.setCapabilities": ('PySide2.QtGui.QTouchDevice.Capabilities',),
        "QTouchDevice.setMaximumTouchPoints": ('int',),
        "QTouchDevice.setName": ('str',),
        "QTouchDevice.setType": ('PySide2.QtGui.QTouchDevice.DeviceType',),
        "QTouchDevice.type": (),

    # class PySide2.QtGui.QTouchEvent:
        "QTouchEvent.__init__": ('PySide2.QtCore.QEvent.Type', 'PySide2.QtGui.QTouchDevice', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.TouchPointStates', 'list'),
        "QTouchEvent.device": (),
        "QTouchEvent.setDevice": ('PySide2.QtGui.QTouchDevice',),
        "QTouchEvent.setTarget": ('PySide2.QtCore.QObject',),
        "QTouchEvent.setTouchPointStates": ('PySide2.QtCore.Qt.TouchPointStates',),
        "QTouchEvent.setTouchPoints": ('list',),
        "QTouchEvent.setWindow": ('PySide2.QtGui.QWindow',),
        "QTouchEvent.target": (),
        "QTouchEvent.touchPointStates": (),
        "QTouchEvent.touchPoints": (),
        "QTouchEvent.window": (),

    # class PySide2.QtGui.QTouchEvent.TouchPoint:
        "QTouchEvent.TouchPoint.__init__": [('PySide2.QtGui.QTouchEvent.TouchPoint',), ('int',)],
        "QTouchEvent.TouchPoint.__copy__": (),
        "QTouchEvent.TouchPoint.ellipseDiameters": (),
        "QTouchEvent.TouchPoint.flags": (),
        "QTouchEvent.TouchPoint.id": (),
        "QTouchEvent.TouchPoint.lastNormalizedPos": (),
        "QTouchEvent.TouchPoint.lastPos": (),
        "QTouchEvent.TouchPoint.lastScenePos": (),
        "QTouchEvent.TouchPoint.lastScreenPos": (),
        "QTouchEvent.TouchPoint.normalizedPos": (),
        "QTouchEvent.TouchPoint.pos": (),
        "QTouchEvent.TouchPoint.pressure": (),
        "QTouchEvent.TouchPoint.rawScreenPositions": (),
        "QTouchEvent.TouchPoint.rect": (),
        "QTouchEvent.TouchPoint.rotation": (),
        "QTouchEvent.TouchPoint.scenePos": (),
        "QTouchEvent.TouchPoint.sceneRect": (),
        "QTouchEvent.TouchPoint.screenPos": (),
        "QTouchEvent.TouchPoint.screenRect": (),
        "QTouchEvent.TouchPoint.setEllipseDiameters": ('PySide2.QtCore.QSizeF',),
        "QTouchEvent.TouchPoint.setFlags": ('PySide2.QtGui.QTouchEvent.TouchPoint.InfoFlags',),
        "QTouchEvent.TouchPoint.setId": ('int',),
        "QTouchEvent.TouchPoint.setLastNormalizedPos": ('PySide2.QtCore.QPointF',),
        "QTouchEvent.TouchPoint.setLastPos": ('PySide2.QtCore.QPointF',),
        "QTouchEvent.TouchPoint.setLastScenePos": ('PySide2.QtCore.QPointF',),
        "QTouchEvent.TouchPoint.setLastScreenPos": ('PySide2.QtCore.QPointF',),
        "QTouchEvent.TouchPoint.setNormalizedPos": ('PySide2.QtCore.QPointF',),
        "QTouchEvent.TouchPoint.setPos": ('PySide2.QtCore.QPointF',),
        "QTouchEvent.TouchPoint.setPressure": ('float',),
        "QTouchEvent.TouchPoint.setRawScreenPositions": ('list',),
        "QTouchEvent.TouchPoint.setRect": ('PySide2.QtCore.QRectF',),
        "QTouchEvent.TouchPoint.setRotation": ('float',),
        "QTouchEvent.TouchPoint.setScenePos": ('PySide2.QtCore.QPointF',),
        "QTouchEvent.TouchPoint.setSceneRect": ('PySide2.QtCore.QRectF',),
        "QTouchEvent.TouchPoint.setScreenPos": ('PySide2.QtCore.QPointF',),
        "QTouchEvent.TouchPoint.setScreenRect": ('PySide2.QtCore.QRectF',),
        "QTouchEvent.TouchPoint.setStartNormalizedPos": ('PySide2.QtCore.QPointF',),
        "QTouchEvent.TouchPoint.setStartPos": ('PySide2.QtCore.QPointF',),
        "QTouchEvent.TouchPoint.setStartScenePos": ('PySide2.QtCore.QPointF',),
        "QTouchEvent.TouchPoint.setStartScreenPos": ('PySide2.QtCore.QPointF',),
        "QTouchEvent.TouchPoint.setState": ('PySide2.QtCore.Qt.TouchPointStates',),
        "QTouchEvent.TouchPoint.setUniqueId": ('int',),
        "QTouchEvent.TouchPoint.setVelocity": ('PySide2.QtGui.QVector2D',),
        "QTouchEvent.TouchPoint.startNormalizedPos": (),
        "QTouchEvent.TouchPoint.startPos": (),
        "QTouchEvent.TouchPoint.startScenePos": (),
        "QTouchEvent.TouchPoint.startScreenPos": (),
        "QTouchEvent.TouchPoint.state": (),
        "QTouchEvent.TouchPoint.swap": ('PySide2.QtGui.QTouchEvent.TouchPoint',),
        "QTouchEvent.TouchPoint.uniqueId": (),
        "QTouchEvent.TouchPoint.velocity": (),

    # class PySide2.QtGui.QTransform:
        "QTransform.__init__": [(), ('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',), ('float', 'float', 'float', 'float', 'float', 'float'), ('float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float')],
        "QTransform.__add__": ('float',),
        "QTransform.__copy__": (),
        "QTransform.__iadd__": ('float',),
        "QTransform.__imul__": [('PySide2.QtGui.QTransform',), ('float',)],
        "QTransform.__isub__": ('float',),
        "QTransform.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QTransform.__mul__": [('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QTransform',), ('float',)],
        "QTransform.__reduce__": (),
        "QTransform.__repr__": (),
        "QTransform.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QTransform.__sub__": ('float',),
        "QTransform.adjoint": (),
        "QTransform.det": (),
        "QTransform.determinant": (),
        "QTransform.dx": (),
        "QTransform.dy": (),
        "QTransform.fromScale": ('float', 'float'),
        "QTransform.fromTranslate": ('float', 'float'),
        "QTransform.inverted": ('bool',),
        "QTransform.isAffine": (),
        "QTransform.isIdentity": (),
        "QTransform.isInvertible": (),
        "QTransform.isRotating": (),
        "QTransform.isScaling": (),
        "QTransform.isTranslating": (),
        "QTransform.m11": (),
        "QTransform.m12": (),
        "QTransform.m13": (),
        "QTransform.m21": (),
        "QTransform.m22": (),
        "QTransform.m23": (),
        "QTransform.m31": (),
        "QTransform.m32": (),
        "QTransform.m33": (),
        "QTransform.map": [('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygon',), ('PySide2.QtGui.QPolygonF',), ('PySide2.QtGui.QRegion',), ('float', 'float', 'float', 'float')],
        "QTransform.mapRect": [('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',)],
        "QTransform.mapToPolygon": ('PySide2.QtCore.QRect',),
        "QTransform.quadToQuad": [('PySide2.QtGui.QPolygonF', 'PySide2.QtGui.QPolygonF'), ('PySide2.QtGui.QPolygonF', 'PySide2.QtGui.QPolygonF', 'PySide2.QtGui.QTransform')],
        "QTransform.quadToSquare": [('PySide2.QtGui.QPolygonF',), ('PySide2.QtGui.QPolygonF', 'PySide2.QtGui.QTransform')],
        "QTransform.reset": (),
        "QTransform.rotate": ('float', 'PySide2.QtCore.Qt.Axis'),
        "QTransform.rotateRadians": ('float', 'PySide2.QtCore.Qt.Axis'),
        "QTransform.scale": ('float', 'float'),
        "QTransform.setMatrix": ('float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float'),
        "QTransform.shear": ('float', 'float'),
        "QTransform.squareToQuad": [('PySide2.QtGui.QPolygonF',), ('PySide2.QtGui.QPolygonF', 'PySide2.QtGui.QTransform')],
        "QTransform.toAffine": (),
        "QTransform.translate": ('float', 'float'),
        "QTransform.transposed": (),
        "QTransform.type": (),

    # class PySide2.QtGui.QValidator:
        "QValidator.__init__": ('PySide2.QtCore.QObject',),
        "QValidator.fixup": ('str',),
        "QValidator.locale": (),
        "QValidator.setLocale": ('PySide2.QtCore.QLocale',),
        "QValidator.validate": ('str', 'int'),

    # class PySide2.QtGui.QVector2D:
        "QVector2D.__init__": [(), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QVector3D',), ('PySide2.QtGui.QVector4D',), ('float', 'float')],
        "QVector2D.__add__": ('PySide2.QtGui.QVector2D',),
        "QVector2D.__copy__": (),
        "QVector2D.__iadd__": ('PySide2.QtGui.QVector2D',),
        "QVector2D.__imul__": [('PySide2.QtGui.QVector2D',), ('float',)],
        "QVector2D.__isub__": ('PySide2.QtGui.QVector2D',),
        "QVector2D.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QVector2D.__mul__": [('PySide2.QtGui.QVector2D',), ('float',)],
        "QVector2D.__neg__": (),
        "QVector2D.__reduce__": (),
        "QVector2D.__repr__": (),
        "QVector2D.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QVector2D.__sub__": ('PySide2.QtGui.QVector2D',),
        "QVector2D.distanceToLine": ('PySide2.QtGui.QVector2D', 'PySide2.QtGui.QVector2D'),
        "QVector2D.distanceToPoint": ('PySide2.QtGui.QVector2D',),
        "QVector2D.dotProduct": ('PySide2.QtGui.QVector2D', 'PySide2.QtGui.QVector2D'),
        "QVector2D.isNull": (),
        "QVector2D.length": (),
        "QVector2D.lengthSquared": (),
        "QVector2D.normalize": (),
        "QVector2D.normalized": (),
        "QVector2D.setX": ('float',),
        "QVector2D.setY": ('float',),
        "QVector2D.toPoint": (),
        "QVector2D.toPointF": (),
        "QVector2D.toTuple": (),
        "QVector2D.toVector3D": (),
        "QVector2D.toVector4D": (),
        "QVector2D.x": (),
        "QVector2D.y": (),

    # class PySide2.QtGui.QVector3D:
        "QVector3D.__init__": [(), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QVector2D',), ('PySide2.QtGui.QVector2D', 'float'), ('PySide2.QtGui.QVector4D',), ('float', 'float', 'float')],
        "QVector3D.__add__": ('PySide2.QtGui.QVector3D',),
        "QVector3D.__copy__": (),
        "QVector3D.__iadd__": ('PySide2.QtGui.QVector3D',),
        "QVector3D.__imul__": [('PySide2.QtGui.QVector3D',), ('float',)],
        "QVector3D.__isub__": ('PySide2.QtGui.QVector3D',),
        "QVector3D.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QVector3D.__mul__": [('PySide2.QtGui.QMatrix4x4',), ('PySide2.QtGui.QQuaternion',), ('PySide2.QtGui.QVector3D',), ('float',)],
        "QVector3D.__neg__": (),
        "QVector3D.__reduce__": (),
        "QVector3D.__repr__": (),
        "QVector3D.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QVector3D.__sub__": ('PySide2.QtGui.QVector3D',),
        "QVector3D.crossProduct": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
        "QVector3D.distanceToLine": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
        "QVector3D.distanceToPlane": [('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'), ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D')],
        "QVector3D.distanceToPoint": ('PySide2.QtGui.QVector3D',),
        "QVector3D.dotProduct": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
        "QVector3D.isNull": (),
        "QVector3D.length": (),
        "QVector3D.lengthSquared": (),
        "QVector3D.normal": [('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'), ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D')],
        "QVector3D.normalize": (),
        "QVector3D.normalized": (),
        "QVector3D.project": ('PySide2.QtGui.QMatrix4x4', 'PySide2.QtGui.QMatrix4x4', 'PySide2.QtCore.QRect'),
        "QVector3D.setX": ('float',),
        "QVector3D.setY": ('float',),
        "QVector3D.setZ": ('float',),
        "QVector3D.toPoint": (),
        "QVector3D.toPointF": (),
        "QVector3D.toTuple": (),
        "QVector3D.toVector2D": (),
        "QVector3D.toVector4D": (),
        "QVector3D.unproject": ('PySide2.QtGui.QMatrix4x4', 'PySide2.QtGui.QMatrix4x4', 'PySide2.QtCore.QRect'),
        "QVector3D.x": (),
        "QVector3D.y": (),
        "QVector3D.z": (),

    # class PySide2.QtGui.QVector4D:
        "QVector4D.__init__": [(), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QVector2D',), ('PySide2.QtGui.QVector2D', 'float', 'float'), ('PySide2.QtGui.QVector3D',), ('PySide2.QtGui.QVector3D', 'float'), ('float', 'float', 'float', 'float')],
        "QVector4D.__add__": ('PySide2.QtGui.QVector4D',),
        "QVector4D.__copy__": (),
        "QVector4D.__iadd__": ('PySide2.QtGui.QVector4D',),
        "QVector4D.__imul__": [('PySide2.QtGui.QVector4D',), ('float',)],
        "QVector4D.__isub__": ('PySide2.QtGui.QVector4D',),
        "QVector4D.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QVector4D.__mul__": [('PySide2.QtGui.QMatrix4x4',), ('PySide2.QtGui.QVector4D',), ('float',)],
        "QVector4D.__neg__": (),
        "QVector4D.__reduce__": (),
        "QVector4D.__repr__": (),
        "QVector4D.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QVector4D.__sub__": ('PySide2.QtGui.QVector4D',),
        "QVector4D.dotProduct": ('PySide2.QtGui.QVector4D', 'PySide2.QtGui.QVector4D'),
        "QVector4D.isNull": (),
        "QVector4D.length": (),
        "QVector4D.lengthSquared": (),
        "QVector4D.normalize": (),
        "QVector4D.normalized": (),
        "QVector4D.setW": ('float',),
        "QVector4D.setX": ('float',),
        "QVector4D.setY": ('float',),
        "QVector4D.setZ": ('float',),
        "QVector4D.toPoint": (),
        "QVector4D.toPointF": (),
        "QVector4D.toTuple": (),
        "QVector4D.toVector2D": (),
        "QVector4D.toVector2DAffine": (),
        "QVector4D.toVector3D": (),
        "QVector4D.toVector3DAffine": (),
        "QVector4D.w": (),
        "QVector4D.x": (),
        "QVector4D.y": (),
        "QVector4D.z": (),

    # class PySide2.QtGui.QWhatsThisClickedEvent:
        "QWhatsThisClickedEvent.__init__": ('str',),
        "QWhatsThisClickedEvent.href": (),

    # class PySide2.QtGui.QWheelEvent:
        "QWheelEvent.__init__": [('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.ScrollPhase', 'bool', 'PySide2.QtCore.Qt.MouseEventSource'), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint', 'int', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers'), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint', 'int', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.ScrollPhase'), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint', 'int', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.ScrollPhase', 'PySide2.QtCore.Qt.MouseEventSource'), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint', 'int', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.ScrollPhase', 'PySide2.QtCore.Qt.MouseEventSource', 'bool'), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'int', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.Orientation'), ('PySide2.QtCore.QPointF', 'int', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.Orientation')],
        "QWheelEvent.angleDelta": (),
        "QWheelEvent.buttons": (),
        "QWheelEvent.delta": (),
        "QWheelEvent.globalPos": (),
        "QWheelEvent.globalPosF": (),
        "QWheelEvent.globalX": (),
        "QWheelEvent.global""Y": (),
        "QWheelEvent.inverted": (),
        "QWheelEvent.orientation": (),
        "QWheelEvent.phase": (),
        "QWheelEvent.pixelDelta": (),
        "QWheelEvent.pos": (),
        "QWheelEvent.posF": (),
        "QWheelEvent.source": (),
        "QWheelEvent.x": (),
        "QWheelEvent.y": (),

    # class PySide2.QtGui.QWindow:
        "QWindow.__init__": [('PySide2.QtGui.QScreen',), ('PySide2.QtGui.QWindow',)],
        "QWindow.accessibleRoot": (),
        "QWindow.alert": ('int',),
        "QWindow.baseSize": (),
        "QWindow.close": (),
        "QWindow.contentOrientation": (),
        "QWindow.create": (),
        "QWindow.cursor": (),
        "QWindow.destroy": (),
        "QWindow.devicePixelRatio": (),
        "QWindow.event": ('PySide2.QtCore.QEvent',),
        "QWindow.exposeEvent": ('PySide2.QtGui.QExposeEvent',),
        "QWindow.filePath": (),
        "QWindow.flags": (),
        "QWindow.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QWindow.focusObject": (),
        "QWindow.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QWindow.format": (),
        "QWindow.frameGeometry": (),
        "QWindow.frameMargins": (),
        "QWindow.framePosition": (),
        "QWindow.fromWinId": ('int',),
        "QWindow.geometry": (),
        "QWindow.height": (),
        "QWindow.hide": (),
        "QWindow.hideEvent": ('PySide2.QtGui.QHideEvent',),
        "QWindow.icon": (),
        "QWindow.isActive": (),
        "QWindow.isAncestorOf": ('PySide2.QtGui.QWindow', 'PySide2.QtGui.QWindow.AncestorMode'),
        "QWindow.isExposed": (),
        "QWindow.isModal": (),
        "QWindow.isTopLevel": (),
        "QWindow.isVisible": (),
        "QWindow.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QWindow.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
        "QWindow.lower": (),
        "QWindow.mapFromGlobal": ('PySide2.QtCore.QPoint',),
        "QWindow.mapToGlobal": ('PySide2.QtCore.QPoint',),
        "QWindow.mask": (),
        "QWindow.maximumHeight": (),
        "QWindow.maximumSize": (),
        "QWindow.maximumWidth": (),
        "QWindow.minimumHeight": (),
        "QWindow.minimumSize": (),
        "QWindow.minimumWidth": (),
        "QWindow.modality": (),
        "QWindow.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
        "QWindow.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QWindow.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QWindow.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QWindow.moveEvent": ('PySide2.QtGui.QMoveEvent',),
        "QWindow.nativeEvent": ('PySide2.QtCore.QByteArray', 'int', 'int'),
        "QWindow.opacity": (),
        "QWindow.parent": [(), ('PySide2.QtGui.QWindow.AncestorMode',)],
        "QWindow.position": (),
        "QWindow.raise_": (),
        "QWindow.reportContentOrientationChange": ('PySide2.QtCore.Qt.ScreenOrientation',),
        "QWindow.requestActivate": (),
        "QWindow.requestUpdate": (),
        "QWindow.requestedFormat": (),
        "QWindow.resize": [('PySide2.QtCore.QSize',), ('int', 'int')],
        "QWindow.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QWindow.screen": (),
        "QWindow.setBaseSize": ('PySide2.QtCore.QSize',),
        "QWindow.setCursor": ('PySide2.QtGui.QCursor',),
        "QWindow.setFilePath": ('str',),
        "QWindow.setFlag": ('PySide2.QtCore.Qt.WindowType', 'bool'),
        "QWindow.setFlags": ('PySide2.QtCore.Qt.WindowFlags',),
        "QWindow.setFormat": ('PySide2.QtGui.QSurfaceFormat',),
        "QWindow.setFramePosition": ('PySide2.QtCore.QPoint',),
        "QWindow.setGeometry": [('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
        "QWindow.setHeight": ('int',),
        "QWindow.setIcon": ('PySide2.QtGui.QIcon',),
        "QWindow.setKeyboardGrabEnabled": ('bool',),
        "QWindow.setMask": ('PySide2.QtGui.QRegion',),
        "QWindow.setMaximumHeight": ('int',),
        "QWindow.setMaximumSize": ('PySide2.QtCore.QSize',),
        "QWindow.setMaximumWidth": ('int',),
        "QWindow.setMinimumHeight": ('int',),
        "QWindow.setMinimumSize": ('PySide2.QtCore.QSize',),
        "QWindow.setMinimumWidth": ('int',),
        "QWindow.setModality": ('PySide2.QtCore.Qt.WindowModality',),
        "QWindow.setMouseGrabEnabled": ('bool',),
        "QWindow.setOpacity": ('float',),
        "QWindow.setParent": ('PySide2.QtGui.QWindow',),
        "QWindow.setPosition": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QWindow.setScreen": ('PySide2.QtGui.QScreen',),
        "QWindow.setSizeIncrement": ('PySide2.QtCore.QSize',),
        "QWindow.setSurfaceType": ('PySide2.QtGui.QSurface.SurfaceType',),
        "QWindow.setTitle": ('str',),
        "QWindow.setTransientParent": ('PySide2.QtGui.QWindow',),
        "QWindow.setVisibility": ('PySide2.QtGui.QWindow.Visibility',),
        "QWindow.setVisible": ('bool',),
        "QWindow.setWidth": ('int',),
        "QWindow.setWindowState": ('PySide2.QtCore.Qt.WindowState',),
        "QWindow.setWindowStates": ('PySide2.QtCore.Qt.WindowStates',),
        "QWindow.setX": ('int',),
        "QWindow.setY": ('int',),
        "QWindow.show": (),
        "QWindow.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QWindow.showFullScreen": (),
        "QWindow.showMaximized": (),
        "QWindow.showMinimized": (),
        "QWindow.showNormal": (),
        "QWindow.size": (),
        "QWindow.sizeIncrement": (),
        "QWindow.surfaceHandle": (),
        "QWindow.surfaceType": (),
        "QWindow.tabletEvent": ('PySide2.QtGui.QTabletEvent',),
        "QWindow.title": (),
        "QWindow.touchEvent": ('PySide2.QtGui.QTouchEvent',),
        "QWindow.transientParent": (),
        "QWindow.type": (),
        "QWindow.unsetCursor": (),
        "QWindow.visibility": (),
        "QWindow.wheelEvent": ('PySide2.QtGui.QWheelEvent',),
        "QWindow.width": (),
        "QWindow.winId": (),
        "QWindow.windowState": (),
        "QWindow.windowStates": (),
        "QWindow.x": (),
        "QWindow.y": (),

    # class PySide2.QtGui.QWindowStateChangeEvent:
        "QWindowStateChangeEvent.__init__": ('PySide2.QtCore.Qt.WindowStates', 'bool'),
        "QWindowStateChangeEvent.isOverride": (),
        "QWindowStateChangeEvent.oldState": (),
    })

# Module PySide2.QtWidgets
if "PySide2.QtWidgets" in sys.modules:
    dict.update({

    # class PySide2.QtWidgets.QAbstractButton:
        "QAbstractButton.__init__": ('PySide2.QtWidgets.QWidget',),
        "QAbstractButton.animateClick": ('int',),
        "QAbstractButton.autoExclusive": (),
        "QAbstractButton.autoRepeat": (),
        "QAbstractButton.autoRepeatDelay": (),
        "QAbstractButton.autoRepeatInterval": (),
        "QAbstractButton.changeEvent": ('PySide2.QtCore.QEvent',),
        "QAbstractButton.checkStateSet": (),
        "QAbstractButton.click": (),
        "QAbstractButton.event": ('PySide2.QtCore.QEvent',),
        "QAbstractButton.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QAbstractButton.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QAbstractButton.group": (),
        "QAbstractButton.hitButton": ('PySide2.QtCore.QPoint',),
        "QAbstractButton.icon": (),
        "QAbstractButton.iconSize": (),
        "QAbstractButton.isCheckable": (),
        "QAbstractButton.isChecked": (),
        "QAbstractButton.isDown": (),
        "QAbstractButton.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QAbstractButton.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
        "QAbstractButton.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QAbstractButton.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QAbstractButton.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QAbstractButton.nextCheckState": (),
        "QAbstractButton.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QAbstractButton.setAutoExclusive": ('bool',),
        "QAbstractButton.setAutoRepeat": ('bool',),
        "QAbstractButton.setAutoRepeatDelay": ('int',),
        "QAbstractButton.setAutoRepeatInterval": ('int',),
        "QAbstractButton.setCheckable": ('bool',),
        "QAbstractButton.setChecked": ('bool',),
        "QAbstractButton.setDown": ('bool',),
        "QAbstractButton.setIcon": ('PySide2.QtGui.QIcon',),
        "QAbstractButton.setIconSize": ('PySide2.QtCore.QSize',),
        "QAbstractButton.setShortcut": ('PySide2.QtGui.QKeySequence',),
        "QAbstractButton.setText": ('str',),
        "QAbstractButton.shortcut": (),
        "QAbstractButton.text": (),
        "QAbstractButton.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QAbstractButton.toggle": (),

    # class PySide2.QtWidgets.QAbstractGraphicsShapeItem:
        "QAbstractGraphicsShapeItem.__init__": ('PySide2.QtWidgets.QGraphicsItem',),
        "QAbstractGraphicsShapeItem.brush": (),
        "QAbstractGraphicsShapeItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
        "QAbstractGraphicsShapeItem.opaqueArea": (),
        "QAbstractGraphicsShapeItem.pen": (),
        "QAbstractGraphicsShapeItem.setBrush": ('PySide2.QtGui.QBrush',),
        "QAbstractGraphicsShapeItem.setPen": ('PySide2.QtGui.QPen',),

    # class PySide2.QtWidgets.QAbstractItemDelegate:
        "QAbstractItemDelegate.__init__": ('PySide2.QtCore.QObject',),
        "QAbstractItemDelegate.createEditor": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemDelegate.destroyEditor": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemDelegate.editorEvent": ('PySide2.QtCore.QEvent', 'PySide2.QtCore.QAbstractItemModel', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemDelegate.elidedText": ('PySide2.QtGui.QFontMetrics', 'int', 'PySide2.QtCore.Qt.TextElideMode', 'str'),
        "QAbstractItemDelegate.helpEvent": ('PySide2.QtGui.QHelpEvent', 'PySide2.QtWidgets.QAbstractItemView', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemDelegate.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemDelegate.paintingRoles": (),
        "QAbstractItemDelegate.setEditorData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemDelegate.setModelData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QAbstractItemModel', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemDelegate.sizeHint": ('PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemDelegate.updateEditorGeometry": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),

    # class PySide2.QtWidgets.QAbstractItemView:
        "QAbstractItemView.__init__": ('PySide2.QtWidgets.QWidget',),
        "QAbstractItemView.alternatingRowColors": (),
        "QAbstractItemView.autoScrollMargin": (),
        "QAbstractItemView.clearSelection": (),
        "QAbstractItemView.closeEditor": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QAbstractItemDelegate.EndEditHint'),
        "QAbstractItemView.closePersistentEditor": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemView.commitData": ('PySide2.QtWidgets.QWidget',),
        "QAbstractItemView.currentChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
        "QAbstractItemView.currentIndex": (),
        "QAbstractItemView.dataChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex', 'list'),
        "QAbstractItemView.defaultDropAction": (),
        "QAbstractItemView.dirtyRegionOffset": (),
        "QAbstractItemView.doAutoScroll": (),
        "QAbstractItemView.doItemsLayout": (),
        "QAbstractItemView.dragDropMode": (),
        "QAbstractItemView.dragDropOverwriteMode": (),
        "QAbstractItemView.dragEnabled": (),
        "QAbstractItemView.dragEnterEvent": ('PySide2.QtGui.QDragEnterEvent',),
        "QAbstractItemView.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
        "QAbstractItemView.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
        "QAbstractItemView.dropEvent": ('PySide2.QtGui.QDropEvent',),
        "QAbstractItemView.dropIndicatorPosition": (),
        "QAbstractItemView.edit": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QAbstractItemView.EditTrigger', 'PySide2.QtCore.QEvent')],
        "QAbstractItemView.editTriggers": (),
        "QAbstractItemView.editorDestroyed": ('PySide2.QtCore.QObject',),
        "QAbstractItemView.event": ('PySide2.QtCore.QEvent',),
        "QAbstractItemView.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QAbstractItemView.executeDelayedItemsLayout": (),
        "QAbstractItemView.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QAbstractItemView.focusNextPrevChild": ('bool',),
        "QAbstractItemView.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QAbstractItemView.hasAutoScroll": (),
        "QAbstractItemView.horizontalOffset": (),
        "QAbstractItemView.horizontalScrollMode": (),
        "QAbstractItemView.horizontalScrollbarAction": ('int',),
        "QAbstractItemView.horizontalScrollbarValueChanged": ('int',),
        "QAbstractItemView.horizontalStepsPerItem": (),
        "QAbstractItemView.iconSize": (),
        "QAbstractItemView.indexAt": ('PySide2.QtCore.QPoint',),
        "QAbstractItemView.indexWidget": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemView.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
        "QAbstractItemView.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
        "QAbstractItemView.isIndexHidden": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemView.isPersistentEditorOpen": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemView.itemDelegate": [(), ('PySide2.QtCore.QModelIndex',)],
        "QAbstractItemView.itemDelegateForColumn": ('int',),
        "QAbstractItemView.itemDelegateForRow": ('int',),
        "QAbstractItemView.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QAbstractItemView.keyboardSearch": ('str',),
        "QAbstractItemView.model": (),
        "QAbstractItemView.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
        "QAbstractItemView.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QAbstractItemView.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QAbstractItemView.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QAbstractItemView.moveCursor": ('PySide2.QtWidgets.QAbstractItemView.CursorAction', 'PySide2.QtCore.Qt.KeyboardModifiers'),
        "QAbstractItemView.openPersistentEditor": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemView.reset": (),
        "QAbstractItemView.resetHorizontalScrollMode": (),
        "QAbstractItemView.resetVerticalScrollMode": (),
        "QAbstractItemView.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QAbstractItemView.rootIndex": (),
        "QAbstractItemView.rowsAboutToBeRemoved": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QAbstractItemView.rowsInserted": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QAbstractItemView.scheduleDelayedItemsLayout": (),
        "QAbstractItemView.scrollDirtyRegion": ('int', 'int'),
        "QAbstractItemView.scrollTo": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
        "QAbstractItemView.scrollToBottom": (),
        "QAbstractItemView.scrollToTop": (),
        "QAbstractItemView.selectAll": (),
        "QAbstractItemView.selectedIndexes": (),
        "QAbstractItemView.selectionBehavior": (),
        "QAbstractItemView.selectionChanged": ('PySide2.QtCore.QItemSelection', 'PySide2.QtCore.QItemSelection'),
        "QAbstractItemView.selectionCommand": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QEvent'),
        "QAbstractItemView.selectionMode": (),
        "QAbstractItemView.selectionModel": (),
        "QAbstractItemView.setAlternatingRowColors": ('bool',),
        "QAbstractItemView.setAutoScroll": ('bool',),
        "QAbstractItemView.setAutoScrollMargin": ('int',),
        "QAbstractItemView.setCurrentIndex": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemView.setDefaultDropAction": ('PySide2.QtCore.Qt.DropAction',),
        "QAbstractItemView.setDirtyRegion": ('PySide2.QtGui.QRegion',),
        "QAbstractItemView.setDragDropMode": ('PySide2.QtWidgets.QAbstractItemView.DragDropMode',),
        "QAbstractItemView.setDragDropOverwriteMode": ('bool',),
        "QAbstractItemView.setDragEnabled": ('bool',),
        "QAbstractItemView.setDropIndicatorShown": ('bool',),
        "QAbstractItemView.setEditTriggers": ('PySide2.QtWidgets.QAbstractItemView.EditTriggers',),
        "QAbstractItemView.setHorizontalScrollMode": ('PySide2.QtWidgets.QAbstractItemView.ScrollMode',),
        "QAbstractItemView.setHorizontalStepsPerItem": ('int',),
        "QAbstractItemView.setIconSize": ('PySide2.QtCore.QSize',),
        "QAbstractItemView.setIndexWidget": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QWidget'),
        "QAbstractItemView.setItemDelegate": ('PySide2.QtWidgets.QAbstractItemDelegate',),
        "QAbstractItemView.setItemDelegateForColumn": ('int', 'PySide2.QtWidgets.QAbstractItemDelegate'),
        "QAbstractItemView.setItemDelegateForRow": ('int', 'PySide2.QtWidgets.QAbstractItemDelegate'),
        "QAbstractItemView.setModel": ('PySide2.QtCore.QAbstractItemModel',),
        "QAbstractItemView.setRootIndex": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemView.setSelection": ('PySide2.QtCore.QRect', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
        "QAbstractItemView.setSelectionBehavior": ('PySide2.QtWidgets.QAbstractItemView.SelectionBehavior',),
        "QAbstractItemView.setSelectionMode": ('PySide2.QtWidgets.QAbstractItemView.SelectionMode',),
        "QAbstractItemView.setSelectionModel": ('PySide2.QtCore.QItemSelectionModel',),
        "QAbstractItemView.setState": ('PySide2.QtWidgets.QAbstractItemView.State',),
        "QAbstractItemView.setTabKeyNavigation": ('bool',),
        "QAbstractItemView.setTextElideMode": ('PySide2.QtCore.Qt.TextElideMode',),
        "QAbstractItemView.setVerticalScrollMode": ('PySide2.QtWidgets.QAbstractItemView.ScrollMode',),
        "QAbstractItemView.setVerticalStepsPerItem": ('int',),
        "QAbstractItemView.showDropIndicator": (),
        "QAbstractItemView.sizeHintForColumn": ('int',),
        "QAbstractItemView.sizeHintForIndex": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemView.sizeHintForRow": ('int',),
        "QAbstractItemView.startAutoScroll": (),
        "QAbstractItemView.startDrag": ('PySide2.QtCore.Qt.DropActions',),
        "QAbstractItemView.state": (),
        "QAbstractItemView.stopAutoScroll": (),
        "QAbstractItemView.tabKeyNavigation": (),
        "QAbstractItemView.textElideMode": (),
        "QAbstractItemView.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QAbstractItemView.update": [(), ('PySide2.QtCore.QModelIndex',)],
        "QAbstractItemView.updateEditorData": (),
        "QAbstractItemView.updateEditorGeometries": (),
        "QAbstractItemView.updateGeometries": (),
        "QAbstractItemView.verticalOffset": (),
        "QAbstractItemView.verticalScrollMode": (),
        "QAbstractItemView.verticalScrollbarAction": ('int',),
        "QAbstractItemView.verticalScrollbarValueChanged": ('int',),
        "QAbstractItemView.verticalStepsPerItem": (),
        "QAbstractItemView.viewOptions": (),
        "QAbstractItemView.viewportEvent": ('PySide2.QtCore.QEvent',),
        "QAbstractItemView.viewportSizeHint": (),
        "QAbstractItemView.visualRect": ('PySide2.QtCore.QModelIndex',),
        "QAbstractItemView.visualRegionForSelection": ('PySide2.QtCore.QItemSelection',),

    # class PySide2.QtWidgets.QAbstractScrollArea:
        "QAbstractScrollArea.__init__": ('PySide2.QtWidgets.QWidget',),
        "QAbstractScrollArea.addScrollBarWidget": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.Alignment'),
        "QAbstractScrollArea.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
        "QAbstractScrollArea.cornerWidget": (),
        "QAbstractScrollArea.dragEnterEvent": ('PySide2.QtGui.QDragEnterEvent',),
        "QAbstractScrollArea.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
        "QAbstractScrollArea.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
        "QAbstractScrollArea.dropEvent": ('PySide2.QtGui.QDropEvent',),
        "QAbstractScrollArea.event": ('PySide2.QtCore.QEvent',),
        "QAbstractScrollArea.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QAbstractScrollArea.horizontalScrollBar": (),
        "QAbstractScrollArea.horizontalScrollBarPolicy": (),
        "QAbstractScrollArea.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QAbstractScrollArea.maximumViewportSize": (),
        "QAbstractScrollArea.minimumSizeHint": (),
        "QAbstractScrollArea.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
        "QAbstractScrollArea.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QAbstractScrollArea.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QAbstractScrollArea.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QAbstractScrollArea.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QAbstractScrollArea.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QAbstractScrollArea.scrollBarWidgets": ('PySide2.QtCore.Qt.Alignment',),
        "QAbstractScrollArea.scrollContentsBy": ('int', 'int'),
        "QAbstractScrollArea.setCornerWidget": ('PySide2.QtWidgets.QWidget',),
        "QAbstractScrollArea.setHorizontalScrollBar": ('PySide2.QtWidgets.QScrollBar',),
        "QAbstractScrollArea.setHorizontalScrollBarPolicy": ('PySide2.QtCore.Qt.ScrollBarPolicy',),
        "QAbstractScrollArea.setSizeAdjustPolicy": ('PySide2.QtWidgets.QAbstractScrollArea.SizeAdjustPolicy',),
        "QAbstractScrollArea.setVerticalScrollBar": ('PySide2.QtWidgets.QScrollBar',),
        "QAbstractScrollArea.setVerticalScrollBarPolicy": ('PySide2.QtCore.Qt.ScrollBarPolicy',),
        "QAbstractScrollArea.setViewport": ('PySide2.QtWidgets.QWidget',),
        "QAbstractScrollArea.setViewportMargins": [('PySide2.QtCore.QMargins',), ('int', 'int', 'int', 'int')],
        "QAbstractScrollArea.setupViewport": ('PySide2.QtWidgets.QWidget',),
        "QAbstractScrollArea.sizeAdjustPolicy": (),
        "QAbstractScrollArea.sizeHint": (),
        "QAbstractScrollArea.verticalScrollBar": (),
        "QAbstractScrollArea.verticalScrollBarPolicy": (),
        "QAbstractScrollArea.viewport": (),
        "QAbstractScrollArea.viewportEvent": ('PySide2.QtCore.QEvent',),
        "QAbstractScrollArea.viewportMargins": (),
        "QAbstractScrollArea.viewportSizeHint": (),
        "QAbstractScrollArea.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

    # class PySide2.QtWidgets.QAbstractSlider:
        "QAbstractSlider.__init__": ('PySide2.QtWidgets.QWidget',),
        "QAbstractSlider.changeEvent": ('PySide2.QtCore.QEvent',),
        "QAbstractSlider.event": ('PySide2.QtCore.QEvent',),
        "QAbstractSlider.hasTracking": (),
        "QAbstractSlider.invertedAppearance": (),
        "QAbstractSlider.invertedControls": (),
        "QAbstractSlider.isSliderDown": (),
        "QAbstractSlider.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QAbstractSlider.maximum": (),
        "QAbstractSlider.minimum": (),
        "QAbstractSlider.orientation": (),
        "QAbstractSlider.pageStep": (),
        "QAbstractSlider.repeatAction": (),
        "QAbstractSlider.setInvertedAppearance": ('bool',),
        "QAbstractSlider.setInvertedControls": ('bool',),
        "QAbstractSlider.setMaximum": ('int',),
        "QAbstractSlider.setMinimum": ('int',),
        "QAbstractSlider.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
        "QAbstractSlider.setPageStep": ('int',),
        "QAbstractSlider.setRange": ('int', 'int'),
        "QAbstractSlider.setRepeatAction": ('PySide2.QtWidgets.QAbstractSlider.SliderAction', 'int', 'int'),
        "QAbstractSlider.setSingleStep": ('int',),
        "QAbstractSlider.setSliderDown": ('bool',),
        "QAbstractSlider.setSliderPosition": ('int',),
        "QAbstractSlider.setTracking": ('bool',),
        "QAbstractSlider.setValue": ('int',),
        "QAbstractSlider.singleStep": (),
        "QAbstractSlider.sliderChange": ('PySide2.QtWidgets.QAbstractSlider.SliderChange',),
        "QAbstractSlider.sliderPosition": (),
        "QAbstractSlider.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QAbstractSlider.triggerAction": ('PySide2.QtWidgets.QAbstractSlider.SliderAction',),
        "QAbstractSlider.value": (),
        "QAbstractSlider.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

    # class PySide2.QtWidgets.QAbstractSpinBox:
        "QAbstractSpinBox.__init__": ('PySide2.QtWidgets.QWidget',),
        "QAbstractSpinBox.alignment": (),
        "QAbstractSpinBox.buttonSymbols": (),
        "QAbstractSpinBox.changeEvent": ('PySide2.QtCore.QEvent',),
        "QAbstractSpinBox.clear": (),
        "QAbstractSpinBox.closeEvent": ('PySide2.QtGui.QCloseEvent',),
        "QAbstractSpinBox.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
        "QAbstractSpinBox.correctionMode": (),
        "QAbstractSpinBox.event": ('PySide2.QtCore.QEvent',),
        "QAbstractSpinBox.fixup": ('str',),
        "QAbstractSpinBox.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QAbstractSpinBox.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QAbstractSpinBox.hasAcceptableInput": (),
        "QAbstractSpinBox.hasFrame": (),
        "QAbstractSpinBox.hideEvent": ('PySide2.QtGui.QHideEvent',),
        "QAbstractSpinBox.initStyleOption": ('PySide2.QtWidgets.QStyleOptionSpinBox',),
        "QAbstractSpinBox.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
        "QAbstractSpinBox.interpretText": (),
        "QAbstractSpinBox.isAccelerated": (),
        "QAbstractSpinBox.isGroupSeparatorShown": (),
        "QAbstractSpinBox.isReadOnly": (),
        "QAbstractSpinBox.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QAbstractSpinBox.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
        "QAbstractSpinBox.keyboardTracking": (),
        "QAbstractSpinBox.lineEdit": (),
        "QAbstractSpinBox.minimumSizeHint": (),
        "QAbstractSpinBox.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QAbstractSpinBox.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QAbstractSpinBox.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QAbstractSpinBox.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QAbstractSpinBox.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QAbstractSpinBox.selectAll": (),
        "QAbstractSpinBox.setAccelerated": ('bool',),
        "QAbstractSpinBox.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QAbstractSpinBox.setButtonSymbols": ('PySide2.QtWidgets.QAbstractSpinBox.ButtonSymbols',),
        "QAbstractSpinBox.setCorrectionMode": ('PySide2.QtWidgets.QAbstractSpinBox.CorrectionMode',),
        "QAbstractSpinBox.setFrame": ('bool',),
        "QAbstractSpinBox.setGroupSeparatorShown": ('bool',),
        "QAbstractSpinBox.setKeyboardTracking": ('bool',),
        "QAbstractSpinBox.setLineEdit": ('PySide2.QtWidgets.QLineEdit',),
        "QAbstractSpinBox.setReadOnly": ('bool',),
        "QAbstractSpinBox.setSpecialValueText": ('str',),
        "QAbstractSpinBox.setWrapping": ('bool',),
        "QAbstractSpinBox.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QAbstractSpinBox.sizeHint": (),
        "QAbstractSpinBox.specialValueText": (),
        "QAbstractSpinBox.stepBy": ('int',),
        "QAbstractSpinBox.stepDown": (),
        "QAbstractSpinBox.stepEnabled": (),
        "QAbstractSpinBox.stepUp": (),
        "QAbstractSpinBox.text": (),
        "QAbstractSpinBox.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QAbstractSpinBox.validate": ('str', 'int'),
        "QAbstractSpinBox.wheelEvent": ('PySide2.QtGui.QWheelEvent',),
        "QAbstractSpinBox.wrapping": (),

    # class PySide2.QtWidgets.QAccessibleWidget:
        "QAccessibleWidget.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtGui.QAccessible.Role', 'str'),
        "QAccessibleWidget.actionNames": (),
        "QAccessibleWidget.addControllingSignal": ('str',),
        "QAccessibleWidget.backgroundColor": (),
        "QAccessibleWidget.child": ('int',),
        "QAccessibleWidget.childCount": (),
        "QAccessibleWidget.doAction": ('str',),
        "QAccessibleWidget.focusChild": (),
        "QAccessibleWidget.foregroundColor": (),
        "QAccessibleWidget.indexOfChild": ('PySide2.QtGui.QAccessibleInterface',),
        "QAccessibleWidget.interface_cast": ('PySide2.QtGui.QAccessible.InterfaceType',),
        "QAccessibleWidget.isValid": (),
        "QAccessibleWidget.keyBindingsForAction": ('str',),
        "QAccessibleWidget.parent": (),
        "QAccessibleWidget.parentObject": (),
        "QAccessibleWidget.rect": (),
        "QAccessibleWidget.relations": ('PySide2.QtGui.QAccessible.Relation',),
        "QAccessibleWidget.role": (),
        "QAccessibleWidget.state": (),
        "QAccessibleWidget.text": ('PySide2.QtGui.QAccessible.Text',),
        "QAccessibleWidget.widget": (),
        "QAccessibleWidget.window": (),

    # class PySide2.QtWidgets.QAction:
        "QAction.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtGui.QIcon', 'str', 'PySide2.QtCore.QObject'), ('str', 'PySide2.QtCore.QObject')],
        "QAction.actionGroup": (),
        "QAction.activate": ('PySide2.QtWidgets.QAction.ActionEvent',),
        "QAction.associatedGraphicsWidgets": (),
        "QAction.associatedWidgets": (),
        "QAction.autoRepeat": (),
        "QAction.data": (),
        "QAction.event": ('PySide2.QtCore.QEvent',),
        "QAction.font": (),
        "QAction.hover": (),
        "QAction.icon": (),
        "QAction.iconText": (),
        "QAction.isCheckable": (),
        "QAction.isChecked": (),
        "QAction.isEnabled": (),
        "QAction.isIconVisibleInMenu": (),
        "QAction.isSeparator": (),
        "QAction.isShortcutVisibleInContextMenu": (),
        "QAction.isVisible": (),
        "QAction.menu": (),
        "QAction.menuRole": (),
        "QAction.parentWidget": (),
        "QAction.priority": (),
        "QAction.setActionGroup": ('PySide2.QtWidgets.QActionGroup',),
        "QAction.setAutoRepeat": ('bool',),
        "QAction.setCheckable": ('bool',),
        "QAction.setChecked": ('bool',),
        "QAction.setData": ('typing.Any',),
        "QAction.setDisabled": ('bool',),
        "QAction.setEnabled": ('bool',),
        "QAction.setFont": ('PySide2.QtGui.QFont',),
        "QAction.setIcon": ('PySide2.QtGui.QIcon',),
        "QAction.setIconText": ('str',),
        "QAction.setIconVisibleInMenu": ('bool',),
        "QAction.setMenu": ('PySide2.QtWidgets.QMenu',),
        "QAction.setMenuRole": ('PySide2.QtWidgets.QAction.MenuRole',),
        "QAction.setPriority": ('PySide2.QtWidgets.QAction.Priority',),
        "QAction.setSeparator": ('bool',),
        "QAction.setShortcut": ('PySide2.QtGui.QKeySequence',),
        "QAction.setShortcutContext": ('PySide2.QtCore.Qt.ShortcutContext',),
        "QAction.setShortcutVisibleInContextMenu": ('bool',),
        "QAction.setShortcuts": [('PySide2.QtGui.QKeySequence.StandardKey',), ('list',)],
        "QAction.setStatusTip": ('str',),
        "QAction.setText": ('str',),
        "QAction.setToolTip": ('str',),
        "QAction.setVisible": ('bool',),
        "QAction.setWhatsThis": ('str',),
        "QAction.shortcut": (),
        "QAction.shortcutContext": (),
        "QAction.shortcuts": (),
        "QAction.showStatusText": ('PySide2.QtWidgets.QWidget',),
        "QAction.statusTip": (),
        "QAction.text": (),
        "QAction.toggle": (),
        "QAction.toolTip": (),
        "QAction.trigger": (),
        "QAction.whatsThis": (),

    # class PySide2.QtWidgets.QActionGroup:
        "QActionGroup.__init__": ('PySide2.QtCore.QObject',),
        "QActionGroup.actions": (),
        "QActionGroup.addAction": [('PySide2.QtGui.QIcon', 'str'), ('PySide2.QtWidgets.QAction',), ('str',)],
        "QActionGroup.checkedAction": (),
        "QActionGroup.isEnabled": (),
        "QActionGroup.isExclusive": (),
        "QActionGroup.isVisible": (),
        "QActionGroup.removeAction": ('PySide2.QtWidgets.QAction',),
        "QActionGroup.setDisabled": ('bool',),
        "QActionGroup.setEnabled": ('bool',),
        "QActionGroup.setExclusive": ('bool',),
        "QActionGroup.setVisible": ('bool',),

    # class PySide2.QtWidgets.QApplication:
        "QApplication.__init__": [(), ('typing.List[str]',)],
        "QApplication.aboutQt": (),
        "QApplication.activeModalWidget": (),
        "QApplication.activePopupWidget": (),
        "QApplication.activeWindow": (),
        "QApplication.alert": ('PySide2.QtWidgets.QWidget', 'int'),
        "QApplication.allWidgets": (),
        "QApplication.autoSipEnabled": (),
        "QApplication.beep": (),
        "QApplication.closeAllWindows": (),
        "QApplication.colorSpec": (),
        "QApplication.cursorFlashTime": (),
        "QApplication.desktop": (),
        "QApplication.doubleClickInterval": (),
        "QApplication.event": ('PySide2.QtCore.QEvent',),
        "QApplication.exec_": (),
        "QApplication.focusWidget": (),
        "QApplication.font": [(), ('PySide2.QtWidgets.QWidget',), ('str',)],
        "QApplication.fontMetrics": (),
        "QApplication.globalStrut": (),
        "QApplication.isEffectEnabled": ('PySide2.QtCore.Qt.UIEffect',),
        "QApplication.keyboardInputInterval": (),
        "QApplication.notify": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QApplication.palette": [(), ('PySide2.QtWidgets.QWidget',), ('str',)],
        "QApplication.setActiveWindow": ('PySide2.QtWidgets.QWidget',),
        "QApplication.setAutoSipEnabled": ('bool',),
        "QApplication.setColorSpec": ('int',),
        "QApplication.setCursorFlashTime": ('int',),
        "QApplication.setDoubleClickInterval": ('int',),
        "QApplication.setEffectEnabled": ('PySide2.QtCore.Qt.UIEffect', 'bool'),
        "QApplication.setFont": [('PySide2.QtGui.QFont',), ('PySide2.QtGui.QFont', 'str')],
        "QApplication.setGlobalStrut": ('PySide2.QtCore.QSize',),
        "QApplication.setKeyboardInputInterval": ('int',),
        "QApplication.setPalette": [('PySide2.QtGui.QPalette',), ('PySide2.QtGui.QPalette', 'str')],
        "QApplication.setStartDragDistance": ('int',),
        "QApplication.setStartDragTime": ('int',),
        "QApplication.setStyle": [('PySide2.QtWidgets.QStyle',), ('str',)],
        "QApplication.setStyleSheet": ('str',),
        "QApplication.setWheelScrollLines": ('int',),
        "QApplication.setWindowIcon": ('PySide2.QtGui.QIcon',),
        "QApplication.startDragDistance": (),
        "QApplication.startDragTime": (),
        "QApplication.style": (),
        "QApplication.styleSheet": (),
        "QApplication.topLevelAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QApplication.topLevelWidgets": (),
        "QApplication.wheelScrollLines": (),
        "QApplication.widgetAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QApplication.windowIcon": (),

    # class PySide2.QtWidgets.QBoxLayout:
        "QBoxLayout.__init__": ('PySide2.QtWidgets.QBoxLayout.Direction', 'PySide2.QtWidgets.QWidget'),
        "QBoxLayout.addItem": ('PySide2.QtWidgets.QLayoutItem',),
        "QBoxLayout.addLayout": ('PySide2.QtWidgets.QLayout', 'int'),
        "QBoxLayout.addSpacerItem": ('PySide2.QtWidgets.QSpacerItem',),
        "QBoxLayout.addSpacing": ('int',),
        "QBoxLayout.addStretch": ('int',),
        "QBoxLayout.addStrut": ('int',),
        "QBoxLayout.addWidget": [('PySide2.QtWidgets.QWidget',), ('PySide2.QtWidgets.QWidget', 'int', 'PySide2.QtCore.Qt.Alignment')],
        "QBoxLayout.count": (),
        "QBoxLayout.direction": (),
        "QBoxLayout.expandingDirections": (),
        "QBoxLayout.hasHeightForWidth": (),
        "QBoxLayout.heightForWidth": ('int',),
        "QBoxLayout.insertItem": ('int', 'PySide2.QtWidgets.QLayoutItem'),
        "QBoxLayout.insertLayout": ('int', 'PySide2.QtWidgets.QLayout', 'int'),
        "QBoxLayout.insertSpacerItem": ('int', 'PySide2.QtWidgets.QSpacerItem'),
        "QBoxLayout.insertSpacing": ('int', 'int'),
        "QBoxLayout.insertStretch": ('int', 'int'),
        "QBoxLayout.insertWidget": ('int', 'PySide2.QtWidgets.QWidget', 'int', 'PySide2.QtCore.Qt.Alignment'),
        "QBoxLayout.invalidate": (),
        "QBoxLayout.itemAt": ('int',),
        "QBoxLayout.maximumSize": (),
        "QBoxLayout.minimumHeightForWidth": ('int',),
        "QBoxLayout.minimumSize": (),
        "QBoxLayout.setDirection": ('PySide2.QtWidgets.QBoxLayout.Direction',),
        "QBoxLayout.setGeometry": ('PySide2.QtCore.QRect',),
        "QBoxLayout.setSpacing": ('int',),
        "QBoxLayout.setStretch": ('int', 'int'),
        "QBoxLayout.setStretchFactor": [('PySide2.QtWidgets.QLayout', 'int'), ('PySide2.QtWidgets.QWidget', 'int')],
        "QBoxLayout.sizeHint": (),
        "QBoxLayout.spacing": (),
        "QBoxLayout.stretch": ('int',),
        "QBoxLayout.takeAt": ('int',),

    # class PySide2.QtWidgets.QButtonGroup:
        "QButtonGroup.__init__": ('PySide2.QtCore.QObject',),
        "QButtonGroup.addButton": ('PySide2.QtWidgets.QAbstractButton', 'int'),
        "QButtonGroup.button": ('int',),
        "QButtonGroup.buttons": (),
        "QButtonGroup.checkedButton": (),
        "QButtonGroup.checkedId": (),
        "QButtonGroup.exclusive": (),
        "QButtonGroup.id": ('PySide2.QtWidgets.QAbstractButton',),
        "QButtonGroup.removeButton": ('PySide2.QtWidgets.QAbstractButton',),
        "QButtonGroup.setExclusive": ('bool',),
        "QButtonGroup.setId": ('PySide2.QtWidgets.QAbstractButton', 'int'),

    # class PySide2.QtWidgets.QCalendarWidget:
        "QCalendarWidget.__init__": ('PySide2.QtWidgets.QWidget',),
        "QCalendarWidget.dateEditAcceptDelay": (),
        "QCalendarWidget.dateTextFormat": [(), ('PySide2.QtCore.QDate',)],
        "QCalendarWidget.event": ('PySide2.QtCore.QEvent',),
        "QCalendarWidget.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QCalendarWidget.firstDayOfWeek": (),
        "QCalendarWidget.headerTextFormat": (),
        "QCalendarWidget.horizontalHeaderFormat": (),
        "QCalendarWidget.isDateEditEnabled": (),
        "QCalendarWidget.isGridVisible": (),
        "QCalendarWidget.isNavigationBarVisible": (),
        "QCalendarWidget.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QCalendarWidget.maximumDate": (),
        "QCalendarWidget.minimumDate": (),
        "QCalendarWidget.minimumSizeHint": (),
        "QCalendarWidget.monthShown": (),
        "QCalendarWidget.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QCalendarWidget.paintCell": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'PySide2.QtCore.QDate'),
        "QCalendarWidget.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QCalendarWidget.selectedDate": (),
        "QCalendarWidget.selectionMode": (),
        "QCalendarWidget.setCurrentPage": ('int', 'int'),
        "QCalendarWidget.setDateEditAcceptDelay": ('int',),
        "QCalendarWidget.setDateEditEnabled": ('bool',),
        "QCalendarWidget.setDateRange": ('PySide2.QtCore.QDate', 'PySide2.QtCore.QDate'),
        "QCalendarWidget.setDateTextFormat": ('PySide2.QtCore.QDate', 'PySide2.QtGui.QTextCharFormat'),
        "QCalendarWidget.setFirstDayOfWeek": ('PySide2.QtCore.Qt.DayOfWeek',),
        "QCalendarWidget.setGridVisible": ('bool',),
        "QCalendarWidget.setHeaderTextFormat": ('PySide2.QtGui.QTextCharFormat',),
        "QCalendarWidget.setHorizontalHeaderFormat": ('PySide2.QtWidgets.QCalendarWidget.HorizontalHeaderFormat',),
        "QCalendarWidget.setMaximumDate": ('PySide2.QtCore.QDate',),
        "QCalendarWidget.setMinimumDate": ('PySide2.QtCore.QDate',),
        "QCalendarWidget.setNavigationBarVisible": ('bool',),
        "QCalendarWidget.setSelectedDate": ('PySide2.QtCore.QDate',),
        "QCalendarWidget.setSelectionMode": ('PySide2.QtWidgets.QCalendarWidget.SelectionMode',),
        "QCalendarWidget.setVerticalHeaderFormat": ('PySide2.QtWidgets.QCalendarWidget.VerticalHeaderFormat',),
        "QCalendarWidget.setWeekdayTextFormat": ('PySide2.QtCore.Qt.DayOfWeek', 'PySide2.QtGui.QTextCharFormat'),
        "QCalendarWidget.showNextMonth": (),
        "QCalendarWidget.showNextYear": (),
        "QCalendarWidget.showPreviousMonth": (),
        "QCalendarWidget.showPreviousYear": (),
        "QCalendarWidget.showSelectedDate": (),
        "QCalendarWidget.showToday": (),
        "QCalendarWidget.sizeHint": (),
        "QCalendarWidget.updateCell": ('PySide2.QtCore.QDate',),
        "QCalendarWidget.updateCells": (),
        "QCalendarWidget.verticalHeaderFormat": (),
        "QCalendarWidget.weekdayTextFormat": ('PySide2.QtCore.Qt.DayOfWeek',),
        "QCalendarWidget.yearShown": (),

    # class PySide2.QtWidgets.QCheckBox:
        "QCheckBox.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
        "QCheckBox.checkState": (),
        "QCheckBox.checkStateSet": (),
        "QCheckBox.event": ('PySide2.QtCore.QEvent',),
        "QCheckBox.hitButton": ('PySide2.QtCore.QPoint',),
        "QCheckBox.initStyleOption": ('PySide2.QtWidgets.QStyleOptionButton',),
        "QCheckBox.isTristate": (),
        "QCheckBox.minimumSizeHint": (),
        "QCheckBox.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QCheckBox.nextCheckState": (),
        "QCheckBox.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QCheckBox.setCheckState": ('PySide2.QtCore.Qt.CheckState',),
        "QCheckBox.setTristate": ('bool',),
        "QCheckBox.sizeHint": (),

    # class PySide2.QtWidgets.QColorDialog:
        "QColorDialog.__init__": [('PySide2.QtGui.QColor', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
        "QColorDialog.changeEvent": ('PySide2.QtCore.QEvent',),
        "QColorDialog.currentColor": (),
        "QColorDialog.customColor": ('int',),
        "QColorDialog.customCount": (),
        "QColorDialog.done": ('int',),
        "QColorDialog.getColor": ('PySide2.QtGui.QColor', 'PySide2.QtWidgets.QWidget', 'str', 'PySide2.QtWidgets.QColorDialog.ColorDialogOptions'),
        "QColorDialog.open": [(), ('PySide2.QtCore.QObject', 'str')],
        "QColorDialog.options": (),
        "QColorDialog.selectedColor": (),
        "QColorDialog.setCurrentColor": ('PySide2.QtGui.QColor',),
        "QColorDialog.setCustomColor": ('int', 'PySide2.QtGui.QColor'),
        "QColorDialog.setOption": ('PySide2.QtWidgets.QColorDialog.ColorDialogOption', 'bool'),
        "QColorDialog.setOptions": ('PySide2.QtWidgets.QColorDialog.ColorDialogOptions',),
        "QColorDialog.setStandardColor": ('int', 'PySide2.QtGui.QColor'),
        "QColorDialog.setVisible": ('bool',),
        "QColorDialog.standardColor": ('int',),
        "QColorDialog.testOption": ('PySide2.QtWidgets.QColorDialog.ColorDialogOption',),

    # class PySide2.QtWidgets.QColormap:
        "QColormap.__init__": ('PySide2.QtWidgets.QColormap',),
        "QColormap.__copy__": (),
        "QColormap.cleanup": (),
        "QColormap.colorAt": ('int',),
        "QColormap.colormap": (),
        "QColormap.depth": (),
        "QColormap.initialize": (),
        "QColormap.instance": ('int',),
        "QColormap.mode": (),
        "QColormap.pixel": ('PySide2.QtGui.QColor',),
        "QColormap.size": (),

    # class PySide2.QtWidgets.QColumnView:
        "QColumnView.__init__": ('PySide2.QtWidgets.QWidget',),
        "QColumnView.columnWidths": (),
        "QColumnView.createColumn": ('PySide2.QtCore.QModelIndex',),
        "QColumnView.currentChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
        "QColumnView.horizontalOffset": (),
        "QColumnView.indexAt": ('PySide2.QtCore.QPoint',),
        "QColumnView.initializeColumn": ('PySide2.QtWidgets.QAbstractItemView',),
        "QColumnView.isIndexHidden": ('PySide2.QtCore.QModelIndex',),
        "QColumnView.moveCursor": ('PySide2.QtWidgets.QAbstractItemView.CursorAction', 'PySide2.QtCore.Qt.KeyboardModifiers'),
        "QColumnView.previewWidget": (),
        "QColumnView.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QColumnView.resizeGripsVisible": (),
        "QColumnView.rowsInserted": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QColumnView.scrollContentsBy": ('int', 'int'),
        "QColumnView.scrollTo": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
        "QColumnView.selectAll": (),
        "QColumnView.setColumnWidths": ('list',),
        "QColumnView.setModel": ('PySide2.QtCore.QAbstractItemModel',),
        "QColumnView.setPreviewWidget": ('PySide2.QtWidgets.QWidget',),
        "QColumnView.setResizeGripsVisible": ('bool',),
        "QColumnView.setRootIndex": ('PySide2.QtCore.QModelIndex',),
        "QColumnView.setSelection": ('PySide2.QtCore.QRect', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
        "QColumnView.setSelectionModel": ('PySide2.QtCore.QItemSelectionModel',),
        "QColumnView.sizeHint": (),
        "QColumnView.verticalOffset": (),
        "QColumnView.visualRect": ('PySide2.QtCore.QModelIndex',),
        "QColumnView.visualRegionForSelection": ('PySide2.QtCore.QItemSelection',),

    # class PySide2.QtWidgets.QComboBox:
        "QComboBox.__init__": ('PySide2.QtWidgets.QWidget',),
        "QComboBox.addItem": [('PySide2.QtGui.QIcon', 'str', 'typing.Any'), ('str', 'typing.Any')],
        "QComboBox.addItems": ('typing.List[str]',),
        "QComboBox.autoCompletion": (),
        "QComboBox.autoCompletionCaseSensitivity": (),
        "QComboBox.changeEvent": ('PySide2.QtCore.QEvent',),
        "QComboBox.clear": (),
        "QComboBox.clearEditText": (),
        "QComboBox.completer": (),
        "QComboBox.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
        "QComboBox.count": (),
        "QComboBox.currentData": ('int',),
        "QComboBox.currentIndex": (),
        "QComboBox.currentText": (),
        "QComboBox.duplicatesEnabled": (),
        "QComboBox.event": ('PySide2.QtCore.QEvent',),
        "QComboBox.findData": ('typing.Any', 'int', 'PySide2.QtCore.Qt.MatchFlags'),
        "QComboBox.findText": ('str', 'PySide2.QtCore.Qt.MatchFlags'),
        "QComboBox.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QComboBox.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QComboBox.hasFrame": (),
        "QComboBox.hideEvent": ('PySide2.QtGui.QHideEvent',),
        "QComboBox.hidePopup": (),
        "QComboBox.iconSize": (),
        "QComboBox.initStyleOption": ('PySide2.QtWidgets.QStyleOptionComboBox',),
        "QComboBox.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
        "QComboBox.inputMethodQuery": [('PySide2.QtCore.Qt.InputMethodQuery',), ('PySide2.QtCore.Qt.InputMethodQuery', 'typing.Any')],
        "QComboBox.insertItem": [('int', 'PySide2.QtGui.QIcon', 'str', 'typing.Any'), ('int', 'str', 'typing.Any')],
        "QComboBox.insertItems": ('int', 'typing.List[str]'),
        "QComboBox.insertPolicy": (),
        "QComboBox.insertSeparator": ('int',),
        "QComboBox.isEditable": (),
        "QComboBox.itemData": ('int', 'int'),
        "QComboBox.itemDelegate": (),
        "QComboBox.itemIcon": ('int',),
        "QComboBox.itemText": ('int',),
        "QComboBox.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QComboBox.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
        "QComboBox.lineEdit": (),
        "QComboBox.maxCount": (),
        "QComboBox.maxVisibleItems": (),
        "QComboBox.minimumContentsLength": (),
        "QComboBox.minimumSizeHint": (),
        "QComboBox.model": (),
        "QComboBox.modelColumn": (),
        "QComboBox.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QComboBox.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QComboBox.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QComboBox.removeItem": ('int',),
        "QComboBox.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QComboBox.rootModelIndex": (),
        "QComboBox.setAutoCompletion": ('bool',),
        "QComboBox.setAutoCompletionCaseSensitivity": ('PySide2.QtCore.Qt.CaseSensitivity',),
        "QComboBox.setCompleter": ('PySide2.QtWidgets.QCompleter',),
        "QComboBox.setCurrentIndex": ('int',),
        "QComboBox.setCurrentText": ('str',),
        "QComboBox.setDuplicatesEnabled": ('bool',),
        "QComboBox.setEditText": ('str',),
        "QComboBox.setEditable": ('bool',),
        "QComboBox.setFrame": ('bool',),
        "QComboBox.setIconSize": ('PySide2.QtCore.QSize',),
        "QComboBox.setInsertPolicy": ('PySide2.QtWidgets.QComboBox.InsertPolicy',),
        "QComboBox.setItemData": ('int', 'typing.Any', 'int'),
        "QComboBox.setItemDelegate": ('PySide2.QtWidgets.QAbstractItemDelegate',),
        "QComboBox.setItemIcon": ('int', 'PySide2.QtGui.QIcon'),
        "QComboBox.setItemText": ('int', 'str'),
        "QComboBox.setLineEdit": ('PySide2.QtWidgets.QLineEdit',),
        "QComboBox.setMaxCount": ('int',),
        "QComboBox.setMaxVisibleItems": ('int',),
        "QComboBox.setMinimumContentsLength": ('int',),
        "QComboBox.setModel": ('PySide2.QtCore.QAbstractItemModel',),
        "QComboBox.setModelColumn": ('int',),
        "QComboBox.setRootModelIndex": ('PySide2.QtCore.QModelIndex',),
        "QComboBox.setSizeAdjustPolicy": ('PySide2.QtWidgets.QComboBox.SizeAdjustPolicy',),
        "QComboBox.setValidator": ('PySide2.QtGui.QValidator',),
        "QComboBox.setView": ('PySide2.QtWidgets.QAbstractItemView',),
        "QComboBox.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QComboBox.showPopup": (),
        "QComboBox.sizeAdjustPolicy": (),
        "QComboBox.sizeHint": (),
        "QComboBox.validator": (),
        "QComboBox.view": (),
        "QComboBox.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

    # class PySide2.QtWidgets.QCommandLinkButton:
        "QCommandLinkButton.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget'), ('str', 'str', 'PySide2.QtWidgets.QWidget')],
        "QCommandLinkButton.description": (),
        "QCommandLinkButton.event": ('PySide2.QtCore.QEvent',),
        "QCommandLinkButton.heightForWidth": ('int',),
        "QCommandLinkButton.minimumSizeHint": (),
        "QCommandLinkButton.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QCommandLinkButton.setDescription": ('str',),
        "QCommandLinkButton.sizeHint": (),

    # class PySide2.QtWidgets.QCommonStyle:
        "QCommonStyle.__init__": (),
        "QCommonStyle.drawComplexControl": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
        "QCommonStyle.drawControl": ('PySide2.QtWidgets.QStyle.ControlElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
        "QCommonStyle.drawPrimitive": ('PySide2.QtWidgets.QStyle.PrimitiveElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
        "QCommonStyle.generatedIconPixmap": ('PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QPixmap', 'PySide2.QtWidgets.QStyleOption'),
        "QCommonStyle.hitTestComplexControl": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QWidget'),
        "QCommonStyle.layoutSpacing": ('PySide2.QtWidgets.QSizePolicy.ControlType', 'PySide2.QtWidgets.QSizePolicy.ControlType', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QCommonStyle.pixelMetric": ('PySide2.QtWidgets.QStyle.PixelMetric', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QCommonStyle.polish": [('PySide2.QtGui.QPalette',), ('PySide2.QtWidgets.QApplication',), ('PySide2.QtWidgets.QWidget',)],
        "QCommonStyle.sizeFromContents": ('PySide2.QtWidgets.QStyle.ContentsType', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtCore.QSize', 'PySide2.QtWidgets.QWidget'),
        "QCommonStyle.standardIcon": ('PySide2.QtWidgets.QStyle.StandardPixmap', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QCommonStyle.standardPixmap": ('PySide2.QtWidgets.QStyle.StandardPixmap', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QCommonStyle.styleHint": ('PySide2.QtWidgets.QStyle.StyleHint', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleHintReturn'),
        "QCommonStyle.subControlRect": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtWidgets.QStyle.SubControl', 'PySide2.QtWidgets.QWidget'),
        "QCommonStyle.subElementRect": ('PySide2.QtWidgets.QStyle.SubElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QCommonStyle.unpolish": [('PySide2.QtWidgets.QApplication',), ('PySide2.QtWidgets.QWidget',)],

    # class PySide2.QtWidgets.QCompleter:
        "QCompleter.__init__": [('PySide2.QtCore.QAbstractItemModel', 'PySide2.QtCore.QObject'), ('PySide2.QtCore.QObject',), ('typing.List[str]', 'PySide2.QtCore.QObject')],
        "QCompleter.caseSensitivity": (),
        "QCompleter.complete": ('PySide2.QtCore.QRect',),
        "QCompleter.completionColumn": (),
        "QCompleter.completionCount": (),
        "QCompleter.completionMode": (),
        "QCompleter.completionModel": (),
        "QCompleter.completionPrefix": (),
        "QCompleter.completionRole": (),
        "QCompleter.currentCompletion": (),
        "QCompleter.currentIndex": (),
        "QCompleter.currentRow": (),
        "QCompleter.event": ('PySide2.QtCore.QEvent',),
        "QCompleter.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QCompleter.filterMode": (),
        "QCompleter.maxVisibleItems": (),
        "QCompleter.model": (),
        "QCompleter.modelSorting": (),
        "QCompleter.pathFromIndex": ('PySide2.QtCore.QModelIndex',),
        "QCompleter.popup": (),
        "QCompleter.setCaseSensitivity": ('PySide2.QtCore.Qt.CaseSensitivity',),
        "QCompleter.setCompletionColumn": ('int',),
        "QCompleter.setCompletionMode": ('PySide2.QtWidgets.QCompleter.CompletionMode',),
        "QCompleter.setCompletionPrefix": ('str',),
        "QCompleter.setCompletionRole": ('int',),
        "QCompleter.setCurrentRow": ('int',),
        "QCompleter.setFilterMode": ('PySide2.QtCore.Qt.MatchFlags',),
        "QCompleter.setMaxVisibleItems": ('int',),
        "QCompleter.setModel": ('PySide2.QtCore.QAbstractItemModel',),
        "QCompleter.setModelSorting": ('PySide2.QtWidgets.QCompleter.ModelSorting',),
        "QCompleter.setPopup": ('PySide2.QtWidgets.QAbstractItemView',),
        "QCompleter.setWidget": ('PySide2.QtWidgets.QWidget',),
        "QCompleter.setWrapAround": ('bool',),
        "QCompleter.splitPath": ('str',),
        "QCompleter.widget": (),
        "QCompleter.wrapAround": (),

    # class PySide2.QtWidgets.QDataWidgetMapper:
        "QDataWidgetMapper.__init__": ('PySide2.QtCore.QObject',),
        "QDataWidgetMapper.addMapping": [('PySide2.QtWidgets.QWidget', 'int'), ('PySide2.QtWidgets.QWidget', 'int', 'PySide2.QtCore.QByteArray')],
        "QDataWidgetMapper.clearMapping": (),
        "QDataWidgetMapper.currentIndex": (),
        "QDataWidgetMapper.itemDelegate": (),
        "QDataWidgetMapper.mappedPropertyName": ('PySide2.QtWidgets.QWidget',),
        "QDataWidgetMapper.mappedSection": ('PySide2.QtWidgets.QWidget',),
        "QDataWidgetMapper.mappedWidgetAt": ('int',),
        "QDataWidgetMapper.model": (),
        "QDataWidgetMapper.orientation": (),
        "QDataWidgetMapper.removeMapping": ('PySide2.QtWidgets.QWidget',),
        "QDataWidgetMapper.revert": (),
        "QDataWidgetMapper.rootIndex": (),
        "QDataWidgetMapper.setCurrentIndex": ('int',),
        "QDataWidgetMapper.setCurrentModelIndex": ('PySide2.QtCore.QModelIndex',),
        "QDataWidgetMapper.setItemDelegate": ('PySide2.QtWidgets.QAbstractItemDelegate',),
        "QDataWidgetMapper.setModel": ('PySide2.QtCore.QAbstractItemModel',),
        "QDataWidgetMapper.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
        "QDataWidgetMapper.setRootIndex": ('PySide2.QtCore.QModelIndex',),
        "QDataWidgetMapper.setSubmitPolicy": ('PySide2.QtWidgets.QDataWidgetMapper.SubmitPolicy',),
        "QDataWidgetMapper.submit": (),
        "QDataWidgetMapper.submitPolicy": (),
        "QDataWidgetMapper.toFirst": (),
        "QDataWidgetMapper.toLast": (),
        "QDataWidgetMapper.toNext": (),
        "QDataWidgetMapper.toPrevious": (),

    # class PySide2.QtWidgets.QDateEdit:
        "QDateEdit.__init__": [('PySide2.QtCore.QDate', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],

    # class PySide2.QtWidgets.QDateTimeEdit:
        "QDateTimeEdit.__init__": [('PySide2.QtCore.QDate', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtCore.QDateTime', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtCore.QTime', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',), ('typing.Any', 'type', 'PySide2.QtWidgets.QWidget')],
        "QDateTimeEdit.calendarPopup": (),
        "QDateTimeEdit.calendarWidget": (),
        "QDateTimeEdit.clear": (),
        "QDateTimeEdit.clearMaximumDate": (),
        "QDateTimeEdit.clearMaximumDateTime": (),
        "QDateTimeEdit.clearMaximumTime": (),
        "QDateTimeEdit.clearMinimumDate": (),
        "QDateTimeEdit.clearMinimumDateTime": (),
        "QDateTimeEdit.clearMinimumTime": (),
        "QDateTimeEdit.currentSection": (),
        "QDateTimeEdit.currentSectionIndex": (),
        "QDateTimeEdit.date": (),
        "QDateTimeEdit.dateTime": (),
        "QDateTimeEdit.dateTimeFromText": ('str',),
        "QDateTimeEdit.displayFormat": (),
        "QDateTimeEdit.displayedSections": (),
        "QDateTimeEdit.event": ('PySide2.QtCore.QEvent',),
        "QDateTimeEdit.fixup": ('str',),
        "QDateTimeEdit.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QDateTimeEdit.focusNextPrevChild": ('bool',),
        "QDateTimeEdit.initStyleOption": ('PySide2.QtWidgets.QStyleOptionSpinBox',),
        "QDateTimeEdit.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QDateTimeEdit.maximumDate": (),
        "QDateTimeEdit.maximumDateTime": (),
        "QDateTimeEdit.maximumTime": (),
        "QDateTimeEdit.minimumDate": (),
        "QDateTimeEdit.minimumDateTime": (),
        "QDateTimeEdit.minimumTime": (),
        "QDateTimeEdit.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QDateTimeEdit.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QDateTimeEdit.sectionAt": ('int',),
        "QDateTimeEdit.sectionCount": (),
        "QDateTimeEdit.sectionText": ('PySide2.QtWidgets.QDateTimeEdit.Section',),
        "QDateTimeEdit.setCalendarPopup": ('bool',),
        "QDateTimeEdit.setCalendarWidget": ('PySide2.QtWidgets.QCalendarWidget',),
        "QDateTimeEdit.setCurrentSection": ('PySide2.QtWidgets.QDateTimeEdit.Section',),
        "QDateTimeEdit.setCurrentSectionIndex": ('int',),
        "QDateTimeEdit.setDate": ('PySide2.QtCore.QDate',),
        "QDateTimeEdit.setDateRange": ('PySide2.QtCore.QDate', 'PySide2.QtCore.QDate'),
        "QDateTimeEdit.setDateTime": ('PySide2.QtCore.QDateTime',),
        "QDateTimeEdit.setDateTimeRange": ('PySide2.QtCore.QDateTime', 'PySide2.QtCore.QDateTime'),
        "QDateTimeEdit.setDisplayFormat": ('str',),
        "QDateTimeEdit.setMaximumDate": ('PySide2.QtCore.QDate',),
        "QDateTimeEdit.setMaximumDateTime": ('PySide2.QtCore.QDateTime',),
        "QDateTimeEdit.setMaximumTime": ('PySide2.QtCore.QTime',),
        "QDateTimeEdit.setMinimumDate": ('PySide2.QtCore.QDate',),
        "QDateTimeEdit.setMinimumDateTime": ('PySide2.QtCore.QDateTime',),
        "QDateTimeEdit.setMinimumTime": ('PySide2.QtCore.QTime',),
        "QDateTimeEdit.setSelectedSection": ('PySide2.QtWidgets.QDateTimeEdit.Section',),
        "QDateTimeEdit.setTime": ('PySide2.QtCore.QTime',),
        "QDateTimeEdit.setTimeRange": ('PySide2.QtCore.QTime', 'PySide2.QtCore.QTime'),
        "QDateTimeEdit.setTimeSpec": ('PySide2.QtCore.Qt.TimeSpec',),
        "QDateTimeEdit.sizeHint": (),
        "QDateTimeEdit.stepBy": ('int',),
        "QDateTimeEdit.stepEnabled": (),
        "QDateTimeEdit.textFromDateTime": ('PySide2.QtCore.QDateTime',),
        "QDateTimeEdit.time": (),
        "QDateTimeEdit.timeSpec": (),
        "QDateTimeEdit.validate": ('str', 'int'),
        "QDateTimeEdit.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

    # class PySide2.QtWidgets.QDesktopWidget:
        "QDesktopWidget.__init__": (),
        "QDesktopWidget.availableGeometry": [('PySide2.QtCore.QPoint',), ('PySide2.QtWidgets.QWidget',), ('int',)],
        "QDesktopWidget.isVirtualDesktop": (),
        "QDesktopWidget.numScreens": (),
        "QDesktopWidget.primaryScreen": (),
        "QDesktopWidget.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QDesktopWidget.screen": ('int',),
        "QDesktopWidget.screenCount": (),
        "QDesktopWidget.screenGeometry": [('PySide2.QtCore.QPoint',), ('PySide2.QtWidgets.QWidget',), ('int',)],
        "QDesktopWidget.screenNumber": [('PySide2.QtCore.QPoint',), ('PySide2.QtWidgets.QWidget',)],

    # class PySide2.QtWidgets.QDial:
        "QDial.__init__": ('PySide2.QtWidgets.QWidget',),
        "QDial.event": ('PySide2.QtCore.QEvent',),
        "QDial.initStyleOption": ('PySide2.QtWidgets.QStyleOptionSlider',),
        "QDial.minimumSizeHint": (),
        "QDial.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QDial.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QDial.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QDial.notchSize": (),
        "QDial.notchTarget": (),
        "QDial.notchesVisible": (),
        "QDial.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QDial.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QDial.setNotchTarget": ('float',),
        "QDial.setNotchesVisible": ('bool',),
        "QDial.setWrapping": ('bool',),
        "QDial.sizeHint": (),
        "QDial.sliderChange": ('PySide2.QtWidgets.QAbstractSlider.SliderChange',),
        "QDial.wrapping": (),

    # class PySide2.QtWidgets.QDialog:
        "QDialog.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
        "QDialog.accept": (),
        "QDialog.adjustPosition": ('PySide2.QtWidgets.QWidget',),
        "QDialog.closeEvent": ('PySide2.QtGui.QCloseEvent',),
        "QDialog.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
        "QDialog.done": ('int',),
        "QDialog.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QDialog.exec_": (),
        "QDialog.extension": (),
        "QDialog.isSizeGripEnabled": (),
        "QDialog.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QDialog.minimumSizeHint": (),
        "QDialog.open": (),
        "QDialog.orientation": (),
        "QDialog.reject": (),
        "QDialog.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QDialog.result": (),
        "QDialog.setExtension": ('PySide2.QtWidgets.QWidget',),
        "QDialog.setModal": ('bool',),
        "QDialog.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
        "QDialog.setResult": ('int',),
        "QDialog.setSizeGripEnabled": ('bool',),
        "QDialog.setVisible": ('bool',),
        "QDialog.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QDialog.showExtension": ('bool',),
        "QDialog.sizeHint": (),

    # class PySide2.QtWidgets.QDialogButtonBox:
        "QDialogButtonBox.__init__": [('PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QDialogButtonBox.StandardButtons', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QDialogButtonBox.StandardButtons', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
        "QDialogButtonBox.addButton": [('PySide2.QtWidgets.QAbstractButton', 'PySide2.QtWidgets.QDialogButtonBox.ButtonRole'), ('PySide2.QtWidgets.QDialogButtonBox.StandardButton',), ('str', 'PySide2.QtWidgets.QDialogButtonBox.ButtonRole')],
        "QDialogButtonBox.button": ('PySide2.QtWidgets.QDialogButtonBox.StandardButton',),
        "QDialogButtonBox.buttonRole": ('PySide2.QtWidgets.QAbstractButton',),
        "QDialogButtonBox.buttons": (),
        "QDialogButtonBox.centerButtons": (),
        "QDialogButtonBox.changeEvent": ('PySide2.QtCore.QEvent',),
        "QDialogButtonBox.clear": (),
        "QDialogButtonBox.event": ('PySide2.QtCore.QEvent',),
        "QDialogButtonBox.orientation": (),
        "QDialogButtonBox.removeButton": ('PySide2.QtWidgets.QAbstractButton',),
        "QDialogButtonBox.setCenterButtons": ('bool',),
        "QDialogButtonBox.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
        "QDialogButtonBox.setStandardButtons": ('PySide2.QtWidgets.QDialogButtonBox.StandardButtons',),
        "QDialogButtonBox.standardButton": ('PySide2.QtWidgets.QAbstractButton',),
        "QDialogButtonBox.standardButtons": (),

    # class PySide2.QtWidgets.QDirModel:
        "QDirModel.__init__": [('PySide2.QtCore.QObject',), ('typing.List[str]', 'PySide2.QtCore.QDir.Filters', 'PySide2.QtCore.QDir.SortFlags', 'PySide2.QtCore.QObject')],
        "QDirModel.columnCount": ('PySide2.QtCore.QModelIndex',),
        "QDirModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
        "QDirModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QDirModel.fileIcon": ('PySide2.QtCore.QModelIndex',),
        "QDirModel.fileInfo": ('PySide2.QtCore.QModelIndex',),
        "QDirModel.fileName": ('PySide2.QtCore.QModelIndex',),
        "QDirModel.filePath": ('PySide2.QtCore.QModelIndex',),
        "QDirModel.filter": (),
        "QDirModel.flags": ('PySide2.QtCore.QModelIndex',),
        "QDirModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
        "QDirModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
        "QDirModel.iconProvider": (),
        "QDirModel.index": [('int', 'int', 'PySide2.QtCore.QModelIndex'), ('str', 'int')],
        "QDirModel.isDir": ('PySide2.QtCore.QModelIndex',),
        "QDirModel.isReadOnly": (),
        "QDirModel.lazyChildCount": (),
        "QDirModel.mimeData": ('typing.List[int]',),
        "QDirModel.mimeTypes": (),
        "QDirModel.mkdir": ('PySide2.QtCore.QModelIndex', 'str'),
        "QDirModel.nameFilters": (),
        "QDirModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
        "QDirModel.refresh": ('PySide2.QtCore.QModelIndex',),
        "QDirModel.remove": ('PySide2.QtCore.QModelIndex',),
        "QDirModel.resolveSymlinks": (),
        "QDirModel.rmdir": ('PySide2.QtCore.QModelIndex',),
        "QDirModel.rowCount": ('PySide2.QtCore.QModelIndex',),
        "QDirModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
        "QDirModel.setFilter": ('PySide2.QtCore.QDir.Filters',),
        "QDirModel.setIconProvider": ('PySide2.QtWidgets.QFileIconProvider',),
        "QDirModel.setLazyChildCount": ('bool',),
        "QDirModel.setNameFilters": ('typing.List[str]',),
        "QDirModel.setReadOnly": ('bool',),
        "QDirModel.setResolveSymlinks": ('bool',),
        "QDirModel.setSorting": ('PySide2.QtCore.QDir.SortFlags',),
        "QDirModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
        "QDirModel.sorting": (),
        "QDirModel.supportedDropActions": (),

    # class PySide2.QtWidgets.QDockWidget:
        "QDockWidget.__init__": [('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('str', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags')],
        "QDockWidget.allowedAreas": (),
        "QDockWidget.changeEvent": ('PySide2.QtCore.QEvent',),
        "QDockWidget.closeEvent": ('PySide2.QtGui.QCloseEvent',),
        "QDockWidget.event": ('PySide2.QtCore.QEvent',),
        "QDockWidget.features": (),
        "QDockWidget.initStyleOption": ('PySide2.QtWidgets.QStyleOptionDockWidget',),
        "QDockWidget.isAreaAllowed": ('PySide2.QtCore.Qt.DockWidgetArea',),
        "QDockWidget.isFloating": (),
        "QDockWidget.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QDockWidget.setAllowedAreas": ('PySide2.QtCore.Qt.DockWidgetAreas',),
        "QDockWidget.setFeatures": ('PySide2.QtWidgets.QDockWidget.DockWidgetFeatures',),
        "QDockWidget.setFloating": ('bool',),
        "QDockWidget.setTitleBarWidget": ('PySide2.QtWidgets.QWidget',),
        "QDockWidget.setWidget": ('PySide2.QtWidgets.QWidget',),
        "QDockWidget.titleBarWidget": (),
        "QDockWidget.toggleViewAction": (),
        "QDockWidget.widget": (),

    # class PySide2.QtWidgets.QDoubleSpinBox:
        "QDoubleSpinBox.__init__": ('PySide2.QtWidgets.QWidget',),
        "QDoubleSpinBox.cleanText": (),
        "QDoubleSpinBox.decimals": (),
        "QDoubleSpinBox.fixup": ('str',),
        "QDoubleSpinBox.maximum": (),
        "QDoubleSpinBox.minimum": (),
        "QDoubleSpinBox.prefix": (),
        "QDoubleSpinBox.setDecimals": ('int',),
        "QDoubleSpinBox.setMaximum": ('float',),
        "QDoubleSpinBox.setMinimum": ('float',),
        "QDoubleSpinBox.setPrefix": ('str',),
        "QDoubleSpinBox.setRange": ('float', 'float'),
        "QDoubleSpinBox.setSingleStep": ('float',),
        "QDoubleSpinBox.setStepType": ('PySide2.QtWidgets.QAbstractSpinBox.StepType',),
        "QDoubleSpinBox.setSuffix": ('str',),
        "QDoubleSpinBox.setValue": ('float',),
        "QDoubleSpinBox.singleStep": (),
        "QDoubleSpinBox.stepType": (),
        "QDoubleSpinBox.suffix": (),
        "QDoubleSpinBox.textFromValue": ('float',),
        "QDoubleSpinBox.validate": ('str', 'int'),
        "QDoubleSpinBox.value": (),
        "QDoubleSpinBox.valueFromText": ('str',),

    # class PySide2.QtWidgets.QErrorMessage:
        "QErrorMessage.__init__": ('PySide2.QtWidgets.QWidget',),
        "QErrorMessage.changeEvent": ('PySide2.QtCore.QEvent',),
        "QErrorMessage.done": ('int',),
        "QErrorMessage.qtHandler": (),
        "QErrorMessage.showMessage": [('str',), ('str', 'str')],

    # class PySide2.QtWidgets.QFileDialog:
        "QFileDialog.__init__": [('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('PySide2.QtWidgets.QWidget', 'str', 'str', 'str')],
        "QFileDialog.accept": (),
        "QFileDialog.acceptMode": (),
        "QFileDialog.changeEvent": ('PySide2.QtCore.QEvent',),
        "QFileDialog.confirmOverwrite": (),
        "QFileDialog.defaultSuffix": (),
        "QFileDialog.directory": (),
        "QFileDialog.directoryUrl": (),
        "QFileDialog.done": ('int',),
        "QFileDialog.fileMode": (),
        "QFileDialog.filter": (),
        "QFileDialog.getExistingDirectory": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QFileDialog.Options'),
        "QFileDialog.getExistingDirectoryUrl": ('PySide2.QtWidgets.QWidget', 'str', 'PySide2.QtCore.QUrl', 'PySide2.QtWidgets.QFileDialog.Options', 'typing.List[str]'),
        "QFileDialog.getOpenFileName": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'str', 'str', 'PySide2.QtWidgets.QFileDialog.Options'),
        "QFileDialog.getOpenFileNames": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'str', 'str', 'PySide2.QtWidgets.QFileDialog.Options'),
        "QFileDialog.getOpenFileUrl": ('PySide2.QtWidgets.QWidget', 'str', 'PySide2.QtCore.QUrl', 'str', 'str', 'PySide2.QtWidgets.QFileDialog.Options', 'typing.List[str]'),
        "QFileDialog.getOpenFileUrls": ('PySide2.QtWidgets.QWidget', 'str', 'PySide2.QtCore.QUrl', 'str', 'str', 'PySide2.QtWidgets.QFileDialog.Options', 'typing.List[str]'),
        "QFileDialog.getSaveFileName": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'str', 'str', 'PySide2.QtWidgets.QFileDialog.Options'),
        "QFileDialog.getSaveFileUrl": ('PySide2.QtWidgets.QWidget', 'str', 'PySide2.QtCore.QUrl', 'str', 'str', 'PySide2.QtWidgets.QFileDialog.Options', 'typing.List[str]'),
        "QFileDialog.history": (),
        "QFileDialog.iconProvider": (),
        "QFileDialog.isNameFilterDetailsVisible": (),
        "QFileDialog.isReadOnly": (),
        "QFileDialog.itemDelegate": (),
        "QFileDialog.labelText": ('PySide2.QtWidgets.QFileDialog.DialogLabel',),
        "QFileDialog.mimeTypeFilters": (),
        "QFileDialog.nameFilters": (),
        "QFileDialog.open": [(), ('PySide2.QtCore.QObject', 'str')],
        "QFileDialog.options": (),
        "QFileDialog.proxyModel": (),
        "QFileDialog.resolveSymlinks": (),
        "QFileDialog.restoreState": ('PySide2.QtCore.QByteArray',),
        "QFileDialog.saveState": (),
        "QFileDialog.selectFile": ('str',),
        "QFileDialog.selectMimeTypeFilter": ('str',),
        "QFileDialog.selectNameFilter": ('str',),
        "QFileDialog.selectUrl": ('PySide2.QtCore.QUrl',),
        "QFileDialog.selectedFiles": (),
        "QFileDialog.selectedMimeTypeFilter": (),
        "QFileDialog.selectedNameFilter": (),
        "QFileDialog.selectedUrls": (),
        "QFileDialog.setAcceptMode": ('PySide2.QtWidgets.QFileDialog.AcceptMode',),
        "QFileDialog.setConfirmOverwrite": ('bool',),
        "QFileDialog.setDefaultSuffix": ('str',),
        "QFileDialog.setDirectory": [('PySide2.QtCore.QDir',), ('str',)],
        "QFileDialog.setDirectoryUrl": ('PySide2.QtCore.QUrl',),
        "QFileDialog.setFileMode": ('PySide2.QtWidgets.QFileDialog.FileMode',),
        "QFileDialog.setFilter": ('PySide2.QtCore.QDir.Filters',),
        "QFileDialog.setHistory": ('typing.List[str]',),
        "QFileDialog.setIconProvider": ('PySide2.QtWidgets.QFileIconProvider',),
        "QFileDialog.setItemDelegate": ('PySide2.QtWidgets.QAbstractItemDelegate',),
        "QFileDialog.setLabelText": ('PySide2.QtWidgets.QFileDialog.DialogLabel', 'str'),
        "QFileDialog.setMimeTypeFilters": ('typing.List[str]',),
        "QFileDialog.setNameFilter": ('str',),
        "QFileDialog.setNameFilterDetailsVisible": ('bool',),
        "QFileDialog.setNameFilters": ('typing.List[str]',),
        "QFileDialog.setOption": ('PySide2.QtWidgets.QFileDialog.Option', 'bool'),
        "QFileDialog.setOptions": ('PySide2.QtWidgets.QFileDialog.Options',),
        "QFileDialog.setProxyModel": ('PySide2.QtCore.QAbstractProxyModel',),
        "QFileDialog.setReadOnly": ('bool',),
        "QFileDialog.setResolveSymlinks": ('bool',),
        "QFileDialog.setSidebarUrls": ('list',),
        "QFileDialog.setSupportedSchemes": ('typing.List[str]',),
        "QFileDialog.setViewMode": ('PySide2.QtWidgets.QFileDialog.ViewMode',),
        "QFileDialog.setVisible": ('bool',),
        "QFileDialog.sidebarUrls": (),
        "QFileDialog.supportedSchemes": (),
        "QFileDialog.testOption": ('PySide2.QtWidgets.QFileDialog.Option',),
        "QFileDialog.viewMode": (),

    # class PySide2.QtWidgets.QFileIconProvider:
        "QFileIconProvider.__init__": (),
        "QFileIconProvider.icon": [('PySide2.QtCore.QFileInfo',), ('PySide2.QtWidgets.QFileIconProvider.IconType',)],
        "QFileIconProvider.options": (),
        "QFileIconProvider.setOptions": ('PySide2.QtWidgets.QFileIconProvider.Options',),
        "QFileIconProvider.type": ('PySide2.QtCore.QFileInfo',),

    # class PySide2.QtWidgets.QFileSystemModel:
        "QFileSystemModel.__init__": ('PySide2.QtCore.QObject',),
        "QFileSystemModel.canFetchMore": ('PySide2.QtCore.QModelIndex',),
        "QFileSystemModel.columnCount": ('PySide2.QtCore.QModelIndex',),
        "QFileSystemModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
        "QFileSystemModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QFileSystemModel.event": ('PySide2.QtCore.QEvent',),
        "QFileSystemModel.fetchMore": ('PySide2.QtCore.QModelIndex',),
        "QFileSystemModel.fileIcon": ('PySide2.QtCore.QModelIndex',),
        "QFileSystemModel.fileInfo": ('PySide2.QtCore.QModelIndex',),
        "QFileSystemModel.fileName": ('PySide2.QtCore.QModelIndex',),
        "QFileSystemModel.filePath": ('PySide2.QtCore.QModelIndex',),
        "QFileSystemModel.filter": (),
        "QFileSystemModel.flags": ('PySide2.QtCore.QModelIndex',),
        "QFileSystemModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
        "QFileSystemModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
        "QFileSystemModel.iconProvider": (),
        "QFileSystemModel.index": [('int', 'int', 'PySide2.QtCore.QModelIndex'), ('str', 'int')],
        "QFileSystemModel.isDir": ('PySide2.QtCore.QModelIndex',),
        "QFileSystemModel.isReadOnly": (),
        "QFileSystemModel.lastModified": ('PySide2.QtCore.QModelIndex',),
        "QFileSystemModel.mimeData": ('typing.List[int]',),
        "QFileSystemModel.mimeTypes": (),
        "QFileSystemModel.mkdir": ('PySide2.QtCore.QModelIndex', 'str'),
        "QFileSystemModel.myComputer": ('int',),
        "QFileSystemModel.nameFilterDisables": (),
        "QFileSystemModel.nameFilters": (),
        "QFileSystemModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
        "QFileSystemModel.remove": ('PySide2.QtCore.QModelIndex',),
        "QFileSystemModel.resolveSymlinks": (),
        "QFileSystemModel.rmdir": ('PySide2.QtCore.QModelIndex',),
        "QFileSystemModel.rootDirectory": (),
        "QFileSystemModel.rootPath": (),
        "QFileSystemModel.rowCount": ('PySide2.QtCore.QModelIndex',),
        "QFileSystemModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
        "QFileSystemModel.setFilter": ('PySide2.QtCore.QDir.Filters',),
        "QFileSystemModel.setIconProvider": ('PySide2.QtWidgets.QFileIconProvider',),
        "QFileSystemModel.setNameFilterDisables": ('bool',),
        "QFileSystemModel.setNameFilters": ('typing.List[str]',),
        "QFileSystemModel.setReadOnly": ('bool',),
        "QFileSystemModel.setResolveSymlinks": ('bool',),
        "QFileSystemModel.setRootPath": ('str',),
        "QFileSystemModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QFileSystemModel.size": ('PySide2.QtCore.QModelIndex',),
        "QFileSystemModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
        "QFileSystemModel.supportedDropActions": (),
        "QFileSystemModel.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QFileSystemModel.type": ('PySide2.QtCore.QModelIndex',),

    # class PySide2.QtWidgets.QFocusFrame:
        "QFocusFrame.__init__": ('PySide2.QtWidgets.QWidget',),
        "QFocusFrame.event": ('PySide2.QtCore.QEvent',),
        "QFocusFrame.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QFocusFrame.initStyleOption": ('PySide2.QtWidgets.QStyleOption',),
        "QFocusFrame.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QFocusFrame.setWidget": ('PySide2.QtWidgets.QWidget',),
        "QFocusFrame.widget": (),

    # class PySide2.QtWidgets.QFontComboBox:
        "QFontComboBox.__init__": ('PySide2.QtWidgets.QWidget',),
        "QFontComboBox.currentFont": (),
        "QFontComboBox.event": ('PySide2.QtCore.QEvent',),
        "QFontComboBox.fontFilters": (),
        "QFontComboBox.setCurrentFont": ('PySide2.QtGui.QFont',),
        "QFontComboBox.setFontFilters": ('PySide2.QtWidgets.QFontComboBox.FontFilters',),
        "QFontComboBox.setWritingSystem": ('PySide2.QtGui.QFontDatabase.WritingSystem',),
        "QFontComboBox.sizeHint": (),
        "QFontComboBox.writingSystem": (),

    # class PySide2.QtWidgets.QFontDialog:
        "QFontDialog.__init__": [('PySide2.QtGui.QFont', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
        "QFontDialog.changeEvent": ('PySide2.QtCore.QEvent',),
        "QFontDialog.currentFont": (),
        "QFontDialog.done": ('int',),
        "QFontDialog.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QFontDialog.getFont": [('bool', 'PySide2.QtGui.QFont', 'PySide2.QtWidgets.QWidget', 'str', 'PySide2.QtWidgets.QFontDialog.FontDialogOptions'), ('bool', 'PySide2.QtWidgets.QWidget')],
        "QFontDialog.open": [(), ('PySide2.QtCore.QObject', 'str')],
        "QFontDialog.options": (),
        "QFontDialog.selectedFont": (),
        "QFontDialog.setCurrentFont": ('PySide2.QtGui.QFont',),
        "QFontDialog.setOption": ('PySide2.QtWidgets.QFontDialog.FontDialogOption', 'bool'),
        "QFontDialog.setOptions": ('PySide2.QtWidgets.QFontDialog.FontDialogOptions',),
        "QFontDialog.setVisible": ('bool',),
        "QFontDialog.testOption": ('PySide2.QtWidgets.QFontDialog.FontDialogOption',),

    # class PySide2.QtWidgets.QFormLayout:
        "QFormLayout.__init__": ('PySide2.QtWidgets.QWidget',),
        "QFormLayout.addItem": ('PySide2.QtWidgets.QLayoutItem',),
        "QFormLayout.addRow": [('PySide2.QtWidgets.QLayout',), ('PySide2.QtWidgets.QWidget',), ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QLayout'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QWidget'), ('str', 'PySide2.QtWidgets.QLayout'), ('str', 'PySide2.QtWidgets.QWidget')],
        "QFormLayout.count": (),
        "QFormLayout.expandingDirections": (),
        "QFormLayout.fieldGrowthPolicy": (),
        "QFormLayout.formAlignment": (),
        "QFormLayout.getItemPosition": ('int', 'int', 'PySide2.QtWidgets.QFormLayout.ItemRole'),
        "QFormLayout.getLayoutPosition": ('PySide2.QtWidgets.QLayout', 'int', 'PySide2.QtWidgets.QFormLayout.ItemRole'),
        "QFormLayout.getWidgetPosition": ('PySide2.QtWidgets.QWidget', 'int', 'PySide2.QtWidgets.QFormLayout.ItemRole'),
        "QFormLayout.hasHeightForWidth": (),
        "QFormLayout.heightForWidth": ('int',),
        "QFormLayout.horizontalSpacing": (),
        "QFormLayout.insertRow": [('int', 'PySide2.QtWidgets.QLayout'), ('int', 'PySide2.QtWidgets.QWidget'), ('int', 'PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QLayout'), ('int', 'PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QWidget'), ('int', 'str', 'PySide2.QtWidgets.QLayout'), ('int', 'str', 'PySide2.QtWidgets.QWidget')],
        "QFormLayout.invalidate": (),
        "QFormLayout.itemAt": [('int',), ('int', 'PySide2.QtWidgets.QFormLayout.ItemRole')],
        "QFormLayout.labelAlignment": (),
        "QFormLayout.labelForField": [('PySide2.QtWidgets.QLayout',), ('PySide2.QtWidgets.QWidget',)],
        "QFormLayout.minimumSize": (),
        "QFormLayout.removeRow": [('PySide2.QtWidgets.QLayout',), ('PySide2.QtWidgets.QWidget',), ('int',)],
        "QFormLayout.rowCount": (),
        "QFormLayout.rowWrapPolicy": (),
        "QFormLayout.setFieldGrowthPolicy": ('PySide2.QtWidgets.QFormLayout.FieldGrowthPolicy',),
        "QFormLayout.setFormAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QFormLayout.setGeometry": ('PySide2.QtCore.QRect',),
        "QFormLayout.setHorizontalSpacing": ('int',),
        "QFormLayout.setItem": ('int', 'PySide2.QtWidgets.QFormLayout.ItemRole', 'PySide2.QtWidgets.QLayoutItem'),
        "QFormLayout.setLabelAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QFormLayout.setLayout": ('int', 'PySide2.QtWidgets.QFormLayout.ItemRole', 'PySide2.QtWidgets.QLayout'),
        "QFormLayout.setRowWrapPolicy": ('PySide2.QtWidgets.QFormLayout.RowWrapPolicy',),
        "QFormLayout.setSpacing": ('int',),
        "QFormLayout.setVerticalSpacing": ('int',),
        "QFormLayout.setWidget": ('int', 'PySide2.QtWidgets.QFormLayout.ItemRole', 'PySide2.QtWidgets.QWidget'),
        "QFormLayout.sizeHint": (),
        "QFormLayout.spacing": (),
        "QFormLayout.takeAt": ('int',),
        "QFormLayout.verticalSpacing": (),

    # class PySide2.QtWidgets.QFrame:
        "QFrame.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
        "QFrame.changeEvent": ('PySide2.QtCore.QEvent',),
        "QFrame.drawFrame": ('PySide2.QtGui.QPainter',),
        "QFrame.event": ('PySide2.QtCore.QEvent',),
        "QFrame.frameRect": (),
        "QFrame.frameShadow": (),
        "QFrame.frameShape": (),
        "QFrame.frameStyle": (),
        "QFrame.frameWidth": (),
        "QFrame.initStyleOption": ('PySide2.QtWidgets.QStyleOptionFrame',),
        "QFrame.lineWidth": (),
        "QFrame.midLineWidth": (),
        "QFrame.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QFrame.setFrameRect": ('PySide2.QtCore.QRect',),
        "QFrame.setFrameShadow": ('PySide2.QtWidgets.QFrame.Shadow',),
        "QFrame.setFrameShape": ('PySide2.QtWidgets.QFrame.Shape',),
        "QFrame.setFrameStyle": ('int',),
        "QFrame.setLineWidth": ('int',),
        "QFrame.setMidLineWidth": ('int',),
        "QFrame.sizeHint": (),

    # class PySide2.QtWidgets.QGesture:
        "QGesture.__init__": ('PySide2.QtCore.QObject',),
        "QGesture.gestureCancelPolicy": (),
        "QGesture.gestureType": (),
        "QGesture.hasHotSpot": (),
        "QGesture.hotSpot": (),
        "QGesture.setGestureCancelPolicy": ('PySide2.QtWidgets.QGesture.GestureCancelPolicy',),
        "QGesture.setHotSpot": ('PySide2.QtCore.QPointF',),
        "QGesture.state": (),
        "QGesture.unsetHotSpot": (),

    # class PySide2.QtWidgets.QGestureEvent:
        "QGestureEvent.__init__": ('list',),
        "QGestureEvent.accept": [(), ('PySide2.QtCore.Qt.GestureType',), ('PySide2.QtWidgets.QGesture',)],
        "QGestureEvent.activeGestures": (),
        "QGestureEvent.canceledGestures": (),
        "QGestureEvent.gesture": ('PySide2.QtCore.Qt.GestureType',),
        "QGestureEvent.gestures": (),
        "QGestureEvent.ignore": [(), ('PySide2.QtCore.Qt.GestureType',), ('PySide2.QtWidgets.QGesture',)],
        "QGestureEvent.isAccepted": [(), ('PySide2.QtCore.Qt.GestureType',), ('PySide2.QtWidgets.QGesture',)],
        "QGestureEvent.mapToGraphicsScene": ('PySide2.QtCore.QPointF',),
        "QGestureEvent.setAccepted": [('PySide2.QtCore.Qt.GestureType', 'bool'), ('PySide2.QtWidgets.QGesture', 'bool'), ('bool',)],
        "QGestureEvent.setWidget": ('PySide2.QtWidgets.QWidget',),
        "QGestureEvent.widget": (),

    # class PySide2.QtWidgets.QGestureRecognizer:
        "QGestureRecognizer.__init__": (),
        "QGestureRecognizer.create": ('PySide2.QtCore.QObject',),
        "QGestureRecognizer.recognize": ('PySide2.QtWidgets.QGesture', 'PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QGestureRecognizer.registerRecognizer": ('PySide2.QtWidgets.QGestureRecognizer',),
        "QGestureRecognizer.reset": ('PySide2.QtWidgets.QGesture',),
        "QGestureRecognizer.unregisterRecognizer": ('PySide2.QtCore.Qt.GestureType',),

    # class PySide2.QtWidgets.QGraphicsAnchor:
        "QGraphicsAnchor.setSizePolicy": ('PySide2.QtWidgets.QSizePolicy.Policy',),
        "QGraphicsAnchor.setSpacing": ('float',),
        "QGraphicsAnchor.sizePolicy": (),
        "QGraphicsAnchor.spacing": (),
        "QGraphicsAnchor.unsetSpacing": (),

    # class PySide2.QtWidgets.QGraphicsAnchorLayout:
        "QGraphicsAnchorLayout.__init__": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
        "QGraphicsAnchorLayout.addAnchor": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.AnchorPoint', 'PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.AnchorPoint'),
        "QGraphicsAnchorLayout.addAnchors": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.Orientations'),
        "QGraphicsAnchorLayout.addCornerAnchors": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.Corner', 'PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.Corner'),
        "QGraphicsAnchorLayout.anchor": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.AnchorPoint', 'PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.AnchorPoint'),
        "QGraphicsAnchorLayout.count": (),
        "QGraphicsAnchorLayout.horizontalSpacing": (),
        "QGraphicsAnchorLayout.invalidate": (),
        "QGraphicsAnchorLayout.itemAt": ('int',),
        "QGraphicsAnchorLayout.removeAt": ('int',),
        "QGraphicsAnchorLayout.setGeometry": ('PySide2.QtCore.QRectF',),
        "QGraphicsAnchorLayout.setHorizontalSpacing": ('float',),
        "QGraphicsAnchorLayout.setSpacing": ('float',),
        "QGraphicsAnchorLayout.setVerticalSpacing": ('float',),
        "QGraphicsAnchorLayout.sizeHint": ('PySide2.QtCore.Qt.SizeHint', 'PySide2.QtCore.QSizeF'),
        "QGraphicsAnchorLayout.verticalSpacing": (),

    # class PySide2.QtWidgets.QGraphicsBlurEffect:
        "QGraphicsBlurEffect.__init__": ('PySide2.QtCore.QObject',),
        "QGraphicsBlurEffect.blurHints": (),
        "QGraphicsBlurEffect.blurRadius": (),
        "QGraphicsBlurEffect.boundingRectFor": ('PySide2.QtCore.QRectF',),
        "QGraphicsBlurEffect.draw": ('PySide2.QtGui.QPainter',),
        "QGraphicsBlurEffect.setBlurHints": ('PySide2.QtWidgets.QGraphicsBlurEffect.BlurHints',),
        "QGraphicsBlurEffect.setBlurRadius": ('float',),

    # class PySide2.QtWidgets.QGraphicsColorizeEffect:
        "QGraphicsColorizeEffect.__init__": ('PySide2.QtCore.QObject',),
        "QGraphicsColorizeEffect.color": (),
        "QGraphicsColorizeEffect.draw": ('PySide2.QtGui.QPainter',),
        "QGraphicsColorizeEffect.setColor": ('PySide2.QtGui.QColor',),
        "QGraphicsColorizeEffect.setStrength": ('float',),
        "QGraphicsColorizeEffect.strength": (),

    # class PySide2.QtWidgets.QGraphicsDropShadowEffect:
        "QGraphicsDropShadowEffect.__init__": ('PySide2.QtCore.QObject',),
        "QGraphicsDropShadowEffect.blurRadius": (),
        "QGraphicsDropShadowEffect.boundingRectFor": ('PySide2.QtCore.QRectF',),
        "QGraphicsDropShadowEffect.color": (),
        "QGraphicsDropShadowEffect.draw": ('PySide2.QtGui.QPainter',),
        "QGraphicsDropShadowEffect.offset": (),
        "QGraphicsDropShadowEffect.setBlurRadius": ('float',),
        "QGraphicsDropShadowEffect.setColor": ('PySide2.QtGui.QColor',),
        "QGraphicsDropShadowEffect.setOffset": [('PySide2.QtCore.QPointF',), ('float',), ('float', 'float')],
        "QGraphicsDropShadowEffect.setXOffset": ('float',),
        "QGraphicsDropShadowEffect.setYOffset": ('float',),
        "QGraphicsDropShadowEffect.xOffset": (),
        "QGraphicsDropShadowEffect.yOffset": (),

    # class PySide2.QtWidgets.QGraphicsEffect:
        "QGraphicsEffect.__init__": ('PySide2.QtCore.QObject',),
        "QGraphicsEffect.boundingRect": (),
        "QGraphicsEffect.boundingRectFor": ('PySide2.QtCore.QRectF',),
        "QGraphicsEffect.draw": ('PySide2.QtGui.QPainter',),
        "QGraphicsEffect.drawSource": ('PySide2.QtGui.QPainter',),
        "QGraphicsEffect.isEnabled": (),
        "QGraphicsEffect.setEnabled": ('bool',),
        "QGraphicsEffect.sourceBoundingRect": ('PySide2.QtCore.Qt.CoordinateSystem',),
        "QGraphicsEffect.sourceChanged": ('PySide2.QtWidgets.QGraphicsEffect.ChangeFlags',),
        "QGraphicsEffect.sourceIsPixmap": (),
        "QGraphicsEffect.sourcePixmap": ('PySide2.QtCore.Qt.CoordinateSystem', 'PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QGraphicsEffect.PixmapPadMode'),
        "QGraphicsEffect.update": (),
        "QGraphicsEffect.updateBoundingRect": (),

    # class PySide2.QtWidgets.QGraphicsEllipseItem:
        "QGraphicsEllipseItem.__init__": [('PySide2.QtCore.QRectF', 'PySide2.QtWidgets.QGraphicsItem'), ('PySide2.QtWidgets.QGraphicsItem',), ('float', 'float', 'float', 'float', 'PySide2.QtWidgets.QGraphicsItem')],
        "QGraphicsEllipseItem.boundingRect": (),
        "QGraphicsEllipseItem.contains": ('PySide2.QtCore.QPointF',),
        "QGraphicsEllipseItem.extension": ('typing.Any',),
        "QGraphicsEllipseItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsEllipseItem.opaqueArea": (),
        "QGraphicsEllipseItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
        "QGraphicsEllipseItem.rect": (),
        "QGraphicsEllipseItem.setRect": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
        "QGraphicsEllipseItem.setSpanAngle": ('int',),
        "QGraphicsEllipseItem.setStartAngle": ('int',),
        "QGraphicsEllipseItem.shape": (),
        "QGraphicsEllipseItem.spanAngle": (),
        "QGraphicsEllipseItem.startAngle": (),
        "QGraphicsEllipseItem.type": (),

    # class PySide2.QtWidgets.QGraphicsGridLayout:
        "QGraphicsGridLayout.__init__": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
        "QGraphicsGridLayout.addItem": [('PySide2.QtWidgets.QGraphicsLayoutItem', 'int', 'int', 'PySide2.QtCore.Qt.Alignment'), ('PySide2.QtWidgets.QGraphicsLayoutItem', 'int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.Alignment')],
        "QGraphicsGridLayout.alignment": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
        "QGraphicsGridLayout.columnAlignment": ('int',),
        "QGraphicsGridLayout.columnCount": (),
        "QGraphicsGridLayout.columnMaximumWidth": ('int',),
        "QGraphicsGridLayout.columnMinimumWidth": ('int',),
        "QGraphicsGridLayout.columnPreferredWidth": ('int',),
        "QGraphicsGridLayout.columnSpacing": ('int',),
        "QGraphicsGridLayout.columnStretchFactor": ('int',),
        "QGraphicsGridLayout.count": (),
        "QGraphicsGridLayout.horizontalSpacing": (),
        "QGraphicsGridLayout.invalidate": (),
        "QGraphicsGridLayout.itemAt": [('int',), ('int', 'int')],
        "QGraphicsGridLayout.removeAt": ('int',),
        "QGraphicsGridLayout.removeItem": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
        "QGraphicsGridLayout.rowAlignment": ('int',),
        "QGraphicsGridLayout.rowCount": (),
        "QGraphicsGridLayout.rowMaximumHeight": ('int',),
        "QGraphicsGridLayout.rowMinimumHeight": ('int',),
        "QGraphicsGridLayout.rowPreferredHeight": ('int',),
        "QGraphicsGridLayout.rowSpacing": ('int',),
        "QGraphicsGridLayout.rowStretchFactor": ('int',),
        "QGraphicsGridLayout.setAlignment": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.Alignment'),
        "QGraphicsGridLayout.setColumnAlignment": ('int', 'PySide2.QtCore.Qt.Alignment'),
        "QGraphicsGridLayout.setColumnFixedWidth": ('int', 'float'),
        "QGraphicsGridLayout.setColumnMaximumWidth": ('int', 'float'),
        "QGraphicsGridLayout.setColumnMinimumWidth": ('int', 'float'),
        "QGraphicsGridLayout.setColumnPreferredWidth": ('int', 'float'),
        "QGraphicsGridLayout.setColumnSpacing": ('int', 'float'),
        "QGraphicsGridLayout.setColumnStretchFactor": ('int', 'int'),
        "QGraphicsGridLayout.setGeometry": ('PySide2.QtCore.QRectF',),
        "QGraphicsGridLayout.setHorizontalSpacing": ('float',),
        "QGraphicsGridLayout.setRowAlignment": ('int', 'PySide2.QtCore.Qt.Alignment'),
        "QGraphicsGridLayout.setRowFixedHeight": ('int', 'float'),
        "QGraphicsGridLayout.setRowMaximumHeight": ('int', 'float'),
        "QGraphicsGridLayout.setRowMinimumHeight": ('int', 'float'),
        "QGraphicsGridLayout.setRowPreferredHeight": ('int', 'float'),
        "QGraphicsGridLayout.setRowSpacing": ('int', 'float'),
        "QGraphicsGridLayout.setRowStretchFactor": ('int', 'int'),
        "QGraphicsGridLayout.setSpacing": ('float',),
        "QGraphicsGridLayout.setVerticalSpacing": ('float',),
        "QGraphicsGridLayout.sizeHint": ('PySide2.QtCore.Qt.SizeHint', 'PySide2.QtCore.QSizeF'),
        "QGraphicsGridLayout.verticalSpacing": (),

    # class PySide2.QtWidgets.QGraphicsItem:
        "QGraphicsItem.__init__": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItem.acceptDrops": (),
        "QGraphicsItem.acceptHoverEvents": (),
        "QGraphicsItem.acceptTouchEvents": (),
        "QGraphicsItem.acceptedMouseButtons": (),
        "QGraphicsItem.addToIndex": (),
        "QGraphicsItem.advance": ('int',),
        "QGraphicsItem.boundingRect": (),
        "QGraphicsItem.boundingRegion": ('PySide2.QtGui.QTransform',),
        "QGraphicsItem.boundingRegionGranularity": (),
        "QGraphicsItem.cacheMode": (),
        "QGraphicsItem.childItems": (),
        "QGraphicsItem.childrenBoundingRect": (),
        "QGraphicsItem.clearFocus": (),
        "QGraphicsItem.clipPath": (),
        "QGraphicsItem.collidesWithItem": ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.Qt.ItemSelectionMode'),
        "QGraphicsItem.collidesWithPath": ('PySide2.QtGui.QPainterPath', 'PySide2.QtCore.Qt.ItemSelectionMode'),
        "QGraphicsItem.collidingItems": ('PySide2.QtCore.Qt.ItemSelectionMode',),
        "QGraphicsItem.commonAncestorItem": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItem.contains": ('PySide2.QtCore.QPointF',),
        "QGraphicsItem.contextMenuEvent": ('PySide2.QtWidgets.QGraphicsSceneContextMenuEvent',),
        "QGraphicsItem.cursor": (),
        "QGraphicsItem.data": ('int',),
        "QGraphicsItem.deviceTransform": ('PySide2.QtGui.QTransform',),
        "QGraphicsItem.dragEnterEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsItem.dragLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsItem.dragMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsItem.dropEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsItem.effectiveOpacity": (),
        "QGraphicsItem.ensureVisible": [('PySide2.QtCore.QRectF', 'int', 'int'), ('float', 'float', 'float', 'float', 'int', 'int')],
        "QGraphicsItem.extension": ('typing.Any',),
        "QGraphicsItem.filtersChildEvents": (),
        "QGraphicsItem.flags": (),
        "QGraphicsItem.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QGraphicsItem.focusItem": (),
        "QGraphicsItem.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QGraphicsItem.focusProxy": (),
        "QGraphicsItem.focusScopeItem": (),
        "QGraphicsItem.grabKeyboard": (),
        "QGraphicsItem.grabMouse": (),
        "QGraphicsItem.graphicsEffect": (),
        "QGraphicsItem.group": (),
        "QGraphicsItem.handlesChildEvents": (),
        "QGraphicsItem.hasCursor": (),
        "QGraphicsItem.hasFocus": (),
        "QGraphicsItem.hide": (),
        "QGraphicsItem.hoverEnterEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
        "QGraphicsItem.hoverLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
        "QGraphicsItem.hoverMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
        "QGraphicsItem.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
        "QGraphicsItem.inputMethodHints": (),
        "QGraphicsItem.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
        "QGraphicsItem.installSceneEventFilter": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItem.isActive": (),
        "QGraphicsItem.isAncestorOf": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItem.isBlockedByModalPanel": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItem.isClipped": (),
        "QGraphicsItem.isEnabled": (),
        "QGraphicsItem.isObscured": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
        "QGraphicsItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItem.isPanel": (),
        "QGraphicsItem.isSelected": (),
        "QGraphicsItem.isUnderMouse": (),
        "QGraphicsItem.isVisible": (),
        "QGraphicsItem.isVisibleTo": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItem.isWidget": (),
        "QGraphicsItem.isWindow": (),
        "QGraphicsItem.itemChange": ('PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange', 'typing.Any'),
        "QGraphicsItem.itemTransform": ('PySide2.QtWidgets.QGraphicsItem', 'bool'),
        "QGraphicsItem.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QGraphicsItem.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
        "QGraphicsItem.mapFromItem": [('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QPointF'), ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QRectF'), ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtGui.QPainterPath'), ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtGui.QPolygonF'), ('PySide2.QtWidgets.QGraphicsItem', 'float', 'float'), ('PySide2.QtWidgets.QGraphicsItem', 'float', 'float', 'float', 'float')],
        "QGraphicsItem.mapFromParent": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygonF',), ('float', 'float'), ('float', 'float', 'float', 'float')],
        "QGraphicsItem.mapFromScene": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygonF',), ('float', 'float'), ('float', 'float', 'float', 'float')],
        "QGraphicsItem.mapRectFromItem": [('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QRectF'), ('PySide2.QtWidgets.QGraphicsItem', 'float', 'float', 'float', 'float')],
        "QGraphicsItem.mapRectFromParent": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
        "QGraphicsItem.mapRectFromScene": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
        "QGraphicsItem.mapRectToItem": [('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QRectF'), ('PySide2.QtWidgets.QGraphicsItem', 'float', 'float', 'float', 'float')],
        "QGraphicsItem.mapRectToParent": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
        "QGraphicsItem.mapRectToScene": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
        "QGraphicsItem.mapToItem": [('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QPointF'), ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QRectF'), ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtGui.QPainterPath'), ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtGui.QPolygonF'), ('PySide2.QtWidgets.QGraphicsItem', 'float', 'float'), ('PySide2.QtWidgets.QGraphicsItem', 'float', 'float', 'float', 'float')],
        "QGraphicsItem.mapToParent": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygonF',), ('float', 'float'), ('float', 'float', 'float', 'float')],
        "QGraphicsItem.mapToScene": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygonF',), ('float', 'float'), ('float', 'float', 'float', 'float')],
        "QGraphicsItem.matrix": (),
        "QGraphicsItem.mouseDoubleClickEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsItem.mouseMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsItem.mousePressEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsItem.mouseReleaseEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsItem.moveBy": ('float', 'float'),
        "QGraphicsItem.opacity": (),
        "QGraphicsItem.opaqueArea": (),
        "QGraphicsItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
        "QGraphicsItem.panel": (),
        "QGraphicsItem.panelModality": (),
        "QGraphicsItem.parentItem": (),
        "QGraphicsItem.parentObject": (),
        "QGraphicsItem.parentWidget": (),
        "QGraphicsItem.pos": (),
        "QGraphicsItem.prepareGeometryChange": (),
        "QGraphicsItem.removeFromIndex": (),
        "QGraphicsItem.removeSceneEventFilter": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItem.resetMatrix": (),
        "QGraphicsItem.resetTransform": (),
        "QGraphicsItem.rotation": (),
        "QGraphicsItem.scale": (),
        "QGraphicsItem.scene": (),
        "QGraphicsItem.sceneBoundingRect": (),
        "QGraphicsItem.sceneEvent": ('PySide2.QtCore.QEvent',),
        "QGraphicsItem.sceneEventFilter": ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QEvent'),
        "QGraphicsItem.sceneMatrix": (),
        "QGraphicsItem.scenePos": (),
        "QGraphicsItem.sceneTransform": (),
        "QGraphicsItem.scroll": ('float', 'float', 'PySide2.QtCore.QRectF'),
        "QGraphicsItem.setAcceptDrops": ('bool',),
        "QGraphicsItem.setAcceptHoverEvents": ('bool',),
        "QGraphicsItem.setAcceptTouchEvents": ('bool',),
        "QGraphicsItem.setAcceptedMouseButtons": ('PySide2.QtCore.Qt.MouseButtons',),
        "QGraphicsItem.setActive": ('bool',),
        "QGraphicsItem.setBoundingRegionGranularity": ('float',),
        "QGraphicsItem.setCacheMode": ('PySide2.QtWidgets.QGraphicsItem.CacheMode', 'PySide2.QtCore.QSize'),
        "QGraphicsItem.setCursor": ('PySide2.QtGui.QCursor',),
        "QGraphicsItem.setData": ('int', 'typing.Any'),
        "QGraphicsItem.setEnabled": ('bool',),
        "QGraphicsItem.setFiltersChildEvents": ('bool',),
        "QGraphicsItem.setFlag": ('PySide2.QtWidgets.QGraphicsItem.GraphicsItemFlag', 'bool'),
        "QGraphicsItem.setFlags": ('PySide2.QtWidgets.QGraphicsItem.GraphicsItemFlags',),
        "QGraphicsItem.setFocus": ('PySide2.QtCore.Qt.FocusReason',),
        "QGraphicsItem.setFocusProxy": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItem.setGraphicsEffect": ('PySide2.QtWidgets.QGraphicsEffect',),
        "QGraphicsItem.setGroup": ('PySide2.QtWidgets.QGraphicsItemGroup',),
        "QGraphicsItem.setHandlesChildEvents": ('bool',),
        "QGraphicsItem.setInputMethodHints": ('PySide2.QtCore.Qt.InputMethodHints',),
        "QGraphicsItem.setMatrix": ('PySide2.QtGui.QMatrix', 'bool'),
        "QGraphicsItem.setOpacity": ('float',),
        "QGraphicsItem.setPanelModality": ('PySide2.QtWidgets.QGraphicsItem.PanelModality',),
        "QGraphicsItem.setParentItem": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItem.setPos": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QGraphicsItem.setRotation": ('float',),
        "QGraphicsItem.setScale": ('float',),
        "QGraphicsItem.setSelected": ('bool',),
        "QGraphicsItem.setToolTip": ('str',),
        "QGraphicsItem.setTransform": ('PySide2.QtGui.QTransform', 'bool'),
        "QGraphicsItem.setTransformOriginPoint": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QGraphicsItem.setTransformations": ('list',),
        "QGraphicsItem.setVisible": ('bool',),
        "QGraphicsItem.setX": ('float',),
        "QGraphicsItem.setY": ('float',),
        "QGraphicsItem.setZValue": ('float',),
        "QGraphicsItem.shape": (),
        "QGraphicsItem.show": (),
        "QGraphicsItem.stackBefore": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItem.toGraphicsObject": (),
        "QGraphicsItem.toolTip": (),
        "QGraphicsItem.topLevelItem": (),
        "QGraphicsItem.topLevelWidget": (),
        "QGraphicsItem.transform": (),
        "QGraphicsItem.transformOriginPoint": (),
        "QGraphicsItem.transformations": (),
        "QGraphicsItem.type": (),
        "QGraphicsItem.ungrabKeyboard": (),
        "QGraphicsItem.ungrabMouse": (),
        "QGraphicsItem.unsetCursor": (),
        "QGraphicsItem.update": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
        "QGraphicsItem.updateMicroFocus": (),
        "QGraphicsItem.wheelEvent": ('PySide2.QtWidgets.QGraphicsSceneWheelEvent',),
        "QGraphicsItem.window": (),
        "QGraphicsItem.x": (),
        "QGraphicsItem.y": (),
        "QGraphicsItem.zValue": (),

    # class PySide2.QtWidgets.QGraphicsItemAnimation:
        "QGraphicsItemAnimation.__init__": ('PySide2.QtCore.QObject',),
        "QGraphicsItemAnimation.afterAnimationStep": ('float',),
        "QGraphicsItemAnimation.beforeAnimationStep": ('float',),
        "QGraphicsItemAnimation.clear": (),
        "QGraphicsItemAnimation.horizontalScaleAt": ('float',),
        "QGraphicsItemAnimation.horizontalShearAt": ('float',),
        "QGraphicsItemAnimation.item": (),
        "QGraphicsItemAnimation.matrixAt": ('float',),
        "QGraphicsItemAnimation.posAt": ('float',),
        "QGraphicsItemAnimation.posList": (),
        "QGraphicsItemAnimation.reset": (),
        "QGraphicsItemAnimation.rotationAt": ('float',),
        "QGraphicsItemAnimation.rotationList": (),
        "QGraphicsItemAnimation.scaleList": (),
        "QGraphicsItemAnimation.setItem": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItemAnimation.setPosAt": ('float', 'PySide2.QtCore.QPointF'),
        "QGraphicsItemAnimation.setRotationAt": ('float', 'float'),
        "QGraphicsItemAnimation.setScaleAt": ('float', 'float', 'float'),
        "QGraphicsItemAnimation.setShearAt": ('float', 'float', 'float'),
        "QGraphicsItemAnimation.setStep": ('float',),
        "QGraphicsItemAnimation.setTimeLine": ('PySide2.QtCore.QTimeLine',),
        "QGraphicsItemAnimation.setTranslationAt": ('float', 'float', 'float'),
        "QGraphicsItemAnimation.shearList": (),
        "QGraphicsItemAnimation.timeLine": (),
        "QGraphicsItemAnimation.translationList": (),
        "QGraphicsItemAnimation.verticalScaleAt": ('float',),
        "QGraphicsItemAnimation.verticalShearAt": ('float',),
        "QGraphicsItemAnimation.xTranslationAt": ('float',),
        "QGraphicsItemAnimation.yTranslationAt": ('float',),

    # class PySide2.QtWidgets.QGraphicsItemGroup:
        "QGraphicsItemGroup.__init__": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItemGroup.addToGroup": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItemGroup.boundingRect": (),
        "QGraphicsItemGroup.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItemGroup.opaqueArea": (),
        "QGraphicsItemGroup.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
        "QGraphicsItemGroup.removeFromGroup": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsItemGroup.type": (),

    # class PySide2.QtWidgets.QGraphicsLayout:
        "QGraphicsLayout.__init__": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
        "QGraphicsLayout.activate": (),
        "QGraphicsLayout.addChildLayoutItem": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
        "QGraphicsLayout.count": (),
        "QGraphicsLayout.getContentsMargins": ('float', 'float', 'float', 'float'),
        "QGraphicsLayout.instantInvalidatePropagation": (),
        "QGraphicsLayout.invalidate": (),
        "QGraphicsLayout.isActivated": (),
        "QGraphicsLayout.itemAt": ('int',),
        "QGraphicsLayout.removeAt": ('int',),
        "QGraphicsLayout.setContentsMargins": ('float', 'float', 'float', 'float'),
        "QGraphicsLayout.setInstantInvalidatePropagation": ('bool',),
        "QGraphicsLayout.updateGeometry": (),
        "QGraphicsLayout.widgetEvent": ('PySide2.QtCore.QEvent',),

    # class PySide2.QtWidgets.QGraphicsLayoutItem:
        "QGraphicsLayoutItem.__init__": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'bool'),
        "QGraphicsLayoutItem.contentsRect": (),
        "QGraphicsLayoutItem.effectiveSizeHint": ('PySide2.QtCore.Qt.SizeHint', 'PySide2.QtCore.QSizeF'),
        "QGraphicsLayoutItem.geometry": (),
        "QGraphicsLayoutItem.getContentsMargins": ('float', 'float', 'float', 'float'),
        "QGraphicsLayoutItem.graphicsItem": (),
        "QGraphicsLayoutItem.isLayout": (),
        "QGraphicsLayoutItem.maximumHeight": (),
        "QGraphicsLayoutItem.maximumSize": (),
        "QGraphicsLayoutItem.maximumWidth": (),
        "QGraphicsLayoutItem.minimumHeight": (),
        "QGraphicsLayoutItem.minimumSize": (),
        "QGraphicsLayoutItem.minimumWidth": (),
        "QGraphicsLayoutItem.ownedByLayout": (),
        "QGraphicsLayoutItem.parentLayoutItem": (),
        "QGraphicsLayoutItem.preferredHeight": (),
        "QGraphicsLayoutItem.preferredSize": (),
        "QGraphicsLayoutItem.preferredWidth": (),
        "QGraphicsLayoutItem.setGeometry": ('PySide2.QtCore.QRectF',),
        "QGraphicsLayoutItem.setGraphicsItem": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsLayoutItem.setMaximumHeight": ('float',),
        "QGraphicsLayoutItem.setMaximumSize": [('PySide2.QtCore.QSizeF',), ('float', 'float')],
        "QGraphicsLayoutItem.setMaximumWidth": ('float',),
        "QGraphicsLayoutItem.setMinimumHeight": ('float',),
        "QGraphicsLayoutItem.setMinimumSize": [('PySide2.QtCore.QSizeF',), ('float', 'float')],
        "QGraphicsLayoutItem.setMinimumWidth": ('float',),
        "QGraphicsLayoutItem.setOwnedByLayout": ('bool',),
        "QGraphicsLayoutItem.setParentLayoutItem": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
        "QGraphicsLayoutItem.setPreferredHeight": ('float',),
        "QGraphicsLayoutItem.setPreferredSize": [('PySide2.QtCore.QSizeF',), ('float', 'float')],
        "QGraphicsLayoutItem.setPreferredWidth": ('float',),
        "QGraphicsLayoutItem.setSizePolicy": [('PySide2.QtWidgets.QSizePolicy',), ('PySide2.QtWidgets.QSizePolicy.Policy', 'PySide2.QtWidgets.QSizePolicy.Policy', 'PySide2.QtWidgets.QSizePolicy.ControlType')],
        "QGraphicsLayoutItem.sizeHint": ('PySide2.QtCore.Qt.SizeHint', 'PySide2.QtCore.QSizeF'),
        "QGraphicsLayoutItem.sizePolicy": (),
        "QGraphicsLayoutItem.updateGeometry": (),

    # class PySide2.QtWidgets.QGraphicsLineItem:
        "QGraphicsLineItem.__init__": [('PySide2.QtCore.QLineF', 'PySide2.QtWidgets.QGraphicsItem'), ('PySide2.QtWidgets.QGraphicsItem',), ('float', 'float', 'float', 'float', 'PySide2.QtWidgets.QGraphicsItem')],
        "QGraphicsLineItem.boundingRect": (),
        "QGraphicsLineItem.contains": ('PySide2.QtCore.QPointF',),
        "QGraphicsLineItem.extension": ('typing.Any',),
        "QGraphicsLineItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsLineItem.line": (),
        "QGraphicsLineItem.opaqueArea": (),
        "QGraphicsLineItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
        "QGraphicsLineItem.pen": (),
        "QGraphicsLineItem.setLine": [('PySide2.QtCore.QLineF',), ('float', 'float', 'float', 'float')],
        "QGraphicsLineItem.setPen": ('PySide2.QtGui.QPen',),
        "QGraphicsLineItem.shape": (),
        "QGraphicsLineItem.type": (),

    # class PySide2.QtWidgets.QGraphicsLinearLayout:
        "QGraphicsLinearLayout.__init__": [('PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QGraphicsLayoutItem'), ('PySide2.QtWidgets.QGraphicsLayoutItem',)],
        "QGraphicsLinearLayout.addItem": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
        "QGraphicsLinearLayout.addStretch": ('int',),
        "QGraphicsLinearLayout.alignment": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
        "QGraphicsLinearLayout.count": (),
        "QGraphicsLinearLayout.dump": ('int',),
        "QGraphicsLinearLayout.insertItem": ('int', 'PySide2.QtWidgets.QGraphicsLayoutItem'),
        "QGraphicsLinearLayout.insertStretch": ('int', 'int'),
        "QGraphicsLinearLayout.invalidate": (),
        "QGraphicsLinearLayout.itemAt": ('int',),
        "QGraphicsLinearLayout.itemSpacing": ('int',),
        "QGraphicsLinearLayout.orientation": (),
        "QGraphicsLinearLayout.removeAt": ('int',),
        "QGraphicsLinearLayout.removeItem": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
        "QGraphicsLinearLayout.setAlignment": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.Alignment'),
        "QGraphicsLinearLayout.setGeometry": ('PySide2.QtCore.QRectF',),
        "QGraphicsLinearLayout.setItemSpacing": ('int', 'float'),
        "QGraphicsLinearLayout.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
        "QGraphicsLinearLayout.setSpacing": ('float',),
        "QGraphicsLinearLayout.setStretchFactor": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'int'),
        "QGraphicsLinearLayout.sizeHint": ('PySide2.QtCore.Qt.SizeHint', 'PySide2.QtCore.QSizeF'),
        "QGraphicsLinearLayout.spacing": (),
        "QGraphicsLinearLayout.stretchFactor": ('PySide2.QtWidgets.QGraphicsLayoutItem',),

    # class PySide2.QtWidgets.QGraphicsObject:
        "QGraphicsObject.__init__": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsObject.event": ('PySide2.QtCore.QEvent',),
        "QGraphicsObject.grabGesture": ('PySide2.QtCore.Qt.GestureType', 'PySide2.QtCore.Qt.GestureFlags'),
        "QGraphicsObject.ungrabGesture": ('PySide2.QtCore.Qt.GestureType',),
        "QGraphicsObject.updateMicroFocus": (),

    # class PySide2.QtWidgets.QGraphicsOpacityEffect:
        "QGraphicsOpacityEffect.__init__": ('PySide2.QtCore.QObject',),
        "QGraphicsOpacityEffect.draw": ('PySide2.QtGui.QPainter',),
        "QGraphicsOpacityEffect.opacity": (),
        "QGraphicsOpacityEffect.opacityMask": (),
        "QGraphicsOpacityEffect.setOpacity": ('float',),
        "QGraphicsOpacityEffect.setOpacityMask": ('PySide2.QtGui.QBrush',),

    # class PySide2.QtWidgets.QGraphicsPathItem:
        "QGraphicsPathItem.__init__": [('PySide2.QtGui.QPainterPath', 'PySide2.QtWidgets.QGraphicsItem'), ('PySide2.QtWidgets.QGraphicsItem',)],
        "QGraphicsPathItem.boundingRect": (),
        "QGraphicsPathItem.contains": ('PySide2.QtCore.QPointF',),
        "QGraphicsPathItem.extension": ('typing.Any',),
        "QGraphicsPathItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsPathItem.opaqueArea": (),
        "QGraphicsPathItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
        "QGraphicsPathItem.path": (),
        "QGraphicsPathItem.setPath": ('PySide2.QtGui.QPainterPath',),
        "QGraphicsPathItem.shape": (),
        "QGraphicsPathItem.type": (),

    # class PySide2.QtWidgets.QGraphicsPixmapItem:
        "QGraphicsPixmapItem.__init__": [('PySide2.QtGui.QPixmap', 'PySide2.QtWidgets.QGraphicsItem'), ('PySide2.QtWidgets.QGraphicsItem',)],
        "QGraphicsPixmapItem.boundingRect": (),
        "QGraphicsPixmapItem.contains": ('PySide2.QtCore.QPointF',),
        "QGraphicsPixmapItem.extension": ('typing.Any',),
        "QGraphicsPixmapItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsPixmapItem.offset": (),
        "QGraphicsPixmapItem.opaqueArea": (),
        "QGraphicsPixmapItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
        "QGraphicsPixmapItem.pixmap": (),
        "QGraphicsPixmapItem.setOffset": [('PySide2.QtCore.QPointF',), ('float', 'float')],
        "QGraphicsPixmapItem.setPixmap": ('PySide2.QtGui.QPixmap',),
        "QGraphicsPixmapItem.setShapeMode": ('PySide2.QtWidgets.QGraphicsPixmapItem.ShapeMode',),
        "QGraphicsPixmapItem.setTransformationMode": ('PySide2.QtCore.Qt.TransformationMode',),
        "QGraphicsPixmapItem.shape": (),
        "QGraphicsPixmapItem.shapeMode": (),
        "QGraphicsPixmapItem.transformationMode": (),
        "QGraphicsPixmapItem.type": (),

    # class PySide2.QtWidgets.QGraphicsPolygonItem:
        "QGraphicsPolygonItem.__init__": [('PySide2.QtGui.QPolygonF', 'PySide2.QtWidgets.QGraphicsItem'), ('PySide2.QtWidgets.QGraphicsItem',)],
        "QGraphicsPolygonItem.boundingRect": (),
        "QGraphicsPolygonItem.contains": ('PySide2.QtCore.QPointF',),
        "QGraphicsPolygonItem.extension": ('typing.Any',),
        "QGraphicsPolygonItem.fillRule": (),
        "QGraphicsPolygonItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsPolygonItem.opaqueArea": (),
        "QGraphicsPolygonItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
        "QGraphicsPolygonItem.polygon": (),
        "QGraphicsPolygonItem.setFillRule": ('PySide2.QtCore.Qt.FillRule',),
        "QGraphicsPolygonItem.setPolygon": ('PySide2.QtGui.QPolygonF',),
        "QGraphicsPolygonItem.shape": (),
        "QGraphicsPolygonItem.type": (),

    # class PySide2.QtWidgets.QGraphicsProxyWidget:
        "QGraphicsProxyWidget.__init__": ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.Qt.WindowFlags'),
        "QGraphicsProxyWidget.contextMenuEvent": ('PySide2.QtWidgets.QGraphicsSceneContextMenuEvent',),
        "QGraphicsProxyWidget.createProxyForChildWidget": ('PySide2.QtWidgets.QWidget',),
        "QGraphicsProxyWidget.dragEnterEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsProxyWidget.dragLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsProxyWidget.dragMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsProxyWidget.dropEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsProxyWidget.event": ('PySide2.QtCore.QEvent',),
        "QGraphicsProxyWidget.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QGraphicsProxyWidget.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QGraphicsProxyWidget.focusNextPrevChild": ('bool',),
        "QGraphicsProxyWidget.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QGraphicsProxyWidget.grabMouseEvent": ('PySide2.QtCore.QEvent',),
        "QGraphicsProxyWidget.hideEvent": ('PySide2.QtGui.QHideEvent',),
        "QGraphicsProxyWidget.hoverEnterEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
        "QGraphicsProxyWidget.hoverLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
        "QGraphicsProxyWidget.hoverMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
        "QGraphicsProxyWidget.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
        "QGraphicsProxyWidget.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
        "QGraphicsProxyWidget.itemChange": ('PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange', 'typing.Any'),
        "QGraphicsProxyWidget.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QGraphicsProxyWidget.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
        "QGraphicsProxyWidget.mouseDoubleClickEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsProxyWidget.mouseMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsProxyWidget.mousePressEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsProxyWidget.mouseReleaseEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsProxyWidget.newProxyWidget": ('PySide2.QtWidgets.QWidget',),
        "QGraphicsProxyWidget.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
        "QGraphicsProxyWidget.resizeEvent": ('PySide2.QtWidgets.QGraphicsSceneResizeEvent',),
        "QGraphicsProxyWidget.setGeometry": ('PySide2.QtCore.QRectF',),
        "QGraphicsProxyWidget.setWidget": ('PySide2.QtWidgets.QWidget',),
        "QGraphicsProxyWidget.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QGraphicsProxyWidget.sizeHint": ('PySide2.QtCore.Qt.SizeHint', 'PySide2.QtCore.QSizeF'),
        "QGraphicsProxyWidget.subWidgetRect": ('PySide2.QtWidgets.QWidget',),
        "QGraphicsProxyWidget.type": (),
        "QGraphicsProxyWidget.ungrabMouseEvent": ('PySide2.QtCore.QEvent',),
        "QGraphicsProxyWidget.wheelEvent": ('PySide2.QtWidgets.QGraphicsSceneWheelEvent',),
        "QGraphicsProxyWidget.widget": (),

    # class PySide2.QtWidgets.QGraphicsRectItem:
        "QGraphicsRectItem.__init__": [('PySide2.QtCore.QRectF', 'PySide2.QtWidgets.QGraphicsItem'), ('PySide2.QtWidgets.QGraphicsItem',), ('float', 'float', 'float', 'float', 'PySide2.QtWidgets.QGraphicsItem')],
        "QGraphicsRectItem.boundingRect": (),
        "QGraphicsRectItem.contains": ('PySide2.QtCore.QPointF',),
        "QGraphicsRectItem.extension": ('typing.Any',),
        "QGraphicsRectItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsRectItem.opaqueArea": (),
        "QGraphicsRectItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
        "QGraphicsRectItem.rect": (),
        "QGraphicsRectItem.setRect": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
        "QGraphicsRectItem.shape": (),
        "QGraphicsRectItem.type": (),

    # class PySide2.QtWidgets.QGraphicsRotation:
        "QGraphicsRotation.__init__": ('PySide2.QtCore.QObject',),
        "QGraphicsRotation.angle": (),
        "QGraphicsRotation.applyTo": ('PySide2.QtGui.QMatrix4x4',),
        "QGraphicsRotation.axis": (),
        "QGraphicsRotation.origin": (),
        "QGraphicsRotation.setAngle": ('float',),
        "QGraphicsRotation.setAxis": [('PySide2.QtCore.Qt.Axis',), ('PySide2.QtGui.QVector3D',)],
        "QGraphicsRotation.setOrigin": ('PySide2.QtGui.QVector3D',),

    # class PySide2.QtWidgets.QGraphicsScale:
        "QGraphicsScale.__init__": ('PySide2.QtCore.QObject',),
        "QGraphicsScale.applyTo": ('PySide2.QtGui.QMatrix4x4',),
        "QGraphicsScale.origin": (),
        "QGraphicsScale.setOrigin": ('PySide2.QtGui.QVector3D',),
        "QGraphicsScale.setXScale": ('float',),
        "QGraphicsScale.setYScale": ('float',),
        "QGraphicsScale.setZScale": ('float',),
        "QGraphicsScale.xScale": (),
        "QGraphicsScale.yScale": (),
        "QGraphicsScale.zScale": (),

    # class PySide2.QtWidgets.QGraphicsScene:
        "QGraphicsScene.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtCore.QRectF', 'PySide2.QtCore.QObject'), ('float', 'float', 'float', 'float', 'PySide2.QtCore.QObject')],
        "QGraphicsScene.activePanel": (),
        "QGraphicsScene.activeWindow": (),
        "QGraphicsScene.addEllipse": [('PySide2.QtCore.QRectF', 'PySide2.QtGui.QPen', 'PySide2.QtGui.QBrush'), ('float', 'float', 'float', 'float', 'PySide2.QtGui.QPen', 'PySide2.QtGui.QBrush')],
        "QGraphicsScene.addItem": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsScene.addLine": [('PySide2.QtCore.QLineF', 'PySide2.QtGui.QPen'), ('float', 'float', 'float', 'float', 'PySide2.QtGui.QPen')],
        "QGraphicsScene.addPath": ('PySide2.QtGui.QPainterPath', 'PySide2.QtGui.QPen', 'PySide2.QtGui.QBrush'),
        "QGraphicsScene.addPixmap": ('PySide2.QtGui.QPixmap',),
        "QGraphicsScene.addPolygon": ('PySide2.QtGui.QPolygonF', 'PySide2.QtGui.QPen', 'PySide2.QtGui.QBrush'),
        "QGraphicsScene.addRect": [('PySide2.QtCore.QRectF', 'PySide2.QtGui.QPen', 'PySide2.QtGui.QBrush'), ('float', 'float', 'float', 'float', 'PySide2.QtGui.QPen', 'PySide2.QtGui.QBrush')],
        "QGraphicsScene.addSimpleText": ('str', 'PySide2.QtGui.QFont'),
        "QGraphicsScene.addText": ('str', 'PySide2.QtGui.QFont'),
        "QGraphicsScene.addWidget": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
        "QGraphicsScene.advance": (),
        "QGraphicsScene.backgroundBrush": (),
        "QGraphicsScene.bspTreeDepth": (),
        "QGraphicsScene.clear": (),
        "QGraphicsScene.clearFocus": (),
        "QGraphicsScene.clearSelection": (),
        "QGraphicsScene.collidingItems": ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.Qt.ItemSelectionMode'),
        "QGraphicsScene.contextMenuEvent": ('PySide2.QtWidgets.QGraphicsSceneContextMenuEvent',),
        "QGraphicsScene.createItemGroup": ('list',),
        "QGraphicsScene.destroyItemGroup": ('PySide2.QtWidgets.QGraphicsItemGroup',),
        "QGraphicsScene.dragEnterEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsScene.dragLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsScene.dragMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsScene.drawBackground": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF'),
        "QGraphicsScene.drawForeground": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF'),
        "QGraphicsScene.dropEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsScene.event": ('PySide2.QtCore.QEvent',),
        "QGraphicsScene.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QGraphicsScene.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QGraphicsScene.focusItem": (),
        "QGraphicsScene.focusNextPrevChild": ('bool',),
        "QGraphicsScene.focusOnTouch": (),
        "QGraphicsScene.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QGraphicsScene.font": (),
        "QGraphicsScene.foregroundBrush": (),
        "QGraphicsScene.hasFocus": (),
        "QGraphicsScene.height": (),
        "QGraphicsScene.helpEvent": ('PySide2.QtWidgets.QGraphicsSceneHelpEvent',),
        "QGraphicsScene.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
        "QGraphicsScene.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
        "QGraphicsScene.invalidate": [('PySide2.QtCore.QRectF', 'PySide2.QtWidgets.QGraphicsScene.SceneLayers'), ('float', 'float', 'float', 'float', 'PySide2.QtWidgets.QGraphicsScene.SceneLayers')],
        "QGraphicsScene.isActive": (),
        "QGraphicsScene.isSortCacheEnabled": (),
        "QGraphicsScene.itemAt": [('PySide2.QtCore.QPointF', 'PySide2.QtGui.QTransform'), ('float', 'float', 'PySide2.QtGui.QTransform')],
        "QGraphicsScene.itemIndexMethod": (),
        "QGraphicsScene.items": [('PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.ItemSelectionMode', 'PySide2.QtCore.Qt.SortOrder', 'PySide2.QtGui.QTransform'), ('PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.ItemSelectionMode', 'PySide2.QtCore.Qt.SortOrder', 'PySide2.QtGui.QTransform'), ('PySide2.QtCore.Qt.SortOrder',), ('PySide2.QtGui.QPainterPath', 'PySide2.QtCore.Qt.ItemSelectionMode', 'PySide2.QtCore.Qt.SortOrder', 'PySide2.QtGui.QTransform'), ('PySide2.QtGui.QPolygonF', 'PySide2.QtCore.Qt.ItemSelectionMode', 'PySide2.QtCore.Qt.SortOrder', 'PySide2.QtGui.QTransform'), ('float', 'float', 'float', 'float', 'PySide2.QtCore.Qt.ItemSelectionMode', 'PySide2.QtCore.Qt.SortOrder', 'PySide2.QtGui.QTransform')],
        "QGraphicsScene.itemsBoundingRect": (),
        "QGraphicsScene.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QGraphicsScene.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
        "QGraphicsScene.minimumRenderSize": (),
        "QGraphicsScene.mouseDoubleClickEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsScene.mouseGrabberItem": (),
        "QGraphicsScene.mouseMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsScene.mousePressEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsScene.mouseReleaseEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsScene.palette": (),
        "QGraphicsScene.removeItem": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsScene.render": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF', 'PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.AspectRatioMode'),
        "QGraphicsScene.sceneRect": (),
        "QGraphicsScene.selectedItems": (),
        "QGraphicsScene.selectionArea": (),
        "QGraphicsScene.sendEvent": ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QEvent'),
        "QGraphicsScene.setActivePanel": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsScene.setActiveWindow": ('PySide2.QtWidgets.QGraphicsWidget',),
        "QGraphicsScene.setBackgroundBrush": ('PySide2.QtGui.QBrush',),
        "QGraphicsScene.setBspTreeDepth": ('int',),
        "QGraphicsScene.setFocus": ('PySide2.QtCore.Qt.FocusReason',),
        "QGraphicsScene.setFocusItem": ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.Qt.FocusReason'),
        "QGraphicsScene.setFocusOnTouch": ('bool',),
        "QGraphicsScene.setFont": ('PySide2.QtGui.QFont',),
        "QGraphicsScene.setForegroundBrush": ('PySide2.QtGui.QBrush',),
        "QGraphicsScene.setItemIndexMethod": ('PySide2.QtWidgets.QGraphicsScene.ItemIndexMethod',),
        "QGraphicsScene.setMinimumRenderSize": ('float',),
        "QGraphicsScene.setPalette": ('PySide2.QtGui.QPalette',),
        "QGraphicsScene.setSceneRect": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
        "QGraphicsScene.setSelectionArea": [('PySide2.QtGui.QPainterPath', 'PySide2.QtCore.Qt.ItemSelectionMode', 'PySide2.QtGui.QTransform'), ('PySide2.QtGui.QPainterPath', 'PySide2.QtCore.Qt.ItemSelectionOperation', 'PySide2.QtCore.Qt.ItemSelectionMode', 'PySide2.QtGui.QTransform'), ('PySide2.QtGui.QPainterPath', 'PySide2.QtGui.QTransform')],
        "QGraphicsScene.setSortCacheEnabled": ('bool',),
        "QGraphicsScene.setStickyFocus": ('bool',),
        "QGraphicsScene.setStyle": ('PySide2.QtWidgets.QStyle',),
        "QGraphicsScene.stickyFocus": (),
        "QGraphicsScene.style": (),
        "QGraphicsScene.update": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
        "QGraphicsScene.views": (),
        "QGraphicsScene.wheelEvent": ('PySide2.QtWidgets.QGraphicsSceneWheelEvent',),
        "QGraphicsScene.width": (),

    # class PySide2.QtWidgets.QGraphicsSceneContextMenuEvent:
        "QGraphicsSceneContextMenuEvent.__init__": ('PySide2.QtCore.QEvent.Type',),
        "QGraphicsSceneContextMenuEvent.modifiers": (),
        "QGraphicsSceneContextMenuEvent.pos": (),
        "QGraphicsSceneContextMenuEvent.reason": (),
        "QGraphicsSceneContextMenuEvent.scenePos": (),
        "QGraphicsSceneContextMenuEvent.screenPos": (),
        "QGraphicsSceneContextMenuEvent.setModifiers": ('PySide2.QtCore.Qt.KeyboardModifiers',),
        "QGraphicsSceneContextMenuEvent.setPos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneContextMenuEvent.setReason": ('PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.Reason',),
        "QGraphicsSceneContextMenuEvent.setScenePos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneContextMenuEvent.setScreenPos": ('PySide2.QtCore.QPoint',),

    # class PySide2.QtWidgets.QGraphicsSceneDragDropEvent:
        "QGraphicsSceneDragDropEvent.__init__": ('PySide2.QtCore.QEvent.Type',),
        "QGraphicsSceneDragDropEvent.acceptProposedAction": (),
        "QGraphicsSceneDragDropEvent.buttons": (),
        "QGraphicsSceneDragDropEvent.dropAction": (),
        "QGraphicsSceneDragDropEvent.mimeData": (),
        "QGraphicsSceneDragDropEvent.modifiers": (),
        "QGraphicsSceneDragDropEvent.pos": (),
        "QGraphicsSceneDragDropEvent.possibleActions": (),
        "QGraphicsSceneDragDropEvent.proposedAction": (),
        "QGraphicsSceneDragDropEvent.scenePos": (),
        "QGraphicsSceneDragDropEvent.screenPos": (),
        "QGraphicsSceneDragDropEvent.setButtons": ('PySide2.QtCore.Qt.MouseButtons',),
        "QGraphicsSceneDragDropEvent.setDropAction": ('PySide2.QtCore.Qt.DropAction',),
        "QGraphicsSceneDragDropEvent.setModifiers": ('PySide2.QtCore.Qt.KeyboardModifiers',),
        "QGraphicsSceneDragDropEvent.setPos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneDragDropEvent.setPossibleActions": ('PySide2.QtCore.Qt.DropActions',),
        "QGraphicsSceneDragDropEvent.setProposedAction": ('PySide2.QtCore.Qt.DropAction',),
        "QGraphicsSceneDragDropEvent.setScenePos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneDragDropEvent.setScreenPos": ('PySide2.QtCore.QPoint',),
        "QGraphicsSceneDragDropEvent.source": (),

    # class PySide2.QtWidgets.QGraphicsSceneEvent:
        "QGraphicsSceneEvent.__init__": ('PySide2.QtCore.QEvent.Type',),
        "QGraphicsSceneEvent.widget": (),

    # class PySide2.QtWidgets.QGraphicsSceneHelpEvent:
        "QGraphicsSceneHelpEvent.__init__": ('PySide2.QtCore.QEvent.Type',),
        "QGraphicsSceneHelpEvent.scenePos": (),
        "QGraphicsSceneHelpEvent.screenPos": (),
        "QGraphicsSceneHelpEvent.setScenePos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneHelpEvent.setScreenPos": ('PySide2.QtCore.QPoint',),

    # class PySide2.QtWidgets.QGraphicsSceneHoverEvent:
        "QGraphicsSceneHoverEvent.__init__": ('PySide2.QtCore.QEvent.Type',),
        "QGraphicsSceneHoverEvent.lastPos": (),
        "QGraphicsSceneHoverEvent.lastScenePos": (),
        "QGraphicsSceneHoverEvent.lastScreenPos": (),
        "QGraphicsSceneHoverEvent.modifiers": (),
        "QGraphicsSceneHoverEvent.pos": (),
        "QGraphicsSceneHoverEvent.scenePos": (),
        "QGraphicsSceneHoverEvent.screenPos": (),
        "QGraphicsSceneHoverEvent.setLastPos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneHoverEvent.setLastScenePos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneHoverEvent.setLastScreenPos": ('PySide2.QtCore.QPoint',),
        "QGraphicsSceneHoverEvent.setModifiers": ('PySide2.QtCore.Qt.KeyboardModifiers',),
        "QGraphicsSceneHoverEvent.setPos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneHoverEvent.setScenePos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneHoverEvent.setScreenPos": ('PySide2.QtCore.QPoint',),

    # class PySide2.QtWidgets.QGraphicsSceneMouseEvent:
        "QGraphicsSceneMouseEvent.__init__": ('PySide2.QtCore.QEvent.Type',),
        "QGraphicsSceneMouseEvent.button": (),
        "QGraphicsSceneMouseEvent.buttonDownPos": ('PySide2.QtCore.Qt.MouseButton',),
        "QGraphicsSceneMouseEvent.buttonDownScenePos": ('PySide2.QtCore.Qt.MouseButton',),
        "QGraphicsSceneMouseEvent.buttonDownScreenPos": ('PySide2.QtCore.Qt.MouseButton',),
        "QGraphicsSceneMouseEvent.buttons": (),
        "QGraphicsSceneMouseEvent.flags": (),
        "QGraphicsSceneMouseEvent.lastPos": (),
        "QGraphicsSceneMouseEvent.lastScenePos": (),
        "QGraphicsSceneMouseEvent.lastScreenPos": (),
        "QGraphicsSceneMouseEvent.modifiers": (),
        "QGraphicsSceneMouseEvent.pos": (),
        "QGraphicsSceneMouseEvent.scenePos": (),
        "QGraphicsSceneMouseEvent.screenPos": (),
        "QGraphicsSceneMouseEvent.setButton": ('PySide2.QtCore.Qt.MouseButton',),
        "QGraphicsSceneMouseEvent.setButtonDownPos": ('PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.QPointF'),
        "QGraphicsSceneMouseEvent.setButtonDownScenePos": ('PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.QPointF'),
        "QGraphicsSceneMouseEvent.setButtonDownScreenPos": ('PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.QPoint'),
        "QGraphicsSceneMouseEvent.setButtons": ('PySide2.QtCore.Qt.MouseButtons',),
        "QGraphicsSceneMouseEvent.setFlags": ('PySide2.QtCore.Qt.MouseEventFlags',),
        "QGraphicsSceneMouseEvent.setLastPos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneMouseEvent.setLastScenePos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneMouseEvent.setLastScreenPos": ('PySide2.QtCore.QPoint',),
        "QGraphicsSceneMouseEvent.setModifiers": ('PySide2.QtCore.Qt.KeyboardModifiers',),
        "QGraphicsSceneMouseEvent.setPos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneMouseEvent.setScenePos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneMouseEvent.setScreenPos": ('PySide2.QtCore.QPoint',),
        "QGraphicsSceneMouseEvent.setSource": ('PySide2.QtCore.Qt.MouseEventSource',),
        "QGraphicsSceneMouseEvent.source": (),

    # class PySide2.QtWidgets.QGraphicsSceneMoveEvent:
        "QGraphicsSceneMoveEvent.__init__": (),
        "QGraphicsSceneMoveEvent.newPos": (),
        "QGraphicsSceneMoveEvent.oldPos": (),
        "QGraphicsSceneMoveEvent.setNewPos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneMoveEvent.setOldPos": ('PySide2.QtCore.QPointF',),

    # class PySide2.QtWidgets.QGraphicsSceneResizeEvent:
        "QGraphicsSceneResizeEvent.__init__": (),
        "QGraphicsSceneResizeEvent.newSize": (),
        "QGraphicsSceneResizeEvent.oldSize": (),
        "QGraphicsSceneResizeEvent.setNewSize": ('PySide2.QtCore.QSizeF',),
        "QGraphicsSceneResizeEvent.setOldSize": ('PySide2.QtCore.QSizeF',),

    # class PySide2.QtWidgets.QGraphicsSceneWheelEvent:
        "QGraphicsSceneWheelEvent.__init__": ('PySide2.QtCore.QEvent.Type',),
        "QGraphicsSceneWheelEvent.buttons": (),
        "QGraphicsSceneWheelEvent.delta": (),
        "QGraphicsSceneWheelEvent.modifiers": (),
        "QGraphicsSceneWheelEvent.orientation": (),
        "QGraphicsSceneWheelEvent.pos": (),
        "QGraphicsSceneWheelEvent.scenePos": (),
        "QGraphicsSceneWheelEvent.screenPos": (),
        "QGraphicsSceneWheelEvent.setButtons": ('PySide2.QtCore.Qt.MouseButtons',),
        "QGraphicsSceneWheelEvent.setDelta": ('int',),
        "QGraphicsSceneWheelEvent.setModifiers": ('PySide2.QtCore.Qt.KeyboardModifiers',),
        "QGraphicsSceneWheelEvent.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
        "QGraphicsSceneWheelEvent.setPos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneWheelEvent.setScenePos": ('PySide2.QtCore.QPointF',),
        "QGraphicsSceneWheelEvent.setScreenPos": ('PySide2.QtCore.QPoint',),

    # class PySide2.QtWidgets.QGraphicsSimpleTextItem:
        "QGraphicsSimpleTextItem.__init__": [('PySide2.QtWidgets.QGraphicsItem',), ('str', 'PySide2.QtWidgets.QGraphicsItem')],
        "QGraphicsSimpleTextItem.boundingRect": (),
        "QGraphicsSimpleTextItem.contains": ('PySide2.QtCore.QPointF',),
        "QGraphicsSimpleTextItem.extension": ('typing.Any',),
        "QGraphicsSimpleTextItem.font": (),
        "QGraphicsSimpleTextItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsSimpleTextItem.opaqueArea": (),
        "QGraphicsSimpleTextItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
        "QGraphicsSimpleTextItem.setFont": ('PySide2.QtGui.QFont',),
        "QGraphicsSimpleTextItem.setText": ('str',),
        "QGraphicsSimpleTextItem.shape": (),
        "QGraphicsSimpleTextItem.text": (),
        "QGraphicsSimpleTextItem.type": (),

    # class PySide2.QtWidgets.QGraphicsTextItem:
        "QGraphicsTextItem.__init__": [('PySide2.QtWidgets.QGraphicsItem',), ('str', 'PySide2.QtWidgets.QGraphicsItem')],
        "QGraphicsTextItem.adjustSize": (),
        "QGraphicsTextItem.boundingRect": (),
        "QGraphicsTextItem.contains": ('PySide2.QtCore.QPointF',),
        "QGraphicsTextItem.contextMenuEvent": ('PySide2.QtWidgets.QGraphicsSceneContextMenuEvent',),
        "QGraphicsTextItem.defaultTextColor": (),
        "QGraphicsTextItem.document": (),
        "QGraphicsTextItem.dragEnterEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsTextItem.dragLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsTextItem.dragMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsTextItem.dropEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
        "QGraphicsTextItem.extension": ('typing.Any',),
        "QGraphicsTextItem.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QGraphicsTextItem.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QGraphicsTextItem.font": (),
        "QGraphicsTextItem.hoverEnterEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
        "QGraphicsTextItem.hoverLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
        "QGraphicsTextItem.hoverMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
        "QGraphicsTextItem.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
        "QGraphicsTextItem.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
        "QGraphicsTextItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsTextItem.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QGraphicsTextItem.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
        "QGraphicsTextItem.mouseDoubleClickEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsTextItem.mouseMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsTextItem.mousePressEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsTextItem.mouseReleaseEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
        "QGraphicsTextItem.opaqueArea": (),
        "QGraphicsTextItem.openExternalLinks": (),
        "QGraphicsTextItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
        "QGraphicsTextItem.sceneEvent": ('PySide2.QtCore.QEvent',),
        "QGraphicsTextItem.setDefaultTextColor": ('PySide2.QtGui.QColor',),
        "QGraphicsTextItem.setDocument": ('PySide2.QtGui.QTextDocument',),
        "QGraphicsTextItem.setFont": ('PySide2.QtGui.QFont',),
        "QGraphicsTextItem.setHtml": ('str',),
        "QGraphicsTextItem.setOpenExternalLinks": ('bool',),
        "QGraphicsTextItem.setPlainText": ('str',),
        "QGraphicsTextItem.setTabChangesFocus": ('bool',),
        "QGraphicsTextItem.setTextCursor": ('PySide2.QtGui.QTextCursor',),
        "QGraphicsTextItem.setTextInteractionFlags": ('PySide2.QtCore.Qt.TextInteractionFlags',),
        "QGraphicsTextItem.setTextWidth": ('float',),
        "QGraphicsTextItem.shape": (),
        "QGraphicsTextItem.tabChangesFocus": (),
        "QGraphicsTextItem.textCursor": (),
        "QGraphicsTextItem.textInteractionFlags": (),
        "QGraphicsTextItem.textWidth": (),
        "QGraphicsTextItem.toHtml": (),
        "QGraphicsTextItem.toPlainText": (),
        "QGraphicsTextItem.type": (),

    # class PySide2.QtWidgets.QGraphicsTransform:
        "QGraphicsTransform.__init__": ('PySide2.QtCore.QObject',),
        "QGraphicsTransform.applyTo": ('PySide2.QtGui.QMatrix4x4',),
        "QGraphicsTransform.update": (),

    # class PySide2.QtWidgets.QGraphicsView:
        "QGraphicsView.__init__": [('PySide2.QtWidgets.QGraphicsScene', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
        "QGraphicsView.alignment": (),
        "QGraphicsView.backgroundBrush": (),
        "QGraphicsView.cacheMode": (),
        "QGraphicsView.centerOn": [('PySide2.QtCore.QPointF',), ('PySide2.QtWidgets.QGraphicsItem',), ('float', 'float')],
        "QGraphicsView.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
        "QGraphicsView.dragEnterEvent": ('PySide2.QtGui.QDragEnterEvent',),
        "QGraphicsView.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
        "QGraphicsView.dragMode": (),
        "QGraphicsView.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
        "QGraphicsView.drawBackground": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF'),
        "QGraphicsView.drawForeground": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF'),
        "QGraphicsView.drawItems": ('PySide2.QtGui.QPainter', 'int', 'typing.List[PySide2.QtWidgets.QGraphicsItem]', 'typing.List[PySide2.QtWidgets.QStyleOptionGraphicsItem]'),
        "QGraphicsView.dropEvent": ('PySide2.QtGui.QDropEvent',),
        "QGraphicsView.ensureVisible": [('PySide2.QtCore.QRectF', 'int', 'int'), ('PySide2.QtWidgets.QGraphicsItem', 'int', 'int'), ('float', 'float', 'float', 'float', 'int', 'int')],
        "QGraphicsView.event": ('PySide2.QtCore.QEvent',),
        "QGraphicsView.fitInView": [('PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.AspectRatioMode'), ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.Qt.AspectRatioMode'), ('float', 'float', 'float', 'float', 'PySide2.QtCore.Qt.AspectRatioMode')],
        "QGraphicsView.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QGraphicsView.focusNextPrevChild": ('bool',),
        "QGraphicsView.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QGraphicsView.foregroundBrush": (),
        "QGraphicsView.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
        "QGraphicsView.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
        "QGraphicsView.invalidateScene": ('PySide2.QtCore.QRectF', 'PySide2.QtWidgets.QGraphicsScene.SceneLayers'),
        "QGraphicsView.isInteractive": (),
        "QGraphicsView.isTransformed": (),
        "QGraphicsView.itemAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QGraphicsView.items": [(), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.ItemSelectionMode'), ('PySide2.QtGui.QPainterPath', 'PySide2.QtCore.Qt.ItemSelectionMode'), ('PySide2.QtGui.QPolygon', 'PySide2.QtCore.Qt.ItemSelectionMode'), ('int', 'int'), ('int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.ItemSelectionMode')],
        "QGraphicsView.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QGraphicsView.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
        "QGraphicsView.mapFromScene": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygonF',), ('float', 'float'), ('float', 'float', 'float', 'float')],
        "QGraphicsView.mapToScene": [('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QRect',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygon',), ('int', 'int'), ('int', 'int', 'int', 'int')],
        "QGraphicsView.matrix": (),
        "QGraphicsView.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
        "QGraphicsView.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QGraphicsView.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QGraphicsView.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QGraphicsView.optimizationFlags": (),
        "QGraphicsView.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QGraphicsView.render": [('PySide2.QtGui.QPaintDevice', 'PySide2.QtCore.QPoint', 'PySide2.QtGui.QRegion', 'PySide2.QtWidgets.QWidget.RenderFlags'), ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF', 'PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.AspectRatioMode')],
        "QGraphicsView.renderHints": (),
        "QGraphicsView.resetCachedContent": (),
        "QGraphicsView.resetMatrix": (),
        "QGraphicsView.resetTransform": (),
        "QGraphicsView.resizeAnchor": (),
        "QGraphicsView.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QGraphicsView.rotate": ('float',),
        "QGraphicsView.rubberBandRect": (),
        "QGraphicsView.rubberBandSelectionMode": (),
        "QGraphicsView.scale": ('float', 'float'),
        "QGraphicsView.scene": (),
        "QGraphicsView.sceneRect": (),
        "QGraphicsView.scrollContentsBy": ('int', 'int'),
        "QGraphicsView.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QGraphicsView.setBackgroundBrush": ('PySide2.QtGui.QBrush',),
        "QGraphicsView.setCacheMode": ('PySide2.QtWidgets.QGraphicsView.CacheMode',),
        "QGraphicsView.setDragMode": ('PySide2.QtWidgets.QGraphicsView.DragMode',),
        "QGraphicsView.setForegroundBrush": ('PySide2.QtGui.QBrush',),
        "QGraphicsView.setInteractive": ('bool',),
        "QGraphicsView.setMatrix": ('PySide2.QtGui.QMatrix', 'bool'),
        "QGraphicsView.setOptimizationFlag": ('PySide2.QtWidgets.QGraphicsView.OptimizationFlag', 'bool'),
        "QGraphicsView.setOptimizationFlags": ('PySide2.QtWidgets.QGraphicsView.OptimizationFlags',),
        "QGraphicsView.setRenderHint": ('PySide2.QtGui.QPainter.RenderHint', 'bool'),
        "QGraphicsView.setRenderHints": ('PySide2.QtGui.QPainter.RenderHints',),
        "QGraphicsView.setResizeAnchor": ('PySide2.QtWidgets.QGraphicsView.ViewportAnchor',),
        "QGraphicsView.setRubberBandSelectionMode": ('PySide2.QtCore.Qt.ItemSelectionMode',),
        "QGraphicsView.setScene": ('PySide2.QtWidgets.QGraphicsScene',),
        "QGraphicsView.setSceneRect": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
        "QGraphicsView.setTransform": ('PySide2.QtGui.QTransform', 'bool'),
        "QGraphicsView.setTransformationAnchor": ('PySide2.QtWidgets.QGraphicsView.ViewportAnchor',),
        "QGraphicsView.setViewportUpdateMode": ('PySide2.QtWidgets.QGraphicsView.ViewportUpdateMode',),
        "QGraphicsView.setupViewport": ('PySide2.QtWidgets.QWidget',),
        "QGraphicsView.shear": ('float', 'float'),
        "QGraphicsView.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QGraphicsView.sizeHint": (),
        "QGraphicsView.transform": (),
        "QGraphicsView.transformationAnchor": (),
        "QGraphicsView.translate": ('float', 'float'),
        "QGraphicsView.updateScene": ('list',),
        "QGraphicsView.updateSceneRect": ('PySide2.QtCore.QRectF',),
        "QGraphicsView.viewportEvent": ('PySide2.QtCore.QEvent',),
        "QGraphicsView.viewportTransform": (),
        "QGraphicsView.viewportUpdateMode": (),
        "QGraphicsView.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

    # class PySide2.QtWidgets.QGraphicsWidget:
        "QGraphicsWidget.__init__": ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.Qt.WindowFlags'),
        "QGraphicsWidget.actions": (),
        "QGraphicsWidget.addAction": ('PySide2.QtWidgets.QAction',),
        "QGraphicsWidget.addActions": ('list',),
        "QGraphicsWidget.adjustSize": (),
        "QGraphicsWidget.autoFillBackground": (),
        "QGraphicsWidget.boundingRect": (),
        "QGraphicsWidget.changeEvent": ('PySide2.QtCore.QEvent',),
        "QGraphicsWidget.close": (),
        "QGraphicsWidget.closeEvent": ('PySide2.QtGui.QCloseEvent',),
        "QGraphicsWidget.event": ('PySide2.QtCore.QEvent',),
        "QGraphicsWidget.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QGraphicsWidget.focusNextPrevChild": ('bool',),
        "QGraphicsWidget.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QGraphicsWidget.focusPolicy": (),
        "QGraphicsWidget.focusWidget": (),
        "QGraphicsWidget.font": (),
        "QGraphicsWidget.getContentsMargins": ('float', 'float', 'float', 'float'),
        "QGraphicsWidget.getWindowFrameMargins": ('float', 'float', 'float', 'float'),
        "QGraphicsWidget.grabKeyboardEvent": ('PySide2.QtCore.QEvent',),
        "QGraphicsWidget.grabMouseEvent": ('PySide2.QtCore.QEvent',),
        "QGraphicsWidget.grabShortcut": ('PySide2.QtGui.QKeySequence', 'PySide2.QtCore.Qt.ShortcutContext'),
        "QGraphicsWidget.hideEvent": ('PySide2.QtGui.QHideEvent',),
        "QGraphicsWidget.hoverLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
        "QGraphicsWidget.hoverMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
        "QGraphicsWidget.initStyleOption": ('PySide2.QtWidgets.QStyleOption',),
        "QGraphicsWidget.insertAction": ('PySide2.QtWidgets.QAction', 'PySide2.QtWidgets.QAction'),
        "QGraphicsWidget.insertActions": ('PySide2.QtWidgets.QAction', 'list'),
        "QGraphicsWidget.isActiveWindow": (),
        "QGraphicsWidget.itemChange": ('PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange', 'typing.Any'),
        "QGraphicsWidget.layout": (),
        "QGraphicsWidget.layoutDirection": (),
        "QGraphicsWidget.moveEvent": ('PySide2.QtWidgets.QGraphicsSceneMoveEvent',),
        "QGraphicsWidget.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
        "QGraphicsWidget.paintWindowFrame": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
        "QGraphicsWidget.palette": (),
        "QGraphicsWidget.polishEvent": (),
        "QGraphicsWidget.propertyChange": ('str', 'typing.Any'),
        "QGraphicsWidget.rect": (),
        "QGraphicsWidget.releaseShortcut": ('int',),
        "QGraphicsWidget.removeAction": ('PySide2.QtWidgets.QAction',),
        "QGraphicsWidget.resize": [('PySide2.QtCore.QSizeF',), ('float', 'float')],
        "QGraphicsWidget.resizeEvent": ('PySide2.QtWidgets.QGraphicsSceneResizeEvent',),
        "QGraphicsWidget.sceneEvent": ('PySide2.QtCore.QEvent',),
        "QGraphicsWidget.setAttribute": ('PySide2.QtCore.Qt.WidgetAttribute', 'bool'),
        "QGraphicsWidget.setAutoFillBackground": ('bool',),
        "QGraphicsWidget.setContentsMargins": ('float', 'float', 'float', 'float'),
        "QGraphicsWidget.setFocusPolicy": ('PySide2.QtCore.Qt.FocusPolicy',),
        "QGraphicsWidget.setFont": ('PySide2.QtGui.QFont',),
        "QGraphicsWidget.setGeometry": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
        "QGraphicsWidget.setLayout": ('PySide2.QtWidgets.QGraphicsLayout',),
        "QGraphicsWidget.setLayoutDirection": ('PySide2.QtCore.Qt.LayoutDirection',),
        "QGraphicsWidget.setPalette": ('PySide2.QtGui.QPalette',),
        "QGraphicsWidget.setShortcutAutoRepeat": ('int', 'bool'),
        "QGraphicsWidget.setShortcutEnabled": ('int', 'bool'),
        "QGraphicsWidget.setStyle": ('PySide2.QtWidgets.QStyle',),
        "QGraphicsWidget.setTabOrder": ('PySide2.QtWidgets.QGraphicsWidget', 'PySide2.QtWidgets.QGraphicsWidget'),
        "QGraphicsWidget.setWindowFlags": ('PySide2.QtCore.Qt.WindowFlags',),
        "QGraphicsWidget.setWindowFrameMargins": ('float', 'float', 'float', 'float'),
        "QGraphicsWidget.setWindowTitle": ('str',),
        "QGraphicsWidget.shape": (),
        "QGraphicsWidget.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QGraphicsWidget.size": (),
        "QGraphicsWidget.sizeHint": ('PySide2.QtCore.Qt.SizeHint', 'PySide2.QtCore.QSizeF'),
        "QGraphicsWidget.style": (),
        "QGraphicsWidget.testAttribute": ('PySide2.QtCore.Qt.WidgetAttribute',),
        "QGraphicsWidget.type": (),
        "QGraphicsWidget.ungrabKeyboardEvent": ('PySide2.QtCore.QEvent',),
        "QGraphicsWidget.ungrabMouseEvent": ('PySide2.QtCore.QEvent',),
        "QGraphicsWidget.unsetLayoutDirection": (),
        "QGraphicsWidget.unsetWindowFrameMargins": (),
        "QGraphicsWidget.updateGeometry": (),
        "QGraphicsWidget.windowFlags": (),
        "QGraphicsWidget.windowFrameEvent": ('PySide2.QtCore.QEvent',),
        "QGraphicsWidget.windowFrameGeometry": (),
        "QGraphicsWidget.windowFrameRect": (),
        "QGraphicsWidget.windowFrameSectionAt": ('PySide2.QtCore.QPointF',),
        "QGraphicsWidget.windowTitle": (),
        "QGraphicsWidget.windowType": (),

    # class PySide2.QtWidgets.QGridLayout:
        "QGridLayout.__init__": [(), ('PySide2.QtWidgets.QWidget',)],
        "QGridLayout.addItem": [('PySide2.QtWidgets.QLayoutItem',), ('PySide2.QtWidgets.QLayoutItem', 'int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.Alignment')],
        "QGridLayout.addLayout": [('PySide2.QtWidgets.QLayout', 'int', 'int', 'PySide2.QtCore.Qt.Alignment'), ('PySide2.QtWidgets.QLayout', 'int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.Alignment')],
        "QGridLayout.addWidget": [('PySide2.QtWidgets.QWidget',), ('PySide2.QtWidgets.QWidget', 'int', 'int', 'PySide2.QtCore.Qt.Alignment'), ('PySide2.QtWidgets.QWidget', 'int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.Alignment')],
        "QGridLayout.cellRect": ('int', 'int'),
        "QGridLayout.columnCount": (),
        "QGridLayout.columnMinimumWidth": ('int',),
        "QGridLayout.columnStretch": ('int',),
        "QGridLayout.count": (),
        "QGridLayout.expandingDirections": (),
        "QGridLayout.getItemPosition": ('int', 'int', 'int', 'int', 'int'),
        "QGridLayout.hasHeightForWidth": (),
        "QGridLayout.heightForWidth": ('int',),
        "QGridLayout.horizontalSpacing": (),
        "QGridLayout.invalidate": (),
        "QGridLayout.itemAt": ('int',),
        "QGridLayout.itemAtPosition": ('int', 'int'),
        "QGridLayout.maximumSize": (),
        "QGridLayout.minimumHeightForWidth": ('int',),
        "QGridLayout.minimumSize": (),
        "QGridLayout.originCorner": (),
        "QGridLayout.rowCount": (),
        "QGridLayout.rowMinimumHeight": ('int',),
        "QGridLayout.rowStretch": ('int',),
        "QGridLayout.setColumnMinimumWidth": ('int', 'int'),
        "QGridLayout.setColumnStretch": ('int', 'int'),
        "QGridLayout.setDefaultPositioning": ('int', 'PySide2.QtCore.Qt.Orientation'),
        "QGridLayout.setGeometry": ('PySide2.QtCore.QRect',),
        "QGridLayout.setHorizontalSpacing": ('int',),
        "QGridLayout.setOriginCorner": ('PySide2.QtCore.Qt.Corner',),
        "QGridLayout.setRowMinimumHeight": ('int', 'int'),
        "QGridLayout.setRowStretch": ('int', 'int'),
        "QGridLayout.setSpacing": ('int',),
        "QGridLayout.setVerticalSpacing": ('int',),
        "QGridLayout.sizeHint": (),
        "QGridLayout.spacing": (),
        "QGridLayout.takeAt": ('int',),
        "QGridLayout.verticalSpacing": (),

    # class PySide2.QtWidgets.QGroupBox:
        "QGroupBox.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
        "QGroupBox.alignment": (),
        "QGroupBox.changeEvent": ('PySide2.QtCore.QEvent',),
        "QGroupBox.childEvent": ('PySide2.QtCore.QChildEvent',),
        "QGroupBox.event": ('PySide2.QtCore.QEvent',),
        "QGroupBox.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QGroupBox.initStyleOption": ('PySide2.QtWidgets.QStyleOptionGroupBox',),
        "QGroupBox.isCheckable": (),
        "QGroupBox.isChecked": (),
        "QGroupBox.isFlat": (),
        "QGroupBox.minimumSizeHint": (),
        "QGroupBox.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QGroupBox.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QGroupBox.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QGroupBox.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QGroupBox.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QGroupBox.setAlignment": ('int',),
        "QGroupBox.setCheckable": ('bool',),
        "QGroupBox.setChecked": ('bool',),
        "QGroupBox.setFlat": ('bool',),
        "QGroupBox.setTitle": ('str',),
        "QGroupBox.title": (),

    # class PySide2.QtWidgets.QHBoxLayout:
        "QHBoxLayout.__init__": [(), ('PySide2.QtWidgets.QWidget',)],

    # class PySide2.QtWidgets.QHeaderView:
        "QHeaderView.__init__": ('PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QWidget'),
        "QHeaderView.cascadingSectionResizes": (),
        "QHeaderView.count": (),
        "QHeaderView.currentChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
        "QHeaderView.dataChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex', 'list'),
        "QHeaderView.defaultAlignment": (),
        "QHeaderView.defaultSectionSize": (),
        "QHeaderView.doItemsLayout": (),
        "QHeaderView.event": ('PySide2.QtCore.QEvent',),
        "QHeaderView.headerDataChanged": ('PySide2.QtCore.Qt.Orientation', 'int', 'int'),
        "QHeaderView.hiddenSectionCount": (),
        "QHeaderView.hideSection": ('int',),
        "QHeaderView.highlightSections": (),
        "QHeaderView.horizontalOffset": (),
        "QHeaderView.indexAt": ('PySide2.QtCore.QPoint',),
        "QHeaderView.initStyleOption": [('PySide2.QtWidgets.QStyleOptionFrame',), ('PySide2.QtWidgets.QStyleOptionHeader',)],
        "QHeaderView.initialize": (),
        "QHeaderView.initializeSections": [(), ('int', 'int')],
        "QHeaderView.isFirstSectionMovable": (),
        "QHeaderView.isIndexHidden": ('PySide2.QtCore.QModelIndex',),
        "QHeaderView.isSectionHidden": ('int',),
        "QHeaderView.isSortIndicatorShown": (),
        "QHeaderView.length": (),
        "QHeaderView.logicalIndex": ('int',),
        "QHeaderView.logicalIndexAt": [('PySide2.QtCore.QPoint',), ('int',), ('int', 'int')],
        "QHeaderView.maximumSectionSize": (),
        "QHeaderView.minimumSectionSize": (),
        "QHeaderView.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
        "QHeaderView.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QHeaderView.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QHeaderView.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QHeaderView.moveCursor": ('PySide2.QtWidgets.QAbstractItemView.CursorAction', 'PySide2.QtCore.Qt.KeyboardModifiers'),
        "QHeaderView.moveSection": ('int', 'int'),
        "QHeaderView.offset": (),
        "QHeaderView.orientation": (),
        "QHeaderView.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QHeaderView.paintSection": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'int'),
        "QHeaderView.reset": (),
        "QHeaderView.resetDefaultSectionSize": (),
        "QHeaderView.resizeContentsPrecision": (),
        "QHeaderView.resizeSection": ('int', 'int'),
        "QHeaderView.resizeSections": [(), ('PySide2.QtWidgets.QHeaderView.ResizeMode',)],
        "QHeaderView.restoreState": ('PySide2.QtCore.QByteArray',),
        "QHeaderView.rowsInserted": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QHeaderView.saveState": (),
        "QHeaderView.scrollContentsBy": ('int', 'int'),
        "QHeaderView.scrollTo": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
        "QHeaderView.sectionPosition": ('int',),
        "QHeaderView.sectionResizeMode": ('int',),
        "QHeaderView.sectionSize": ('int',),
        "QHeaderView.sectionSizeFromContents": ('int',),
        "QHeaderView.sectionSizeHint": ('int',),
        "QHeaderView.sectionViewportPosition": ('int',),
        "QHeaderView.sectionsAboutToBeRemoved": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QHeaderView.sectionsClickable": (),
        "QHeaderView.sectionsHidden": (),
        "QHeaderView.sectionsInserted": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QHeaderView.sectionsMovable": (),
        "QHeaderView.sectionsMoved": (),
        "QHeaderView.setCascadingSectionResizes": ('bool',),
        "QHeaderView.setDefaultAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QHeaderView.setDefaultSectionSize": ('int',),
        "QHeaderView.setFirstSectionMovable": ('bool',),
        "QHeaderView.setHighlightSections": ('bool',),
        "QHeaderView.setMaximumSectionSize": ('int',),
        "QHeaderView.setMinimumSectionSize": ('int',),
        "QHeaderView.setModel": ('PySide2.QtCore.QAbstractItemModel',),
        "QHeaderView.setOffset": ('int',),
        "QHeaderView.setOffsetToLastSection": (),
        "QHeaderView.setOffsetToSectionPosition": ('int',),
        "QHeaderView.setResizeContentsPrecision": ('int',),
        "QHeaderView.setSectionHidden": ('int', 'bool'),
        "QHeaderView.setSectionResizeMode": [('PySide2.QtWidgets.QHeaderView.ResizeMode',), ('int', 'PySide2.QtWidgets.QHeaderView.ResizeMode')],
        "QHeaderView.setSectionsClickable": ('bool',),
        "QHeaderView.setSectionsMovable": ('bool',),
        "QHeaderView.setSelection": ('PySide2.QtCore.QRect', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
        "QHeaderView.setSortIndicator": ('int', 'PySide2.QtCore.Qt.SortOrder'),
        "QHeaderView.setSortIndicatorShown": ('bool',),
        "QHeaderView.setStretchLastSection": ('bool',),
        "QHeaderView.setVisible": ('bool',),
        "QHeaderView.showSection": ('int',),
        "QHeaderView.sizeHint": (),
        "QHeaderView.sortIndicatorOrder": (),
        "QHeaderView.sortIndicatorSection": (),
        "QHeaderView.stretchLastSection": (),
        "QHeaderView.stretchSectionCount": (),
        "QHeaderView.swapSections": ('int', 'int'),
        "QHeaderView.updateGeometries": (),
        "QHeaderView.updateSection": ('int',),
        "QHeaderView.verticalOffset": (),
        "QHeaderView.viewportEvent": ('PySide2.QtCore.QEvent',),
        "QHeaderView.visualIndex": ('int',),
        "QHeaderView.visualIndexAt": ('int',),
        "QHeaderView.visualRect": ('PySide2.QtCore.QModelIndex',),
        "QHeaderView.visualRegionForSelection": ('PySide2.QtCore.QItemSelection',),

    # class PySide2.QtWidgets.QInputDialog:
        "QInputDialog.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
        "QInputDialog.cancelButtonText": (),
        "QInputDialog.comboBoxItems": (),
        "QInputDialog.done": ('int',),
        "QInputDialog.doubleDecimals": (),
        "QInputDialog.doubleMaximum": (),
        "QInputDialog.doubleMinimum": (),
        "QInputDialog.doubleStep": (),
        "QInputDialog.doubleValue": (),
        "QInputDialog.getDouble": [('PySide2.QtWidgets.QWidget', 'str', 'str', 'float', 'float', 'float', 'int', 'bool', 'PySide2.QtCore.Qt.WindowFlags'), ('PySide2.QtWidgets.QWidget', 'str', 'str', 'float', 'float', 'float', 'int', 'bool', 'PySide2.QtCore.Qt.WindowFlags', 'float')],
        "QInputDialog.getInt": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'int', 'int', 'int', 'int', 'bool', 'PySide2.QtCore.Qt.WindowFlags'),
        "QInputDialog.getItem": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'typing.List[str]', 'int', 'bool', 'bool', 'PySide2.QtCore.Qt.WindowFlags', 'PySide2.QtCore.Qt.InputMethodHints'),
        "QInputDialog.getMultiLineText": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'str', 'bool', 'PySide2.QtCore.Qt.WindowFlags', 'PySide2.QtCore.Qt.InputMethodHints'),
        "QInputDialog.getText": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QLineEdit.EchoMode', 'str', 'bool', 'PySide2.QtCore.Qt.WindowFlags', 'PySide2.QtCore.Qt.InputMethodHints'),
        "QInputDialog.inputMode": (),
        "QInputDialog.intMaximum": (),
        "QInputDialog.intMinimum": (),
        "QInputDialog.intStep": (),
        "QInputDialog.intValue": (),
        "QInputDialog.isComboBoxEditable": (),
        "QInputDialog.labelText": (),
        "QInputDialog.minimumSizeHint": (),
        "QInputDialog.okButtonText": (),
        "QInputDialog.open": [(), ('PySide2.QtCore.QObject', 'str')],
        "QInputDialog.setCancelButtonText": ('str',),
        "QInputDialog.setComboBoxEditable": ('bool',),
        "QInputDialog.setComboBoxItems": ('typing.List[str]',),
        "QInputDialog.setDoubleDecimals": ('int',),
        "QInputDialog.setDoubleMaximum": ('float',),
        "QInputDialog.setDoubleMinimum": ('float',),
        "QInputDialog.setDoubleRange": ('float', 'float'),
        "QInputDialog.setDoubleStep": ('float',),
        "QInputDialog.setDoubleValue": ('float',),
        "QInputDialog.setInputMode": ('PySide2.QtWidgets.QInputDialog.InputMode',),
        "QInputDialog.setIntMaximum": ('int',),
        "QInputDialog.setIntMinimum": ('int',),
        "QInputDialog.setIntRange": ('int', 'int'),
        "QInputDialog.setIntStep": ('int',),
        "QInputDialog.setIntValue": ('int',),
        "QInputDialog.setLabelText": ('str',),
        "QInputDialog.setOkButtonText": ('str',),
        "QInputDialog.setOption": ('PySide2.QtWidgets.QInputDialog.InputDialogOption', 'bool'),
        "QInputDialog.setTextEchoMode": ('PySide2.QtWidgets.QLineEdit.EchoMode',),
        "QInputDialog.setTextValue": ('str',),
        "QInputDialog.setVisible": ('bool',),
        "QInputDialog.sizeHint": (),
        "QInputDialog.testOption": ('PySide2.QtWidgets.QInputDialog.InputDialogOption',),
        "QInputDialog.textEchoMode": (),
        "QInputDialog.textValue": (),

    # class PySide2.QtWidgets.QItemDelegate:
        "QItemDelegate.__init__": ('PySide2.QtCore.QObject',),
        "QItemDelegate.createEditor": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QItemDelegate.decoration": ('PySide2.QtWidgets.QStyleOptionViewItem', 'typing.Any'),
        "QItemDelegate.doCheck": ('PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QRect', 'typing.Any'),
        "QItemDelegate.drawBackground": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QItemDelegate.drawCheck": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.CheckState'),
        "QItemDelegate.drawDecoration": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QRect', 'PySide2.QtGui.QPixmap'),
        "QItemDelegate.drawDisplay": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QRect', 'str'),
        "QItemDelegate.drawFocus": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QRect'),
        "QItemDelegate.editorEvent": ('PySide2.QtCore.QEvent', 'PySide2.QtCore.QAbstractItemModel', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QItemDelegate.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QItemDelegate.hasClipping": (),
        "QItemDelegate.itemEditorFactory": (),
        "QItemDelegate.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QItemDelegate.rect": ('PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex', 'int'),
        "QItemDelegate.setClipping": ('bool',),
        "QItemDelegate.setEditorData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QModelIndex'),
        "QItemDelegate.setItemEditorFactory": ('PySide2.QtWidgets.QItemEditorFactory',),
        "QItemDelegate.setModelData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QAbstractItemModel', 'PySide2.QtCore.QModelIndex'),
        "QItemDelegate.setOptions": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QStyleOptionViewItem'),
        "QItemDelegate.sizeHint": ('PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QItemDelegate.textRectangle": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'PySide2.QtGui.QFont', 'str'),
        "QItemDelegate.updateEditorGeometry": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),

    # class PySide2.QtWidgets.QItemEditorCreatorBase:
        "QItemEditorCreatorBase.__init__": (),
        "QItemEditorCreatorBase.createWidget": ('PySide2.QtWidgets.QWidget',),
        "QItemEditorCreatorBase.valuePropertyName": (),

    # class PySide2.QtWidgets.QItemEditorFactory:
        "QItemEditorFactory.__init__": (),
        "QItemEditorFactory.createEditor": ('int', 'PySide2.QtWidgets.QWidget'),
        "QItemEditorFactory.defaultFactory": (),
        "QItemEditorFactory.registerEditor": ('int', 'PySide2.QtWidgets.QItemEditorCreatorBase'),
        "QItemEditorFactory.setDefaultFactory": ('PySide2.QtWidgets.QItemEditorFactory',),
        "QItemEditorFactory.valuePropertyName": ('int',),

    # class PySide2.QtWidgets.QKeyEventTransition:
        "QKeyEventTransition.__init__": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent.Type', 'int', 'PySide2.QtCore.QState'), ('PySide2.QtCore.QState',)],
        "QKeyEventTransition.eventTest": ('PySide2.QtCore.QEvent',),
        "QKeyEventTransition.key": (),
        "QKeyEventTransition.modifierMask": (),
        "QKeyEventTransition.onTransition": ('PySide2.QtCore.QEvent',),
        "QKeyEventTransition.setKey": ('int',),
        "QKeyEventTransition.setModifierMask": ('PySide2.QtCore.Qt.KeyboardModifiers',),

    # class PySide2.QtWidgets.QKeySequenceEdit:
        "QKeySequenceEdit.__init__": [('PySide2.QtGui.QKeySequence', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
        "QKeySequenceEdit.clear": (),
        "QKeySequenceEdit.event": ('PySide2.QtCore.QEvent',),
        "QKeySequenceEdit.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QKeySequenceEdit.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
        "QKeySequenceEdit.keySequence": (),
        "QKeySequenceEdit.setKeySequence": ('PySide2.QtGui.QKeySequence',),
        "QKeySequenceEdit.timerEvent": ('PySide2.QtCore.QTimerEvent',),

    # class PySide2.QtWidgets.QLCDNumber:
        "QLCDNumber.__init__": [('PySide2.QtWidgets.QWidget',), ('int', 'PySide2.QtWidgets.QWidget')],
        "QLCDNumber.checkOverflow": [('float',), ('int',)],
        "QLCDNumber.digitCount": (),
        "QLCDNumber.display": [('float',), ('int',), ('str',)],
        "QLCDNumber.event": ('PySide2.QtCore.QEvent',),
        "QLCDNumber.intValue": (),
        "QLCDNumber.mode": (),
        "QLCDNumber.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QLCDNumber.segmentStyle": (),
        "QLCDNumber.setBinMode": (),
        "QLCDNumber.setDecMode": (),
        "QLCDNumber.setDigitCount": ('int',),
        "QLCDNumber.setHexMode": (),
        "QLCDNumber.setMode": ('PySide2.QtWidgets.QLCDNumber.Mode',),
        "QLCDNumber.setOctMode": (),
        "QLCDNumber.setSegmentStyle": ('PySide2.QtWidgets.QLCDNumber.SegmentStyle',),
        "QLCDNumber.setSmallDecimalPoint": ('bool',),
        "QLCDNumber.sizeHint": (),
        "QLCDNumber.smallDecimalPoint": (),
        "QLCDNumber.value": (),

    # class PySide2.QtWidgets.QLabel:
        "QLabel.__init__": [('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('str', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags')],
        "QLabel.alignment": (),
        "QLabel.buddy": (),
        "QLabel.changeEvent": ('PySide2.QtCore.QEvent',),
        "QLabel.clear": (),
        "QLabel.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
        "QLabel.event": ('PySide2.QtCore.QEvent',),
        "QLabel.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QLabel.focusNextPrevChild": ('bool',),
        "QLabel.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QLabel.hasScaledContents": (),
        "QLabel.hasSelectedText": (),
        "QLabel.heightForWidth": ('int',),
        "QLabel.indent": (),
        "QLabel.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QLabel.margin": (),
        "QLabel.minimumSizeHint": (),
        "QLabel.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QLabel.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QLabel.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QLabel.movie": (),
        "QLabel.openExternalLinks": (),
        "QLabel.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QLabel.picture": (),
        "QLabel.pixmap": (),
        "QLabel.selectedText": (),
        "QLabel.selectionStart": (),
        "QLabel.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QLabel.setBuddy": ('PySide2.QtWidgets.QWidget',),
        "QLabel.setIndent": ('int',),
        "QLabel.setMargin": ('int',),
        "QLabel.setMovie": ('PySide2.QtGui.QMovie',),
        "QLabel.setNum": [('float',), ('int',)],
        "QLabel.setOpenExternalLinks": ('bool',),
        "QLabel.setPicture": ('PySide2.QtGui.QPicture',),
        "QLabel.setPixmap": ('PySide2.QtGui.QPixmap',),
        "QLabel.setScaledContents": ('bool',),
        "QLabel.setSelection": ('int', 'int'),
        "QLabel.setText": ('str',),
        "QLabel.setTextFormat": ('PySide2.QtCore.Qt.TextFormat',),
        "QLabel.setTextInteractionFlags": ('PySide2.QtCore.Qt.TextInteractionFlags',),
        "QLabel.setWordWrap": ('bool',),
        "QLabel.sizeHint": (),
        "QLabel.text": (),
        "QLabel.textFormat": (),
        "QLabel.textInteractionFlags": (),
        "QLabel.wordWrap": (),

    # class PySide2.QtWidgets.QLayout:
        "QLayout.__init__": [(), ('PySide2.QtWidgets.QWidget',)],
        "QLayout.activate": (),
        "QLayout.addChildLayout": ('PySide2.QtWidgets.QLayout',),
        "QLayout.addChildWidget": ('PySide2.QtWidgets.QWidget',),
        "QLayout.addItem": ('PySide2.QtWidgets.QLayoutItem',),
        "QLayout.addWidget": ('PySide2.QtWidgets.QWidget',),
        "QLayout.adoptLayout": ('PySide2.QtWidgets.QLayout',),
        "QLayout.alignmentRect": ('PySide2.QtCore.QRect',),
        "QLayout.childEvent": ('PySide2.QtCore.QChildEvent',),
        "QLayout.closestAcceptableSize": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QSize'),
        "QLayout.contentsMargins": (),
        "QLayout.contentsRect": (),
        "QLayout.controlTypes": (),
        "QLayout.count": (),
        "QLayout.expandingDirections": (),
        "QLayout.geometry": (),
        "QLayout.getContentsMargins": ('int', 'int', 'int', 'int'),
        "QLayout.indexOf": [('PySide2.QtWidgets.QLayoutItem',), ('PySide2.QtWidgets.QWidget',)],
        "QLayout.invalidate": (),
        "QLayout.isEmpty": (),
        "QLayout.isEnabled": (),
        "QLayout.itemAt": ('int',),
        "QLayout.layout": (),
        "QLayout.margin": (),
        "QLayout.maximumSize": (),
        "QLayout.menuBar": (),
        "QLayout.minimumSize": (),
        "QLayout.parentWidget": (),
        "QLayout.removeItem": ('PySide2.QtWidgets.QLayoutItem',),
        "QLayout.removeWidget": ('PySide2.QtWidgets.QWidget',),
        "QLayout.replaceWidget": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.FindChildOptions'),
        "QLayout.setAlignment": [('PySide2.QtCore.Qt.Alignment',), ('PySide2.QtWidgets.QLayout', 'PySide2.QtCore.Qt.Alignment'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.Alignment')],
        "QLayout.setContentsMargins": [('PySide2.QtCore.QMargins',), ('int', 'int', 'int', 'int')],
        "QLayout.setEnabled": ('bool',),
        "QLayout.setGeometry": ('PySide2.QtCore.QRect',),
        "QLayout.setMargin": ('int',),
        "QLayout.setMenuBar": ('PySide2.QtWidgets.QWidget',),
        "QLayout.setSizeConstraint": ('PySide2.QtWidgets.QLayout.SizeConstraint',),
        "QLayout.setSpacing": ('int',),
        "QLayout.sizeConstraint": (),
        "QLayout.spacing": (),
        "QLayout.takeAt": ('int',),
        "QLayout.totalHeightForWidth": ('int',),
        "QLayout.totalMaximumSize": (),
        "QLayout.totalMinimumSize": (),
        "QLayout.totalSizeHint": (),
        "QLayout.update": (),
        "QLayout.widgetEvent": ('PySide2.QtCore.QEvent',),

    # class PySide2.QtWidgets.QLayoutItem:
        "QLayoutItem.__init__": ('PySide2.QtCore.Qt.Alignment',),
        "QLayoutItem.alignment": (),
        "QLayoutItem.controlTypes": (),
        "QLayoutItem.expandingDirections": (),
        "QLayoutItem.geometry": (),
        "QLayoutItem.hasHeightForWidth": (),
        "QLayoutItem.heightForWidth": ('int',),
        "QLayoutItem.invalidate": (),
        "QLayoutItem.isEmpty": (),
        "QLayoutItem.layout": (),
        "QLayoutItem.maximumSize": (),
        "QLayoutItem.minimumHeightForWidth": ('int',),
        "QLayoutItem.minimumSize": (),
        "QLayoutItem.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QLayoutItem.setGeometry": ('PySide2.QtCore.QRect',),
        "QLayoutItem.sizeHint": (),
        "QLayoutItem.spacerItem": (),
        "QLayoutItem.widget": (),

    # class PySide2.QtWidgets.QLineEdit:
        "QLineEdit.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
        "QLineEdit.addAction": [('PySide2.QtGui.QIcon', 'PySide2.QtWidgets.QLineEdit.ActionPosition'), ('PySide2.QtWidgets.QAction',), ('PySide2.QtWidgets.QAction', 'PySide2.QtWidgets.QLineEdit.ActionPosition')],
        "QLineEdit.alignment": (),
        "QLineEdit.backspace": (),
        "QLineEdit.changeEvent": ('PySide2.QtCore.QEvent',),
        "QLineEdit.clear": (),
        "QLineEdit.completer": (),
        "QLineEdit.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
        "QLineEdit.copy": (),
        "QLineEdit.createStandardContextMenu": (),
        "QLineEdit.cursorBackward": ('bool', 'int'),
        "QLineEdit.cursorForward": ('bool', 'int'),
        "QLineEdit.cursorMoveStyle": (),
        "QLineEdit.cursorPosition": (),
        "QLineEdit.cursorPositionAt": ('PySide2.QtCore.QPoint',),
        "QLineEdit.cursorRect": (),
        "QLineEdit.cursorWordBackward": ('bool',),
        "QLineEdit.cursorWordForward": ('bool',),
        "QLineEdit.cut": (),
        "QLineEdit.del_": (),
        "QLineEdit.deselect": (),
        "QLineEdit.displayText": (),
        "QLineEdit.dragEnabled": (),
        "QLineEdit.dragEnterEvent": ('PySide2.QtGui.QDragEnterEvent',),
        "QLineEdit.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
        "QLineEdit.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
        "QLineEdit.dropEvent": ('PySide2.QtGui.QDropEvent',),
        "QLineEdit.echoMode": (),
        "QLineEdit.end": ('bool',),
        "QLineEdit.event": ('PySide2.QtCore.QEvent',),
        "QLineEdit.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QLineEdit.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QLineEdit.getTextMargins": ('int', 'int', 'int', 'int'),
        "QLineEdit.hasAcceptableInput": (),
        "QLineEdit.hasFrame": (),
        "QLineEdit.hasSelectedText": (),
        "QLineEdit.home": ('bool',),
        "QLineEdit.initStyleOption": ('PySide2.QtWidgets.QStyleOptionFrame',),
        "QLineEdit.inputMask": (),
        "QLineEdit.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
        "QLineEdit.inputMethodQuery": [('PySide2.QtCore.Qt.InputMethodQuery',), ('PySide2.QtCore.Qt.InputMethodQuery', 'typing.Any')],
        "QLineEdit.insert": ('str',),
        "QLineEdit.isClearButtonEnabled": (),
        "QLineEdit.isModified": (),
        "QLineEdit.isReadOnly": (),
        "QLineEdit.isRedoAvailable": (),
        "QLineEdit.isUndoAvailable": (),
        "QLineEdit.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QLineEdit.maxLength": (),
        "QLineEdit.minimumSizeHint": (),
        "QLineEdit.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
        "QLineEdit.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QLineEdit.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QLineEdit.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QLineEdit.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QLineEdit.paste": (),
        "QLineEdit.placeholderText": (),
        "QLineEdit.redo": (),
        "QLineEdit.selectAll": (),
        "QLineEdit.selectedText": (),
        "QLineEdit.selectionEnd": (),
        "QLineEdit.selectionLength": (),
        "QLineEdit.selectionStart": (),
        "QLineEdit.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QLineEdit.setClearButtonEnabled": ('bool',),
        "QLineEdit.setCompleter": ('PySide2.QtWidgets.QCompleter',),
        "QLineEdit.setCursorMoveStyle": ('PySide2.QtCore.Qt.CursorMoveStyle',),
        "QLineEdit.setCursorPosition": ('int',),
        "QLineEdit.setDragEnabled": ('bool',),
        "QLineEdit.setEchoMode": ('PySide2.QtWidgets.QLineEdit.EchoMode',),
        "QLineEdit.setFrame": ('bool',),
        "QLineEdit.setInputMask": ('str',),
        "QLineEdit.setMaxLength": ('int',),
        "QLineEdit.setModified": ('bool',),
        "QLineEdit.setPlaceholderText": ('str',),
        "QLineEdit.setReadOnly": ('bool',),
        "QLineEdit.setSelection": ('int', 'int'),
        "QLineEdit.setText": ('str',),
        "QLineEdit.setTextMargins": [('PySide2.QtCore.QMargins',), ('int', 'int', 'int', 'int')],
        "QLineEdit.setValidator": ('PySide2.QtGui.QValidator',),
        "QLineEdit.sizeHint": (),
        "QLineEdit.text": (),
        "QLineEdit.textMargins": (),
        "QLineEdit.undo": (),
        "QLineEdit.validator": (),

    # class PySide2.QtWidgets.QListView:
        "QListView.__init__": ('PySide2.QtWidgets.QWidget',),
        "QListView.batchSize": (),
        "QListView.clearPropertyFlags": (),
        "QListView.contentsSize": (),
        "QListView.currentChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
        "QListView.dataChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex', 'list'),
        "QListView.doItemsLayout": (),
        "QListView.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
        "QListView.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
        "QListView.dropEvent": ('PySide2.QtGui.QDropEvent',),
        "QListView.event": ('PySide2.QtCore.QEvent',),
        "QListView.flow": (),
        "QListView.gridSize": (),
        "QListView.horizontalOffset": (),
        "QListView.indexAt": ('PySide2.QtCore.QPoint',),
        "QListView.isIndexHidden": ('PySide2.QtCore.QModelIndex',),
        "QListView.isRowHidden": ('int',),
        "QListView.isSelectionRectVisible": (),
        "QListView.isWrapping": (),
        "QListView.itemAlignment": (),
        "QListView.layoutMode": (),
        "QListView.modelColumn": (),
        "QListView.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QListView.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QListView.moveCursor": ('PySide2.QtWidgets.QAbstractItemView.CursorAction', 'PySide2.QtCore.Qt.KeyboardModifiers'),
        "QListView.movement": (),
        "QListView.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QListView.rectForIndex": ('PySide2.QtCore.QModelIndex',),
        "QListView.reset": (),
        "QListView.resizeContents": ('int', 'int'),
        "QListView.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QListView.resizeMode": (),
        "QListView.rowsAboutToBeRemoved": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QListView.rowsInserted": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QListView.scrollContentsBy": ('int', 'int'),
        "QListView.scrollTo": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
        "QListView.selectedIndexes": (),
        "QListView.selectionChanged": ('PySide2.QtCore.QItemSelection', 'PySide2.QtCore.QItemSelection'),
        "QListView.setBatchSize": ('int',),
        "QListView.setFlow": ('PySide2.QtWidgets.QListView.Flow',),
        "QListView.setGridSize": ('PySide2.QtCore.QSize',),
        "QListView.setItemAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QListView.setLayoutMode": ('PySide2.QtWidgets.QListView.LayoutMode',),
        "QListView.setModelColumn": ('int',),
        "QListView.setMovement": ('PySide2.QtWidgets.QListView.Movement',),
        "QListView.setPositionForIndex": ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QModelIndex'),
        "QListView.setResizeMode": ('PySide2.QtWidgets.QListView.ResizeMode',),
        "QListView.setRootIndex": ('PySide2.QtCore.QModelIndex',),
        "QListView.setRowHidden": ('int', 'bool'),
        "QListView.setSelection": ('PySide2.QtCore.QRect', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
        "QListView.setSelectionRectVisible": ('bool',),
        "QListView.setSpacing": ('int',),
        "QListView.setUniformItemSizes": ('bool',),
        "QListView.setViewMode": ('PySide2.QtWidgets.QListView.ViewMode',),
        "QListView.setWordWrap": ('bool',),
        "QListView.setWrapping": ('bool',),
        "QListView.spacing": (),
        "QListView.startDrag": ('PySide2.QtCore.Qt.DropActions',),
        "QListView.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QListView.uniformItemSizes": (),
        "QListView.updateGeometries": (),
        "QListView.verticalOffset": (),
        "QListView.viewMode": (),
        "QListView.viewOptions": (),
        "QListView.viewportSizeHint": (),
        "QListView.visualRect": ('PySide2.QtCore.QModelIndex',),
        "QListView.visualRegionForSelection": ('PySide2.QtCore.QItemSelection',),
        "QListView.wheelEvent": ('PySide2.QtGui.QWheelEvent',),
        "QListView.wordWrap": (),

    # class PySide2.QtWidgets.QListWidget:
        "QListWidget.__init__": ('PySide2.QtWidgets.QWidget',),
        "QListWidget.addItem": [('PySide2.QtWidgets.QListWidgetItem',), ('str',)],
        "QListWidget.addItems": ('typing.List[str]',),
        "QListWidget.clear": (),
        "QListWidget.closePersistentEditor": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QListWidgetItem',)],
        "QListWidget.count": (),
        "QListWidget.currentItem": (),
        "QListWidget.currentRow": (),
        "QListWidget.dropEvent": ('PySide2.QtGui.QDropEvent',),
        "QListWidget.dropMimeData": ('int', 'PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction'),
        "QListWidget.editItem": ('PySide2.QtWidgets.QListWidgetItem',),
        "QListWidget.event": ('PySide2.QtCore.QEvent',),
        "QListWidget.findItems": ('str', 'PySide2.QtCore.Qt.MatchFlags'),
        "QListWidget.indexFromItem": ('PySide2.QtWidgets.QListWidgetItem',),
        "QListWidget.insertItem": [('int', 'PySide2.QtWidgets.QListWidgetItem'), ('int', 'str')],
        "QListWidget.insertItems": ('int', 'typing.List[str]'),
        "QListWidget.isItemHidden": ('PySide2.QtWidgets.QListWidgetItem',),
        "QListWidget.isItemSelected": ('PySide2.QtWidgets.QListWidgetItem',),
        "QListWidget.isPersistentEditorOpen": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QListWidgetItem',)],
        "QListWidget.isSortingEnabled": (),
        "QListWidget.item": ('int',),
        "QListWidget.itemAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QListWidget.itemFromIndex": ('PySide2.QtCore.QModelIndex',),
        "QListWidget.itemWidget": ('PySide2.QtWidgets.QListWidgetItem',),
        "QListWidget.items": ('PySide2.QtCore.QMimeData',),
        "QListWidget.mimeData": ('list',),
        "QListWidget.mimeTypes": (),
        "QListWidget.openPersistentEditor": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QListWidgetItem',)],
        "QListWidget.removeItemWidget": ('PySide2.QtWidgets.QListWidgetItem',),
        "QListWidget.row": ('PySide2.QtWidgets.QListWidgetItem',),
        "QListWidget.scrollToItem": ('PySide2.QtWidgets.QListWidgetItem', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
        "QListWidget.selectedItems": (),
        "QListWidget.setCurrentItem": [('PySide2.QtWidgets.QListWidgetItem',), ('PySide2.QtWidgets.QListWidgetItem', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags')],
        "QListWidget.setCurrentRow": [('int',), ('int', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags')],
        "QListWidget.setItemHidden": ('PySide2.QtWidgets.QListWidgetItem', 'bool'),
        "QListWidget.setItemSelected": ('PySide2.QtWidgets.QListWidgetItem', 'bool'),
        "QListWidget.setItemWidget": ('PySide2.QtWidgets.QListWidgetItem', 'PySide2.QtWidgets.QWidget'),
        "QListWidget.setModel": ('PySide2.QtCore.QAbstractItemModel',),
        "QListWidget.setSelectionModel": ('PySide2.QtCore.QItemSelectionModel',),
        "QListWidget.setSortingEnabled": ('bool',),
        "QListWidget.sortItems": ('PySide2.QtCore.Qt.SortOrder',),
        "QListWidget.supportedDropActions": (),
        "QListWidget.takeItem": ('int',),
        "QListWidget.visualItemRect": ('PySide2.QtWidgets.QListWidgetItem',),

    # class PySide2.QtWidgets.QListWidgetItem:
        "QListWidgetItem.__init__": [('PySide2.QtGui.QIcon', 'str', 'PySide2.QtWidgets.QListWidget', 'int'), ('PySide2.QtWidgets.QListWidget', 'int'), ('PySide2.QtWidgets.QListWidgetItem',), ('str', 'PySide2.QtWidgets.QListWidget', 'int')],
        "QListWidgetItem.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QListWidgetItem.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QListWidgetItem.background": (),
        "QListWidgetItem.backgroundColor": (),
        "QListWidgetItem.checkState": (),
        "QListWidgetItem.clone": (),
        "QListWidgetItem.data": ('int',),
        "QListWidgetItem.flags": (),
        "QListWidgetItem.font": (),
        "QListWidgetItem.foreground": (),
        "QListWidgetItem.icon": (),
        "QListWidgetItem.isHidden": (),
        "QListWidgetItem.isSelected": (),
        "QListWidgetItem.listWidget": (),
        "QListWidgetItem.read": ('PySide2.QtCore.QDataStream',),
        "QListWidgetItem.setBackground": ('PySide2.QtGui.QBrush',),
        "QListWidgetItem.setBackgroundColor": ('PySide2.QtGui.QColor',),
        "QListWidgetItem.setCheckState": ('PySide2.QtCore.Qt.CheckState',),
        "QListWidgetItem.setData": ('int', 'typing.Any'),
        "QListWidgetItem.setFlags": ('PySide2.QtCore.Qt.ItemFlags',),
        "QListWidgetItem.setFont": ('PySide2.QtGui.QFont',),
        "QListWidgetItem.setForeground": ('PySide2.QtGui.QBrush',),
        "QListWidgetItem.setHidden": ('bool',),
        "QListWidgetItem.setIcon": ('PySide2.QtGui.QIcon',),
        "QListWidgetItem.setSelected": ('bool',),
        "QListWidgetItem.setSizeHint": ('PySide2.QtCore.QSize',),
        "QListWidgetItem.setStatusTip": ('str',),
        "QListWidgetItem.setText": ('str',),
        "QListWidgetItem.setTextAlignment": ('int',),
        "QListWidgetItem.setTextColor": ('PySide2.QtGui.QColor',),
        "QListWidgetItem.setToolTip": ('str',),
        "QListWidgetItem.setWhatsThis": ('str',),
        "QListWidgetItem.sizeHint": (),
        "QListWidgetItem.statusTip": (),
        "QListWidgetItem.text": (),
        "QListWidgetItem.textAlignment": (),
        "QListWidgetItem.textColor": (),
        "QListWidgetItem.toolTip": (),
        "QListWidgetItem.type": (),
        "QListWidgetItem.whatsThis": (),
        "QListWidgetItem.write": ('PySide2.QtCore.QDataStream',),

    # class PySide2.QtWidgets.QMainWindow:
        "QMainWindow.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
        "QMainWindow.addDockWidget": [('PySide2.QtCore.Qt.DockWidgetArea', 'PySide2.QtWidgets.QDockWidget'), ('PySide2.QtCore.Qt.DockWidgetArea', 'PySide2.QtWidgets.QDockWidget', 'PySide2.QtCore.Qt.Orientation')],
        "QMainWindow.addToolBar": [('PySide2.QtCore.Qt.ToolBarArea', 'PySide2.QtWidgets.QToolBar'), ('PySide2.QtWidgets.QToolBar',), ('str',)],
        "QMainWindow.addToolBarBreak": ('PySide2.QtCore.Qt.ToolBarArea',),
        "QMainWindow.centralWidget": (),
        "QMainWindow.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
        "QMainWindow.corner": ('PySide2.QtCore.Qt.Corner',),
        "QMainWindow.createPopupMenu": (),
        "QMainWindow.dockOptions": (),
        "QMainWindow.dockWidgetArea": ('PySide2.QtWidgets.QDockWidget',),
        "QMainWindow.documentMode": (),
        "QMainWindow.event": ('PySide2.QtCore.QEvent',),
        "QMainWindow.iconSize": (),
        "QMainWindow.insertToolBar": ('PySide2.QtWidgets.QToolBar', 'PySide2.QtWidgets.QToolBar'),
        "QMainWindow.insertToolBarBreak": ('PySide2.QtWidgets.QToolBar',),
        "QMainWindow.isAnimated": (),
        "QMainWindow.isDockNestingEnabled": (),
        "QMainWindow.isSeparator": ('PySide2.QtCore.QPoint',),
        "QMainWindow.menuBar": (),
        "QMainWindow.menuWidget": (),
        "QMainWindow.removeDockWidget": ('PySide2.QtWidgets.QDockWidget',),
        "QMainWindow.removeToolBar": ('PySide2.QtWidgets.QToolBar',),
        "QMainWindow.removeToolBarBreak": ('PySide2.QtWidgets.QToolBar',),
        "QMainWindow.resizeDocks": ('list', 'list', 'PySide2.QtCore.Qt.Orientation'),
        "QMainWindow.restoreDockWidget": ('PySide2.QtWidgets.QDockWidget',),
        "QMainWindow.restoreState": ('PySide2.QtCore.QByteArray', 'int'),
        "QMainWindow.saveState": ('int',),
        "QMainWindow.setAnimated": ('bool',),
        "QMainWindow.setCentralWidget": ('PySide2.QtWidgets.QWidget',),
        "QMainWindow.setCorner": ('PySide2.QtCore.Qt.Corner', 'PySide2.QtCore.Qt.DockWidgetArea'),
        "QMainWindow.setDockNestingEnabled": ('bool',),
        "QMainWindow.setDockOptions": ('PySide2.QtWidgets.QMainWindow.DockOptions',),
        "QMainWindow.setDocumentMode": ('bool',),
        "QMainWindow.setIconSize": ('PySide2.QtCore.QSize',),
        "QMainWindow.setMenuBar": ('PySide2.QtWidgets.QMenuBar',),
        "QMainWindow.setMenuWidget": ('PySide2.QtWidgets.QWidget',),
        "QMainWindow.setStatusBar": ('PySide2.QtWidgets.QStatusBar',),
        "QMainWindow.setTabPosition": ('PySide2.QtCore.Qt.DockWidgetAreas', 'PySide2.QtWidgets.QTabWidget.TabPosition'),
        "QMainWindow.setTabShape": ('PySide2.QtWidgets.QTabWidget.TabShape',),
        "QMainWindow.setToolButtonStyle": ('PySide2.QtCore.Qt.ToolButtonStyle',),
        "QMainWindow.setUnifiedTitleAndToolBarOnMac": ('bool',),
        "QMainWindow.splitDockWidget": ('PySide2.QtWidgets.QDockWidget', 'PySide2.QtWidgets.QDockWidget', 'PySide2.QtCore.Qt.Orientation'),
        "QMainWindow.statusBar": (),
        "QMainWindow.tabPosition": ('PySide2.QtCore.Qt.DockWidgetArea',),
        "QMainWindow.tabShape": (),
        "QMainWindow.tabifiedDockWidgets": ('PySide2.QtWidgets.QDockWidget',),
        "QMainWindow.tabifyDockWidget": ('PySide2.QtWidgets.QDockWidget', 'PySide2.QtWidgets.QDockWidget'),
        "QMainWindow.takeCentralWidget": (),
        "QMainWindow.toolBarArea": ('PySide2.QtWidgets.QToolBar',),
        "QMainWindow.toolBarBreak": ('PySide2.QtWidgets.QToolBar',),
        "QMainWindow.toolButtonStyle": (),
        "QMainWindow.unifiedTitleAndToolBarOnMac": (),

    # class PySide2.QtWidgets.QMdiArea:
        "QMdiArea.__init__": ('PySide2.QtWidgets.QWidget',),
        "QMdiArea.activateNextSubWindow": (),
        "QMdiArea.activatePreviousSubWindow": (),
        "QMdiArea.activationOrder": (),
        "QMdiArea.activeSubWindow": (),
        "QMdiArea.addSubWindow": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
        "QMdiArea.background": (),
        "QMdiArea.cascadeSubWindows": (),
        "QMdiArea.childEvent": ('PySide2.QtCore.QChildEvent',),
        "QMdiArea.closeActiveSubWindow": (),
        "QMdiArea.closeAllSubWindows": (),
        "QMdiArea.currentSubWindow": (),
        "QMdiArea.documentMode": (),
        "QMdiArea.event": ('PySide2.QtCore.QEvent',),
        "QMdiArea.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QMdiArea.minimumSizeHint": (),
        "QMdiArea.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QMdiArea.removeSubWindow": ('PySide2.QtWidgets.QWidget',),
        "QMdiArea.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QMdiArea.scrollContentsBy": ('int', 'int'),
        "QMdiArea.setActivationOrder": ('PySide2.QtWidgets.QMdiArea.WindowOrder',),
        "QMdiArea.setActiveSubWindow": ('PySide2.QtWidgets.QMdiSubWindow',),
        "QMdiArea.setBackground": ('PySide2.QtGui.QBrush',),
        "QMdiArea.setDocumentMode": ('bool',),
        "QMdiArea.setOption": ('PySide2.QtWidgets.QMdiArea.AreaOption', 'bool'),
        "QMdiArea.setTabPosition": ('PySide2.QtWidgets.QTabWidget.TabPosition',),
        "QMdiArea.setTabShape": ('PySide2.QtWidgets.QTabWidget.TabShape',),
        "QMdiArea.setTabsClosable": ('bool',),
        "QMdiArea.setTabsMovable": ('bool',),
        "QMdiArea.setViewMode": ('PySide2.QtWidgets.QMdiArea.ViewMode',),
        "QMdiArea.setupViewport": ('PySide2.QtWidgets.QWidget',),
        "QMdiArea.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QMdiArea.sizeHint": (),
        "QMdiArea.subWindowList": ('PySide2.QtWidgets.QMdiArea.WindowOrder',),
        "QMdiArea.tabPosition": (),
        "QMdiArea.tabShape": (),
        "QMdiArea.tabsClosable": (),
        "QMdiArea.tabsMovable": (),
        "QMdiArea.testOption": ('PySide2.QtWidgets.QMdiArea.AreaOption',),
        "QMdiArea.tileSubWindows": (),
        "QMdiArea.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QMdiArea.viewMode": (),
        "QMdiArea.viewportEvent": ('PySide2.QtCore.QEvent',),

    # class PySide2.QtWidgets.QMdiSubWindow:
        "QMdiSubWindow.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
        "QMdiSubWindow.changeEvent": ('PySide2.QtCore.QEvent',),
        "QMdiSubWindow.childEvent": ('PySide2.QtCore.QChildEvent',),
        "QMdiSubWindow.closeEvent": ('PySide2.QtGui.QCloseEvent',),
        "QMdiSubWindow.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
        "QMdiSubWindow.event": ('PySide2.QtCore.QEvent',),
        "QMdiSubWindow.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QMdiSubWindow.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QMdiSubWindow.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QMdiSubWindow.hideEvent": ('PySide2.QtGui.QHideEvent',),
        "QMdiSubWindow.isShaded": (),
        "QMdiSubWindow.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QMdiSubWindow.keyboardPageStep": (),
        "QMdiSubWindow.keyboardSingleStep": (),
        "QMdiSubWindow.leaveEvent": ('PySide2.QtCore.QEvent',),
        "QMdiSubWindow.maximizedButtonsWidget": (),
        "QMdiSubWindow.maximizedSystemMenuIconWidget": (),
        "QMdiSubWindow.mdiArea": (),
        "QMdiSubWindow.minimumSizeHint": (),
        "QMdiSubWindow.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
        "QMdiSubWindow.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QMdiSubWindow.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QMdiSubWindow.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QMdiSubWindow.moveEvent": ('PySide2.QtGui.QMoveEvent',),
        "QMdiSubWindow.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QMdiSubWindow.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QMdiSubWindow.setKeyboardPageStep": ('int',),
        "QMdiSubWindow.setKeyboardSingleStep": ('int',),
        "QMdiSubWindow.setOption": ('PySide2.QtWidgets.QMdiSubWindow.SubWindowOption', 'bool'),
        "QMdiSubWindow.setSystemMenu": ('PySide2.QtWidgets.QMenu',),
        "QMdiSubWindow.setWidget": ('PySide2.QtWidgets.QWidget',),
        "QMdiSubWindow.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QMdiSubWindow.showShaded": (),
        "QMdiSubWindow.showSystemMenu": (),
        "QMdiSubWindow.sizeHint": (),
        "QMdiSubWindow.systemMenu": (),
        "QMdiSubWindow.testOption": ('PySide2.QtWidgets.QMdiSubWindow.SubWindowOption',),
        "QMdiSubWindow.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QMdiSubWindow.widget": (),

    # class PySide2.QtWidgets.QMenu:
        "QMenu.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
        "QMenu.actionAt": ('PySide2.QtCore.QPoint',),
        "QMenu.actionEvent": ('PySide2.QtGui.QActionEvent',),
        "QMenu.actionGeometry": ('PySide2.QtWidgets.QAction',),
        "QMenu.activeAction": (),
        "QMenu.addAction": [('PySide2.QtGui.QIcon', 'str'), ('PySide2.QtGui.QIcon', 'str', 'PySide2.QtCore.QObject', 'str', 'PySide2.QtGui.QKeySequence'), ('PySide2.QtGui.QIcon', 'str', 'object', 'PySide2.QtGui.QKeySequence'), ('PySide2.QtWidgets.QAction',), ('str',), ('str', 'PySide2.QtCore.QObject', 'str', 'PySide2.QtGui.QKeySequence'), ('str', 'object', 'PySide2.QtGui.QKeySequence')],
        "QMenu.addMenu": [('PySide2.QtGui.QIcon', 'str'), ('PySide2.QtWidgets.QMenu',), ('str',)],
        "QMenu.addSection": [('PySide2.QtGui.QIcon', 'str'), ('str',)],
        "QMenu.addSeparator": (),
        "QMenu.changeEvent": ('PySide2.QtCore.QEvent',),
        "QMenu.clear": (),
        "QMenu.columnCount": (),
        "QMenu.defaultAction": (),
        "QMenu.enterEvent": ('PySide2.QtCore.QEvent',),
        "QMenu.event": ('PySide2.QtCore.QEvent',),
        "QMenu.exec_": [(), ('PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QAction'), ('list', 'PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QAction', 'PySide2.QtWidgets.QWidget')],
        "QMenu.focusNextPrevChild": ('bool',),
        "QMenu.hideEvent": ('PySide2.QtGui.QHideEvent',),
        "QMenu.hideTearOffMenu": (),
        "QMenu.icon": (),
        "QMenu.initStyleOption": ('PySide2.QtWidgets.QStyleOptionMenuItem', 'PySide2.QtWidgets.QAction'),
        "QMenu.insertMenu": ('PySide2.QtWidgets.QAction', 'PySide2.QtWidgets.QMenu'),
        "QMenu.insertSection": [('PySide2.QtWidgets.QAction', 'PySide2.QtGui.QIcon', 'str'), ('PySide2.QtWidgets.QAction', 'str')],
        "QMenu.insertSeparator": ('PySide2.QtWidgets.QAction',),
        "QMenu.isEmpty": (),
        "QMenu.isTearOffEnabled": (),
        "QMenu.isTearOffMenuVisible": (),
        "QMenu.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QMenu.leaveEvent": ('PySide2.QtCore.QEvent',),
        "QMenu.menuAction": (),
        "QMenu.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QMenu.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QMenu.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QMenu.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QMenu.popup": ('PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QAction'),
        "QMenu.separatorsCollapsible": (),
        "QMenu.setActiveAction": ('PySide2.QtWidgets.QAction',),
        "QMenu.setDefaultAction": ('PySide2.QtWidgets.QAction',),
        "QMenu.setIcon": ('PySide2.QtGui.QIcon',),
        "QMenu.setSeparatorsCollapsible": ('bool',),
        "QMenu.setTearOffEnabled": ('bool',),
        "QMenu.setTitle": ('str',),
        "QMenu.setToolTipsVisible": ('bool',),
        "QMenu.showTearOffMenu": [(), ('PySide2.QtCore.QPoint',)],
        "QMenu.sizeHint": (),
        "QMenu.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QMenu.title": (),
        "QMenu.toolTipsVisible": (),
        "QMenu.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

    # class PySide2.QtWidgets.QMenuBar:
        "QMenuBar.__init__": ('PySide2.QtWidgets.QWidget',),
        "QMenuBar.actionAt": ('PySide2.QtCore.QPoint',),
        "QMenuBar.actionEvent": ('PySide2.QtGui.QActionEvent',),
        "QMenuBar.actionGeometry": ('PySide2.QtWidgets.QAction',),
        "QMenuBar.activeAction": (),
        "QMenuBar.addAction": [('PySide2.QtWidgets.QAction',), ('str',), ('str', 'PySide2.QtCore.QObject', 'str'), ('str', 'object')],
        "QMenuBar.addMenu": [('PySide2.QtGui.QIcon', 'str'), ('PySide2.QtWidgets.QMenu',), ('str',)],
        "QMenuBar.addSeparator": (),
        "QMenuBar.changeEvent": ('PySide2.QtCore.QEvent',),
        "QMenuBar.clear": (),
        "QMenuBar.cornerWidget": ('PySide2.QtCore.Qt.Corner',),
        "QMenuBar.event": ('PySide2.QtCore.QEvent',),
        "QMenuBar.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QMenuBar.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QMenuBar.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QMenuBar.heightForWidth": ('int',),
        "QMenuBar.initStyleOption": ('PySide2.QtWidgets.QStyleOptionMenuItem', 'PySide2.QtWidgets.QAction'),
        "QMenuBar.insertMenu": ('PySide2.QtWidgets.QAction', 'PySide2.QtWidgets.QMenu'),
        "QMenuBar.insertSeparator": ('PySide2.QtWidgets.QAction',),
        "QMenuBar.isDefaultUp": (),
        "QMenuBar.isNativeMenuBar": (),
        "QMenuBar.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QMenuBar.leaveEvent": ('PySide2.QtCore.QEvent',),
        "QMenuBar.minimumSizeHint": (),
        "QMenuBar.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QMenuBar.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QMenuBar.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QMenuBar.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QMenuBar.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QMenuBar.setActiveAction": ('PySide2.QtWidgets.QAction',),
        "QMenuBar.setCornerWidget": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.Corner'),
        "QMenuBar.setDefaultUp": ('bool',),
        "QMenuBar.setNativeMenuBar": ('bool',),
        "QMenuBar.setVisible": ('bool',),
        "QMenuBar.sizeHint": (),
        "QMenuBar.timerEvent": ('PySide2.QtCore.QTimerEvent',),

    # class PySide2.QtWidgets.QMessageBox:
        "QMessageBox.__init__": [('PySide2.QtWidgets.QMessageBox.Icon', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButtons', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('PySide2.QtWidgets.QWidget',)],
        "QMessageBox.about": ('PySide2.QtWidgets.QWidget', 'str', 'str'),
        "QMessageBox.aboutQt": ('PySide2.QtWidgets.QWidget', 'str'),
        "QMessageBox.addButton": [('PySide2.QtWidgets.QAbstractButton', 'PySide2.QtWidgets.QMessageBox.ButtonRole'), ('PySide2.QtWidgets.QMessageBox.StandardButton',), ('str', 'PySide2.QtWidgets.QMessageBox.ButtonRole')],
        "QMessageBox.button": ('PySide2.QtWidgets.QMessageBox.StandardButton',),
        "QMessageBox.buttonRole": ('PySide2.QtWidgets.QAbstractButton',),
        "QMessageBox.buttonText": ('int',),
        "QMessageBox.buttons": (),
        "QMessageBox.changeEvent": ('PySide2.QtCore.QEvent',),
        "QMessageBox.checkBox": (),
        "QMessageBox.clickedButton": (),
        "QMessageBox.closeEvent": ('PySide2.QtGui.QCloseEvent',),
        "QMessageBox.critical": [('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButton', 'PySide2.QtWidgets.QMessageBox.StandardButton'), ('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButtons', 'PySide2.QtWidgets.QMessageBox.StandardButton')],
        "QMessageBox.defaultButton": (),
        "QMessageBox.detailedText": (),
        "QMessageBox.escapeButton": (),
        "QMessageBox.event": ('PySide2.QtCore.QEvent',),
        "QMessageBox.icon": (),
        "QMessageBox.iconPixmap": (),
        "QMessageBox.information": [('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButton', 'PySide2.QtWidgets.QMessageBox.StandardButton'), ('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButtons', 'PySide2.QtWidgets.QMessageBox.StandardButton')],
        "QMessageBox.informativeText": (),
        "QMessageBox.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QMessageBox.open": [(), ('PySide2.QtCore.QObject', 'str')],
        "QMessageBox.question": [('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButton', 'PySide2.QtWidgets.QMessageBox.StandardButton'), ('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButtons', 'PySide2.QtWidgets.QMessageBox.StandardButton')],
        "QMessageBox.removeButton": ('PySide2.QtWidgets.QAbstractButton',),
        "QMessageBox.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QMessageBox.setButtonText": ('int', 'str'),
        "QMessageBox.setCheckBox": ('PySide2.QtWidgets.QCheckBox',),
        "QMessageBox.setDefaultButton": [('PySide2.QtWidgets.QMessageBox.StandardButton',), ('PySide2.QtWidgets.QPushButton',)],
        "QMessageBox.setDetailedText": ('str',),
        "QMessageBox.setEscapeButton": [('PySide2.QtWidgets.QAbstractButton',), ('PySide2.QtWidgets.QMessageBox.StandardButton',)],
        "QMessageBox.setIcon": ('PySide2.QtWidgets.QMessageBox.Icon',),
        "QMessageBox.setIconPixmap": ('PySide2.QtGui.QPixmap',),
        "QMessageBox.setInformativeText": ('str',),
        "QMessageBox.setStandardButtons": ('PySide2.QtWidgets.QMessageBox.StandardButtons',),
        "QMessageBox.setText": ('str',),
        "QMessageBox.setTextFormat": ('PySide2.QtCore.Qt.TextFormat',),
        "QMessageBox.setTextInteractionFlags": ('PySide2.QtCore.Qt.TextInteractionFlags',),
        "QMessageBox.setWindowModality": ('PySide2.QtCore.Qt.WindowModality',),
        "QMessageBox.setWindowTitle": ('str',),
        "QMessageBox.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QMessageBox.standardButton": ('PySide2.QtWidgets.QAbstractButton',),
        "QMessageBox.standardButtons": (),
        "QMessageBox.standardIcon": ('PySide2.QtWidgets.QMessageBox.Icon',),
        "QMessageBox.text": (),
        "QMessageBox.textFormat": (),
        "QMessageBox.textInteractionFlags": (),
        "QMessageBox.warning": [('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButton', 'PySide2.QtWidgets.QMessageBox.StandardButton'), ('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButtons', 'PySide2.QtWidgets.QMessageBox.StandardButton')],

    # class PySide2.QtWidgets.QMouseEventTransition:
        "QMouseEventTransition.__init__": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.QState'), ('PySide2.QtCore.QState',)],
        "QMouseEventTransition.button": (),
        "QMouseEventTransition.eventTest": ('PySide2.QtCore.QEvent',),
        "QMouseEventTransition.hitTestPath": (),
        "QMouseEventTransition.modifierMask": (),
        "QMouseEventTransition.onTransition": ('PySide2.QtCore.QEvent',),
        "QMouseEventTransition.setButton": ('PySide2.QtCore.Qt.MouseButton',),
        "QMouseEventTransition.setHitTestPath": ('PySide2.QtGui.QPainterPath',),
        "QMouseEventTransition.setModifierMask": ('PySide2.QtCore.Qt.KeyboardModifiers',),

    # class PySide2.QtWidgets.QOpenGLWidget:
        "QOpenGLWidget.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
        "QOpenGLWidget.context": (),
        "QOpenGLWidget.defaultFramebufferObject": (),
        "QOpenGLWidget.doneCurrent": (),
        "QOpenGLWidget.event": ('PySide2.QtCore.QEvent',),
        "QOpenGLWidget.format": (),
        "QOpenGLWidget.grabFramebuffer": (),
        "QOpenGLWidget.initializeGL": (),
        "QOpenGLWidget.isValid": (),
        "QOpenGLWidget.makeCurrent": (),
        "QOpenGLWidget.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
        "QOpenGLWidget.paintEngine": (),
        "QOpenGLWidget.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QOpenGLWidget.paintGL": (),
        "QOpenGLWidget.redirected": ('PySide2.QtCore.QPoint',),
        "QOpenGLWidget.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QOpenGLWidget.resizeGL": ('int', 'int'),
        "QOpenGLWidget.setFormat": ('PySide2.QtGui.QSurfaceFormat',),
        "QOpenGLWidget.setTextureFormat": ('int',),
        "QOpenGLWidget.setUpdateBehavior": ('PySide2.QtWidgets.QOpenGLWidget.UpdateBehavior',),
        "QOpenGLWidget.textureFormat": (),
        "QOpenGLWidget.updateBehavior": (),

    # class PySide2.QtWidgets.QPanGesture:
        "QPanGesture.__init__": ('PySide2.QtCore.QObject',),
        "QPanGesture.acceleration": (),
        "QPanGesture.delta": (),
        "QPanGesture.lastOffset": (),
        "QPanGesture.offset": (),
        "QPanGesture.setAcceleration": ('float',),
        "QPanGesture.setLastOffset": ('PySide2.QtCore.QPointF',),
        "QPanGesture.setOffset": ('PySide2.QtCore.QPointF',),

    # class PySide2.QtWidgets.QPinchGesture:
        "QPinchGesture.__init__": ('PySide2.QtCore.QObject',),
        "QPinchGesture.centerPoint": (),
        "QPinchGesture.changeFlags": (),
        "QPinchGesture.lastCenterPoint": (),
        "QPinchGesture.lastRotationAngle": (),
        "QPinchGesture.lastScaleFactor": (),
        "QPinchGesture.rotationAngle": (),
        "QPinchGesture.scaleFactor": (),
        "QPinchGesture.setCenterPoint": ('PySide2.QtCore.QPointF',),
        "QPinchGesture.setChangeFlags": ('PySide2.QtWidgets.QPinchGesture.ChangeFlags',),
        "QPinchGesture.setLastCenterPoint": ('PySide2.QtCore.QPointF',),
        "QPinchGesture.setLastRotationAngle": ('float',),
        "QPinchGesture.setLastScaleFactor": ('float',),
        "QPinchGesture.setRotationAngle": ('float',),
        "QPinchGesture.setScaleFactor": ('float',),
        "QPinchGesture.setStartCenterPoint": ('PySide2.QtCore.QPointF',),
        "QPinchGesture.setTotalChangeFlags": ('PySide2.QtWidgets.QPinchGesture.ChangeFlags',),
        "QPinchGesture.setTotalRotationAngle": ('float',),
        "QPinchGesture.setTotalScaleFactor": ('float',),
        "QPinchGesture.startCenterPoint": (),
        "QPinchGesture.totalChangeFlags": (),
        "QPinchGesture.totalRotationAngle": (),
        "QPinchGesture.totalScaleFactor": (),

    # class PySide2.QtWidgets.QPlainTextDocumentLayout:
        "QPlainTextDocumentLayout.__init__": ('PySide2.QtGui.QTextDocument',),
        "QPlainTextDocumentLayout.blockBoundingRect": ('PySide2.QtGui.QTextBlock',),
        "QPlainTextDocumentLayout.cursorWidth": (),
        "QPlainTextDocumentLayout.documentChanged": ('int', 'int', 'int'),
        "QPlainTextDocumentLayout.documentSize": (),
        "QPlainTextDocumentLayout.draw": ('PySide2.QtGui.QPainter', 'PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext'),
        "QPlainTextDocumentLayout.ensureBlockLayout": ('PySide2.QtGui.QTextBlock',),
        "QPlainTextDocumentLayout.frameBoundingRect": ('PySide2.QtGui.QTextFrame',),
        "QPlainTextDocumentLayout.hitTest": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.HitTestAccuracy'),
        "QPlainTextDocumentLayout.pageCount": (),
        "QPlainTextDocumentLayout.requestUpdate": (),
        "QPlainTextDocumentLayout.setCursorWidth": ('int',),

    # class PySide2.QtWidgets.QPlainTextEdit:
        "QPlainTextEdit.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
        "QPlainTextEdit.anchorAt": ('PySide2.QtCore.QPoint',),
        "QPlainTextEdit.appendHtml": ('str',),
        "QPlainTextEdit.appendPlainText": ('str',),
        "QPlainTextEdit.backgroundVisible": (),
        "QPlainTextEdit.blockBoundingGeometry": ('PySide2.QtGui.QTextBlock',),
        "QPlainTextEdit.blockBoundingRect": ('PySide2.QtGui.QTextBlock',),
        "QPlainTextEdit.blockCount": (),
        "QPlainTextEdit.canInsertFromMimeData": ('PySide2.QtCore.QMimeData',),
        "QPlainTextEdit.canPaste": (),
        "QPlainTextEdit.centerCursor": (),
        "QPlainTextEdit.centerOnScroll": (),
        "QPlainTextEdit.changeEvent": ('PySide2.QtCore.QEvent',),
        "QPlainTextEdit.clear": (),
        "QPlainTextEdit.contentOffset": (),
        "QPlainTextEdit.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
        "QPlainTextEdit.copy": (),
        "QPlainTextEdit.createMimeDataFromSelection": (),
        "QPlainTextEdit.createStandardContextMenu": [(), ('PySide2.QtCore.QPoint',)],
        "QPlainTextEdit.currentCharFormat": (),
        "QPlainTextEdit.cursorForPosition": ('PySide2.QtCore.QPoint',),
        "QPlainTextEdit.cursorRect": [(), ('PySide2.QtGui.QTextCursor',)],
        "QPlainTextEdit.cursorWidth": (),
        "QPlainTextEdit.cut": (),
        "QPlainTextEdit.doSetTextCursor": ('PySide2.QtGui.QTextCursor',),
        "QPlainTextEdit.document": (),
        "QPlainTextEdit.documentTitle": (),
        "QPlainTextEdit.dragEnterEvent": ('PySide2.QtGui.QDragEnterEvent',),
        "QPlainTextEdit.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
        "QPlainTextEdit.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
        "QPlainTextEdit.dropEvent": ('PySide2.QtGui.QDropEvent',),
        "QPlainTextEdit.ensureCursorVisible": (),
        "QPlainTextEdit.event": ('PySide2.QtCore.QEvent',),
        "QPlainTextEdit.extraSelections": (),
        "QPlainTextEdit.find": [('PySide2.QtCore.QRegExp', 'PySide2.QtGui.QTextDocument.FindFlags'), ('str', 'PySide2.QtGui.QTextDocument.FindFlags')],
        "QPlainTextEdit.firstVisibleBlock": (),
        "QPlainTextEdit.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QPlainTextEdit.focusNextPrevChild": ('bool',),
        "QPlainTextEdit.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QPlainTextEdit.getPaintContext": (),
        "QPlainTextEdit.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
        "QPlainTextEdit.inputMethodQuery": [('PySide2.QtCore.Qt.InputMethodQuery',), ('PySide2.QtCore.Qt.InputMethodQuery', 'typing.Any')],
        "QPlainTextEdit.insertFromMimeData": ('PySide2.QtCore.QMimeData',),
        "QPlainTextEdit.insertPlainText": ('str',),
        "QPlainTextEdit.isReadOnly": (),
        "QPlainTextEdit.isUndoRedoEnabled": (),
        "QPlainTextEdit.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QPlainTextEdit.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
        "QPlainTextEdit.lineWrapMode": (),
        "QPlainTextEdit.loadResource": ('int', 'PySide2.QtCore.QUrl'),
        "QPlainTextEdit.maximumBlockCount": (),
        "QPlainTextEdit.mergeCurrentCharFormat": ('PySide2.QtGui.QTextCharFormat',),
        "QPlainTextEdit.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
        "QPlainTextEdit.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QPlainTextEdit.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QPlainTextEdit.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QPlainTextEdit.moveCursor": ('PySide2.QtGui.QTextCursor.MoveOperation', 'PySide2.QtGui.QTextCursor.MoveMode'),
        "QPlainTextEdit.overwriteMode": (),
        "QPlainTextEdit.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QPlainTextEdit.paste": (),
        "QPlainTextEdit.placeholderText": (),
        "QPlainTextEdit.print_": ('PySide2.QtGui.QPagedPaintDevice',),
        "QPlainTextEdit.redo": (),
        "QPlainTextEdit.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QPlainTextEdit.scrollContentsBy": ('int', 'int'),
        "QPlainTextEdit.selectAll": (),
        "QPlainTextEdit.setBackgroundVisible": ('bool',),
        "QPlainTextEdit.setCenterOnScroll": ('bool',),
        "QPlainTextEdit.setCurrentCharFormat": ('PySide2.QtGui.QTextCharFormat',),
        "QPlainTextEdit.setCursorWidth": ('int',),
        "QPlainTextEdit.setDocument": ('PySide2.QtGui.QTextDocument',),
        "QPlainTextEdit.setDocumentTitle": ('str',),
        "QPlainTextEdit.setExtraSelections": ('list',),
        "QPlainTextEdit.setLineWrapMode": ('PySide2.QtWidgets.QPlainTextEdit.LineWrapMode',),
        "QPlainTextEdit.setMaximumBlockCount": ('int',),
        "QPlainTextEdit.setOverwriteMode": ('bool',),
        "QPlainTextEdit.setPlaceholderText": ('str',),
        "QPlainTextEdit.setPlainText": ('str',),
        "QPlainTextEdit.setReadOnly": ('bool',),
        "QPlainTextEdit.setTabChangesFocus": ('bool',),
        "QPlainTextEdit.setTabStopDistance": ('float',),
        "QPlainTextEdit.setTabStopWidth": ('int',),
        "QPlainTextEdit.setTextCursor": ('PySide2.QtGui.QTextCursor',),
        "QPlainTextEdit.setTextInteractionFlags": ('PySide2.QtCore.Qt.TextInteractionFlags',),
        "QPlainTextEdit.setUndoRedoEnabled": ('bool',),
        "QPlainTextEdit.setWordWrapMode": ('PySide2.QtGui.QTextOption.WrapMode',),
        "QPlainTextEdit.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QPlainTextEdit.tabChangesFocus": (),
        "QPlainTextEdit.tabStopDistance": (),
        "QPlainTextEdit.tabStopWidth": (),
        "QPlainTextEdit.textCursor": (),
        "QPlainTextEdit.textInteractionFlags": (),
        "QPlainTextEdit.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QPlainTextEdit.toPlainText": (),
        "QPlainTextEdit.undo": (),
        "QPlainTextEdit.wheelEvent": ('PySide2.QtGui.QWheelEvent',),
        "QPlainTextEdit.wordWrapMode": (),
        "QPlainTextEdit.zoomIn": ('int',),
        "QPlainTextEdit.zoomInF": ('float',),
        "QPlainTextEdit.zoomOut": ('int',),

    # class PySide2.QtWidgets.QProgressBar:
        "QProgressBar.__init__": ('PySide2.QtWidgets.QWidget',),
        "QProgressBar.alignment": (),
        "QProgressBar.event": ('PySide2.QtCore.QEvent',),
        "QProgressBar.format": (),
        "QProgressBar.initStyleOption": ('PySide2.QtWidgets.QStyleOptionProgressBar',),
        "QProgressBar.invertedAppearance": (),
        "QProgressBar.isTextVisible": (),
        "QProgressBar.maximum": (),
        "QProgressBar.minimum": (),
        "QProgressBar.minimumSizeHint": (),
        "QProgressBar.orientation": (),
        "QProgressBar.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QProgressBar.reset": (),
        "QProgressBar.resetFormat": (),
        "QProgressBar.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QProgressBar.setFormat": ('str',),
        "QProgressBar.setInvertedAppearance": ('bool',),
        "QProgressBar.setMaximum": ('int',),
        "QProgressBar.setMinimum": ('int',),
        "QProgressBar.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
        "QProgressBar.setRange": ('int', 'int'),
        "QProgressBar.setTextDirection": ('PySide2.QtWidgets.QProgressBar.Direction',),
        "QProgressBar.setTextVisible": ('bool',),
        "QProgressBar.setValue": ('int',),
        "QProgressBar.sizeHint": (),
        "QProgressBar.text": (),
        "QProgressBar.textDirection": (),
        "QProgressBar.value": (),

    # class PySide2.QtWidgets.QProgressDialog:
        "QProgressDialog.__init__": [('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('str', 'str', 'int', 'int', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags')],
        "QProgressDialog.autoClose": (),
        "QProgressDialog.autoReset": (),
        "QProgressDialog.cancel": (),
        "QProgressDialog.changeEvent": ('PySide2.QtCore.QEvent',),
        "QProgressDialog.closeEvent": ('PySide2.QtGui.QCloseEvent',),
        "QProgressDialog.forceShow": (),
        "QProgressDialog.labelText": (),
        "QProgressDialog.maximum": (),
        "QProgressDialog.minimum": (),
        "QProgressDialog.minimumDuration": (),
        "QProgressDialog.open": [(), ('PySide2.QtCore.QObject', 'str')],
        "QProgressDialog.reset": (),
        "QProgressDialog.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QProgressDialog.setAutoClose": ('bool',),
        "QProgressDialog.setAutoReset": ('bool',),
        "QProgressDialog.setBar": ('PySide2.QtWidgets.QProgressBar',),
        "QProgressDialog.setCancelButton": ('PySide2.QtWidgets.QPushButton',),
        "QProgressDialog.setCancelButtonText": ('str',),
        "QProgressDialog.setLabel": ('PySide2.QtWidgets.QLabel',),
        "QProgressDialog.setLabelText": ('str',),
        "QProgressDialog.setMaximum": ('int',),
        "QProgressDialog.setMinimum": ('int',),
        "QProgressDialog.setMinimumDuration": ('int',),
        "QProgressDialog.setRange": ('int', 'int'),
        "QProgressDialog.setValue": ('int',),
        "QProgressDialog.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QProgressDialog.sizeHint": (),
        "QProgressDialog.value": (),
        "QProgressDialog.wasCanceled": (),

    # class PySide2.QtWidgets.QProxyStyle:
        "QProxyStyle.__init__": [('PySide2.QtWidgets.QStyle',), ('str',)],
        "QProxyStyle.baseStyle": (),
        "QProxyStyle.drawComplexControl": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
        "QProxyStyle.drawControl": ('PySide2.QtWidgets.QStyle.ControlElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
        "QProxyStyle.drawItemPixmap": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPixmap'),
        "QProxyStyle.drawItemText": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPalette', 'bool', 'str', 'PySide2.QtGui.QPalette.ColorRole'),
        "QProxyStyle.drawPrimitive": ('PySide2.QtWidgets.QStyle.PrimitiveElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
        "QProxyStyle.event": ('PySide2.QtCore.QEvent',),
        "QProxyStyle.generatedIconPixmap": ('PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QPixmap', 'PySide2.QtWidgets.QStyleOption'),
        "QProxyStyle.hitTestComplexControl": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QWidget'),
        "QProxyStyle.itemPixmapRect": ('PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPixmap'),
        "QProxyStyle.itemTextRect": ('PySide2.QtGui.QFontMetrics', 'PySide2.QtCore.QRect', 'int', 'bool', 'str'),
        "QProxyStyle.layoutSpacing": ('PySide2.QtWidgets.QSizePolicy.ControlType', 'PySide2.QtWidgets.QSizePolicy.ControlType', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QProxyStyle.pixelMetric": ('PySide2.QtWidgets.QStyle.PixelMetric', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QProxyStyle.polish": [('PySide2.QtGui.QPalette',), ('PySide2.QtWidgets.QApplication',), ('PySide2.QtWidgets.QWidget',)],
        "QProxyStyle.setBaseStyle": ('PySide2.QtWidgets.QStyle',),
        "QProxyStyle.sizeFromContents": ('PySide2.QtWidgets.QStyle.ContentsType', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtCore.QSize', 'PySide2.QtWidgets.QWidget'),
        "QProxyStyle.standardIcon": ('PySide2.QtWidgets.QStyle.StandardPixmap', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QProxyStyle.standardPalette": (),
        "QProxyStyle.standardPixmap": ('PySide2.QtWidgets.QStyle.StandardPixmap', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QProxyStyle.styleHint": ('PySide2.QtWidgets.QStyle.StyleHint', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleHintReturn'),
        "QProxyStyle.subControlRect": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtWidgets.QStyle.SubControl', 'PySide2.QtWidgets.QWidget'),
        "QProxyStyle.subElementRect": ('PySide2.QtWidgets.QStyle.SubElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QProxyStyle.unpolish": [('PySide2.QtWidgets.QApplication',), ('PySide2.QtWidgets.QWidget',)],

    # class PySide2.QtWidgets.QPushButton:
        "QPushButton.__init__": [('PySide2.QtGui.QIcon', 'str', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
        "QPushButton.autoDefault": (),
        "QPushButton.event": ('PySide2.QtCore.QEvent',),
        "QPushButton.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QPushButton.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QPushButton.initStyleOption": ('PySide2.QtWidgets.QStyleOptionButton',),
        "QPushButton.isDefault": (),
        "QPushButton.isFlat": (),
        "QPushButton.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QPushButton.menu": (),
        "QPushButton.minimumSizeHint": (),
        "QPushButton.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QPushButton.setAutoDefault": ('bool',),
        "QPushButton.setDefault": ('bool',),
        "QPushButton.setFlat": ('bool',),
        "QPushButton.setMenu": ('PySide2.QtWidgets.QMenu',),
        "QPushButton.showMenu": (),
        "QPushButton.sizeHint": (),

    # class PySide2.QtWidgets.QRadioButton:
        "QRadioButton.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
        "QRadioButton.event": ('PySide2.QtCore.QEvent',),
        "QRadioButton.hitButton": ('PySide2.QtCore.QPoint',),
        "QRadioButton.initStyleOption": ('PySide2.QtWidgets.QStyleOptionButton',),
        "QRadioButton.minimumSizeHint": (),
        "QRadioButton.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QRadioButton.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QRadioButton.sizeHint": (),

    # class PySide2.QtWidgets.QRubberBand:
        "QRubberBand.__init__": ('PySide2.QtWidgets.QRubberBand.Shape', 'PySide2.QtWidgets.QWidget'),
        "QRubberBand.changeEvent": ('PySide2.QtCore.QEvent',),
        "QRubberBand.event": ('PySide2.QtCore.QEvent',),
        "QRubberBand.initStyleOption": ('PySide2.QtWidgets.QStyleOptionRubberBand',),
        "QRubberBand.move": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QRubberBand.moveEvent": ('PySide2.QtGui.QMoveEvent',),
        "QRubberBand.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QRubberBand.resize": [('PySide2.QtCore.QSize',), ('int', 'int')],
        "QRubberBand.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QRubberBand.setGeometry": [('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
        "QRubberBand.shape": (),
        "QRubberBand.showEvent": ('PySide2.QtGui.QShowEvent',),

    # class PySide2.QtWidgets.QScrollArea:
        "QScrollArea.__init__": ('PySide2.QtWidgets.QWidget',),
        "QScrollArea.alignment": (),
        "QScrollArea.ensureVisible": ('int', 'int', 'int', 'int'),
        "QScrollArea.ensureWidgetVisible": ('PySide2.QtWidgets.QWidget', 'int', 'int'),
        "QScrollArea.event": ('PySide2.QtCore.QEvent',),
        "QScrollArea.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QScrollArea.focusNextPrevChild": ('bool',),
        "QScrollArea.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QScrollArea.scrollContentsBy": ('int', 'int'),
        "QScrollArea.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QScrollArea.setWidget": ('PySide2.QtWidgets.QWidget',),
        "QScrollArea.setWidgetResizable": ('bool',),
        "QScrollArea.sizeHint": (),
        "QScrollArea.takeWidget": (),
        "QScrollArea.viewportSizeHint": (),
        "QScrollArea.widget": (),
        "QScrollArea.widgetResizable": (),

    # class PySide2.QtWidgets.QScrollBar:
        "QScrollBar.__init__": [('PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
        "QScrollBar.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
        "QScrollBar.event": ('PySide2.QtCore.QEvent',),
        "QScrollBar.hideEvent": ('PySide2.QtGui.QHideEvent',),
        "QScrollBar.initStyleOption": ('PySide2.QtWidgets.QStyleOptionSlider',),
        "QScrollBar.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QScrollBar.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QScrollBar.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QScrollBar.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QScrollBar.sizeHint": (),
        "QScrollBar.sliderChange": ('PySide2.QtWidgets.QAbstractSlider.SliderChange',),
        "QScrollBar.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

    # class PySide2.QtWidgets.QScroller:
        "QScroller.activeScrollers": (),
        "QScroller.ensureVisible": [('PySide2.QtCore.QRectF', 'float', 'float'), ('PySide2.QtCore.QRectF', 'float', 'float', 'int')],
        "QScroller.finalPosition": (),
        "QScroller.grabGesture": ('PySide2.QtCore.QObject', 'PySide2.QtWidgets.QScroller.ScrollerGestureType'),
        "QScroller.grabbedGesture": ('PySide2.QtCore.QObject',),
        "QScroller.handleInput": ('PySide2.QtWidgets.QScroller.Input', 'PySide2.QtCore.QPointF', 'int'),
        "QScroller.hasScroller": ('PySide2.QtCore.QObject',),
        "QScroller.pixelPerMeter": (),
        "QScroller.resendPrepareEvent": (),
        "QScroller.scrollTo": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QPointF', 'int')],
        "QScroller.scroller": ('PySide2.QtCore.QObject',),
        "QScroller.scrollerProperties": (),
        "QScroller.setScrollerProperties": ('PySide2.QtWidgets.QScrollerProperties',),
        "QScroller.setSnapPositionsX": [('float', 'float'), ('list',)],
        "QScroller.setSnapPositionsY": [('float', 'float'), ('list',)],
        "QScroller.state": (),
        "QScroller.stop": (),
        "QScroller.target": (),
        "QScroller.ungrabGesture": ('PySide2.QtCore.QObject',),
        "QScroller.velocity": (),

    # class PySide2.QtWidgets.QScrollerProperties:
        "QScrollerProperties.__init__": [(), ('PySide2.QtWidgets.QScrollerProperties',)],
        "QScrollerProperties.__copy__": (),
        "QScrollerProperties.scrollMetric": ('PySide2.QtWidgets.QScrollerProperties.ScrollMetric',),
        "QScrollerProperties.setDefaultScrollerProperties": ('PySide2.QtWidgets.QScrollerProperties',),
        "QScrollerProperties.setScrollMetric": ('PySide2.QtWidgets.QScrollerProperties.ScrollMetric', 'typing.Any'),
        "QScrollerProperties.unsetDefaultScrollerProperties": (),

    # class PySide2.QtWidgets.QShortcut:
        "QShortcut.__init__": [('PySide2.QtGui.QKeySequence', 'PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtCore.Qt.ShortcutContext'), ('PySide2.QtGui.QKeySequence', 'PySide2.QtWidgets.QWidget', 'typing.Callable', 'PySide2.QtCore.Qt.ShortcutContext'), ('PySide2.QtWidgets.QWidget',)],
        "QShortcut.autoRepeat": (),
        "QShortcut.context": (),
        "QShortcut.event": ('PySide2.QtCore.QEvent',),
        "QShortcut.id": (),
        "QShortcut.isEnabled": (),
        "QShortcut.key": (),
        "QShortcut.parentWidget": (),
        "QShortcut.setAutoRepeat": ('bool',),
        "QShortcut.setContext": ('PySide2.QtCore.Qt.ShortcutContext',),
        "QShortcut.setEnabled": ('bool',),
        "QShortcut.setKey": ('PySide2.QtGui.QKeySequence',),
        "QShortcut.setWhatsThis": ('str',),
        "QShortcut.whatsThis": (),

    # class PySide2.QtWidgets.QSizeGrip:
        "QSizeGrip.__init__": ('PySide2.QtWidgets.QWidget',),
        "QSizeGrip.event": ('PySide2.QtCore.QEvent',),
        "QSizeGrip.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QSizeGrip.hideEvent": ('PySide2.QtGui.QHideEvent',),
        "QSizeGrip.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QSizeGrip.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QSizeGrip.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QSizeGrip.moveEvent": ('PySide2.QtGui.QMoveEvent',),
        "QSizeGrip.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QSizeGrip.setVisible": ('bool',),
        "QSizeGrip.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QSizeGrip.sizeHint": (),

    # class PySide2.QtWidgets.QSizePolicy:
        "QSizePolicy.__init__": [(), ('PySide2.QtWidgets.QSizePolicy.Policy', 'PySide2.QtWidgets.QSizePolicy.Policy', 'PySide2.QtWidgets.QSizePolicy.ControlType')],
        "QSizePolicy.__copy__": (),
        "QSizePolicy.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QSizePolicy.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QSizePolicy.controlType": (),
        "QSizePolicy.expandingDirections": (),
        "QSizePolicy.hasHeightForWidth": (),
        "QSizePolicy.hasWidthForHeight": (),
        "QSizePolicy.horizontalPolicy": (),
        "QSizePolicy.horizontalStretch": (),
        "QSizePolicy.retainSizeWhenHidden": (),
        "QSizePolicy.setControlType": ('PySide2.QtWidgets.QSizePolicy.ControlType',),
        "QSizePolicy.setHeightForWidth": ('bool',),
        "QSizePolicy.setHorizontalPolicy": ('PySide2.QtWidgets.QSizePolicy.Policy',),
        "QSizePolicy.setHorizontalStretch": ('int',),
        "QSizePolicy.setRetainSizeWhenHidden": ('bool',),
        "QSizePolicy.setVerticalPolicy": ('PySide2.QtWidgets.QSizePolicy.Policy',),
        "QSizePolicy.setVerticalStretch": ('int',),
        "QSizePolicy.setWidthForHeight": ('bool',),
        "QSizePolicy.transpose": (),
        "QSizePolicy.transposed": (),
        "QSizePolicy.verticalPolicy": (),
        "QSizePolicy.verticalStretch": (),

    # class PySide2.QtWidgets.QSlider:
        "QSlider.__init__": [('PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
        "QSlider.event": ('PySide2.QtCore.QEvent',),
        "QSlider.initStyleOption": ('PySide2.QtWidgets.QStyleOptionSlider',),
        "QSlider.minimumSizeHint": (),
        "QSlider.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QSlider.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QSlider.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QSlider.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QSlider.setTickInterval": ('int',),
        "QSlider.setTickPosition": ('PySide2.QtWidgets.QSlider.TickPosition',),
        "QSlider.sizeHint": (),
        "QSlider.tickInterval": (),
        "QSlider.tickPosition": (),

    # class PySide2.QtWidgets.QSpacerItem:
        "QSpacerItem.__init__": ('int', 'int', 'PySide2.QtWidgets.QSizePolicy.Policy', 'PySide2.QtWidgets.QSizePolicy.Policy'),
        "QSpacerItem.changeSize": ('int', 'int', 'PySide2.QtWidgets.QSizePolicy.Policy', 'PySide2.QtWidgets.QSizePolicy.Policy'),
        "QSpacerItem.expandingDirections": (),
        "QSpacerItem.geometry": (),
        "QSpacerItem.isEmpty": (),
        "QSpacerItem.maximumSize": (),
        "QSpacerItem.minimumSize": (),
        "QSpacerItem.setGeometry": ('PySide2.QtCore.QRect',),
        "QSpacerItem.sizeHint": (),
        "QSpacerItem.sizePolicy": (),
        "QSpacerItem.spacerItem": (),

    # class PySide2.QtWidgets.QSpinBox:
        "QSpinBox.__init__": ('PySide2.QtWidgets.QWidget',),
        "QSpinBox.cleanText": (),
        "QSpinBox.displayIntegerBase": (),
        "QSpinBox.event": ('PySide2.QtCore.QEvent',),
        "QSpinBox.fixup": ('str',),
        "QSpinBox.maximum": (),
        "QSpinBox.minimum": (),
        "QSpinBox.prefix": (),
        "QSpinBox.setDisplayIntegerBase": ('int',),
        "QSpinBox.setMaximum": ('int',),
        "QSpinBox.setMinimum": ('int',),
        "QSpinBox.setPrefix": ('str',),
        "QSpinBox.setRange": ('int', 'int'),
        "QSpinBox.setSingleStep": ('int',),
        "QSpinBox.setStepType": ('PySide2.QtWidgets.QAbstractSpinBox.StepType',),
        "QSpinBox.setSuffix": ('str',),
        "QSpinBox.setValue": ('int',),
        "QSpinBox.singleStep": (),
        "QSpinBox.stepType": (),
        "QSpinBox.suffix": (),
        "QSpinBox.textFromValue": ('int',),
        "QSpinBox.validate": ('str', 'int'),
        "QSpinBox.value": (),
        "QSpinBox.valueFromText": ('str',),

    # class PySide2.QtWidgets.QSplashScreen:
        "QSplashScreen.__init__": [('PySide2.QtGui.QPixmap', 'PySide2.QtCore.Qt.WindowFlags'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.Qt.WindowFlags')],
        "QSplashScreen.clearMessage": (),
        "QSplashScreen.drawContents": ('PySide2.QtGui.QPainter',),
        "QSplashScreen.event": ('PySide2.QtCore.QEvent',),
        "QSplashScreen.finish": ('PySide2.QtWidgets.QWidget',),
        "QSplashScreen.message": (),
        "QSplashScreen.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QSplashScreen.pixmap": (),
        "QSplashScreen.setPixmap": ('PySide2.QtGui.QPixmap',),
        "QSplashScreen.showMessage": ('str', 'int', 'PySide2.QtGui.QColor'),

    # class PySide2.QtWidgets.QSplitter:
        "QSplitter.__init__": [('PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
        "QSplitter.__lshift__": ('PySide2.QtCore.QTextStream',),
        "QSplitter.__rshift__": ('PySide2.QtCore.QTextStream',),
        "QSplitter.addWidget": ('PySide2.QtWidgets.QWidget',),
        "QSplitter.changeEvent": ('PySide2.QtCore.QEvent',),
        "QSplitter.childEvent": ('PySide2.QtCore.QChildEvent',),
        "QSplitter.childrenCollapsible": (),
        "QSplitter.closestLegalPosition": ('int', 'int'),
        "QSplitter.count": (),
        "QSplitter.createHandle": (),
        "QSplitter.event": ('PySide2.QtCore.QEvent',),
        "QSplitter.getRange": ('int', 'int', 'int'),
        "QSplitter.handle": ('int',),
        "QSplitter.handleWidth": (),
        "QSplitter.indexOf": ('PySide2.QtWidgets.QWidget',),
        "QSplitter.insertWidget": ('int', 'PySide2.QtWidgets.QWidget'),
        "QSplitter.isCollapsible": ('int',),
        "QSplitter.minimumSizeHint": (),
        "QSplitter.moveSplitter": ('int', 'int'),
        "QSplitter.opaqueResize": (),
        "QSplitter.orientation": (),
        "QSplitter.refresh": (),
        "QSplitter.replaceWidget": ('int', 'PySide2.QtWidgets.QWidget'),
        "QSplitter.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QSplitter.restoreState": ('PySide2.QtCore.QByteArray',),
        "QSplitter.saveState": (),
        "QSplitter.setChildrenCollapsible": ('bool',),
        "QSplitter.setCollapsible": ('int', 'bool'),
        "QSplitter.setHandleWidth": ('int',),
        "QSplitter.setOpaqueResize": ('bool',),
        "QSplitter.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
        "QSplitter.setRubberBand": ('int',),
        "QSplitter.setSizes": ('list',),
        "QSplitter.setStretchFactor": ('int', 'int'),
        "QSplitter.sizeHint": (),
        "QSplitter.sizes": (),
        "QSplitter.widget": ('int',),

    # class PySide2.QtWidgets.QSplitterHandle:
        "QSplitterHandle.__init__": ('PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QSplitter'),
        "QSplitterHandle.closestLegalPosition": ('int',),
        "QSplitterHandle.event": ('PySide2.QtCore.QEvent',),
        "QSplitterHandle.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QSplitterHandle.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QSplitterHandle.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QSplitterHandle.moveSplitter": ('int',),
        "QSplitterHandle.opaqueResize": (),
        "QSplitterHandle.orientation": (),
        "QSplitterHandle.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QSplitterHandle.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QSplitterHandle.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
        "QSplitterHandle.sizeHint": (),
        "QSplitterHandle.splitter": (),

    # class PySide2.QtWidgets.QStackedLayout:
        "QStackedLayout.__init__": [(), ('PySide2.QtWidgets.QLayout',), ('PySide2.QtWidgets.QWidget',)],
        "QStackedLayout.addItem": ('PySide2.QtWidgets.QLayoutItem',),
        "QStackedLayout.addWidget": ('PySide2.QtWidgets.QWidget',),
        "QStackedLayout.count": (),
        "QStackedLayout.currentIndex": (),
        "QStackedLayout.currentWidget": (),
        "QStackedLayout.hasHeightForWidth": (),
        "QStackedLayout.heightForWidth": ('int',),
        "QStackedLayout.insertWidget": ('int', 'PySide2.QtWidgets.QWidget'),
        "QStackedLayout.itemAt": ('int',),
        "QStackedLayout.minimumSize": (),
        "QStackedLayout.setCurrentIndex": ('int',),
        "QStackedLayout.setCurrentWidget": ('PySide2.QtWidgets.QWidget',),
        "QStackedLayout.setGeometry": ('PySide2.QtCore.QRect',),
        "QStackedLayout.setStackingMode": ('PySide2.QtWidgets.QStackedLayout.StackingMode',),
        "QStackedLayout.sizeHint": (),
        "QStackedLayout.stackingMode": (),
        "QStackedLayout.takeAt": ('int',),
        "QStackedLayout.widget": [(), ('int',)],

    # class PySide2.QtWidgets.QStackedWidget:
        "QStackedWidget.__init__": ('PySide2.QtWidgets.QWidget',),
        "QStackedWidget.addWidget": ('PySide2.QtWidgets.QWidget',),
        "QStackedWidget.count": (),
        "QStackedWidget.currentIndex": (),
        "QStackedWidget.currentWidget": (),
        "QStackedWidget.event": ('PySide2.QtCore.QEvent',),
        "QStackedWidget.indexOf": ('PySide2.QtWidgets.QWidget',),
        "QStackedWidget.insertWidget": ('int', 'PySide2.QtWidgets.QWidget'),
        "QStackedWidget.removeWidget": ('PySide2.QtWidgets.QWidget',),
        "QStackedWidget.setCurrentIndex": ('int',),
        "QStackedWidget.setCurrentWidget": ('PySide2.QtWidgets.QWidget',),
        "QStackedWidget.widget": ('int',),

    # class PySide2.QtWidgets.QStatusBar:
        "QStatusBar.__init__": ('PySide2.QtWidgets.QWidget',),
        "QStatusBar.addPermanentWidget": ('PySide2.QtWidgets.QWidget', 'int'),
        "QStatusBar.addWidget": ('PySide2.QtWidgets.QWidget', 'int'),
        "QStatusBar.clearMessage": (),
        "QStatusBar.currentMessage": (),
        "QStatusBar.event": ('PySide2.QtCore.QEvent',),
        "QStatusBar.hideOrShow": (),
        "QStatusBar.insertPermanentWidget": ('int', 'PySide2.QtWidgets.QWidget', 'int'),
        "QStatusBar.insertWidget": ('int', 'PySide2.QtWidgets.QWidget', 'int'),
        "QStatusBar.isSizeGripEnabled": (),
        "QStatusBar.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QStatusBar.reformat": (),
        "QStatusBar.removeWidget": ('PySide2.QtWidgets.QWidget',),
        "QStatusBar.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QStatusBar.setSizeGripEnabled": ('bool',),
        "QStatusBar.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QStatusBar.showMessage": ('str', 'int'),

    # class PySide2.QtWidgets.QStyle:
        "QStyle.__init__": (),
        "QStyle.alignedRect": ('PySide2.QtCore.Qt.LayoutDirection', 'PySide2.QtCore.Qt.Alignment', 'PySide2.QtCore.QSize', 'PySide2.QtCore.QRect'),
        "QStyle.combinedLayoutSpacing": ('PySide2.QtWidgets.QSizePolicy.ControlTypes', 'PySide2.QtWidgets.QSizePolicy.ControlTypes', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QStyle.drawComplexControl": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
        "QStyle.drawControl": ('PySide2.QtWidgets.QStyle.ControlElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
        "QStyle.drawItemPixmap": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPixmap'),
        "QStyle.drawItemText": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPalette', 'bool', 'str', 'PySide2.QtGui.QPalette.ColorRole'),
        "QStyle.drawPrimitive": ('PySide2.QtWidgets.QStyle.PrimitiveElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
        "QStyle.generatedIconPixmap": ('PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QPixmap', 'PySide2.QtWidgets.QStyleOption'),
        "QStyle.hitTestComplexControl": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QWidget'),
        "QStyle.itemPixmapRect": ('PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPixmap'),
        "QStyle.itemTextRect": ('PySide2.QtGui.QFontMetrics', 'PySide2.QtCore.QRect', 'int', 'bool', 'str'),
        "QStyle.layoutSpacing": ('PySide2.QtWidgets.QSizePolicy.ControlType', 'PySide2.QtWidgets.QSizePolicy.ControlType', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QStyle.pixelMetric": ('PySide2.QtWidgets.QStyle.PixelMetric', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QStyle.polish": [('PySide2.QtGui.QPalette',), ('PySide2.QtWidgets.QApplication',), ('PySide2.QtWidgets.QWidget',)],
        "QStyle.proxy": (),
        "QStyle.sizeFromContents": ('PySide2.QtWidgets.QStyle.ContentsType', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtCore.QSize', 'PySide2.QtWidgets.QWidget'),
        "QStyle.sliderPositionFromValue": ('int', 'int', 'int', 'int', 'bool'),
        "QStyle.sliderValueFromPosition": ('int', 'int', 'int', 'int', 'bool'),
        "QStyle.standardIcon": ('PySide2.QtWidgets.QStyle.StandardPixmap', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QStyle.standardPalette": (),
        "QStyle.standardPixmap": ('PySide2.QtWidgets.QStyle.StandardPixmap', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QStyle.styleHint": ('PySide2.QtWidgets.QStyle.StyleHint', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleHintReturn'),
        "QStyle.subControlRect": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtWidgets.QStyle.SubControl', 'PySide2.QtWidgets.QWidget'),
        "QStyle.subElementRect": ('PySide2.QtWidgets.QStyle.SubElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
        "QStyle.unpolish": [('PySide2.QtWidgets.QApplication',), ('PySide2.QtWidgets.QWidget',)],
        "QStyle.visualAlignment": ('PySide2.QtCore.Qt.LayoutDirection', 'PySide2.QtCore.Qt.Alignment'),
        "QStyle.visualPos": ('PySide2.QtCore.Qt.LayoutDirection', 'PySide2.QtCore.QRect', 'PySide2.QtCore.QPoint'),
        "QStyle.visualRect": ('PySide2.QtCore.Qt.LayoutDirection', 'PySide2.QtCore.QRect', 'PySide2.QtCore.QRect'),

    # class PySide2.QtWidgets.QStyleFactory:
        "QStyleFactory.__init__": (),
        "QStyleFactory.create": ('str',),
        "QStyleFactory.keys": (),

    # class PySide2.QtWidgets.QStyleHintReturn:
        "QStyleHintReturn.__init__": ('int', 'int'),

    # class PySide2.QtWidgets.QStyleHintReturnMask:
        "QStyleHintReturnMask.__init__": (),

    # class PySide2.QtWidgets.QStyleHintReturnVariant:
        "QStyleHintReturnVariant.__init__": (),

    # class PySide2.QtWidgets.QStyleOption:
        "QStyleOption.__init__": [('PySide2.QtWidgets.QStyleOption',), ('int', 'int')],
        "QStyleOption.init": ('PySide2.QtWidgets.QWidget',),
        "QStyleOption.initFrom": ('PySide2.QtWidgets.QWidget',),

    # class PySide2.QtWidgets.QStyleOptionButton:
        "QStyleOptionButton.__init__": [(), ('PySide2.QtWidgets.QStyleOptionButton',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionComboBox:
        "QStyleOptionComboBox.__init__": [(), ('PySide2.QtWidgets.QStyleOptionComboBox',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionComplex:
        "QStyleOptionComplex.__init__": [('PySide2.QtWidgets.QStyleOptionComplex',), ('int', 'int')],

    # class PySide2.QtWidgets.QStyleOptionDockWidget:
        "QStyleOptionDockWidget.__init__": [(), ('PySide2.QtWidgets.QStyleOptionDockWidget',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionFocusRect:
        "QStyleOptionFocusRect.__init__": [(), ('PySide2.QtWidgets.QStyleOptionFocusRect',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionFrame:
        "QStyleOptionFrame.__init__": [(), ('PySide2.QtWidgets.QStyleOptionFrame',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionGraphicsItem:
        "QStyleOptionGraphicsItem.__init__": [(), ('PySide2.QtWidgets.QStyleOptionGraphicsItem',), ('int',)],
        "QStyleOptionGraphicsItem.levelOfDetailFromTransform": ('PySide2.QtGui.QTransform',),

    # class PySide2.QtWidgets.QStyleOptionGroupBox:
        "QStyleOptionGroupBox.__init__": [(), ('PySide2.QtWidgets.QStyleOptionGroupBox',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionHeader:
        "QStyleOptionHeader.__init__": [(), ('PySide2.QtWidgets.QStyleOptionHeader',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionMenuItem:
        "QStyleOptionMenuItem.__init__": [(), ('PySide2.QtWidgets.QStyleOptionMenuItem',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionProgressBar:
        "QStyleOptionProgressBar.__init__": [(), ('PySide2.QtWidgets.QStyleOptionProgressBar',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionRubberBand:
        "QStyleOptionRubberBand.__init__": [(), ('PySide2.QtWidgets.QStyleOptionRubberBand',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionSizeGrip:
        "QStyleOptionSizeGrip.__init__": [(), ('PySide2.QtWidgets.QStyleOptionSizeGrip',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionSlider:
        "QStyleOptionSlider.__init__": [(), ('PySide2.QtWidgets.QStyleOptionSlider',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionSpinBox:
        "QStyleOptionSpinBox.__init__": [(), ('PySide2.QtWidgets.QStyleOptionSpinBox',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionTab:
        "QStyleOptionTab.__init__": [(), ('PySide2.QtWidgets.QStyleOptionTab',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionTabBarBase:
        "QStyleOptionTabBarBase.__init__": [(), ('PySide2.QtWidgets.QStyleOptionTabBarBase',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionTabWidgetFrame:
        "QStyleOptionTabWidgetFrame.__init__": [(), ('PySide2.QtWidgets.QStyleOptionTabWidgetFrame',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionTitleBar:
        "QStyleOptionTitleBar.__init__": [(), ('PySide2.QtWidgets.QStyleOptionTitleBar',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionToolBar:
        "QStyleOptionToolBar.__init__": [(), ('PySide2.QtWidgets.QStyleOptionToolBar',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionToolBox:
        "QStyleOptionToolBox.__init__": [(), ('PySide2.QtWidgets.QStyleOptionToolBox',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionToolButton:
        "QStyleOptionToolButton.__init__": [(), ('PySide2.QtWidgets.QStyleOptionToolButton',), ('int',)],

    # class PySide2.QtWidgets.QStyleOptionViewItem:
        "QStyleOptionViewItem.__init__": [(), ('PySide2.QtWidgets.QStyleOptionViewItem',), ('int',)],
        "QStyleOptionViewItem.__copy__": (),

    # class PySide2.QtWidgets.QStylePainter:
        "QStylePainter.__init__": [(), ('PySide2.QtGui.QPaintDevice', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
        "QStylePainter.begin": [('PySide2.QtGui.QPaintDevice',), ('PySide2.QtGui.QPaintDevice', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
        "QStylePainter.drawComplexControl": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex'),
        "QStylePainter.drawControl": ('PySide2.QtWidgets.QStyle.ControlElement', 'PySide2.QtWidgets.QStyleOption'),
        "QStylePainter.drawItemPixmap": ('PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPixmap'),
        "QStylePainter.drawItemText": ('PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPalette', 'bool', 'str', 'PySide2.QtGui.QPalette.ColorRole'),
        "QStylePainter.drawPrimitive": ('PySide2.QtWidgets.QStyle.PrimitiveElement', 'PySide2.QtWidgets.QStyleOption'),
        "QStylePainter.style": (),

    # class PySide2.QtWidgets.QStyledItemDelegate:
        "QStyledItemDelegate.__init__": ('PySide2.QtCore.QObject',),
        "QStyledItemDelegate.createEditor": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QStyledItemDelegate.displayText": ('typing.Any', 'PySide2.QtCore.QLocale'),
        "QStyledItemDelegate.editorEvent": ('PySide2.QtCore.QEvent', 'PySide2.QtCore.QAbstractItemModel', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QStyledItemDelegate.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QStyledItemDelegate.initStyleOption": ('PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QStyledItemDelegate.itemEditorFactory": (),
        "QStyledItemDelegate.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QStyledItemDelegate.setEditorData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QModelIndex'),
        "QStyledItemDelegate.setItemEditorFactory": ('PySide2.QtWidgets.QItemEditorFactory',),
        "QStyledItemDelegate.setModelData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QAbstractItemModel', 'PySide2.QtCore.QModelIndex'),
        "QStyledItemDelegate.sizeHint": ('PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QStyledItemDelegate.updateEditorGeometry": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),

    # class PySide2.QtWidgets.QSwipeGesture:
        "QSwipeGesture.__init__": ('PySide2.QtCore.QObject',),
        "QSwipeGesture.horizontalDirection": (),
        "QSwipeGesture.setSwipeAngle": ('float',),
        "QSwipeGesture.swipeAngle": (),
        "QSwipeGesture.verticalDirection": (),

    # class PySide2.QtWidgets.QSystemTrayIcon:
        "QSystemTrayIcon.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtGui.QIcon', 'PySide2.QtCore.QObject')],
        "QSystemTrayIcon.contextMenu": (),
        "QSystemTrayIcon.event": ('PySide2.QtCore.QEvent',),
        "QSystemTrayIcon.geometry": (),
        "QSystemTrayIcon.hide": (),
        "QSystemTrayIcon.icon": (),
        "QSystemTrayIcon.isSystemTrayAvailable": (),
        "QSystemTrayIcon.isVisible": (),
        "QSystemTrayIcon.setContextMenu": ('PySide2.QtWidgets.QMenu',),
        "QSystemTrayIcon.setIcon": ('PySide2.QtGui.QIcon',),
        "QSystemTrayIcon.setToolTip": ('str',),
        "QSystemTrayIcon.setVisible": ('bool',),
        "QSystemTrayIcon.show": (),
        "QSystemTrayIcon.showMessage": [('str', 'str', 'PySide2.QtGui.QIcon', 'int'), ('str', 'str', 'PySide2.QtWidgets.QSystemTrayIcon.MessageIcon', 'int')],
        "QSystemTrayIcon.supportsMessages": (),
        "QSystemTrayIcon.toolTip": (),

    # class PySide2.QtWidgets.QTabBar:
        "QTabBar.__init__": ('PySide2.QtWidgets.QWidget',),
        "QTabBar.accessibleTabName": ('int',),
        "QTabBar.addTab": [('PySide2.QtGui.QIcon', 'str'), ('str',)],
        "QTabBar.autoHide": (),
        "QTabBar.changeCurrentOnDrag": (),
        "QTabBar.changeEvent": ('PySide2.QtCore.QEvent',),
        "QTabBar.count": (),
        "QTabBar.currentIndex": (),
        "QTabBar.documentMode": (),
        "QTabBar.drawBase": (),
        "QTabBar.elideMode": (),
        "QTabBar.event": ('PySide2.QtCore.QEvent',),
        "QTabBar.expanding": (),
        "QTabBar.hideEvent": ('PySide2.QtGui.QHideEvent',),
        "QTabBar.iconSize": (),
        "QTabBar.initStyleOption": ('PySide2.QtWidgets.QStyleOptionTab', 'int'),
        "QTabBar.insertTab": [('int', 'PySide2.QtGui.QIcon', 'str'), ('int', 'str')],
        "QTabBar.isMovable": (),
        "QTabBar.isTabEnabled": ('int',),
        "QTabBar.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QTabBar.minimumSizeHint": (),
        "QTabBar.minimumTabSizeHint": ('int',),
        "QTabBar.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QTabBar.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QTabBar.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QTabBar.moveTab": ('int', 'int'),
        "QTabBar.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QTabBar.removeTab": ('int',),
        "QTabBar.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QTabBar.selectionBehaviorOnRemove": (),
        "QTabBar.setAccessibleTabName": ('int', 'str'),
        "QTabBar.setAutoHide": ('bool',),
        "QTabBar.setChangeCurrentOnDrag": ('bool',),
        "QTabBar.setCurrentIndex": ('int',),
        "QTabBar.setDocumentMode": ('bool',),
        "QTabBar.setDrawBase": ('bool',),
        "QTabBar.setElideMode": ('PySide2.QtCore.Qt.TextElideMode',),
        "QTabBar.setExpanding": ('bool',),
        "QTabBar.setIconSize": ('PySide2.QtCore.QSize',),
        "QTabBar.setMovable": ('bool',),
        "QTabBar.setSelectionBehaviorOnRemove": ('PySide2.QtWidgets.QTabBar.SelectionBehavior',),
        "QTabBar.setShape": ('PySide2.QtWidgets.QTabBar.Shape',),
        "QTabBar.setTabButton": ('int', 'PySide2.QtWidgets.QTabBar.ButtonPosition', 'PySide2.QtWidgets.QWidget'),
        "QTabBar.setTabData": ('int', 'typing.Any'),
        "QTabBar.setTabEnabled": ('int', 'bool'),
        "QTabBar.setTabIcon": ('int', 'PySide2.QtGui.QIcon'),
        "QTabBar.setTabText": ('int', 'str'),
        "QTabBar.setTabTextColor": ('int', 'PySide2.QtGui.QColor'),
        "QTabBar.setTabToolTip": ('int', 'str'),
        "QTabBar.setTabWhatsThis": ('int', 'str'),
        "QTabBar.setTabsClosable": ('bool',),
        "QTabBar.setUsesScrollButtons": ('bool',),
        "QTabBar.shape": (),
        "QTabBar.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QTabBar.sizeHint": (),
        "QTabBar.tabAt": ('PySide2.QtCore.QPoint',),
        "QTabBar.tabButton": ('int', 'PySide2.QtWidgets.QTabBar.ButtonPosition'),
        "QTabBar.tabData": ('int',),
        "QTabBar.tabIcon": ('int',),
        "QTabBar.tabInserted": ('int',),
        "QTabBar.tabLayoutChange": (),
        "QTabBar.tabRect": ('int',),
        "QTabBar.tabRemoved": ('int',),
        "QTabBar.tabSizeHint": ('int',),
        "QTabBar.tabText": ('int',),
        "QTabBar.tabTextColor": ('int',),
        "QTabBar.tabToolTip": ('int',),
        "QTabBar.tabWhatsThis": ('int',),
        "QTabBar.tabsClosable": (),
        "QTabBar.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QTabBar.usesScrollButtons": (),
        "QTabBar.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

    # class PySide2.QtWidgets.QTabWidget:
        "QTabWidget.__init__": ('PySide2.QtWidgets.QWidget',),
        "QTabWidget.addTab": [('PySide2.QtWidgets.QWidget', 'PySide2.QtGui.QIcon', 'str'), ('PySide2.QtWidgets.QWidget', 'str')],
        "QTabWidget.changeEvent": ('PySide2.QtCore.QEvent',),
        "QTabWidget.clear": (),
        "QTabWidget.cornerWidget": ('PySide2.QtCore.Qt.Corner',),
        "QTabWidget.count": (),
        "QTabWidget.currentIndex": (),
        "QTabWidget.currentWidget": (),
        "QTabWidget.documentMode": (),
        "QTabWidget.elideMode": (),
        "QTabWidget.event": ('PySide2.QtCore.QEvent',),
        "QTabWidget.hasHeightForWidth": (),
        "QTabWidget.heightForWidth": ('int',),
        "QTabWidget.iconSize": (),
        "QTabWidget.indexOf": ('PySide2.QtWidgets.QWidget',),
        "QTabWidget.initStyleOption": ('PySide2.QtWidgets.QStyleOptionTabWidgetFrame',),
        "QTabWidget.insertTab": [('int', 'PySide2.QtWidgets.QWidget', 'PySide2.QtGui.QIcon', 'str'), ('int', 'PySide2.QtWidgets.QWidget', 'str')],
        "QTabWidget.isMovable": (),
        "QTabWidget.isTabEnabled": ('int',),
        "QTabWidget.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QTabWidget.minimumSizeHint": (),
        "QTabWidget.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QTabWidget.removeTab": ('int',),
        "QTabWidget.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QTabWidget.setCornerWidget": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.Corner'),
        "QTabWidget.setCurrentIndex": ('int',),
        "QTabWidget.setCurrentWidget": ('PySide2.QtWidgets.QWidget',),
        "QTabWidget.setDocumentMode": ('bool',),
        "QTabWidget.setElideMode": ('PySide2.QtCore.Qt.TextElideMode',),
        "QTabWidget.setIconSize": ('PySide2.QtCore.QSize',),
        "QTabWidget.setMovable": ('bool',),
        "QTabWidget.setTabBar": ('PySide2.QtWidgets.QTabBar',),
        "QTabWidget.setTabBarAutoHide": ('bool',),
        "QTabWidget.setTabEnabled": ('int', 'bool'),
        "QTabWidget.setTabIcon": ('int', 'PySide2.QtGui.QIcon'),
        "QTabWidget.setTabPosition": ('PySide2.QtWidgets.QTabWidget.TabPosition',),
        "QTabWidget.setTabShape": ('PySide2.QtWidgets.QTabWidget.TabShape',),
        "QTabWidget.setTabText": ('int', 'str'),
        "QTabWidget.setTabToolTip": ('int', 'str'),
        "QTabWidget.setTabWhatsThis": ('int', 'str'),
        "QTabWidget.setTabsClosable": ('bool',),
        "QTabWidget.setUsesScrollButtons": ('bool',),
        "QTabWidget.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QTabWidget.sizeHint": (),
        "QTabWidget.tabBar": (),
        "QTabWidget.tabBarAutoHide": (),
        "QTabWidget.tabIcon": ('int',),
        "QTabWidget.tabInserted": ('int',),
        "QTabWidget.tabPosition": (),
        "QTabWidget.tabRemoved": ('int',),
        "QTabWidget.tabShape": (),
        "QTabWidget.tabText": ('int',),
        "QTabWidget.tabToolTip": ('int',),
        "QTabWidget.tabWhatsThis": ('int',),
        "QTabWidget.tabsClosable": (),
        "QTabWidget.usesScrollButtons": (),
        "QTabWidget.widget": ('int',),

    # class PySide2.QtWidgets.QTableView:
        "QTableView.__init__": ('PySide2.QtWidgets.QWidget',),
        "QTableView.clearSpans": (),
        "QTableView.columnAt": ('int',),
        "QTableView.columnCountChanged": ('int', 'int'),
        "QTableView.columnMoved": ('int', 'int', 'int'),
        "QTableView.columnResized": ('int', 'int', 'int'),
        "QTableView.columnSpan": ('int', 'int'),
        "QTableView.columnViewportPosition": ('int',),
        "QTableView.columnWidth": ('int',),
        "QTableView.currentChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
        "QTableView.doItemsLayout": (),
        "QTableView.gridStyle": (),
        "QTableView.hideColumn": ('int',),
        "QTableView.hideRow": ('int',),
        "QTableView.horizontalHeader": (),
        "QTableView.horizontalOffset": (),
        "QTableView.horizontalScrollbarAction": ('int',),
        "QTableView.indexAt": ('PySide2.QtCore.QPoint',),
        "QTableView.isColumnHidden": ('int',),
        "QTableView.isCornerButtonEnabled": (),
        "QTableView.isIndexHidden": ('PySide2.QtCore.QModelIndex',),
        "QTableView.isRowHidden": ('int',),
        "QTableView.isSortingEnabled": (),
        "QTableView.moveCursor": ('PySide2.QtWidgets.QAbstractItemView.CursorAction', 'PySide2.QtCore.Qt.KeyboardModifiers'),
        "QTableView.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QTableView.resizeColumnToContents": ('int',),
        "QTableView.resizeColumnsToContents": (),
        "QTableView.resizeRowToContents": ('int',),
        "QTableView.resizeRowsToContents": (),
        "QTableView.rowAt": ('int',),
        "QTableView.rowCountChanged": ('int', 'int'),
        "QTableView.rowHeight": ('int',),
        "QTableView.rowMoved": ('int', 'int', 'int'),
        "QTableView.rowResized": ('int', 'int', 'int'),
        "QTableView.rowSpan": ('int', 'int'),
        "QTableView.rowViewportPosition": ('int',),
        "QTableView.scrollContentsBy": ('int', 'int'),
        "QTableView.scrollTo": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
        "QTableView.selectColumn": ('int',),
        "QTableView.selectRow": ('int',),
        "QTableView.selectedIndexes": (),
        "QTableView.selectionChanged": ('PySide2.QtCore.QItemSelection', 'PySide2.QtCore.QItemSelection'),
        "QTableView.setColumnHidden": ('int', 'bool'),
        "QTableView.setColumnWidth": ('int', 'int'),
        "QTableView.setCornerButtonEnabled": ('bool',),
        "QTableView.setGridStyle": ('PySide2.QtCore.Qt.PenStyle',),
        "QTableView.setHorizontalHeader": ('PySide2.QtWidgets.QHeaderView',),
        "QTableView.setModel": ('PySide2.QtCore.QAbstractItemModel',),
        "QTableView.setRootIndex": ('PySide2.QtCore.QModelIndex',),
        "QTableView.setRowHeight": ('int', 'int'),
        "QTableView.setRowHidden": ('int', 'bool'),
        "QTableView.setSelection": ('PySide2.QtCore.QRect', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
        "QTableView.setSelectionModel": ('PySide2.QtCore.QItemSelectionModel',),
        "QTableView.setShowGrid": ('bool',),
        "QTableView.setSortingEnabled": ('bool',),
        "QTableView.setSpan": ('int', 'int', 'int', 'int'),
        "QTableView.setVerticalHeader": ('PySide2.QtWidgets.QHeaderView',),
        "QTableView.setWordWrap": ('bool',),
        "QTableView.showColumn": ('int',),
        "QTableView.showGrid": (),
        "QTableView.showRow": ('int',),
        "QTableView.sizeHintForColumn": ('int',),
        "QTableView.sizeHintForRow": ('int',),
        "QTableView.sortByColumn": [('int',), ('int', 'PySide2.QtCore.Qt.SortOrder')],
        "QTableView.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QTableView.updateGeometries": (),
        "QTableView.verticalHeader": (),
        "QTableView.verticalOffset": (),
        "QTableView.verticalScrollbarAction": ('int',),
        "QTableView.viewOptions": (),
        "QTableView.viewportSizeHint": (),
        "QTableView.visualRect": ('PySide2.QtCore.QModelIndex',),
        "QTableView.visualRegionForSelection": ('PySide2.QtCore.QItemSelection',),
        "QTableView.wordWrap": (),

    # class PySide2.QtWidgets.QTableWidget:
        "QTableWidget.__init__": [('PySide2.QtWidgets.QWidget',), ('int', 'int', 'PySide2.QtWidgets.QWidget')],
        "QTableWidget.cellWidget": ('int', 'int'),
        "QTableWidget.clear": (),
        "QTableWidget.clearContents": (),
        "QTableWidget.closePersistentEditor": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QTableWidgetItem',)],
        "QTableWidget.column": ('PySide2.QtWidgets.QTableWidgetItem',),
        "QTableWidget.columnCount": (),
        "QTableWidget.currentColumn": (),
        "QTableWidget.currentItem": (),
        "QTableWidget.currentRow": (),
        "QTableWidget.dropEvent": ('PySide2.QtGui.QDropEvent',),
        "QTableWidget.dropMimeData": ('int', 'int', 'PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction'),
        "QTableWidget.editItem": ('PySide2.QtWidgets.QTableWidgetItem',),
        "QTableWidget.event": ('PySide2.QtCore.QEvent',),
        "QTableWidget.findItems": ('str', 'PySide2.QtCore.Qt.MatchFlags'),
        "QTableWidget.horizontalHeaderItem": ('int',),
        "QTableWidget.indexFromItem": ('PySide2.QtWidgets.QTableWidgetItem',),
        "QTableWidget.insertColumn": ('int',),
        "QTableWidget.insertRow": ('int',),
        "QTableWidget.isItemSelected": ('PySide2.QtWidgets.QTableWidgetItem',),
        "QTableWidget.isPersistentEditorOpen": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QTableWidgetItem',)],
        "QTableWidget.isSortingEnabled": (),
        "QTableWidget.item": ('int', 'int'),
        "QTableWidget.itemAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QTableWidget.itemFromIndex": ('PySide2.QtCore.QModelIndex',),
        "QTableWidget.itemPrototype": (),
        "QTableWidget.items": ('PySide2.QtCore.QMimeData',),
        "QTableWidget.mimeData": ('list',),
        "QTableWidget.mimeTypes": (),
        "QTableWidget.openPersistentEditor": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QTableWidgetItem',)],
        "QTableWidget.removeCellWidget": ('int', 'int'),
        "QTableWidget.removeColumn": ('int',),
        "QTableWidget.removeRow": ('int',),
        "QTableWidget.row": ('PySide2.QtWidgets.QTableWidgetItem',),
        "QTableWidget.rowCount": (),
        "QTableWidget.scrollToItem": ('PySide2.QtWidgets.QTableWidgetItem', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
        "QTableWidget.selectedItems": (),
        "QTableWidget.selectedRanges": (),
        "QTableWidget.setCellWidget": ('int', 'int', 'PySide2.QtWidgets.QWidget'),
        "QTableWidget.setColumnCount": ('int',),
        "QTableWidget.setCurrentCell": [('int', 'int'), ('int', 'int', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags')],
        "QTableWidget.setCurrentItem": [('PySide2.QtWidgets.QTableWidgetItem',), ('PySide2.QtWidgets.QTableWidgetItem', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags')],
        "QTableWidget.setHorizontalHeaderItem": ('int', 'PySide2.QtWidgets.QTableWidgetItem'),
        "QTableWidget.setHorizontalHeaderLabels": ('typing.List[str]',),
        "QTableWidget.setItem": ('int', 'int', 'PySide2.QtWidgets.QTableWidgetItem'),
        "QTableWidget.setItemPrototype": ('PySide2.QtWidgets.QTableWidgetItem',),
        "QTableWidget.setItemSelected": ('PySide2.QtWidgets.QTableWidgetItem', 'bool'),
        "QTableWidget.setModel": ('PySide2.QtCore.QAbstractItemModel',),
        "QTableWidget.setRangeSelected": ('PySide2.QtWidgets.QTableWidgetSelectionRange', 'bool'),
        "QTableWidget.setRowCount": ('int',),
        "QTableWidget.setSortingEnabled": ('bool',),
        "QTableWidget.setVerticalHeaderItem": ('int', 'PySide2.QtWidgets.QTableWidgetItem'),
        "QTableWidget.setVerticalHeaderLabels": ('typing.List[str]',),
        "QTableWidget.sortItems": ('int', 'PySide2.QtCore.Qt.SortOrder'),
        "QTableWidget.supportedDropActions": (),
        "QTableWidget.takeHorizontalHeaderItem": ('int',),
        "QTableWidget.takeItem": ('int', 'int'),
        "QTableWidget.takeVerticalHeaderItem": ('int',),
        "QTableWidget.verticalHeaderItem": ('int',),
        "QTableWidget.visualColumn": ('int',),
        "QTableWidget.visualItemRect": ('PySide2.QtWidgets.QTableWidgetItem',),
        "QTableWidget.visualRow": ('int',),

    # class PySide2.QtWidgets.QTableWidgetItem:
        "QTableWidgetItem.__init__": [('PySide2.QtGui.QIcon', 'str', 'int'), ('PySide2.QtWidgets.QTableWidgetItem',), ('int',), ('str', 'int')],
        "QTableWidgetItem.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QTableWidgetItem.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QTableWidgetItem.background": (),
        "QTableWidgetItem.backgroundColor": (),
        "QTableWidgetItem.checkState": (),
        "QTableWidgetItem.clone": (),
        "QTableWidgetItem.column": (),
        "QTableWidgetItem.data": ('int',),
        "QTableWidgetItem.flags": (),
        "QTableWidgetItem.font": (),
        "QTableWidgetItem.foreground": (),
        "QTableWidgetItem.icon": (),
        "QTableWidgetItem.isSelected": (),
        "QTableWidgetItem.read": ('PySide2.QtCore.QDataStream',),
        "QTableWidgetItem.row": (),
        "QTableWidgetItem.setBackground": ('PySide2.QtGui.QBrush',),
        "QTableWidgetItem.setBackgroundColor": ('PySide2.QtGui.QColor',),
        "QTableWidgetItem.setCheckState": ('PySide2.QtCore.Qt.CheckState',),
        "QTableWidgetItem.setData": ('int', 'typing.Any'),
        "QTableWidgetItem.setFlags": ('PySide2.QtCore.Qt.ItemFlags',),
        "QTableWidgetItem.setFont": ('PySide2.QtGui.QFont',),
        "QTableWidgetItem.setForeground": ('PySide2.QtGui.QBrush',),
        "QTableWidgetItem.setIcon": ('PySide2.QtGui.QIcon',),
        "QTableWidgetItem.setSelected": ('bool',),
        "QTableWidgetItem.setSizeHint": ('PySide2.QtCore.QSize',),
        "QTableWidgetItem.setStatusTip": ('str',),
        "QTableWidgetItem.setText": ('str',),
        "QTableWidgetItem.setTextAlignment": ('int',),
        "QTableWidgetItem.setTextColor": ('PySide2.QtGui.QColor',),
        "QTableWidgetItem.setToolTip": ('str',),
        "QTableWidgetItem.setWhatsThis": ('str',),
        "QTableWidgetItem.sizeHint": (),
        "QTableWidgetItem.statusTip": (),
        "QTableWidgetItem.tableWidget": (),
        "QTableWidgetItem.text": (),
        "QTableWidgetItem.textAlignment": (),
        "QTableWidgetItem.textColor": (),
        "QTableWidgetItem.toolTip": (),
        "QTableWidgetItem.type": (),
        "QTableWidgetItem.whatsThis": (),
        "QTableWidgetItem.write": ('PySide2.QtCore.QDataStream',),

    # class PySide2.QtWidgets.QTableWidgetSelectionRange:
        "QTableWidgetSelectionRange.__init__": [(), ('PySide2.QtWidgets.QTableWidgetSelectionRange',), ('int', 'int', 'int', 'int')],
        "QTableWidgetSelectionRange.__copy__": (),
        "QTableWidgetSelectionRange.bottomRow": (),
        "QTableWidgetSelectionRange.columnCount": (),
        "QTableWidgetSelectionRange.leftColumn": (),
        "QTableWidgetSelectionRange.rightColumn": (),
        "QTableWidgetSelectionRange.rowCount": (),
        "QTableWidgetSelectionRange.topRow": (),

    # class PySide2.QtWidgets.QTapAndHoldGesture:
        "QTapAndHoldGesture.__init__": ('PySide2.QtCore.QObject',),
        "QTapAndHoldGesture.position": (),
        "QTapAndHoldGesture.setPosition": ('PySide2.QtCore.QPointF',),
        "QTapAndHoldGesture.setTimeout": ('int',),
        "QTapAndHoldGesture.timeout": (),

    # class PySide2.QtWidgets.QTapGesture:
        "QTapGesture.__init__": ('PySide2.QtCore.QObject',),
        "QTapGesture.position": (),
        "QTapGesture.setPosition": ('PySide2.QtCore.QPointF',),

    # class PySide2.QtWidgets.QTextBrowser:
        "QTextBrowser.__init__": ('PySide2.QtWidgets.QWidget',),
        "QTextBrowser.backward": (),
        "QTextBrowser.backwardHistoryCount": (),
        "QTextBrowser.clearHistory": (),
        "QTextBrowser.event": ('PySide2.QtCore.QEvent',),
        "QTextBrowser.focusNextPrevChild": ('bool',),
        "QTextBrowser.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QTextBrowser.forward": (),
        "QTextBrowser.forwardHistoryCount": (),
        "QTextBrowser.historyTitle": ('int',),
        "QTextBrowser.historyUrl": ('int',),
        "QTextBrowser.home": (),
        "QTextBrowser.isBackwardAvailable": (),
        "QTextBrowser.isForwardAvailable": (),
        "QTextBrowser.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QTextBrowser.loadResource": ('int', 'PySide2.QtCore.QUrl'),
        "QTextBrowser.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QTextBrowser.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QTextBrowser.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QTextBrowser.openExternalLinks": (),
        "QTextBrowser.openLinks": (),
        "QTextBrowser.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QTextBrowser.reload": (),
        "QTextBrowser.searchPaths": (),
        "QTextBrowser.setOpenExternalLinks": ('bool',),
        "QTextBrowser.setOpenLinks": ('bool',),
        "QTextBrowser.setSearchPaths": ('typing.List[str]',),
        "QTextBrowser.setSource": ('PySide2.QtCore.QUrl',),
        "QTextBrowser.source": (),

    # class PySide2.QtWidgets.QTextEdit:
        "QTextEdit.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
        "QTextEdit.acceptRichText": (),
        "QTextEdit.alignment": (),
        "QTextEdit.anchorAt": ('PySide2.QtCore.QPoint',),
        "QTextEdit.append": ('str',),
        "QTextEdit.autoFormatting": (),
        "QTextEdit.canInsertFromMimeData": ('PySide2.QtCore.QMimeData',),
        "QTextEdit.canPaste": (),
        "QTextEdit.changeEvent": ('PySide2.QtCore.QEvent',),
        "QTextEdit.clear": (),
        "QTextEdit.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
        "QTextEdit.copy": (),
        "QTextEdit.createMimeDataFromSelection": (),
        "QTextEdit.createStandardContextMenu": [(), ('PySide2.QtCore.QPoint',)],
        "QTextEdit.currentCharFormat": (),
        "QTextEdit.currentFont": (),
        "QTextEdit.cursorForPosition": ('PySide2.QtCore.QPoint',),
        "QTextEdit.cursorRect": [(), ('PySide2.QtGui.QTextCursor',)],
        "QTextEdit.cursorWidth": (),
        "QTextEdit.cut": (),
        "QTextEdit.doSetTextCursor": ('PySide2.QtGui.QTextCursor',),
        "QTextEdit.document": (),
        "QTextEdit.documentTitle": (),
        "QTextEdit.dragEnterEvent": ('PySide2.QtGui.QDragEnterEvent',),
        "QTextEdit.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
        "QTextEdit.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
        "QTextEdit.dropEvent": ('PySide2.QtGui.QDropEvent',),
        "QTextEdit.ensureCursorVisible": (),
        "QTextEdit.event": ('PySide2.QtCore.QEvent',),
        "QTextEdit.extraSelections": (),
        "QTextEdit.find": [('PySide2.QtCore.QRegExp', 'PySide2.QtGui.QTextDocument.FindFlags'), ('str', 'PySide2.QtGui.QTextDocument.FindFlags')],
        "QTextEdit.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QTextEdit.focusNextPrevChild": ('bool',),
        "QTextEdit.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QTextEdit.fontFamily": (),
        "QTextEdit.fontItalic": (),
        "QTextEdit.fontPointSize": (),
        "QTextEdit.fontUnderline": (),
        "QTextEdit.fontWeight": (),
        "QTextEdit.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
        "QTextEdit.inputMethodQuery": [('PySide2.QtCore.Qt.InputMethodQuery',), ('PySide2.QtCore.Qt.InputMethodQuery', 'typing.Any')],
        "QTextEdit.insertFromMimeData": ('PySide2.QtCore.QMimeData',),
        "QTextEdit.insertHtml": ('str',),
        "QTextEdit.insertPlainText": ('str',),
        "QTextEdit.isReadOnly": (),
        "QTextEdit.isUndoRedoEnabled": (),
        "QTextEdit.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QTextEdit.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
        "QTextEdit.lineWrapColumnOrWidth": (),
        "QTextEdit.lineWrapMode": (),
        "QTextEdit.loadResource": ('int', 'PySide2.QtCore.QUrl'),
        "QTextEdit.mergeCurrentCharFormat": ('PySide2.QtGui.QTextCharFormat',),
        "QTextEdit.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
        "QTextEdit.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QTextEdit.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QTextEdit.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QTextEdit.moveCursor": ('PySide2.QtGui.QTextCursor.MoveOperation', 'PySide2.QtGui.QTextCursor.MoveMode'),
        "QTextEdit.overwriteMode": (),
        "QTextEdit.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QTextEdit.paste": (),
        "QTextEdit.placeholderText": (),
        "QTextEdit.print_": ('PySide2.QtGui.QPagedPaintDevice',),
        "QTextEdit.redo": (),
        "QTextEdit.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QTextEdit.scrollContentsBy": ('int', 'int'),
        "QTextEdit.scrollToAnchor": ('str',),
        "QTextEdit.selectAll": (),
        "QTextEdit.setAcceptRichText": ('bool',),
        "QTextEdit.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
        "QTextEdit.setAutoFormatting": ('PySide2.QtWidgets.QTextEdit.AutoFormatting',),
        "QTextEdit.setCurrentCharFormat": ('PySide2.QtGui.QTextCharFormat',),
        "QTextEdit.setCurrentFont": ('PySide2.QtGui.QFont',),
        "QTextEdit.setCursorWidth": ('int',),
        "QTextEdit.setDocument": ('PySide2.QtGui.QTextDocument',),
        "QTextEdit.setDocumentTitle": ('str',),
        "QTextEdit.setExtraSelections": ('list',),
        "QTextEdit.setFontFamily": ('str',),
        "QTextEdit.setFontItalic": ('bool',),
        "QTextEdit.setFontPointSize": ('float',),
        "QTextEdit.setFontUnderline": ('bool',),
        "QTextEdit.setFontWeight": ('int',),
        "QTextEdit.setHtml": ('str',),
        "QTextEdit.setLineWrapColumnOrWidth": ('int',),
        "QTextEdit.setLineWrapMode": ('PySide2.QtWidgets.QTextEdit.LineWrapMode',),
        "QTextEdit.setOverwriteMode": ('bool',),
        "QTextEdit.setPlaceholderText": ('str',),
        "QTextEdit.setPlainText": ('str',),
        "QTextEdit.setReadOnly": ('bool',),
        "QTextEdit.setTabChangesFocus": ('bool',),
        "QTextEdit.setTabStopDistance": ('float',),
        "QTextEdit.setTabStopWidth": ('int',),
        "QTextEdit.setText": ('str',),
        "QTextEdit.setTextBackgroundColor": ('PySide2.QtGui.QColor',),
        "QTextEdit.setTextColor": ('PySide2.QtGui.QColor',),
        "QTextEdit.setTextCursor": ('PySide2.QtGui.QTextCursor',),
        "QTextEdit.setTextInteractionFlags": ('PySide2.QtCore.Qt.TextInteractionFlags',),
        "QTextEdit.setUndoRedoEnabled": ('bool',),
        "QTextEdit.setWordWrapMode": ('PySide2.QtGui.QTextOption.WrapMode',),
        "QTextEdit.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QTextEdit.tabChangesFocus": (),
        "QTextEdit.tabStopDistance": (),
        "QTextEdit.tabStopWidth": (),
        "QTextEdit.textBackgroundColor": (),
        "QTextEdit.textColor": (),
        "QTextEdit.textCursor": (),
        "QTextEdit.textInteractionFlags": (),
        "QTextEdit.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QTextEdit.toHtml": (),
        "QTextEdit.toPlainText": (),
        "QTextEdit.undo": (),
        "QTextEdit.wheelEvent": ('PySide2.QtGui.QWheelEvent',),
        "QTextEdit.wordWrapMode": (),
        "QTextEdit.zoomIn": ('int',),
        "QTextEdit.zoomInF": ('float',),
        "QTextEdit.zoomOut": ('int',),

    # class PySide2.QtWidgets.QTextEdit.ExtraSelection:
        "QTextEdit.ExtraSelection.__init__": [(), ('PySide2.QtWidgets.QTextEdit.ExtraSelection',)],
        "QTextEdit.ExtraSelection.__copy__": (),

    # class PySide2.QtWidgets.QTileRules:
        "QTileRules.__init__": [('PySide2.QtCore.Qt.TileRule',), ('PySide2.QtCore.Qt.TileRule', 'PySide2.QtCore.Qt.TileRule'), ('PySide2.QtWidgets.QTileRules',)],
        "QTileRules.__copy__": (),

    # class PySide2.QtWidgets.QTimeEdit:
        "QTimeEdit.__init__": [('PySide2.QtCore.QTime', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],

    # class PySide2.QtWidgets.QToolBar:
        "QToolBar.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
        "QToolBar.actionAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QToolBar.actionEvent": ('PySide2.QtGui.QActionEvent',),
        "QToolBar.actionGeometry": ('PySide2.QtWidgets.QAction',),
        "QToolBar.addAction": [('PySide2.QtGui.QIcon', 'str'), ('PySide2.QtGui.QIcon', 'str', 'PySide2.QtCore.QObject', 'str'), ('PySide2.QtWidgets.QAction',), ('str',), ('str', 'PySide2.QtCore.QObject', 'str')],
        "QToolBar.addSeparator": (),
        "QToolBar.addWidget": ('PySide2.QtWidgets.QWidget',),
        "QToolBar.allowedAreas": (),
        "QToolBar.changeEvent": ('PySide2.QtCore.QEvent',),
        "QToolBar.clear": (),
        "QToolBar.event": ('PySide2.QtCore.QEvent',),
        "QToolBar.iconSize": (),
        "QToolBar.initStyleOption": ('PySide2.QtWidgets.QStyleOptionToolBar',),
        "QToolBar.insertSeparator": ('PySide2.QtWidgets.QAction',),
        "QToolBar.insertWidget": ('PySide2.QtWidgets.QAction', 'PySide2.QtWidgets.QWidget'),
        "QToolBar.isAreaAllowed": ('PySide2.QtCore.Qt.ToolBarArea',),
        "QToolBar.isFloatable": (),
        "QToolBar.isFloating": (),
        "QToolBar.isMovable": (),
        "QToolBar.orientation": (),
        "QToolBar.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QToolBar.setAllowedAreas": ('PySide2.QtCore.Qt.ToolBarAreas',),
        "QToolBar.setFloatable": ('bool',),
        "QToolBar.setIconSize": ('PySide2.QtCore.QSize',),
        "QToolBar.setMovable": ('bool',),
        "QToolBar.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
        "QToolBar.setToolButtonStyle": ('PySide2.QtCore.Qt.ToolButtonStyle',),
        "QToolBar.toggleViewAction": (),
        "QToolBar.toolButtonStyle": (),
        "QToolBar.widgetForAction": ('PySide2.QtWidgets.QAction',),

    # class PySide2.QtWidgets.QToolBox:
        "QToolBox.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
        "QToolBox.addItem": [('PySide2.QtWidgets.QWidget', 'PySide2.QtGui.QIcon', 'str'), ('PySide2.QtWidgets.QWidget', 'str')],
        "QToolBox.changeEvent": ('PySide2.QtCore.QEvent',),
        "QToolBox.count": (),
        "QToolBox.currentIndex": (),
        "QToolBox.currentWidget": (),
        "QToolBox.event": ('PySide2.QtCore.QEvent',),
        "QToolBox.indexOf": ('PySide2.QtWidgets.QWidget',),
        "QToolBox.insertItem": [('int', 'PySide2.QtWidgets.QWidget', 'PySide2.QtGui.QIcon', 'str'), ('int', 'PySide2.QtWidgets.QWidget', 'str')],
        "QToolBox.isItemEnabled": ('int',),
        "QToolBox.itemIcon": ('int',),
        "QToolBox.itemInserted": ('int',),
        "QToolBox.itemRemoved": ('int',),
        "QToolBox.itemText": ('int',),
        "QToolBox.itemToolTip": ('int',),
        "QToolBox.removeItem": ('int',),
        "QToolBox.setCurrentIndex": ('int',),
        "QToolBox.setCurrentWidget": ('PySide2.QtWidgets.QWidget',),
        "QToolBox.setItemEnabled": ('int', 'bool'),
        "QToolBox.setItemIcon": ('int', 'PySide2.QtGui.QIcon'),
        "QToolBox.setItemText": ('int', 'str'),
        "QToolBox.setItemToolTip": ('int', 'str'),
        "QToolBox.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QToolBox.widget": ('int',),

    # class PySide2.QtWidgets.QToolButton:
        "QToolButton.__init__": ('PySide2.QtWidgets.QWidget',),
        "QToolButton.actionEvent": ('PySide2.QtGui.QActionEvent',),
        "QToolButton.arrowType": (),
        "QToolButton.autoRaise": (),
        "QToolButton.changeEvent": ('PySide2.QtCore.QEvent',),
        "QToolButton.defaultAction": (),
        "QToolButton.enterEvent": ('PySide2.QtCore.QEvent',),
        "QToolButton.event": ('PySide2.QtCore.QEvent',),
        "QToolButton.hitButton": ('PySide2.QtCore.QPoint',),
        "QToolButton.initStyleOption": ('PySide2.QtWidgets.QStyleOptionToolButton',),
        "QToolButton.leaveEvent": ('PySide2.QtCore.QEvent',),
        "QToolButton.menu": (),
        "QToolButton.minimumSizeHint": (),
        "QToolButton.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QToolButton.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QToolButton.nextCheckState": (),
        "QToolButton.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QToolButton.popupMode": (),
        "QToolButton.setArrowType": ('PySide2.QtCore.Qt.ArrowType',),
        "QToolButton.setAutoRaise": ('bool',),
        "QToolButton.setDefaultAction": ('PySide2.QtWidgets.QAction',),
        "QToolButton.setMenu": ('PySide2.QtWidgets.QMenu',),
        "QToolButton.setPopupMode": ('PySide2.QtWidgets.QToolButton.ToolButtonPopupMode',),
        "QToolButton.setToolButtonStyle": ('PySide2.QtCore.Qt.ToolButtonStyle',),
        "QToolButton.showMenu": (),
        "QToolButton.sizeHint": (),
        "QToolButton.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QToolButton.toolButtonStyle": (),

    # class PySide2.QtWidgets.QToolTip:
        "QToolTip.font": (),
        "QToolTip.hideText": (),
        "QToolTip.isVisible": (),
        "QToolTip.palette": (),
        "QToolTip.setFont": ('PySide2.QtGui.QFont',),
        "QToolTip.setPalette": ('PySide2.QtGui.QPalette',),
        "QToolTip.showText": [('PySide2.QtCore.QPoint', 'str', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtCore.QPoint', 'str', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QRect'), ('PySide2.QtCore.QPoint', 'str', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QRect', 'int')],
        "QToolTip.text": (),

    # class PySide2.QtWidgets.QTreeView:
        "QTreeView.__init__": ('PySide2.QtWidgets.QWidget',),
        "QTreeView.allColumnsShowFocus": (),
        "QTreeView.autoExpandDelay": (),
        "QTreeView.collapse": ('PySide2.QtCore.QModelIndex',),
        "QTreeView.collapseAll": (),
        "QTreeView.columnAt": ('int',),
        "QTreeView.columnCountChanged": ('int', 'int'),
        "QTreeView.columnMoved": (),
        "QTreeView.columnResized": ('int', 'int', 'int'),
        "QTreeView.columnViewportPosition": ('int',),
        "QTreeView.columnWidth": ('int',),
        "QTreeView.currentChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
        "QTreeView.dataChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex', 'list'),
        "QTreeView.doItemsLayout": (),
        "QTreeView.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
        "QTreeView.drawBranches": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'PySide2.QtCore.QModelIndex'),
        "QTreeView.drawRow": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QTreeView.drawTree": ('PySide2.QtGui.QPainter', 'PySide2.QtGui.QRegion'),
        "QTreeView.expand": ('PySide2.QtCore.QModelIndex',),
        "QTreeView.expandAll": (),
        "QTreeView.expandToDepth": ('int',),
        "QTreeView.expandsOnDoubleClick": (),
        "QTreeView.header": (),
        "QTreeView.hideColumn": ('int',),
        "QTreeView.horizontalOffset": (),
        "QTreeView.horizontalScrollbarAction": ('int',),
        "QTreeView.indentation": (),
        "QTreeView.indexAbove": ('PySide2.QtCore.QModelIndex',),
        "QTreeView.indexAt": ('PySide2.QtCore.QPoint',),
        "QTreeView.indexBelow": ('PySide2.QtCore.QModelIndex',),
        "QTreeView.indexRowSizeHint": ('PySide2.QtCore.QModelIndex',),
        "QTreeView.isAnimated": (),
        "QTreeView.isColumnHidden": ('int',),
        "QTreeView.isExpanded": ('PySide2.QtCore.QModelIndex',),
        "QTreeView.isFirstColumnSpanned": ('int', 'PySide2.QtCore.QModelIndex'),
        "QTreeView.isHeaderHidden": (),
        "QTreeView.isIndexHidden": ('PySide2.QtCore.QModelIndex',),
        "QTreeView.isRowHidden": ('int', 'PySide2.QtCore.QModelIndex'),
        "QTreeView.isSortingEnabled": (),
        "QTreeView.itemsExpandable": (),
        "QTreeView.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QTreeView.keyboardSearch": ('str',),
        "QTreeView.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
        "QTreeView.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QTreeView.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QTreeView.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QTreeView.moveCursor": ('PySide2.QtWidgets.QAbstractItemView.CursorAction', 'PySide2.QtCore.Qt.KeyboardModifiers'),
        "QTreeView.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QTreeView.reexpand": (),
        "QTreeView.reset": (),
        "QTreeView.resetIndentation": (),
        "QTreeView.resizeColumnToContents": ('int',),
        "QTreeView.rootIsDecorated": (),
        "QTreeView.rowHeight": ('PySide2.QtCore.QModelIndex',),
        "QTreeView.rowsAboutToBeRemoved": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QTreeView.rowsInserted": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QTreeView.rowsRemoved": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QTreeView.scrollContentsBy": ('int', 'int'),
        "QTreeView.scrollTo": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
        "QTreeView.selectAll": (),
        "QTreeView.selectedIndexes": (),
        "QTreeView.selectionChanged": ('PySide2.QtCore.QItemSelection', 'PySide2.QtCore.QItemSelection'),
        "QTreeView.setAllColumnsShowFocus": ('bool',),
        "QTreeView.setAnimated": ('bool',),
        "QTreeView.setAutoExpandDelay": ('int',),
        "QTreeView.setColumnHidden": ('int', 'bool'),
        "QTreeView.setColumnWidth": ('int', 'int'),
        "QTreeView.setExpanded": ('PySide2.QtCore.QModelIndex', 'bool'),
        "QTreeView.setExpandsOnDoubleClick": ('bool',),
        "QTreeView.setFirstColumnSpanned": ('int', 'PySide2.QtCore.QModelIndex', 'bool'),
        "QTreeView.setHeader": ('PySide2.QtWidgets.QHeaderView',),
        "QTreeView.setHeaderHidden": ('bool',),
        "QTreeView.setIndentation": ('int',),
        "QTreeView.setItemsExpandable": ('bool',),
        "QTreeView.setModel": ('PySide2.QtCore.QAbstractItemModel',),
        "QTreeView.setRootIndex": ('PySide2.QtCore.QModelIndex',),
        "QTreeView.setRootIsDecorated": ('bool',),
        "QTreeView.setRowHidden": ('int', 'PySide2.QtCore.QModelIndex', 'bool'),
        "QTreeView.setSelection": ('PySide2.QtCore.QRect', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
        "QTreeView.setSelectionModel": ('PySide2.QtCore.QItemSelectionModel',),
        "QTreeView.setSortingEnabled": ('bool',),
        "QTreeView.setTreePosition": ('int',),
        "QTreeView.setUniformRowHeights": ('bool',),
        "QTreeView.setWordWrap": ('bool',),
        "QTreeView.showColumn": ('int',),
        "QTreeView.sizeHintForColumn": ('int',),
        "QTreeView.sortByColumn": [('int',), ('int', 'PySide2.QtCore.Qt.SortOrder')],
        "QTreeView.timerEvent": ('PySide2.QtCore.QTimerEvent',),
        "QTreeView.treePosition": (),
        "QTreeView.uniformRowHeights": (),
        "QTreeView.updateGeometries": (),
        "QTreeView.verticalOffset": (),
        "QTreeView.verticalScrollbarValueChanged": ('int',),
        "QTreeView.viewportEvent": ('PySide2.QtCore.QEvent',),
        "QTreeView.viewportSizeHint": (),
        "QTreeView.visualRect": ('PySide2.QtCore.QModelIndex',),
        "QTreeView.visualRegionForSelection": ('PySide2.QtCore.QItemSelection',),
        "QTreeView.wordWrap": (),

    # class PySide2.QtWidgets.QTreeWidget:
        "QTreeWidget.__init__": ('PySide2.QtWidgets.QWidget',),
        "QTreeWidget.addTopLevelItem": ('PySide2.QtWidgets.QTreeWidgetItem',),
        "QTreeWidget.addTopLevelItems": ('list',),
        "QTreeWidget.clear": (),
        "QTreeWidget.closePersistentEditor": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QTreeWidgetItem', 'int')],
        "QTreeWidget.collapseItem": ('PySide2.QtWidgets.QTreeWidgetItem',),
        "QTreeWidget.columnCount": (),
        "QTreeWidget.currentColumn": (),
        "QTreeWidget.currentItem": (),
        "QTreeWidget.dropEvent": ('PySide2.QtGui.QDropEvent',),
        "QTreeWidget.dropMimeData": ('PySide2.QtWidgets.QTreeWidgetItem', 'int', 'PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction'),
        "QTreeWidget.editItem": ('PySide2.QtWidgets.QTreeWidgetItem', 'int'),
        "QTreeWidget.event": ('PySide2.QtCore.QEvent',),
        "QTreeWidget.expandItem": ('PySide2.QtWidgets.QTreeWidgetItem',),
        "QTreeWidget.findItems": ('str', 'PySide2.QtCore.Qt.MatchFlags', 'int'),
        "QTreeWidget.headerItem": (),
        "QTreeWidget.indexFromItem": ('PySide2.QtWidgets.QTreeWidgetItem', 'int'),
        "QTreeWidget.indexOfTopLevelItem": ('PySide2.QtWidgets.QTreeWidgetItem',),
        "QTreeWidget.insertTopLevelItem": ('int', 'PySide2.QtWidgets.QTreeWidgetItem'),
        "QTreeWidget.insertTopLevelItems": ('int', 'list'),
        "QTreeWidget.invisibleRootItem": (),
        "QTreeWidget.isFirstItemColumnSpanned": ('PySide2.QtWidgets.QTreeWidgetItem',),
        "QTreeWidget.isItemExpanded": ('PySide2.QtWidgets.QTreeWidgetItem',),
        "QTreeWidget.isItemHidden": ('PySide2.QtWidgets.QTreeWidgetItem',),
        "QTreeWidget.isItemSelected": ('PySide2.QtWidgets.QTreeWidgetItem',),
        "QTreeWidget.isPersistentEditorOpen": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QTreeWidgetItem', 'int')],
        "QTreeWidget.itemAbove": ('PySide2.QtWidgets.QTreeWidgetItem',),
        "QTreeWidget.itemAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QTreeWidget.itemBelow": ('PySide2.QtWidgets.QTreeWidgetItem',),
        "QTreeWidget.itemFromIndex": ('PySide2.QtCore.QModelIndex',),
        "QTreeWidget.itemWidget": ('PySide2.QtWidgets.QTreeWidgetItem', 'int'),
        "QTreeWidget.items": ('PySide2.QtCore.QMimeData',),
        "QTreeWidget.mimeData": ('list',),
        "QTreeWidget.mimeTypes": (),
        "QTreeWidget.openPersistentEditor": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QTreeWidgetItem', 'int')],
        "QTreeWidget.removeItemWidget": ('PySide2.QtWidgets.QTreeWidgetItem', 'int'),
        "QTreeWidget.scrollToItem": ('PySide2.QtWidgets.QTreeWidgetItem', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
        "QTreeWidget.selectedItems": (),
        "QTreeWidget.setColumnCount": ('int',),
        "QTreeWidget.setCurrentItem": [('PySide2.QtWidgets.QTreeWidgetItem',), ('PySide2.QtWidgets.QTreeWidgetItem', 'int'), ('PySide2.QtWidgets.QTreeWidgetItem', 'int', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags')],
        "QTreeWidget.setFirstItemColumnSpanned": ('PySide2.QtWidgets.QTreeWidgetItem', 'bool'),
        "QTreeWidget.setHeaderItem": ('PySide2.QtWidgets.QTreeWidgetItem',),
        "QTreeWidget.setHeaderLabel": ('str',),
        "QTreeWidget.setHeaderLabels": ('typing.List[str]',),
        "QTreeWidget.setItemExpanded": ('PySide2.QtWidgets.QTreeWidgetItem', 'bool'),
        "QTreeWidget.setItemHidden": ('PySide2.QtWidgets.QTreeWidgetItem', 'bool'),
        "QTreeWidget.setItemSelected": ('PySide2.QtWidgets.QTreeWidgetItem', 'bool'),
        "QTreeWidget.setItemWidget": ('PySide2.QtWidgets.QTreeWidgetItem', 'int', 'PySide2.QtWidgets.QWidget'),
        "QTreeWidget.setModel": ('PySide2.QtCore.QAbstractItemModel',),
        "QTreeWidget.setSelectionModel": ('PySide2.QtCore.QItemSelectionModel',),
        "QTreeWidget.sortColumn": (),
        "QTreeWidget.sortItems": ('int', 'PySide2.QtCore.Qt.SortOrder'),
        "QTreeWidget.supportedDropActions": (),
        "QTreeWidget.takeTopLevelItem": ('int',),
        "QTreeWidget.topLevelItem": ('int',),
        "QTreeWidget.topLevelItemCount": (),
        "QTreeWidget.visualItemRect": ('PySide2.QtWidgets.QTreeWidgetItem',),

    # class PySide2.QtWidgets.QTreeWidgetItem:
        "QTreeWidgetItem.__init__": [('PySide2.QtWidgets.QTreeWidget', 'PySide2.QtWidgets.QTreeWidgetItem', 'int'), ('PySide2.QtWidgets.QTreeWidget', 'int'), ('PySide2.QtWidgets.QTreeWidget', 'typing.List[str]', 'int'), ('PySide2.QtWidgets.QTreeWidgetItem',), ('PySide2.QtWidgets.QTreeWidgetItem', 'PySide2.QtWidgets.QTreeWidgetItem', 'int'), ('PySide2.QtWidgets.QTreeWidgetItem', 'int'), ('PySide2.QtWidgets.QTreeWidgetItem', 'typing.List[str]', 'int'), ('int',), ('typing.List[str]', 'int')],
        "QTreeWidgetItem.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QTreeWidgetItem.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QTreeWidgetItem.addChild": ('PySide2.QtWidgets.QTreeWidgetItem',),
        "QTreeWidgetItem.addChildren": ('list',),
        "QTreeWidgetItem.background": ('int',),
        "QTreeWidgetItem.backgroundColor": ('int',),
        "QTreeWidgetItem.checkState": ('int',),
        "QTreeWidgetItem.child": ('int',),
        "QTreeWidgetItem.childCount": (),
        "QTreeWidgetItem.childIndicatorPolicy": (),
        "QTreeWidgetItem.clone": (),
        "QTreeWidgetItem.columnCount": (),
        "QTreeWidgetItem.data": ('int', 'int'),
        "QTreeWidgetItem.emitDataChanged": (),
        "QTreeWidgetItem.flags": (),
        "QTreeWidgetItem.font": ('int',),
        "QTreeWidgetItem.foreground": ('int',),
        "QTreeWidgetItem.icon": ('int',),
        "QTreeWidgetItem.indexOfChild": ('PySide2.QtWidgets.QTreeWidgetItem',),
        "QTreeWidgetItem.insertChild": ('int', 'PySide2.QtWidgets.QTreeWidgetItem'),
        "QTreeWidgetItem.insertChildren": ('int', 'list'),
        "QTreeWidgetItem.isDisabled": (),
        "QTreeWidgetItem.isExpanded": (),
        "QTreeWidgetItem.isFirstColumnSpanned": (),
        "QTreeWidgetItem.isHidden": (),
        "QTreeWidgetItem.isSelected": (),
        "QTreeWidgetItem.parent": (),
        "QTreeWidgetItem.read": ('PySide2.QtCore.QDataStream',),
        "QTreeWidgetItem.removeChild": ('PySide2.QtWidgets.QTreeWidgetItem',),
        "QTreeWidgetItem.setBackground": ('int', 'PySide2.QtGui.QBrush'),
        "QTreeWidgetItem.setBackgroundColor": ('int', 'PySide2.QtGui.QColor'),
        "QTreeWidgetItem.setCheckState": ('int', 'PySide2.QtCore.Qt.CheckState'),
        "QTreeWidgetItem.setChildIndicatorPolicy": ('PySide2.QtWidgets.QTreeWidgetItem.ChildIndicatorPolicy',),
        "QTreeWidgetItem.setData": ('int', 'int', 'typing.Any'),
        "QTreeWidgetItem.setDisabled": ('bool',),
        "QTreeWidgetItem.setExpanded": ('bool',),
        "QTreeWidgetItem.setFirstColumnSpanned": ('bool',),
        "QTreeWidgetItem.setFlags": ('PySide2.QtCore.Qt.ItemFlags',),
        "QTreeWidgetItem.setFont": ('int', 'PySide2.QtGui.QFont'),
        "QTreeWidgetItem.setForeground": ('int', 'PySide2.QtGui.QBrush'),
        "QTreeWidgetItem.setHidden": ('bool',),
        "QTreeWidgetItem.setIcon": ('int', 'PySide2.QtGui.QIcon'),
        "QTreeWidgetItem.setSelected": ('bool',),
        "QTreeWidgetItem.setSizeHint": ('int', 'PySide2.QtCore.QSize'),
        "QTreeWidgetItem.setStatusTip": ('int', 'str'),
        "QTreeWidgetItem.setText": ('int', 'str'),
        "QTreeWidgetItem.setTextAlignment": ('int', 'int'),
        "QTreeWidgetItem.setTextColor": ('int', 'PySide2.QtGui.QColor'),
        "QTreeWidgetItem.setToolTip": ('int', 'str'),
        "QTreeWidgetItem.setWhatsThis": ('int', 'str'),
        "QTreeWidgetItem.sizeHint": ('int',),
        "QTreeWidgetItem.sortChildren": ('int', 'PySide2.QtCore.Qt.SortOrder'),
        "QTreeWidgetItem.statusTip": ('int',),
        "QTreeWidgetItem.takeChild": ('int',),
        "QTreeWidgetItem.takeChildren": (),
        "QTreeWidgetItem.text": ('int',),
        "QTreeWidgetItem.textAlignment": ('int',),
        "QTreeWidgetItem.textColor": ('int',),
        "QTreeWidgetItem.toolTip": ('int',),
        "QTreeWidgetItem.treeWidget": (),
        "QTreeWidgetItem.type": (),
        "QTreeWidgetItem.whatsThis": ('int',),
        "QTreeWidgetItem.write": ('PySide2.QtCore.QDataStream',),

    # class PySide2.QtWidgets.QTreeWidgetItemIterator:
        "QTreeWidgetItemIterator.__init__": [('PySide2.QtWidgets.QTreeWidget', 'PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags'), ('PySide2.QtWidgets.QTreeWidgetItem', 'PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags'), ('PySide2.QtWidgets.QTreeWidgetItemIterator',)],
        "QTreeWidgetItemIterator.__copy__": (),
        "QTreeWidgetItemIterator.__iadd__": ('int',),
        "QTreeWidgetItemIterator.__isub__": ('int',),
        "QTreeWidgetItemIterator.__iter__": (),
        "QTreeWidgetItemIterator.value": (),

    # class PySide2.QtWidgets.QUndoCommand:
        "QUndoCommand.__init__": [('PySide2.QtWidgets.QUndoCommand',), ('str', 'PySide2.QtWidgets.QUndoCommand')],
        "QUndoCommand.actionText": (),
        "QUndoCommand.child": ('int',),
        "QUndoCommand.childCount": (),
        "QUndoCommand.id": (),
        "QUndoCommand.isObsolete": (),
        "QUndoCommand.mergeWith": ('PySide2.QtWidgets.QUndoCommand',),
        "QUndoCommand.redo": (),
        "QUndoCommand.setObsolete": ('bool',),
        "QUndoCommand.setText": ('str',),
        "QUndoCommand.text": (),
        "QUndoCommand.undo": (),

    # class PySide2.QtWidgets.QUndoGroup:
        "QUndoGroup.__init__": ('PySide2.QtCore.QObject',),
        "QUndoGroup.activeStack": (),
        "QUndoGroup.addStack": ('PySide2.QtWidgets.QUndoStack',),
        "QUndoGroup.canRedo": (),
        "QUndoGroup.canUndo": (),
        "QUndoGroup.createRedoAction": ('PySide2.QtCore.QObject', 'str'),
        "QUndoGroup.createUndoAction": ('PySide2.QtCore.QObject', 'str'),
        "QUndoGroup.isClean": (),
        "QUndoGroup.redo": (),
        "QUndoGroup.redoText": (),
        "QUndoGroup.removeStack": ('PySide2.QtWidgets.QUndoStack',),
        "QUndoGroup.setActiveStack": ('PySide2.QtWidgets.QUndoStack',),
        "QUndoGroup.stacks": (),
        "QUndoGroup.undo": (),
        "QUndoGroup.undoText": (),

    # class PySide2.QtWidgets.QUndoStack:
        "QUndoStack.__init__": ('PySide2.QtCore.QObject',),
        "QUndoStack.beginMacro": ('str',),
        "QUndoStack.canRedo": (),
        "QUndoStack.canUndo": (),
        "QUndoStack.cleanIndex": (),
        "QUndoStack.clear": (),
        "QUndoStack.command": ('int',),
        "QUndoStack.count": (),
        "QUndoStack.createRedoAction": ('PySide2.QtCore.QObject', 'str'),
        "QUndoStack.createUndoAction": ('PySide2.QtCore.QObject', 'str'),
        "QUndoStack.endMacro": (),
        "QUndoStack.index": (),
        "QUndoStack.isActive": (),
        "QUndoStack.isClean": (),
        "QUndoStack.push": ('PySide2.QtWidgets.QUndoCommand',),
        "QUndoStack.redo": (),
        "QUndoStack.redoText": (),
        "QUndoStack.resetClean": (),
        "QUndoStack.setActive": ('bool',),
        "QUndoStack.setClean": (),
        "QUndoStack.setIndex": ('int',),
        "QUndoStack.setUndoLimit": ('int',),
        "QUndoStack.text": ('int',),
        "QUndoStack.undo": (),
        "QUndoStack.undoLimit": (),
        "QUndoStack.undoText": (),

    # class PySide2.QtWidgets.QUndoView:
        "QUndoView.__init__": [('PySide2.QtWidgets.QUndoGroup', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QUndoStack', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
        "QUndoView.cleanIcon": (),
        "QUndoView.emptyLabel": (),
        "QUndoView.group": (),
        "QUndoView.setCleanIcon": ('PySide2.QtGui.QIcon',),
        "QUndoView.setEmptyLabel": ('str',),
        "QUndoView.setGroup": ('PySide2.QtWidgets.QUndoGroup',),
        "QUndoView.setStack": ('PySide2.QtWidgets.QUndoStack',),
        "QUndoView.stack": (),

    # class PySide2.QtWidgets.QVBoxLayout:
        "QVBoxLayout.__init__": [(), ('PySide2.QtWidgets.QWidget',)],

    # class PySide2.QtWidgets.QWhatsThis:
        "QWhatsThis.createAction": ('PySide2.QtCore.QObject',),
        "QWhatsThis.enterWhatsThisMode": (),
        "QWhatsThis.hideText": (),
        "QWhatsThis.inWhatsThisMode": (),
        "QWhatsThis.leaveWhatsThisMode": (),
        "QWhatsThis.showText": ('PySide2.QtCore.QPoint', 'str', 'PySide2.QtWidgets.QWidget'),

    # class PySide2.QtWidgets.QWidget:
        "QWidget.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
        "QWidget.acceptDrops": (),
        "QWidget.accessibleDescription": (),
        "QWidget.accessibleName": (),
        "QWidget.actionEvent": ('PySide2.QtGui.QActionEvent',),
        "QWidget.actions": (),
        "QWidget.activateWindow": (),
        "QWidget.addAction": ('PySide2.QtWidgets.QAction',),
        "QWidget.addActions": ('list',),
        "QWidget.adjustSize": (),
        "QWidget.autoFillBackground": (),
        "QWidget.backgroundRole": (),
        "QWidget.backingStore": (),
        "QWidget.baseSize": (),
        "QWidget.changeEvent": ('PySide2.QtCore.QEvent',),
        "QWidget.childAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QWidget.childrenRect": (),
        "QWidget.childrenRegion": (),
        "QWidget.clearFocus": (),
        "QWidget.clearMask": (),
        "QWidget.close": (),
        "QWidget.closeEvent": ('PySide2.QtGui.QCloseEvent',),
        "QWidget.contentsMargins": (),
        "QWidget.contentsRect": (),
        "QWidget.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
        "QWidget.contextMenuPolicy": (),
        "QWidget.create": ('int', 'bool', 'bool'),
        "QWidget.createWinId": (),
        "QWidget.createWindowContainer": ('PySide2.QtGui.QWindow', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
        "QWidget.cursor": (),
        "QWidget.destroy": ('bool', 'bool'),
        "QWidget.devType": (),
        "QWidget.dragEnterEvent": ('PySide2.QtGui.QDragEnterEvent',),
        "QWidget.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
        "QWidget.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
        "QWidget.dropEvent": ('PySide2.QtGui.QDropEvent',),
        "QWidget.effectiveWinId": (),
        "QWidget.ensurePolished": (),
        "QWidget.enterEvent": ('PySide2.QtCore.QEvent',),
        "QWidget.event": ('PySide2.QtCore.QEvent',),
        "QWidget.find": ('int',),
        "QWidget.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QWidget.focusNextChild": (),
        "QWidget.focusNextPrevChild": ('bool',),
        "QWidget.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
        "QWidget.focusPolicy": (),
        "QWidget.focusPreviousChild": (),
        "QWidget.focusProxy": (),
        "QWidget.focusWidget": (),
        "QWidget.font": (),
        "QWidget.fontInfo": (),
        "QWidget.fontMetrics": (),
        "QWidget.foregroundRole": (),
        "QWidget.frameGeometry": (),
        "QWidget.frameSize": (),
        "QWidget.geometry": (),
        "QWidget.getContentsMargins": ('int', 'int', 'int', 'int'),
        "QWidget.grab": ('PySide2.QtCore.QRect',),
        "QWidget.grabGesture": ('PySide2.QtCore.Qt.GestureType', 'PySide2.QtCore.Qt.GestureFlags'),
        "QWidget.grabKeyboard": (),
        "QWidget.grabMouse": [(), ('PySide2.QtGui.QCursor',)],
        "QWidget.grabShortcut": ('PySide2.QtGui.QKeySequence', 'PySide2.QtCore.Qt.ShortcutContext'),
        "QWidget.graphicsEffect": (),
        "QWidget.graphicsProxyWidget": (),
        "QWidget.hasFocus": (),
        "QWidget.hasHeightForWidth": (),
        "QWidget.hasMouseTracking": (),
        "QWidget.hasTabletTracking": (),
        "QWidget.height": (),
        "QWidget.heightForWidth": ('int',),
        "QWidget.hide": (),
        "QWidget.hideEvent": ('PySide2.QtGui.QHideEvent',),
        "QWidget.initPainter": ('PySide2.QtGui.QPainter',),
        "QWidget.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
        "QWidget.inputMethodHints": (),
        "QWidget.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
        "QWidget.insertAction": ('PySide2.QtWidgets.QAction', 'PySide2.QtWidgets.QAction'),
        "QWidget.insertActions": ('PySide2.QtWidgets.QAction', 'list'),
        "QWidget.internalWinId": (),
        "QWidget.isActiveWindow": (),
        "QWidget.isAncestorOf": ('PySide2.QtWidgets.QWidget',),
        "QWidget.isEnabled": (),
        "QWidget.isEnabledTo": ('PySide2.QtWidgets.QWidget',),
        "QWidget.isEnabledToTLW": (),
        "QWidget.isFullScreen": (),
        "QWidget.isHidden": (),
        "QWidget.isLeftToRight": (),
        "QWidget.isMaximized": (),
        "QWidget.isMinimized": (),
        "QWidget.isModal": (),
        "QWidget.isRightToLeft": (),
        "QWidget.isTopLevel": (),
        "QWidget.isVisible": (),
        "QWidget.isVisibleTo": ('PySide2.QtWidgets.QWidget',),
        "QWidget.isWindow": (),
        "QWidget.isWindowModified": (),
        "QWidget.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
        "QWidget.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
        "QWidget.keyboardGrabber": (),
        "QWidget.layout": (),
        "QWidget.layoutDirection": (),
        "QWidget.leaveEvent": ('PySide2.QtCore.QEvent',),
        "QWidget.locale": (),
        "QWidget.lower": (),
        "QWidget.mapFrom": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QPoint'),
        "QWidget.mapFromGlobal": ('PySide2.QtCore.QPoint',),
        "QWidget.mapFromParent": ('PySide2.QtCore.QPoint',),
        "QWidget.mapTo": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QPoint'),
        "QWidget.mapToGlobal": ('PySide2.QtCore.QPoint',),
        "QWidget.mapToParent": ('PySide2.QtCore.QPoint',),
        "QWidget.mask": (),
        "QWidget.maximumHeight": (),
        "QWidget.maximumSize": (),
        "QWidget.maximumWidth": (),
        "QWidget.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
        "QWidget.minimumHeight": (),
        "QWidget.minimumSize": (),
        "QWidget.minimumSizeHint": (),
        "QWidget.minimumWidth": (),
        "QWidget.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
        "QWidget.mouseGrabber": (),
        "QWidget.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
        "QWidget.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
        "QWidget.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
        "QWidget.move": [('PySide2.QtCore.QPoint',), ('int', 'int')],
        "QWidget.moveEvent": ('PySide2.QtGui.QMoveEvent',),
        "QWidget.nativeEvent": ('PySide2.QtCore.QByteArray', 'int', 'int'),
        "QWidget.nativeParentWidget": (),
        "QWidget.nextInFocusChain": (),
        "QWidget.normalGeometry": (),
        "QWidget.overrideWindowFlags": ('PySide2.QtCore.Qt.WindowFlags',),
        "QWidget.overrideWindowState": ('PySide2.QtCore.Qt.WindowStates',),
        "QWidget.paintEngine": (),
        "QWidget.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QWidget.palette": (),
        "QWidget.parentWidget": (),
        "QWidget.pos": (),
        "QWidget.previousInFocusChain": (),
        "QWidget.raise_": (),
        "QWidget.rect": (),
        "QWidget.redirected": ('PySide2.QtCore.QPoint',),
        "QWidget.releaseKeyboard": (),
        "QWidget.releaseMouse": (),
        "QWidget.releaseShortcut": ('int',),
        "QWidget.removeAction": ('PySide2.QtWidgets.QAction',),
        "QWidget.render": [('PySide2.QtGui.QPaintDevice', 'PySide2.QtCore.QPoint', 'PySide2.QtGui.QRegion', 'PySide2.QtWidgets.QWidget.RenderFlags'), ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QPoint', 'PySide2.QtGui.QRegion', 'PySide2.QtWidgets.QWidget.RenderFlags')],
        "QWidget.repaint": [(), ('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',), ('int', 'int', 'int', 'int')],
        "QWidget.resize": [('PySide2.QtCore.QSize',), ('int', 'int')],
        "QWidget.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QWidget.restoreGeometry": ('PySide2.QtCore.QByteArray',),
        "QWidget.saveGeometry": (),
        "QWidget.scroll": [('int', 'int'), ('int', 'int', 'PySide2.QtCore.QRect')],
        "QWidget.setAcceptDrops": ('bool',),
        "QWidget.setAccessibleDescription": ('str',),
        "QWidget.setAccessibleName": ('str',),
        "QWidget.setAttribute": ('PySide2.QtCore.Qt.WidgetAttribute', 'bool'),
        "QWidget.setAutoFillBackground": ('bool',),
        "QWidget.setBackgroundRole": ('PySide2.QtGui.QPalette.ColorRole',),
        "QWidget.setBaseSize": [('PySide2.QtCore.QSize',), ('int', 'int')],
        "QWidget.setContentsMargins": [('PySide2.QtCore.QMargins',), ('int', 'int', 'int', 'int')],
        "QWidget.setContextMenuPolicy": ('PySide2.QtCore.Qt.ContextMenuPolicy',),
        "QWidget.setCursor": ('PySide2.QtGui.QCursor',),
        "QWidget.setDisabled": ('bool',),
        "QWidget.setEnabled": ('bool',),
        "QWidget.setFixedHeight": ('int',),
        "QWidget.setFixedSize": [('PySide2.QtCore.QSize',), ('int', 'int')],
        "QWidget.setFixedWidth": ('int',),
        "QWidget.setFocus": [(), ('PySide2.QtCore.Qt.FocusReason',)],
        "QWidget.setFocusPolicy": ('PySide2.QtCore.Qt.FocusPolicy',),
        "QWidget.setFocusProxy": ('PySide2.QtWidgets.QWidget',),
        "QWidget.setFont": ('PySide2.QtGui.QFont',),
        "QWidget.setForegroundRole": ('PySide2.QtGui.QPalette.ColorRole',),
        "QWidget.setGeometry": [('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
        "QWidget.setGraphicsEffect": ('PySide2.QtWidgets.QGraphicsEffect',),
        "QWidget.setHidden": ('bool',),
        "QWidget.setInputMethodHints": ('PySide2.QtCore.Qt.InputMethodHints',),
        "QWidget.setLayout": ('PySide2.QtWidgets.QLayout',),
        "QWidget.setLayoutDirection": ('PySide2.QtCore.Qt.LayoutDirection',),
        "QWidget.setLocale": ('PySide2.QtCore.QLocale',),
        "QWidget.setMask": [('PySide2.QtGui.QBitmap',), ('PySide2.QtGui.QRegion',)],
        "QWidget.setMaximumHeight": ('int',),
        "QWidget.setMaximumSize": [('PySide2.QtCore.QSize',), ('int', 'int')],
        "QWidget.setMaximumWidth": ('int',),
        "QWidget.setMinimumHeight": ('int',),
        "QWidget.setMinimumSize": [('PySide2.QtCore.QSize',), ('int', 'int')],
        "QWidget.setMinimumWidth": ('int',),
        "QWidget.setMouseTracking": ('bool',),
        "QWidget.setPalette": ('PySide2.QtGui.QPalette',),
        "QWidget.setParent": [('PySide2.QtWidgets.QWidget',), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags')],
        "QWidget.setShortcutAutoRepeat": ('int', 'bool'),
        "QWidget.setShortcutEnabled": ('int', 'bool'),
        "QWidget.setSizeIncrement": [('PySide2.QtCore.QSize',), ('int', 'int')],
        "QWidget.setSizePolicy": [('PySide2.QtWidgets.QSizePolicy',), ('PySide2.QtWidgets.QSizePolicy.Policy', 'PySide2.QtWidgets.QSizePolicy.Policy')],
        "QWidget.setStatusTip": ('str',),
        "QWidget.setStyle": ('PySide2.QtWidgets.QStyle',),
        "QWidget.setStyleSheet": ('str',),
        "QWidget.setTabOrder": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QWidget'),
        "QWidget.setTabletTracking": ('bool',),
        "QWidget.setToolTip": ('str',),
        "QWidget.setToolTipDuration": ('int',),
        "QWidget.setUpdatesEnabled": ('bool',),
        "QWidget.setVisible": ('bool',),
        "QWidget.setWhatsThis": ('str',),
        "QWidget.setWindowFilePath": ('str',),
        "QWidget.setWindowFlag": ('PySide2.QtCore.Qt.WindowType', 'bool'),
        "QWidget.setWindowFlags": ('PySide2.QtCore.Qt.WindowFlags',),
        "QWidget.setWindowIcon": ('PySide2.QtGui.QIcon',),
        "QWidget.setWindowIconText": ('str',),
        "QWidget.setWindowModality": ('PySide2.QtCore.Qt.WindowModality',),
        "QWidget.setWindowModified": ('bool',),
        "QWidget.setWindowOpacity": ('float',),
        "QWidget.setWindowRole": ('str',),
        "QWidget.setWindowState": ('PySide2.QtCore.Qt.WindowStates',),
        "QWidget.setWindowTitle": ('str',),
        "QWidget.sharedPainter": (),
        "QWidget.show": (),
        "QWidget.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QWidget.showFullScreen": (),
        "QWidget.showMaximized": (),
        "QWidget.showMinimized": (),
        "QWidget.showNormal": (),
        "QWidget.size": (),
        "QWidget.sizeHint": (),
        "QWidget.sizeIncrement": (),
        "QWidget.sizePolicy": (),
        "QWidget.stackUnder": ('PySide2.QtWidgets.QWidget',),
        "QWidget.statusTip": (),
        "QWidget.style": (),
        "QWidget.styleSheet": (),
        "QWidget.tabletEvent": ('PySide2.QtGui.QTabletEvent',),
        "QWidget.testAttribute": ('PySide2.QtCore.Qt.WidgetAttribute',),
        "QWidget.toolTip": (),
        "QWidget.toolTipDuration": (),
        "QWidget.topLevelWidget": (),
        "QWidget.underMouse": (),
        "QWidget.ungrabGesture": ('PySide2.QtCore.Qt.GestureType',),
        "QWidget.unsetCursor": (),
        "QWidget.unsetLayoutDirection": (),
        "QWidget.unsetLocale": (),
        "QWidget.update": [(), ('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',), ('int', 'int', 'int', 'int')],
        "QWidget.updateGeometry": (),
        "QWidget.updateMicroFocus": (),
        "QWidget.updatesEnabled": (),
        "QWidget.visibleRegion": (),
        "QWidget.whatsThis": (),
        "QWidget.wheelEvent": ('PySide2.QtGui.QWheelEvent',),
        "QWidget.width": (),
        "QWidget.winId": (),
        "QWidget.window": (),
        "QWidget.windowFilePath": (),
        "QWidget.windowFlags": (),
        "QWidget.windowHandle": (),
        "QWidget.windowIcon": (),
        "QWidget.windowIconText": (),
        "QWidget.windowModality": (),
        "QWidget.windowOpacity": (),
        "QWidget.windowRole": (),
        "QWidget.windowState": (),
        "QWidget.windowTitle": (),
        "QWidget.windowType": (),
        "QWidget.x": (),
        "QWidget.y": (),

    # class PySide2.QtWidgets.QWidgetAction:
        "QWidgetAction.__init__": ('PySide2.QtCore.QObject',),
        "QWidgetAction.createWidget": ('PySide2.QtWidgets.QWidget',),
        "QWidgetAction.createdWidgets": (),
        "QWidgetAction.defaultWidget": (),
        "QWidgetAction.deleteWidget": ('PySide2.QtWidgets.QWidget',),
        "QWidgetAction.event": ('PySide2.QtCore.QEvent',),
        "QWidgetAction.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
        "QWidgetAction.releaseWidget": ('PySide2.QtWidgets.QWidget',),
        "QWidgetAction.requestWidget": ('PySide2.QtWidgets.QWidget',),
        "QWidgetAction.setDefaultWidget": ('PySide2.QtWidgets.QWidget',),

    # class PySide2.QtWidgets.QWidgetItem:
        "QWidgetItem.__init__": ('PySide2.QtWidgets.QWidget',),
        "QWidgetItem.controlTypes": (),
        "QWidgetItem.expandingDirections": (),
        "QWidgetItem.geometry": (),
        "QWidgetItem.hasHeightForWidth": (),
        "QWidgetItem.heightForWidth": ('int',),
        "QWidgetItem.isEmpty": (),
        "QWidgetItem.maximumSize": (),
        "QWidgetItem.minimumSize": (),
        "QWidgetItem.setGeometry": ('PySide2.QtCore.QRect',),
        "QWidgetItem.sizeHint": (),
        "QWidgetItem.widget": (),

    # class PySide2.QtWidgets.QWizard:
        "QWizard.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
        "QWizard.addPage": ('PySide2.QtWidgets.QWizardPage',),
        "QWizard.back": (),
        "QWizard.button": ('PySide2.QtWidgets.QWizard.WizardButton',),
        "QWizard.buttonText": ('PySide2.QtWidgets.QWizard.WizardButton',),
        "QWizard.cleanupPage": ('int',),
        "QWizard.currentId": (),
        "QWizard.currentPage": (),
        "QWizard.done": ('int',),
        "QWizard.event": ('PySide2.QtCore.QEvent',),
        "QWizard.field": ('str',),
        "QWizard.hasVisitedPage": ('int',),
        "QWizard.initializePage": ('int',),
        "QWizard.nextId": (),
        "QWizard.options": (),
        "QWizard.page": ('int',),
        "QWizard.pageIds": (),
        "QWizard.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QWizard.pixmap": ('PySide2.QtWidgets.QWizard.WizardPixmap',),
        "QWizard.removePage": ('int',),
        "QWizard.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QWizard.restart": (),
        "QWizard.setButton": ('PySide2.QtWidgets.QWizard.WizardButton', 'PySide2.QtWidgets.QAbstractButton'),
        "QWizard.setButtonLayout": ('list',),
        "QWizard.setButtonText": ('PySide2.QtWidgets.QWizard.WizardButton', 'str'),
        "QWizard.setDefaultProperty": ('str', 'str', 'str'),
        "QWizard.setField": ('str', 'typing.Any'),
        "QWizard.setOption": ('PySide2.QtWidgets.QWizard.WizardOption', 'bool'),
        "QWizard.setOptions": ('PySide2.QtWidgets.QWizard.WizardOptions',),
        "QWizard.setPage": ('int', 'PySide2.QtWidgets.QWizardPage'),
        "QWizard.setPixmap": ('PySide2.QtWidgets.QWizard.WizardPixmap', 'PySide2.QtGui.QPixmap'),
        "QWizard.setSideWidget": ('PySide2.QtWidgets.QWidget',),
        "QWizard.setStartId": ('int',),
        "QWizard.setSubTitleFormat": ('PySide2.QtCore.Qt.TextFormat',),
        "QWizard.setTitleFormat": ('PySide2.QtCore.Qt.TextFormat',),
        "QWizard.setVisible": ('bool',),
        "QWizard.setWizardStyle": ('PySide2.QtWidgets.QWizard.WizardStyle',),
        "QWizard.sideWidget": (),
        "QWizard.sizeHint": (),
        "QWizard.startId": (),
        "QWizard.subTitleFormat": (),
        "QWizard.testOption": ('PySide2.QtWidgets.QWizard.WizardOption',),
        "QWizard.titleFormat": (),
        "QWizard.validateCurrentPage": (),
        "QWizard.visitedPages": (),
        "QWizard.wizardStyle": (),

    # class PySide2.QtWidgets.QWizardPage:
        "QWizardPage.__init__": ('PySide2.QtWidgets.QWidget',),
        "QWizardPage.buttonText": ('PySide2.QtWidgets.QWizard.WizardButton',),
        "QWizardPage.cleanupPage": (),
        "QWizardPage.field": ('str',),
        "QWizardPage.initializePage": (),
        "QWizardPage.isCommitPage": (),
        "QWizardPage.isComplete": (),
        "QWizardPage.isFinalPage": (),
        "QWizardPage.nextId": (),
        "QWizardPage.pixmap": ('PySide2.QtWidgets.QWizard.WizardPixmap',),
        "QWizardPage.registerField": ('str', 'PySide2.QtWidgets.QWidget', 'str', 'str'),
        "QWizardPage.setButtonText": ('PySide2.QtWidgets.QWizard.WizardButton', 'str'),
        "QWizardPage.setCommitPage": ('bool',),
        "QWizardPage.setField": ('str', 'typing.Any'),
        "QWizardPage.setFinalPage": ('bool',),
        "QWizardPage.setPixmap": ('PySide2.QtWidgets.QWizard.WizardPixmap', 'PySide2.QtGui.QPixmap'),
        "QWizardPage.setSubTitle": ('str',),
        "QWizardPage.setTitle": ('str',),
        "QWizardPage.subTitle": (),
        "QWizardPage.title": (),
        "QWizardPage.validatePage": (),
        "QWizardPage.wizard": (),
    })

# Module PySide2.QtPrintSupport
if "PySide2.QtPrintSupport" in sys.modules:
    dict.update({

    # class PySide2.QtPrintSupport.QAbstractPrintDialog:
        "QAbstractPrintDialog.__init__": ('PySide2.QtPrintSupport.QPrinter', 'PySide2.QtWidgets.QWidget'),
        "QAbstractPrintDialog.addEnabledOption": ('PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption',),
        "QAbstractPrintDialog.enabledOptions": (),
        "QAbstractPrintDialog.exec_": (),
        "QAbstractPrintDialog.fromPage": (),
        "QAbstractPrintDialog.isOptionEnabled": ('PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption',),
        "QAbstractPrintDialog.maxPage": (),
        "QAbstractPrintDialog.minPage": (),
        "QAbstractPrintDialog.printRange": (),
        "QAbstractPrintDialog.printer": (),
        "QAbstractPrintDialog.setEnabledOptions": ('PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOptions',),
        "QAbstractPrintDialog.setFromTo": ('int', 'int'),
        "QAbstractPrintDialog.setMinMax": ('int', 'int'),
        "QAbstractPrintDialog.setOptionTabs": ('list',),
        "QAbstractPrintDialog.setPrintRange": ('PySide2.QtPrintSupport.QAbstractPrintDialog.PrintRange',),
        "QAbstractPrintDialog.toPage": (),

    # class PySide2.QtPrintSupport.QPageSetupDialog:
        "QPageSetupDialog.__init__": [('PySide2.QtPrintSupport.QPrinter', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
        "QPageSetupDialog.done": ('int',),
        "QPageSetupDialog.exec_": (),
        "QPageSetupDialog.open": [(), ('PySide2.QtCore.QObject', 'str')],
        "QPageSetupDialog.printer": (),

    # class PySide2.QtPrintSupport.QPrintDialog:
        "QPrintDialog.__init__": [('PySide2.QtPrintSupport.QPrinter', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
        "QPrintDialog.accept": (),
        "QPrintDialog.done": ('int',),
        "QPrintDialog.exec_": (),
        "QPrintDialog.open": [(), ('PySide2.QtCore.QObject', 'str')],
        "QPrintDialog.options": (),
        "QPrintDialog.setOption": ('PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption', 'bool'),
        "QPrintDialog.setOptions": ('PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOptions',),
        "QPrintDialog.setVisible": ('bool',),
        "QPrintDialog.testOption": ('PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption',),

    # class PySide2.QtPrintSupport.QPrintEngine:
        "QPrintEngine.__init__": (),
        "QPrintEngine.abort": (),
        "QPrintEngine.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
        "QPrintEngine.newPage": (),
        "QPrintEngine.printerState": (),
        "QPrintEngine.property": ('PySide2.QtPrintSupport.QPrintEngine.PrintEnginePropertyKey',),
        "QPrintEngine.setProperty": ('PySide2.QtPrintSupport.QPrintEngine.PrintEnginePropertyKey', 'typing.Any'),

    # class PySide2.QtPrintSupport.QPrintPreviewDialog:
        "QPrintPreviewDialog.__init__": [('PySide2.QtPrintSupport.QPrinter', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags')],
        "QPrintPreviewDialog.done": ('int',),
        "QPrintPreviewDialog.open": [(), ('PySide2.QtCore.QObject', 'str')],
        "QPrintPreviewDialog.printer": (),
        "QPrintPreviewDialog.setVisible": ('bool',),

    # class PySide2.QtPrintSupport.QPrintPreviewWidget:
        "QPrintPreviewWidget.__init__": [('PySide2.QtPrintSupport.QPrinter', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags')],
        "QPrintPreviewWidget.currentPage": (),
        "QPrintPreviewWidget.fitInView": (),
        "QPrintPreviewWidget.fitToWidth": (),
        "QPrintPreviewWidget.orientation": (),
        "QPrintPreviewWidget.pageCount": (),
        "QPrintPreviewWidget.print_": (),
        "QPrintPreviewWidget.setAllPagesViewMode": (),
        "QPrintPreviewWidget.setCurrentPage": ('int',),
        "QPrintPreviewWidget.setFacingPagesViewMode": (),
        "QPrintPreviewWidget.setLandscapeOrientation": (),
        "QPrintPreviewWidget.setOrientation": ('PySide2.QtPrintSupport.QPrinter.Orientation',),
        "QPrintPreviewWidget.setPortraitOrientation": (),
        "QPrintPreviewWidget.setSinglePageViewMode": (),
        "QPrintPreviewWidget.setViewMode": ('PySide2.QtPrintSupport.QPrintPreviewWidget.ViewMode',),
        "QPrintPreviewWidget.setVisible": ('bool',),
        "QPrintPreviewWidget.setZoomFactor": ('float',),
        "QPrintPreviewWidget.setZoomMode": ('PySide2.QtPrintSupport.QPrintPreviewWidget.ZoomMode',),
        "QPrintPreviewWidget.updatePreview": (),
        "QPrintPreviewWidget.viewMode": (),
        "QPrintPreviewWidget.zoomFactor": (),
        "QPrintPreviewWidget.zoomIn": ('float',),
        "QPrintPreviewWidget.zoomMode": (),
        "QPrintPreviewWidget.zoomOut": ('float',),

    # class PySide2.QtPrintSupport.QPrinter:
        "QPrinter.__init__": [('PySide2.QtPrintSupport.QPrinter.PrinterMode',), ('PySide2.QtPrintSupport.QPrinterInfo', 'PySide2.QtPrintSupport.QPrinter.PrinterMode')],
        "QPrinter.abort": (),
        "QPrinter.actualNumCopies": (),
        "QPrinter.collateCopies": (),
        "QPrinter.colorMode": (),
        "QPrinter.copyCount": (),
        "QPrinter.creator": (),
        "QPrinter.devType": (),
        "QPrinter.docName": (),
        "QPrinter.doubleSidedPrinting": (),
        "QPrinter.duplex": (),
        "QPrinter.fontEmbeddingEnabled": (),
        "QPrinter.fromPage": (),
        "QPrinter.fullPage": (),
        "QPrinter.getPageMargins": ('float', 'float', 'float', 'float', 'PySide2.QtPrintSupport.QPrinter.Unit'),
        "QPrinter.isValid": (),
        "QPrinter.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
        "QPrinter.newPage": (),
        "QPrinter.numCopies": (),
        "QPrinter.orientation": (),
        "QPrinter.outputFileName": (),
        "QPrinter.outputFormat": (),
        "QPrinter.pageOrder": (),
        "QPrinter.pageRect": [(), ('PySide2.QtPrintSupport.QPrinter.Unit',)],
        "QPrinter.pageSize": (),
        "QPrinter.paintEngine": (),
        "QPrinter.paperName": (),
        "QPrinter.paperRect": [(), ('PySide2.QtPrintSupport.QPrinter.Unit',)],
        "QPrinter.paperSize": [(), ('PySide2.QtPrintSupport.QPrinter.Unit',)],
        "QPrinter.paperSource": (),
        "QPrinter.pdfVersion": (),
        "QPrinter.printEngine": (),
        "QPrinter.printProgram": (),
        "QPrinter.printRange": (),
        "QPrinter.printerName": (),
        "QPrinter.printerState": (),
        "QPrinter.resolution": (),
        "QPrinter.setCollateCopies": ('bool',),
        "QPrinter.setColorMode": ('PySide2.QtPrintSupport.QPrinter.ColorMode',),
        "QPrinter.setCopyCount": ('int',),
        "QPrinter.setCreator": ('str',),
        "QPrinter.setDocName": ('str',),
        "QPrinter.setDoubleSidedPrinting": ('bool',),
        "QPrinter.setDuplex": ('PySide2.QtPrintSupport.QPrinter.DuplexMode',),
        "QPrinter.setEngines": ('PySide2.QtPrintSupport.QPrintEngine', 'PySide2.QtGui.QPaintEngine'),
        "QPrinter.setFontEmbeddingEnabled": ('bool',),
        "QPrinter.setFromTo": ('int', 'int'),
        "QPrinter.setFullPage": ('bool',),
        "QPrinter.setMargins": ('PySide2.QtGui.QPagedPaintDevice.Margins',),
        "QPrinter.setNumCopies": ('int',),
        "QPrinter.setOrientation": ('PySide2.QtPrintSupport.QPrinter.Orientation',),
        "QPrinter.setOutputFileName": ('str',),
        "QPrinter.setOutputFormat": ('PySide2.QtPrintSupport.QPrinter.OutputFormat',),
        "QPrinter.setPageMargins": [('PySide2.QtCore.QMarginsF',), ('float', 'float', 'float', 'float', 'PySide2.QtPrintSupport.QPrinter.Unit')],
        "QPrinter.setPageOrder": ('PySide2.QtPrintSupport.QPrinter.PageOrder',),
        "QPrinter.setPageSize": ('PySide2.QtGui.QPagedPaintDevice.PageSize',),
        "QPrinter.setPageSizeMM": ('PySide2.QtCore.QSizeF',),
        "QPrinter.setPaperName": ('str',),
        "QPrinter.setPaperSize": [('PySide2.QtCore.QSizeF', 'PySide2.QtPrintSupport.QPrinter.Unit'), ('PySide2.QtGui.QPagedPaintDevice.PageSize',)],
        "QPrinter.setPaperSource": ('PySide2.QtPrintSupport.QPrinter.PaperSource',),
        "QPrinter.setPdfVersion": ('PySide2.QtGui.QPagedPaintDevice.PdfVersion',),
        "QPrinter.setPrintProgram": ('str',),
        "QPrinter.setPrintRange": ('PySide2.QtPrintSupport.QPrinter.PrintRange',),
        "QPrinter.setPrinterName": ('str',),
        "QPrinter.setResolution": ('int',),
        "QPrinter.setWinPageSize": ('int',),
        "QPrinter.supportedResolutions": (),
        "QPrinter.supportsMultipleCopies": (),
        "QPrinter.toPage": (),
        "QPrinter.winPageSize": (),

    # class PySide2.QtPrintSupport.QPrinterInfo:
        "QPrinterInfo.__init__": [(), ('PySide2.QtPrintSupport.QPrinter',), ('PySide2.QtPrintSupport.QPrinterInfo',)],
        "QPrinterInfo.__copy__": (),
        "QPrinterInfo.availablePrinterNames": (),
        "QPrinterInfo.availablePrinters": (),
        "QPrinterInfo.defaultDuplexMode": (),
        "QPrinterInfo.defaultPageSize": (),
        "QPrinterInfo.defaultPrinter": (),
        "QPrinterInfo.defaultPrinterName": (),
        "QPrinterInfo.description": (),
        "QPrinterInfo.isDefault": (),
        "QPrinterInfo.isNull": (),
        "QPrinterInfo.isRemote": (),
        "QPrinterInfo.location": (),
        "QPrinterInfo.makeAndModel": (),
        "QPrinterInfo.maximumPhysicalPageSize": (),
        "QPrinterInfo.minimumPhysicalPageSize": (),
        "QPrinterInfo.printerInfo": ('str',),
        "QPrinterInfo.printerName": (),
        "QPrinterInfo.state": (),
        "QPrinterInfo.supportedDuplexModes": (),
        "QPrinterInfo.supportedPageSizes": (),
        "QPrinterInfo.supportedPaperSizes": (),
        "QPrinterInfo.supportedResolutions": (),
        "QPrinterInfo.supportedSizesWithNames": (),
        "QPrinterInfo.supportsCustomPageSizes": (),
    })

# Module PySide2.QtSql
if "PySide2.QtSql" in sys.modules:
    dict.update({

    # class PySide2.QtSql.QSql:

    # class PySide2.QtSql.QSqlDatabase:
        "QSqlDatabase.__init__": [(), ('PySide2.QtSql.QSqlDatabase',), ('PySide2.QtSql.QSqlDriver',), ('str',)],
        "QSqlDatabase.__copy__": (),
        "QSqlDatabase.addDatabase": [('PySide2.QtSql.QSqlDriver', 'str'), ('str', 'str')],
        "QSqlDatabase.cloneDatabase": ('PySide2.QtSql.QSqlDatabase', 'str'),
        "QSqlDatabase.close": (),
        "QSqlDatabase.commit": (),
        "QSqlDatabase.connectOptions": (),
        "QSqlDatabase.connectionName": (),
        "QSqlDatabase.connectionNames": (),
        "QSqlDatabase.contains": ('str',),
        "QSqlDatabase.database": ('str', 'bool'),
        "QSqlDatabase.databaseName": (),
        "QSqlDatabase.driver": (),
        "QSqlDatabase.driverName": (),
        "QSqlDatabase.drivers": (),
        "QSqlDatabase.exec_": ('str',),
        "QSqlDatabase.hostName": (),
        "QSqlDatabase.isDriverAvailable": ('str',),
        "QSqlDatabase.isOpen": (),
        "QSqlDatabase.isOpenError": (),
        "QSqlDatabase.isValid": (),
        "QSqlDatabase.lastError": (),
        "QSqlDatabase.numericalPrecisionPolicy": (),
        "QSqlDatabase.open": [(), ('str', 'str')],
        "QSqlDatabase.password": (),
        "QSqlDatabase.port": (),
        "QSqlDatabase.primaryIndex": ('str',),
        "QSqlDatabase.record": ('str',),
        "QSqlDatabase.registerSqlDriver": ('str', 'PySide2.QtSql.QSqlDriverCreatorBase'),
        "QSqlDatabase.removeDatabase": ('str',),
        "QSqlDatabase.rollback": (),
        "QSqlDatabase.setConnectOptions": ('str',),
        "QSqlDatabase.setDatabaseName": ('str',),
        "QSqlDatabase.setHostName": ('str',),
        "QSqlDatabase.setNumericalPrecisionPolicy": ('PySide2.QtSql.QSql.NumericalPrecisionPolicy',),
        "QSqlDatabase.setPassword": ('str',),
        "QSqlDatabase.setPort": ('int',),
        "QSqlDatabase.setUserName": ('str',),
        "QSqlDatabase.tables": ('PySide2.QtSql.QSql.TableType',),
        "QSqlDatabase.transaction": (),
        "QSqlDatabase.userName": (),

    # class PySide2.QtSql.QSqlDriver:
        "QSqlDriver.__init__": ('PySide2.QtCore.QObject',),
        "QSqlDriver.beginTransaction": (),
        "QSqlDriver.cancelQuery": (),
        "QSqlDriver.close": (),
        "QSqlDriver.commitTransaction": (),
        "QSqlDriver.createResult": (),
        "QSqlDriver.dbmsType": (),
        "QSqlDriver.escapeIdentifier": ('str', 'PySide2.QtSql.QSqlDriver.IdentifierType'),
        "QSqlDriver.formatValue": ('PySide2.QtSql.QSqlField', 'bool'),
        "QSqlDriver.hasFeature": ('PySide2.QtSql.QSqlDriver.DriverFeature',),
        "QSqlDriver.isIdentifierEscaped": ('str', 'PySide2.QtSql.QSqlDriver.IdentifierType'),
        "QSqlDriver.isOpen": (),
        "QSqlDriver.isOpenError": (),
        "QSqlDriver.lastError": (),
        "QSqlDriver.numericalPrecisionPolicy": (),
        "QSqlDriver.open": ('str', 'str', 'str', 'str', 'int', 'str'),
        "QSqlDriver.primaryIndex": ('str',),
        "QSqlDriver.record": ('str',),
        "QSqlDriver.rollbackTransaction": (),
        "QSqlDriver.setLastError": ('PySide2.QtSql.QSqlError',),
        "QSqlDriver.setNumericalPrecisionPolicy": ('PySide2.QtSql.QSql.NumericalPrecisionPolicy',),
        "QSqlDriver.setOpen": ('bool',),
        "QSqlDriver.setOpenError": ('bool',),
        "QSqlDriver.sqlStatement": ('PySide2.QtSql.QSqlDriver.StatementType', 'str', 'PySide2.QtSql.QSqlRecord', 'bool'),
        "QSqlDriver.stripDelimiters": ('str', 'PySide2.QtSql.QSqlDriver.IdentifierType'),
        "QSqlDriver.subscribeToNotification": ('str',),
        "QSqlDriver.subscribedToNotifications": (),
        "QSqlDriver.tables": ('PySide2.QtSql.QSql.TableType',),
        "QSqlDriver.unsubscribeFromNotification": ('str',),

    # class PySide2.QtSql.QSqlDriverCreatorBase:
        "QSqlDriverCreatorBase.__init__": (),
        "QSqlDriverCreatorBase.createObject": (),

    # class PySide2.QtSql.QSqlError:
        "QSqlError.__init__": [('PySide2.QtSql.QSqlError',), ('str', 'str', 'PySide2.QtSql.QSqlError.ErrorType', 'int'), ('str', 'str', 'PySide2.QtSql.QSqlError.ErrorType', 'str')],
        "QSqlError.__copy__": (),
        "QSqlError.databaseText": (),
        "QSqlError.driverText": (),
        "QSqlError.isValid": (),
        "QSqlError.nativeErrorCode": (),
        "QSqlError.number": (),
        "QSqlError.setDatabaseText": ('str',),
        "QSqlError.setDriverText": ('str',),
        "QSqlError.setNumber": ('int',),
        "QSqlError.setType": ('PySide2.QtSql.QSqlError.ErrorType',),
        "QSqlError.swap": ('PySide2.QtSql.QSqlError',),
        "QSqlError.text": (),
        "QSqlError.type": (),

    # class PySide2.QtSql.QSqlField:
        "QSqlField.__init__": [('PySide2.QtSql.QSqlField',), ('str', 'type'), ('str', 'type', 'str')],
        "QSqlField.__copy__": (),
        "QSqlField.clear": (),
        "QSqlField.defaultValue": (),
        "QSqlField.isAutoValue": (),
        "QSqlField.isGenerated": (),
        "QSqlField.isNull": (),
        "QSqlField.isReadOnly": (),
        "QSqlField.isValid": (),
        "QSqlField.length": (),
        "QSqlField.name": (),
        "QSqlField.precision": (),
        "QSqlField.requiredStatus": (),
        "QSqlField.setAutoValue": ('bool',),
        "QSqlField.setDefaultValue": ('typing.Any',),
        "QSqlField.setGenerated": ('bool',),
        "QSqlField.setLength": ('int',),
        "QSqlField.setName": ('str',),
        "QSqlField.setPrecision": ('int',),
        "QSqlField.setReadOnly": ('bool',),
        "QSqlField.setRequired": ('bool',),
        "QSqlField.setRequiredStatus": ('PySide2.QtSql.QSqlField.RequiredStatus',),
        "QSqlField.setSqlType": ('int',),
        "QSqlField.setTableName": ('str',),
        "QSqlField.setType": ('type',),
        "QSqlField.setValue": ('typing.Any',),
        "QSqlField.tableName": (),
        "QSqlField.type": (),
        "QSqlField.typeID": (),
        "QSqlField.value": (),

    # class PySide2.QtSql.QSqlIndex:
        "QSqlIndex.__init__": [('PySide2.QtSql.QSqlIndex',), ('str', 'str')],
        "QSqlIndex.__copy__": (),
        "QSqlIndex.append": [('PySide2.QtSql.QSqlField',), ('PySide2.QtSql.QSqlField', 'bool')],
        "QSqlIndex.cursorName": (),
        "QSqlIndex.isDescending": ('int',),
        "QSqlIndex.name": (),
        "QSqlIndex.setCursorName": ('str',),
        "QSqlIndex.setDescending": ('int', 'bool'),
        "QSqlIndex.setName": ('str',),

    # class PySide2.QtSql.QSqlQuery:
        "QSqlQuery.__init__": [('PySide2.QtSql.QSqlDatabase',), ('PySide2.QtSql.QSqlQuery',), ('PySide2.QtSql.QSqlResult',), ('str', 'PySide2.QtSql.QSqlDatabase')],
        "QSqlQuery.__copy__": (),
        "QSqlQuery.addBindValue": ('typing.Any', 'PySide2.QtSql.QSql.ParamType'),
        "QSqlQuery.at": (),
        "QSqlQuery.bindValue": [('int', 'typing.Any', 'PySide2.QtSql.QSql.ParamType'), ('str', 'typing.Any', 'PySide2.QtSql.QSql.ParamType')],
        "QSqlQuery.boundValue": [('int',), ('str',)],
        "QSqlQuery.boundValues": (),
        "QSqlQuery.clear": (),
        "QSqlQuery.driver": (),
        "QSqlQuery.execBatch": ('PySide2.QtSql.QSqlQuery.BatchExecutionMode',),
        "QSqlQuery.exec_": [(), ('str',)],
        "QSqlQuery.executedQuery": (),
        "QSqlQuery.finish": (),
        "QSqlQuery.first": (),
        "QSqlQuery.isActive": (),
        "QSqlQuery.isForwardOnly": (),
        "QSqlQuery.isNull": [('int',), ('str',)],
        "QSqlQuery.isSelect": (),
        "QSqlQuery.isValid": (),
        "QSqlQuery.last": (),
        "QSqlQuery.lastError": (),
        "QSqlQuery.lastInsertId": (),
        "QSqlQuery.lastQuery": (),
        "QSqlQuery.nextResult": (),
        "QSqlQuery.numRowsAffected": (),
        "QSqlQuery.numericalPrecisionPolicy": (),
        "QSqlQuery.prepare": ('str',),
        "QSqlQuery.previous": (),
        "QSqlQuery.record": (),
        "QSqlQuery.result": (),
        "QSqlQuery.seek": ('int', 'bool'),
        "QSqlQuery.setForwardOnly": ('bool',),
        "QSqlQuery.setNumericalPrecisionPolicy": ('PySide2.QtSql.QSql.NumericalPrecisionPolicy',),
        "QSqlQuery.size": (),
        "QSqlQuery.value": [('int',), ('str',)],

    # class PySide2.QtSql.QSqlQueryModel:
        "QSqlQueryModel.__init__": ('PySide2.QtCore.QObject',),
        "QSqlQueryModel.beginInsertColumns": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QSqlQueryModel.beginInsertRows": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QSqlQueryModel.beginRemoveColumns": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QSqlQueryModel.beginRemoveRows": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
        "QSqlQueryModel.beginResetModel": (),
        "QSqlQueryModel.canFetchMore": ('PySide2.QtCore.QModelIndex',),
        "QSqlQueryModel.clear": (),
        "QSqlQueryModel.columnCount": ('PySide2.QtCore.QModelIndex',),
        "QSqlQueryModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
        "QSqlQueryModel.endInsertColumns": (),
        "QSqlQueryModel.endInsertRows": (),
        "QSqlQueryModel.endRemoveColumns": (),
        "QSqlQueryModel.endRemoveRows": (),
        "QSqlQueryModel.endResetModel": (),
        "QSqlQueryModel.fetchMore": ('PySide2.QtCore.QModelIndex',),
        "QSqlQueryModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
        "QSqlQueryModel.indexInQuery": ('PySide2.QtCore.QModelIndex',),
        "QSqlQueryModel.insertColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QSqlQueryModel.lastError": (),
        "QSqlQueryModel.query": (),
        "QSqlQueryModel.queryChange": (),
        "QSqlQueryModel.record": [(), ('int',)],
        "QSqlQueryModel.removeColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QSqlQueryModel.roleNames": (),
        "QSqlQueryModel.rowCount": ('PySide2.QtCore.QModelIndex',),
        "QSqlQueryModel.setHeaderData": ('int', 'PySide2.QtCore.Qt.Orientation', 'typing.Any', 'int'),
        "QSqlQueryModel.setLastError": ('PySide2.QtSql.QSqlError',),
        "QSqlQueryModel.setQuery": [('PySide2.QtSql.QSqlQuery',), ('str', 'PySide2.QtSql.QSqlDatabase')],

    # class PySide2.QtSql.QSqlRecord:
        "QSqlRecord.__init__": [(), ('PySide2.QtSql.QSqlRecord',)],
        "QSqlRecord.__copy__": (),
        "QSqlRecord.append": ('PySide2.QtSql.QSqlField',),
        "QSqlRecord.clear": (),
        "QSqlRecord.clearValues": (),
        "QSqlRecord.contains": ('str',),
        "QSqlRecord.count": (),
        "QSqlRecord.field": [('int',), ('str',)],
        "QSqlRecord.fieldName": ('int',),
        "QSqlRecord.indexOf": ('str',),
        "QSqlRecord.insert": ('int', 'PySide2.QtSql.QSqlField'),
        "QSqlRecord.isEmpty": (),
        "QSqlRecord.isGenerated": [('int',), ('str',)],
        "QSqlRecord.isNull": [('int',), ('str',)],
        "QSqlRecord.keyValues": ('PySide2.QtSql.QSqlRecord',),
        "QSqlRecord.remove": ('int',),
        "QSqlRecord.replace": ('int', 'PySide2.QtSql.QSqlField'),
        "QSqlRecord.setGenerated": [('int', 'bool'), ('str', 'bool')],
        "QSqlRecord.setNull": [('int',), ('str',)],
        "QSqlRecord.setValue": [('int', 'typing.Any'), ('str', 'typing.Any')],
        "QSqlRecord.value": [('int',), ('str',)],

    # class PySide2.QtSql.QSqlRelation:
        "QSqlRelation.__init__": [(), ('PySide2.QtSql.QSqlRelation',), ('str', 'str', 'str')],
        "QSqlRelation.__copy__": (),
        "QSqlRelation.displayColumn": (),
        "QSqlRelation.indexColumn": (),
        "QSqlRelation.isValid": (),
        "QSqlRelation.swap": ('PySide2.QtSql.QSqlRelation',),
        "QSqlRelation.tableName": (),

    # class PySide2.QtSql.QSqlRelationalDelegate:
        "QSqlRelationalDelegate.__init__": ('PySide2.QtCore.QObject',),
        "QSqlRelationalDelegate.createEditor": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
        "QSqlRelationalDelegate.setEditorData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QModelIndex'),
        "QSqlRelationalDelegate.setModelData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QAbstractItemModel', 'PySide2.QtCore.QModelIndex'),

    # class PySide2.QtSql.QSqlRelationalTableModel:
        "QSqlRelationalTableModel.__init__": ('PySide2.QtCore.QObject', 'PySide2.QtSql.QSqlDatabase'),
        "QSqlRelationalTableModel.clear": (),
        "QSqlRelationalTableModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
        "QSqlRelationalTableModel.insertRowIntoTable": ('PySide2.QtSql.QSqlRecord',),
        "QSqlRelationalTableModel.orderByClause": (),
        "QSqlRelationalTableModel.relation": ('int',),
        "QSqlRelationalTableModel.relationModel": ('int',),
        "QSqlRelationalTableModel.removeColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QSqlRelationalTableModel.revertRow": ('int',),
        "QSqlRelationalTableModel.select": (),
        "QSqlRelationalTableModel.selectStatement": (),
        "QSqlRelationalTableModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
        "QSqlRelationalTableModel.setJoinMode": ('PySide2.QtSql.QSqlRelationalTableModel.JoinMode',),
        "QSqlRelationalTableModel.setRelation": ('int', 'PySide2.QtSql.QSqlRelation'),
        "QSqlRelationalTableModel.setTable": ('str',),
        "QSqlRelationalTableModel.updateRowInTable": ('int', 'PySide2.QtSql.QSqlRecord'),

    # class PySide2.QtSql.QSqlResult:
        "QSqlResult.__init__": ('PySide2.QtSql.QSqlDriver',),
        "QSqlResult.addBindValue": ('typing.Any', 'PySide2.QtSql.QSql.ParamType'),
        "QSqlResult.at": (),
        "QSqlResult.bindValue": [('int', 'typing.Any', 'PySide2.QtSql.QSql.ParamType'), ('str', 'typing.Any', 'PySide2.QtSql.QSql.ParamType')],
        "QSqlResult.bindValueType": [('int',), ('str',)],
        "QSqlResult.bindingSyntax": (),
        "QSqlResult.boundValue": [('int',), ('str',)],
        "QSqlResult.boundValueCount": (),
        "QSqlResult.boundValueName": ('int',),
        "QSqlResult.boundValues": (),
        "QSqlResult.clear": (),
        "QSqlResult.data": ('int',),
        "QSqlResult.detachFromResultSet": (),
        "QSqlResult.driver": (),
        "QSqlResult.execBatch": ('bool',),
        "QSqlResult.exec_": (),
        "QSqlResult.executedQuery": (),
        "QSqlResult.fetch": ('int',),
        "QSqlResult.fetchFirst": (),
        "QSqlResult.fetchLast": (),
        "QSqlResult.fetchNext": (),
        "QSqlResult.fetchPrevious": (),
        "QSqlResult.handle": (),
        "QSqlResult.hasOutValues": (),
        "QSqlResult.isActive": (),
        "QSqlResult.isForwardOnly": (),
        "QSqlResult.isNull": ('int',),
        "QSqlResult.isSelect": (),
        "QSqlResult.isValid": (),
        "QSqlResult.lastError": (),
        "QSqlResult.lastInsertId": (),
        "QSqlResult.lastQuery": (),
        "QSqlResult.nextResult": (),
        "QSqlResult.numRowsAffected": (),
        "QSqlResult.numericalPrecisionPolicy": (),
        "QSqlResult.prepare": ('str',),
        "QSqlResult.record": (),
        "QSqlResult.reset": ('str',),
        "QSqlResult.resetBindCount": (),
        "QSqlResult.savePrepare": ('str',),
        "QSqlResult.setActive": ('bool',),
        "QSqlResult.setAt": ('int',),
        "QSqlResult.setForwardOnly": ('bool',),
        "QSqlResult.setLastError": ('PySide2.QtSql.QSqlError',),
        "QSqlResult.setNumericalPrecisionPolicy": ('PySide2.QtSql.QSql.NumericalPrecisionPolicy',),
        "QSqlResult.setQuery": ('str',),
        "QSqlResult.setSelect": ('bool',),
        "QSqlResult.size": (),

    # class PySide2.QtSql.QSqlTableModel:
        "QSqlTableModel.__init__": ('PySide2.QtCore.QObject', 'PySide2.QtSql.QSqlDatabase'),
        "QSqlTableModel.clear": (),
        "QSqlTableModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
        "QSqlTableModel.database": (),
        "QSqlTableModel.deleteRowFromTable": ('int',),
        "QSqlTableModel.editStrategy": (),
        "QSqlTableModel.fieldIndex": ('str',),
        "QSqlTableModel.filter": (),
        "QSqlTableModel.flags": ('PySide2.QtCore.QModelIndex',),
        "QSqlTableModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
        "QSqlTableModel.indexInQuery": ('PySide2.QtCore.QModelIndex',),
        "QSqlTableModel.insertRecord": ('int', 'PySide2.QtSql.QSqlRecord'),
        "QSqlTableModel.insertRowIntoTable": ('PySide2.QtSql.QSqlRecord',),
        "QSqlTableModel.insertRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QSqlTableModel.isDirty": [(), ('PySide2.QtCore.QModelIndex',)],
        "QSqlTableModel.orderByClause": (),
        "QSqlTableModel.primaryKey": (),
        "QSqlTableModel.primaryValues": ('int',),
        "QSqlTableModel.record": [(), ('int',)],
        "QSqlTableModel.removeColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QSqlTableModel.removeRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QSqlTableModel.revert": (),
        "QSqlTableModel.revertAll": (),
        "QSqlTableModel.revertRow": ('int',),
        "QSqlTableModel.rowCount": ('PySide2.QtCore.QModelIndex',),
        "QSqlTableModel.select": (),
        "QSqlTableModel.selectRow": ('int',),
        "QSqlTableModel.selectStatement": (),
        "QSqlTableModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
        "QSqlTableModel.setEditStrategy": ('PySide2.QtSql.QSqlTableModel.EditStrategy',),
        "QSqlTableModel.setFilter": ('str',),
        "QSqlTableModel.setPrimaryKey": ('PySide2.QtSql.QSqlIndex',),
        "QSqlTableModel.setQuery": ('PySide2.QtSql.QSqlQuery',),
        "QSqlTableModel.setRecord": ('int', 'PySide2.QtSql.QSqlRecord'),
        "QSqlTableModel.setSort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
        "QSqlTableModel.setTable": ('str',),
        "QSqlTableModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
        "QSqlTableModel.submit": (),
        "QSqlTableModel.submitAll": (),
        "QSqlTableModel.tableName": (),
        "QSqlTableModel.updateRowInTable": ('int', 'PySide2.QtSql.QSqlRecord'),
    })

# Module PySide2.QtNetwork
if "PySide2.QtNetwork" in sys.modules:
    dict.update({

    # class PySide2.QtNetwork.QAbstractNetworkCache:
        "QAbstractNetworkCache.__init__": ('PySide2.QtCore.QObject',),
        "QAbstractNetworkCache.cacheSize": (),
        "QAbstractNetworkCache.clear": (),
        "QAbstractNetworkCache.data": ('PySide2.QtCore.QUrl',),
        "QAbstractNetworkCache.insert": ('PySide2.QtCore.QIODevice',),
        "QAbstractNetworkCache.metaData": ('PySide2.QtCore.QUrl',),
        "QAbstractNetworkCache.prepare": ('PySide2.QtNetwork.QNetworkCacheMetaData',),
        "QAbstractNetworkCache.remove": ('PySide2.QtCore.QUrl',),
        "QAbstractNetworkCache.updateMetaData": ('PySide2.QtNetwork.QNetworkCacheMetaData',),

    # class PySide2.QtNetwork.QAbstractSocket:
        "QAbstractSocket.__init__": ('PySide2.QtNetwork.QAbstractSocket.SocketType', 'PySide2.QtCore.QObject'),
        "QAbstractSocket.abort": (),
        "QAbstractSocket.atEnd": (),
        "QAbstractSocket.bind": [('PySide2.QtNetwork.QHostAddress', 'int', 'PySide2.QtNetwork.QAbstractSocket.BindMode'), ('int', 'PySide2.QtNetwork.QAbstractSocket.BindMode')],
        "QAbstractSocket.bytesAvailable": (),
        "QAbstractSocket.bytesToWrite": (),
        "QAbstractSocket.canReadLine": (),
        "QAbstractSocket.close": (),
        "QAbstractSocket.connectToHost": [('PySide2.QtNetwork.QHostAddress', 'int', 'PySide2.QtCore.QIODevice.OpenMode'), ('str', 'int', 'PySide2.QtCore.QIODevice.OpenMode', 'PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol')],
        "QAbstractSocket.disconnectFromHost": (),
        "QAbstractSocket.error": (),
        "QAbstractSocket.flush": (),
        "QAbstractSocket.isSequential": (),
        "QAbstractSocket.isValid": (),
        "QAbstractSocket.localAddress": (),
        "QAbstractSocket.localPort": (),
        "QAbstractSocket.pauseMode": (),
        "QAbstractSocket.peerAddress": (),
        "QAbstractSocket.peerName": (),
        "QAbstractSocket.peerPort": (),
        "QAbstractSocket.proxy": (),
        "QAbstractSocket.readBufferSize": (),
        "QAbstractSocket.readData": ('str', 'int'),
        "QAbstractSocket.readLineData": ('str', 'int'),
        "QAbstractSocket.resume": (),
        "QAbstractSocket.setLocalAddress": ('PySide2.QtNetwork.QHostAddress',),
        "QAbstractSocket.setLocalPort": ('int',),
        "QAbstractSocket.setPauseMode": ('PySide2.QtNetwork.QAbstractSocket.PauseModes',),
        "QAbstractSocket.setPeerAddress": ('PySide2.QtNetwork.QHostAddress',),
        "QAbstractSocket.setPeerName": ('str',),
        "QAbstractSocket.setPeerPort": ('int',),
        "QAbstractSocket.setProxy": ('PySide2.QtNetwork.QNetworkProxy',),
        "QAbstractSocket.setReadBufferSize": ('int',),
        "QAbstractSocket.setSocketDescriptor": ('int', 'PySide2.QtNetwork.QAbstractSocket.SocketState', 'PySide2.QtCore.QIODevice.OpenMode'),
        "QAbstractSocket.setSocketError": ('PySide2.QtNetwork.QAbstractSocket.SocketError',),
        "QAbstractSocket.setSocketOption": ('PySide2.QtNetwork.QAbstractSocket.SocketOption', 'typing.Any'),
        "QAbstractSocket.setSocketState": ('PySide2.QtNetwork.QAbstractSocket.SocketState',),
        "QAbstractSocket.socketDescriptor": (),
        "QAbstractSocket.socketOption": ('PySide2.QtNetwork.QAbstractSocket.SocketOption',),
        "QAbstractSocket.socketType": (),
        "QAbstractSocket.state": (),
        "QAbstractSocket.waitForBytesWritten": ('int',),
        "QAbstractSocket.waitForConnected": ('int',),
        "QAbstractSocket.waitForDisconnected": ('int',),
        "QAbstractSocket.waitForReadyRead": ('int',),
        "QAbstractSocket.writeData": ('str', 'int'),

    # class PySide2.QtNetwork.QAuthenticator:
        "QAuthenticator.__init__": [(), ('PySide2.QtNetwork.QAuthenticator',)],
        "QAuthenticator.__copy__": (),
        "QAuthenticator.isNull": (),
        "QAuthenticator.option": ('str',),
        "QAuthenticator.options": (),
        "QAuthenticator.password": (),
        "QAuthenticator.realm": (),
        "QAuthenticator.setOption": ('str', 'typing.Any'),
        "QAuthenticator.setPassword": ('str',),
        "QAuthenticator.setRealm": ('str',),
        "QAuthenticator.setUser": ('str',),
        "QAuthenticator.user": (),

    # class PySide2.QtNetwork.QDnsDomainNameRecord:
        "QDnsDomainNameRecord.__init__": [(), ('PySide2.QtNetwork.QDnsDomainNameRecord',)],
        "QDnsDomainNameRecord.__copy__": (),
        "QDnsDomainNameRecord.name": (),
        "QDnsDomainNameRecord.swap": ('PySide2.QtNetwork.QDnsDomainNameRecord',),
        "QDnsDomainNameRecord.timeToLive": (),
        "QDnsDomainNameRecord.value": (),

    # class PySide2.QtNetwork.QDnsHostAddressRecord:
        "QDnsHostAddressRecord.__init__": [(), ('PySide2.QtNetwork.QDnsHostAddressRecord',)],
        "QDnsHostAddressRecord.__copy__": (),
        "QDnsHostAddressRecord.name": (),
        "QDnsHostAddressRecord.swap": ('PySide2.QtNetwork.QDnsHostAddressRecord',),
        "QDnsHostAddressRecord.timeToLive": (),
        "QDnsHostAddressRecord.value": (),

    # class PySide2.QtNetwork.QDnsLookup:
        "QDnsLookup.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtNetwork.QDnsLookup.Type', 'str', 'PySide2.QtCore.QObject'), ('PySide2.QtNetwork.QDnsLookup.Type', 'str', 'PySide2.QtNetwork.QHostAddress', 'PySide2.QtCore.QObject')],
        "QDnsLookup.abort": (),
        "QDnsLookup.canonicalNameRecords": (),
        "QDnsLookup.error": (),
        "QDnsLookup.errorString": (),
        "QDnsLookup.hostAddressRecords": (),
        "QDnsLookup.isFinished": (),
        "QDnsLookup.lookup": (),
        "QDnsLookup.mailExchangeRecords": (),
        "QDnsLookup.name": (),
        "QDnsLookup.nameServerRecords": (),
        "QDnsLookup.nameserver": (),
        "QDnsLookup.pointerRecords": (),
        "QDnsLookup.serviceRecords": (),
        "QDnsLookup.setName": ('str',),
        "QDnsLookup.setNameserver": ('PySide2.QtNetwork.QHostAddress',),
        "QDnsLookup.setType": ('PySide2.QtNetwork.QDnsLookup.Type',),
        "QDnsLookup.textRecords": (),
        "QDnsLookup.type": (),

    # class PySide2.QtNetwork.QDnsMailExchangeRecord:
        "QDnsMailExchangeRecord.__init__": [(), ('PySide2.QtNetwork.QDnsMailExchangeRecord',)],
        "QDnsMailExchangeRecord.__copy__": (),
        "QDnsMailExchangeRecord.exchange": (),
        "QDnsMailExchangeRecord.name": (),
        "QDnsMailExchangeRecord.preference": (),
        "QDnsMailExchangeRecord.swap": ('PySide2.QtNetwork.QDnsMailExchangeRecord',),
        "QDnsMailExchangeRecord.timeToLive": (),

    # class PySide2.QtNetwork.QDnsServiceRecord:
        "QDnsServiceRecord.__init__": [(), ('PySide2.QtNetwork.QDnsServiceRecord',)],
        "QDnsServiceRecord.__copy__": (),
        "QDnsServiceRecord.name": (),
        "QDnsServiceRecord.port": (),
        "QDnsServiceRecord.priority": (),
        "QDnsServiceRecord.swap": ('PySide2.QtNetwork.QDnsServiceRecord',),
        "QDnsServiceRecord.target": (),
        "QDnsServiceRecord.timeToLive": (),
        "QDnsServiceRecord.weight": (),

    # class PySide2.QtNetwork.QDnsTextRecord:
        "QDnsTextRecord.__init__": [(), ('PySide2.QtNetwork.QDnsTextRecord',)],
        "QDnsTextRecord.__copy__": (),
        "QDnsTextRecord.name": (),
        "QDnsTextRecord.swap": ('PySide2.QtNetwork.QDnsTextRecord',),
        "QDnsTextRecord.timeToLive": (),
        "QDnsTextRecord.values": (),

    # class PySide2.QtNetwork.QDtls:
        "QDtls.__init__": ('PySide2.QtNetwork.QSslSocket.SslMode', 'PySide2.QtCore.QObject'),
        "QDtls.abortHandshake": ('PySide2.QtNetwork.QUdpSocket',),
        "QDtls.decryptDatagram": ('PySide2.QtNetwork.QUdpSocket', 'PySide2.QtCore.QByteArray'),
        "QDtls.doHandshake": ('PySide2.QtNetwork.QUdpSocket', 'PySide2.QtCore.QByteArray'),
        "QDtls.dtlsConfiguration": (),
        "QDtls.dtlsError": (),
        "QDtls.dtlsErrorString": (),
        "QDtls.handleTimeout": ('PySide2.QtNetwork.QUdpSocket',),
        "QDtls.handshakeState": (),
        "QDtls.ignoreVerificationErrors": ('list',),
        "QDtls.isConnectionEncrypted": (),
        "QDtls.mtuHint": (),
        "QDtls.peerAddress": (),
        "QDtls.peerPort": (),
        "QDtls.peerVerificationErrors": (),
        "QDtls.peerVerificationName": (),
        "QDtls.resumeHandshake": ('PySide2.QtNetwork.QUdpSocket',),
        "QDtls.sessionCipher": (),
        "QDtls.sessionProtocol": (),
        "QDtls.setDtlsConfiguration": ('PySide2.QtNetwork.QSslConfiguration',),
        "QDtls.setMtuHint": ('int',),
        "QDtls.setPeer": ('PySide2.QtNetwork.QHostAddress', 'int', 'str'),
        "QDtls.setPeerVerificationName": ('str',),
        "QDtls.shutdown": ('PySide2.QtNetwork.QUdpSocket',),
        "QDtls.sslMode": (),
        "QDtls.writeDatagramEncrypted": ('PySide2.QtNetwork.QUdpSocket', 'PySide2.QtCore.QByteArray'),

    # class PySide2.QtNetwork.QHostAddress:
        "QHostAddress.__init__": [(), ('PySide2.QtNetwork.QHostAddress',), ('PySide2.QtNetwork.QHostAddress.SpecialAddress',), ('PySide2.QtNetwork.QIPv6Address',), ('int',), ('str',)],
        "QHostAddress.__copy__": (),
        "QHostAddress.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QHostAddress.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QHostAddress.clear": (),
        "QHostAddress.isBroadcast": (),
        "QHostAddress.isEqual": ('PySide2.QtNetwork.QHostAddress', 'PySide2.QtNetwork.QHostAddress.ConversionMode'),
        "QHostAddress.isGlobal": (),
        "QHostAddress.isInSubnet": [('PySide2.QtNetwork.QHostAddress', 'int'), ('typing.Tuple[typing.Any, typing.Any]',)],
        "QHostAddress.isLinkLocal": (),
        "QHostAddress.isLoopback": (),
        "QHostAddress.isMulticast": (),
        "QHostAddress.isNull": (),
        "QHostAddress.isSiteLocal": (),
        "QHostAddress.isUniqueLocalUnicast": (),
        "QHostAddress.parseSubnet": ('str',),
        "QHostAddress.protocol": (),
        "QHostAddress.scopeId": (),
        "QHostAddress.setAddress": [('PySide2.QtNetwork.QHostAddress.SpecialAddress',), ('PySide2.QtNetwork.QIPv6Address',), ('int',), ('str',)],
        "QHostAddress.setScopeId": ('str',),
        "QHostAddress.swap": ('PySide2.QtNetwork.QHostAddress',),
        "QHostAddress.toIPv4Address": [(), ('bool',)],
        "QHostAddress.toIPv6Address": (),
        "QHostAddress.toString": (),

    # class PySide2.QtNetwork.QHostInfo:
        "QHostInfo.__init__": [('PySide2.QtNetwork.QHostInfo',), ('int',)],
        "QHostInfo.__copy__": (),
        "QHostInfo.abortHostLookup": ('int',),
        "QHostInfo.addresses": (),
        "QHostInfo.error": (),
        "QHostInfo.errorString": (),
        "QHostInfo.fromName": ('str',),
        "QHostInfo.hostName": (),
        "QHostInfo.localDomainName": (),
        "QHostInfo.localHostName": (),
        "QHostInfo.lookupId": (),
        "QHostInfo.setAddresses": ('list',),
        "QHostInfo.setError": ('PySide2.QtNetwork.QHostInfo.HostInfoError',),
        "QHostInfo.setErrorString": ('str',),
        "QHostInfo.setHostName": ('str',),
        "QHostInfo.setLookupId": ('int',),
        "QHostInfo.swap": ('PySide2.QtNetwork.QHostInfo',),

    # class PySide2.QtNetwork.QHstsPolicy:
        "QHstsPolicy.__init__": [(), ('PySide2.QtCore.QDateTime', 'PySide2.QtNetwork.QHstsPolicy.PolicyFlags', 'str', 'PySide2.QtCore.QUrl.ParsingMode'), ('PySide2.QtNetwork.QHstsPolicy',)],
        "QHstsPolicy.__copy__": (),
        "QHstsPolicy.expiry": (),
        "QHstsPolicy.host": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
        "QHstsPolicy.includesSubDomains": (),
        "QHstsPolicy.isExpired": (),
        "QHstsPolicy.setExpiry": ('PySide2.QtCore.QDateTime',),
        "QHstsPolicy.setHost": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
        "QHstsPolicy.setIncludesSubDomains": ('bool',),
        "QHstsPolicy.swap": ('PySide2.QtNetwork.QHstsPolicy',),

    # class PySide2.QtNetwork.QHttpMultiPart:
        "QHttpMultiPart.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtNetwork.QHttpMultiPart.ContentType', 'PySide2.QtCore.QObject')],
        "QHttpMultiPart.append": ('PySide2.QtNetwork.QHttpPart',),
        "QHttpMultiPart.boundary": (),
        "QHttpMultiPart.setBoundary": ('PySide2.QtCore.QByteArray',),
        "QHttpMultiPart.setContentType": ('PySide2.QtNetwork.QHttpMultiPart.ContentType',),

    # class PySide2.QtNetwork.QHttpPart:
        "QHttpPart.__init__": [(), ('PySide2.QtNetwork.QHttpPart',)],
        "QHttpPart.__copy__": (),
        "QHttpPart.setBody": ('PySide2.QtCore.QByteArray',),
        "QHttpPart.setBodyDevice": ('PySide2.QtCore.QIODevice',),
        "QHttpPart.setHeader": ('PySide2.QtNetwork.QNetworkRequest.KnownHeaders', 'typing.Any'),
        "QHttpPart.setRawHeader": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray'),
        "QHttpPart.swap": ('PySide2.QtNetwork.QHttpPart',),

    # class PySide2.QtNetwork.QIPv6Address:
        "QIPv6Address.__init__": [(), ('PySide2.QtNetwork.QIPv6Address',)],
        "QIPv6Address.__copy__": (),

    # class PySide2.QtNetwork.QLocalServer:
        "QLocalServer.__init__": ('PySide2.QtCore.QObject',),
        "QLocalServer.close": (),
        "QLocalServer.errorString": (),
        "QLocalServer.fullServerName": (),
        "QLocalServer.hasPendingConnections": (),
        "QLocalServer.incomingConnection": ('int',),
        "QLocalServer.isListening": (),
        "QLocalServer.listen": [('int',), ('str',)],
        "QLocalServer.maxPendingConnections": (),
        "QLocalServer.nextPendingConnection": (),
        "QLocalServer.removeServer": ('str',),
        "QLocalServer.serverError": (),
        "QLocalServer.serverName": (),
        "QLocalServer.setMaxPendingConnections": ('int',),
        "QLocalServer.setSocketOptions": ('PySide2.QtNetwork.QLocalServer.SocketOptions',),
        "QLocalServer.socketDescriptor": (),
        "QLocalServer.socketOptions": (),
        "QLocalServer.waitForNewConnection": ('int', 'bool'),

    # class PySide2.QtNetwork.QLocalSocket:
        "QLocalSocket.__init__": ('PySide2.QtCore.QObject',),
        "QLocalSocket.abort": (),
        "QLocalSocket.bytesAvailable": (),
        "QLocalSocket.bytesToWrite": (),
        "QLocalSocket.canReadLine": (),
        "QLocalSocket.close": (),
        "QLocalSocket.connectToServer": [('PySide2.QtCore.QIODevice.OpenMode',), ('str', 'PySide2.QtCore.QIODevice.OpenMode')],
        "QLocalSocket.disconnectFromServer": (),
        "QLocalSocket.error": (),
        "QLocalSocket.flush": (),
        "QLocalSocket.fullServerName": (),
        "QLocalSocket.isSequential": (),
        "QLocalSocket.isValid": (),
        "QLocalSocket.open": ('PySide2.QtCore.QIODevice.OpenMode',),
        "QLocalSocket.readBufferSize": (),
        "QLocalSocket.readData": ('str', 'int'),
        "QLocalSocket.serverName": (),
        "QLocalSocket.setReadBufferSize": ('int',),
        "QLocalSocket.setServerName": ('str',),
        "QLocalSocket.setSocketDescriptor": ('int', 'PySide2.QtNetwork.QLocalSocket.LocalSocketState', 'PySide2.QtCore.QIODevice.OpenMode'),
        "QLocalSocket.socketDescriptor": (),
        "QLocalSocket.state": (),
        "QLocalSocket.waitForBytesWritten": ('int',),
        "QLocalSocket.waitForConnected": ('int',),
        "QLocalSocket.waitForDisconnected": ('int',),
        "QLocalSocket.waitForReadyRead": ('int',),
        "QLocalSocket.writeData": ('str', 'int'),

    # class PySide2.QtNetwork.QNetworkAccessManager:
        "QNetworkAccessManager.__init__": ('PySide2.QtCore.QObject',),
        "QNetworkAccessManager.activeConfiguration": (),
        "QNetworkAccessManager.addStrictTransportSecurityHosts": ('list',),
        "QNetworkAccessManager.cache": (),
        "QNetworkAccessManager.clearAccessCache": (),
        "QNetworkAccessManager.clearConnectionCache": (),
        "QNetworkAccessManager.configuration": (),
        "QNetworkAccessManager.connectToHost": ('str', 'int'),
        "QNetworkAccessManager.connectToHostEncrypted": ('str', 'int', 'PySide2.QtNetwork.QSslConfiguration'),
        "QNetworkAccessManager.cookieJar": (),
        "QNetworkAccessManager.createRequest": ('PySide2.QtNetwork.QNetworkAccessManager.Operation', 'PySide2.QtNetwork.QNetworkRequest', 'PySide2.QtCore.QIODevice'),
        "QNetworkAccessManager.deleteResource": ('PySide2.QtNetwork.QNetworkRequest',),
        "QNetworkAccessManager.enableStrictTransportSecurityStore": ('bool', 'str'),
        "QNetworkAccessManager.get": ('PySide2.QtNetwork.QNetworkRequest',),
        "QNetworkAccessManager.head": ('PySide2.QtNetwork.QNetworkRequest',),
        "QNetworkAccessManager.isStrictTransportSecurityEnabled": (),
        "QNetworkAccessManager.isStrictTransportSecurityStoreEnabled": (),
        "QNetworkAccessManager.networkAccessible": (),
        "QNetworkAccessManager.post": [('PySide2.QtNetwork.QNetworkRequest', 'PySide2.QtCore.QByteArray'), ('PySide2.QtNetwork.QNetworkRequest', 'PySide2.QtCore.QIODevice'), ('PySide2.QtNetwork.QNetworkRequest', 'PySide2.QtNetwork.QHttpMultiPart')],
        "QNetworkAccessManager.proxy": (),
        "QNetworkAccessManager.proxyFactory": (),
        "QNetworkAccessManager.put": [('PySide2.QtNetwork.QNetworkRequest', 'PySide2.QtCore.QByteArray'), ('PySide2.QtNetwork.QNetworkRequest', 'PySide2.QtCore.QIODevice'), ('PySide2.QtNetwork.QNetworkRequest', 'PySide2.QtNetwork.QHttpMultiPart')],
        "QNetworkAccessManager.redirectPolicy": (),
        "QNetworkAccessManager.sendCustomRequest": [('PySide2.QtNetwork.QNetworkRequest', 'PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray'), ('PySide2.QtNetwork.QNetworkRequest', 'PySide2.QtCore.QByteArray', 'PySide2.QtCore.QIODevice'), ('PySide2.QtNetwork.QNetworkRequest', 'PySide2.QtCore.QByteArray', 'PySide2.QtNetwork.QHttpMultiPart')],
        "QNetworkAccessManager.setCache": ('PySide2.QtNetwork.QAbstractNetworkCache',),
        "QNetworkAccessManager.setConfiguration": ('PySide2.QtNetwork.QNetworkConfiguration',),
        "QNetworkAccessManager.setCookieJar": ('PySide2.QtNetwork.QNetworkCookieJar',),
        "QNetworkAccessManager.setNetworkAccessible": ('PySide2.QtNetwork.QNetworkAccessManager.NetworkAccessibility',),
        "QNetworkAccessManager.setProxy": ('PySide2.QtNetwork.QNetworkProxy',),
        "QNetworkAccessManager.setProxyFactory": ('PySide2.QtNetwork.QNetworkProxyFactory',),
        "QNetworkAccessManager.setRedirectPolicy": ('PySide2.QtNetwork.QNetworkRequest.RedirectPolicy',),
        "QNetworkAccessManager.setStrictTransportSecurityEnabled": ('bool',),
        "QNetworkAccessManager.strictTransportSecurityHosts": (),
        "QNetworkAccessManager.supportedSchemes": (),
        "QNetworkAccessManager.supportedSchemesImplementation": (),

    # class PySide2.QtNetwork.QNetworkAddressEntry:
        "QNetworkAddressEntry.__init__": [(), ('PySide2.QtNetwork.QNetworkAddressEntry',)],
        "QNetworkAddressEntry.__copy__": (),
        "QNetworkAddressEntry.broadcast": (),
        "QNetworkAddressEntry.clearAddressLifetime": (),
        "QNetworkAddressEntry.dnsEligibility": (),
        "QNetworkAddressEntry.ip": (),
        "QNetworkAddressEntry.isLifetimeKnown": (),
        "QNetworkAddressEntry.isPermanent": (),
        "QNetworkAddressEntry.isTemporary": (),
        "QNetworkAddressEntry.netmask": (),
        "QNetworkAddressEntry.prefixLength": (),
        "QNetworkAddressEntry.setBroadcast": ('PySide2.QtNetwork.QHostAddress',),
        "QNetworkAddressEntry.setDnsEligibility": ('PySide2.QtNetwork.QNetworkAddressEntry.DnsEligibilityStatus',),
        "QNetworkAddressEntry.setIp": ('PySide2.QtNetwork.QHostAddress',),
        "QNetworkAddressEntry.setNetmask": ('PySide2.QtNetwork.QHostAddress',),
        "QNetworkAddressEntry.setPrefixLength": ('int',),
        "QNetworkAddressEntry.swap": ('PySide2.QtNetwork.QNetworkAddressEntry',),

    # class PySide2.QtNetwork.QNetworkCacheMetaData:
        "QNetworkCacheMetaData.__init__": [(), ('PySide2.QtNetwork.QNetworkCacheMetaData',)],
        "QNetworkCacheMetaData.__copy__": (),
        "QNetworkCacheMetaData.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QNetworkCacheMetaData.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QNetworkCacheMetaData.attributes": (),
        "QNetworkCacheMetaData.expirationDate": (),
        "QNetworkCacheMetaData.isValid": (),
        "QNetworkCacheMetaData.lastModified": (),
        "QNetworkCacheMetaData.rawHeaders": (),
        "QNetworkCacheMetaData.saveToDisk": (),
        "QNetworkCacheMetaData.setAttributes": ('dict',),
        "QNetworkCacheMetaData.setExpirationDate": ('PySide2.QtCore.QDateTime',),
        "QNetworkCacheMetaData.setLastModified": ('PySide2.QtCore.QDateTime',),
        "QNetworkCacheMetaData.setRawHeaders": ('list',),
        "QNetworkCacheMetaData.setSaveToDisk": ('bool',),
        "QNetworkCacheMetaData.setUrl": ('PySide2.QtCore.QUrl',),
        "QNetworkCacheMetaData.swap": ('PySide2.QtNetwork.QNetworkCacheMetaData',),
        "QNetworkCacheMetaData.url": (),

    # class PySide2.QtNetwork.QNetworkConfiguration:
        "QNetworkConfiguration.__init__": [(), ('PySide2.QtNetwork.QNetworkConfiguration',)],
        "QNetworkConfiguration.__copy__": (),
        "QNetworkConfiguration.bearerType": (),
        "QNetworkConfiguration.bearerTypeFamily": (),
        "QNetworkConfiguration.bearerTypeName": (),
        "QNetworkConfiguration.children": (),
        "QNetworkConfiguration.connectTimeout": (),
        "QNetworkConfiguration.identifier": (),
        "QNetworkConfiguration.isRoamingAvailable": (),
        "QNetworkConfiguration.isValid": (),
        "QNetworkConfiguration.name": (),
        "QNetworkConfiguration.purpose": (),
        "QNetworkConfiguration.setConnectTimeout": ('int',),
        "QNetworkConfiguration.state": (),
        "QNetworkConfiguration.swap": ('PySide2.QtNetwork.QNetworkConfiguration',),
        "QNetworkConfiguration.type": (),

    # class PySide2.QtNetwork.QNetworkConfigurationManager:
        "QNetworkConfigurationManager.__init__": ('PySide2.QtCore.QObject',),
        "QNetworkConfigurationManager.allConfigurations": ('PySide2.QtNetwork.QNetworkConfiguration.StateFlags',),
        "QNetworkConfigurationManager.capabilities": (),
        "QNetworkConfigurationManager.configurationFromIdentifier": ('str',),
        "QNetworkConfigurationManager.defaultConfiguration": (),
        "QNetworkConfigurationManager.isOnline": (),
        "QNetworkConfigurationManager.updateConfigurations": (),

    # class PySide2.QtNetwork.QNetworkCookie:
        "QNetworkCookie.__init__": [('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray'), ('PySide2.QtNetwork.QNetworkCookie',)],
        "QNetworkCookie.__copy__": (),
        "QNetworkCookie.domain": (),
        "QNetworkCookie.expirationDate": (),
        "QNetworkCookie.hasSameIdentifier": ('PySide2.QtNetwork.QNetworkCookie',),
        "QNetworkCookie.isHttpOnly": (),
        "QNetworkCookie.isSecure": (),
        "QNetworkCookie.isSessionCookie": (),
        "QNetworkCookie.name": (),
        "QNetworkCookie.normalize": ('PySide2.QtCore.QUrl',),
        "QNetworkCookie.parseCookies": ('PySide2.QtCore.QByteArray',),
        "QNetworkCookie.path": (),
        "QNetworkCookie.setDomain": ('str',),
        "QNetworkCookie.setExpirationDate": ('PySide2.QtCore.QDateTime',),
        "QNetworkCookie.setHttpOnly": ('bool',),
        "QNetworkCookie.setName": ('PySide2.QtCore.QByteArray',),
        "QNetworkCookie.setPath": ('str',),
        "QNetworkCookie.setSecure": ('bool',),
        "QNetworkCookie.setValue": ('PySide2.QtCore.QByteArray',),
        "QNetworkCookie.swap": ('PySide2.QtNetwork.QNetworkCookie',),
        "QNetworkCookie.toRawForm": ('PySide2.QtNetwork.QNetworkCookie.RawForm',),
        "QNetworkCookie.value": (),

    # class PySide2.QtNetwork.QNetworkCookieJar:
        "QNetworkCookieJar.__init__": ('PySide2.QtCore.QObject',),
        "QNetworkCookieJar.allCookies": (),
        "QNetworkCookieJar.cookiesForUrl": ('PySide2.QtCore.QUrl',),
        "QNetworkCookieJar.deleteCookie": ('PySide2.QtNetwork.QNetworkCookie',),
        "QNetworkCookieJar.insertCookie": ('PySide2.QtNetwork.QNetworkCookie',),
        "QNetworkCookieJar.setAllCookies": ('list',),
        "QNetworkCookieJar.setCookiesFromUrl": ('list', 'PySide2.QtCore.QUrl'),
        "QNetworkCookieJar.updateCookie": ('PySide2.QtNetwork.QNetworkCookie',),
        "QNetworkCookieJar.validateCookie": ('PySide2.QtNetwork.QNetworkCookie', 'PySide2.QtCore.QUrl'),

    # class PySide2.QtNetwork.QNetworkDatagram:
        "QNetworkDatagram.__init__": [(), ('PySide2.QtCore.QByteArray', 'PySide2.QtNetwork.QHostAddress', 'int'), ('PySide2.QtNetwork.QNetworkDatagram',)],
        "QNetworkDatagram.__copy__": (),
        "QNetworkDatagram.clear": (),
        "QNetworkDatagram.data": (),
        "QNetworkDatagram.destinationAddress": (),
        "QNetworkDatagram.destinationPort": (),
        "QNetworkDatagram.hopLimit": (),
        "QNetworkDatagram.interfaceIndex": (),
        "QNetworkDatagram.isNull": (),
        "QNetworkDatagram.isValid": (),
        "QNetworkDatagram.makeReply": ('PySide2.QtCore.QByteArray',),
        "QNetworkDatagram.senderAddress": (),
        "QNetworkDatagram.senderPort": (),
        "QNetworkDatagram.setData": ('PySide2.QtCore.QByteArray',),
        "QNetworkDatagram.setDestination": ('PySide2.QtNetwork.QHostAddress', 'int'),
        "QNetworkDatagram.setHopLimit": ('int',),
        "QNetworkDatagram.setInterfaceIndex": ('int',),
        "QNetworkDatagram.setSender": ('PySide2.QtNetwork.QHostAddress', 'int'),
        "QNetworkDatagram.swap": ('PySide2.QtNetwork.QNetworkDatagram',),

    # class PySide2.QtNetwork.QNetworkDiskCache:
        "QNetworkDiskCache.__init__": ('PySide2.QtCore.QObject',),
        "QNetworkDiskCache.cacheDirectory": (),
        "QNetworkDiskCache.cacheSize": (),
        "QNetworkDiskCache.clear": (),
        "QNetworkDiskCache.data": ('PySide2.QtCore.QUrl',),
        "QNetworkDiskCache.expire": (),
        "QNetworkDiskCache.fileMetaData": ('str',),
        "QNetworkDiskCache.insert": ('PySide2.QtCore.QIODevice',),
        "QNetworkDiskCache.maximumCacheSize": (),
        "QNetworkDiskCache.metaData": ('PySide2.QtCore.QUrl',),
        "QNetworkDiskCache.prepare": ('PySide2.QtNetwork.QNetworkCacheMetaData',),
        "QNetworkDiskCache.remove": ('PySide2.QtCore.QUrl',),
        "QNetworkDiskCache.setCacheDirectory": ('str',),
        "QNetworkDiskCache.setMaximumCacheSize": ('int',),
        "QNetworkDiskCache.updateMetaData": ('PySide2.QtNetwork.QNetworkCacheMetaData',),

    # class PySide2.QtNetwork.QNetworkInterface:
        "QNetworkInterface.__init__": [(), ('PySide2.QtNetwork.QNetworkInterface',)],
        "QNetworkInterface.__copy__": (),
        "QNetworkInterface.addressEntries": (),
        "QNetworkInterface.allAddresses": (),
        "QNetworkInterface.allInterfaces": (),
        "QNetworkInterface.flags": (),
        "QNetworkInterface.hardwareAddress": (),
        "QNetworkInterface.humanReadableName": (),
        "QNetworkInterface.index": (),
        "QNetworkInterface.interfaceFromIndex": ('int',),
        "QNetworkInterface.interfaceFromName": ('str',),
        "QNetworkInterface.interfaceIndexFromName": ('str',),
        "QNetworkInterface.interfaceNameFromIndex": ('int',),
        "QNetworkInterface.isValid": (),
        "QNetworkInterface.maximumTransmissionUnit": (),
        "QNetworkInterface.name": (),
        "QNetworkInterface.swap": ('PySide2.QtNetwork.QNetworkInterface',),
        "QNetworkInterface.type": (),

    # class PySide2.QtNetwork.QNetworkProxy:
        "QNetworkProxy.__init__": [(), ('PySide2.QtNetwork.QNetworkProxy',), ('PySide2.QtNetwork.QNetworkProxy.ProxyType', 'str', 'int', 'str', 'str')],
        "QNetworkProxy.__copy__": (),
        "QNetworkProxy.applicationProxy": (),
        "QNetworkProxy.capabilities": (),
        "QNetworkProxy.hasRawHeader": ('PySide2.QtCore.QByteArray',),
        "QNetworkProxy.header": ('PySide2.QtNetwork.QNetworkRequest.KnownHeaders',),
        "QNetworkProxy.hostName": (),
        "QNetworkProxy.isCachingProxy": (),
        "QNetworkProxy.isTransparentProxy": (),
        "QNetworkProxy.password": (),
        "QNetworkProxy.port": (),
        "QNetworkProxy.rawHeader": ('PySide2.QtCore.QByteArray',),
        "QNetworkProxy.rawHeaderList": (),
        "QNetworkProxy.setApplicationProxy": ('PySide2.QtNetwork.QNetworkProxy',),
        "QNetworkProxy.setCapabilities": ('PySide2.QtNetwork.QNetworkProxy.Capabilities',),
        "QNetworkProxy.setHeader": ('PySide2.QtNetwork.QNetworkRequest.KnownHeaders', 'typing.Any'),
        "QNetworkProxy.setHostName": ('str',),
        "QNetworkProxy.setPassword": ('str',),
        "QNetworkProxy.setPort": ('int',),
        "QNetworkProxy.setRawHeader": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray'),
        "QNetworkProxy.setType": ('PySide2.QtNetwork.QNetworkProxy.ProxyType',),
        "QNetworkProxy.setUser": ('str',),
        "QNetworkProxy.swap": ('PySide2.QtNetwork.QNetworkProxy',),
        "QNetworkProxy.type": (),
        "QNetworkProxy.user": (),

    # class PySide2.QtNetwork.QNetworkProxyFactory:
        "QNetworkProxyFactory.__init__": (),
        "QNetworkProxyFactory.proxyForQuery": ('PySide2.QtNetwork.QNetworkProxyQuery',),
        "QNetworkProxyFactory.queryProxy": ('PySide2.QtNetwork.QNetworkProxyQuery',),
        "QNetworkProxyFactory.setApplicationProxyFactory": ('PySide2.QtNetwork.QNetworkProxyFactory',),
        "QNetworkProxyFactory.setUseSystemConfiguration": ('bool',),
        "QNetworkProxyFactory.systemProxyForQuery": ('PySide2.QtNetwork.QNetworkProxyQuery',),
        "QNetworkProxyFactory.usesSystemConfiguration": (),

    # class PySide2.QtNetwork.QNetworkProxyQuery:
        "QNetworkProxyQuery.__init__": [(), ('PySide2.QtCore.QUrl', 'PySide2.QtNetwork.QNetworkProxyQuery.QueryType'), ('PySide2.QtNetwork.QNetworkConfiguration', 'PySide2.QtCore.QUrl', 'PySide2.QtNetwork.QNetworkProxyQuery.QueryType'), ('PySide2.QtNetwork.QNetworkConfiguration', 'int', 'str', 'PySide2.QtNetwork.QNetworkProxyQuery.QueryType'), ('PySide2.QtNetwork.QNetworkConfiguration', 'str', 'int', 'str', 'PySide2.QtNetwork.QNetworkProxyQuery.QueryType'), ('PySide2.QtNetwork.QNetworkProxyQuery',), ('int', 'str', 'PySide2.QtNetwork.QNetworkProxyQuery.QueryType'), ('str', 'int', 'str', 'PySide2.QtNetwork.QNetworkProxyQuery.QueryType')],
        "QNetworkProxyQuery.__copy__": (),
        "QNetworkProxyQuery.localPort": (),
        "QNetworkProxyQuery.networkConfiguration": (),
        "QNetworkProxyQuery.peerHostName": (),
        "QNetworkProxyQuery.peerPort": (),
        "QNetworkProxyQuery.protocolTag": (),
        "QNetworkProxyQuery.queryType": (),
        "QNetworkProxyQuery.setLocalPort": ('int',),
        "QNetworkProxyQuery.setNetworkConfiguration": ('PySide2.QtNetwork.QNetworkConfiguration',),
        "QNetworkProxyQuery.setPeerHostName": ('str',),
        "QNetworkProxyQuery.setPeerPort": ('int',),
        "QNetworkProxyQuery.setProtocolTag": ('str',),
        "QNetworkProxyQuery.setQueryType": ('PySide2.QtNetwork.QNetworkProxyQuery.QueryType',),
        "QNetworkProxyQuery.setUrl": ('PySide2.QtCore.QUrl',),
        "QNetworkProxyQuery.swap": ('PySide2.QtNetwork.QNetworkProxyQuery',),
        "QNetworkProxyQuery.url": (),

    # class PySide2.QtNetwork.QNetworkReply:
        "QNetworkReply.__init__": ('PySide2.QtCore.QObject',),
        "QNetworkReply.abort": (),
        "QNetworkReply.attribute": ('PySide2.QtNetwork.QNetworkRequest.Attribute',),
        "QNetworkReply.close": (),
        "QNetworkReply.error": (),
        "QNetworkReply.hasRawHeader": ('PySide2.QtCore.QByteArray',),
        "QNetworkReply.header": ('PySide2.QtNetwork.QNetworkRequest.KnownHeaders',),
        "QNetworkReply.ignoreSslErrors": [(), ('list',)],
        "QNetworkReply.ignoreSslErrorsImplementation": ('list',),
        "QNetworkReply.isFinished": (),
        "QNetworkReply.isRunning": (),
        "QNetworkReply.isSequential": (),
        "QNetworkReply.manager": (),
        "QNetworkReply.operation": (),
        "QNetworkReply.rawHeader": ('PySide2.QtCore.QByteArray',),
        "QNetworkReply.rawHeaderList": (),
        "QNetworkReply.rawHeaderPairs": (),
        "QNetworkReply.readBufferSize": (),
        "QNetworkReply.request": (),
        "QNetworkReply.setAttribute": ('PySide2.QtNetwork.QNetworkRequest.Attribute', 'typing.Any'),
        "QNetworkReply.setError": ('PySide2.QtNetwork.QNetworkReply.NetworkError', 'str'),
        "QNetworkReply.setFinished": ('bool',),
        "QNetworkReply.setHeader": ('PySide2.QtNetwork.QNetworkRequest.KnownHeaders', 'typing.Any'),
        "QNetworkReply.setOperation": ('PySide2.QtNetwork.QNetworkAccessManager.Operation',),
        "QNetworkReply.setRawHeader": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray'),
        "QNetworkReply.setReadBufferSize": ('int',),
        "QNetworkReply.setRequest": ('PySide2.QtNetwork.QNetworkRequest',),
        "QNetworkReply.setSslConfiguration": ('PySide2.QtNetwork.QSslConfiguration',),
        "QNetworkReply.setSslConfigurationImplementation": ('PySide2.QtNetwork.QSslConfiguration',),
        "QNetworkReply.setUrl": ('PySide2.QtCore.QUrl',),
        "QNetworkReply.sslConfiguration": (),
        "QNetworkReply.sslConfigurationImplementation": ('PySide2.QtNetwork.QSslConfiguration',),
        "QNetworkReply.url": (),
        "QNetworkReply.writeData": ('str', 'int'),

    # class PySide2.QtNetwork.QNetworkRequest:
        "QNetworkRequest.__init__": [('PySide2.QtCore.QUrl',), ('PySide2.QtNetwork.QNetworkRequest',)],
        "QNetworkRequest.__copy__": (),
        "QNetworkRequest.attribute": ('PySide2.QtNetwork.QNetworkRequest.Attribute', 'typing.Any'),
        "QNetworkRequest.hasRawHeader": ('PySide2.QtCore.QByteArray',),
        "QNetworkRequest.header": ('PySide2.QtNetwork.QNetworkRequest.KnownHeaders',),
        "QNetworkRequest.maximumRedirectsAllowed": (),
        "QNetworkRequest.originatingObject": (),
        "QNetworkRequest.priority": (),
        "QNetworkRequest.rawHeader": ('PySide2.QtCore.QByteArray',),
        "QNetworkRequest.rawHeaderList": (),
        "QNetworkRequest.setAttribute": ('PySide2.QtNetwork.QNetworkRequest.Attribute', 'typing.Any'),
        "QNetworkRequest.setHeader": ('PySide2.QtNetwork.QNetworkRequest.KnownHeaders', 'typing.Any'),
        "QNetworkRequest.setMaximumRedirectsAllowed": ('int',),
        "QNetworkRequest.setOriginatingObject": ('PySide2.QtCore.QObject',),
        "QNetworkRequest.setPriority": ('PySide2.QtNetwork.QNetworkRequest.Priority',),
        "QNetworkRequest.setRawHeader": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray'),
        "QNetworkRequest.setSslConfiguration": ('PySide2.QtNetwork.QSslConfiguration',),
        "QNetworkRequest.setUrl": ('PySide2.QtCore.QUrl',),
        "QNetworkRequest.sslConfiguration": (),
        "QNetworkRequest.swap": ('PySide2.QtNetwork.QNetworkRequest',),
        "QNetworkRequest.url": (),

    # class PySide2.QtNetwork.QNetworkSession:
        "QNetworkSession.__init__": ('PySide2.QtNetwork.QNetworkConfiguration', 'PySide2.QtCore.QObject'),
        "QNetworkSession.accept": (),
        "QNetworkSession.activeTime": (),
        "QNetworkSession.bytesReceived": (),
        "QNetworkSession.bytesWritten": (),
        "QNetworkSession.close": (),
        "QNetworkSession.configuration": (),
        "QNetworkSession.connectNotify": ('PySide2.QtCore.QMetaMethod',),
        "QNetworkSession.disconnectNotify": ('PySide2.QtCore.QMetaMethod',),
        "QNetworkSession.error": (),
        "QNetworkSession.errorString": (),
        "QNetworkSession.ignore": (),
        "QNetworkSession.interface": (),
        "QNetworkSession.isOpen": (),
        "QNetworkSession.migrate": (),
        "QNetworkSession.open": (),
        "QNetworkSession.reject": (),
        "QNetworkSession.sessionProperty": ('str',),
        "QNetworkSession.setSessionProperty": ('str', 'typing.Any'),
        "QNetworkSession.state": (),
        "QNetworkSession.stop": (),
        "QNetworkSession.usagePolicies": (),
        "QNetworkSession.waitForOpened": ('int',),

    # class PySide2.QtNetwork.QPasswordDigestor:
        "QPasswordDigestor.deriveKeyPbkdf1": ('PySide2.QtCore.QCryptographicHash.Algorithm', 'PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray', 'int', 'int'),
        "QPasswordDigestor.deriveKeyPbkdf2": ('PySide2.QtCore.QCryptographicHash.Algorithm', 'PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray', 'int', 'int'),

    # class PySide2.QtNetwork.QSsl:

    # class PySide2.QtNetwork.QSslCertificate:
        "QSslCertificate.__init__": [('PySide2.QtCore.QByteArray', 'PySide2.QtNetwork.QSsl.EncodingFormat'), ('PySide2.QtCore.QIODevice', 'PySide2.QtNetwork.QSsl.EncodingFormat'), ('PySide2.QtNetwork.QSslCertificate',)],
        "QSslCertificate.__copy__": (),
        "QSslCertificate.clear": (),
        "QSslCertificate.digest": ('PySide2.QtCore.QCryptographicHash.Algorithm',),
        "QSslCertificate.effectiveDate": (),
        "QSslCertificate.expiryDate": (),
        "QSslCertificate.extensions": (),
        "QSslCertificate.fromData": ('PySide2.QtCore.QByteArray', 'PySide2.QtNetwork.QSsl.EncodingFormat'),
        "QSslCertificate.fromDevice": ('PySide2.QtCore.QIODevice', 'PySide2.QtNetwork.QSsl.EncodingFormat'),
        "QSslCertificate.fromPath": ('str', 'PySide2.QtNetwork.QSsl.EncodingFormat', 'PySide2.QtCore.QRegExp.PatternSyntax'),
        "QSslCertificate.handle": (),
        "QSslCertificate.importPkcs12": ('PySide2.QtCore.QIODevice', 'PySide2.QtNetwork.QSslKey', 'PySide2.QtNetwork.QSslCertificate', 'list', 'PySide2.QtCore.QByteArray'),
        "QSslCertificate.isBlacklisted": (),
        "QSslCertificate.isNull": (),
        "QSslCertificate.isSelfSigned": (),
        "QSslCertificate.issuerDisplayName": (),
        "QSslCertificate.issuerInfo": [('PySide2.QtCore.QByteArray',), ('PySide2.QtNetwork.QSslCertificate.SubjectInfo',)],
        "QSslCertificate.issuerInfoAttributes": (),
        "QSslCertificate.publicKey": (),
        "QSslCertificate.serialNumber": (),
        "QSslCertificate.subjectAlternativeNames": (),
        "QSslCertificate.subjectDisplayName": (),
        "QSslCertificate.subjectInfo": [('PySide2.QtCore.QByteArray',), ('PySide2.QtNetwork.QSslCertificate.SubjectInfo',)],
        "QSslCertificate.subjectInfoAttributes": (),
        "QSslCertificate.swap": ('PySide2.QtNetwork.QSslCertificate',),
        "QSslCertificate.toDer": (),
        "QSslCertificate.toPem": (),
        "QSslCertificate.toText": (),
        "QSslCertificate.verify": ('list', 'str'),
        "QSslCertificate.version": (),

    # class PySide2.QtNetwork.QSslCertificateExtension:
        "QSslCertificateExtension.__init__": [(), ('PySide2.QtNetwork.QSslCertificateExtension',)],
        "QSslCertificateExtension.__copy__": (),
        "QSslCertificateExtension.isCritical": (),
        "QSslCertificateExtension.isSupported": (),
        "QSslCertificateExtension.name": (),
        "QSslCertificateExtension.oid": (),
        "QSslCertificateExtension.swap": ('PySide2.QtNetwork.QSslCertificateExtension',),
        "QSslCertificateExtension.value": (),

    # class PySide2.QtNetwork.QSslCipher:
        "QSslCipher.__init__": [(), ('PySide2.QtNetwork.QSslCipher',), ('str',), ('str', 'PySide2.QtNetwork.QSsl.SslProtocol')],
        "QSslCipher.__copy__": (),
        "QSslCipher.authenticationMethod": (),
        "QSslCipher.encryptionMethod": (),
        "QSslCipher.isNull": (),
        "QSslCipher.keyExchangeMethod": (),
        "QSslCipher.name": (),
        "QSslCipher.protocol": (),
        "QSslCipher.protocolString": (),
        "QSslCipher.supportedBits": (),
        "QSslCipher.swap": ('PySide2.QtNetwork.QSslCipher',),
        "QSslCipher.usedBits": (),

    # class PySide2.QtNetwork.QSslConfiguration:
        "QSslConfiguration.__init__": [(), ('PySide2.QtNetwork.QSslConfiguration',)],
        "QSslConfiguration.__copy__": (),
        "QSslConfiguration.allowedNextProtocols": (),
        "QSslConfiguration.backendConfiguration": (),
        "QSslConfiguration.caCertificates": (),
        "QSslConfiguration.ciphers": (),
        "QSslConfiguration.defaultConfiguration": (),
        "QSslConfiguration.defaultDtlsConfiguration": (),
        "QSslConfiguration.diffieHellmanParameters": (),
        "QSslConfiguration.dtlsCookieVerificationEnabled": (),
        "QSslConfiguration.ephemeralServerKey": (),
        "QSslConfiguration.isNull": (),
        "QSslConfiguration.localCertificate": (),
        "QSslConfiguration.localCertificateChain": (),
        "QSslConfiguration.nextNegotiatedProtocol": (),
        "QSslConfiguration.nextProtocolNegotiationStatus": (),
        "QSslConfiguration.peerCertificate": (),
        "QSslConfiguration.peerCertificateChain": (),
        "QSslConfiguration.peerVerifyDepth": (),
        "QSslConfiguration.peerVerifyMode": (),
        "QSslConfiguration.preSharedKeyIdentityHint": (),
        "QSslConfiguration.privateKey": (),
        "QSslConfiguration.protocol": (),
        "QSslConfiguration.sessionCipher": (),
        "QSslConfiguration.sessionProtocol": (),
        "QSslConfiguration.sessionTicket": (),
        "QSslConfiguration.sessionTicketLifeTimeHint": (),
        "QSslConfiguration.setAllowedNextProtocols": ('list',),
        "QSslConfiguration.setBackendConfiguration": ('dict',),
        "QSslConfiguration.setBackendConfigurationOption": ('PySide2.QtCore.QByteArray', 'typing.Any'),
        "QSslConfiguration.setCaCertificates": ('list',),
        "QSslConfiguration.setCiphers": ('list',),
        "QSslConfiguration.setDefaultConfiguration": ('PySide2.QtNetwork.QSslConfiguration',),
        "QSslConfiguration.setDefaultDtlsConfiguration": ('PySide2.QtNetwork.QSslConfiguration',),
        "QSslConfiguration.setDiffieHellmanParameters": ('PySide2.QtNetwork.QSslDiffieHellmanParameters',),
        "QSslConfiguration.setDtlsCookieVerificationEnabled": ('bool',),
        "QSslConfiguration.setLocalCertificate": ('PySide2.QtNetwork.QSslCertificate',),
        "QSslConfiguration.setLocalCertificateChain": ('list',),
        "QSslConfiguration.setPeerVerifyDepth": ('int',),
        "QSslConfiguration.setPeerVerifyMode": ('PySide2.QtNetwork.QSslSocket.PeerVerifyMode',),
        "QSslConfiguration.setPreSharedKeyIdentityHint": ('PySide2.QtCore.QByteArray',),
        "QSslConfiguration.setPrivateKey": ('PySide2.QtNetwork.QSslKey',),
        "QSslConfiguration.setProtocol": ('PySide2.QtNetwork.QSsl.SslProtocol',),
        "QSslConfiguration.setSessionTicket": ('PySide2.QtCore.QByteArray',),
        "QSslConfiguration.setSslOption": ('PySide2.QtNetwork.QSsl.SslOption', 'bool'),
        "QSslConfiguration.supportedCiphers": (),
        "QSslConfiguration.swap": ('PySide2.QtNetwork.QSslConfiguration',),
        "QSslConfiguration.systemCaCertificates": (),
        "QSslConfiguration.testSslOption": ('PySide2.QtNetwork.QSsl.SslOption',),

    # class PySide2.QtNetwork.QSslDiffieHellmanParameters:
        "QSslDiffieHellmanParameters.__init__": [(), ('PySide2.QtNetwork.QSslDiffieHellmanParameters',)],
        "QSslDiffieHellmanParameters.__copy__": (),
        "QSslDiffieHellmanParameters.defaultParameters": (),
        "QSslDiffieHellmanParameters.error": (),
        "QSslDiffieHellmanParameters.errorString": (),
        "QSslDiffieHellmanParameters.fromEncoded": [('PySide2.QtCore.QByteArray', 'PySide2.QtNetwork.QSsl.EncodingFormat'), ('PySide2.QtCore.QIODevice', 'PySide2.QtNetwork.QSsl.EncodingFormat')],
        "QSslDiffieHellmanParameters.isEmpty": (),
        "QSslDiffieHellmanParameters.isValid": (),
        "QSslDiffieHellmanParameters.swap": ('PySide2.QtNetwork.QSslDiffieHellmanParameters',),

    # class PySide2.QtNetwork.QSslError:
        "QSslError.__init__": [(), ('PySide2.QtNetwork.QSslError',), ('PySide2.QtNetwork.QSslError.SslError',), ('PySide2.QtNetwork.QSslError.SslError', 'PySide2.QtNetwork.QSslCertificate')],
        "QSslError.__copy__": (),
        "QSslError.certificate": (),
        "QSslError.error": (),
        "QSslError.errorString": (),
        "QSslError.swap": ('PySide2.QtNetwork.QSslError',),

    # class PySide2.QtNetwork.QSslKey:
        "QSslKey.__init__": [(), ('PySide2.QtCore.QByteArray', 'PySide2.QtNetwork.QSsl.KeyAlgorithm', 'PySide2.QtNetwork.QSsl.EncodingFormat', 'PySide2.QtNetwork.QSsl.KeyType', 'PySide2.QtCore.QByteArray'), ('PySide2.QtCore.QIODevice', 'PySide2.QtNetwork.QSsl.KeyAlgorithm', 'PySide2.QtNetwork.QSsl.EncodingFormat', 'PySide2.QtNetwork.QSsl.KeyType', 'PySide2.QtCore.QByteArray'), ('PySide2.QtNetwork.QSslKey',), ('int', 'PySide2.QtNetwork.QSsl.KeyType')],
        "QSslKey.__copy__": (),
        "QSslKey.algorithm": (),
        "QSslKey.clear": (),
        "QSslKey.handle": (),
        "QSslKey.isNull": (),
        "QSslKey.length": (),
        "QSslKey.swap": ('PySide2.QtNetwork.QSslKey',),
        "QSslKey.toDer": ('PySide2.QtCore.QByteArray',),
        "QSslKey.toPem": ('PySide2.QtCore.QByteArray',),
        "QSslKey.type": (),

    # class PySide2.QtNetwork.QSslPreSharedKeyAuthenticator:
        "QSslPreSharedKeyAuthenticator.__init__": [(), ('PySide2.QtNetwork.QSslPreSharedKeyAuthenticator',)],
        "QSslPreSharedKeyAuthenticator.__copy__": (),
        "QSslPreSharedKeyAuthenticator.identity": (),
        "QSslPreSharedKeyAuthenticator.identityHint": (),
        "QSslPreSharedKeyAuthenticator.maximumIdentityLength": (),
        "QSslPreSharedKeyAuthenticator.maximumPreSharedKeyLength": (),
        "QSslPreSharedKeyAuthenticator.preSharedKey": (),
        "QSslPreSharedKeyAuthenticator.setIdentity": ('PySide2.QtCore.QByteArray',),
        "QSslPreSharedKeyAuthenticator.setPreSharedKey": ('PySide2.QtCore.QByteArray',),
        "QSslPreSharedKeyAuthenticator.swap": ('PySide2.QtNetwork.QSslPreSharedKeyAuthenticator',),

    # class PySide2.QtNetwork.QSslSocket:
        "QSslSocket.__init__": ('PySide2.QtCore.QObject',),
        "QSslSocket.abort": (),
        "QSslSocket.addCaCertificate": ('PySide2.QtNetwork.QSslCertificate',),
        "QSslSocket.addCaCertificates": [('list',), ('str', 'PySide2.QtNetwork.QSsl.EncodingFormat', 'PySide2.QtCore.QRegExp.PatternSyntax')],
        "QSslSocket.addDefaultCaCertificate": ('PySide2.QtNetwork.QSslCertificate',),
        "QSslSocket.addDefaultCaCertificates": [('list',), ('str', 'PySide2.QtNetwork.QSsl.EncodingFormat', 'PySide2.QtCore.QRegExp.PatternSyntax')],
        "QSslSocket.atEnd": (),
        "QSslSocket.bytesAvailable": (),
        "QSslSocket.bytesToWrite": (),
        "QSslSocket.caCertificates": (),
        "QSslSocket.canReadLine": (),
        "QSslSocket.ciphers": (),
        "QSslSocket.close": (),
        "QSslSocket.connectToHost": [('PySide2.QtNetwork.QHostAddress', 'int', 'PySide2.QtCore.QIODevice.OpenMode'), ('str', 'int', 'PySide2.QtCore.QIODevice.OpenMode', 'PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol')],
        "QSslSocket.connectToHostEncrypted": [('str', 'int', 'PySide2.QtCore.QIODevice.OpenMode', 'PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol'), ('str', 'int', 'str', 'PySide2.QtCore.QIODevice.OpenMode', 'PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol')],
        "QSslSocket.defaultCaCertificates": (),
        "QSslSocket.defaultCiphers": (),
        "QSslSocket.disconnectFromHost": (),
        "QSslSocket.encryptedBytesAvailable": (),
        "QSslSocket.encryptedBytesToWrite": (),
        "QSslSocket.flush": (),
        "QSslSocket.ignoreSslErrors": [(), ('list',)],
        "QSslSocket.isEncrypted": (),
        "QSslSocket.localCertificate": (),
        "QSslSocket.localCertificateChain": (),
        "QSslSocket.mode": (),
        "QSslSocket.peerCertificate": (),
        "QSslSocket.peerCertificateChain": (),
        "QSslSocket.peerVerifyDepth": (),
        "QSslSocket.peerVerifyMode": (),
        "QSslSocket.peerVerifyName": (),
        "QSslSocket.privateKey": (),
        "QSslSocket.protocol": (),
        "QSslSocket.readData": ('str', 'int'),
        "QSslSocket.resume": (),
        "QSslSocket.sessionCipher": (),
        "QSslSocket.sessionProtocol": (),
        "QSslSocket.setCaCertificates": ('list',),
        "QSslSocket.setCiphers": [('list',), ('str',)],
        "QSslSocket.setDefaultCaCertificates": ('list',),
        "QSslSocket.setDefaultCiphers": ('list',),
        "QSslSocket.setLocalCertificate": [('PySide2.QtNetwork.QSslCertificate',), ('str', 'PySide2.QtNetwork.QSsl.EncodingFormat')],
        "QSslSocket.setLocalCertificateChain": ('list',),
        "QSslSocket.setPeerVerifyDepth": ('int',),
        "QSslSocket.setPeerVerifyMode": ('PySide2.QtNetwork.QSslSocket.PeerVerifyMode',),
        "QSslSocket.setPeerVerifyName": ('str',),
        "QSslSocket.setPrivateKey": [('PySide2.QtNetwork.QSslKey',), ('str', 'PySide2.QtNetwork.QSsl.KeyAlgorithm', 'PySide2.QtNetwork.QSsl.EncodingFormat', 'PySide2.QtCore.QByteArray')],
        "QSslSocket.setProtocol": ('PySide2.QtNetwork.QSsl.SslProtocol',),
        "QSslSocket.setReadBufferSize": ('int',),
        "QSslSocket.setSocketDescriptor": ('int', 'PySide2.QtNetwork.QAbstractSocket.SocketState', 'PySide2.QtCore.QIODevice.OpenMode'),
        "QSslSocket.setSocketOption": ('PySide2.QtNetwork.QAbstractSocket.SocketOption', 'typing.Any'),
        "QSslSocket.setSslConfiguration": ('PySide2.QtNetwork.QSslConfiguration',),
        "QSslSocket.socketOption": ('PySide2.QtNetwork.QAbstractSocket.SocketOption',),
        "QSslSocket.sslConfiguration": (),
        "QSslSocket.sslErrors": (),
        "QSslSocket.sslLibraryBuildVersionNumber": (),
        "QSslSocket.sslLibraryBuildVersionString": (),
        "QSslSocket.sslLibraryVersionNumber": (),
        "QSslSocket.sslLibraryVersionString": (),
        "QSslSocket.startClientEncryption": (),
        "QSslSocket.startServerEncryption": (),
        "QSslSocket.supportedCiphers": (),
        "QSslSocket.supportsSsl": (),
        "QSslSocket.systemCaCertificates": (),
        "QSslSocket.waitForBytesWritten": ('int',),
        "QSslSocket.waitForConnected": ('int',),
        "QSslSocket.waitForDisconnected": ('int',),
        "QSslSocket.waitForEncrypted": ('int',),
        "QSslSocket.waitForReadyRead": ('int',),
        "QSslSocket.writeData": ('str', 'int'),

    # class PySide2.QtNetwork.QTcpServer:
        "QTcpServer.__init__": ('PySide2.QtCore.QObject',),
        "QTcpServer.addPendingConnection": ('PySide2.QtNetwork.QTcpSocket',),
        "QTcpServer.close": (),
        "QTcpServer.errorString": (),
        "QTcpServer.hasPendingConnections": (),
        "QTcpServer.incomingConnection": ('int',),
        "QTcpServer.isListening": (),
        "QTcpServer.listen": ('PySide2.QtNetwork.QHostAddress', 'int'),
        "QTcpServer.maxPendingConnections": (),
        "QTcpServer.nextPendingConnection": (),
        "QTcpServer.pauseAccepting": (),
        "QTcpServer.proxy": (),
        "QTcpServer.resumeAccepting": (),
        "QTcpServer.serverAddress": (),
        "QTcpServer.serverError": (),
        "QTcpServer.serverPort": (),
        "QTcpServer.setMaxPendingConnections": ('int',),
        "QTcpServer.setProxy": ('PySide2.QtNetwork.QNetworkProxy',),
        "QTcpServer.setSocketDescriptor": ('int',),
        "QTcpServer.socketDescriptor": (),
        "QTcpServer.waitForNewConnection": ('int', 'bool'),

    # class PySide2.QtNetwork.QTcpSocket:
        "QTcpSocket.__init__": ('PySide2.QtCore.QObject',),

    # class PySide2.QtNetwork.QUdpSocket:
        "QUdpSocket.__init__": ('PySide2.QtCore.QObject',),
        "QUdpSocket.hasPendingDatagrams": (),
        "QUdpSocket.joinMulticastGroup": [('PySide2.QtNetwork.QHostAddress',), ('PySide2.QtNetwork.QHostAddress', 'PySide2.QtNetwork.QNetworkInterface')],
        "QUdpSocket.leaveMulticastGroup": [('PySide2.QtNetwork.QHostAddress',), ('PySide2.QtNetwork.QHostAddress', 'PySide2.QtNetwork.QNetworkInterface')],
        "QUdpSocket.multicastInterface": (),
        "QUdpSocket.pendingDatagramSize": (),
        "QUdpSocket.readDatagram": ('str', 'int', 'PySide2.QtNetwork.QHostAddress', 'int'),
        "QUdpSocket.receiveDatagram": ('int',),
        "QUdpSocket.setMulticastInterface": ('PySide2.QtNetwork.QNetworkInterface',),
        "QUdpSocket.writeDatagram": [('PySide2.QtCore.QByteArray', 'PySide2.QtNetwork.QHostAddress', 'int'), ('PySide2.QtNetwork.QNetworkDatagram',)],
    })

# Module PySide2.QtTest
if "PySide2.QtTest" in sys.modules:
    dict.update({

    # class PySide2.QtTest.QTest:
        "QTest.addColumnInternal": ('int', 'str'),
        "QTest.asciiToKey": ('typing.Union[str, int]',),
        "QTest.compare_ptr_helper": ('int', 'int', 'str', 'str', 'str', 'int'),
        "QTest.compare_string_helper": ('str', 'str', 'str', 'str', 'str', 'int'),
        "QTest.createTouchDevice": ('PySide2.QtGui.QTouchDevice.DeviceType',),
        "QTest.currentAppName": (),
        "QTest.currentDataTag": (),
        "QTest.currentTestFailed": (),
        "QTest.currentTestFunction": (),
        "QTest.ignoreMessage": [('PySide2.QtCore.QtMsgType', 'PySide2.QtCore.QRegularExpression'), ('PySide2.QtCore.QtMsgType', 'str')],
        "QTest.keyClick": [('PySide2.QtGui.QWindow', 'PySide2.QtCore.Qt.Key', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtGui.QWindow', 'typing.Union[str, int]', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.Key', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtWidgets.QWidget', 'typing.Union[str, int]', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int')],
        "QTest.keyClicks": ('PySide2.QtWidgets.QWidget', 'str', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'),
        "QTest.keyEvent": [('PySide2.QtTest.QTest.KeyAction', 'PySide2.QtGui.QWindow', 'PySide2.QtCore.Qt.Key', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtTest.QTest.KeyAction', 'PySide2.QtGui.QWindow', 'typing.Union[str, int]', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtTest.QTest.KeyAction', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.Key', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtTest.QTest.KeyAction', 'PySide2.QtWidgets.QWidget', 'typing.Union[str, int]', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int')],
        "QTest.keyPress": [('PySide2.QtGui.QWindow', 'PySide2.QtCore.Qt.Key', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtGui.QWindow', 'typing.Union[str, int]', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.Key', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtWidgets.QWidget', 'typing.Union[str, int]', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int')],
        "QTest.keyRelease": [('PySide2.QtGui.QWindow', 'PySide2.QtCore.Qt.Key', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtGui.QWindow', 'typing.Union[str, int]', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.Key', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtWidgets.QWidget', 'typing.Union[str, int]', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int')],
        "QTest.keySequence": [('PySide2.QtGui.QWindow', 'PySide2.QtGui.QKeySequence'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtGui.QKeySequence')],
        "QTest.keyToAscii": ('PySide2.QtCore.Qt.Key',),
        "QTest.mouseClick": [('PySide2.QtGui.QWindow', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.QPoint', 'int'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.QPoint', 'int')],
        "QTest.mouseDClick": [('PySide2.QtGui.QWindow', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.QPoint', 'int'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.QPoint', 'int')],
        "QTest.mouseEvent": [('PySide2.QtTest.QTest.MouseAction', 'PySide2.QtGui.QWindow', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.QPoint', 'int'), ('PySide2.QtTest.QTest.MouseAction', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.QPoint', 'int')],
        "QTest.mouseMove": [('PySide2.QtGui.QWindow', 'PySide2.QtCore.QPoint', 'int'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QPoint', 'int')],
        "QTest.mousePress": [('PySide2.QtGui.QWindow', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.QPoint', 'int'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.QPoint', 'int')],
        "QTest.mouseRelease": [('PySide2.QtGui.QWindow', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.QPoint', 'int'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.QPoint', 'int')],
        "QTest.qCleanup": (),
        "QTest.qElementData": ('str', 'int'),
        "QTest.qExpectFail": ('str', 'str', 'PySide2.QtTest.QTest.TestFailMode', 'str', 'int'),
        "QTest.qFindTestData": ('str', 'str', 'int', 'str'),
        "QTest.qGlobalData": ('str', 'int'),
        "QTest.qRun": (),
        "QTest.qSkip": ('str', 'str', 'int'),
        "QTest.qWaitForWindowActive": ('PySide2.QtWidgets.QWidget', 'int'),
        "QTest.qWaitForWindowExposed": ('PySide2.QtWidgets.QWidget', 'int'),
        "QTest.sendKeyEvent": [('PySide2.QtTest.QTest.KeyAction', 'PySide2.QtGui.QWindow', 'PySide2.QtCore.Qt.Key', 'str', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtTest.QTest.KeyAction', 'PySide2.QtGui.QWindow', 'PySide2.QtCore.Qt.Key', 'typing.Union[str, int]', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtTest.QTest.KeyAction', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.Key', 'str', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtTest.QTest.KeyAction', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.Key', 'typing.Union[str, int]', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int')],
        "QTest.setBenchmarkResult": ('float', 'PySide2.QtTest.QTest.QBenchmarkMetric'),
        "QTest.setMainSourcePath": ('str', 'str'),
        "QTest.simulateEvent": [('PySide2.QtGui.QWindow', 'bool', 'int', 'PySide2.QtCore.Qt.KeyboardModifiers', 'str', 'bool', 'int'), ('PySide2.QtWidgets.QWidget', 'bool', 'int', 'PySide2.QtCore.Qt.KeyboardModifiers', 'str', 'bool', 'int')],
        "QTest.testObject": (),
        "QTest.toPrettyCString": ('str', 'int'),
        "QTest.touchEvent": [('PySide2.QtGui.QWindow', 'PySide2.QtGui.QTouchDevice', 'bool'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtGui.QTouchDevice', 'bool')],

    # class PySide2.QtTest.QTest.QTouchEventSequence:
        "QTest.QTouchEventSequence.commit": ('bool',),
        "QTest.QTouchEventSequence.move": [('int', 'PySide2.QtCore.QPoint', 'PySide2.QtGui.QWindow'), ('int', 'PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QWidget')],
        "QTest.QTouchEventSequence.press": [('int', 'PySide2.QtCore.QPoint', 'PySide2.QtGui.QWindow'), ('int', 'PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QWidget')],
        "QTest.QTouchEventSequence.release": [('int', 'PySide2.QtCore.QPoint', 'PySide2.QtGui.QWindow'), ('int', 'PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QWidget')],
        "QTest.QTouchEventSequence.stationary": ('int',),
    })

# Module PySide2.QtConcurrent
if "PySide2.QtConcurrent" in sys.modules:
    dict.update({

    # class PySide2.QtConcurrent.QtConcurrent:
    })

# Module PySide2.QtX11Extras
if "PySide2.QtX11Extras" in sys.modules:
    dict.update({

    # class PySide2.QtX11Extras.QX11Info:
        "QX11Info.appDpiX": ('int',),
        "QX11Info.appDpiY": ('int',),
        "QX11Info.appRootWindow": ('int',),
        "QX11Info.appScreen": (),
        "QX11Info.appTime": (),
        "QX11Info.appUserTime": (),
        "QX11Info.generatePeekerId": (),
        "QX11Info.getTimestamp": (),
        "QX11Info.isCompositingManagerRunning": ('int',),
        "QX11Info.isPlatformX11": (),
        "QX11Info.nextStartupId": (),
        "QX11Info.removePeekerId": ('int',),
        "QX11Info.setAppTime": ('int',),
        "QX11Info.setAppUserTime": ('int',),
        "QX11Info.setNextStartupId": ('PySide2.QtCore.QByteArray',),
    })

# Module PySide2.QtXml
if "PySide2.QtXml" in sys.modules:
    dict.update({

    # class PySide2.QtXml.QDomAttr:
        "QDomAttr.__init__": [(), ('PySide2.QtXml.QDomAttr',)],
        "QDomAttr.__copy__": (),
        "QDomAttr.name": (),
        "QDomAttr.nodeType": (),
        "QDomAttr.ownerElement": (),
        "QDomAttr.setValue": ('str',),
        "QDomAttr.specified": (),
        "QDomAttr.value": (),

    # class PySide2.QtXml.QDomCDATASection:
        "QDomCDATASection.__init__": [(), ('PySide2.QtXml.QDomCDATASection',)],
        "QDomCDATASection.__copy__": (),
        "QDomCDATASection.nodeType": (),

    # class PySide2.QtXml.QDomCharacterData:
        "QDomCharacterData.__init__": [(), ('PySide2.QtXml.QDomCharacterData',)],
        "QDomCharacterData.__copy__": (),
        "QDomCharacterData.appendData": ('str',),
        "QDomCharacterData.data": (),
        "QDomCharacterData.deleteData": ('int', 'int'),
        "QDomCharacterData.insertData": ('int', 'str'),
        "QDomCharacterData.length": (),
        "QDomCharacterData.nodeType": (),
        "QDomCharacterData.replaceData": ('int', 'int', 'str'),
        "QDomCharacterData.setData": ('str',),
        "QDomCharacterData.substringData": ('int', 'int'),

    # class PySide2.QtXml.QDomComment:
        "QDomComment.__init__": [(), ('PySide2.QtXml.QDomComment',)],
        "QDomComment.__copy__": (),
        "QDomComment.nodeType": (),

    # class PySide2.QtXml.QDomDocument:
        "QDomDocument.__init__": [(), ('PySide2.QtXml.QDomDocument',), ('PySide2.QtXml.QDomDocumentType',), ('str',)],
        "QDomDocument.__copy__": (),
        "QDomDocument.createAttribute": ('str',),
        "QDomDocument.createAttributeNS": ('str', 'str'),
        "QDomDocument.createCDATASection": ('str',),
        "QDomDocument.createComment": ('str',),
        "QDomDocument.createDocumentFragment": (),
        "QDomDocument.createElement": ('str',),
        "QDomDocument.createElementNS": ('str', 'str'),
        "QDomDocument.createEntityReference": ('str',),
        "QDomDocument.createProcessingInstruction": ('str', 'str'),
        "QDomDocument.createTextNode": ('str',),
        "QDomDocument.doctype": (),
        "QDomDocument.documentElement": (),
        "QDomDocument.elementById": ('str',),
        "QDomDocument.elementsByTagName": ('str',),
        "QDomDocument.elementsByTagNameNS": ('str', 'str'),
        "QDomDocument.implementation": (),
        "QDomDocument.importNode": ('PySide2.QtXml.QDomNode', 'bool'),
        "QDomDocument.nodeType": (),
        "QDomDocument.setContent": [('PySide2.QtCore.QByteArray', 'bool', 'str', 'int', 'int'), ('PySide2.QtCore.QByteArray', 'str', 'int', 'int'), ('PySide2.QtCore.QIODevice', 'bool', 'str', 'int', 'int'), ('PySide2.QtCore.QIODevice', 'str', 'int', 'int'), ('PySide2.QtXml.QXmlInputSource', 'PySide2.QtXml.QXmlReader', 'str', 'int', 'int'), ('PySide2.QtXml.QXmlInputSource', 'bool', 'str', 'int', 'int'), ('str', 'bool', 'str', 'int', 'int'), ('str', 'str', 'int', 'int')],
        "QDomDocument.toByteArray": ('int',),
        "QDomDocument.toString": ('int',),

    # class PySide2.QtXml.QDomDocumentFragment:
        "QDomDocumentFragment.__init__": [(), ('PySide2.QtXml.QDomDocumentFragment',)],
        "QDomDocumentFragment.__copy__": (),
        "QDomDocumentFragment.nodeType": (),

    # class PySide2.QtXml.QDomDocumentType:
        "QDomDocumentType.__init__": [(), ('PySide2.QtXml.QDomDocumentType',)],
        "QDomDocumentType.__copy__": (),
        "QDomDocumentType.entities": (),
        "QDomDocumentType.internalSubset": (),
        "QDomDocumentType.name": (),
        "QDomDocumentType.nodeType": (),
        "QDomDocumentType.notations": (),
        "QDomDocumentType.publicId": (),
        "QDomDocumentType.systemId": (),

    # class PySide2.QtXml.QDomElement:
        "QDomElement.__init__": [(), ('PySide2.QtXml.QDomElement',)],
        "QDomElement.__copy__": (),
        "QDomElement.attribute": ('str', 'str'),
        "QDomElement.attributeNS": ('str', 'str', 'str'),
        "QDomElement.attributeNode": ('str',),
        "QDomElement.attributeNodeNS": ('str', 'str'),
        "QDomElement.attributes": (),
        "QDomElement.elementsByTagName": ('str',),
        "QDomElement.elementsByTagNameNS": ('str', 'str'),
        "QDomElement.hasAttribute": ('str',),
        "QDomElement.hasAttributeNS": ('str', 'str'),
        "QDomElement.nodeType": (),
        "QDomElement.removeAttribute": ('str',),
        "QDomElement.removeAttributeNS": ('str', 'str'),
        "QDomElement.removeAttributeNode": ('PySide2.QtXml.QDomAttr',),
        "QDomElement.setAttribute": [('str', 'float'), ('str', 'int'), ('str', 'str')],
        "QDomElement.setAttributeNS": [('str', 'str', 'float'), ('str', 'str', 'int'), ('str', 'str', 'str')],
        "QDomElement.setAttributeNode": ('PySide2.QtXml.QDomAttr',),
        "QDomElement.setAttributeNodeNS": ('PySide2.QtXml.QDomAttr',),
        "QDomElement.setTagName": ('str',),
        "QDomElement.tagName": (),
        "QDomElement.text": (),

    # class PySide2.QtXml.QDomEntity:
        "QDomEntity.__init__": [(), ('PySide2.QtXml.QDomEntity',)],
        "QDomEntity.__copy__": (),
        "QDomEntity.nodeType": (),
        "QDomEntity.notationName": (),
        "QDomEntity.publicId": (),
        "QDomEntity.systemId": (),

    # class PySide2.QtXml.QDomEntityReference:
        "QDomEntityReference.__init__": [(), ('PySide2.QtXml.QDomEntityReference',)],
        "QDomEntityReference.__copy__": (),
        "QDomEntityReference.nodeType": (),

    # class PySide2.QtXml.QDomImplementation:
        "QDomImplementation.__init__": [(), ('PySide2.QtXml.QDomImplementation',)],
        "QDomImplementation.__copy__": (),
        "QDomImplementation.createDocument": ('str', 'str', 'PySide2.QtXml.QDomDocumentType'),
        "QDomImplementation.createDocumentType": ('str', 'str', 'str'),
        "QDomImplementation.hasFeature": ('str', 'str'),
        "QDomImplementation.invalidDataPolicy": (),
        "QDomImplementation.isNull": (),
        "QDomImplementation.setInvalidDataPolicy": ('PySide2.QtXml.QDomImplementation.InvalidDataPolicy',),

    # class PySide2.QtXml.QDomNamedNodeMap:
        "QDomNamedNodeMap.__init__": [(), ('PySide2.QtXml.QDomNamedNodeMap',)],
        "QDomNamedNodeMap.__copy__": (),
        "QDomNamedNodeMap.contains": ('str',),
        "QDomNamedNodeMap.count": (),
        "QDomNamedNodeMap.isEmpty": (),
        "QDomNamedNodeMap.item": ('int',),
        "QDomNamedNodeMap.length": (),
        "QDomNamedNodeMap.namedItem": ('str',),
        "QDomNamedNodeMap.namedItemNS": ('str', 'str'),
        "QDomNamedNodeMap.removeNamedItem": ('str',),
        "QDomNamedNodeMap.removeNamedItemNS": ('str', 'str'),
        "QDomNamedNodeMap.setNamedItem": ('PySide2.QtXml.QDomNode',),
        "QDomNamedNodeMap.setNamedItemNS": ('PySide2.QtXml.QDomNode',),
        "QDomNamedNodeMap.size": (),

    # class PySide2.QtXml.QDomNode:
        "QDomNode.__init__": [(), ('PySide2.QtXml.QDomNode',)],
        "QDomNode.__copy__": (),
        "QDomNode.__lshift__": ('PySide2.QtCore.QTextStream',),
        "QDomNode.appendChild": ('PySide2.QtXml.QDomNode',),
        "QDomNode.attributes": (),
        "QDomNode.childNodes": (),
        "QDomNode.clear": (),
        "QDomNode.cloneNode": ('bool',),
        "QDomNode.columnNumber": (),
        "QDomNode.firstChild": (),
        "QDomNode.firstChildElement": ('str',),
        "QDomNode.hasAttributes": (),
        "QDomNode.hasChildNodes": (),
        "QDomNode.insertAfter": ('PySide2.QtXml.QDomNode', 'PySide2.QtXml.QDomNode'),
        "QDomNode.insertBefore": ('PySide2.QtXml.QDomNode', 'PySide2.QtXml.QDomNode'),
        "QDomNode.isAttr": (),
        "QDomNode.isCDATASection": (),
        "QDomNode.isCharacterData": (),
        "QDomNode.isComment": (),
        "QDomNode.isDocument": (),
        "QDomNode.isDocumentFragment": (),
        "QDomNode.isDocumentType": (),
        "QDomNode.isElement": (),
        "QDomNode.isEntity": (),
        "QDomNode.isEntityReference": (),
        "QDomNode.isNotation": (),
        "QDomNode.isNull": (),
        "QDomNode.isProcessingInstruction": (),
        "QDomNode.isSupported": ('str', 'str'),
        "QDomNode.isText": (),
        "QDomNode.lastChild": (),
        "QDomNode.lastChildElement": ('str',),
        "QDomNode.lineNumber": (),
        "QDomNode.localName": (),
        "QDomNode.namedItem": ('str',),
        "QDomNode.namespaceURI": (),
        "QDomNode.nextSibling": (),
        "QDomNode.nextSiblingElement": ('str',),
        "QDomNode.nodeName": (),
        "QDomNode.nodeType": (),
        "QDomNode.nodeValue": (),
        "QDomNode.normalize": (),
        "QDomNode.ownerDocument": (),
        "QDomNode.parentNode": (),
        "QDomNode.prefix": (),
        "QDomNode.previousSibling": (),
        "QDomNode.previousSiblingElement": ('str',),
        "QDomNode.removeChild": ('PySide2.QtXml.QDomNode',),
        "QDomNode.replaceChild": ('PySide2.QtXml.QDomNode', 'PySide2.QtXml.QDomNode'),
        "QDomNode.save": ('PySide2.QtCore.QTextStream', 'int', 'PySide2.QtXml.QDomNode.EncodingPolicy'),
        "QDomNode.setNodeValue": ('str',),
        "QDomNode.setPrefix": ('str',),
        "QDomNode.toAttr": (),
        "QDomNode.toCDATASection": (),
        "QDomNode.toCharacterData": (),
        "QDomNode.toComment": (),
        "QDomNode.toDocument": (),
        "QDomNode.toDocumentFragment": (),
        "QDomNode.toDocumentType": (),
        "QDomNode.toElement": (),
        "QDomNode.toEntity": (),
        "QDomNode.toEntityReference": (),
        "QDomNode.toNotation": (),
        "QDomNode.toProcessingInstruction": (),
        "QDomNode.toText": (),

    # class PySide2.QtXml.QDomNodeList:
        "QDomNodeList.__init__": [(), ('PySide2.QtXml.QDomNodeList',)],
        "QDomNodeList.__copy__": (),
        "QDomNodeList.at": ('int',),
        "QDomNodeList.count": (),
        "QDomNodeList.isEmpty": (),
        "QDomNodeList.item": ('int',),
        "QDomNodeList.length": (),
        "QDomNodeList.size": (),

    # class PySide2.QtXml.QDomNotation:
        "QDomNotation.__init__": [(), ('PySide2.QtXml.QDomNotation',)],
        "QDomNotation.__copy__": (),
        "QDomNotation.nodeType": (),
        "QDomNotation.publicId": (),
        "QDomNotation.systemId": (),

    # class PySide2.QtXml.QDomProcessingInstruction:
        "QDomProcessingInstruction.__init__": [(), ('PySide2.QtXml.QDomProcessingInstruction',)],
        "QDomProcessingInstruction.__copy__": (),
        "QDomProcessingInstruction.data": (),
        "QDomProcessingInstruction.nodeType": (),
        "QDomProcessingInstruction.setData": ('str',),
        "QDomProcessingInstruction.target": (),

    # class PySide2.QtXml.QDomText:
        "QDomText.__init__": [(), ('PySide2.QtXml.QDomText',)],
        "QDomText.__copy__": (),
        "QDomText.nodeType": (),
        "QDomText.splitText": ('int',),

    # class PySide2.QtXml.QXmlAttributes:
        "QXmlAttributes.__init__": [(), ('PySide2.QtXml.QXmlAttributes',)],
        "QXmlAttributes.__copy__": (),
        "QXmlAttributes.append": ('str', 'str', 'str', 'str'),
        "QXmlAttributes.clear": (),
        "QXmlAttributes.count": (),
        "QXmlAttributes.index": [('str',), ('str', 'str')],
        "QXmlAttributes.length": (),
        "QXmlAttributes.localName": ('int',),
        "QXmlAttributes.qName": ('int',),
        "QXmlAttributes.swap": ('PySide2.QtXml.QXmlAttributes',),
        "QXmlAttributes.type": [('int',), ('str',), ('str', 'str')],
        "QXmlAttributes.uri": ('int',),
        "QXmlAttributes.value": [('int',), ('str',), ('str', 'str')],

    # class PySide2.QtXml.QXmlContentHandler:
        "QXmlContentHandler.__init__": (),
        "QXmlContentHandler.characters": ('str',),
        "QXmlContentHandler.endDocument": (),
        "QXmlContentHandler.endElement": ('str', 'str', 'str'),
        "QXmlContentHandler.endPrefixMapping": ('str',),
        "QXmlContentHandler.errorString": (),
        "QXmlContentHandler.ignorableWhitespace": ('str',),
        "QXmlContentHandler.processingInstruction": ('str', 'str'),
        "QXmlContentHandler.setDocumentLocator": ('PySide2.QtXml.QXmlLocator',),
        "QXmlContentHandler.skippedEntity": ('str',),
        "QXmlContentHandler.startDocument": (),
        "QXmlContentHandler.startElement": ('str', 'str', 'str', 'PySide2.QtXml.QXmlAttributes'),
        "QXmlContentHandler.startPrefixMapping": ('str', 'str'),

    # class PySide2.QtXml.QXmlDTDHandler:
        "QXmlDTDHandler.__init__": (),
        "QXmlDTDHandler.errorString": (),
        "QXmlDTDHandler.notationDecl": ('str', 'str', 'str'),
        "QXmlDTDHandler.unparsedEntityDecl": ('str', 'str', 'str', 'str'),

    # class PySide2.QtXml.QXmlDeclHandler:
        "QXmlDeclHandler.__init__": (),
        "QXmlDeclHandler.attributeDecl": ('str', 'str', 'str', 'str', 'str'),
        "QXmlDeclHandler.errorString": (),
        "QXmlDeclHandler.externalEntityDecl": ('str', 'str', 'str'),
        "QXmlDeclHandler.internalEntityDecl": ('str', 'str'),

    # class PySide2.QtXml.QXmlDefaultHandler:
        "QXmlDefaultHandler.__init__": (),
        "QXmlDefaultHandler.attributeDecl": ('str', 'str', 'str', 'str', 'str'),
        "QXmlDefaultHandler.characters": ('str',),
        "QXmlDefaultHandler.comment": ('str',),
        "QXmlDefaultHandler.endCDATA": (),
        "QXmlDefaultHandler.endDTD": (),
        "QXmlDefaultHandler.endDocument": (),
        "QXmlDefaultHandler.endElement": ('str', 'str', 'str'),
        "QXmlDefaultHandler.endEntity": ('str',),
        "QXmlDefaultHandler.endPrefixMapping": ('str',),
        "QXmlDefaultHandler.error": ('PySide2.QtXml.QXmlParseException',),
        "QXmlDefaultHandler.errorString": (),
        "QXmlDefaultHandler.externalEntityDecl": ('str', 'str', 'str'),
        "QXmlDefaultHandler.fatalError": ('PySide2.QtXml.QXmlParseException',),
        "QXmlDefaultHandler.ignorableWhitespace": ('str',),
        "QXmlDefaultHandler.internalEntityDecl": ('str', 'str'),
        "QXmlDefaultHandler.notationDecl": ('str', 'str', 'str'),
        "QXmlDefaultHandler.processingInstruction": ('str', 'str'),
        "QXmlDefaultHandler.resolveEntity": ('str', 'str', 'PySide2.QtXml.QXmlInputSource'),
        "QXmlDefaultHandler.setDocumentLocator": ('PySide2.QtXml.QXmlLocator',),
        "QXmlDefaultHandler.skippedEntity": ('str',),
        "QXmlDefaultHandler.startCDATA": (),
        "QXmlDefaultHandler.startDTD": ('str', 'str', 'str'),
        "QXmlDefaultHandler.startDocument": (),
        "QXmlDefaultHandler.startElement": ('str', 'str', 'str', 'PySide2.QtXml.QXmlAttributes'),
        "QXmlDefaultHandler.startEntity": ('str',),
        "QXmlDefaultHandler.startPrefixMapping": ('str', 'str'),
        "QXmlDefaultHandler.unparsedEntityDecl": ('str', 'str', 'str', 'str'),
        "QXmlDefaultHandler.warning": ('PySide2.QtXml.QXmlParseException',),

    # class PySide2.QtXml.QXmlEntityResolver:
        "QXmlEntityResolver.__init__": (),
        "QXmlEntityResolver.errorString": (),
        "QXmlEntityResolver.resolveEntity": ('str', 'str', 'PySide2.QtXml.QXmlInputSource'),

    # class PySide2.QtXml.QXmlErrorHandler:
        "QXmlErrorHandler.__init__": (),
        "QXmlErrorHandler.error": ('PySide2.QtXml.QXmlParseException',),
        "QXmlErrorHandler.errorString": (),
        "QXmlErrorHandler.fatalError": ('PySide2.QtXml.QXmlParseException',),
        "QXmlErrorHandler.warning": ('PySide2.QtXml.QXmlParseException',),

    # class PySide2.QtXml.QXmlInputSource:
        "QXmlInputSource.__init__": [(), ('PySide2.QtCore.QIODevice',)],
        "QXmlInputSource.data": (),
        "QXmlInputSource.fetchData": (),
        "QXmlInputSource.fromRawData": ('PySide2.QtCore.QByteArray', 'bool'),
        "QXmlInputSource.reset": (),
        "QXmlInputSource.setData": [('PySide2.QtCore.QByteArray',), ('str',)],

    # class PySide2.QtXml.QXmlLexicalHandler:
        "QXmlLexicalHandler.__init__": (),
        "QXmlLexicalHandler.comment": ('str',),
        "QXmlLexicalHandler.endCDATA": (),
        "QXmlLexicalHandler.endDTD": (),
        "QXmlLexicalHandler.endEntity": ('str',),
        "QXmlLexicalHandler.errorString": (),
        "QXmlLexicalHandler.startCDATA": (),
        "QXmlLexicalHandler.startDTD": ('str', 'str', 'str'),
        "QXmlLexicalHandler.startEntity": ('str',),

    # class PySide2.QtXml.QXmlLocator:
        "QXmlLocator.__init__": (),
        "QXmlLocator.columnNumber": (),
        "QXmlLocator.lineNumber": (),

    # class PySide2.QtXml.QXmlNamespaceSupport:
        "QXmlNamespaceSupport.__init__": (),
        "QXmlNamespaceSupport.popContext": (),
        "QXmlNamespaceSupport.prefix": ('str',),
        "QXmlNamespaceSupport.prefixes": [(), ('str',)],
        "QXmlNamespaceSupport.processName": ('str', 'bool', 'str', 'str'),
        "QXmlNamespaceSupport.pushContext": (),
        "QXmlNamespaceSupport.reset": (),
        "QXmlNamespaceSupport.setPrefix": ('str', 'str'),
        "QXmlNamespaceSupport.splitName": ('str', 'str', 'str'),
        "QXmlNamespaceSupport.uri": ('str',),

    # class PySide2.QtXml.QXmlParseException:
        "QXmlParseException.__init__": [('PySide2.QtXml.QXmlParseException',), ('str', 'int', 'int', 'str', 'str')],
        "QXmlParseException.columnNumber": (),
        "QXmlParseException.lineNumber": (),
        "QXmlParseException.message": (),
        "QXmlParseException.publicId": (),
        "QXmlParseException.systemId": (),

    # class PySide2.QtXml.QXmlReader:
        "QXmlReader.__init__": (),
        "QXmlReader.DTDHandler": (),
        "QXmlReader.contentHandler": (),
        "QXmlReader.declHandler": (),
        "QXmlReader.entityResolver": (),
        "QXmlReader.errorHandler": (),
        "QXmlReader.feature": ('str', 'bool'),
        "QXmlReader.hasFeature": ('str',),
        "QXmlReader.hasProperty": ('str',),
        "QXmlReader.lexicalHandler": (),
        "QXmlReader.parse": ('PySide2.QtXml.QXmlInputSource',),
        "QXmlReader.property": ('str', 'bool'),
        "QXmlReader.setContentHandler": ('PySide2.QtXml.QXmlContentHandler',),
        "QXmlReader.setDTDHandler": ('PySide2.QtXml.QXmlDTDHandler',),
        "QXmlReader.setDeclHandler": ('PySide2.QtXml.QXmlDeclHandler',),
        "QXmlReader.setEntityResolver": ('PySide2.QtXml.QXmlEntityResolver',),
        "QXmlReader.setErrorHandler": ('PySide2.QtXml.QXmlErrorHandler',),
        "QXmlReader.setFeature": ('str', 'bool'),
        "QXmlReader.setLexicalHandler": ('PySide2.QtXml.QXmlLexicalHandler',),
        "QXmlReader.setProperty": ('str', 'int'),

    # class PySide2.QtXml.QXmlSimpleReader:
        "QXmlSimpleReader.__init__": (),
        "QXmlSimpleReader.DTDHandler": (),
        "QXmlSimpleReader.contentHandler": (),
        "QXmlSimpleReader.declHandler": (),
        "QXmlSimpleReader.entityResolver": (),
        "QXmlSimpleReader.errorHandler": (),
        "QXmlSimpleReader.feature": ('str', 'bool'),
        "QXmlSimpleReader.hasFeature": ('str',),
        "QXmlSimpleReader.hasProperty": ('str',),
        "QXmlSimpleReader.lexicalHandler": (),
        "QXmlSimpleReader.parse": [('PySide2.QtXml.QXmlInputSource',), ('PySide2.QtXml.QXmlInputSource', 'bool')],
        "QXmlSimpleReader.parseContinue": (),
        "QXmlSimpleReader.property": ('str', 'bool'),
        "QXmlSimpleReader.setContentHandler": ('PySide2.QtXml.QXmlContentHandler',),
        "QXmlSimpleReader.setDTDHandler": ('PySide2.QtXml.QXmlDTDHandler',),
        "QXmlSimpleReader.setDeclHandler": ('PySide2.QtXml.QXmlDeclHandler',),
        "QXmlSimpleReader.setEntityResolver": ('PySide2.QtXml.QXmlEntityResolver',),
        "QXmlSimpleReader.setErrorHandler": ('PySide2.QtXml.QXmlErrorHandler',),
        "QXmlSimpleReader.setFeature": ('str', 'bool'),
        "QXmlSimpleReader.setLexicalHandler": ('PySide2.QtXml.QXmlLexicalHandler',),
        "QXmlSimpleReader.setProperty": ('str', 'int'),
    })

# Module PySide2.QtXmlPatterns
if "PySide2.QtXmlPatterns" in sys.modules:
    dict.update({

    # class PySide2.QtXmlPatterns.QAbstractMessageHandler:
        "QAbstractMessageHandler.__init__": ('PySide2.QtCore.QObject',),
        "QAbstractMessageHandler.handleMessage": ('PySide2.QtCore.QtMsgType', 'str', 'PySide2.QtCore.QUrl', 'PySide2.QtXmlPatterns.QSourceLocation'),
        "QAbstractMessageHandler.message": ('PySide2.QtCore.QtMsgType', 'str', 'PySide2.QtCore.QUrl', 'PySide2.QtXmlPatterns.QSourceLocation'),

    # class PySide2.QtXmlPatterns.QAbstractUriResolver:
        "QAbstractUriResolver.__init__": ('PySide2.QtCore.QObject',),
        "QAbstractUriResolver.resolve": ('PySide2.QtCore.QUrl', 'PySide2.QtCore.QUrl'),

    # class PySide2.QtXmlPatterns.QAbstractXmlNodeModel:
        "QAbstractXmlNodeModel.__init__": (),
        "QAbstractXmlNodeModel.attributes": ('PySide2.QtXmlPatterns.QXmlNodeModelIndex',),
        "QAbstractXmlNodeModel.baseUri": ('PySide2.QtXmlPatterns.QXmlNodeModelIndex',),
        "QAbstractXmlNodeModel.compareOrder": ('PySide2.QtXmlPatterns.QXmlNodeModelIndex', 'PySide2.QtXmlPatterns.QXmlNodeModelIndex'),
        "QAbstractXmlNodeModel.createIndex": [('int',), ('int', 'int')],
        "QAbstractXmlNodeModel.documentUri": ('PySide2.QtXmlPatterns.QXmlNodeModelIndex',),
        "QAbstractXmlNodeModel.elementById": ('PySide2.QtXmlPatterns.QXmlName',),
        "QAbstractXmlNodeModel.isDeepEqual": ('PySide2.QtXmlPatterns.QXmlNodeModelIndex', 'PySide2.QtXmlPatterns.QXmlNodeModelIndex'),
        "QAbstractXmlNodeModel.kind": ('PySide2.QtXmlPatterns.QXmlNodeModelIndex',),
        "QAbstractXmlNodeModel.name": ('PySide2.QtXmlPatterns.QXmlNodeModelIndex',),
        "QAbstractXmlNodeModel.namespaceBindings": ('PySide2.QtXmlPatterns.QXmlNodeModelIndex',),
        "QAbstractXmlNodeModel.namespaceForPrefix": ('PySide2.QtXmlPatterns.QXmlNodeModelIndex', 'Missing("PySide2.QtXmlPatterns.QXmlName.PrefixCode")'),
        "QAbstractXmlNodeModel.nextFromSimpleAxis": ('PySide2.QtXmlPatterns.QAbstractXmlNodeModel.SimpleAxis', 'PySide2.QtXmlPatterns.QXmlNodeModelIndex'),
        "QAbstractXmlNodeModel.nodesByIdref": ('PySide2.QtXmlPatterns.QXmlName',),
        "QAbstractXmlNodeModel.root": ('PySide2.QtXmlPatterns.QXmlNodeModelIndex',),
        "QAbstractXmlNodeModel.sendNamespaces": ('PySide2.QtXmlPatterns.QXmlNodeModelIndex', 'PySide2.QtXmlPatterns.QAbstractXmlReceiver'),
        "QAbstractXmlNodeModel.sourceLocation": ('PySide2.QtXmlPatterns.QXmlNodeModelIndex',),
        "QAbstractXmlNodeModel.stringValue": ('PySide2.QtXmlPatterns.QXmlNodeModelIndex',),
        "QAbstractXmlNodeModel.typedValue": ('PySide2.QtXmlPatterns.QXmlNodeModelIndex',),

    # class PySide2.QtXmlPatterns.QAbstractXmlReceiver:
        "QAbstractXmlReceiver.__init__": (),
        "QAbstractXmlReceiver.atomicValue": ('typing.Any',),
        "QAbstractXmlReceiver.attribute": ('PySide2.QtXmlPatterns.QXmlName', 'str'),
        "QAbstractXmlReceiver.characters": ('str',),
        "QAbstractXmlReceiver.comment": ('str',),
        "QAbstractXmlReceiver.endDocument": (),
        "QAbstractXmlReceiver.endElement": (),
        "QAbstractXmlReceiver.endOfSequence": (),
        "QAbstractXmlReceiver.namespaceBinding": ('PySide2.QtXmlPatterns.QXmlName',),
        "QAbstractXmlReceiver.processingInstruction": ('PySide2.QtXmlPatterns.QXmlName', 'str'),
        "QAbstractXmlReceiver.startDocument": (),
        "QAbstractXmlReceiver.startElement": ('PySide2.QtXmlPatterns.QXmlName',),
        "QAbstractXmlReceiver.startOfSequence": (),
        "QAbstractXmlReceiver.whitespaceOnly": ('str',),

    # class PySide2.QtXmlPatterns.QSourceLocation:
        "QSourceLocation.__init__": [(), ('PySide2.QtCore.QUrl', 'int', 'int'), ('PySide2.QtXmlPatterns.QSourceLocation',)],
        "QSourceLocation.__copy__": (),
        "QSourceLocation.column": (),
        "QSourceLocation.isNull": (),
        "QSourceLocation.line": (),
        "QSourceLocation.setColumn": ('int',),
        "QSourceLocation.setLine": ('int',),
        "QSourceLocation.setUri": ('PySide2.QtCore.QUrl',),
        "QSourceLocation.uri": (),

    # class PySide2.QtXmlPatterns.QXmlFormatter:
        "QXmlFormatter.__init__": ('PySide2.QtXmlPatterns.QXmlQuery', 'PySide2.QtCore.QIODevice'),
        "QXmlFormatter.atomicValue": ('typing.Any',),
        "QXmlFormatter.attribute": ('PySide2.QtXmlPatterns.QXmlName', 'str'),
        "QXmlFormatter.characters": ('str',),
        "QXmlFormatter.comment": ('str',),
        "QXmlFormatter.endDocument": (),
        "QXmlFormatter.endElement": (),
        "QXmlFormatter.endOfSequence": (),
        "QXmlFormatter.indentationDepth": (),
        "QXmlFormatter.processingInstruction": ('PySide2.QtXmlPatterns.QXmlName', 'str'),
        "QXmlFormatter.setIndentationDepth": ('int',),
        "QXmlFormatter.startDocument": (),
        "QXmlFormatter.startElement": ('PySide2.QtXmlPatterns.QXmlName',),
        "QXmlFormatter.startOfSequence": (),

    # class PySide2.QtXmlPatterns.QXmlItem:
        "QXmlItem.__init__": [(), ('PySide2.QtXmlPatterns.QXmlItem',), ('PySide2.QtXmlPatterns.QXmlNodeModelIndex',), ('typing.Any',)],
        "QXmlItem.__copy__": (),
        "QXmlItem.isAtomicValue": (),
        "QXmlItem.isNode": (),
        "QXmlItem.isNull": (),
        "QXmlItem.toAtomicValue": (),
        "QXmlItem.toNodeModelIndex": (),

    # class PySide2.QtXmlPatterns.QXmlName:
        "QXmlName.__init__": [(), ('PySide2.QtXmlPatterns.QXmlName',), ('PySide2.QtXmlPatterns.QXmlNamePool', 'str', 'str', 'str')],
        "QXmlName.__copy__": (),
        "QXmlName.fromClarkName": ('str', 'PySide2.QtXmlPatterns.QXmlNamePool'),
        "QXmlName.isNCName": ('str',),
        "QXmlName.isNull": (),
        "QXmlName.localName": ('PySide2.QtXmlPatterns.QXmlNamePool',),
        "QXmlName.namespaceUri": ('PySide2.QtXmlPatterns.QXmlNamePool',),
        "QXmlName.prefix": ('PySide2.QtXmlPatterns.QXmlNamePool',),
        "QXmlName.toClarkName": ('PySide2.QtXmlPatterns.QXmlNamePool',),

    # class PySide2.QtXmlPatterns.QXmlNamePool:
        "QXmlNamePool.__init__": [(), ('PySide2.QtXmlPatterns.QXmlNamePool',)],
        "QXmlNamePool.__copy__": (),

    # class PySide2.QtXmlPatterns.QXmlNodeModelIndex:
        "QXmlNodeModelIndex.__init__": [(), ('PySide2.QtXmlPatterns.QXmlNodeModelIndex',)],
        "QXmlNodeModelIndex.__copy__": (),
        "QXmlNodeModelIndex.additionalData": (),
        "QXmlNodeModelIndex.data": (),
        "QXmlNodeModelIndex.internalPointer": (),
        "QXmlNodeModelIndex.isNull": (),
        "QXmlNodeModelIndex.model": (),

    # class PySide2.QtXmlPatterns.QXmlQuery:
        "QXmlQuery.__init__": [(), ('PySide2.QtXmlPatterns.QXmlNamePool',), ('PySide2.QtXmlPatterns.QXmlQuery',), ('PySide2.QtXmlPatterns.QXmlQuery.QueryLanguage', 'PySide2.QtXmlPatterns.QXmlNamePool')],
        "QXmlQuery.__copy__": (),
        "QXmlQuery.bindVariable": [('PySide2.QtXmlPatterns.QXmlName', 'PySide2.QtCore.QIODevice'), ('PySide2.QtXmlPatterns.QXmlName', 'PySide2.QtXmlPatterns.QXmlItem'), ('PySide2.QtXmlPatterns.QXmlName', 'PySide2.QtXmlPatterns.QXmlQuery'), ('str', 'PySide2.QtCore.QIODevice'), ('str', 'PySide2.QtXmlPatterns.QXmlItem'), ('str', 'PySide2.QtXmlPatterns.QXmlQuery')],
        "QXmlQuery.evaluateTo": [('PySide2.QtCore.QIODevice',), ('PySide2.QtXmlPatterns.QAbstractXmlReceiver',), ('PySide2.QtXmlPatterns.QXmlResultItems',)],
        "QXmlQuery.initialTemplateName": (),
        "QXmlQuery.isValid": (),
        "QXmlQuery.messageHandler": (),
        "QXmlQuery.namePool": (),
        "QXmlQuery.queryLanguage": (),
        "QXmlQuery.setFocus": [('PySide2.QtCore.QIODevice',), ('PySide2.QtCore.QUrl',), ('PySide2.QtXmlPatterns.QXmlItem',), ('str',)],
        "QXmlQuery.setInitialTemplateName": [('PySide2.QtXmlPatterns.QXmlName',), ('str',)],
        "QXmlQuery.setMessageHandler": ('PySide2.QtXmlPatterns.QAbstractMessageHandler',),
        "QXmlQuery.setQuery": [('PySide2.QtCore.QIODevice', 'PySide2.QtCore.QUrl'), ('PySide2.QtCore.QUrl', 'PySide2.QtCore.QUrl'), ('str', 'PySide2.QtCore.QUrl')],
        "QXmlQuery.setUriResolver": ('PySide2.QtXmlPatterns.QAbstractUriResolver',),
        "QXmlQuery.uriResolver": (),

    # class PySide2.QtXmlPatterns.QXmlResultItems:
        "QXmlResultItems.__init__": (),
        "QXmlResultItems.current": (),
        "QXmlResultItems.hasError": (),

    # class PySide2.QtXmlPatterns.QXmlSchema:
        "QXmlSchema.__init__": [(), ('PySide2.QtXmlPatterns.QXmlSchema',)],
        "QXmlSchema.documentUri": (),
        "QXmlSchema.isValid": (),
        "QXmlSchema.load": [('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QUrl'), ('PySide2.QtCore.QIODevice', 'PySide2.QtCore.QUrl'), ('PySide2.QtCore.QUrl',)],
        "QXmlSchema.messageHandler": (),
        "QXmlSchema.namePool": (),
        "QXmlSchema.setMessageHandler": ('PySide2.QtXmlPatterns.QAbstractMessageHandler',),
        "QXmlSchema.setUriResolver": ('PySide2.QtXmlPatterns.QAbstractUriResolver',),
        "QXmlSchema.uriResolver": (),

    # class PySide2.QtXmlPatterns.QXmlSchemaValidator:
        "QXmlSchemaValidator.__init__": [(), ('PySide2.QtXmlPatterns.QXmlSchema',)],
        "QXmlSchemaValidator.messageHandler": (),
        "QXmlSchemaValidator.namePool": (),
        "QXmlSchemaValidator.schema": (),
        "QXmlSchemaValidator.setMessageHandler": ('PySide2.QtXmlPatterns.QAbstractMessageHandler',),
        "QXmlSchemaValidator.setSchema": ('PySide2.QtXmlPatterns.QXmlSchema',),
        "QXmlSchemaValidator.setUriResolver": ('PySide2.QtXmlPatterns.QAbstractUriResolver',),
        "QXmlSchemaValidator.uriResolver": (),
        "QXmlSchemaValidator.validate": [('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QUrl'), ('PySide2.QtCore.QIODevice', 'PySide2.QtCore.QUrl'), ('PySide2.QtCore.QUrl',)],

    # class PySide2.QtXmlPatterns.QXmlSerializer:
        "QXmlSerializer.__init__": ('PySide2.QtXmlPatterns.QXmlQuery', 'PySide2.QtCore.QIODevice'),
        "QXmlSerializer.atomicValue": ('typing.Any',),
        "QXmlSerializer.attribute": ('PySide2.QtXmlPatterns.QXmlName', 'str'),
        "QXmlSerializer.characters": ('str',),
        "QXmlSerializer.codec": (),
        "QXmlSerializer.comment": ('str',),
        "QXmlSerializer.endDocument": (),
        "QXmlSerializer.endElement": (),
        "QXmlSerializer.endOfSequence": (),
        "QXmlSerializer.namespaceBinding": ('PySide2.QtXmlPatterns.QXmlName',),
        "QXmlSerializer.outputDevice": (),
        "QXmlSerializer.processingInstruction": ('PySide2.QtXmlPatterns.QXmlName', 'str'),
        "QXmlSerializer.setCodec": ('PySide2.QtCore.QTextCodec',),
        "QXmlSerializer.startDocument": (),
        "QXmlSerializer.startElement": ('PySide2.QtXmlPatterns.QXmlName',),
        "QXmlSerializer.startOfSequence": (),
    })

# Module PySide2.QtHelp
if "PySide2.QtHelp" in sys.modules:
    dict.update({

    # class PySide2.QtHelp.QHelpContentItem:
        "QHelpContentItem.__copy__": (),
        "QHelpContentItem.child": ('int',),
        "QHelpContentItem.childCount": (),
        "QHelpContentItem.childPosition": ('PySide2.QtHelp.QHelpContentItem',),
        "QHelpContentItem.parent": (),
        "QHelpContentItem.row": (),
        "QHelpContentItem.title": (),
        "QHelpContentItem.url": (),

    # class PySide2.QtHelp.QHelpContentModel:
        "QHelpContentModel.columnCount": ('PySide2.QtCore.QModelIndex',),
        "QHelpContentModel.contentItemAt": ('PySide2.QtCore.QModelIndex',),
        "QHelpContentModel.createContents": ('str',),
        "QHelpContentModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
        "QHelpContentModel.index": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
        "QHelpContentModel.isCreatingContents": (),
        "QHelpContentModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
        "QHelpContentModel.rowCount": ('PySide2.QtCore.QModelIndex',),

    # class PySide2.QtHelp.QHelpContentWidget:
        "QHelpContentWidget.indexOf": ('PySide2.QtCore.QUrl',),

    # class PySide2.QtHelp.QHelpEngine:
        "QHelpEngine.__init__": ('str', 'PySide2.QtCore.QObject'),
        "QHelpEngine.contentModel": (),
        "QHelpEngine.contentWidget": (),
        "QHelpEngine.indexModel": (),
        "QHelpEngine.indexWidget": (),
        "QHelpEngine.searchEngine": (),

    # class PySide2.QtHelp.QHelpEngineCore:
        "QHelpEngineCore.__init__": ('str', 'PySide2.QtCore.QObject'),
        "QHelpEngineCore.addCustomFilter": ('str', 'typing.List[str]'),
        "QHelpEngineCore.autoSaveFilter": (),
        "QHelpEngineCore.collectionFile": (),
        "QHelpEngineCore.copyCollectionFile": ('str',),
        "QHelpEngineCore.currentFilter": (),
        "QHelpEngineCore.customFilters": (),
        "QHelpEngineCore.customValue": ('str', 'typing.Any'),
        "QHelpEngineCore.documentationFileName": ('str',),
        "QHelpEngineCore.error": (),
        "QHelpEngineCore.fileData": ('PySide2.QtCore.QUrl',),
        "QHelpEngineCore.files": ('str', 'typing.List[str]', 'str'),
        "QHelpEngineCore.filterAttributeSets": ('str',),
        "QHelpEngineCore.filterAttributes": [(), ('str',)],
        "QHelpEngineCore.findFile": ('PySide2.QtCore.QUrl',),
        "QHelpEngineCore.linksForIdentifier": ('str',),
        "QHelpEngineCore.linksForKeyword": ('str',),
        "QHelpEngineCore.metaData": ('str', 'str'),
        "QHelpEngineCore.namespaceName": ('str',),
        "QHelpEngineCore.registerDocumentation": ('str',),
        "QHelpEngineCore.registeredDocumentations": (),
        "QHelpEngineCore.removeCustomFilter": ('str',),
        "QHelpEngineCore.removeCustomValue": ('str',),
        "QHelpEngineCore.setAutoSaveFilter": ('bool',),
        "QHelpEngineCore.setCollectionFile": ('str',),
        "QHelpEngineCore.setCurrentFilter": ('str',),
        "QHelpEngineCore.setCustomValue": ('str', 'typing.Any'),
        "QHelpEngineCore.setupData": (),
        "QHelpEngineCore.unregisterDocumentation": ('str',),

    # class PySide2.QtHelp.QHelpIndexModel:
        "QHelpIndexModel.createIndex": [('int', 'int', 'int'), ('int', 'int', 'object'), ('str',)],
        "QHelpIndexModel.filter": ('str', 'str'),
        "QHelpIndexModel.isCreatingIndex": (),
        "QHelpIndexModel.linksForKeyword": ('str',),

    # class PySide2.QtHelp.QHelpIndexWidget:
        "QHelpIndexWidget.activateCurrentItem": (),
        "QHelpIndexWidget.filterIndices": ('str', 'str'),

    # class PySide2.QtHelp.QHelpSearchEngine:
        "QHelpSearchEngine.__init__": ('PySide2.QtHelp.QHelpEngineCore', 'PySide2.QtCore.QObject'),
        "QHelpSearchEngine.cancelIndexing": (),
        "QHelpSearchEngine.cancelSearching": (),
        "QHelpSearchEngine.hitCount": (),
        "QHelpSearchEngine.hits": ('int', 'int'),
        "QHelpSearchEngine.hitsCount": (),
        "QHelpSearchEngine.query": (),
        "QHelpSearchEngine.queryWidget": (),
        "QHelpSearchEngine.reindexDocumentation": (),
        "QHelpSearchEngine.resultWidget": (),
        "QHelpSearchEngine.scheduleIndexDocumentation": (),
        "QHelpSearchEngine.search": [('list',), ('str',)],
        "QHelpSearchEngine.searchInput": (),
        "QHelpSearchEngine.searchResultCount": (),
        "QHelpSearchEngine.searchResults": ('int', 'int'),

    # class PySide2.QtHelp.QHelpSearchQuery:
        "QHelpSearchQuery.__init__": [(), ('PySide2.QtHelp.QHelpSearchQuery',), ('PySide2.QtHelp.QHelpSearchQuery.FieldName', 'typing.List[str]')],
        "QHelpSearchQuery.__copy__": (),

    # class PySide2.QtHelp.QHelpSearchQueryWidget:
        "QHelpSearchQueryWidget.__init__": ('PySide2.QtWidgets.QWidget',),
        "QHelpSearchQueryWidget.changeEvent": ('PySide2.QtCore.QEvent',),
        "QHelpSearchQueryWidget.collapseExtendedSearch": (),
        "QHelpSearchQueryWidget.expandExtendedSearch": (),
        "QHelpSearchQueryWidget.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
        "QHelpSearchQueryWidget.isCompactMode": (),
        "QHelpSearchQueryWidget.query": (),
        "QHelpSearchQueryWidget.searchInput": (),
        "QHelpSearchQueryWidget.setCompactMode": ('bool',),
        "QHelpSearchQueryWidget.setQuery": ('list',),
        "QHelpSearchQueryWidget.setSearchInput": ('str',),

    # class PySide2.QtHelp.QHelpSearchResult:
        "QHelpSearchResult.__init__": [(), ('PySide2.QtCore.QUrl', 'str', 'str'), ('PySide2.QtHelp.QHelpSearchResult',)],
        "QHelpSearchResult.snippet": (),
        "QHelpSearchResult.title": (),
        "QHelpSearchResult.url": (),

    # class PySide2.QtHelp.QHelpSearchResultWidget:
        "QHelpSearchResultWidget.changeEvent": ('PySide2.QtCore.QEvent',),
        "QHelpSearchResultWidget.linkAt": ('PySide2.QtCore.QPoint',),
    })

# Module PySide2.QtMultimedia
if "PySide2.QtMultimedia" in sys.modules:
    dict.update({

    # class PySide2.QtMultimedia.QAbstractAudioDeviceInfo:
        "QAbstractAudioDeviceInfo.__init__": (),
        "QAbstractAudioDeviceInfo.deviceName": (),
        "QAbstractAudioDeviceInfo.isFormatSupported": ('PySide2.QtMultimedia.QAudioFormat',),
        "QAbstractAudioDeviceInfo.preferredFormat": (),
        "QAbstractAudioDeviceInfo.supportedByteOrders": (),
        "QAbstractAudioDeviceInfo.supportedChannelCounts": (),
        "QAbstractAudioDeviceInfo.supportedCodecs": (),
        "QAbstractAudioDeviceInfo.supportedSampleRates": (),
        "QAbstractAudioDeviceInfo.supportedSampleSizes": (),
        "QAbstractAudioDeviceInfo.supportedSampleTypes": (),

    # class PySide2.QtMultimedia.QAbstractAudioInput:
        "QAbstractAudioInput.__init__": (),
        "QAbstractAudioInput.bufferSize": (),
        "QAbstractAudioInput.bytesReady": (),
        "QAbstractAudioInput.elapsedUSecs": (),
        "QAbstractAudioInput.error": (),
        "QAbstractAudioInput.format": (),
        "QAbstractAudioInput.notifyInterval": (),
        "QAbstractAudioInput.periodSize": (),
        "QAbstractAudioInput.processedUSecs": (),
        "QAbstractAudioInput.reset": (),
        "QAbstractAudioInput.resume": (),
        "QAbstractAudioInput.setBufferSize": ('int',),
        "QAbstractAudioInput.setFormat": ('PySide2.QtMultimedia.QAudioFormat',),
        "QAbstractAudioInput.setNotifyInterval": ('int',),
        "QAbstractAudioInput.setVolume": ('float',),
        "QAbstractAudioInput.start": [(), ('PySide2.QtCore.QIODevice',)],
        "QAbstractAudioInput.state": (),
        "QAbstractAudioInput.stop": (),
        "QAbstractAudioInput.suspend": (),
        "QAbstractAudioInput.volume": (),

    # class PySide2.QtMultimedia.QAbstractAudioOutput:
        "QAbstractAudioOutput.__init__": (),
        "QAbstractAudioOutput.bufferSize": (),
        "QAbstractAudioOutput.bytesFree": (),
        "QAbstractAudioOutput.category": (),
        "QAbstractAudioOutput.elapsedUSecs": (),
        "QAbstractAudioOutput.error": (),
        "QAbstractAudioOutput.format": (),
        "QAbstractAudioOutput.notifyInterval": (),
        "QAbstractAudioOutput.periodSize": (),
        "QAbstractAudioOutput.processedUSecs": (),
        "QAbstractAudioOutput.reset": (),
        "QAbstractAudioOutput.resume": (),
        "QAbstractAudioOutput.setBufferSize": ('int',),
        "QAbstractAudioOutput.setCategory": ('str',),
        "QAbstractAudioOutput.setFormat": ('PySide2.QtMultimedia.QAudioFormat',),
        "QAbstractAudioOutput.setNotifyInterval": ('int',),
        "QAbstractAudioOutput.setVolume": ('float',),
        "QAbstractAudioOutput.start": [(), ('PySide2.QtCore.QIODevice',)],
        "QAbstractAudioOutput.state": (),
        "QAbstractAudioOutput.stop": (),
        "QAbstractAudioOutput.suspend": (),
        "QAbstractAudioOutput.volume": (),

    # class PySide2.QtMultimedia.QAbstractVideoBuffer:
        "QAbstractVideoBuffer.__init__": ('PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType',),
        "QAbstractVideoBuffer.handle": (),
        "QAbstractVideoBuffer.handleType": (),
        "QAbstractVideoBuffer.mapMode": (),
        "QAbstractVideoBuffer.release": (),
        "QAbstractVideoBuffer.unmap": (),

    # class PySide2.QtMultimedia.QAbstractVideoFilter:
        "QAbstractVideoFilter.__init__": ('PySide2.QtCore.QObject',),
        "QAbstractVideoFilter.createFilterRunnable": (),
        "QAbstractVideoFilter.isActive": (),
        "QAbstractVideoFilter.setActive": ('bool',),

    # class PySide2.QtMultimedia.QAbstractVideoSurface:
        "QAbstractVideoSurface.__init__": ('PySide2.QtCore.QObject',),
        "QAbstractVideoSurface.error": (),
        "QAbstractVideoSurface.isActive": (),
        "QAbstractVideoSurface.isFormatSupported": ('PySide2.QtMultimedia.QVideoSurfaceFormat',),
        "QAbstractVideoSurface.nativeResolution": (),
        "QAbstractVideoSurface.nearestFormat": ('PySide2.QtMultimedia.QVideoSurfaceFormat',),
        "QAbstractVideoSurface.present": ('PySide2.QtMultimedia.QVideoFrame',),
        "QAbstractVideoSurface.setError": ('PySide2.QtMultimedia.QAbstractVideoSurface.Error',),
        "QAbstractVideoSurface.setNativeResolution": ('PySide2.QtCore.QSize',),
        "QAbstractVideoSurface.start": ('PySide2.QtMultimedia.QVideoSurfaceFormat',),
        "QAbstractVideoSurface.stop": (),
        "QAbstractVideoSurface.supportedPixelFormats": ('PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType',),
        "QAbstractVideoSurface.surfaceFormat": (),

    # class PySide2.QtMultimedia.QAudio:
        "QAudio.convertVolume": ('float', 'PySide2.QtMultimedia.QAudio.VolumeScale', 'PySide2.QtMultimedia.QAudio.VolumeScale'),

    # class PySide2.QtMultimedia.QAudioBuffer:
        "QAudioBuffer.__init__": [(), ('PySide2.QtCore.QByteArray', 'PySide2.QtMultimedia.QAudioFormat', 'int'), ('PySide2.QtMultimedia.QAudioBuffer',), ('int', 'PySide2.QtMultimedia.QAudioFormat', 'int')],
        "QAudioBuffer.__copy__": (),
        "QAudioBuffer.byteCount": (),
        "QAudioBuffer.constData": (),
        "QAudioBuffer.data": (),
        "QAudioBuffer.duration": (),
        "QAudioBuffer.format": (),
        "QAudioBuffer.frameCount": (),
        "QAudioBuffer.isValid": (),
        "QAudioBuffer.sampleCount": (),
        "QAudioBuffer.startTime": (),

    # class PySide2.QtMultimedia.QAudioDecoder:
        "QAudioDecoder.__init__": ('PySide2.QtCore.QObject',),
        "QAudioDecoder.audioFormat": (),
        "QAudioDecoder.bind": ('PySide2.QtCore.QObject',),
        "QAudioDecoder.bufferAvailable": (),
        "QAudioDecoder.duration": (),
        "QAudioDecoder.error": (),
        "QAudioDecoder.errorString": (),
        "QAudioDecoder.hasSupport": ('str', 'typing.List[str]'),
        "QAudioDecoder.position": (),
        "QAudioDecoder.read": (),
        "QAudioDecoder.setAudioFormat": ('PySide2.QtMultimedia.QAudioFormat',),
        "QAudioDecoder.setSourceDevice": ('PySide2.QtCore.QIODevice',),
        "QAudioDecoder.setSourceFilename": ('str',),
        "QAudioDecoder.sourceDevice": (),
        "QAudioDecoder.sourceFilename": (),
        "QAudioDecoder.start": (),
        "QAudioDecoder.state": (),
        "QAudioDecoder.stop": (),
        "QAudioDecoder.unbind": ('PySide2.QtCore.QObject',),

    # class PySide2.QtMultimedia.QAudioDecoderControl:
        "QAudioDecoderControl.__init__": ('PySide2.QtCore.QObject',),
        "QAudioDecoderControl.audioFormat": (),
        "QAudioDecoderControl.bufferAvailable": (),
        "QAudioDecoderControl.duration": (),
        "QAudioDecoderControl.position": (),
        "QAudioDecoderControl.read": (),
        "QAudioDecoderControl.setAudioFormat": ('PySide2.QtMultimedia.QAudioFormat',),
        "QAudioDecoderControl.setSourceDevice": ('PySide2.QtCore.QIODevice',),
        "QAudioDecoderControl.setSourceFilename": ('str',),
        "QAudioDecoderControl.sourceDevice": (),
        "QAudioDecoderControl.sourceFilename": (),
        "QAudioDecoderControl.start": (),
        "QAudioDecoderControl.state": (),
        "QAudioDecoderControl.stop": (),

    # class PySide2.QtMultimedia.QAudioDeviceInfo:
        "QAudioDeviceInfo.__init__": [(), ('PySide2.QtMultimedia.QAudioDeviceInfo',)],
        "QAudioDeviceInfo.__copy__": (),
        "QAudioDeviceInfo.availableDevices": ('PySide2.QtMultimedia.QAudio.Mode',),
        "QAudioDeviceInfo.defaultInputDevice": (),
        "QAudioDeviceInfo.defaultOutputDevice": (),
        "QAudioDeviceInfo.deviceName": (),
        "QAudioDeviceInfo.isFormatSupported": ('PySide2.QtMultimedia.QAudioFormat',),
        "QAudioDeviceInfo.isNull": (),
        "QAudioDeviceInfo.nearestFormat": ('PySide2.QtMultimedia.QAudioFormat',),
        "QAudioDeviceInfo.preferredFormat": (),
        "QAudioDeviceInfo.supportedByteOrders": (),
        "QAudioDeviceInfo.supportedChannelCounts": (),
        "QAudioDeviceInfo.supportedCodecs": (),
        "QAudioDeviceInfo.supportedSampleRates": (),
        "QAudioDeviceInfo.supportedSampleSizes": (),
        "QAudioDeviceInfo.supportedSampleTypes": (),

    # class PySide2.QtMultimedia.QAudioEncoderSettings:
        "QAudioEncoderSettings.__init__": [(), ('PySide2.QtMultimedia.QAudioEncoderSettings',)],
        "QAudioEncoderSettings.__copy__": (),
        "QAudioEncoderSettings.bitRate": (),
        "QAudioEncoderSettings.channelCount": (),
        "QAudioEncoderSettings.codec": (),
        "QAudioEncoderSettings.encodingMode": (),
        "QAudioEncoderSettings.encodingOption": ('str',),
        "QAudioEncoderSettings.encodingOptions": (),
        "QAudioEncoderSettings.isNull": (),
        "QAudioEncoderSettings.quality": (),
        "QAudioEncoderSettings.sampleRate": (),
        "QAudioEncoderSettings.setBitRate": ('int',),
        "QAudioEncoderSettings.setChannelCount": ('int',),
        "QAudioEncoderSettings.setCodec": ('str',),
        "QAudioEncoderSettings.setEncodingMode": ('PySide2.QtMultimedia.QMultimedia.EncodingMode',),
        "QAudioEncoderSettings.setEncodingOption": ('str', 'typing.Any'),
        "QAudioEncoderSettings.setEncodingOptions": ('dict',),
        "QAudioEncoderSettings.setQuality": ('PySide2.QtMultimedia.QMultimedia.EncodingQuality',),
        "QAudioEncoderSettings.setSampleRate": ('int',),

    # class PySide2.QtMultimedia.QAudioEncoderSettingsControl:
        "QAudioEncoderSettingsControl.__init__": ('PySide2.QtCore.QObject',),
        "QAudioEncoderSettingsControl.audioSettings": (),
        "QAudioEncoderSettingsControl.codecDescription": ('str',),
        "QAudioEncoderSettingsControl.setAudioSettings": ('PySide2.QtMultimedia.QAudioEncoderSettings',),
        "QAudioEncoderSettingsControl.supportedAudioCodecs": (),

    # class PySide2.QtMultimedia.QAudioFormat:
        "QAudioFormat.__init__": [(), ('PySide2.QtMultimedia.QAudioFormat',)],
        "QAudioFormat.__copy__": (),
        "QAudioFormat.byteOrder": (),
        "QAudioFormat.bytesForDuration": ('int',),
        "QAudioFormat.bytesForFrames": ('int',),
        "QAudioFormat.bytesPerFrame": (),
        "QAudioFormat.channelCount": (),
        "QAudioFormat.codec": (),
        "QAudioFormat.durationForBytes": ('int',),
        "QAudioFormat.durationForFrames": ('int',),
        "QAudioFormat.framesForBytes": ('int',),
        "QAudioFormat.framesForDuration": ('int',),
        "QAudioFormat.isValid": (),
        "QAudioFormat.sampleRate": (),
        "QAudioFormat.sampleSize": (),
        "QAudioFormat.sampleType": (),
        "QAudioFormat.setByteOrder": ('PySide2.QtMultimedia.QAudioFormat.Endian',),
        "QAudioFormat.setChannelCount": ('int',),
        "QAudioFormat.setCodec": ('str',),
        "QAudioFormat.setSampleRate": ('int',),
        "QAudioFormat.setSampleSize": ('int',),
        "QAudioFormat.setSampleType": ('PySide2.QtMultimedia.QAudioFormat.SampleType',),

    # class PySide2.QtMultimedia.QAudioInput:
        "QAudioInput.__init__": [('PySide2.QtMultimedia.QAudioDeviceInfo', 'PySide2.QtMultimedia.QAudioFormat', 'PySide2.QtCore.QObject'), ('PySide2.QtMultimedia.QAudioFormat', 'PySide2.QtCore.QObject')],
        "QAudioInput.bufferSize": (),
        "QAudioInput.bytesReady": (),
        "QAudioInput.elapsedUSecs": (),
        "QAudioInput.error": (),
        "QAudioInput.format": (),
        "QAudioInput.notifyInterval": (),
        "QAudioInput.periodSize": (),
        "QAudioInput.processedUSecs": (),
        "QAudioInput.reset": (),
        "QAudioInput.resume": (),
        "QAudioInput.setBufferSize": ('int',),
        "QAudioInput.setNotifyInterval": ('int',),
        "QAudioInput.setVolume": ('float',),
        "QAudioInput.start": [(), ('PySide2.QtCore.QIODevice',)],
        "QAudioInput.state": (),
        "QAudioInput.stop": (),
        "QAudioInput.suspend": (),
        "QAudioInput.volume": (),

    # class PySide2.QtMultimedia.QAudioInputSelectorControl:
        "QAudioInputSelectorControl.__init__": ('PySide2.QtCore.QObject',),
        "QAudioInputSelectorControl.activeInput": (),
        "QAudioInputSelectorControl.availableInputs": (),
        "QAudioInputSelectorControl.defaultInput": (),
        "QAudioInputSelectorControl.inputDescription": ('str',),
        "QAudioInputSelectorControl.setActiveInput": ('str',),

    # class PySide2.QtMultimedia.QAudioOutput:
        "QAudioOutput.__init__": [('PySide2.QtMultimedia.QAudioDeviceInfo', 'PySide2.QtMultimedia.QAudioFormat', 'PySide2.QtCore.QObject'), ('PySide2.QtMultimedia.QAudioFormat', 'PySide2.QtCore.QObject')],
        "QAudioOutput.bufferSize": (),
        "QAudioOutput.bytesFree": (),
        "QAudioOutput.category": (),
        "QAudioOutput.elapsedUSecs": (),
        "QAudioOutput.error": (),
        "QAudioOutput.format": (),
        "QAudioOutput.notifyInterval": (),
        "QAudioOutput.periodSize": (),
        "QAudioOutput.processedUSecs": (),
        "QAudioOutput.reset": (),
        "QAudioOutput.resume": (),
        "QAudioOutput.setBufferSize": ('int',),
        "QAudioOutput.setCategory": ('str',),
        "QAudioOutput.setNotifyInterval": ('int',),
        "QAudioOutput.setVolume": ('float',),
        "QAudioOutput.start": [(), ('PySide2.QtCore.QIODevice',)],
        "QAudioOutput.state": (),
        "QAudioOutput.stop": (),
        "QAudioOutput.suspend": (),
        "QAudioOutput.volume": (),

    # class PySide2.QtMultimedia.QAudioOutputSelectorControl:
        "QAudioOutputSelectorControl.__init__": ('PySide2.QtCore.QObject',),
        "QAudioOutputSelectorControl.activeOutput": (),
        "QAudioOutputSelectorControl.availableOutputs": (),
        "QAudioOutputSelectorControl.defaultOutput": (),
        "QAudioOutputSelectorControl.outputDescription": ('str',),
        "QAudioOutputSelectorControl.setActiveOutput": ('str',),

    # class PySide2.QtMultimedia.QAudioProbe:
        "QAudioProbe.__init__": ('PySide2.QtCore.QObject',),
        "QAudioProbe.isActive": (),
        "QAudioProbe.setSource": [('PySide2.QtMultimedia.QMediaObject',), ('PySide2.QtMultimedia.QMediaRecorder',)],

    # class PySide2.QtMultimedia.QAudioRecorder:
        "QAudioRecorder.__init__": ('PySide2.QtCore.QObject',),
        "QAudioRecorder.audioInput": (),
        "QAudioRecorder.audioInputDescription": ('str',),
        "QAudioRecorder.audioInputs": (),
        "QAudioRecorder.defaultAudioInput": (),
        "QAudioRecorder.setAudioInput": ('str',),

    # class PySide2.QtMultimedia.QAudioRoleControl:
        "QAudioRoleControl.__init__": ('PySide2.QtCore.QObject',),
        "QAudioRoleControl.audioRole": (),
        "QAudioRoleControl.setAudioRole": ('PySide2.QtMultimedia.QAudio.Role',),
        "QAudioRoleControl.supportedAudioRoles": (),

    # class PySide2.QtMultimedia.QCamera:
        "QCamera.__init__": [('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QObject'), ('PySide2.QtCore.QObject',), ('PySide2.QtMultimedia.QCamera.Position', 'PySide2.QtCore.QObject'), ('PySide2.QtMultimedia.QCameraInfo', 'PySide2.QtCore.QObject')],
        "QCamera.availability": (),
        "QCamera.availableDevices": (),
        "QCamera.captureMode": (),
        "QCamera.deviceDescription": ('PySide2.QtCore.QByteArray',),
        "QCamera.error": (),
        "QCamera.errorString": (),
        "QCamera.isCaptureModeSupported": ('PySide2.QtMultimedia.QCamera.CaptureModes',),
        "QCamera.load": (),
        "QCamera.lockStatus": [(), ('PySide2.QtMultimedia.QCamera.LockType',)],
        "QCamera.requestedLocks": (),
        "QCamera.searchAndLock": [(), ('PySide2.QtMultimedia.QCamera.LockTypes',)],
        "QCamera.setCaptureMode": ('PySide2.QtMultimedia.QCamera.CaptureModes',),
        "QCamera.setViewfinder": [('PySide2.QtMultimedia.QAbstractVideoSurface',), ('PySide2.QtMultimediaWidgets.QGraphicsVideoItem',), ('PySide2.QtMultimediaWidgets.QVideoWidget',)],
        "QCamera.setViewfinderSettings": ('PySide2.QtMultimedia.QCameraViewfinderSettings',),
        "QCamera.start": (),
        "QCamera.state": (),
        "QCamera.status": (),
        "QCamera.stop": (),
        "QCamera.supportedLocks": (),
        "QCamera.supportedViewfinderFrameRateRanges": ('PySide2.QtMultimedia.QCameraViewfinderSettings',),
        "QCamera.supportedViewfinderPixelFormats": ('PySide2.QtMultimedia.QCameraViewfinderSettings',),
        "QCamera.supportedViewfinderResolutions": ('PySide2.QtMultimedia.QCameraViewfinderSettings',),
        "QCamera.supportedViewfinderSettings": ('PySide2.QtMultimedia.QCameraViewfinderSettings',),
        "QCamera.unload": (),
        "QCamera.unlock": [(), ('PySide2.QtMultimedia.QCamera.LockTypes',)],
        "QCamera.viewfinderSettings": (),

    # class PySide2.QtMultimedia.QCamera.FrameRateRange:
        "QCamera.FrameRateRange.__init__": [(), ('PySide2.QtMultimedia.QCamera.FrameRateRange',), ('float', 'float')],
        "QCamera.FrameRateRange.__copy__": (),

    # class PySide2.QtMultimedia.QCameraCaptureBufferFormatControl:
        "QCameraCaptureBufferFormatControl.__init__": ('PySide2.QtCore.QObject',),
        "QCameraCaptureBufferFormatControl.bufferFormat": (),
        "QCameraCaptureBufferFormatControl.setBufferFormat": ('PySide2.QtMultimedia.QVideoFrame.PixelFormat',),
        "QCameraCaptureBufferFormatControl.supportedBufferFormats": (),

    # class PySide2.QtMultimedia.QCameraCaptureDestinationControl:
        "QCameraCaptureDestinationControl.__init__": ('PySide2.QtCore.QObject',),
        "QCameraCaptureDestinationControl.captureDestination": (),
        "QCameraCaptureDestinationControl.isCaptureDestinationSupported": ('PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations',),
        "QCameraCaptureDestinationControl.setCaptureDestination": ('PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations',),

    # class PySide2.QtMultimedia.QCameraControl:
        "QCameraControl.__init__": ('PySide2.QtCore.QObject',),
        "QCameraControl.canChangeProperty": ('PySide2.QtMultimedia.QCameraControl.PropertyChangeType', 'PySide2.QtMultimedia.QCamera.Status'),
        "QCameraControl.captureMode": (),
        "QCameraControl.isCaptureModeSupported": ('PySide2.QtMultimedia.QCamera.CaptureModes',),
        "QCameraControl.setCaptureMode": ('PySide2.QtMultimedia.QCamera.CaptureModes',),
        "QCameraControl.setState": ('PySide2.QtMultimedia.QCamera.State',),
        "QCameraControl.state": (),
        "QCameraControl.status": (),

    # class PySide2.QtMultimedia.QCameraExposureControl:
        "QCameraExposureControl.__init__": ('PySide2.QtCore.QObject',),
        "QCameraExposureControl.actualValue": ('PySide2.QtMultimedia.QCameraExposureControl.ExposureParameter',),
        "QCameraExposureControl.isParameterSupported": ('PySide2.QtMultimedia.QCameraExposureControl.ExposureParameter',),
        "QCameraExposureControl.requestedValue": ('PySide2.QtMultimedia.QCameraExposureControl.ExposureParameter',),
        "QCameraExposureControl.setValue": ('PySide2.QtMultimedia.QCameraExposureControl.ExposureParameter', 'typing.Any'),

    # class PySide2.QtMultimedia.QCameraFeedbackControl:
        "QCameraFeedbackControl.__init__": ('PySide2.QtCore.QObject',),
        "QCameraFeedbackControl.isEventFeedbackEnabled": ('PySide2.QtMultimedia.QCameraFeedbackControl.EventType',),
        "QCameraFeedbackControl.isEventFeedbackLocked": ('PySide2.QtMultimedia.QCameraFeedbackControl.EventType',),
        "QCameraFeedbackControl.resetEventFeedback": ('PySide2.QtMultimedia.QCameraFeedbackControl.EventType',),
        "QCameraFeedbackControl.setEventFeedbackEnabled": ('PySide2.QtMultimedia.QCameraFeedbackControl.EventType', 'bool'),
        "QCameraFeedbackControl.setEventFeedbackSound": ('PySide2.QtMultimedia.QCameraFeedbackControl.EventType', 'str'),

    # class PySide2.QtMultimedia.QCameraFocusZone:
        "QCameraFocusZone.__init__": [(), ('PySide2.QtCore.QRectF', 'PySide2.QtMultimedia.QCameraFocusZone.FocusZoneStatus'), ('PySide2.QtMultimedia.QCameraFocusZone',)],
        "QCameraFocusZone.__copy__": (),
        "QCameraFocusZone.area": (),
        "QCameraFocusZone.isValid": (),
        "QCameraFocusZone.setStatus": ('PySide2.QtMultimedia.QCameraFocusZone.FocusZoneStatus',),
        "QCameraFocusZone.status": (),

    # class PySide2.QtMultimedia.QCameraImageCapture:
        "QCameraImageCapture.__init__": ('PySide2.QtMultimedia.QMediaObject', 'PySide2.QtCore.QObject'),
        "QCameraImageCapture.availability": (),
        "QCameraImageCapture.bufferFormat": (),
        "QCameraImageCapture.cancelCapture": (),
        "QCameraImageCapture.capture": ('str',),
        "QCameraImageCapture.captureDestination": (),
        "QCameraImageCapture.encodingSettings": (),
        "QCameraImageCapture.error": (),
        "QCameraImageCapture.errorString": (),
        "QCameraImageCapture.imageCodecDescription": ('str',),
        "QCameraImageCapture.isAvailable": (),
        "QCameraImageCapture.isCaptureDestinationSupported": ('PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations',),
        "QCameraImageCapture.isReadyForCapture": (),
        "QCameraImageCapture.mediaObject": (),
        "QCameraImageCapture.setBufferFormat": ('PySide2.QtMultimedia.QVideoFrame.PixelFormat',),
        "QCameraImageCapture.setCaptureDestination": ('PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations',),
        "QCameraImageCapture.setEncodingSettings": ('PySide2.QtMultimedia.QImageEncoderSettings',),
        "QCameraImageCapture.setMediaObject": ('PySide2.QtMultimedia.QMediaObject',),
        "QCameraImageCapture.supportedBufferFormats": (),
        "QCameraImageCapture.supportedImageCodecs": (),

    # class PySide2.QtMultimedia.QCameraImageCaptureControl:
        "QCameraImageCaptureControl.__init__": ('PySide2.QtCore.QObject',),
        "QCameraImageCaptureControl.cancelCapture": (),
        "QCameraImageCaptureControl.capture": ('str',),
        "QCameraImageCaptureControl.driveMode": (),
        "QCameraImageCaptureControl.isReadyForCapture": (),
        "QCameraImageCaptureControl.setDriveMode": ('PySide2.QtMultimedia.QCameraImageCapture.DriveMode',),

    # class PySide2.QtMultimedia.QCameraImageProcessingControl:
        "QCameraImageProcessingControl.__init__": ('PySide2.QtCore.QObject',),
        "QCameraImageProcessingControl.isParameterSupported": ('PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter',),
        "QCameraImageProcessingControl.isParameterValueSupported": ('PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter', 'typing.Any'),
        "QCameraImageProcessingControl.parameter": ('PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter',),
        "QCameraImageProcessingControl.setParameter": ('PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter', 'typing.Any'),

    # class PySide2.QtMultimedia.QCameraInfo:
        "QCameraInfo.__init__": [('PySide2.QtCore.QByteArray',), ('PySide2.QtMultimedia.QCamera',), ('PySide2.QtMultimedia.QCameraInfo',)],
        "QCameraInfo.__copy__": (),
        "QCameraInfo.availableCameras": ('PySide2.QtMultimedia.QCamera.Position',),
        "QCameraInfo.defaultCamera": (),
        "QCameraInfo.description": (),
        "QCameraInfo.deviceName": (),
        "QCameraInfo.isNull": (),
        "QCameraInfo.orientation": (),
        "QCameraInfo.position": (),

    # class PySide2.QtMultimedia.QCameraInfoControl:
        "QCameraInfoControl.__init__": ('PySide2.QtCore.QObject',),
        "QCameraInfoControl.cameraOrientation": ('str',),
        "QCameraInfoControl.cameraPosition": ('str',),

    # class PySide2.QtMultimedia.QCameraLocksControl:
        "QCameraLocksControl.__init__": ('PySide2.QtCore.QObject',),
        "QCameraLocksControl.lockStatus": ('PySide2.QtMultimedia.QCamera.LockType',),
        "QCameraLocksControl.searchAndLock": ('PySide2.QtMultimedia.QCamera.LockTypes',),
        "QCameraLocksControl.supportedLocks": (),
        "QCameraLocksControl.unlock": ('PySide2.QtMultimedia.QCamera.LockTypes',),

    # class PySide2.QtMultimedia.QCameraViewfinderSettings:
        "QCameraViewfinderSettings.__init__": [(), ('PySide2.QtMultimedia.QCameraViewfinderSettings',)],
        "QCameraViewfinderSettings.__copy__": (),
        "QCameraViewfinderSettings.isNull": (),
        "QCameraViewfinderSettings.maximumFrameRate": (),
        "QCameraViewfinderSettings.minimumFrameRate": (),
        "QCameraViewfinderSettings.pixelAspectRatio": (),
        "QCameraViewfinderSettings.pixelFormat": (),
        "QCameraViewfinderSettings.resolution": (),
        "QCameraViewfinderSettings.setMaximumFrameRate": ('float',),
        "QCameraViewfinderSettings.setMinimumFrameRate": ('float',),
        "QCameraViewfinderSettings.setPixelAspectRatio": [('PySide2.QtCore.QSize',), ('int', 'int')],
        "QCameraViewfinderSettings.setPixelFormat": ('PySide2.QtMultimedia.QVideoFrame.PixelFormat',),
        "QCameraViewfinderSettings.setResolution": [('PySide2.QtCore.QSize',), ('int', 'int')],
        "QCameraViewfinderSettings.swap": ('PySide2.QtMultimedia.QCameraViewfinderSettings',),

    # class PySide2.QtMultimedia.QCameraViewfinderSettingsControl:
        "QCameraViewfinderSettingsControl.__init__": ('PySide2.QtCore.QObject',),
        "QCameraViewfinderSettingsControl.isViewfinderParameterSupported": ('PySide2.QtMultimedia.QCameraViewfinderSettingsControl.ViewfinderParameter',),
        "QCameraViewfinderSettingsControl.setViewfinderParameter": ('PySide2.QtMultimedia.QCameraViewfinderSettingsControl.ViewfinderParameter', 'typing.Any'),
        "QCameraViewfinderSettingsControl.viewfinderParameter": ('PySide2.QtMultimedia.QCameraViewfinderSettingsControl.ViewfinderParameter',),

    # class PySide2.QtMultimedia.QCameraViewfinderSettingsControl2:
        "QCameraViewfinderSettingsControl2.__init__": ('PySide2.QtCore.QObject',),
        "QCameraViewfinderSettingsControl2.setViewfinderSettings": ('PySide2.QtMultimedia.QCameraViewfinderSettings',),
        "QCameraViewfinderSettingsControl2.supportedViewfinderSettings": (),
        "QCameraViewfinderSettingsControl2.viewfinderSettings": (),

    # class PySide2.QtMultimedia.QCameraZoomControl:
        "QCameraZoomControl.__init__": ('PySide2.QtCore.QObject',),
        "QCameraZoomControl.currentDigitalZoom": (),
        "QCameraZoomControl.currentOpticalZoom": (),
        "QCameraZoomControl.maximumDigitalZoom": (),
        "QCameraZoomControl.maximumOpticalZoom": (),
        "QCameraZoomControl.requestedDigitalZoom": (),
        "QCameraZoomControl.requestedOpticalZoom": (),
        "QCameraZoomControl.zoomTo": ('float', 'float'),

    # class PySide2.QtMultimedia.QCustomAudioRoleControl:
        "QCustomAudioRoleControl.__init__": ('PySide2.QtCore.QObject',),
        "QCustomAudioRoleControl.customAudioRole": (),
        "QCustomAudioRoleControl.setCustomAudioRole": ('str',),
        "QCustomAudioRoleControl.supportedCustomAudioRoles": (),

    # class PySide2.QtMultimedia.QImageEncoderControl:
        "QImageEncoderControl.__init__": ('PySide2.QtCore.QObject',),
        "QImageEncoderControl.imageCodecDescription": ('str',),
        "QImageEncoderControl.imageSettings": (),
        "QImageEncoderControl.setImageSettings": ('PySide2.QtMultimedia.QImageEncoderSettings',),
        "QImageEncoderControl.supportedImageCodecs": (),

    # class PySide2.QtMultimedia.QImageEncoderSettings:
        "QImageEncoderSettings.__init__": [(), ('PySide2.QtMultimedia.QImageEncoderSettings',)],
        "QImageEncoderSettings.__copy__": (),
        "QImageEncoderSettings.codec": (),
        "QImageEncoderSettings.encodingOption": ('str',),
        "QImageEncoderSettings.encodingOptions": (),
        "QImageEncoderSettings.isNull": (),
        "QImageEncoderSettings.quality": (),
        "QImageEncoderSettings.resolution": (),
        "QImageEncoderSettings.setCodec": ('str',),
        "QImageEncoderSettings.setEncodingOption": ('str', 'typing.Any'),
        "QImageEncoderSettings.setEncodingOptions": ('dict',),
        "QImageEncoderSettings.setQuality": ('PySide2.QtMultimedia.QMultimedia.EncodingQuality',),
        "QImageEncoderSettings.setResolution": [('PySide2.QtCore.QSize',), ('int', 'int')],

    # class PySide2.QtMultimedia.QMediaAudioProbeControl:
        "QMediaAudioProbeControl.__init__": ('PySide2.QtCore.QObject',),

    # class PySide2.QtMultimedia.QMediaAvailabilityControl:
        "QMediaAvailabilityControl.__init__": ('PySide2.QtCore.QObject',),
        "QMediaAvailabilityControl.availability": (),

    # class PySide2.QtMultimedia.QMediaBindableInterface:
        "QMediaBindableInterface.__init__": (),
        "QMediaBindableInterface.mediaObject": (),
        "QMediaBindableInterface.setMediaObject": ('PySide2.QtMultimedia.QMediaObject',),

    # class PySide2.QtMultimedia.QMediaContainerControl:
        "QMediaContainerControl.__init__": ('PySide2.QtCore.QObject',),
        "QMediaContainerControl.containerDescription": ('str',),
        "QMediaContainerControl.containerFormat": (),
        "QMediaContainerControl.setContainerFormat": ('str',),
        "QMediaContainerControl.supportedContainers": (),

    # class PySide2.QtMultimedia.QMediaContent:
        "QMediaContent.__init__": [(), ('PySide2.QtCore.QUrl',), ('PySide2.QtMultimedia.QMediaContent',), ('PySide2.QtMultimedia.QMediaPlaylist', 'PySide2.QtCore.QUrl', 'bool'), ('PySide2.QtMultimedia.QMediaResource',), ('PySide2.QtNetwork.QNetworkRequest',), ('list',)],
        "QMediaContent.__copy__": (),
        "QMediaContent.canonicalRequest": (),
        "QMediaContent.canonicalResource": (),
        "QMediaContent.canonicalUrl": (),
        "QMediaContent.isNull": (),
        "QMediaContent.playlist": (),
        "QMediaContent.resources": (),

    # class PySide2.QtMultimedia.QMediaControl:
        "QMediaControl.__init__": ('PySide2.QtCore.QObject',),

    # class PySide2.QtMultimedia.QMediaGaplessPlaybackControl:
        "QMediaGaplessPlaybackControl.__init__": ('PySide2.QtCore.QObject',),
        "QMediaGaplessPlaybackControl.crossfadeTime": (),
        "QMediaGaplessPlaybackControl.isCrossfadeSupported": (),
        "QMediaGaplessPlaybackControl.nextMedia": (),
        "QMediaGaplessPlaybackControl.setCrossfadeTime": ('float',),
        "QMediaGaplessPlaybackControl.setNextMedia": ('PySide2.QtMultimedia.QMediaContent',),

    # class PySide2.QtMultimedia.QMediaNetworkAccessControl:
        "QMediaNetworkAccessControl.__init__": ('PySide2.QtCore.QObject',),
        "QMediaNetworkAccessControl.currentConfiguration": (),
        "QMediaNetworkAccessControl.setConfigurations": ('list',),

    # class PySide2.QtMultimedia.QMediaObject:
        "QMediaObject.__init__": ('PySide2.QtCore.QObject', 'PySide2.QtMultimedia.QMediaService'),
        "QMediaObject.addPropertyWatch": ('PySide2.QtCore.QByteArray',),
        "QMediaObject.availability": (),
        "QMediaObject.availableMetaData": (),
        "QMediaObject.bind": ('PySide2.QtCore.QObject',),
        "QMediaObject.isAvailable": (),
        "QMediaObject.isMetaDataAvailable": (),
        "QMediaObject.metaData": ('str',),
        "QMediaObject.notifyInterval": (),
        "QMediaObject.removePropertyWatch": ('PySide2.QtCore.QByteArray',),
        "QMediaObject.service": (),
        "QMediaObject.setNotifyInterval": ('int',),
        "QMediaObject.unbind": ('PySide2.QtCore.QObject',),

    # class PySide2.QtMultimedia.QMediaPlayer:
        "QMediaPlayer.__init__": ('PySide2.QtCore.QObject', 'PySide2.QtMultimedia.QMediaPlayer.Flags'),
        "QMediaPlayer.audioRole": (),
        "QMediaPlayer.availability": (),
        "QMediaPlayer.bind": ('PySide2.QtCore.QObject',),
        "QMediaPlayer.bufferStatus": (),
        "QMediaPlayer.currentMedia": (),
        "QMediaPlayer.currentNetworkConfiguration": (),
        "QMediaPlayer.customAudioRole": (),
        "QMediaPlayer.duration": (),
        "QMediaPlayer.error": (),
        "QMediaPlayer.errorString": (),
        "QMediaPlayer.hasSupport": ('str', 'typing.List[str]', 'PySide2.QtMultimedia.QMediaPlayer.Flags'),
        "QMediaPlayer.isAudioAvailable": (),
        "QMediaPlayer.isMuted": (),
        "QMediaPlayer.isSeekable": (),
        "QMediaPlayer.isVideoAvailable": (),
        "QMediaPlayer.media": (),
        "QMediaPlayer.mediaStatus": (),
        "QMediaPlayer.mediaStream": (),
        "QMediaPlayer.pause": (),
        "QMediaPlayer.play": (),
        "QMediaPlayer.playbackRate": (),
        "QMediaPlayer.playlist": (),
        "QMediaPlayer.position": (),
        "QMediaPlayer.setAudioRole": ('PySide2.QtMultimedia.QAudio.Role',),
        "QMediaPlayer.setCustomAudioRole": ('str',),
        "QMediaPlayer.setMedia": ('PySide2.QtMultimedia.QMediaContent', 'PySide2.QtCore.QIODevice'),
        "QMediaPlayer.setMuted": ('bool',),
        "QMediaPlayer.setNetworkConfigurations": ('list',),
        "QMediaPlayer.setPlaybackRate": ('float',),
        "QMediaPlayer.setPlaylist": ('PySide2.QtMultimedia.QMediaPlaylist',),
        "QMediaPlayer.setPosition": ('int',),
        "QMediaPlayer.setVideoOutput": [('PySide2.QtMultimedia.QAbstractVideoSurface',), ('PySide2.QtMultimediaWidgets.QGraphicsVideoItem',), ('PySide2.QtMultimediaWidgets.QVideoWidget',)],
        "QMediaPlayer.setVolume": ('int',),
        "QMediaPlayer.state": (),
        "QMediaPlayer.stop": (),
        "QMediaPlayer.supportedAudioRoles": (),
        "QMediaPlayer.supportedCustomAudioRoles": (),
        "QMediaPlayer.supportedMimeTypes": ('PySide2.QtMultimedia.QMediaPlayer.Flags',),
        "QMediaPlayer.unbind": ('PySide2.QtCore.QObject',),
        "QMediaPlayer.volume": (),

    # class PySide2.QtMultimedia.QMediaPlayerControl:
        "QMediaPlayerControl.__init__": ('PySide2.QtCore.QObject',),
        "QMediaPlayerControl.availablePlaybackRanges": (),
        "QMediaPlayerControl.bufferStatus": (),
        "QMediaPlayerControl.duration": (),
        "QMediaPlayerControl.isAudioAvailable": (),
        "QMediaPlayerControl.isMuted": (),
        "QMediaPlayerControl.isSeekable": (),
        "QMediaPlayerControl.isVideoAvailable": (),
        "QMediaPlayerControl.media": (),
        "QMediaPlayerControl.mediaStatus": (),
        "QMediaPlayerControl.mediaStream": (),
        "QMediaPlayerControl.pause": (),
        "QMediaPlayerControl.play": (),
        "QMediaPlayerControl.playbackRate": (),
        "QMediaPlayerControl.position": (),
        "QMediaPlayerControl.setMedia": ('PySide2.QtMultimedia.QMediaContent', 'PySide2.QtCore.QIODevice'),
        "QMediaPlayerControl.setMuted": ('bool',),
        "QMediaPlayerControl.setPlaybackRate": ('float',),
        "QMediaPlayerControl.setPosition": ('int',),
        "QMediaPlayerControl.setVolume": ('int',),
        "QMediaPlayerControl.state": (),
        "QMediaPlayerControl.stop": (),
        "QMediaPlayerControl.volume": (),

    # class PySide2.QtMultimedia.QMediaPlaylist:
        "QMediaPlaylist.__init__": ('PySide2.QtCore.QObject',),
        "QMediaPlaylist.addMedia": [('PySide2.QtMultimedia.QMediaContent',), ('list',)],
        "QMediaPlaylist.clear": (),
        "QMediaPlaylist.currentIndex": (),
        "QMediaPlaylist.currentMedia": (),
        "QMediaPlaylist.error": (),
        "QMediaPlaylist.errorString": (),
        "QMediaPlaylist.insertMedia": [('int', 'PySide2.QtMultimedia.QMediaContent'), ('int', 'list')],
        "QMediaPlaylist.isEmpty": (),
        "QMediaPlaylist.isReadOnly": (),
        "QMediaPlaylist.load": [('PySide2.QtCore.QIODevice', 'str'), ('PySide2.QtCore.QUrl', 'str'), ('PySide2.QtNetwork.QNetworkRequest', 'str')],
        "QMediaPlaylist.media": ('int',),
        "QMediaPlaylist.mediaCount": (),
        "QMediaPlaylist.mediaObject": (),
        "QMediaPlaylist.moveMedia": ('int', 'int'),
        "QMediaPlaylist.nextIndex": ('int',),
        "QMediaPlaylist.playbackMode": (),
        "QMediaPlaylist.previous": (),
        "QMediaPlaylist.previousIndex": ('int',),
        "QMediaPlaylist.removeMedia": [('int',), ('int', 'int')],
        "QMediaPlaylist.save": [('PySide2.QtCore.QIODevice', 'str'), ('PySide2.QtCore.QUrl', 'str')],
        "QMediaPlaylist.setCurrentIndex": ('int',),
        "QMediaPlaylist.setMediaObject": ('PySide2.QtMultimedia.QMediaObject',),
        "QMediaPlaylist.setPlaybackMode": ('PySide2.QtMultimedia.QMediaPlaylist.PlaybackMode',),
        "QMediaPlaylist.shuffle": (),

    # class PySide2.QtMultimedia.QMediaRecorder:
        "QMediaRecorder.__init__": ('PySide2.QtMultimedia.QMediaObject', 'PySide2.QtCore.QObject'),
        "QMediaRecorder.actualLocation": (),
        "QMediaRecorder.audioCodecDescription": ('str',),
        "QMediaRecorder.audioSettings": (),
        "QMediaRecorder.availability": (),
        "QMediaRecorder.availableMetaData": (),
        "QMediaRecorder.containerDescription": ('str',),
        "QMediaRecorder.containerFormat": (),
        "QMediaRecorder.duration": (),
        "QMediaRecorder.error": (),
        "QMediaRecorder.errorString": (),
        "QMediaRecorder.isAvailable": (),
        "QMediaRecorder.isMetaDataAvailable": (),
        "QMediaRecorder.isMetaDataWritable": (),
        "QMediaRecorder.isMuted": (),
        "QMediaRecorder.mediaObject": (),
        "QMediaRecorder.metaData": ('str',),
        "QMediaRecorder.outputLocation": (),
        "QMediaRecorder.pause": (),
        "QMediaRecorder.record": (),
        "QMediaRecorder.setAudioSettings": ('PySide2.QtMultimedia.QAudioEncoderSettings',),
        "QMediaRecorder.setContainerFormat": ('str',),
        "QMediaRecorder.setEncodingSettings": ('PySide2.QtMultimedia.QAudioEncoderSettings', 'PySide2.QtMultimedia.QVideoEncoderSettings', 'str'),
        "QMediaRecorder.setMediaObject": ('PySide2.QtMultimedia.QMediaObject',),
        "QMediaRecorder.setMetaData": ('str', 'typing.Any'),
        "QMediaRecorder.setMuted": ('bool',),
        "QMediaRecorder.setOutputLocation": ('PySide2.QtCore.QUrl',),
        "QMediaRecorder.setVideoSettings": ('PySide2.QtMultimedia.QVideoEncoderSettings',),
        "QMediaRecorder.setVolume": ('float',),
        "QMediaRecorder.state": (),
        "QMediaRecorder.status": (),
        "QMediaRecorder.stop": (),
        "QMediaRecorder.supportedAudioCodecs": (),
        "QMediaRecorder.supportedContainers": (),
        "QMediaRecorder.supportedVideoCodecs": (),
        "QMediaRecorder.videoCodecDescription": ('str',),
        "QMediaRecorder.videoSettings": (),
        "QMediaRecorder.volume": (),

    # class PySide2.QtMultimedia.QMediaRecorderControl:
        "QMediaRecorderControl.__init__": ('PySide2.QtCore.QObject',),
        "QMediaRecorderControl.applySettings": (),
        "QMediaRecorderControl.duration": (),
        "QMediaRecorderControl.isMuted": (),
        "QMediaRecorderControl.outputLocation": (),
        "QMediaRecorderControl.setMuted": ('bool',),
        "QMediaRecorderControl.setOutputLocation": ('PySide2.QtCore.QUrl',),
        "QMediaRecorderControl.setState": ('PySide2.QtMultimedia.QMediaRecorder.State',),
        "QMediaRecorderControl.setVolume": ('float',),
        "QMediaRecorderControl.state": (),
        "QMediaRecorderControl.status": (),
        "QMediaRecorderControl.volume": (),

    # class PySide2.QtMultimedia.QMediaResource:
        "QMediaResource.__init__": [(), ('PySide2.QtCore.QUrl', 'str'), ('PySide2.QtMultimedia.QMediaResource',), ('PySide2.QtNetwork.QNetworkRequest', 'str')],
        "QMediaResource.__copy__": (),
        "QMediaResource.audioBitRate": (),
        "QMediaResource.audioCodec": (),
        "QMediaResource.channelCount": (),
        "QMediaResource.dataSize": (),
        "QMediaResource.isNull": (),
        "QMediaResource.language": (),
        "QMediaResource.mimeType": (),
        "QMediaResource.request": (),
        "QMediaResource.resolution": (),
        "QMediaResource.sampleRate": (),
        "QMediaResource.setAudioBitRate": ('int',),
        "QMediaResource.setAudioCodec": ('str',),
        "QMediaResource.setChannelCount": ('int',),
        "QMediaResource.setDataSize": ('int',),
        "QMediaResource.setLanguage": ('str',),
        "QMediaResource.setResolution": [('PySide2.QtCore.QSize',), ('int', 'int')],
        "QMediaResource.setSampleRate": ('int',),
        "QMediaResource.setVideoBitRate": ('int',),
        "QMediaResource.setVideoCodec": ('str',),
        "QMediaResource.url": (),
        "QMediaResource.videoBitRate": (),
        "QMediaResource.videoCodec": (),

    # class PySide2.QtMultimedia.QMediaService:
        "QMediaService.__init__": ('PySide2.QtCore.QObject',),
        "QMediaService.releaseControl": ('PySide2.QtMultimedia.QMediaControl',),
        "QMediaService.requestControl": ('str',),

    # class PySide2.QtMultimedia.QMediaServiceCameraInfoInterface:
        "QMediaServiceCameraInfoInterface.__init__": (),
        "QMediaServiceCameraInfoInterface.cameraOrientation": ('PySide2.QtCore.QByteArray',),
        "QMediaServiceCameraInfoInterface.cameraPosition": ('PySide2.QtCore.QByteArray',),

    # class PySide2.QtMultimedia.QMediaServiceDefaultDeviceInterface:
        "QMediaServiceDefaultDeviceInterface.__init__": (),
        "QMediaServiceDefaultDeviceInterface.defaultDevice": ('PySide2.QtCore.QByteArray',),

    # class PySide2.QtMultimedia.QMediaServiceFeaturesInterface:
        "QMediaServiceFeaturesInterface.__init__": (),
        "QMediaServiceFeaturesInterface.supportedFeatures": ('PySide2.QtCore.QByteArray',),

    # class PySide2.QtMultimedia.QMediaServiceProviderHint:
        "QMediaServiceProviderHint.__init__": [(), ('PySide2.QtCore.QByteArray',), ('PySide2.QtMultimedia.QCamera.Position',), ('PySide2.QtMultimedia.QMediaServiceProviderHint',), ('PySide2.QtMultimedia.QMediaServiceProviderHint.Features',), ('str', 'typing.List[str]')],
        "QMediaServiceProviderHint.__copy__": (),
        "QMediaServiceProviderHint.cameraPosition": (),
        "QMediaServiceProviderHint.codecs": (),
        "QMediaServiceProviderHint.device": (),
        "QMediaServiceProviderHint.features": (),
        "QMediaServiceProviderHint.isNull": (),
        "QMediaServiceProviderHint.mimeType": (),
        "QMediaServiceProviderHint.type": (),

    # class PySide2.QtMultimedia.QMediaServiceSupportedDevicesInterface:
        "QMediaServiceSupportedDevicesInterface.__init__": (),
        "QMediaServiceSupportedDevicesInterface.deviceDescription": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray'),
        "QMediaServiceSupportedDevicesInterface.devices": ('PySide2.QtCore.QByteArray',),

    # class PySide2.QtMultimedia.QMediaServiceSupportedFormatsInterface:
        "QMediaServiceSupportedFormatsInterface.__init__": (),
        "QMediaServiceSupportedFormatsInterface.hasSupport": ('str', 'typing.List[str]'),
        "QMediaServiceSupportedFormatsInterface.supportedMimeTypes": (),

    # class PySide2.QtMultimedia.QMediaStreamsControl:
        "QMediaStreamsControl.__init__": ('PySide2.QtCore.QObject',),
        "QMediaStreamsControl.isActive": ('int',),
        "QMediaStreamsControl.metaData": ('int', 'str'),
        "QMediaStreamsControl.setActive": ('int', 'bool'),
        "QMediaStreamsControl.streamCount": (),
        "QMediaStreamsControl.streamType": ('int',),

    # class PySide2.QtMultimedia.QMediaTimeInterval:
        "QMediaTimeInterval.__init__": [(), ('PySide2.QtMultimedia.QMediaTimeInterval',), ('int', 'int')],
        "QMediaTimeInterval.__copy__": (),
        "QMediaTimeInterval.contains": ('int',),
        "QMediaTimeInterval.end": (),
        "QMediaTimeInterval.isNormal": (),
        "QMediaTimeInterval.normalized": (),
        "QMediaTimeInterval.start": (),
        "QMediaTimeInterval.translated": ('int',),

    # class PySide2.QtMultimedia.QMediaTimeRange:
        "QMediaTimeRange.__init__": [(), ('PySide2.QtMultimedia.QMediaTimeInterval',), ('PySide2.QtMultimedia.QMediaTimeRange',), ('int', 'int')],
        "QMediaTimeRange.__add__": ('PySide2.QtMultimedia.QMediaTimeRange',),
        "QMediaTimeRange.__copy__": (),
        "QMediaTimeRange.__iadd__": [('PySide2.QtMultimedia.QMediaTimeInterval',), ('PySide2.QtMultimedia.QMediaTimeRange',)],
        "QMediaTimeRange.__isub__": [('PySide2.QtMultimedia.QMediaTimeInterval',), ('PySide2.QtMultimedia.QMediaTimeRange',)],
        "QMediaTimeRange.__sub__": ('PySide2.QtMultimedia.QMediaTimeRange',),
        "QMediaTimeRange.addInterval": [('PySide2.QtMultimedia.QMediaTimeInterval',), ('int', 'int')],
        "QMediaTimeRange.addTimeRange": ('PySide2.QtMultimedia.QMediaTimeRange',),
        "QMediaTimeRange.clear": (),
        "QMediaTimeRange.contains": ('int',),
        "QMediaTimeRange.earliestTime": (),
        "QMediaTimeRange.intervals": (),
        "QMediaTimeRange.isContinuous": (),
        "QMediaTimeRange.isEmpty": (),
        "QMediaTimeRange.latestTime": (),
        "QMediaTimeRange.removeInterval": [('PySide2.QtMultimedia.QMediaTimeInterval',), ('int', 'int')],
        "QMediaTimeRange.removeTimeRange": ('PySide2.QtMultimedia.QMediaTimeRange',),

    # class PySide2.QtMultimedia.QMediaVideoProbeControl:
        "QMediaVideoProbeControl.__init__": ('PySide2.QtCore.QObject',),

    # class PySide2.QtMultimedia.QMetaDataReaderControl:
        "QMetaDataReaderControl.__init__": ('PySide2.QtCore.QObject',),
        "QMetaDataReaderControl.availableMetaData": (),
        "QMetaDataReaderControl.isMetaDataAvailable": (),
        "QMetaDataReaderControl.metaData": ('str',),

    # class PySide2.QtMultimedia.QMetaDataWriterControl:
        "QMetaDataWriterControl.__init__": ('PySide2.QtCore.QObject',),
        "QMetaDataWriterControl.availableMetaData": (),
        "QMetaDataWriterControl.isMetaDataAvailable": (),
        "QMetaDataWriterControl.isWritable": (),
        "QMetaDataWriterControl.metaData": ('str',),
        "QMetaDataWriterControl.setMetaData": ('str', 'typing.Any'),

    # class PySide2.QtMultimedia.QMultimedia:

    # class PySide2.QtMultimedia.QRadioData:
        "QRadioData.__init__": ('PySide2.QtMultimedia.QMediaObject', 'PySide2.QtCore.QObject'),
        "QRadioData.availability": (),
        "QRadioData.error": (),
        "QRadioData.errorString": (),
        "QRadioData.isAlternativeFrequenciesEnabled": (),
        "QRadioData.mediaObject": (),
        "QRadioData.programType": (),
        "QRadioData.programTypeName": (),
        "QRadioData.radioText": (),
        "QRadioData.setAlternativeFrequenciesEnabled": ('bool',),
        "QRadioData.setMediaObject": ('PySide2.QtMultimedia.QMediaObject',),
        "QRadioData.stationId": (),
        "QRadioData.stationName": (),

    # class PySide2.QtMultimedia.QRadioDataControl:
        "QRadioDataControl.__init__": ('PySide2.QtCore.QObject',),
        "QRadioDataControl.error": (),
        "QRadioDataControl.errorString": (),
        "QRadioDataControl.isAlternativeFrequenciesEnabled": (),
        "QRadioDataControl.programType": (),
        "QRadioDataControl.programTypeName": (),
        "QRadioDataControl.radioText": (),
        "QRadioDataControl.setAlternativeFrequenciesEnabled": ('bool',),
        "QRadioDataControl.stationId": (),
        "QRadioDataControl.stationName": (),

    # class PySide2.QtMultimedia.QRadioTuner:
        "QRadioTuner.__init__": ('PySide2.QtCore.QObject',),
        "QRadioTuner.availability": (),
        "QRadioTuner.band": (),
        "QRadioTuner.cancelSearch": (),
        "QRadioTuner.error": (),
        "QRadioTuner.errorString": (),
        "QRadioTuner.frequency": (),
        "QRadioTuner.frequencyRange": ('PySide2.QtMultimedia.QRadioTuner.Band',),
        "QRadioTuner.frequencyStep": ('PySide2.QtMultimedia.QRadioTuner.Band',),
        "QRadioTuner.isAntennaConnected": (),
        "QRadioTuner.isBandSupported": ('PySide2.QtMultimedia.QRadioTuner.Band',),
        "QRadioTuner.isMuted": (),
        "QRadioTuner.isSearching": (),
        "QRadioTuner.isStereo": (),
        "QRadioTuner.radioData": (),
        "QRadioTuner.searchAllStations": ('PySide2.QtMultimedia.QRadioTuner.SearchMode',),
        "QRadioTuner.searchBackward": (),
        "QRadioTuner.searchForward": (),
        "QRadioTuner.setBand": ('PySide2.QtMultimedia.QRadioTuner.Band',),
        "QRadioTuner.setFrequency": ('int',),
        "QRadioTuner.setMuted": ('bool',),
        "QRadioTuner.setStereoMode": ('PySide2.QtMultimedia.QRadioTuner.StereoMode',),
        "QRadioTuner.setVolume": ('int',),
        "QRadioTuner.signalStrength": (),
        "QRadioTuner.start": (),
        "QRadioTuner.state": (),
        "QRadioTuner.stereoMode": (),
        "QRadioTuner.stop": (),
        "QRadioTuner.volume": (),

    # class PySide2.QtMultimedia.QRadioTunerControl:
        "QRadioTunerControl.__init__": ('PySide2.QtCore.QObject',),
        "QRadioTunerControl.band": (),
        "QRadioTunerControl.cancelSearch": (),
        "QRadioTunerControl.error": (),
        "QRadioTunerControl.errorString": (),
        "QRadioTunerControl.frequency": (),
        "QRadioTunerControl.frequencyRange": ('PySide2.QtMultimedia.QRadioTuner.Band',),
        "QRadioTunerControl.frequencyStep": ('PySide2.QtMultimedia.QRadioTuner.Band',),
        "QRadioTunerControl.isAntennaConnected": (),
        "QRadioTunerControl.isBandSupported": ('PySide2.QtMultimedia.QRadioTuner.Band',),
        "QRadioTunerControl.isMuted": (),
        "QRadioTunerControl.isSearching": (),
        "QRadioTunerControl.isStereo": (),
        "QRadioTunerControl.searchAllStations": ('PySide2.QtMultimedia.QRadioTuner.SearchMode',),
        "QRadioTunerControl.searchBackward": (),
        "QRadioTunerControl.searchForward": (),
        "QRadioTunerControl.setBand": ('PySide2.QtMultimedia.QRadioTuner.Band',),
        "QRadioTunerControl.setFrequency": ('int',),
        "QRadioTunerControl.setMuted": ('bool',),
        "QRadioTunerControl.setStereoMode": ('PySide2.QtMultimedia.QRadioTuner.StereoMode',),
        "QRadioTunerControl.setVolume": ('int',),
        "QRadioTunerControl.signalStrength": (),
        "QRadioTunerControl.start": (),
        "QRadioTunerControl.state": (),
        "QRadioTunerControl.stereoMode": (),
        "QRadioTunerControl.stop": (),
        "QRadioTunerControl.volume": (),

    # class PySide2.QtMultimedia.QSound:
        "QSound.__init__": ('str', 'PySide2.QtCore.QObject'),
        "QSound.fileName": (),
        "QSound.isFinished": (),
        "QSound.loops": (),
        "QSound.loopsRemaining": (),
        "QSound.play": [(), ('str',)],
        "QSound.setLoops": ('int',),
        "QSound.stop": (),

    # class PySide2.QtMultimedia.QSoundEffect:
        "QSoundEffect.__init__": ('PySide2.QtCore.QObject',),
        "QSoundEffect.category": (),
        "QSoundEffect.isLoaded": (),
        "QSoundEffect.isMuted": (),
        "QSoundEffect.isPlaying": (),
        "QSoundEffect.loopCount": (),
        "QSoundEffect.loopsRemaining": (),
        "QSoundEffect.play": (),
        "QSoundEffect.setCategory": ('str',),
        "QSoundEffect.setLoopCount": ('int',),
        "QSoundEffect.setMuted": ('bool',),
        "QSoundEffect.setSource": ('PySide2.QtCore.QUrl',),
        "QSoundEffect.setVolume": ('float',),
        "QSoundEffect.source": (),
        "QSoundEffect.status": (),
        "QSoundEffect.stop": (),
        "QSoundEffect.supportedMimeTypes": (),
        "QSoundEffect.volume": (),

    # class PySide2.QtMultimedia.QVideoDeviceSelectorControl:
        "QVideoDeviceSelectorControl.__init__": ('PySide2.QtCore.QObject',),
        "QVideoDeviceSelectorControl.defaultDevice": (),
        "QVideoDeviceSelectorControl.deviceCount": (),
        "QVideoDeviceSelectorControl.deviceDescription": ('int',),
        "QVideoDeviceSelectorControl.deviceName": ('int',),
        "QVideoDeviceSelectorControl.selectedDevice": (),
        "QVideoDeviceSelectorControl.setSelectedDevice": ('int',),

    # class PySide2.QtMultimedia.QVideoEncoderSettings:
        "QVideoEncoderSettings.__init__": [(), ('PySide2.QtMultimedia.QVideoEncoderSettings',)],
        "QVideoEncoderSettings.__copy__": (),
        "QVideoEncoderSettings.bitRate": (),
        "QVideoEncoderSettings.codec": (),
        "QVideoEncoderSettings.encodingMode": (),
        "QVideoEncoderSettings.encodingOption": ('str',),
        "QVideoEncoderSettings.encodingOptions": (),
        "QVideoEncoderSettings.frameRate": (),
        "QVideoEncoderSettings.isNull": (),
        "QVideoEncoderSettings.quality": (),
        "QVideoEncoderSettings.resolution": (),
        "QVideoEncoderSettings.setBitRate": ('int',),
        "QVideoEncoderSettings.setCodec": ('str',),
        "QVideoEncoderSettings.setEncodingMode": ('PySide2.QtMultimedia.QMultimedia.EncodingMode',),
        "QVideoEncoderSettings.setEncodingOption": ('str', 'typing.Any'),
        "QVideoEncoderSettings.setEncodingOptions": ('dict',),
        "QVideoEncoderSettings.setFrameRate": ('float',),
        "QVideoEncoderSettings.setQuality": ('PySide2.QtMultimedia.QMultimedia.EncodingQuality',),
        "QVideoEncoderSettings.setResolution": [('PySide2.QtCore.QSize',), ('int', 'int')],

    # class PySide2.QtMultimedia.QVideoEncoderSettingsControl:
        "QVideoEncoderSettingsControl.__init__": ('PySide2.QtCore.QObject',),
        "QVideoEncoderSettingsControl.setVideoSettings": ('PySide2.QtMultimedia.QVideoEncoderSettings',),
        "QVideoEncoderSettingsControl.supportedVideoCodecs": (),
        "QVideoEncoderSettingsControl.videoCodecDescription": ('str',),
        "QVideoEncoderSettingsControl.videoSettings": (),

    # class PySide2.QtMultimedia.QVideoFilterRunnable:
        "QVideoFilterRunnable.__init__": (),
        "QVideoFilterRunnable.run": ('PySide2.QtMultimedia.QVideoFrame', 'PySide2.QtMultimedia.QVideoSurfaceFormat', 'PySide2.QtMultimedia.QVideoFilterRunnable.RunFlags'),

    # class PySide2.QtMultimedia.QVideoFrame:
        "QVideoFrame.__init__": [(), ('PySide2.QtGui.QImage',), ('PySide2.QtMultimedia.QAbstractVideoBuffer', 'PySide2.QtCore.QSize', 'PySide2.QtMultimedia.QVideoFrame.PixelFormat'), ('PySide2.QtMultimedia.QVideoFrame',), ('int', 'PySide2.QtCore.QSize', 'int', 'PySide2.QtMultimedia.QVideoFrame.PixelFormat')],
        "QVideoFrame.__copy__": (),
        "QVideoFrame.availableMetaData": (),
        "QVideoFrame.bits": (),
        "QVideoFrame.bytesPerLine": [(), ('int',)],
        "QVideoFrame.endTime": (),
        "QVideoFrame.fieldType": (),
        "QVideoFrame.handle": (),
        "QVideoFrame.handleType": (),
        "QVideoFrame.height": (),
        "QVideoFrame.imageFormatFromPixelFormat": ('PySide2.QtMultimedia.QVideoFrame.PixelFormat',),
        "QVideoFrame.isMapped": (),
        "QVideoFrame.isReadable": (),
        "QVideoFrame.isValid": (),
        "QVideoFrame.isWritable": (),
        "QVideoFrame.map": ('PySide2.QtMultimedia.QAbstractVideoBuffer.MapMode',),
        "QVideoFrame.mapMode": (),
        "QVideoFrame.mappedBytes": (),
        "QVideoFrame.metaData": ('str',),
        "QVideoFrame.pixelFormat": (),
        "QVideoFrame.pixelFormatFromImageFormat": ('PySide2.QtGui.QImage.Format',),
        "QVideoFrame.planeCount": (),
        "QVideoFrame.setEndTime": ('int',),
        "QVideoFrame.setFieldType": ('PySide2.QtMultimedia.QVideoFrame.FieldType',),
        "QVideoFrame.setMetaData": ('str', 'typing.Any'),
        "QVideoFrame.setStartTime": ('int',),
        "QVideoFrame.size": (),
        "QVideoFrame.startTime": (),
        "QVideoFrame.unmap": (),
        "QVideoFrame.width": (),

    # class PySide2.QtMultimedia.QVideoProbe:
        "QVideoProbe.__init__": ('PySide2.QtCore.QObject',),
        "QVideoProbe.isActive": (),
        "QVideoProbe.setSource": [('PySide2.QtMultimedia.QMediaObject',), ('PySide2.QtMultimedia.QMediaRecorder',)],

    # class PySide2.QtMultimedia.QVideoRendererControl:
        "QVideoRendererControl.__init__": ('PySide2.QtCore.QObject',),
        "QVideoRendererControl.setSurface": ('PySide2.QtMultimedia.QAbstractVideoSurface',),
        "QVideoRendererControl.surface": (),

    # class PySide2.QtMultimedia.QVideoSurfaceFormat:
        "QVideoSurfaceFormat.__init__": [(), ('PySide2.QtCore.QSize', 'PySide2.QtMultimedia.QVideoFrame.PixelFormat', 'PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType'), ('PySide2.QtMultimedia.QVideoSurfaceFormat',)],
        "QVideoSurfaceFormat.__copy__": (),
        "QVideoSurfaceFormat.frameHeight": (),
        "QVideoSurfaceFormat.frameRate": (),
        "QVideoSurfaceFormat.frameSize": (),
        "QVideoSurfaceFormat.frameWidth": (),
        "QVideoSurfaceFormat.handleType": (),
        "QVideoSurfaceFormat.isMirrored": (),
        "QVideoSurfaceFormat.isValid": (),
        "QVideoSurfaceFormat.pixelAspectRatio": (),
        "QVideoSurfaceFormat.pixelFormat": (),
        "QVideoSurfaceFormat.property": ('str',),
        "QVideoSurfaceFormat.propertyNames": (),
        "QVideoSurfaceFormat.scanLineDirection": (),
        "QVideoSurfaceFormat.setFrameRate": ('float',),
        "QVideoSurfaceFormat.setFrameSize": [('PySide2.QtCore.QSize',), ('int', 'int')],
        "QVideoSurfaceFormat.setMirrored": ('bool',),
        "QVideoSurfaceFormat.setPixelAspectRatio": [('PySide2.QtCore.QSize',), ('int', 'int')],
        "QVideoSurfaceFormat.setProperty": ('str', 'typing.Any'),
        "QVideoSurfaceFormat.setScanLineDirection": ('PySide2.QtMultimedia.QVideoSurfaceFormat.Direction',),
        "QVideoSurfaceFormat.setViewport": ('PySide2.QtCore.QRect',),
        "QVideoSurfaceFormat.setYCbCrColorSpace": ('PySide2.QtMultimedia.QVideoSurfaceFormat.YCbCrColorSpace',),
        "QVideoSurfaceFormat.sizeHint": (),
        "QVideoSurfaceFormat.viewport": (),
        "QVideoSurfaceFormat.yCbCrColorSpace": (),

    # class PySide2.QtMultimedia.QVideoWindowControl:
        "QVideoWindowControl.__init__": ('PySide2.QtCore.QObject',),
        "QVideoWindowControl.aspectRatioMode": (),
        "QVideoWindowControl.brightness": (),
        "QVideoWindowControl.contrast": (),
        "QVideoWindowControl.displayRect": (),
        "QVideoWindowControl.hue": (),
        "QVideoWindowControl.isFullScreen": (),
        "QVideoWindowControl.nativeSize": (),
        "QVideoWindowControl.repaint": (),
        "QVideoWindowControl.saturation": (),
        "QVideoWindowControl.setAspectRatioMode": ('PySide2.QtCore.Qt.AspectRatioMode',),
        "QVideoWindowControl.setBrightness": ('int',),
        "QVideoWindowControl.setContrast": ('int',),
        "QVideoWindowControl.setDisplayRect": ('PySide2.QtCore.QRect',),
        "QVideoWindowControl.setFullScreen": ('bool',),
        "QVideoWindowControl.setHue": ('int',),
        "QVideoWindowControl.setSaturation": ('int',),
        "QVideoWindowControl.setWinId": ('int',),
        "QVideoWindowControl.winId": (),
    })

# Module PySide2.QtMultimediaWidgets
if "PySide2.QtMultimediaWidgets" in sys.modules:
    dict.update({

    # class PySide2.QtMultimediaWidgets.QCameraViewfinder:
        "QCameraViewfinder.__init__": ('PySide2.QtWidgets.QWidget',),
        "QCameraViewfinder.mediaObject": (),
        "QCameraViewfinder.setMediaObject": ('PySide2.QtMultimedia.QMediaObject',),

    # class PySide2.QtMultimediaWidgets.QGraphicsVideoItem:
        "QGraphicsVideoItem.__init__": ('PySide2.QtWidgets.QGraphicsItem',),
        "QGraphicsVideoItem.aspectRatioMode": (),
        "QGraphicsVideoItem.boundingRect": (),
        "QGraphicsVideoItem.itemChange": ('PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange', 'typing.Any'),
        "QGraphicsVideoItem.mediaObject": (),
        "QGraphicsVideoItem.nativeSize": (),
        "QGraphicsVideoItem.offset": (),
        "QGraphicsVideoItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
        "QGraphicsVideoItem.setAspectRatioMode": ('PySide2.QtCore.Qt.AspectRatioMode',),
        "QGraphicsVideoItem.setMediaObject": ('PySide2.QtMultimedia.QMediaObject',),
        "QGraphicsVideoItem.setOffset": ('PySide2.QtCore.QPointF',),
        "QGraphicsVideoItem.setSize": ('PySide2.QtCore.QSizeF',),
        "QGraphicsVideoItem.size": (),
        "QGraphicsVideoItem.timerEvent": ('PySide2.QtCore.QTimerEvent',),

    # class PySide2.QtMultimediaWidgets.QVideoWidget:
        "QVideoWidget.__init__": ('PySide2.QtWidgets.QWidget',),
        "QVideoWidget.aspectRatioMode": (),
        "QVideoWidget.brightness": (),
        "QVideoWidget.contrast": (),
        "QVideoWidget.event": ('PySide2.QtCore.QEvent',),
        "QVideoWidget.hideEvent": ('PySide2.QtGui.QHideEvent',),
        "QVideoWidget.hue": (),
        "QVideoWidget.mediaObject": (),
        "QVideoWidget.moveEvent": ('PySide2.QtGui.QMoveEvent',),
        "QVideoWidget.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QVideoWidget.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QVideoWidget.saturation": (),
        "QVideoWidget.setAspectRatioMode": ('PySide2.QtCore.Qt.AspectRatioMode',),
        "QVideoWidget.setBrightness": ('int',),
        "QVideoWidget.setContrast": ('int',),
        "QVideoWidget.setFullScreen": ('bool',),
        "QVideoWidget.setHue": ('int',),
        "QVideoWidget.setMediaObject": ('PySide2.QtMultimedia.QMediaObject',),
        "QVideoWidget.setSaturation": ('int',),
        "QVideoWidget.showEvent": ('PySide2.QtGui.QShowEvent',),
        "QVideoWidget.sizeHint": (),

    # class PySide2.QtMultimediaWidgets.QVideoWidgetControl:
        "QVideoWidgetControl.__init__": ('PySide2.QtCore.QObject',),
        "QVideoWidgetControl.aspectRatioMode": (),
        "QVideoWidgetControl.brightness": (),
        "QVideoWidgetControl.contrast": (),
        "QVideoWidgetControl.hue": (),
        "QVideoWidgetControl.isFullScreen": (),
        "QVideoWidgetControl.saturation": (),
        "QVideoWidgetControl.setAspectRatioMode": ('PySide2.QtCore.Qt.AspectRatioMode',),
        "QVideoWidgetControl.setBrightness": ('int',),
        "QVideoWidgetControl.setContrast": ('int',),
        "QVideoWidgetControl.setFullScreen": ('bool',),
        "QVideoWidgetControl.setHue": ('int',),
        "QVideoWidgetControl.setSaturation": ('int',),
        "QVideoWidgetControl.videoWidget": (),
    })

# Module PySide2.QtOpenGL
if "PySide2.QtOpenGL" in sys.modules:
    dict.update({

    # class PySide2.QtOpenGL.QGL:

    # class PySide2.QtOpenGL.QGLBuffer:
        "QGLBuffer.__init__": [(), ('PySide2.QtOpenGL.QGLBuffer',), ('PySide2.QtOpenGL.QGLBuffer.Type',)],
        "QGLBuffer.allocate": [('int',), ('int', 'int')],
        "QGLBuffer.bind": (),
        "QGLBuffer.bufferId": (),
        "QGLBuffer.create": (),
        "QGLBuffer.destroy": (),
        "QGLBuffer.isCreated": (),
        "QGLBuffer.map": ('PySide2.QtOpenGL.QGLBuffer.Access',),
        "QGLBuffer.read": ('int', 'int', 'int'),
        "QGLBuffer.release": [(), ('PySide2.QtOpenGL.QGLBuffer.Type',)],
        "QGLBuffer.setUsagePattern": ('PySide2.QtOpenGL.QGLBuffer.UsagePattern',),
        "QGLBuffer.size": (),
        "QGLBuffer.type": (),
        "QGLBuffer.unmap": (),
        "QGLBuffer.usagePattern": (),
        "QGLBuffer.write": ('int', 'int', 'int'),

    # class PySide2.QtOpenGL.QGLColormap:
        "QGLColormap.__init__": [(), ('PySide2.QtOpenGL.QGLColormap',)],
        "QGLColormap.__copy__": (),
        "QGLColormap.entryColor": ('int',),
        "QGLColormap.entryRgb": ('int',),
        "QGLColormap.find": ('int',),
        "QGLColormap.findNearest": ('int',),
        "QGLColormap.handle": (),
        "QGLColormap.isEmpty": (),
        "QGLColormap.setEntry": [('int', 'PySide2.QtGui.QColor'), ('int', 'int')],
        "QGLColormap.setHandle": ('int',),
        "QGLColormap.size": (),

    # class PySide2.QtOpenGL.QGLContext:
        "QGLContext.__init__": ('PySide2.QtOpenGL.QGLFormat',),
        "QGLContext.areSharing": ('PySide2.QtOpenGL.QGLContext', 'PySide2.QtOpenGL.QGLContext'),
        "QGLContext.bindTexture": [('PySide2.QtGui.QImage', 'int', 'int'), ('PySide2.QtGui.QImage', 'int', 'int', 'PySide2.QtOpenGL.QGLContext.BindOptions'), ('PySide2.QtGui.QPixmap', 'int', 'int'), ('PySide2.QtGui.QPixmap', 'int', 'int', 'PySide2.QtOpenGL.QGLContext.BindOptions'), ('str',)],
        "QGLContext.chooseContext": ('PySide2.QtOpenGL.QGLContext',),
        "QGLContext.colorIndex": ('PySide2.QtGui.QColor',),
        "QGLContext.contextHandle": (),
        "QGLContext.create": ('PySide2.QtOpenGL.QGLContext',),
        "QGLContext.currentContext": (),
        "QGLContext.deleteTexture": ('int',),
        "QGLContext.device": (),
        "QGLContext.deviceIsPixmap": (),
        "QGLContext.doneCurrent": (),
        "QGLContext.drawTexture": [('PySide2.QtCore.QPointF', 'int', 'int'), ('PySide2.QtCore.QRectF', 'int', 'int')],
        "QGLContext.format": (),
        "QGLContext.fromOpenGLContext": ('PySide2.QtGui.QOpenGLContext',),
        "QGLContext.initialized": (),
        "QGLContext.isSharing": (),
        "QGLContext.isValid": (),
        "QGLContext.makeCurrent": (),
        "QGLContext.moveToThread": ('PySide2.QtCore.QThread',),
        "QGLContext.overlayTransparentColor": (),
        "QGLContext.requestedFormat": (),
        "QGLContext.reset": (),
        "QGLContext.setDevice": ('PySide2.QtGui.QPaintDevice',),
        "QGLContext.setFormat": ('PySide2.QtOpenGL.QGLFormat',),
        "QGLContext.setInitialized": ('bool',),
        "QGLContext.setTextureCacheLimit": ('int',),
        "QGLContext.setValid": ('bool',),
        "QGLContext.setWindowCreated": ('bool',),
        "QGLContext.swapBuffers": (),
        "QGLContext.textureCacheLimit": (),
        "QGLContext.windowCreated": (),

    # class PySide2.QtOpenGL.QGLFormat:
        "QGLFormat.__init__": [(), ('PySide2.QtOpenGL.QGL.FormatOptions', 'int'), ('PySide2.QtOpenGL.QGLFormat',)],
        "QGLFormat.__copy__": (),
        "QGLFormat.accum": (),
        "QGLFormat.accumBufferSize": (),
        "QGLFormat.alpha": (),
        "QGLFormat.alphaBufferSize": (),
        "QGLFormat.blueBufferSize": (),
        "QGLFormat.defaultFormat": (),
        "QGLFormat.defaultOverlayFormat": (),
        "QGLFormat.depth": (),
        "QGLFormat.depthBufferSize": (),
        "QGLFormat.directRendering": (),
        "QGLFormat.doubleBuffer": (),
        "QGLFormat.fromSurfaceFormat": ('PySide2.QtGui.QSurfaceFormat',),
        "QGLFormat.greenBufferSize": (),
        "QGLFormat.hasOpenGL": (),
        "QGLFormat.hasOpenGLOverlays": (),
        "QGLFormat.hasOverlay": (),
        "QGLFormat.majorVersion": (),
        "QGLFormat.minorVersion": (),
        "QGLFormat.openGLVersionFlags": (),
        "QGLFormat.plane": (),
        "QGLFormat.profile": (),
        "QGLFormat.redBufferSize": (),
        "QGLFormat.rgba": (),
        "QGLFormat.sampleBuffers": (),
        "QGLFormat.samples": (),
        "QGLFormat.setAccum": ('bool',),
        "QGLFormat.setAccumBufferSize": ('int',),
        "QGLFormat.setAlpha": ('bool',),
        "QGLFormat.setAlphaBufferSize": ('int',),
        "QGLFormat.setBlueBufferSize": ('int',),
        "QGLFormat.setDefaultFormat": ('PySide2.QtOpenGL.QGLFormat',),
        "QGLFormat.setDefaultOverlayFormat": ('PySide2.QtOpenGL.QGLFormat',),
        "QGLFormat.setDepth": ('bool',),
        "QGLFormat.setDepthBufferSize": ('int',),
        "QGLFormat.setDirectRendering": ('bool',),
        "QGLFormat.setDoubleBuffer": ('bool',),
        "QGLFormat.setGreenBufferSize": ('int',),
        "QGLFormat.setOption": ('PySide2.QtOpenGL.QGL.FormatOptions',),
        "QGLFormat.setOverlay": ('bool',),
        "QGLFormat.setPlane": ('int',),
        "QGLFormat.setProfile": ('PySide2.QtOpenGL.QGLFormat.OpenGLContextProfile',),
        "QGLFormat.setRedBufferSize": ('int',),
        "QGLFormat.setRgba": ('bool',),
        "QGLFormat.setSampleBuffers": ('bool',),
        "QGLFormat.setSamples": ('int',),
        "QGLFormat.setStencil": ('bool',),
        "QGLFormat.setStencilBufferSize": ('int',),
        "QGLFormat.setStereo": ('bool',),
        "QGLFormat.setSwapInterval": ('int',),
        "QGLFormat.setVersion": ('int', 'int'),
        "QGLFormat.stencil": (),
        "QGLFormat.stencilBufferSize": (),
        "QGLFormat.stereo": (),
        "QGLFormat.swapInterval": (),
        "QGLFormat.testOption": ('PySide2.QtOpenGL.QGL.FormatOptions',),
        "QGLFormat.toSurfaceFormat": ('PySide2.QtOpenGL.QGLFormat',),

    # class PySide2.QtOpenGL.QGLFramebufferObject:
        "QGLFramebufferObject.__init__": [('PySide2.QtCore.QSize', 'PySide2.QtOpenGL.QGLFramebufferObject.Attachment', 'int', 'int'), ('PySide2.QtCore.QSize', 'PySide2.QtOpenGL.QGLFramebufferObjectFormat'), ('PySide2.QtCore.QSize', 'int'), ('int', 'int', 'PySide2.QtOpenGL.QGLFramebufferObject.Attachment', 'int', 'int'), ('int', 'int', 'PySide2.QtOpenGL.QGLFramebufferObjectFormat'), ('int', 'int', 'int')],
        "QGLFramebufferObject.attachment": (),
        "QGLFramebufferObject.bind": (),
        "QGLFramebufferObject.bindDefault": (),
        "QGLFramebufferObject.blitFramebuffer": ('PySide2.QtOpenGL.QGLFramebufferObject', 'PySide2.QtCore.QRect', 'PySide2.QtOpenGL.QGLFramebufferObject', 'PySide2.QtCore.QRect', 'int', 'int'),
        "QGLFramebufferObject.devType": (),
        "QGLFramebufferObject.drawTexture": [('PySide2.QtCore.QPointF', 'int', 'int'), ('PySide2.QtCore.QRectF', 'int', 'int')],
        "QGLFramebufferObject.format": (),
        "QGLFramebufferObject.handle": (),
        "QGLFramebufferObject.hasOpenGLFramebufferBlit": (),
        "QGLFramebufferObject.hasOpenGLFramebufferObjects": (),
        "QGLFramebufferObject.isBound": (),
        "QGLFramebufferObject.isValid": (),
        "QGLFramebufferObject.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
        "QGLFramebufferObject.paintEngine": (),
        "QGLFramebufferObject.release": (),
        "QGLFramebufferObject.size": (),
        "QGLFramebufferObject.texture": (),
        "QGLFramebufferObject.toImage": (),

    # class PySide2.QtOpenGL.QGLFramebufferObjectFormat:
        "QGLFramebufferObjectFormat.__init__": [(), ('PySide2.QtOpenGL.QGLFramebufferObjectFormat',)],
        "QGLFramebufferObjectFormat.__copy__": (),
        "QGLFramebufferObjectFormat.attachment": (),
        "QGLFramebufferObjectFormat.internalTextureFormat": (),
        "QGLFramebufferObjectFormat.mipmap": (),
        "QGLFramebufferObjectFormat.samples": (),
        "QGLFramebufferObjectFormat.setAttachment": ('PySide2.QtOpenGL.QGLFramebufferObject.Attachment',),
        "QGLFramebufferObjectFormat.setInternalTextureFormat": ('int',),
        "QGLFramebufferObjectFormat.setMipmap": ('bool',),
        "QGLFramebufferObjectFormat.setSamples": ('int',),
        "QGLFramebufferObjectFormat.setTextureTarget": ('int',),
        "QGLFramebufferObjectFormat.textureTarget": (),

    # class PySide2.QtOpenGL.QGLPixelBuffer:
        "QGLPixelBuffer.__init__": [('PySide2.QtCore.QSize', 'PySide2.QtOpenGL.QGLFormat', 'PySide2.QtOpenGL.QGLWidget'), ('int', 'int', 'PySide2.QtOpenGL.QGLFormat', 'PySide2.QtOpenGL.QGLWidget')],
        "QGLPixelBuffer.bindTexture": [('PySide2.QtGui.QImage', 'int'), ('PySide2.QtGui.QPixmap', 'int'), ('str',)],
        "QGLPixelBuffer.bindToDynamicTexture": ('int',),
        "QGLPixelBuffer.context": (),
        "QGLPixelBuffer.deleteTexture": ('int',),
        "QGLPixelBuffer.devType": (),
        "QGLPixelBuffer.doneCurrent": (),
        "QGLPixelBuffer.drawTexture": [('PySide2.QtCore.QPointF', 'int', 'int'), ('PySide2.QtCore.QRectF', 'int', 'int')],
        "QGLPixelBuffer.format": (),
        "QGLPixelBuffer.generateDynamicTexture": (),
        "QGLPixelBuffer.handle": (),
        "QGLPixelBuffer.hasOpenGLPbuffers": (),
        "QGLPixelBuffer.isValid": (),
        "QGLPixelBuffer.makeCurrent": (),
        "QGLPixelBuffer.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
        "QGLPixelBuffer.paintEngine": (),
        "QGLPixelBuffer.releaseFromDynamicTexture": (),
        "QGLPixelBuffer.size": (),
        "QGLPixelBuffer.toImage": (),
        "QGLPixelBuffer.updateDynamicTexture": ('int',),

    # class PySide2.QtOpenGL.QGLShader:
        "QGLShader.__init__": [('PySide2.QtOpenGL.QGLShader.ShaderType', 'PySide2.QtCore.QObject'), ('PySide2.QtOpenGL.QGLShader.ShaderType', 'PySide2.QtOpenGL.QGLContext', 'PySide2.QtCore.QObject')],
        "QGLShader.compileSourceCode": [('PySide2.QtCore.QByteArray',), ('str',)],
        "QGLShader.compileSourceFile": ('str',),
        "QGLShader.hasOpenGLShaders": ('PySide2.QtOpenGL.QGLShader.ShaderType', 'PySide2.QtOpenGL.QGLContext'),
        "QGLShader.isCompiled": (),
        "QGLShader.log": (),
        "QGLShader.shaderId": (),
        "QGLShader.shaderType": (),
        "QGLShader.sourceCode": (),

    # class PySide2.QtOpenGL.QGLShaderProgram:
        "QGLShaderProgram.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtOpenGL.QGLContext', 'PySide2.QtCore.QObject')],
        "QGLShaderProgram.addShader": ('PySide2.QtOpenGL.QGLShader',),
        "QGLShaderProgram.addShaderFromSourceCode": [('PySide2.QtOpenGL.QGLShader.ShaderType', 'PySide2.QtCore.QByteArray'), ('PySide2.QtOpenGL.QGLShader.ShaderType', 'str')],
        "QGLShaderProgram.addShaderFromSourceFile": ('PySide2.QtOpenGL.QGLShader.ShaderType', 'str'),
        "QGLShaderProgram.attributeLocation": [('PySide2.QtCore.QByteArray',), ('str',)],
        "QGLShaderProgram.bind": (),
        "QGLShaderProgram.bindAttributeLocation": [('PySide2.QtCore.QByteArray', 'int'), ('str', 'int')],
        "QGLShaderProgram.disableAttributeArray": [('int',), ('str',)],
        "QGLShaderProgram.enableAttributeArray": [('int',), ('str',)],
        "QGLShaderProgram.geometryInputType": (),
        "QGLShaderProgram.geometryOutputType": (),
        "QGLShaderProgram.geometryOutputVertexCount": (),
        "QGLShaderProgram.hasOpenGLShaderPrograms": ('PySide2.QtOpenGL.QGLContext',),
        "QGLShaderProgram.isLinked": (),
        "QGLShaderProgram.link": (),
        "QGLShaderProgram.log": (),
        "QGLShaderProgram.maxGeometryOutputVertices": (),
        "QGLShaderProgram.programId": (),
        "QGLShaderProgram.release": (),
        "QGLShaderProgram.removeAllShaders": (),
        "QGLShaderProgram.removeShader": ('PySide2.QtOpenGL.QGLShader',),
        "QGLShaderProgram.setAttributeArray2D": [('int', 'PySide2.QtGui.QVector2D', 'int'), ('str', 'PySide2.QtGui.QVector2D', 'int')],
        "QGLShaderProgram.setAttributeArray3D": [('int', 'PySide2.QtGui.QVector3D', 'int'), ('str', 'PySide2.QtGui.QVector3D', 'int')],
        "QGLShaderProgram.setAttributeArray4D": [('int', 'PySide2.QtGui.QVector4D', 'int'), ('str', 'PySide2.QtGui.QVector4D', 'int')],
        "QGLShaderProgram.setAttributeBuffer": [('int', 'int', 'int', 'int', 'int'), ('str', 'int', 'int', 'int', 'int')],
        "QGLShaderProgram.setAttributeValue": [('int', 'PySide2.QtGui.QColor'), ('int', 'PySide2.QtGui.QVector2D'), ('int', 'PySide2.QtGui.QVector3D'), ('int', 'PySide2.QtGui.QVector4D'), ('int', 'float'), ('int', 'float', 'float'), ('int', 'float', 'float', 'float'), ('int', 'float', 'float', 'float', 'float'), ('str', 'PySide2.QtGui.QColor'), ('str', 'PySide2.QtGui.QVector2D'), ('str', 'PySide2.QtGui.QVector3D'), ('str', 'PySide2.QtGui.QVector4D'), ('str', 'float'), ('str', 'float', 'float'), ('str', 'float', 'float', 'float'), ('str', 'float', 'float', 'float', 'float')],
        "QGLShaderProgram.setGeometryInputType": ('int',),
        "QGLShaderProgram.setGeometryOutputType": ('int',),
        "QGLShaderProgram.setGeometryOutputVertexCount": ('int',),
        "QGLShaderProgram.setUniformValue": [('int', 'PySide2.QtCore.QPoint'), ('int', 'PySide2.QtCore.QPointF'), ('int', 'PySide2.QtCore.QSize'), ('int', 'PySide2.QtCore.QSizeF'), ('int', 'PySide2.QtGui.QColor'), ('int', 'PySide2.QtGui.QMatrix2x2'), ('int', 'PySide2.QtGui.QMatrix2x3'), ('int', 'PySide2.QtGui.QMatrix2x4'), ('int', 'PySide2.QtGui.QMatrix3x2'), ('int', 'PySide2.QtGui.QMatrix3x3'), ('int', 'PySide2.QtGui.QMatrix3x4'), ('int', 'PySide2.QtGui.QMatrix4x2'), ('int', 'PySide2.QtGui.QMatrix4x3'), ('int', 'PySide2.QtGui.QMatrix4x4'), ('int', 'PySide2.QtGui.QTransform'), ('int', 'PySide2.QtGui.QVector2D'), ('int', 'PySide2.QtGui.QVector3D'), ('int', 'PySide2.QtGui.QVector4D'), ('int', 'float'), ('int', 'float', 'float'), ('int', 'float', 'float', 'float'), ('int', 'float', 'float', 'float', 'float'), ('int', 'int'), ('str', 'PySide2.QtCore.QPoint'), ('str', 'PySide2.QtCore.QPointF'), ('str', 'PySide2.QtCore.QSize'), ('str', 'PySide2.QtCore.QSizeF'), ('str', 'PySide2.QtGui.QColor'), ('str', 'PySide2.QtGui.QMatrix2x2'), ('str', 'PySide2.QtGui.QMatrix2x3'), ('str', 'PySide2.QtGui.QMatrix2x4'), ('str', 'PySide2.QtGui.QMatrix3x2'), ('str', 'PySide2.QtGui.QMatrix3x3'), ('str', 'PySide2.QtGui.QMatrix3x4'), ('str', 'PySide2.QtGui.QMatrix4x2'), ('str', 'PySide2.QtGui.QMatrix4x3'), ('str', 'PySide2.QtGui.QMatrix4x4'), ('str', 'PySide2.QtGui.QTransform'), ('str', 'PySide2.QtGui.QVector2D'), ('str', 'PySide2.QtGui.QVector3D'), ('str', 'PySide2.QtGui.QVector4D'), ('str', 'float'), ('str', 'float', 'float'), ('str', 'float', 'float', 'float'), ('str', 'float', 'float', 'float', 'float'), ('str', 'int')],
        "QGLShaderProgram.setUniformValueArray2D": [('int', 'PySide2.QtGui.QVector2D', 'int'), ('str', 'PySide2.QtGui.QVector2D', 'int')],
        "QGLShaderProgram.setUniformValueArray2x2": [('int', 'PySide2.QtGui.QMatrix2x2', 'int'), ('str', 'PySide2.QtGui.QMatrix2x2', 'int')],
        "QGLShaderProgram.setUniformValueArray2x3": [('int', 'PySide2.QtGui.QMatrix2x3', 'int'), ('str', 'PySide2.QtGui.QMatrix2x3', 'int')],
        "QGLShaderProgram.setUniformValueArray2x4": [('int', 'PySide2.QtGui.QMatrix2x4', 'int'), ('str', 'PySide2.QtGui.QMatrix2x4', 'int')],
        "QGLShaderProgram.setUniformValueArray3D": [('int', 'PySide2.QtGui.QVector3D', 'int'), ('str', 'PySide2.QtGui.QVector3D', 'int')],
        "QGLShaderProgram.setUniformValueArray3x2": [('int', 'PySide2.QtGui.QMatrix3x2', 'int'), ('str', 'PySide2.QtGui.QMatrix3x2', 'int')],
        "QGLShaderProgram.setUniformValueArray3x3": [('int', 'PySide2.QtGui.QMatrix3x3', 'int'), ('str', 'PySide2.QtGui.QMatrix3x3', 'int')],
        "QGLShaderProgram.setUniformValueArray3x4": [('int', 'PySide2.QtGui.QMatrix3x4', 'int'), ('str', 'PySide2.QtGui.QMatrix3x4', 'int')],
        "QGLShaderProgram.setUniformValueArray4D": [('int', 'PySide2.QtGui.QVector4D', 'int'), ('str', 'PySide2.QtGui.QVector4D', 'int')],
        "QGLShaderProgram.setUniformValueArray4x2": [('int', 'PySide2.QtGui.QMatrix4x2', 'int'), ('str', 'PySide2.QtGui.QMatrix4x2', 'int')],
        "QGLShaderProgram.setUniformValueArray4x3": [('int', 'PySide2.QtGui.QMatrix4x3', 'int'), ('str', 'PySide2.QtGui.QMatrix4x3', 'int')],
        "QGLShaderProgram.setUniformValueArray4x4": [('int', 'PySide2.QtGui.QMatrix4x4', 'int'), ('str', 'PySide2.QtGui.QMatrix4x4', 'int')],
        "QGLShaderProgram.setUniformValueArrayInt": [('int', 'int', 'int'), ('str', 'int', 'int')],
        "QGLShaderProgram.setUniformValueArrayUint": [('int', 'int', 'int'), ('str', 'int', 'int')],
        "QGLShaderProgram.shaders": (),
        "QGLShaderProgram.uniformLocation": [('PySide2.QtCore.QByteArray',), ('str',)],

    # class PySide2.QtOpenGL.QGLWidget:
        "QGLWidget.__init__": [('PySide2.QtOpenGL.QGLContext', 'PySide2.QtWidgets.QWidget', 'PySide2.QtOpenGL.QGLWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('PySide2.QtOpenGL.QGLFormat', 'PySide2.QtWidgets.QWidget', 'PySide2.QtOpenGL.QGLWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtOpenGL.QGLWidget', 'PySide2.QtCore.Qt.WindowFlags')],
        "QGLWidget.autoBufferSwap": (),
        "QGLWidget.bindTexture": [('PySide2.QtGui.QImage', 'int', 'int'), ('PySide2.QtGui.QImage', 'int', 'int', 'PySide2.QtOpenGL.QGLContext.BindOptions'), ('PySide2.QtGui.QPixmap', 'int', 'int'), ('PySide2.QtGui.QPixmap', 'int', 'int', 'PySide2.QtOpenGL.QGLContext.BindOptions'), ('str',)],
        "QGLWidget.colormap": (),
        "QGLWidget.context": (),
        "QGLWidget.convertToGLFormat": ('PySide2.QtGui.QImage',),
        "QGLWidget.deleteTexture": ('int',),
        "QGLWidget.doneCurrent": (),
        "QGLWidget.doubleBuffer": (),
        "QGLWidget.drawTexture": [('PySide2.QtCore.QPointF', 'int', 'int'), ('PySide2.QtCore.QRectF', 'int', 'int')],
        "QGLWidget.event": ('PySide2.QtCore.QEvent',),
        "QGLWidget.format": (),
        "QGLWidget.glDraw": (),
        "QGLWidget.glInit": (),
        "QGLWidget.grabFrameBuffer": ('bool',),
        "QGLWidget.initializeGL": (),
        "QGLWidget.initializeOverlayGL": (),
        "QGLWidget.isSharing": (),
        "QGLWidget.isValid": (),
        "QGLWidget.makeCurrent": (),
        "QGLWidget.makeOverlayCurrent": (),
        "QGLWidget.overlayContext": (),
        "QGLWidget.paintEngine": (),
        "QGLWidget.paintEvent": ('PySide2.QtGui.QPaintEvent',),
        "QGLWidget.paintGL": (),
        "QGLWidget.paintOverlayGL": (),
        "QGLWidget.qglClearColor": ('PySide2.QtGui.QColor',),
        "QGLWidget.qglColor": ('PySide2.QtGui.QColor',),
        "QGLWidget.renderPixmap": ('int', 'int', 'bool'),
        "QGLWidget.renderText": [('float', 'float', 'float', 'str', 'PySide2.QtGui.QFont'), ('int', 'int', 'str', 'PySide2.QtGui.QFont')],
        "QGLWidget.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
        "QGLWidget.resizeGL": ('int', 'int'),
        "QGLWidget.resizeOverlayGL": ('int', 'int'),
        "QGLWidget.setAutoBufferSwap": ('bool',),
        "QGLWidget.setColormap": ('PySide2.QtOpenGL.QGLColormap',),
        "QGLWidget.swapBuffers": (),
        "QGLWidget.updateGL": (),
        "QGLWidget.updateOverlayGL": (),
    })

# Module PySide2.QtPositioning
if "PySide2.QtPositioning" in sys.modules:
    dict.update({

    # class PySide2.QtPositioning.QGeoAddress:
        "QGeoAddress.__init__": [(), ('PySide2.QtPositioning.QGeoAddress',)],
        "QGeoAddress.__copy__": (),
        "QGeoAddress.city": (),
        "QGeoAddress.clear": (),
        "QGeoAddress.country": (),
        "QGeoAddress.countryCode": (),
        "QGeoAddress.county": (),
        "QGeoAddress.district": (),
        "QGeoAddress.isEmpty": (),
        "QGeoAddress.isTextGenerated": (),
        "QGeoAddress.postalCode": (),
        "QGeoAddress.setCity": ('str',),
        "QGeoAddress.setCountry": ('str',),
        "QGeoAddress.setCountryCode": ('str',),
        "QGeoAddress.setCounty": ('str',),
        "QGeoAddress.setDistrict": ('str',),
        "QGeoAddress.setPostalCode": ('str',),
        "QGeoAddress.setState": ('str',),
        "QGeoAddress.setStreet": ('str',),
        "QGeoAddress.setText": ('str',),
        "QGeoAddress.state": (),
        "QGeoAddress.street": (),
        "QGeoAddress.text": (),

    # class PySide2.QtPositioning.QGeoAreaMonitorInfo:
        "QGeoAreaMonitorInfo.__init__": [('PySide2.QtPositioning.QGeoAreaMonitorInfo',), ('str',)],
        "QGeoAreaMonitorInfo.__copy__": (),
        "QGeoAreaMonitorInfo.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QGeoAreaMonitorInfo.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QGeoAreaMonitorInfo.area": (),
        "QGeoAreaMonitorInfo.expiration": (),
        "QGeoAreaMonitorInfo.identifier": (),
        "QGeoAreaMonitorInfo.isPersistent": (),
        "QGeoAreaMonitorInfo.isValid": (),
        "QGeoAreaMonitorInfo.name": (),
        "QGeoAreaMonitorInfo.notificationParameters": (),
        "QGeoAreaMonitorInfo.setArea": ('PySide2.QtPositioning.QGeoShape',),
        "QGeoAreaMonitorInfo.setExpiration": ('PySide2.QtCore.QDateTime',),
        "QGeoAreaMonitorInfo.setName": ('str',),
        "QGeoAreaMonitorInfo.setNotificationParameters": ('dict',),
        "QGeoAreaMonitorInfo.setPersistent": ('bool',),

    # class PySide2.QtPositioning.QGeoAreaMonitorSource:
        "QGeoAreaMonitorSource.__init__": ('PySide2.QtCore.QObject',),
        "QGeoAreaMonitorSource.activeMonitors": [(), ('PySide2.QtPositioning.QGeoShape',)],
        "QGeoAreaMonitorSource.availableSources": (),
        "QGeoAreaMonitorSource.createDefaultSource": ('PySide2.QtCore.QObject',),
        "QGeoAreaMonitorSource.createSource": ('str', 'PySide2.QtCore.QObject'),
        "QGeoAreaMonitorSource.error": (),
        "QGeoAreaMonitorSource.positionInfoSource": (),
        "QGeoAreaMonitorSource.requestUpdate": ('PySide2.QtPositioning.QGeoAreaMonitorInfo', 'str'),
        "QGeoAreaMonitorSource.setPositionInfoSource": ('PySide2.QtPositioning.QGeoPositionInfoSource',),
        "QGeoAreaMonitorSource.sourceName": (),
        "QGeoAreaMonitorSource.startMonitoring": ('PySide2.QtPositioning.QGeoAreaMonitorInfo',),
        "QGeoAreaMonitorSource.stopMonitoring": ('PySide2.QtPositioning.QGeoAreaMonitorInfo',),
        "QGeoAreaMonitorSource.supportedAreaMonitorFeatures": (),

    # class PySide2.QtPositioning.QGeoCircle:
        "QGeoCircle.__init__": [(), ('PySide2.QtPositioning.QGeoCircle',), ('PySide2.QtPositioning.QGeoCoordinate', 'float'), ('PySide2.QtPositioning.QGeoShape',)],
        "QGeoCircle.__copy__": (),
        "QGeoCircle.center": (),
        "QGeoCircle.extendCircle": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoCircle.radius": (),
        "QGeoCircle.setCenter": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoCircle.setRadius": ('float',),
        "QGeoCircle.toString": (),
        "QGeoCircle.translate": ('float', 'float'),
        "QGeoCircle.translated": ('float', 'float'),

    # class PySide2.QtPositioning.QGeoCoordinate:
        "QGeoCoordinate.__init__": [(), ('PySide2.QtPositioning.QGeoCoordinate',), ('float', 'float'), ('float', 'float', 'float')],
        "QGeoCoordinate.__copy__": (),
        "QGeoCoordinate.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QGeoCoordinate.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QGeoCoordinate.altitude": (),
        "QGeoCoordinate.atDistanceAndAzimuth": ('float', 'float', 'float'),
        "QGeoCoordinate.azimuthTo": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoCoordinate.distanceTo": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoCoordinate.isValid": (),
        "QGeoCoordinate.latitude": (),
        "QGeoCoordinate.longitude": (),
        "QGeoCoordinate.setAltitude": ('float',),
        "QGeoCoordinate.setLatitude": ('float',),
        "QGeoCoordinate.setLongitude": ('float',),
        "QGeoCoordinate.toString": ('PySide2.QtPositioning.QGeoCoordinate.CoordinateFormat',),
        "QGeoCoordinate.type": (),

    # class PySide2.QtPositioning.QGeoLocation:
        "QGeoLocation.__init__": [(), ('PySide2.QtPositioning.QGeoLocation',)],
        "QGeoLocation.__copy__": (),
        "QGeoLocation.address": (),
        "QGeoLocation.boundingBox": (),
        "QGeoLocation.coordinate": (),
        "QGeoLocation.isEmpty": (),
        "QGeoLocation.setAddress": ('PySide2.QtPositioning.QGeoAddress',),
        "QGeoLocation.setBoundingBox": ('PySide2.QtPositioning.QGeoRectangle',),
        "QGeoLocation.setCoordinate": ('PySide2.QtPositioning.QGeoCoordinate',),

    # class PySide2.QtPositioning.QGeoPath:
        "QGeoPath.__init__": [(), ('PySide2.QtPositioning.QGeoPath',), ('PySide2.QtPositioning.QGeoShape',), ('list', 'float')],
        "QGeoPath.__copy__": (),
        "QGeoPath.addCoordinate": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoPath.clearPath": (),
        "QGeoPath.containsCoordinate": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoPath.coordinateAt": ('int',),
        "QGeoPath.insertCoordinate": ('int', 'PySide2.QtPositioning.QGeoCoordinate'),
        "QGeoPath.length": ('int', 'int'),
        "QGeoPath.path": (),
        "QGeoPath.removeCoordinate": [('PySide2.QtPositioning.QGeoCoordinate',), ('int',)],
        "QGeoPath.replaceCoordinate": ('int', 'PySide2.QtPositioning.QGeoCoordinate'),
        "QGeoPath.setPath": ('list',),
        "QGeoPath.setVariantPath": ('list',),
        "QGeoPath.setWidth": ('float',),
        "QGeoPath.size": (),
        "QGeoPath.toString": (),
        "QGeoPath.translate": ('float', 'float'),
        "QGeoPath.translated": ('float', 'float'),
        "QGeoPath.variantPath": (),
        "QGeoPath.width": (),

    # class PySide2.QtPositioning.QGeoPolygon:
        "QGeoPolygon.__init__": [(), ('PySide2.QtPositioning.QGeoPolygon',), ('PySide2.QtPositioning.QGeoShape',), ('list',)],
        "QGeoPolygon.__copy__": (),
        "QGeoPolygon.addCoordinate": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoPolygon.addHole": [('list',), ('typing.Any',)],
        "QGeoPolygon.containsCoordinate": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoPolygon.coordinateAt": ('int',),
        "QGeoPolygon.hole": ('int',),
        "QGeoPolygon.holePath": ('int',),
        "QGeoPolygon.holesCount": (),
        "QGeoPolygon.insertCoordinate": ('int', 'PySide2.QtPositioning.QGeoCoordinate'),
        "QGeoPolygon.length": ('int', 'int'),
        "QGeoPolygon.path": (),
        "QGeoPolygon.perimeter": (),
        "QGeoPolygon.removeCoordinate": [('PySide2.QtPositioning.QGeoCoordinate',), ('int',)],
        "QGeoPolygon.removeHole": ('int',),
        "QGeoPolygon.replaceCoordinate": ('int', 'PySide2.QtPositioning.QGeoCoordinate'),
        "QGeoPolygon.setPath": ('list',),
        "QGeoPolygon.setPerimeter": ('list',),
        "QGeoPolygon.size": (),
        "QGeoPolygon.toString": (),
        "QGeoPolygon.translate": ('float', 'float'),
        "QGeoPolygon.translated": ('float', 'float'),

    # class PySide2.QtPositioning.QGeoPositionInfo:
        "QGeoPositionInfo.__init__": [(), ('PySide2.QtPositioning.QGeoCoordinate', 'PySide2.QtCore.QDateTime'), ('PySide2.QtPositioning.QGeoPositionInfo',)],
        "QGeoPositionInfo.__copy__": (),
        "QGeoPositionInfo.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QGeoPositionInfo.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QGeoPositionInfo.attribute": ('PySide2.QtPositioning.QGeoPositionInfo.Attribute',),
        "QGeoPositionInfo.coordinate": (),
        "QGeoPositionInfo.hasAttribute": ('PySide2.QtPositioning.QGeoPositionInfo.Attribute',),
        "QGeoPositionInfo.isValid": (),
        "QGeoPositionInfo.removeAttribute": ('PySide2.QtPositioning.QGeoPositionInfo.Attribute',),
        "QGeoPositionInfo.setAttribute": ('PySide2.QtPositioning.QGeoPositionInfo.Attribute', 'float'),
        "QGeoPositionInfo.setCoordinate": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoPositionInfo.setTimestamp": ('PySide2.QtCore.QDateTime',),
        "QGeoPositionInfo.timestamp": (),

    # class PySide2.QtPositioning.QGeoPositionInfoSource:
        "QGeoPositionInfoSource.__init__": ('PySide2.QtCore.QObject',),
        "QGeoPositionInfoSource.availableSources": (),
        "QGeoPositionInfoSource.createDefaultSource": ('PySide2.QtCore.QObject',),
        "QGeoPositionInfoSource.createSource": ('str', 'PySide2.QtCore.QObject'),
        "QGeoPositionInfoSource.error": (),
        "QGeoPositionInfoSource.lastKnownPosition": ('bool',),
        "QGeoPositionInfoSource.minimumUpdateInterval": (),
        "QGeoPositionInfoSource.preferredPositioningMethods": (),
        "QGeoPositionInfoSource.requestUpdate": ('int',),
        "QGeoPositionInfoSource.setPreferredPositioningMethods": ('PySide2.QtPositioning.QGeoPositionInfoSource.PositioningMethods',),
        "QGeoPositionInfoSource.setUpdateInterval": ('int',),
        "QGeoPositionInfoSource.sourceName": (),
        "QGeoPositionInfoSource.startUpdates": (),
        "QGeoPositionInfoSource.stopUpdates": (),
        "QGeoPositionInfoSource.supportedPositioningMethods": (),
        "QGeoPositionInfoSource.updateInterval": (),

    # class PySide2.QtPositioning.QGeoPositionInfoSourceFactory:
        "QGeoPositionInfoSourceFactory.__init__": (),
        "QGeoPositionInfoSourceFactory.areaMonitor": ('PySide2.QtCore.QObject',),
        "QGeoPositionInfoSourceFactory.positionInfoSource": ('PySide2.QtCore.QObject',),
        "QGeoPositionInfoSourceFactory.satelliteInfoSource": ('PySide2.QtCore.QObject',),

    # class PySide2.QtPositioning.QGeoRectangle:
        "QGeoRectangle.__init__": [(), ('PySide2.QtPositioning.QGeoCoordinate', 'PySide2.QtPositioning.QGeoCoordinate'), ('PySide2.QtPositioning.QGeoCoordinate', 'float', 'float'), ('PySide2.QtPositioning.QGeoRectangle',), ('PySide2.QtPositioning.QGeoShape',), ('list',)],
        "QGeoRectangle.__copy__": (),
        "QGeoRectangle.__ior__": ('PySide2.QtPositioning.QGeoRectangle',),
        "QGeoRectangle.__or__": ('PySide2.QtPositioning.QGeoRectangle',),
        "QGeoRectangle.bottomLeft": (),
        "QGeoRectangle.bottomRight": (),
        "QGeoRectangle.center": (),
        "QGeoRectangle.contains": [('PySide2.QtPositioning.QGeoCoordinate',), ('PySide2.QtPositioning.QGeoRectangle',)],
        "QGeoRectangle.extendRectangle": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoRectangle.height": (),
        "QGeoRectangle.intersects": ('PySide2.QtPositioning.QGeoRectangle',),
        "QGeoRectangle.setBottomLeft": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoRectangle.setBottomRight": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoRectangle.setCenter": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoRectangle.setHeight": ('float',),
        "QGeoRectangle.setTopLeft": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoRectangle.setTopRight": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoRectangle.setWidth": ('float',),
        "QGeoRectangle.toString": (),
        "QGeoRectangle.topLeft": (),
        "QGeoRectangle.topRight": (),
        "QGeoRectangle.translate": ('float', 'float'),
        "QGeoRectangle.translated": ('float', 'float'),
        "QGeoRectangle.united": ('PySide2.QtPositioning.QGeoRectangle',),
        "QGeoRectangle.width": (),

    # class PySide2.QtPositioning.QGeoSatelliteInfo:
        "QGeoSatelliteInfo.__init__": [(), ('PySide2.QtPositioning.QGeoSatelliteInfo',)],
        "QGeoSatelliteInfo.__copy__": (),
        "QGeoSatelliteInfo.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QGeoSatelliteInfo.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QGeoSatelliteInfo.attribute": ('PySide2.QtPositioning.QGeoSatelliteInfo.Attribute',),
        "QGeoSatelliteInfo.hasAttribute": ('PySide2.QtPositioning.QGeoSatelliteInfo.Attribute',),
        "QGeoSatelliteInfo.removeAttribute": ('PySide2.QtPositioning.QGeoSatelliteInfo.Attribute',),
        "QGeoSatelliteInfo.satelliteIdentifier": (),
        "QGeoSatelliteInfo.satelliteSystem": (),
        "QGeoSatelliteInfo.setAttribute": ('PySide2.QtPositioning.QGeoSatelliteInfo.Attribute', 'float'),
        "QGeoSatelliteInfo.setSatelliteIdentifier": ('int',),
        "QGeoSatelliteInfo.setSatelliteSystem": ('PySide2.QtPositioning.QGeoSatelliteInfo.SatelliteSystem',),
        "QGeoSatelliteInfo.setSignalStrength": ('int',),
        "QGeoSatelliteInfo.signalStrength": (),

    # class PySide2.QtPositioning.QGeoSatelliteInfoSource:
        "QGeoSatelliteInfoSource.__init__": ('PySide2.QtCore.QObject',),
        "QGeoSatelliteInfoSource.availableSources": (),
        "QGeoSatelliteInfoSource.createDefaultSource": ('PySide2.QtCore.QObject',),
        "QGeoSatelliteInfoSource.createSource": ('str', 'PySide2.QtCore.QObject'),
        "QGeoSatelliteInfoSource.error": (),
        "QGeoSatelliteInfoSource.minimumUpdateInterval": (),
        "QGeoSatelliteInfoSource.requestUpdate": ('int',),
        "QGeoSatelliteInfoSource.setUpdateInterval": ('int',),
        "QGeoSatelliteInfoSource.sourceName": (),
        "QGeoSatelliteInfoSource.startUpdates": (),
        "QGeoSatelliteInfoSource.stopUpdates": (),
        "QGeoSatelliteInfoSource.updateInterval": (),

    # class PySide2.QtPositioning.QGeoShape:
        "QGeoShape.__init__": [(), ('PySide2.QtPositioning.QGeoShape',)],
        "QGeoShape.__copy__": (),
        "QGeoShape.__lshift__": ('PySide2.QtCore.QDataStream',),
        "QGeoShape.__rshift__": ('PySide2.QtCore.QDataStream',),
        "QGeoShape.boundingGeoRectangle": (),
        "QGeoShape.center": (),
        "QGeoShape.contains": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoShape.extendShape": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoShape.isEmpty": (),
        "QGeoShape.isValid": (),
        "QGeoShape.toString": (),
        "QGeoShape.type": (),

    # class PySide2.QtPositioning.QNmeaPositionInfoSource:
        "QNmeaPositionInfoSource.__init__": ('PySide2.QtPositioning.QNmeaPositionInfoSource.UpdateMode', 'PySide2.QtCore.QObject'),
        "QNmeaPositionInfoSource.device": (),
        "QNmeaPositionInfoSource.error": (),
        "QNmeaPositionInfoSource.lastKnownPosition": ('bool',),
        "QNmeaPositionInfoSource.minimumUpdateInterval": (),
        "QNmeaPositionInfoSource.parsePosInfoFromNmeaData": ('str', 'int', 'PySide2.QtPositioning.QGeoPositionInfo', 'bool'),
        "QNmeaPositionInfoSource.requestUpdate": ('int',),
        "QNmeaPositionInfoSource.setDevice": ('PySide2.QtCore.QIODevice',),
        "QNmeaPositionInfoSource.setUpdateInterval": ('int',),
        "QNmeaPositionInfoSource.setUserEquivalentRangeError": ('float',),
        "QNmeaPositionInfoSource.startUpdates": (),
        "QNmeaPositionInfoSource.stopUpdates": (),
        "QNmeaPositionInfoSource.supportedPositioningMethods": (),
        "QNmeaPositionInfoSource.updateMode": (),
        "QNmeaPositionInfoSource.userEquivalentRangeError": (),
    })

# Module PySide2.QtLocation
if "PySide2.QtLocation" in sys.modules:
    dict.update({

    # class PySide2.QtLocation.QGeoCodeReply:
        "QGeoCodeReply.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtLocation.QGeoCodeReply.Error', 'str', 'PySide2.QtCore.QObject')],
        "QGeoCodeReply.abort": (),
        "QGeoCodeReply.addLocation": ('PySide2.QtPositioning.QGeoLocation',),
        "QGeoCodeReply.error": (),
        "QGeoCodeReply.errorString": (),
        "QGeoCodeReply.isFinished": (),
        "QGeoCodeReply.limit": (),
        "QGeoCodeReply.locations": (),
        "QGeoCodeReply.offset": (),
        "QGeoCodeReply.setError": ('PySide2.QtLocation.QGeoCodeReply.Error', 'str'),
        "QGeoCodeReply.setFinished": ('bool',),
        "QGeoCodeReply.setLimit": ('int',),
        "QGeoCodeReply.setLocations": ('list',),
        "QGeoCodeReply.setOffset": ('int',),
        "QGeoCodeReply.setViewport": ('PySide2.QtPositioning.QGeoShape',),
        "QGeoCodeReply.viewport": (),

    # class PySide2.QtLocation.QGeoCodingManager:
        "QGeoCodingManager.geocode": [('PySide2.QtPositioning.QGeoAddress', 'PySide2.QtPositioning.QGeoShape'), ('str', 'int', 'int', 'PySide2.QtPositioning.QGeoShape')],
        "QGeoCodingManager.locale": (),
        "QGeoCodingManager.managerName": (),
        "QGeoCodingManager.managerVersion": (),
        "QGeoCodingManager.reverseGeocode": ('PySide2.QtPositioning.QGeoCoordinate', 'PySide2.QtPositioning.QGeoShape'),
        "QGeoCodingManager.setLocale": ('PySide2.QtCore.QLocale',),

    # class PySide2.QtLocation.QGeoCodingManagerEngine:
        "QGeoCodingManagerEngine.__init__": ('dict', 'PySide2.QtCore.QObject'),
        "QGeoCodingManagerEngine.geocode": [('PySide2.QtPositioning.QGeoAddress', 'PySide2.QtPositioning.QGeoShape'), ('str', 'int', 'int', 'PySide2.QtPositioning.QGeoShape')],
        "QGeoCodingManagerEngine.locale": (),
        "QGeoCodingManagerEngine.managerName": (),
        "QGeoCodingManagerEngine.managerVersion": (),
        "QGeoCodingManagerEngine.reverseGeocode": ('PySide2.QtPositioning.QGeoCoordinate', 'PySide2.QtPositioning.QGeoShape'),
        "QGeoCodingManagerEngine.setLocale": ('PySide2.QtCore.QLocale',),

    # class PySide2.QtLocation.QGeoManeuver:
        "QGeoManeuver.__init__": [(), ('PySide2.QtLocation.QGeoManeuver',)],
        "QGeoManeuver.__copy__": (),
        "QGeoManeuver.direction": (),
        "QGeoManeuver.distanceToNextInstruction": (),
        "QGeoManeuver.extendedAttributes": (),
        "QGeoManeuver.instructionText": (),
        "QGeoManeuver.isValid": (),
        "QGeoManeuver.position": (),
        "QGeoManeuver.setDirection": ('PySide2.QtLocation.QGeoManeuver.InstructionDirection',),
        "QGeoManeuver.setDistanceToNextInstruction": ('float',),
        "QGeoManeuver.setExtendedAttributes": ('dict',),
        "QGeoManeuver.setInstructionText": ('str',),
        "QGeoManeuver.setPosition": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoManeuver.setTimeToNextInstruction": ('int',),
        "QGeoManeuver.setWaypoint": ('PySide2.QtPositioning.QGeoCoordinate',),
        "QGeoManeuver.timeToNextInstruction": (),
        "QGeoManeuver.waypoint": (),

    # class PySide2.QtLocation.QGeoRoute:
        "QGeoRoute.__init__": [(), ('PySide2.QtLocation.QGeoRoute',)],
        "QGeoRoute.__copy__": (),
        "QGeoRoute.bounds": (),
        "QGeoRoute.distance": (),
        "QGeoRoute.firstRouteSegment": (),
        "QGeoRoute.path": (),
        "QGeoRoute.request": (),
        "QGeoRoute.routeId": (),
        "QGeoRoute.setBounds": ('PySide2.QtPositioning.QGeoRectangle',),
        "QGeoRoute.setDistance": ('float',),
        "QGeoRoute.setFirstRouteSegment": ('PySide2.QtLocation.QGeoRouteSegment',),
        "QGeoRoute.setPath": ('list',),
        "QGeoRoute.setRequest": ('PySide2.QtLocation.QGeoRouteRequest',),
        "QGeoRoute.setRouteId": ('str',),
        "QGeoRoute.setTravelMode": ('PySide2.QtLocation.QGeoRouteRequest.TravelMode',),
        "QGeoRoute.setTravelTime": ('int',),
        "QGeoRoute.travelMode": (),
        "QGeoRoute.travelTime": (),

    # class PySide2.QtLocation.QGeoRouteReply:
        "QGeoRouteReply.__init__": [('PySide2.QtLocation.QGeoRouteReply.Error', 'str', 'PySide2.QtCore.QObject'), ('PySide2.QtLocation.QGeoRouteRequest', 'PySide2.QtCore.QObject')],
        "QGeoRouteReply.abort": (),
        "QGeoRouteReply.addRoutes": ('list',),
        "QGeoRouteReply.error": (),
        "QGeoRouteReply.errorString": (),
        "QGeoRouteReply.isFinished": (),
        "QGeoRouteReply.request": (),
        "QGeoRouteReply.routes": (),
        "QGeoRouteReply.setError": ('PySide2.QtLocation.QGeoRouteReply.Error', 'str'),
        "QGeoRouteReply.setFinished": ('bool',),
        "QGeoRouteReply.setRoutes": ('list',),

    # class PySide2.QtLocation.QGeoRouteRequest:
        "QGeoRouteRequest.__init__": [('PySide2.QtLocation.QGeoRouteRequest',), ('PySide2.QtPositioning.QGeoCoordinate', 'PySide2.QtPositioning.QGeoCoordinate'), ('list',)],
        "QGeoRouteRequest.excludeAreas": (),
        "QGeoRouteRequest.extraParameters": (),
        "QGeoRouteRequest.featureTypes": (),
        "QGeoRouteRequest.featureWeight": ('PySide2.QtLocation.QGeoRouteRequest.FeatureType',),
        "QGeoRouteRequest.maneuverDetail": (),
        "QGeoRouteRequest.numberAlternativeRoutes": (),
        "QGeoRouteRequest.routeOptimization": (),
        "QGeoRouteRequest.segmentDetail": (),
        "QGeoRouteRequest.setExcludeAreas": ('list',),
        "QGeoRouteRequest.setExtraParameters": ('dict',),
        "QGeoRouteRequest.setFeatureWeight": ('PySide2.QtLocation.QGeoRouteRequest.FeatureType', 'PySide2.QtLocation.QGeoRouteRequest.FeatureWeight'),
        "QGeoRouteRequest.setManeuverDetail": ('PySide2.QtLocation.QGeoRouteRequest.ManeuverDetail',),
        "QGeoRouteRequest.setNumberAlternativeRoutes": ('int',),
        "QGeoRouteRequest.setRouteOptimization": ('PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations',),
        "QGeoRouteRequest.setSegmentDetail": ('PySide2.QtLocation.QGeoRouteRequest.SegmentDetail',),
        "QGeoRouteRequest.setTravelModes": ('PySide2.QtLocation.QGeoRouteRequest.TravelModes',),
        "QGeoRouteRequest.setWaypoints": ('list',),
        "QGeoRouteRequest.setWaypointsMetadata": ('list',),
        "QGeoRouteRequest.travelModes": (),
        "QGeoRouteRequest.waypoints": (),
        "QGeoRouteRequest.waypointsMetadata": (),

    # class PySide2.QtLocation.QGeoRouteSegment:
        "QGeoRouteSegment.__init__": [(), ('PySide2.QtLocation.QGeoRouteSegment',)],
        "QGeoRouteSegment.__copy__": (),
        "QGeoRouteSegment.distance": (),
        "QGeoRouteSegment.isLegLastSegment": (),
        "QGeoRouteSegment.isValid": (),
        "QGeoRouteSegment.maneuver": (),
        "QGeoRouteSegment.nextRouteSegment": (),
        "QGeoRouteSegment.path": (),
        "QGeoRouteSegment.setDistance": ('float',),
        "QGeoRouteSegment.setManeuver": ('PySide2.QtLocation.QGeoManeuver',),
        "QGeoRouteSegment.setNextRouteSegment": ('PySide2.QtLocation.QGeoRouteSegment',),
        "QGeoRouteSegment.setPath": ('list',),
        "QGeoRouteSegment.setTravelTime": ('int',),
        "QGeoRouteSegment.travelTime": (),

    # class PySide2.QtLocation.QGeoRoutingManager:
        "QGeoRoutingManager.calculateRoute": ('PySide2.QtLocation.QGeoRouteRequest',),
        "QGeoRoutingManager.locale": (),
        "QGeoRoutingManager.managerName": (),
        "QGeoRoutingManager.managerVersion": (),
        "QGeoRoutingManager.measurementSystem": (),
        "QGeoRoutingManager.setLocale": ('PySide2.QtCore.QLocale',),
        "QGeoRoutingManager.setMeasurementSystem": ('PySide2.QtCore.QLocale.MeasurementSystem',),
        "QGeoRoutingManager.supportedFeatureTypes": (),
        "QGeoRoutingManager.supportedFeatureWeights": (),
        "QGeoRoutingManager.supportedManeuverDetails": (),
        "QGeoRoutingManager.supportedRouteOptimizations": (),
        "QGeoRoutingManager.supportedSegmentDetails": (),
        "QGeoRoutingManager.supportedTravelModes": (),
        "QGeoRoutingManager.updateRoute": ('PySide2.QtLocation.QGeoRoute', 'PySide2.QtPositioning.QGeoCoordinate'),

    # class PySide2.QtLocation.QGeoRoutingManagerEngine:
        "QGeoRoutingManagerEngine.__init__": ('dict', 'PySide2.QtCore.QObject'),
        "QGeoRoutingManagerEngine.calculateRoute": ('PySide2.QtLocation.QGeoRouteRequest',),
        "QGeoRoutingManagerEngine.locale": (),
        "QGeoRoutingManagerEngine.managerName": (),
        "QGeoRoutingManagerEngine.managerVersion": (),
        "QGeoRoutingManagerEngine.measurementSystem": (),
        "QGeoRoutingManagerEngine.setLocale": ('PySide2.QtCore.QLocale',),
        "QGeoRoutingManagerEngine.setMeasurementSystem": ('PySide2.QtCore.QLocale.MeasurementSystem',),
        "QGeoRoutingManagerEngine.setSupportedFeatureTypes": ('PySide2.QtLocation.QGeoRouteRequest.FeatureTypes',),
        "QGeoRoutingManagerEngine.setSupportedFeatureWeights": ('PySide2.QtLocation.QGeoRouteRequest.FeatureWeights',),
        "QGeoRoutingManagerEngine.setSupportedManeuverDetails": ('PySide2.QtLocation.QGeoRouteRequest.ManeuverDetails',),
        "QGeoRoutingManagerEngine.setSupportedRouteOptimizations": ('PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations',),
        "QGeoRoutingManagerEngine.setSupportedSegmentDetails": ('PySide2.QtLocation.QGeoRouteRequest.SegmentDetails',),
        "QGeoRoutingManagerEngine.setSupportedTravelModes": ('PySide2.QtLocation.QGeoRouteRequest.TravelModes',),
        "QGeoRoutingManagerEngine.supportedFeatureTypes": (),
        "QGeoRoutingManagerEngine.supportedFeatureWeights": (),
        "QGeoRoutingManagerEngine.supportedManeuverDetails": (),
        "QGeoRoutingManagerEngine.supportedRouteOptimizations": (),
        "QGeoRoutingManagerEngine.supportedSegmentDetails": (),
        "QGeoRoutingManagerEngine.supportedTravelModes": (),
        "QGeoRoutingManagerEngine.updateRoute": ('PySide2.QtLocation.QGeoRoute', 'PySide2.QtPositioning.QGeoCoordinate'),

    # class PySide2.QtLocation.QGeoServiceProvider:
        "QGeoServiceProvider.__init__": ('str', 'dict', 'bool'),
        "QGeoServiceProvider.availableServiceProviders": (),
        "QGeoServiceProvider.error": (),
        "QGeoServiceProvider.errorString": (),
        "QGeoServiceProvider.geocodingFeatures": (),
        "QGeoServiceProvider.geocodingManager": (),
        "QGeoServiceProvider.mappingFeatures": (),
        "QGeoServiceProvider.navigationFeatures": (),
        "QGeoServiceProvider.placeManager": (),
        "QGeoServiceProvider.placesFeatures": (),
        "QGeoServiceProvider.routingFeatures": (),
        "QGeoServiceProvider.routingManager": (),
        "QGeoServiceProvider.setAllowExperimental": ('bool',),
        "QGeoServiceProvider.setLocale": ('PySide2.QtCore.QLocale',),
        "QGeoServiceProvider.setParameters": ('dict',),

    # class PySide2.QtLocation.QGeoServiceProviderFactory:
        "QGeoServiceProviderFactory.__init__": (),
        "QGeoServiceProviderFactory.createGeocodingManagerEngine": ('dict', 'PySide2.QtLocation.QGeoServiceProvider.Error', 'str'),
        "QGeoServiceProviderFactory.createPlaceManagerEngine": ('dict', 'PySide2.QtLocation.QGeoServiceProvider.Error', 'str'),
        "QGeoServiceProviderFactory.createRoutingManagerEngine": ('dict', 'PySide2.QtLocation.QGeoServiceProvider.Error', 'str'),

    # class PySide2.QtLocation.QGeoServiceProviderFactoryV2:
        "QGeoServiceProviderFactoryV2.__init__": (),

    # class PySide2.QtLocation.QPlace:
        "QPlace.__init__": [(), ('PySide2.QtLocation.QPlace',)],
        "QPlace.__copy__": (),
        "QPlace.appendContactDetail": ('str', 'PySide2.QtLocation.QPlaceContactDetail'),
        "QPlace.attribution": (),
        "QPlace.categories": (),
        "QPlace.contactDetails": ('str',),
        "QPlace.contactTypes": (),
        "QPlace.content": ('PySide2.QtLocation.QPlaceContent.Type',),
        "QPlace.detailsFetched": (),
        "QPlace.extendedAttribute": ('str',),
        "QPlace.extendedAttributeTypes": (),
        "QPlace.icon": (),
        "QPlace.insertContent": ('PySide2.QtLocation.QPlaceContent.Type', 'dict'),
        "QPlace.isEmpty": (),
        "QPlace.location": (),
        "QPlace.name": (),
        "QPlace.placeId": (),
        "QPlace.primaryEmail": (),
        "QPlace.primaryFax": (),
        "QPlace.primaryPhone": (),
        "QPlace.primaryWebsite": (),
        "QPlace.ratings": (),
        "QPlace.removeContactDetails": ('str',),
        "QPlace.removeExtendedAttribute": ('str',),
        "QPlace.setAttribution": ('str',),
        "QPlace.setCategories": ('list',),
        "QPlace.setCategory": ('PySide2.QtLocation.QPlaceCategory',),
        "QPlace.setContactDetails": ('str', 'list'),
        "QPlace.setContent": ('PySide2.QtLocation.QPlaceContent.Type', 'dict'),
        "QPlace.setDetailsFetched": ('bool',),
        "QPlace.setExtendedAttribute": ('str', 'PySide2.QtLocation.QPlaceAttribute'),
        "QPlace.setIcon": ('PySide2.QtLocation.QPlaceIcon',),
        "QPlace.setLocation": ('PySide2.QtPositioning.QGeoLocation',),
        "QPlace.setName": ('str',),
        "QPlace.setPlaceId": ('str',),
        "QPlace.setRatings": ('PySide2.QtLocation.QPlaceRatings',),
        "QPlace.setSupplier": ('PySide2.QtLocation.QPlaceSupplier',),
        "QPlace.setTotalContentCount": ('PySide2.QtLocation.QPlaceContent.Type', 'int'),
        "QPlace.supplier": (),
        "QPlace.totalContentCount": ('PySide2.QtLocation.QPlaceContent.Type',),

    # class PySide2.QtLocation.QPlaceAttribute:
        "QPlaceAttribute.__init__": [(), ('PySide2.QtLocation.QPlaceAttribute',)],
        "QPlaceAttribute.__copy__": (),
        "QPlaceAttribute.isEmpty": (),
        "QPlaceAttribute.label": (),
        "QPlaceAttribute.setLabel": ('str',),
        "QPlaceAttribute.setText": ('str',),
        "QPlaceAttribute.text": (),

    # class PySide2.QtLocation.QPlaceCategory:
        "QPlaceCategory.__init__": [(), ('PySide2.QtLocation.QPlaceCategory',)],
        "QPlaceCategory.__copy__": (),
        "QPlaceCategory.categoryId": (),
        "QPlaceCategory.icon": (),
        "QPlaceCategory.isEmpty": (),
        "QPlaceCategory.name": (),
        "QPlaceCategory.setCategoryId": ('str',),
        "QPlaceCategory.setIcon": ('PySide2.QtLocation.QPlaceIcon',),
        "QPlaceCategory.setName": ('str',),

    # class PySide2.QtLocation.QPlaceContactDetail:
        "QPlaceContactDetail.__init__": [(), ('PySide2.QtLocation.QPlaceContactDetail',)],
        "QPlaceContactDetail.__copy__": (),
        "QPlaceContactDetail.clear": (),
        "QPlaceContactDetail.label": (),
        "QPlaceContactDetail