// Copyright (C) 2019 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

import QtQuick 2.0

ListModel {
    ListElement {
        projectName: "ClusterTutorial"
        qmlFileName: "ClusterTutorial.qml"
        thumbnail: "images/tutorialclusterdemo_thumbnail.png"
        displayName: "Cluster Tutorial"
    }

    ListElement {
        projectName: "CoffeeMachine"
        qmlFileName: "CoffeeMachine.qml"
        thumbnail: "images/coffeemachinedemo_thumbnail.png"
        displayName: "Coffee Machine"
    }

    ListElement {
        projectName: "SideMenu"
        qmlFileName: "SideMenu.qml"
        thumbnail: "images/sidemenu_demo.png"
        displayName: "Side Menu"
    }

    ListElement {
        projectName: "WebinarDemo"
        qmlFileName: "DesignStudioWebinar.qml"
        thumbnail: "images/webinardemo_thumbnail.png"
        displayName: "Webinar Demo"
    }

    ListElement {
        projectName: "EBikeDesign"
        qmlFileName: "EBikeDesign.qml"
        thumbnail: "images/ebike_demo_thumbnail.png"
        displayName: "E-Bike Design"
    }

    ListElement {
        projectName: "ProgressBar"
        qmlFileName: "ProgressBar.ui.qml"
        thumbnail: "images/progressbar_demo.png"
        displayName: "Progress Bar"
    }

    ListElement {
        projectName: "washingMachineUI"
        qmlFileName: "washingMachineUI.qml"
        thumbnail: "images/washingmachinedemo_thumbnail.png"
        displayName: "Washing Machine"
    }

    ListElement {
        projectName: "SimpleKeyboard"
        qmlFileName: "SimpleKeyboard.qml"
        thumbnail: "images/virtualkeyboard_thumbnail.png"
        displayName: "Virtual Keyboard"
    }

    ListElement {
        projectName: "highendivisystem"
        qmlFileName: "Screen01.ui.qml"
        thumbnail: "images/highendivi_thumbnail.png"
        displayName: "Highend IVI System"
        url: "https://download.qt.io/learning/examples/qtdesignstudio/highendivisystem.zip"
        showDownload: true
    }

    ListElement {
        projectName: "digitalcluster"
        qmlFileName: "Screen01.ui.qml"
        thumbnail: "images/digital_cluster_thumbnail.png"
        displayName: "Digital Cluster"
        url: "https://download.qt.io/learning/examples/qtdesignstudio/digitalcluster.zip"
        showDownload: true
    }

    ListElement {
        projectName: "effectdemo"
        qmlFileName: "Screen01.ui.qml"
        thumbnail: "images/effectdemo_thumbnail.png"
        displayName: "Effect Demo"
        url: "https://download.qt.io/learning/examples/qtdesignstudio/effectdemo.zip"
        showDownload: true
    }


    ListElement {
        projectName: "cppdemoproject"
        explicitQmlproject: "qml/qdsproject.qmlproject"
        qmlFileName: "Screen01.ui.qml"
        thumbnail: "images/cppdemo_thumbnail.png"
        displayName: "C++ Demo Project"
        url: "https://download.qt.io/learning/examples/qtdesignstudio/cppdemoproject.zip"
        showDownload: true
    }
}
