/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

public class StringIntMap {
    protected Entry[] table;
    protected int count;

    public StringIntMap(int n) {
        this.table = new Entry[(n * 3 >>> 2) + 1];
    }

    public int get(String string) {
        int n = string.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(string)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return -1;
    }

    public void put(String string, int n) {
        Entry entry;
        int n2 = string.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry2 = this.table[n3];
        while (entry2 != null) {
            if (entry2.hash == n2 && entry2.key.equals(string)) {
                entry2.value = n;
                return;
            }
            entry2 = entry2.next;
        }
        int n4 = this.table.length;
        if (this.count++ >= n4 * 3 >>> 2) {
            this.rehash();
            n3 = n2 % this.table.length;
        }
        this.table[n3] = entry = new Entry(n2, string, n, this.table[n3]);
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        int n = entryArray.length - 1;
        while (n >= 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = entry2.hash % this.table.length;
                entry2.next = this.table[n2];
                this.table[n2] = entry2;
            }
            --n;
        }
    }

    protected static class Entry {
        public int hash;
        public String key;
        public int value;
        public Entry next;

        public Entry(int n, String string, int n2, Entry entry) {
            this.hash = n;
            this.key = string;
            this.value = n2;
            this.next = entry;
        }
    }
}

